% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BigVAR.R
\docType{package}
\name{BigVAR}
\alias{BigVAR}
\alias{BigVAR-package}
\title{Dimension Reduction Methods for Multivariate Time Series.}
\description{
BigVAR implements the HVAR and VARX-L frameworks which allow for the estimation of vector autoregressions and vector autoregressions with exogenous variables using structured convex penalties.  This package originated as a 2014 Google "Summer of Code" Project.  The development version of this package is hosted on github: \url{http://www.github.com/wbnicholson/BigVAR}.
}
\details{
To use the facilities of this package, starting with an \eqn{T \times k+m} multivariate time series (in which T denotes the length of the series, k the number of endogenous or "model") and run \code{\link{constructModel}} to create an object of class \code{\link{BigVAR}}.  \code{\link{cv.BigVAR}} creates an object of class \code{\link{BigVAR.results}}, which chooses an optimal penalty parameter based on minimizing h-step ahead forecasts on a specified cross-validation period over a grid of values as well as comparisons against AIC, BIC, unconditional mean, and a random walk.  There are plot functions for both BigVAR (\code{\link{plot.BigVAR}}) and BigVAR.results (\code{\link{plot}}) as well as a predict function for BigVAR.results (\code{\link{predict}}).
}
\examples{
# Fit a Basic VAR-L(3,4) on simulated data
data(Y)
T1=floor(nrow(Y)/3)
T2=floor(2*nrow(Y)/3)
m1=constructModel(Y,p=4,struct="Basic",gran=c(50,10),verbose=FALSE,T1=T1,T2=T2,IC=FALSE)
plot(m1)
results=cv.BigVAR(m1)
plot(results)
predict(results,n.ahead=1)
}
\references{
Lutkepohl "New Introduction to Multivariate Time Series",
William B Nicholson, Jacob Bien, and David S Matteson. "High Dimensional Forecasting via Interpretable Vector Autoregression." arXiv preprint arXiv:1412.5250, 2016.
William B Nicholson, David S. Matteson, and Jacob Bien (2015), "VARX-L Structured regularization for large vector
autoregressions with exogenous variables," arXiv preprint arXiv:1508.07497, 2016..
William B Nicholson, David S. Matteson, and Jacob Bien (2016), "BigVAR: Dimension Reduction Reduction Methods for Multivariate Time Series," \url{http://www.wbnicholson.com/BigVAR.pdf}.
}
\seealso{
\code{\link{constructModel}}, \code{\link{cv.BigVAR}}, \code{\link{BigVAR.results}}, \code{\link{plot}}, \code{\link{predict}}
}
\author{
Will Nicholson \email{wbn8@cornell.edu},
}
