% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{vcftobd}
\alias{vcftobd}
\title{Convert a VCF file to a binary dosage file}
\usage{
vcftobd(
  vcffiles,
  gz = FALSE,
  bdfiles,
  format = 4L,
  subformat = 0L,
  snpidformat = 0,
  bdoptions = character(0)
)
}
\arguments{
\item{vcffiles}{A vector of file names.
The first is the name of the vcf file. The
second is name of the file that contains information
about the imputation of the SNPs. This file is produced
by minimac 3 and 4.}

\item{gz}{Indicator if VCF file is compressed using gzip.
Default value is FALSE.}

\item{bdfiles}{Vector of names of the output files.
The binary dosage file name is first. The family and
map files follow. For format 4, no family and map file
names are needed.}

\item{format}{The format of the output binary dosage file.
Allowed values are 1, 2, 3, and 4. The default value is 4.
Using the default value is recommended.}

\item{subformat}{The subformat of the format of the output
binary dosage file. A value of 1 or 3 indicates that only the
dosage value is saved. A value of 2 or 4 indicates
the dosage and genetic probabilities will be output. Values
of 3 or 4 are only allowed with formats 3 and 4. If a value
of zero if provided, and genetic probabilities are in the vcf
file, subformat 2 will be used for formats 1 and 2, and
subformat 4 will be used for formats 3 and 4. If the vcf file
does not contain genetic probabilities, subformat 1 will be
used for formats 1 and 2, and subformat 3 will be used for
formats 3 and 4. The default value is 0.}

\item{snpidformat}{The format that the SNP ID will be saved as.
-1 SNP ID not written
0 - same as in the VCF file
1 - chromosome:location
2 - chromosome:location:reference_allele:alternate_allele
If snpidformat is 1 and the VCF file uses format 2, an error is
generated. Default value is 0.}

\item{bdoptions}{Character array containing any of the following
value, "aaf", "maf", "rsq". The presence of any of these
values indicates that the specified values should be
calculates and stored in the binary dosage file. These values only
apply to format 4.}
}
\value{
None
}
\description{
Routine to read information from a VCF file and create
a binary dosage file. The function is designed to use
files return from the Michigan Imputation Server but will
run on other VCF files if they contain dosage and genetic
probabilities. Note: This routine can take a long time to
run if the VCF file is large.
}
\examples{
# Find the vcf file names
vcf1afile <- system.file("extdata", "set1a.vcf", package = "BinaryDosage")
vcf1ainfo <- system.file("extdata", "set1a.info", package = "BinaryDosage")
bdfiles <- tempfile()
# Convert the file
vcftobd(vcffiles = c(vcf1afile, vcf1ainfo), bdfiles = bdfiles)
# Verify the file was written correctly
bdinfo <- getbdinfo(bdfiles)
}
