# Whole workflow works consistently

    Code
      set.seed(42)
      gridding(meta, btf) %>% resampling(measure = "ABUNDANCE", resamps = 1L) %>%
        getBetaMetrics(measure = "ABUNDANCE") %>% getLinearRegressions(divType = "beta")
    Message
      OK: all SL studies have 1 grid cell
    Output
           YEAR assemblageID           metric dissimilarity         slope
      1    1984    10_358678      JaccardDiss  1.818182e-01  9.199134e-03
      2    1984    10_358678 MorisitaHornDiss  1.969240e-03  1.008993e-03
      3    1984    10_358678   BrayCurtisDiss  2.197115e-01 -4.899627e-03
      4    1992    10_358678      JaccardDiss  3.333333e-01  9.199134e-03
      5    1992    10_358678 MorisitaHornDiss  1.257756e-02  1.008993e-03
      6    1992    10_358678   BrayCurtisDiss  2.558140e-01 -4.899627e-03
      7    1996    10_358678      JaccardDiss  2.727273e-01  9.199134e-03
      8    1996    10_358678 MorisitaHornDiss  1.344306e-02  1.008993e-03
      9    1996    10_358678   BrayCurtisDiss  1.420912e-01 -4.899627e-03
      10   1945    18_335239      JaccardDiss  6.739130e-01  1.274780e-03
      11   1945    18_335239 MorisitaHornDiss  6.029562e-01  1.606513e-03
      12   1945    18_335239   BrayCurtisDiss  7.264151e-01  4.699316e-04
      13   1933    18_335239      JaccardDiss  4.666667e-01  1.274780e-03
      14   1933    18_335239 MorisitaHornDiss  2.604879e-01  1.606513e-03
      15   1933    18_335239   BrayCurtisDiss  5.443182e-01  4.699316e-04
      16   1935    18_335239      JaccardDiss  3.636364e-01  1.274780e-03
      17   1935    18_335239 MorisitaHornDiss  3.224528e-01  1.606513e-03
      18   1935    18_335239   BrayCurtisDiss  4.712644e-01  4.699316e-04
      19   1936    18_335239      JaccardDiss  5.121951e-01  1.274780e-03
      20   1936    18_335239 MorisitaHornDiss  3.352489e-01  1.606513e-03
      21   1936    18_335239   BrayCurtisDiss  5.493934e-01  4.699316e-04
      22   1937    18_335239      JaccardDiss  2.926829e-01  1.274780e-03
      23   1937    18_335239 MorisitaHornDiss  1.165808e-01  1.606513e-03
      24   1937    18_335239   BrayCurtisDiss  2.973227e-01  4.699316e-04
      25   1940    18_335239      JaccardDiss  6.000000e-01  1.274780e-03
      26   1940    18_335239 MorisitaHornDiss  7.540253e-02  1.606513e-03
      27   1940    18_335239   BrayCurtisDiss  5.945946e-01  4.699316e-04
      28   1954    18_335239      JaccardDiss  5.121951e-01  1.274780e-03
      29   1954    18_335239 MorisitaHornDiss  1.031311e-01  1.606513e-03
      30   1954    18_335239   BrayCurtisDiss  3.590010e-01  4.699316e-04
      31   1950    18_335239      JaccardDiss  4.418605e-01  1.274780e-03
      32   1950    18_335239 MorisitaHornDiss  9.847590e-02  1.606513e-03
      33   1950    18_335239   BrayCurtisDiss  3.209494e-01  4.699316e-04
      34   1955    18_335239      JaccardDiss  6.222222e-01  1.274780e-03
      35   1955    18_335239 MorisitaHornDiss  3.559309e-01  1.606513e-03
      36   1955    18_335239   BrayCurtisDiss  7.181467e-01  4.699316e-04
      37   1973    18_335239      JaccardDiss  6.046512e-01  1.274780e-03
      38   1973    18_335239 MorisitaHornDiss  2.194598e-01  1.606513e-03
      39   1973    18_335239   BrayCurtisDiss  6.995487e-01  4.699316e-04
      40   1923    18_335239      JaccardDiss  5.714286e-01  1.274780e-03
      41   1923    18_335239 MorisitaHornDiss  2.350433e-01  1.606513e-03
      42   1923    18_335239   BrayCurtisDiss  7.049834e-01  4.699316e-04
      43   1926    18_335239      JaccardDiss  6.666667e-01  1.274780e-03
      44   1926    18_335239 MorisitaHornDiss  3.281649e-01  1.606513e-03
      45   1926    18_335239   BrayCurtisDiss  7.561317e-01  4.699316e-04
      46   1927    18_335239      JaccardDiss  6.590909e-01  1.274780e-03
      47   1927    18_335239 MorisitaHornDiss  3.262905e-01  1.606513e-03
      48   1927    18_335239   BrayCurtisDiss  6.109694e-01  4.699316e-04
      49   1929    18_335239      JaccardDiss  5.000000e-01  1.274780e-03
      50   1929    18_335239 MorisitaHornDiss  1.737435e-01  1.606513e-03
      51   1929    18_335239   BrayCurtisDiss  5.180288e-01  4.699316e-04
      52   1930    18_335239      JaccardDiss  5.641026e-01  1.274780e-03
      53   1930    18_335239 MorisitaHornDiss  1.010028e-01  1.606513e-03
      54   1930    18_335239   BrayCurtisDiss  6.597455e-01  4.699316e-04
      55   1932    18_335239      JaccardDiss  5.384615e-01  1.274780e-03
      56   1932    18_335239 MorisitaHornDiss  3.920189e-01  1.606513e-03
      57   1932    18_335239   BrayCurtisDiss  6.890117e-01  4.699316e-04
      58   1934    18_335239      JaccardDiss  4.324324e-01  1.274780e-03
      59   1934    18_335239 MorisitaHornDiss  1.099035e-01  1.606513e-03
      60   1934    18_335239   BrayCurtisDiss  5.047281e-01  4.699316e-04
      61   1938    18_335239      JaccardDiss  2.972973e-01  1.274780e-03
      62   1938    18_335239 MorisitaHornDiss  1.050475e-01  1.606513e-03
      63   1938    18_335239   BrayCurtisDiss  3.372845e-01  4.699316e-04
      64   1939    18_335239      JaccardDiss  3.750000e-01  1.274780e-03
      65   1939    18_335239 MorisitaHornDiss  1.396192e-01  1.606513e-03
      66   1939    18_335239   BrayCurtisDiss  3.241314e-01  4.699316e-04
      67   1941    18_335239      JaccardDiss  3.500000e-01  1.274780e-03
      68   1941    18_335239 MorisitaHornDiss  2.563309e-01  1.606513e-03
      69   1941    18_335239   BrayCurtisDiss  3.839698e-01  4.699316e-04
      70   1942    18_335239      JaccardDiss  3.170732e-01  1.274780e-03
      71   1942    18_335239 MorisitaHornDiss  1.559703e-01  1.606513e-03
      72   1942    18_335239   BrayCurtisDiss  2.826970e-01  4.699316e-04
      73   1946    18_335239      JaccardDiss  4.615385e-01  1.274780e-03
      74   1946    18_335239 MorisitaHornDiss  1.463880e-01  1.606513e-03
      75   1946    18_335239   BrayCurtisDiss  4.295011e-01  4.699316e-04
      76   1949    18_335239      JaccardDiss  3.846154e-01  1.274780e-03
      77   1949    18_335239 MorisitaHornDiss  1.424235e-01  1.606513e-03
      78   1949    18_335239   BrayCurtisDiss  4.145553e-01  4.699316e-04
      79   1951    18_335239      JaccardDiss  5.714286e-01  1.274780e-03
      80   1951    18_335239 MorisitaHornDiss  2.168495e-01  1.606513e-03
      81   1951    18_335239   BrayCurtisDiss  5.813084e-01  4.699316e-04
      82   1952    18_335239      JaccardDiss  5.238095e-01  1.274780e-03
      83   1952    18_335239 MorisitaHornDiss  2.791757e-01  1.606513e-03
      84   1952    18_335239   BrayCurtisDiss  6.600129e-01  4.699316e-04
      85   1956    18_335239      JaccardDiss  6.052632e-01  1.274780e-03
      86   1956    18_335239 MorisitaHornDiss  3.139674e-01  1.606513e-03
      87   1956    18_335239   BrayCurtisDiss  5.749354e-01  4.699316e-04
      88   1931    18_335239      JaccardDiss  5.128205e-01  1.274780e-03
      89   1931    18_335239 MorisitaHornDiss  7.600243e-02  1.606513e-03
      90   1931    18_335239   BrayCurtisDiss  3.568753e-01  4.699316e-04
      91   1947    18_335239      JaccardDiss  6.097561e-01  1.274780e-03
      92   1947    18_335239 MorisitaHornDiss  2.372588e-01  1.606513e-03
      93   1947    18_335239   BrayCurtisDiss  6.709030e-01  4.699316e-04
      94   1957    18_335239      JaccardDiss  6.000000e-01  1.274780e-03
      95   1957    18_335239 MorisitaHornDiss  5.720909e-01  1.606513e-03
      96   1957    18_335239   BrayCurtisDiss  6.360153e-01  4.699316e-04
      97   1923    41_452736      JaccardDiss  1.224490e-01  7.420661e-03
      98   1923    41_452736 MorisitaHornDiss  9.254352e-02  1.166606e-02
      99   1923    41_452736   BrayCurtisDiss  1.916376e-01  8.008083e-03
      100  1924    41_452736      JaccardDiss  2.600000e-01  7.420661e-03
      101  1924    41_452736 MorisitaHornDiss  1.268351e-01  1.166606e-02
      102  1924    41_452736   BrayCurtisDiss  2.436364e-01  8.008083e-03
      103  1926    41_452736      JaccardDiss  1.875000e-01  7.420661e-03
      104  1926    41_452736 MorisitaHornDiss  1.170597e-01  1.166606e-02
      105  1926    41_452736   BrayCurtisDiss  2.690763e-01  8.008083e-03
      106  1927    41_452736      JaccardDiss  2.448980e-01  7.420661e-03
      107  1927    41_452736 MorisitaHornDiss  1.161156e-01  1.166606e-02
      108  1927    41_452736   BrayCurtisDiss  3.025210e-01  8.008083e-03
      109  1930    41_452736      JaccardDiss  2.600000e-01  7.420661e-03
      110  1930    41_452736 MorisitaHornDiss  2.145213e-01  1.166606e-02
      111  1930    41_452736   BrayCurtisDiss  3.495935e-01  8.008083e-03
      112  1931    41_452736      JaccardDiss  2.884615e-01  7.420661e-03
      113  1931    41_452736 MorisitaHornDiss  2.877664e-01  1.166606e-02
      114  1931    41_452736   BrayCurtisDiss  3.974895e-01  8.008083e-03
      115  1936    41_452736      JaccardDiss  2.708333e-01  7.420661e-03
      116  1936    41_452736 MorisitaHornDiss  3.239312e-01  1.166606e-02
      117  1936    41_452736   BrayCurtisDiss  3.924051e-01  8.008083e-03
      118  1937    41_452736      JaccardDiss  3.148148e-01  7.420661e-03
      119  1937    41_452736 MorisitaHornDiss  3.327702e-01  1.166606e-02
      120  1937    41_452736   BrayCurtisDiss  4.144487e-01  8.008083e-03
      121  1938    41_452736      JaccardDiss  3.529412e-01  7.420661e-03
      122  1938    41_452736 MorisitaHornDiss  3.510086e-01  1.166606e-02
      123  1938    41_452736   BrayCurtisDiss  4.150198e-01  8.008083e-03
      124  1940    41_452736      JaccardDiss  2.600000e-01  7.420661e-03
      125  1940    41_452736 MorisitaHornDiss  1.413000e-01  1.166606e-02
      126  1940    41_452736   BrayCurtisDiss  2.446043e-01  8.008083e-03
      127  1966    53_393795      JaccardDiss  4.285714e-01 -2.715858e-02
      128  1966    53_393795 MorisitaHornDiss  3.499768e-01 -1.748095e-02
      129  1966    53_393795   BrayCurtisDiss  4.277539e-01 -5.578685e-03
      130  1967    53_393795      JaccardDiss  3.800000e-01 -2.715858e-02
      131  1967    53_393795 MorisitaHornDiss  3.112680e-01 -1.748095e-02
      132  1967    53_393795   BrayCurtisDiss  5.632184e-01 -5.578685e-03
      133  1968    53_393795      JaccardDiss  3.529412e-01 -2.715858e-02
      134  1968    53_393795 MorisitaHornDiss  3.190303e-01 -1.748095e-02
      135  1968    53_393795   BrayCurtisDiss  3.684211e-01 -5.578685e-03
      136  1970    53_393795      JaccardDiss  3.910256e-01 -2.715858e-02
      137  1970    53_393795 MorisitaHornDiss  3.304827e-01 -1.748095e-02
      138  1970    53_393795   BrayCurtisDiss  3.781250e-01 -5.578685e-03
      139  1971    53_393795      JaccardDiss  5.000000e-01 -2.715858e-02
      140  1971    53_393795 MorisitaHornDiss  2.128460e-01 -1.748095e-02
      141  1971    53_393795   BrayCurtisDiss  5.041322e-01 -5.578685e-03
      142  1974    53_393795      JaccardDiss  2.307692e-01 -2.715858e-02
      143  1974    53_393795 MorisitaHornDiss  2.519492e-01 -1.748095e-02
      144  1974    53_393795   BrayCurtisDiss  3.293413e-01 -5.578685e-03
      145  1975    53_393795      JaccardDiss  0.000000e+00 -2.715858e-02
      146  1975    53_393795 MorisitaHornDiss  5.391696e-02 -1.748095e-02
      147  1975    53_393795   BrayCurtisDiss  3.684211e-01 -5.578685e-03
      148  1976    53_393795      JaccardDiss  3.235294e-01 -2.715858e-02
      149  1976    53_393795 MorisitaHornDiss  3.363594e-01 -1.748095e-02
      150  1976    53_393795   BrayCurtisDiss  5.265700e-01 -5.578685e-03
      151  1969    53_393795      JaccardDiss  5.714286e-01 -2.715858e-02
      152  1969    53_393795 MorisitaHornDiss  3.493203e-01 -1.748095e-02
      153  1969    53_393795   BrayCurtisDiss  5.868545e-01 -5.578685e-03
      154  1973    53_393795      JaccardDiss  3.191489e-01 -2.715858e-02
      155  1973    53_393795 MorisitaHornDiss  8.222285e-02 -1.748095e-02
      156  1973    53_393795   BrayCurtisDiss  4.482759e-01 -5.578685e-03
      157  1985    59_470015      JaccardDiss  2.142857e-01 -1.727384e-03
      158  1985    59_470015 MorisitaHornDiss  3.655128e-02 -2.332364e-03
      159  1985    59_470015   BrayCurtisDiss  3.947368e-01 -4.292601e-03
      160  1989    59_470015      JaccardDiss  5.333333e-01 -1.727384e-03
      161  1989    59_470015 MorisitaHornDiss  7.168714e-02 -2.332364e-03
      162  1989    59_470015   BrayCurtisDiss  3.253012e-01 -4.292601e-03
      163  1990    59_470015      JaccardDiss  4.615385e-01 -1.727384e-03
      164  1990    59_470015 MorisitaHornDiss  1.120332e-01 -2.332364e-03
      165  1990    59_470015   BrayCurtisDiss  3.991031e-01 -4.292601e-03
      166  1991    59_470015      JaccardDiss  4.666667e-01 -1.727384e-03
      167  1991    59_470015 MorisitaHornDiss  1.074937e-01 -2.332364e-03
      168  1991    59_470015   BrayCurtisDiss  4.513274e-01 -4.292601e-03
      169  1992    59_470015      JaccardDiss  5.000000e-01 -1.727384e-03
      170  1992    59_470015 MorisitaHornDiss  1.235927e-01 -2.332364e-03
      171  1992    59_470015   BrayCurtisDiss  3.307087e-01 -4.292601e-03
      172  1993    59_470015      JaccardDiss  7.142857e-01 -1.727384e-03
      173  1993    59_470015 MorisitaHornDiss  1.522181e-01 -2.332364e-03
      174  1993    59_470015   BrayCurtisDiss  3.974895e-01 -4.292601e-03
      175  1995    59_470015      JaccardDiss  5.882353e-01 -1.727384e-03
      176  1995    59_470015 MorisitaHornDiss  9.468756e-02 -2.332364e-03
      177  1995    59_470015   BrayCurtisDiss  3.399340e-01 -4.292601e-03
      178  1997    59_470015      JaccardDiss  4.375000e-01 -1.727384e-03
      179  1997    59_470015 MorisitaHornDiss  7.398826e-02 -2.332364e-03
      180  1997    59_470015   BrayCurtisDiss  3.037975e-01 -4.292601e-03
      181  1998    59_470015      JaccardDiss  6.923077e-01 -1.727384e-03
      182  1998    59_470015 MorisitaHornDiss  1.207143e-01 -2.332364e-03
      183  1998    59_470015   BrayCurtisDiss  6.858639e-01 -4.292601e-03
      184  1999    59_470015      JaccardDiss  4.375000e-01 -1.727384e-03
      185  1999    59_470015 MorisitaHornDiss  1.057817e-01 -2.332364e-03
      186  1999    59_470015   BrayCurtisDiss  3.791045e-01 -4.292601e-03
      187  2001    59_470015      JaccardDiss  4.705882e-01 -1.727384e-03
      188  2001    59_470015 MorisitaHornDiss  1.092753e-01 -2.332364e-03
      189  2001    59_470015   BrayCurtisDiss  3.519553e-01 -4.292601e-03
      190  2002    59_470015      JaccardDiss  1.428571e-01 -1.727384e-03
      191  2002    59_470015 MorisitaHornDiss  3.557374e-02 -2.332364e-03
      192  2002    59_470015   BrayCurtisDiss  1.846690e-01 -4.292601e-03
      193  1986    59_470015      JaccardDiss  4.210526e-01 -1.727384e-03
      194  1986    59_470015 MorisitaHornDiss  4.281654e-02 -2.332364e-03
      195  1986    59_470015   BrayCurtisDiss  2.418301e-01 -4.292601e-03
      196  1988    59_470015      JaccardDiss  4.375000e-01 -1.727384e-03
      197  1988    59_470015 MorisitaHornDiss  7.792642e-02 -2.332364e-03
      198  1988    59_470015   BrayCurtisDiss  5.022222e-01 -4.292601e-03
      199  1987    59_470015      JaccardDiss  7.333333e-01 -1.727384e-03
      200  1987    59_470015 MorisitaHornDiss  4.310268e-01 -2.332364e-03
      201  1987    59_470015   BrayCurtisDiss  7.030568e-01 -4.292601e-03
      202  2000    59_470015      JaccardDiss  3.750000e-01 -1.727384e-03
      203  2000    59_470015 MorisitaHornDiss  4.281962e-02 -2.332364e-03
      204  2000    59_470015   BrayCurtisDiss  3.333333e-01 -4.292601e-03
      205  1984    59_470015      JaccardDiss  6.428571e-01 -1.727384e-03
      206  1984    59_470015 MorisitaHornDiss  2.465441e-01 -2.332364e-03
      207  1984    59_470015   BrayCurtisDiss  7.578947e-01 -4.292601e-03
      208  1977    59_470015      JaccardDiss  4.666667e-01 -1.727384e-03
      209  1977    59_470015 MorisitaHornDiss  1.503363e-01 -2.332364e-03
      210  1977    59_470015   BrayCurtisDiss  4.296029e-01 -4.292601e-03
      211  1978    59_470015      JaccardDiss  3.846154e-01 -1.727384e-03
      212  1978    59_470015 MorisitaHornDiss  1.324767e-01 -2.332364e-03
      213  1978    59_470015   BrayCurtisDiss  4.552846e-01 -4.292601e-03
      214  1979    59_470015      JaccardDiss  4.285714e-01 -1.727384e-03
      215  1979    59_470015 MorisitaHornDiss  1.058048e-01 -2.332364e-03
      216  1979    59_470015   BrayCurtisDiss  3.425606e-01 -4.292601e-03
      217  1980    59_470015      JaccardDiss  4.666667e-01 -1.727384e-03
      218  1980    59_470015 MorisitaHornDiss  7.849689e-02 -2.332364e-03
      219  1980    59_470015   BrayCurtisDiss  4.710744e-01 -4.292601e-03
      220  1981    59_470015      JaccardDiss  3.125000e-01 -1.727384e-03
      221  1981    59_470015 MorisitaHornDiss  5.870083e-02 -2.332364e-03
      222  1981    59_470015   BrayCurtisDiss  2.906667e-01 -4.292601e-03
      223  1982    59_470015      JaccardDiss  5.000000e-01 -1.727384e-03
      224  1982    59_470015 MorisitaHornDiss  6.872616e-02 -2.332364e-03
      225  1982    59_470015   BrayCurtisDiss  3.021807e-01 -4.292601e-03
      226  1996    59_470015      JaccardDiss  4.117647e-01 -1.727384e-03
      227  1996    59_470015 MorisitaHornDiss  9.690735e-02 -2.332364e-03
      228  1996    59_470015   BrayCurtisDiss  2.400000e-01 -4.292601e-03
      229  1983    59_470015      JaccardDiss  8.461538e-01 -1.727384e-03
      230  1983    59_470015 MorisitaHornDiss  2.090201e-01 -2.332364e-03
      231  1983    59_470015   BrayCurtisDiss  5.918367e-01 -4.292601e-03
      232  1994    59_470015      JaccardDiss  5.000000e-01 -1.727384e-03
      233  1994    59_470015 MorisitaHornDiss  3.897869e-02 -2.332364e-03
      234  1994    59_470015   BrayCurtisDiss  5.241935e-01 -4.292601e-03
      235  1996   333_426399      JaccardDiss  3.921569e-01 -2.700895e-03
      236  1996   333_426399 MorisitaHornDiss  1.108423e-01 -2.278324e-03
      237  1996   333_426399   BrayCurtisDiss  3.155894e-01 -2.556426e-03
      238  1997   333_426399      JaccardDiss  4.814815e-01 -2.700895e-03
      239  1997   333_426399 MorisitaHornDiss  7.931856e-02 -2.278324e-03
      240  1997   333_426399   BrayCurtisDiss  2.714286e-01 -2.556426e-03
      241  2000   333_426399      JaccardDiss  4.545455e-01 -2.700895e-03
      242  2000   333_426399 MorisitaHornDiss  1.628665e-01 -2.278324e-03
      243  2000   333_426399   BrayCurtisDiss  3.978261e-01 -2.556426e-03
      244  1989   333_426399      JaccardDiss  6.176471e-01 -2.700895e-03
      245  1989   333_426399 MorisitaHornDiss  6.089913e-01 -2.278324e-03
      246  1989   333_426399   BrayCurtisDiss  5.904366e-01 -2.556426e-03
      247  1981   333_426399      JaccardDiss  5.882353e-01 -2.700895e-03
      248  1981   333_426399 MorisitaHornDiss  2.202891e-01 -2.278324e-03
      249  1981   333_426399   BrayCurtisDiss  4.255319e-01 -2.556426e-03
      250  1982   333_426399      JaccardDiss  4.893617e-01 -2.700895e-03
      251  1982   333_426399 MorisitaHornDiss  3.113123e-01 -2.278324e-03
      252  1982   333_426399   BrayCurtisDiss  5.820896e-01 -2.556426e-03
      253  1984   333_426399      JaccardDiss  5.178571e-01 -2.700895e-03
      254  1984   333_426399 MorisitaHornDiss  2.772325e-01 -2.278324e-03
      255  1984   333_426399   BrayCurtisDiss  3.909348e-01 -2.556426e-03
      256  1985   333_426399      JaccardDiss  4.464286e-01 -2.700895e-03
      257  1985   333_426399 MorisitaHornDiss  1.606174e-01 -2.278324e-03
      258  1985   333_426399   BrayCurtisDiss  3.953488e-01 -2.556426e-03
      259  1987   333_426399      JaccardDiss  4.444444e-01 -2.700895e-03
      260  1987   333_426399 MorisitaHornDiss  1.250636e-01 -2.278324e-03
      261  1987   333_426399   BrayCurtisDiss  3.226238e-01 -2.556426e-03
      262  1988   333_426399      JaccardDiss  4.444444e-01 -2.700895e-03
      263  1988   333_426399 MorisitaHornDiss  8.750685e-02 -2.278324e-03
      264  1988   333_426399   BrayCurtisDiss  3.236074e-01 -2.556426e-03
      265  1991   333_426399      JaccardDiss  4.042553e-01 -2.700895e-03
      266  1991   333_426399 MorisitaHornDiss  8.801436e-02 -2.278324e-03
      267  1991   333_426399   BrayCurtisDiss  3.358071e-01 -2.556426e-03
      268  1992   333_426399      JaccardDiss  3.673469e-01 -2.700895e-03
      269  1992   333_426399 MorisitaHornDiss  7.245419e-02 -2.278324e-03
      270  1992   333_426399   BrayCurtisDiss  2.638889e-01 -2.556426e-03
      271  1993   333_426399      JaccardDiss  3.958333e-01 -2.700895e-03
      272  1993   333_426399 MorisitaHornDiss  1.166308e-01 -2.278324e-03
      273  1993   333_426399   BrayCurtisDiss  3.103448e-01 -2.556426e-03
      274  1994   333_426399      JaccardDiss  4.285714e-01 -2.700895e-03
      275  1994   333_426399 MorisitaHornDiss  2.033527e-01 -2.278324e-03
      276  1994   333_426399   BrayCurtisDiss  4.183865e-01 -2.556426e-03
      277  1995   333_426399      JaccardDiss  5.370370e-01 -2.700895e-03
      278  1995   333_426399 MorisitaHornDiss  1.543556e-01 -2.278324e-03
      279  1995   333_426399   BrayCurtisDiss  5.110220e-01 -2.556426e-03
      280  1998   333_426399      JaccardDiss  4.375000e-01 -2.700895e-03
      281  1998   333_426399 MorisitaHornDiss  2.519213e-01 -2.278324e-03
      282  1998   333_426399   BrayCurtisDiss  4.917127e-01 -2.556426e-03
      283  1999   333_426399      JaccardDiss  5.490196e-01 -2.700895e-03
      284  1999   333_426399 MorisitaHornDiss  1.396268e-01 -2.278324e-03
      285  1999   333_426399   BrayCurtisDiss  4.087591e-01 -2.556426e-03
      286  2001   333_426399      JaccardDiss  5.000000e-01 -2.700895e-03
      287  2001   333_426399 MorisitaHornDiss  7.301026e-02 -2.278324e-03
      288  2001   333_426399   BrayCurtisDiss  2.920354e-01 -2.556426e-03
      289  2002   333_426399      JaccardDiss  3.962264e-01 -2.700895e-03
      290  2002   333_426399 MorisitaHornDiss  1.158922e-01 -2.278324e-03
      291  2002   333_426399   BrayCurtisDiss  3.597811e-01 -2.556426e-03
      292  2003   333_426399      JaccardDiss  5.600000e-01 -2.700895e-03
      293  2003   333_426399 MorisitaHornDiss  9.315696e-02 -2.278324e-03
      294  2003   333_426399   BrayCurtisDiss  3.751508e-01 -2.556426e-03
      295  2004   333_426399      JaccardDiss  5.000000e-01 -2.700895e-03
      296  2004   333_426399 MorisitaHornDiss  1.215294e-01 -2.278324e-03
      297  2004   333_426399   BrayCurtisDiss  3.633952e-01 -2.556426e-03
      298  2005   333_426399      JaccardDiss  4.642857e-01 -2.700895e-03
      299  2005   333_426399 MorisitaHornDiss  1.801253e-01 -2.278324e-03
      300  2005   333_426399   BrayCurtisDiss  4.028892e-01 -2.556426e-03
      301  2006   333_426399      JaccardDiss  5.614035e-01 -2.700895e-03
      302  2006   333_426399 MorisitaHornDiss  4.111651e-01 -2.278324e-03
      303  2006   333_426399   BrayCurtisDiss  4.825175e-01 -2.556426e-03
      304  2007   333_426399      JaccardDiss  5.689655e-01 -2.700895e-03
      305  2007   333_426399 MorisitaHornDiss  2.381192e-01 -2.278324e-03
      306  2007   333_426399   BrayCurtisDiss  4.140127e-01 -2.556426e-03
      307  2008   333_426399      JaccardDiss  5.344828e-01 -2.700895e-03
      308  2008   333_426399 MorisitaHornDiss  8.090146e-01 -2.278324e-03
      309  2008   333_426399   BrayCurtisDiss  6.728723e-01 -2.556426e-03
      310  1983   333_426399      JaccardDiss  6.363636e-01 -2.700895e-03
      311  1983   333_426399 MorisitaHornDiss  4.125186e-01 -2.278324e-03
      312  1983   333_426399   BrayCurtisDiss  5.276873e-01 -2.556426e-03
      313  1986   333_426399      JaccardDiss  5.423729e-01 -2.700895e-03
      314  1986   333_426399 MorisitaHornDiss  2.870562e-01 -2.278324e-03
      315  1986   333_426399   BrayCurtisDiss  4.376658e-01 -2.556426e-03
      316  1990   333_426399      JaccardDiss  8.297872e-01 -2.700895e-03
      317  1990   333_426399 MorisitaHornDiss  9.807781e-01 -2.278324e-03
      318  1990   333_426399   BrayCurtisDiss  9.152542e-01 -2.556426e-03
      319  2009   333_426399      JaccardDiss  2.692308e-01 -2.700895e-03
      320  2009   333_426399 MorisitaHornDiss  4.910003e-02 -2.278324e-03
      321  2009   333_426399   BrayCurtisDiss  2.462077e-01 -2.556426e-03
      322  2009  372_2374177      JaccardDiss  6.170213e-01 -1.583744e-02
      323  2009  372_2374177 MorisitaHornDiss  4.622395e-01  1.303879e-01
      324  2009  372_2374177   BrayCurtisDiss  7.550432e-01  5.347758e-02
      325  2010  372_2374177      JaccardDiss  5.348837e-01 -1.583744e-02
      326  2010  372_2374177 MorisitaHornDiss  2.901461e-01  1.303879e-01
      327  2010  372_2374177   BrayCurtisDiss  4.766667e-01  5.347758e-02
      328  2008  372_2374177      JaccardDiss  5.777778e-01 -1.583744e-02
      329  2008  372_2374177 MorisitaHornDiss  2.052522e-01  1.303879e-01
      330  2008  372_2374177   BrayCurtisDiss  4.900662e-01  5.347758e-02
      331  2011  372_2374177      JaccardDiss  5.945946e-01 -1.583744e-02
      332  2011  372_2374177 MorisitaHornDiss  6.299432e-01  1.303879e-01
      333  2011  372_2374177   BrayCurtisDiss  6.691450e-01  5.347758e-02
      334  2012  372_2374177      JaccardDiss  5.098039e-01 -1.583744e-02
      335  2012  372_2374177 MorisitaHornDiss  7.733398e-01  1.303879e-01
      336  2012  372_2374177   BrayCurtisDiss  8.004032e-01  5.347758e-02
      337  2011  372_2378534      JaccardDiss  4.473684e-01 -1.248538e-02
      338  2011  372_2378534 MorisitaHornDiss  1.126935e-01 -8.914750e-03
      339  2011  372_2378534   BrayCurtisDiss  3.177083e-01 -1.422627e-02
      340  2009  372_2378534      JaccardDiss  4.500000e-01 -1.248538e-02
      341  2009  372_2378534 MorisitaHornDiss  8.418330e-02 -8.914750e-03
      342  2009  372_2378534   BrayCurtisDiss  2.772277e-01 -1.422627e-02
      343  2010  372_2378534      JaccardDiss  6.388889e-01 -1.248538e-02
      344  2010  372_2378534 MorisitaHornDiss  1.289641e-01 -8.914750e-03
      345  2010  372_2378534   BrayCurtisDiss  4.129032e-01 -1.422627e-02
      346  2012  372_2378534      JaccardDiss  4.722222e-01 -1.248538e-02
      347  2012  372_2378534 MorisitaHornDiss  5.989100e-02 -8.914750e-03
      348  2012  372_2378534   BrayCurtisDiss  2.615385e-01 -1.422627e-02
      349  2008  372_2425908      JaccardDiss  5.952381e-01  2.665565e-02
      350  2008  372_2425908 MorisitaHornDiss  2.839168e-01  2.013998e-02
      351  2008  372_2425908   BrayCurtisDiss  4.860335e-01  1.689895e-02
      352  2010  372_2425908      JaccardDiss  6.052632e-01  2.665565e-02
      353  2010  372_2425908 MorisitaHornDiss  2.688127e-01  2.013998e-02
      354  2010  372_2425908   BrayCurtisDiss  4.787431e-01  1.689895e-02
      355  2011  372_2425908      JaccardDiss  5.750000e-01  2.665565e-02
      356  2011  372_2425908 MorisitaHornDiss  3.259589e-01  2.013998e-02
      357  2011  372_2425908   BrayCurtisDiss  5.024390e-01  1.689895e-02
      358  2012  372_2425908      JaccardDiss  5.789474e-01  2.665565e-02
      359  2012  372_2425908 MorisitaHornDiss  2.477072e-01  2.013998e-02
      360  2012  372_2425908   BrayCurtisDiss  4.178218e-01  1.689895e-02
      361  2009  372_2425908      JaccardDiss  2.758621e-01  2.665565e-02
      362  2009  372_2425908 MorisitaHornDiss  5.213979e-02  2.013998e-02
      363  2009  372_2425908   BrayCurtisDiss  1.970260e-01  1.689895e-02
      364  2010  372_2427363      JaccardDiss  3.695652e-01 -3.212136e-02
      365  2010  372_2427363 MorisitaHornDiss  1.436842e-01  7.146120e-02
      366  2010  372_2427363   BrayCurtisDiss  2.795634e-01  3.749751e-02
      367  2011  372_2427363      JaccardDiss  2.380952e-01 -3.212136e-02
      368  2011  372_2427363 MorisitaHornDiss  2.222093e-01  7.146120e-02
      369  2011  372_2427363   BrayCurtisDiss  3.142549e-01  3.749751e-02
      370  2009  372_2427363      JaccardDiss  3.076923e-01 -3.212136e-02
      371  2009  372_2427363 MorisitaHornDiss  5.729247e-02  7.146120e-02
      372  2009  372_2427363   BrayCurtisDiss  2.122072e-01  3.749751e-02
      373  2012  372_2427363      JaccardDiss  2.444444e-01 -3.212136e-02
      374  2012  372_2427363 MorisitaHornDiss  2.693214e-01  7.146120e-02
      375  2012  372_2427363   BrayCurtisDiss  3.256351e-01  3.749751e-02
      376  2011  372_2428091      JaccardDiss  4.117647e-01  8.008638e-03
      377  2011  372_2428091 MorisitaHornDiss  9.162038e-02 -3.899041e-03
      378  2011  372_2428091   BrayCurtisDiss  2.193548e-01 -4.844248e-02
      379  2012  372_2428091      JaccardDiss  4.230769e-01  8.008638e-03
      380  2012  372_2428091 MorisitaHornDiss  1.222011e-01 -3.899041e-03
      381  2012  372_2428091   BrayCurtisDiss  3.260620e-01 -4.844248e-02
      382  2009  372_2428091      JaccardDiss  4.200000e-01  8.008638e-03
      383  2009  372_2428091 MorisitaHornDiss  1.003877e-01 -3.899041e-03
      384  2009  372_2428091   BrayCurtisDiss  4.441379e-01 -4.844248e-02
      385  2010  372_2428091      JaccardDiss  3.409091e-01  8.008638e-03
      386  2010  372_2428091 MorisitaHornDiss  1.960512e-01 -3.899041e-03
      387  2010  372_2428091   BrayCurtisDiss  3.495519e-01 -4.844248e-02
      388  2009  372_2425904      JaccardDiss  6.451613e-01  3.866689e-02
      389  2009  372_2425904 MorisitaHornDiss  4.235821e-01  1.176345e-02
      390  2009  372_2425904   BrayCurtisDiss  5.702918e-01  2.688767e-02
      391  2011  372_2425904      JaccardDiss  4.827586e-01  3.866689e-02
      392  2011  372_2425904 MorisitaHornDiss  1.081609e-01  1.176345e-02
      393  2011  372_2425904   BrayCurtisDiss  4.014963e-01  2.688767e-02
      394  2008  372_2425904      JaccardDiss  3.461538e-01  3.866689e-02
      395  2008  372_2425904 MorisitaHornDiss  2.258270e-01  1.176345e-02
      396  2008  372_2425904   BrayCurtisDiss  3.743842e-01  2.688767e-02
      397  2012  372_2425904      JaccardDiss  6.206897e-01  3.866689e-02
      398  2012  372_2425904 MorisitaHornDiss  4.423549e-01  1.176345e-02
      399  2012  372_2425904   BrayCurtisDiss  5.932203e-01  2.688767e-02
      400  2008  372_2407700      JaccardDiss  6.315789e-01  2.096276e-03
      401  2008  372_2407700 MorisitaHornDiss  2.268733e-01  1.317271e-01
      402  2008  372_2407700   BrayCurtisDiss  6.582278e-01  9.917075e-03
      403  2010  372_2407700      JaccardDiss  7.931034e-01  2.096276e-03
      404  2010  372_2407700 MorisitaHornDiss  7.207067e-01  1.317271e-01
      405  2010  372_2407700   BrayCurtisDiss  7.721519e-01  9.917075e-03
      406  2009  372_2407700      JaccardDiss  8.461538e-01  2.096276e-03
      407  2009  372_2407700 MorisitaHornDiss  7.519285e-01  1.317271e-01
      408  2009  372_2407700   BrayCurtisDiss  7.884615e-01  9.917075e-03
      409  2011  372_2407700      JaccardDiss  6.562500e-01  2.096276e-03
      410  2011  372_2407700 MorisitaHornDiss  6.763710e-01  1.317271e-01
      411  2011  372_2407700   BrayCurtisDiss  6.967213e-01  9.917075e-03
      412  2009  372_2398943      JaccardDiss  3.478261e-01  6.842656e-02
      413  2009  372_2398943 MorisitaHornDiss  4.192508e-02  3.356505e-02
      414  2009  372_2398943   BrayCurtisDiss  2.635848e-01  8.502761e-02
      415  2010  372_2398943      JaccardDiss  4.750000e-01  6.842656e-02
      416  2010  372_2398943 MorisitaHornDiss  1.132490e-01  3.356505e-02
      417  2010  372_2398943   BrayCurtisDiss  5.443787e-01  8.502761e-02
      418  2011  372_2398943      JaccardDiss  3.902439e-01  6.842656e-02
      419  2011  372_2398943 MorisitaHornDiss  4.526144e-02  3.356505e-02
      420  2011  372_2398943   BrayCurtisDiss  2.128514e-01  8.502761e-02
      421  2012  372_2398943      JaccardDiss  6.041667e-01  6.842656e-02
      422  2012  372_2398943 MorisitaHornDiss  1.764711e-01  3.356505e-02
      423  2012  372_2398943   BrayCurtisDiss  6.575192e-01  8.502761e-02
      424  2010  372_2347198      JaccardDiss  4.615385e-01 -4.015385e-02
      425  2010  372_2347198 MorisitaHornDiss  2.512736e-01 -2.693494e-02
      426  2010  372_2347198   BrayCurtisDiss  4.602588e-01 -2.502021e-02
      427  2009  372_2347198      JaccardDiss  4.000000e-01 -4.015385e-02
      428  2009  372_2347198 MorisitaHornDiss  2.731930e-01 -2.693494e-02
      429  2009  372_2347198   BrayCurtisDiss  3.918919e-01 -2.502021e-02
      430  2011  372_2347198      JaccardDiss  3.600000e-01 -4.015385e-02
      431  2011  372_2347198 MorisitaHornDiss  2.890946e-01 -2.693494e-02
      432  2011  372_2347198   BrayCurtisDiss  4.232558e-01 -2.502021e-02
      433  2012  372_2347198      JaccardDiss  3.000000e-01 -4.015385e-02
      434  2012  372_2347198 MorisitaHornDiss  1.708029e-01 -2.693494e-02
      435  2012  372_2347198   BrayCurtisDiss  3.208255e-01 -2.502021e-02
      436  2010  372_2430280      JaccardDiss  4.038462e-01  3.327680e-03
      437  2010  372_2430280 MorisitaHornDiss  2.008782e-01  3.219271e-02
      438  2010  372_2430280   BrayCurtisDiss  3.089343e-01 -2.953876e-03
      439  2011  372_2430280      JaccardDiss  3.695652e-01  3.327680e-03
      440  2011  372_2430280 MorisitaHornDiss  3.788795e-01  3.219271e-02
      441  2011  372_2430280   BrayCurtisDiss  4.012400e-01 -2.953876e-03
      442  2009  372_2430280      JaccardDiss  4.444444e-01  3.327680e-03
      443  2009  372_2430280 MorisitaHornDiss  3.414522e-01  3.219271e-02
      444  2009  372_2430280   BrayCurtisDiss  4.238603e-01 -2.953876e-03
      445  2008  372_2430280      JaccardDiss  4.042553e-01  3.327680e-03
      446  2008  372_2430280 MorisitaHornDiss  1.715674e-01  3.219271e-02
      447  2008  372_2430280   BrayCurtisDiss  3.743961e-01 -2.953876e-03
      448  2012  372_2430280      JaccardDiss  4.583333e-01  3.327680e-03
      449  2012  372_2430280 MorisitaHornDiss  3.138173e-01  3.219271e-02
      450  2012  372_2430280   BrayCurtisDiss  3.709369e-01 -2.953876e-03
      451  2010  372_2428088      JaccardDiss  4.594595e-01  3.445378e-02
      452  2010  372_2428088 MorisitaHornDiss  1.370986e-01  3.544781e-02
      453  2010  372_2428088   BrayCurtisDiss  3.181818e-01  2.296671e-02
      454  2008  372_2428088      JaccardDiss  4.571429e-01  3.445378e-02
      455  2008  372_2428088 MorisitaHornDiss  1.886352e-01  3.544781e-02
      456  2008  372_2428088   BrayCurtisDiss  3.209877e-01  2.296671e-02
      457  2011  372_2428088      JaccardDiss  5.000000e-01  3.445378e-02
      458  2011  372_2428088 MorisitaHornDiss  5.527855e-01  3.544781e-02
      459  2011  372_2428088   BrayCurtisDiss  4.695122e-01  2.296671e-02
      460  2012  372_2428088      JaccardDiss  6.000000e-01  3.445378e-02
      461  2012  372_2428088 MorisitaHornDiss  2.395059e-01  3.544781e-02
      462  2012  372_2428088   BrayCurtisDiss  4.200000e-01  2.296671e-02
      463  2009  372_2428088      JaccardDiss  4.411765e-01  3.445378e-02
      464  2009  372_2428088 MorisitaHornDiss  3.000487e-01  3.544781e-02
      465  2009  372_2428088   BrayCurtisDiss  4.378698e-01  2.296671e-02
      466  2008  372_2407691      JaccardDiss  6.333333e-01  2.441558e-02
      467  2008  372_2407691 MorisitaHornDiss  2.566349e-01  2.137934e-02
      468  2008  372_2407691   BrayCurtisDiss  4.956522e-01  2.708408e-02
      469  2009  372_2407691      JaccardDiss  4.285714e-01  2.441558e-02
      470  2009  372_2407691 MorisitaHornDiss  1.895062e-01  2.137934e-02
      471  2009  372_2407691   BrayCurtisDiss  4.420601e-01  2.708408e-02
      472  2010  372_2407691      JaccardDiss  5.714286e-01  2.441558e-02
      473  2010  372_2407691 MorisitaHornDiss  4.092125e-01  2.137934e-02
      474  2010  372_2407691   BrayCurtisDiss  5.169492e-01  2.708408e-02
      475  2011  372_2407691      JaccardDiss  6.666667e-01  2.441558e-02
      476  2011  372_2407691 MorisitaHornDiss  1.952390e-01  2.137934e-02
      477  2011  372_2407691   BrayCurtisDiss  5.737705e-01  2.708408e-02
      478  2012  372_2407691      JaccardDiss  6.363636e-01  2.441558e-02
      479  2012  372_2407691 MorisitaHornDiss  3.606651e-01  2.137934e-02
      480  2012  372_2407691   BrayCurtisDiss  5.652174e-01  2.708408e-02
      481  2008  372_2397485      JaccardDiss  3.870968e-01  7.159400e-03
      482  2008  372_2397485 MorisitaHornDiss  2.244589e-01 -2.285114e-02
      483  2008  372_2397485   BrayCurtisDiss  3.615928e-01  1.580528e-02
      484  2009  372_2397485      JaccardDiss  4.333333e-01  7.159400e-03
      485  2009  372_2397485 MorisitaHornDiss  1.323587e-01 -2.285114e-02
      486  2009  372_2397485   BrayCurtisDiss  3.009079e-01  1.580528e-02
      487  2010  372_2397485      JaccardDiss  3.793103e-01  7.159400e-03
      488  2010  372_2397485 MorisitaHornDiss  1.491882e-01 -2.285114e-02
      489  2010  372_2397485   BrayCurtisDiss  4.867444e-01  1.580528e-02
      490  2011  372_2397485      JaccardDiss  3.076923e-01  7.159400e-03
      491  2011  372_2397485 MorisitaHornDiss  1.797631e-01 -2.285114e-02
      492  2011  372_2397485   BrayCurtisDiss  6.434676e-01  1.580528e-02
      493  2012  372_2397485      JaccardDiss  4.857143e-01  7.159400e-03
      494  2012  372_2397485 MorisitaHornDiss  8.650105e-02 -2.285114e-02
      495  2012  372_2397485   BrayCurtisDiss  2.693394e-01  1.580528e-02
      496  2005  372_2400408      JaccardDiss  8.333333e-01 -5.772587e-02
      497  2005  372_2400408 MorisitaHornDiss  6.672444e-01 -6.682944e-02
      498  2005  372_2400408   BrayCurtisDiss  7.560976e-01 -4.287809e-02
      499  2006  372_2400408      JaccardDiss  8.163265e-01 -5.772587e-02
      500  2006  372_2400408 MorisitaHornDiss  5.090884e-01 -6.682944e-02
      501  2006  372_2400408   BrayCurtisDiss  6.903766e-01 -4.287809e-02
      502  2007  372_2400408      JaccardDiss  6.000000e-01 -5.772587e-02
      503  2007  372_2400408 MorisitaHornDiss  5.201654e-01 -6.682944e-02
      504  2007  372_2400408   BrayCurtisDiss  5.421687e-01 -4.287809e-02
      505  2008  372_2400408      JaccardDiss  5.681818e-01 -5.772587e-02
      506  2008  372_2400408 MorisitaHornDiss  4.055519e-01 -6.682944e-02
      507  2008  372_2400408   BrayCurtisDiss  5.214724e-01 -4.287809e-02
      508  2009  372_2400408      JaccardDiss  6.600000e-01 -5.772587e-02
      509  2009  372_2400408 MorisitaHornDiss  4.917319e-01 -6.682944e-02
      510  2009  372_2400408   BrayCurtisDiss  6.950495e-01 -4.287809e-02
      511  2010  372_2400408      JaccardDiss  5.294118e-01 -5.772587e-02
      512  2010  372_2400408 MorisitaHornDiss  2.327749e-01 -6.682944e-02
      513  2010  372_2400408   BrayCurtisDiss  4.572864e-01 -4.287809e-02
      514  2010  372_2436844      JaccardDiss  5.625000e-01 -2.174020e-02
      515  2010  372_2436844 MorisitaHornDiss  2.980907e-01 -1.653234e-02
      516  2010  372_2436844   BrayCurtisDiss  4.639498e-01  1.008571e-02
      517  2011  372_2436844      JaccardDiss  4.333333e-01 -2.174020e-02
      518  2011  372_2436844 MorisitaHornDiss  2.642548e-01 -1.653234e-02
      519  2011  372_2436844   BrayCurtisDiss  3.890020e-01  1.008571e-02
      520  2009  372_2436844      JaccardDiss  5.294118e-01 -2.174020e-02
      521  2009  372_2436844 MorisitaHornDiss  3.937306e-01 -1.653234e-02
      522  2009  372_2436844   BrayCurtisDiss  4.246101e-01  1.008571e-02
      523  2012  372_2436844      JaccardDiss  5.000000e-01 -2.174020e-02
      524  2012  372_2436844 MorisitaHornDiss  3.499014e-01 -1.653234e-02
      525  2012  372_2436844   BrayCurtisDiss  4.832117e-01  1.008571e-02
      526  2009  372_2424448      JaccardDiss  6.666667e-01 -2.219780e-02
      527  2009  372_2424448 MorisitaHornDiss  2.092268e-01 -1.483230e-02
      528  2009  372_2424448   BrayCurtisDiss  4.677419e-01 -5.718125e-04
      529  2010  372_2424448      JaccardDiss  7.142857e-01 -2.219780e-02
      530  2010  372_2424448 MorisitaHornDiss  1.415463e-01 -1.483230e-02
      531  2010  372_2424448   BrayCurtisDiss  3.965517e-01 -5.718125e-04
      532  2011  372_2424448      JaccardDiss  6.923077e-01 -2.219780e-02
      533  2011  372_2424448 MorisitaHornDiss  1.294137e-01 -1.483230e-02
      534  2011  372_2424448   BrayCurtisDiss  5.940594e-01 -5.718125e-04
      535  2012  372_2424448      JaccardDiss  6.000000e-01 -2.219780e-02
      536  2012  372_2424448 MorisitaHornDiss  1.638300e-01 -1.483230e-02
      537  2012  372_2424448   BrayCurtisDiss  4.000000e-01 -5.718125e-04
      538  2010  372_2410600      JaccardDiss  4.000000e-01  1.169591e-02
      539  2010  372_2410600 MorisitaHornDiss  1.590290e-01 -7.966068e-03
      540  2010  372_2410600   BrayCurtisDiss  3.650794e-01  2.428283e-04
      541  2008  372_2410600      JaccardDiss  5.555556e-01  1.169591e-02
      542  2008  372_2410600 MorisitaHornDiss  1.820254e-01 -7.966068e-03
      543  2008  372_2410600   BrayCurtisDiss  3.684211e-01  2.428283e-04
      544  2009  372_2410600      JaccardDiss  6.666667e-01  1.169591e-02
      545  2009  372_2410600 MorisitaHornDiss  4.318488e-01 -7.966068e-03
      546  2009  372_2410600   BrayCurtisDiss  5.820896e-01  2.428283e-04
      547  2012  372_2410600      JaccardDiss  6.842105e-01  1.169591e-02
      548  2012  372_2410600 MorisitaHornDiss  3.003370e-01 -7.966068e-03
      549  2012  372_2410600   BrayCurtisDiss  5.121951e-01  2.428283e-04
      550  2011  372_2410600      JaccardDiss  5.263158e-01  1.169591e-02
      551  2011  372_2410600 MorisitaHornDiss  1.155650e-01 -7.966068e-03
      552  2011  372_2410600   BrayCurtisDiss  2.969697e-01  2.428283e-04
      553  2009  372_2374899      JaccardDiss  4.146341e-01  3.813131e-02
      554  2009  372_2374899 MorisitaHornDiss  4.331154e-01  2.580127e-02
      555  2009  372_2374899   BrayCurtisDiss  4.786517e-01  4.497995e-02
      556  2010  372_2374899      JaccardDiss  5.897436e-01  3.813131e-02
      557  2010  372_2374899 MorisitaHornDiss  5.291759e-01  2.580127e-02
      558  2010  372_2374899   BrayCurtisDiss  5.363322e-01  4.497995e-02
      559  2011  372_2374899      JaccardDiss  5.405405e-01  3.813131e-02
      560  2011  372_2374899 MorisitaHornDiss  3.847368e-01  2.580127e-02
      561  2011  372_2374899   BrayCurtisDiss  4.611111e-01  4.497995e-02
      562  2012  372_2374899      JaccardDiss  5.581395e-01  3.813131e-02
      563  2012  372_2374899 MorisitaHornDiss  5.672659e-01  2.580127e-02
      564  2012  372_2374899   BrayCurtisDiss  6.536585e-01  4.497995e-02
      565  2010  372_2406225      JaccardDiss  6.470588e-01 -4.193559e-02
      566  2010  372_2406225 MorisitaHornDiss  1.268607e-01  1.421454e-02
      567  2010  372_2406225   BrayCurtisDiss  4.854054e-01  2.566988e-02
      568  2009  372_2406225      JaccardDiss  7.037037e-01 -4.193559e-02
      569  2009  372_2406225 MorisitaHornDiss  8.529712e-02  1.421454e-02
      570  2009  372_2406225   BrayCurtisDiss  3.026445e-01  2.566988e-02
      571  2011  372_2406225      JaccardDiss  5.000000e-01 -4.193559e-02
      572  2011  372_2406225 MorisitaHornDiss  2.426254e-01  1.421454e-02
      573  2011  372_2406225   BrayCurtisDiss  6.280992e-01  2.566988e-02
      574  2008  372_2406225      JaccardDiss  7.600000e-01 -4.193559e-02
      575  2008  372_2406225 MorisitaHornDiss  1.307008e-01  1.421454e-02
      576  2008  372_2406225   BrayCurtisDiss  4.395062e-01  2.566988e-02
      577  2012  372_2406225      JaccardDiss  6.521739e-01 -4.193559e-02
      578  2012  372_2406225 MorisitaHornDiss  1.231094e-01  1.421454e-02
      579  2012  372_2406225   BrayCurtisDiss  4.051282e-01  2.566988e-02
      580  2010  372_2459505      JaccardDiss  6.400000e-01 -2.490693e-02
      581  2010  372_2459505 MorisitaHornDiss  2.364202e-01  3.177554e-02
      582  2010  372_2459505   BrayCurtisDiss  4.758621e-01  2.438215e-02
      583  2011  372_2459505      JaccardDiss  6.818182e-01 -2.490693e-02
      584  2011  372_2459505 MorisitaHornDiss  1.612311e-01  3.177554e-02
      585  2011  372_2459505   BrayCurtisDiss  4.047619e-01  2.438215e-02
      586  2008  372_2459505      JaccardDiss  7.142857e-01 -2.490693e-02
      587  2008  372_2459505 MorisitaHornDiss  7.251154e-02  3.177554e-02
      588  2008  372_2459505   BrayCurtisDiss  2.934783e-01  2.438215e-02
      589  2009  372_2459505      JaccardDiss  7.916667e-01 -2.490693e-02
      590  2009  372_2459505 MorisitaHornDiss  1.848237e-01  3.177554e-02
      591  2009  372_2459505   BrayCurtisDiss  5.658915e-01  2.438215e-02
      592  2009  372_2442010      JaccardDiss  3.846154e-01  2.838828e-01
      593  2009  372_2442010 MorisitaHornDiss  1.011388e-01  4.390241e-01
      594  2009  372_2442010   BrayCurtisDiss  3.333333e-01  3.232323e-01
      595  2010  372_2442010      JaccardDiss  9.565217e-01  2.838828e-01
      596  2010  372_2442010 MorisitaHornDiss  9.855072e-01  4.390241e-01
      597  2010  372_2442010   BrayCurtisDiss  9.858156e-01  3.232323e-01
      598  2011  372_2442010      JaccardDiss  9.523810e-01  2.838828e-01
      599  2011  372_2442010 MorisitaHornDiss  9.791870e-01  4.390241e-01
      600  2011  372_2442010   BrayCurtisDiss  9.797980e-01  3.232323e-01
      601  2009  372_2433992      JaccardDiss  4.651163e-01 -5.542316e-02
      602  2009  372_2433992 MorisitaHornDiss  1.881482e-01 -3.370744e-02
      603  2009  372_2433992   BrayCurtisDiss  4.749263e-01 -5.128119e-02
      604  2012  372_2433992      JaccardDiss  2.857143e-01 -5.542316e-02
      605  2012  372_2433992 MorisitaHornDiss  1.239996e-01 -3.370744e-02
      606  2012  372_2433992   BrayCurtisDiss  3.043478e-01 -5.128119e-02
      607  2010  372_2433992      JaccardDiss  3.750000e-01 -5.542316e-02
      608  2010  372_2433992 MorisitaHornDiss  2.784570e-01 -3.370744e-02
      609  2010  372_2433992   BrayCurtisDiss  4.004376e-01 -5.128119e-02
      610  2011  372_2433992      JaccardDiss  3.589744e-01 -5.542316e-02
      611  2011  372_2433992 MorisitaHornDiss  1.338282e-01 -3.370744e-02
      612  2011  372_2433992   BrayCurtisDiss  3.993610e-01 -5.128119e-02
      613  2006  372_2366870      JaccardDiss  5.185185e-01  1.972698e-02
      614  2006  372_2366870 MorisitaHornDiss  4.553298e-01  9.358890e-03
      615  2006  372_2366870   BrayCurtisDiss  6.502732e-01 -4.949736e-03
      616  2008  372_2366870      JaccardDiss  4.583333e-01  1.972698e-02
      617  2008  372_2366870 MorisitaHornDiss  3.250395e-01  9.358890e-03
      618  2008  372_2366870   BrayCurtisDiss  6.404494e-01 -4.949736e-03
      619  2009  372_2366870      JaccardDiss  7.187500e-01  1.972698e-02
      620  2009  372_2366870 MorisitaHornDiss  7.179313e-01  9.358890e-03
      621  2009  372_2366870   BrayCurtisDiss  7.977528e-01 -4.949736e-03
      622  2011  372_2366870      JaccardDiss  7.857143e-01  1.972698e-02
      623  2011  372_2366870 MorisitaHornDiss  6.890166e-01  9.358890e-03
      624  2011  372_2366870   BrayCurtisDiss  7.404580e-01 -4.949736e-03
      625  2012  372_2366870      JaccardDiss  5.161290e-01  1.972698e-02
      626  2012  372_2366870 MorisitaHornDiss  3.191346e-01  9.358890e-03
      627  2012  372_2366870   BrayCurtisDiss  5.714286e-01 -4.949736e-03
      628  2007  372_2366870      JaccardDiss  4.642857e-01  1.972698e-02
      629  2007  372_2366870 MorisitaHornDiss  3.398026e-01  9.358890e-03
      630  2007  372_2366870   BrayCurtisDiss  5.694444e-01 -4.949736e-03
      631  2010  372_2366870      JaccardDiss  3.750000e-01  1.972698e-02
      632  2010  372_2366870 MorisitaHornDiss  2.972461e-01  9.358890e-03
      633  2010  372_2366870   BrayCurtisDiss  3.963636e-01 -4.949736e-03
      634  2008  372_2440508      JaccardDiss  3.913043e-01  3.221532e-02
      635  2008  372_2440508 MorisitaHornDiss  2.039672e-01  7.237424e-02
      636  2008  372_2440508   BrayCurtisDiss  3.828571e-01  3.589309e-02
      637  2009  372_2440508      JaccardDiss  6.666667e-01  3.221532e-02
      638  2009  372_2440508 MorisitaHornDiss  5.867813e-01  7.237424e-02
      639  2009  372_2440508   BrayCurtisDiss  6.595745e-01  3.589309e-02
      640  2011  372_2440508      JaccardDiss  5.714286e-01  3.221532e-02
      641  2011  372_2440508 MorisitaHornDiss  7.721823e-01  7.237424e-02
      642  2011  372_2440508   BrayCurtisDiss  7.326733e-01  3.589309e-02
      643  2012  372_2440508      JaccardDiss  6.000000e-01  3.221532e-02
      644  2012  372_2440508 MorisitaHornDiss  4.731380e-01  7.237424e-02
      645  2012  372_2440508   BrayCurtisDiss  5.257732e-01  3.589309e-02
      646  2010  372_2440508      JaccardDiss  7.307692e-01  3.221532e-02
      647  2010  372_2440508 MorisitaHornDiss  6.739561e-01  7.237424e-02
      648  2010  372_2440508   BrayCurtisDiss  7.049180e-01  3.589309e-02
      649  2012  372_2442692      JaccardDiss  6.842105e-01  6.502629e-02
      650  2012  372_2442692 MorisitaHornDiss  5.740840e-01  9.156447e-02
      651  2012  372_2442692   BrayCurtisDiss  7.049808e-01  7.865379e-02
      652  2008  372_2442692      JaccardDiss  3.870968e-01  6.502629e-02
      653  2008  372_2442692 MorisitaHornDiss  1.225246e-01  9.156447e-02
      654  2008  372_2442692   BrayCurtisDiss  3.441860e-01  7.865379e-02
      655  2009  372_2442692      JaccardDiss  6.250000e-01  6.502629e-02
      656  2009  372_2442692 MorisitaHornDiss  5.869666e-01  9.156447e-02
      657  2009  372_2442692   BrayCurtisDiss  6.335878e-01  7.865379e-02
      658  2010  372_2442692      JaccardDiss  7.027027e-01  6.502629e-02
      659  2010  372_2442692 MorisitaHornDiss  6.565723e-01  9.156447e-02
      660  2010  372_2442692   BrayCurtisDiss  7.181208e-01  7.865379e-02
      661  2009  372_2432467      JaccardDiss  5.714286e-01 -7.133005e-02
      662  2009  372_2432467 MorisitaHornDiss  5.886537e-01 -1.131262e-01
      663  2009  372_2432467   BrayCurtisDiss  6.057007e-01 -8.912919e-02
      664  2010  372_2432467      JaccardDiss  6.857143e-01 -7.133005e-02
      665  2010  372_2432467 MorisitaHornDiss  6.090408e-01 -1.131262e-01
      666  2010  372_2432467   BrayCurtisDiss  6.125000e-01 -8.912919e-02
      667  2011  372_2432467      JaccardDiss  2.068966e-01 -7.133005e-02
      668  2011  372_2432467 MorisitaHornDiss  1.154909e-01 -1.131262e-01
      669  2011  372_2432467   BrayCurtisDiss  2.677596e-01 -8.912919e-02
      670  2008  372_2432467      JaccardDiss  4.827586e-01 -7.133005e-02
      671  2008  372_2432467 MorisitaHornDiss  4.993740e-01 -1.131262e-01
      672  2008  372_2432467   BrayCurtisDiss  5.671233e-01 -8.912919e-02
      673  2009  372_2428094      JaccardDiss  2.916667e-01  6.723602e-02
      674  2009  372_2428094 MorisitaHornDiss  7.906680e-02  5.639579e-02
      675  2009  372_2428094   BrayCurtisDiss  2.254902e-01  9.037901e-02
      676  2012  372_2428094      JaccardDiss  4.583333e-01  6.723602e-02
      677  2012  372_2428094 MorisitaHornDiss  1.349679e-01  5.639579e-02
      678  2012  372_2428094   BrayCurtisDiss  4.640523e-01  9.037901e-02
      679  2011  372_2428094      JaccardDiss  6.071429e-01  6.723602e-02
      680  2011  372_2428094 MorisitaHornDiss  5.270585e-01  5.639579e-02
      681  2011  372_2428094   BrayCurtisDiss  5.978261e-01  9.037901e-02
      682  2010  372_2428094      JaccardDiss  4.347826e-01  6.723602e-02
      683  2010  372_2428094 MorisitaHornDiss  1.308039e-01  5.639579e-02
      684  2010  372_2428094   BrayCurtisDiss  4.097222e-01  9.037901e-02
      685  2009  372_2432464      JaccardDiss  1.000000e+00 -3.000000e-01
      686  2009  372_2432464 MorisitaHornDiss  1.000000e+00 -3.000000e-01
      687  2009  372_2432464   BrayCurtisDiss  1.000000e+00 -1.714286e-01
      688  2010  372_2432464      JaccardDiss  1.000000e+00 -3.000000e-01
      689  2010  372_2432464 MorisitaHornDiss  1.000000e+00 -3.000000e-01
      690  2010  372_2432464   BrayCurtisDiss  1.000000e+00 -1.714286e-01
      691  2011  372_2432464      JaccardDiss  1.000000e+00 -3.000000e-01
      692  2011  372_2432464 MorisitaHornDiss  1.000000e+00 -3.000000e-01
      693  2011  372_2432464   BrayCurtisDiss  1.000000e+00 -1.714286e-01
      694  2012  372_2432464      JaccardDiss  0.000000e+00 -3.000000e-01
      695  2012  372_2432464 MorisitaHornDiss  0.000000e+00 -3.000000e-01
      696  2012  372_2432464   BrayCurtisDiss  4.285714e-01 -1.714286e-01
      697  2009  372_2421551      JaccardDiss  4.642857e-01  1.011905e-01
      698  2009  372_2421551 MorisitaHornDiss  6.715115e-01 -5.496420e-03
      699  2009  372_2421551   BrayCurtisDiss  5.458937e-01  8.050142e-02
      700  2010  372_2421551      JaccardDiss  6.538462e-01  1.011905e-01
      701  2010  372_2421551 MorisitaHornDiss  4.077024e-01 -5.496420e-03
      702  2010  372_2421551   BrayCurtisDiss  7.518248e-01  8.050142e-02
      703  2011  372_2421551      JaccardDiss  6.666667e-01  1.011905e-01
      704  2011  372_2421551 MorisitaHornDiss  6.605186e-01 -5.496420e-03
      705  2011  372_2421551   BrayCurtisDiss  7.068966e-01  8.050142e-02
      706  2010  372_2406229      JaccardDiss  3.555556e-01 -5.955125e-04
      707  2010  372_2406229 MorisitaHornDiss  4.562590e-01  6.530551e-02
      708  2010  372_2406229   BrayCurtisDiss  4.502203e-01  5.919049e-02
      709  2012  372_2406229      JaccardDiss  3.488372e-01 -5.955125e-04
      710  2012  372_2406229 MorisitaHornDiss  5.038662e-01  6.530551e-02
      711  2012  372_2406229   BrayCurtisDiss  5.124555e-01  5.919049e-02
      712  2011  372_2406229      JaccardDiss  3.571429e-01 -5.955125e-04
      713  2011  372_2406229 MorisitaHornDiss  3.911818e-01  6.530551e-02
      714  2011  372_2406229   BrayCurtisDiss  4.708603e-01  5.919049e-02
      715  2009  372_2406229      JaccardDiss  3.513514e-01 -5.955125e-04
      716  2009  372_2406229 MorisitaHornDiss  2.644888e-01  6.530551e-02
      717  2009  372_2406229   BrayCurtisDiss  3.220339e-01  5.919049e-02
      718  2010  372_2402583      JaccardDiss  3.333333e-01 -2.680808e-02
      719  2010  372_2402583 MorisitaHornDiss  1.353501e-01 -4.871120e-02
      720  2010  372_2402583   BrayCurtisDiss  3.032345e-01 -2.415584e-02
      721  2011  372_2402583      JaccardDiss  2.888889e-01 -2.680808e-02
      722  2011  372_2402583 MorisitaHornDiss  4.841321e-02 -4.871120e-02
      723  2011  372_2402583   BrayCurtisDiss  2.222951e-01 -2.415584e-02
      724  2009  372_2402583      JaccardDiss  4.545455e-01 -2.680808e-02
      725  2009  372_2402583 MorisitaHornDiss  2.791389e-01 -4.871120e-02
      726  2009  372_2402583   BrayCurtisDiss  3.542133e-01 -2.415584e-02
      727  2012  372_2402583      JaccardDiss  3.800000e-01 -2.680808e-02
      728  2012  372_2402583 MorisitaHornDiss  1.457472e-01 -4.871120e-02
      729  2012  372_2402583   BrayCurtisDiss  3.006736e-01 -2.415584e-02
      730  2009  372_2425903      JaccardDiss  3.111111e-01 -2.140921e-02
      731  2009  372_2425903 MorisitaHornDiss  1.305762e-01  5.669685e-02
      732  2009  372_2425903   BrayCurtisDiss  2.813559e-01  2.951231e-02
      733  2010  372_2425903      JaccardDiss  2.500000e-01 -2.140921e-02
      734  2010  372_2425903 MorisitaHornDiss  4.271234e-01  5.669685e-02
      735  2010  372_2425903   BrayCurtisDiss  3.866906e-01  2.951231e-02
      736  2011  372_2425903      JaccardDiss  2.682927e-01 -2.140921e-02
      737  2011  372_2425903 MorisitaHornDiss  2.439699e-01  5.669685e-02
      738  2011  372_2425903   BrayCurtisDiss  3.403805e-01  2.951231e-02
      739  2009  372_2426633      JaccardDiss  2.352941e-01  4.726319e-02
      740  2009  372_2426633 MorisitaHornDiss  4.865003e-01 -5.363214e-02
      741  2009  372_2426633   BrayCurtisDiss  5.675199e-01 -7.842308e-03
      742  2010  372_2426633      JaccardDiss  3.720930e-01  4.726319e-02
      743  2010  372_2426633 MorisitaHornDiss  4.150950e-01 -5.363214e-02
      744  2010  372_2426633   BrayCurtisDiss  3.596939e-01 -7.842308e-03
      745  2011  372_2426633      JaccardDiss  4.736842e-01  4.726319e-02
      746  2011  372_2426633 MorisitaHornDiss  6.010619e-01 -5.363214e-02
      747  2011  372_2426633   BrayCurtisDiss  5.612403e-01 -7.842308e-03
      748  2012  372_2426633      JaccardDiss  3.589744e-01  4.726319e-02
      749  2012  372_2426633 MorisitaHornDiss  2.457375e-01 -5.363214e-02
      750  2012  372_2426633   BrayCurtisDiss  4.741967e-01 -7.842308e-03
      751  2010  372_2403302      JaccardDiss  5.172414e-01 -7.516858e-02
      752  2010  372_2403302 MorisitaHornDiss  1.115679e-01  1.502112e-02
      753  2010  372_2403302   BrayCurtisDiss  2.962025e-01 -8.919838e-02
      754  2011  372_2403302      JaccardDiss  5.555556e-01 -7.516858e-02
      755  2011  372_2403302 MorisitaHornDiss  3.521035e-01  1.502112e-02
      756  2011  372_2403302   BrayCurtisDiss  4.952681e-01 -8.919838e-02
      757  2009  372_2403302      JaccardDiss  6.800000e-01 -7.516858e-02
      758  2009  372_2403302 MorisitaHornDiss  3.027402e-01  1.502112e-02
      759  2009  372_2403302   BrayCurtisDiss  7.942387e-01 -8.919838e-02
      760  2012  372_2403302      JaccardDiss  4.166667e-01 -7.516858e-02
      761  2012  372_2403302 MorisitaHornDiss  2.726321e-01  1.502112e-02
      762  2012  372_2403302   BrayCurtisDiss  4.305556e-01 -8.919838e-02
      763  2008  372_2369058      JaccardDiss  4.827586e-01  2.024033e-02
      764  2008  372_2369058 MorisitaHornDiss  2.054135e-01 -2.464217e-02
      765  2008  372_2369058   BrayCurtisDiss  3.673966e-01  2.645858e-02
      766  2009  372_2369058      JaccardDiss  6.896552e-01  2.024033e-02
      767  2009  372_2369058 MorisitaHornDiss  3.942345e-01 -2.464217e-02
      768  2009  372_2369058   BrayCurtisDiss  6.377358e-01  2.645858e-02
      769  2011  372_2369058      JaccardDiss  7.666667e-01  2.024033e-02
      770  2011  372_2369058 MorisitaHornDiss  2.225812e-01 -2.464217e-02
      771  2011  372_2369058   BrayCurtisDiss  4.823529e-01  2.645858e-02
      772  2010  372_2369058      JaccardDiss  7.727273e-01  2.024033e-02
      773  2010  372_2369058 MorisitaHornDiss  7.543740e-01 -2.464217e-02
      774  2010  372_2369058   BrayCurtisDiss  8.557692e-01  2.645858e-02
      775  2012  372_2369058      JaccardDiss  5.454545e-01  2.024033e-02
      776  2012  372_2369058 MorisitaHornDiss  1.680292e-01 -2.464217e-02
      777  2012  372_2369058   BrayCurtisDiss  5.773810e-01  2.645858e-02
      778  2005  372_2399671      JaccardDiss  4.074074e-01 -1.060791e-02
      779  2005  372_2399671 MorisitaHornDiss  1.352009e-01  3.955357e-02
      780  2005  372_2399671   BrayCurtisDiss  3.856502e-01  9.839510e-03
      781  2006  372_2399671      JaccardDiss  2.727273e-01 -1.060791e-02
      782  2006  372_2399671 MorisitaHornDiss  2.910512e-01  3.955357e-02
      783  2006  372_2399671   BrayCurtisDiss  5.088608e-01  9.839510e-03
      784  2007  372_2399671      JaccardDiss  4.333333e-01 -1.060791e-02
      785  2007  372_2399671 MorisitaHornDiss  2.433083e-01  3.955357e-02
      786  2007  372_2399671   BrayCurtisDiss  3.823088e-01  9.839510e-03
      787  2008  372_2399671      JaccardDiss  5.161290e-01 -1.060791e-02
      788  2008  372_2399671 MorisitaHornDiss  5.080315e-01  3.955357e-02
      789  2008  372_2399671   BrayCurtisDiss  5.816327e-01  9.839510e-03
      790  2009  372_2399671      JaccardDiss  6.000000e-01 -1.060791e-02
      791  2009  372_2399671 MorisitaHornDiss  4.503323e-01  3.955357e-02
      792  2009  372_2399671   BrayCurtisDiss  6.086022e-01  9.839510e-03
      793  2010  372_2399671      JaccardDiss  4.516129e-01 -1.060791e-02
      794  2010  372_2399671 MorisitaHornDiss  5.743516e-01  3.955357e-02
      795  2010  372_2399671   BrayCurtisDiss  6.727273e-01  9.839510e-03
      796  2011  372_2399671      JaccardDiss  3.571429e-01 -1.060791e-02
      797  2011  372_2399671 MorisitaHornDiss  7.592145e-01  3.955357e-02
      798  2011  372_2399671   BrayCurtisDiss  6.188679e-01  9.839510e-03
      799  2012  372_2399671      JaccardDiss  2.000000e-01 -1.060791e-02
      800  2012  372_2399671 MorisitaHornDiss  1.418084e-01  3.955357e-02
      801  2012  372_2399671   BrayCurtisDiss  2.968300e-01  9.839510e-03
      802  2007  372_2431035      JaccardDiss  6.521739e-01 -2.562720e-03
      803  2007  372_2431035 MorisitaHornDiss  5.810600e-01  7.783757e-03
      804  2007  372_2431035   BrayCurtisDiss  5.396825e-01  1.231788e-02
      805  2008  372_2431035      JaccardDiss  7.941176e-01 -2.562720e-03
      806  2008  372_2431035 MorisitaHornDiss  8.475527e-01  7.783757e-03
      807  2008  372_2431035   BrayCurtisDiss  8.909091e-01  1.231788e-02
      808  2009  372_2431035      JaccardDiss  6.400000e-01 -2.562720e-03
      809  2009  372_2431035 MorisitaHornDiss  6.148699e-01  7.783757e-03
      810  2009  372_2431035   BrayCurtisDiss  5.733333e-01  1.231788e-02
      811  2010  372_2431035      JaccardDiss  6.521739e-01 -2.562720e-03
      812  2010  372_2431035 MorisitaHornDiss  5.711813e-01  7.783757e-03
      813  2010  372_2431035   BrayCurtisDiss  5.284553e-01  1.231788e-02
      814  2011  372_2431035      JaccardDiss  6.190476e-01 -2.562720e-03
      815  2011  372_2431035 MorisitaHornDiss  5.345025e-01  7.783757e-03
      816  2011  372_2431035   BrayCurtisDiss  5.312500e-01  1.231788e-02
      817  2012  372_2431035      JaccardDiss  7.368421e-01 -2.562720e-03
      818  2012  372_2431035 MorisitaHornDiss  8.321142e-01  7.783757e-03
      819  2012  372_2431035   BrayCurtisDiss  8.506787e-01  1.231788e-02
      820  2009  372_2443467      JaccardDiss  7.333333e-01  1.324384e-02
      821  2009  372_2443467 MorisitaHornDiss  7.062295e-01  5.234463e-02
      822  2009  372_2443467   BrayCurtisDiss  7.587940e-01  2.725155e-02
      823  2012  372_2443467      JaccardDiss  2.903226e-01  1.324384e-02
      824  2012  372_2443467 MorisitaHornDiss  2.117801e-01  5.234463e-02
      825  2012  372_2443467   BrayCurtisDiss  3.307985e-01  2.725155e-02
      826  2008  372_2443467      JaccardDiss  4.615385e-01  1.324384e-02
      827  2008  372_2443467 MorisitaHornDiss  1.791790e-01  5.234463e-02
      828  2008  372_2443467   BrayCurtisDiss  4.006116e-01  2.725155e-02
      829  2007  372_2443467      JaccardDiss  4.000000e-01  1.324384e-02
      830  2007  372_2443467 MorisitaHornDiss  1.541727e-01  5.234463e-02
      831  2007  372_2443467   BrayCurtisDiss  3.355932e-01  2.725155e-02
      832  2010  372_2443467      JaccardDiss  8.571429e-01  1.324384e-02
      833  2010  372_2443467 MorisitaHornDiss  9.231193e-01  5.234463e-02
      834  2010  372_2443467   BrayCurtisDiss  9.186047e-01  2.725155e-02
      835  2011  372_2443467      JaccardDiss  7.575758e-01  1.324384e-02
      836  2011  372_2443467 MorisitaHornDiss  6.215575e-01  5.234463e-02
      837  2011  372_2443467   BrayCurtisDiss  6.732673e-01  2.725155e-02
      838  2008  372_2393839      JaccardDiss  4.482759e-01  5.224660e-03
      839  2008  372_2393839 MorisitaHornDiss  2.485045e-01 -3.410366e-02
      840  2008  372_2393839   BrayCurtisDiss  4.054054e-01 -5.376214e-03
      841  2009  372_2393839      JaccardDiss  3.030303e-01  5.224660e-03
      842  2009  372_2393839 MorisitaHornDiss  2.342640e-01 -3.410366e-02
      843  2009  372_2393839   BrayCurtisDiss  3.634686e-01 -5.376214e-03
      844  2010  372_2393839      JaccardDiss  4.705882e-01  5.224660e-03
      845  2010  372_2393839 MorisitaHornDiss  1.736946e-01 -3.410366e-02
      846  2010  372_2393839   BrayCurtisDiss  3.277662e-01 -5.376214e-03
      847  2011  372_2393839      JaccardDiss  3.823529e-01  5.224660e-03
      848  2011  372_2393839 MorisitaHornDiss  8.263330e-02 -3.410366e-02
      849  2011  372_2393839   BrayCurtisDiss  2.611718e-01 -5.376214e-03
      850  2012  372_2393839      JaccardDiss  5.294118e-01  5.224660e-03
      851  2012  372_2393839 MorisitaHornDiss  2.085639e-01 -3.410366e-02
      852  2012  372_2393839   BrayCurtisDiss  3.950762e-01 -5.376214e-03
      853  2013  372_2393839      JaccardDiss  3.666667e-01  5.224660e-03
      854  2013  372_2393839 MorisitaHornDiss  4.341111e-02 -3.410366e-02
      855  2013  372_2393839   BrayCurtisDiss  3.621262e-01 -5.376214e-03
      856  2012  372_2362487      JaccardDiss  5.641026e-01  2.471284e-02
      857  2012  372_2362487 MorisitaHornDiss  3.511405e-01 -4.745260e-02
      858  2012  372_2362487   BrayCurtisDiss  4.272864e-01 -3.125001e-02
      859  2008  372_2362487      JaccardDiss  5.128205e-01  2.471284e-02
      860  2008  372_2362487 MorisitaHornDiss  5.858783e-01 -4.745260e-02
      861  2008  372_2362487   BrayCurtisDiss  6.043956e-01 -3.125001e-02
      862  2011  372_2362487      JaccardDiss  7.058824e-01  2.471284e-02
      863  2011  372_2362487 MorisitaHornDiss  5.558392e-01 -4.745260e-02
      864  2011  372_2362487   BrayCurtisDiss  6.409186e-01 -3.125001e-02
      865  2008  372_2409874      JaccardDiss  3.928571e-01  4.565048e-03
      866  2008  372_2409874 MorisitaHornDiss  2.265213e-01  6.694686e-02
      867  2008  372_2409874   BrayCurtisDiss  3.647799e-01  4.857136e-02
      868  2009  372_2409874      JaccardDiss  3.200000e-01  4.565048e-03
      869  2009  372_2409874 MorisitaHornDiss  3.284644e-01  6.694686e-02
      870  2009  372_2409874   BrayCurtisDiss  4.101695e-01  4.857136e-02
      871  2010  372_2409874      JaccardDiss  4.000000e-01  4.565048e-03
      872  2010  372_2409874 MorisitaHornDiss  3.719931e-01  6.694686e-02
      873  2010  372_2409874   BrayCurtisDiss  4.755784e-01  4.857136e-02
      874  2011  372_2409874      JaccardDiss  6.129032e-01  4.565048e-03
      875  2011  372_2409874 MorisitaHornDiss  4.409938e-01  6.694686e-02
      876  2011  372_2409874   BrayCurtisDiss  5.836177e-01  4.857136e-02
      877  2012  372_2409874      JaccardDiss  2.692308e-01  4.565048e-03
      878  2012  372_2409874 MorisitaHornDiss  5.049909e-01  6.694686e-02
      879  2012  372_2409874   BrayCurtisDiss  5.209125e-01  4.857136e-02
      880  2008  372_2452208      JaccardDiss  3.958333e-01  1.423758e-02
      881  2008  372_2452208 MorisitaHornDiss  2.281904e-01  2.447692e-02
      882  2008  372_2452208   BrayCurtisDiss  3.275362e-01  2.515234e-02
      883  2009  372_2452208      JaccardDiss  4.583333e-01  1.423758e-02
      884  2009  372_2452208 MorisitaHornDiss  1.471027e-01  2.447692e-02
      885  2009  372_2452208   BrayCurtisDiss  3.207547e-01  2.515234e-02
      886  2010  372_2452208      JaccardDiss  4.130435e-01  1.423758e-02
      887  2010  372_2452208 MorisitaHornDiss  1.313581e-01  2.447692e-02
      888  2010  372_2452208   BrayCurtisDiss  3.620955e-01  2.515234e-02
      889  2011  372_2452208      JaccardDiss  4.489796e-01  1.423758e-02
      890  2011  372_2452208 MorisitaHornDiss  1.185144e-01  2.447692e-02
      891  2011  372_2452208   BrayCurtisDiss  3.661202e-01  2.515234e-02
      892  2012  372_2452208      JaccardDiss  4.716981e-01  1.423758e-02
      893  2012  372_2452208 MorisitaHornDiss  3.648692e-01  2.447692e-02
      894  2012  372_2452208   BrayCurtisDiss  4.306152e-01  2.515234e-02
      895  2009  372_2379269      JaccardDiss  6.923077e-01 -1.111040e-01
      896  2009  372_2379269 MorisitaHornDiss  4.672055e-01 -1.159919e-01
      897  2009  372_2379269   BrayCurtisDiss  6.909621e-01 -1.292971e-01
      898  2010  372_2379269      JaccardDiss  6.829268e-01 -1.111040e-01
      899  2010  372_2379269 MorisitaHornDiss  4.060407e-01 -1.159919e-01
      900  2010  372_2379269   BrayCurtisDiss  5.932203e-01 -1.292971e-01
      901  2011  372_2379269      JaccardDiss  5.238095e-01 -1.111040e-01
      902  2011  372_2379269 MorisitaHornDiss  3.701598e-01 -1.159919e-01
      903  2011  372_2379269   BrayCurtisDiss  4.642517e-01 -1.292971e-01
      904  2012  372_2379269      JaccardDiss  3.750000e-01 -1.111040e-01
      905  2012  372_2379269 MorisitaHornDiss  9.252597e-02 -1.159919e-01
      906  2012  372_2379269   BrayCurtisDiss  3.029613e-01 -1.292971e-01
      907  2009  372_2441280      JaccardDiss  3.725490e-01  3.856105e-02
      908  2009  372_2441280 MorisitaHornDiss  2.651530e-01  1.341167e-02
      909  2009  372_2441280   BrayCurtisDiss  4.406580e-01 -3.614867e-03
      910  2010  372_2441280      JaccardDiss  3.200000e-01  3.856105e-02
      911  2010  372_2441280 MorisitaHornDiss  2.233589e-01  1.341167e-02
      912  2010  372_2441280   BrayCurtisDiss  3.682310e-01 -3.614867e-03
      913  2011  372_2441280      JaccardDiss  4.081633e-01  3.856105e-02
      914  2011  372_2441280 MorisitaHornDiss  1.878986e-01  1.341167e-02
      915  2011  372_2441280   BrayCurtisDiss  3.429454e-01 -3.614867e-03
      916  2012  372_2441280      JaccardDiss  4.716981e-01  3.856105e-02
      917  2012  372_2441280 MorisitaHornDiss  3.216787e-01  1.341167e-02
      918  2012  372_2441280   BrayCurtisDiss  4.370370e-01 -3.614867e-03
      919  2009  372_2442005      JaccardDiss  5.000000e-01  9.998646e-03
      920  2009  372_2442005 MorisitaHornDiss  1.184970e-01  1.717299e-01
      921  2009  372_2442005   BrayCurtisDiss  4.302789e-01  5.828469e-02
      922  2010  372_2442005      JaccardDiss  4.347826e-01  9.998646e-03
      923  2010  372_2442005 MorisitaHornDiss  9.429625e-01  1.717299e-01
      924  2010  372_2442005   BrayCurtisDiss  7.015755e-01  5.828469e-02
      925  2011  372_2442005      JaccardDiss  4.390244e-01  9.998646e-03
      926  2011  372_2442005 MorisitaHornDiss  2.046165e-01  1.717299e-01
      927  2011  372_2442005   BrayCurtisDiss  3.652482e-01  5.828469e-02
      928  2012  372_2442005      JaccardDiss  5.319149e-01  9.998646e-03
      929  2012  372_2442005 MorisitaHornDiss  9.370455e-01  1.717299e-01
      930  2012  372_2442005   BrayCurtisDiss  7.366703e-01  5.828469e-02
      931  2008  372_2439790      JaccardDiss  4.583333e-01  3.825959e-02
      932  2008  372_2439790 MorisitaHornDiss  1.470732e-01 -8.020716e-05
      933  2008  372_2439790   BrayCurtisDiss  3.154762e-01  1.304443e-02
      934  2011  372_2439790      JaccardDiss  6.296296e-01  3.825959e-02
      935  2011  372_2439790 MorisitaHornDiss  1.798636e-01 -8.020716e-05
      936  2011  372_2439790   BrayCurtisDiss  3.644860e-01  1.304443e-02
      937  2009  372_2439790      JaccardDiss  7.096774e-01  3.825959e-02
      938  2009  372_2439790 MorisitaHornDiss  2.812143e-01 -8.020716e-05
      939  2009  372_2439790   BrayCurtisDiss  4.777070e-01  1.304443e-02
      940  2012  372_2439790      JaccardDiss  6.896552e-01  3.825959e-02
      941  2012  372_2439790 MorisitaHornDiss  1.973475e-01 -8.020716e-05
      942  2012  372_2439790   BrayCurtisDiss  4.373089e-01  1.304443e-02
      943  2010  372_2439790      JaccardDiss  5.714286e-01  3.825959e-02
      944  2010  372_2439790 MorisitaHornDiss  3.314556e-01 -8.020716e-05
      945  2010  372_2439790   BrayCurtisDiss  4.400000e-01  1.304443e-02
      946  2010  372_2437599      JaccardDiss  4.444444e-01 -4.522559e-02
      947  2010  372_2437599 MorisitaHornDiss  9.520270e-02 -7.394189e-02
      948  2010  372_2437599   BrayCurtisDiss  3.846154e-01 -5.554443e-02
      949  2012  372_2437599      JaccardDiss  4.800000e-01 -4.522559e-02
      950  2012  372_2437599 MorisitaHornDiss  8.951063e-02 -7.394189e-02
      951  2012  372_2437599   BrayCurtisDiss  2.962963e-01 -5.554443e-02
      952  2009  372_2437599      JaccardDiss  6.060606e-01 -4.522559e-02
      953  2009  372_2437599 MorisitaHornDiss  3.535742e-01 -7.394189e-02
      954  2009  372_2437599   BrayCurtisDiss  5.040000e-01 -5.554443e-02
      955  2011  372_2437599      JaccardDiss  3.703704e-01 -4.522559e-02
      956  2011  372_2437599 MorisitaHornDiss  1.479745e-01 -7.394189e-02
      957  2011  372_2437599   BrayCurtisDiss  4.522822e-01 -5.554443e-02
      958  2009  372_2433956      JaccardDiss  5.333333e-01 -7.701149e-02
      959  2009  372_2433956 MorisitaHornDiss  1.930995e-01 -1.389937e-02
      960  2009  372_2433956   BrayCurtisDiss  5.802469e-01 -1.420971e-01
      961  2011  372_2433956      JaccardDiss  3.793103e-01 -7.701149e-02
      962  2011  372_2433956 MorisitaHornDiss  1.653008e-01 -1.389937e-02
      963  2011  372_2433956   BrayCurtisDiss  2.960526e-01 -1.420971e-01
      964  2010  372_2433956      JaccardDiss  4.285714e-01 -7.701149e-02
      965  2010  372_2433956 MorisitaHornDiss  1.879623e-01 -1.389937e-02
      966  2010  372_2433956   BrayCurtisDiss  4.792899e-01 -1.420971e-01
      967  2009  372_2435398      JaccardDiss  4.468085e-01 -2.767992e-02
      968  2009  372_2435398 MorisitaHornDiss  4.553246e-02  2.546496e-02
      969  2009  372_2435398   BrayCurtisDiss  1.860649e-01  5.507351e-02
      970  2010  372_2435398      JaccardDiss  3.095238e-01 -2.767992e-02
      971  2010  372_2435398 MorisitaHornDiss  1.619983e-01  2.546496e-02
      972  2010  372_2435398   BrayCurtisDiss  4.082247e-01  5.507351e-02
      973  2011  372_2435398      JaccardDiss  4.186047e-01 -2.767992e-02
      974  2011  372_2435398 MorisitaHornDiss  1.621831e-01  2.546496e-02
      975  2011  372_2435398   BrayCurtisDiss  3.400922e-01  5.507351e-02
      976  2012  372_2435398      JaccardDiss  3.181818e-01 -2.767992e-02
      977  2012  372_2435398 MorisitaHornDiss  1.303540e-01  2.546496e-02
      978  2012  372_2435398   BrayCurtisDiss  3.923541e-01  5.507351e-02
      979  2008  372_2425178      JaccardDiss  4.411765e-01  3.247097e-03
      980  2008  372_2425178 MorisitaHornDiss  7.068601e-01  1.488814e-02
      981  2008  372_2425178   BrayCurtisDiss  5.502646e-01  1.039753e-02
      982  2009  372_2425178      JaccardDiss  4.545455e-01  3.247097e-03
      983  2009  372_2425178 MorisitaHornDiss  1.924112e-01  1.488814e-02
      984  2009  372_2425178   BrayCurtisDiss  3.571429e-01  1.039753e-02
      985  2011  372_2425178      JaccardDiss  7.027027e-01  3.247097e-03
      986  2011  372_2425178 MorisitaHornDiss  2.316990e-01  1.488814e-02
      987  2011  372_2425178   BrayCurtisDiss  4.350649e-01  1.039753e-02
      988  2010  372_2425178      JaccardDiss  7.222222e-01  3.247097e-03
      989  2010  372_2425178 MorisitaHornDiss  3.321257e-01  1.488814e-02
      990  2010  372_2425178   BrayCurtisDiss  5.522388e-01  1.039753e-02
      991  2012  372_2425178      JaccardDiss  3.333333e-01  3.247097e-03
      992  2012  372_2425178 MorisitaHornDiss  7.616569e-01  1.488814e-02
      993  2012  372_2425178   BrayCurtisDiss  5.632911e-01  1.039753e-02
      994  2009  372_2426634      JaccardDiss  2.051282e-01  2.684408e-02
      995  2009  372_2426634 MorisitaHornDiss  2.674524e-02  1.950203e-02
      996  2009  372_2426634   BrayCurtisDiss  1.901860e-01  2.899412e-02
      997  2010  372_2426634      JaccardDiss  1.315789e-01  2.684408e-02
      998  2010  372_2426634 MorisitaHornDiss  1.757787e-02  1.950203e-02
      999  2010  372_2426634   BrayCurtisDiss  1.363902e-01  2.899412e-02
      1000 2011  372_2426634      JaccardDiss  2.105263e-01  2.684408e-02
      1001 2011  372_2426634 MorisitaHornDiss  1.397845e-01  1.950203e-02
      1002 2011  372_2426634   BrayCurtisDiss  3.527908e-01  2.899412e-02
      1003 2012  372_2426634      JaccardDiss  2.682927e-01  2.684408e-02
      1004 2012  372_2426634 MorisitaHornDiss  5.101645e-02  1.950203e-02
      1005 2012  372_2426634   BrayCurtisDiss  2.146996e-01  2.899412e-02
      1006 2009  372_2427362      JaccardDiss  3.928571e-01 -9.769799e-02
      1007 2009  372_2427362 MorisitaHornDiss  5.595981e-02  2.089290e-02
      1008 2009  372_2427362   BrayCurtisDiss  2.807646e-01 -1.163024e-02
      1009 2010  372_2427362      JaccardDiss  4.137931e-01 -9.769799e-02
      1010 2010  372_2427362 MorisitaHornDiss  1.190533e-01  2.089290e-02
      1011 2010  372_2427362   BrayCurtisDiss  3.647343e-01 -1.163024e-02
      1012 2011  372_2427362      JaccardDiss  2.692308e-01 -9.769799e-02
      1013 2011  372_2427362 MorisitaHornDiss  6.592983e-02  2.089290e-02
      1014 2011  372_2427362   BrayCurtisDiss  2.401628e-01 -1.163024e-02
      1015 2012  372_2427362      JaccardDiss  1.153846e-01 -9.769799e-02
      1016 2012  372_2427362 MorisitaHornDiss  1.433107e-01  2.089290e-02
      1017 2012  372_2427362   BrayCurtisDiss  2.835210e-01 -1.163024e-02
      1018 2008  372_2428818      JaccardDiss  4.333333e-01 -4.819865e-02
      1019 2008  372_2428818 MorisitaHornDiss  1.411430e-01 -2.424811e-02
      1020 2008  372_2428818   BrayCurtisDiss  3.174312e-01 -3.153648e-02
      1021 2010  372_2428818      JaccardDiss  5.333333e-01 -4.819865e-02
      1022 2010  372_2428818 MorisitaHornDiss  2.018504e-01 -2.424811e-02
      1023 2010  372_2428818   BrayCurtisDiss  3.673870e-01 -3.153648e-02
      1024 2009  372_2428818      JaccardDiss  6.060606e-01 -4.819865e-02
      1025 2009  372_2428818 MorisitaHornDiss  3.416210e-01 -2.424811e-02
      1026 2009  372_2428818   BrayCurtisDiss  4.863158e-01 -3.153648e-02
      1027 2011  372_2428818      JaccardDiss  4.074074e-01 -4.819865e-02
      1028 2011  372_2428818 MorisitaHornDiss  2.891853e-01 -2.424811e-02
      1029 2011  372_2428818   BrayCurtisDiss  4.371859e-01 -3.153648e-02
      1030 2012  372_2428818      JaccardDiss  2.916667e-01 -4.819865e-02
      1031 2012  372_2428818 MorisitaHornDiss  4.612032e-02 -2.424811e-02
      1032 2012  372_2428818   BrayCurtisDiss  1.843137e-01 -3.153648e-02
      1033 2009  372_2428817      JaccardDiss  4.583333e-01  3.439622e-02
      1034 2009  372_2428817 MorisitaHornDiss  2.545256e-01  2.787216e-02
      1035 2009  372_2428817   BrayCurtisDiss  5.768116e-01  1.800878e-02
      1036 2010  372_2428817      JaccardDiss  4.615385e-01  3.439622e-02
      1037 2010  372_2428817 MorisitaHornDiss  7.694123e-02  2.787216e-02
      1038 2010  372_2428817   BrayCurtisDiss  2.484600e-01  1.800878e-02
      1039 2011  372_2428817      JaccardDiss  4.848485e-01  3.439622e-02
      1040 2011  372_2428817 MorisitaHornDiss  1.207757e-01  2.787216e-02
      1041 2011  372_2428817   BrayCurtisDiss  2.941176e-01  1.800878e-02
      1042 2012  372_2428817      JaccardDiss  5.652174e-01  3.439622e-02
      1043 2012  372_2428817 MorisitaHornDiss  3.328213e-01  2.787216e-02
      1044 2012  372_2428817   BrayCurtisDiss  6.216216e-01  1.800878e-02
      1045 2009  372_2425199      JaccardDiss  3.043478e-01  4.771739e-02
      1046 2009  372_2425199 MorisitaHornDiss  4.918537e-02  2.172545e-01
      1047 2009  372_2425199   BrayCurtisDiss  1.986971e-01  1.320179e-01
      1048 2010  372_2425199      JaccardDiss  4.347826e-01  4.771739e-02
      1049 2010  372_2425199 MorisitaHornDiss  5.306276e-01  2.172545e-01
      1050 2010  372_2425199   BrayCurtisDiss  5.045317e-01  1.320179e-01
      1051 2011  372_2425199      JaccardDiss  7.000000e-01  4.771739e-02
      1052 2011  372_2425199 MorisitaHornDiss  6.808523e-01  2.172545e-01
      1053 2011  372_2425199   BrayCurtisDiss  8.484848e-01  1.320179e-01
      1054 2012  372_2425199      JaccardDiss  3.750000e-01  4.771739e-02
      1055 2012  372_2425199 MorisitaHornDiss  7.232922e-01  2.172545e-01
      1056 2012  372_2425199   BrayCurtisDiss  5.241058e-01  1.320179e-01
      1057 2009  372_2423009      JaccardDiss  5.000000e-01 -7.331378e-03
      1058 2009  372_2423009 MorisitaHornDiss  1.658926e-01 -4.214438e-03
      1059 2009  372_2423009   BrayCurtisDiss  3.981481e-01  1.091188e-02
      1060 2010  372_2423009      JaccardDiss  7.272727e-01 -7.331378e-03
      1061 2010  372_2423009 MorisitaHornDiss  9.604082e-01 -4.214438e-03
      1062 2010  372_2423009   BrayCurtisDiss  9.018759e-01  1.091188e-02
      1063 2008  372_2423009      JaccardDiss  7.419355e-01 -7.331378e-03
      1064 2008  372_2423009 MorisitaHornDiss  9.688371e-01 -4.214438e-03
      1065 2008  372_2423009   BrayCurtisDiss  8.800522e-01  1.091188e-02
      1066 2011  372_2404057      JaccardDiss  2.500000e-01 -4.814815e-02
      1067 2011  372_2404057 MorisitaHornDiss  8.492612e-02  1.619126e-02
      1068 2011  372_2404057   BrayCurtisDiss  3.544828e-01  1.114364e-01
      1069 2012  372_2404057      JaccardDiss  2.000000e-01 -4.814815e-02
      1070 2012  372_2404057 MorisitaHornDiss  1.336028e-01  1.619126e-02
      1071 2012  372_2404057   BrayCurtisDiss  5.099541e-01  1.114364e-01
      1072 2010  372_2404057      JaccardDiss  2.962963e-01 -4.814815e-02
      1073 2010  372_2404057 MorisitaHornDiss  1.012203e-01  1.619126e-02
      1074 2010  372_2404057   BrayCurtisDiss  2.870813e-01  1.114364e-01
      1075 2008  372_2412081      JaccardDiss  0.000000e+00  3.055556e-01
      1076 2008  372_2412081 MorisitaHornDiss  2.733321e-03  1.154008e-01
      1077 2008  372_2412081   BrayCurtisDiss  7.612457e-02  2.130793e-01
      1078 2009  372_2412081      JaccardDiss  6.111111e-01  3.055556e-01
      1079 2009  372_2412081 MorisitaHornDiss  2.238176e-01  1.154008e-01
      1080 2009  372_2412081   BrayCurtisDiss  5.228216e-01  2.130793e-01
      1081 2010  372_2412081      JaccardDiss  6.111111e-01  3.055556e-01
      1082 2010  372_2412081 MorisitaHornDiss  2.335349e-01  1.154008e-01
      1083 2010  372_2412081   BrayCurtisDiss  5.022831e-01  2.130793e-01
      1084 2009  372_2419351      JaccardDiss  4.000000e-01 -1.124424e-02
      1085 2009  372_2419351 MorisitaHornDiss  1.201073e-01  1.086711e-01
      1086 2009  372_2419351   BrayCurtisDiss  2.921615e-01  6.591582e-02
      1087 2010  372_2419351      JaccardDiss  4.516129e-01 -1.124424e-02
      1088 2010  372_2419351 MorisitaHornDiss  3.540725e-01  1.086711e-01
      1089 2010  372_2419351   BrayCurtisDiss  4.691943e-01  6.591582e-02
      1090 2011  372_2419351      JaccardDiss  5.714286e-01 -1.124424e-02
      1091 2011  372_2419351 MorisitaHornDiss  4.856951e-01  1.086711e-01
      1092 2011  372_2419351   BrayCurtisDiss  5.891892e-01  6.591582e-02
      1093 2012  372_2419351      JaccardDiss  3.225806e-01 -1.124424e-02
      1094 2012  372_2419351 MorisitaHornDiss  4.384700e-01  1.086711e-01
      1095 2012  372_2419351   BrayCurtisDiss  4.718826e-01  6.591582e-02
      1096 2008  372_2418626      JaccardDiss  5.000000e-01  2.675214e-02
      1097 2008  372_2418626 MorisitaHornDiss  1.932432e-01  4.657165e-02
      1098 2008  372_2418626   BrayCurtisDiss  4.104478e-01  5.217656e-02
      1099 2009  372_2418626      JaccardDiss  5.769231e-01  2.675214e-02
      1100 2009  372_2418626 MorisitaHornDiss  1.602843e-01  4.657165e-02
      1101 2009  372_2418626   BrayCurtisDiss  3.353116e-01  5.217656e-02
      1102 2010  372_2418626      JaccardDiss  7.741935e-01  2.675214e-02
      1103 2010  372_2418626 MorisitaHornDiss  8.398978e-01  4.657165e-02
      1104 2010  372_2418626   BrayCurtisDiss  7.660377e-01  5.217656e-02
      1105 2011  372_2418626      JaccardDiss  7.777778e-01  2.675214e-02
      1106 2011  372_2418626 MorisitaHornDiss  8.706353e-01  4.657165e-02
      1107 2011  372_2418626   BrayCurtisDiss  8.148148e-01  5.217656e-02
      1108 2012  372_2418626      JaccardDiss  5.333333e-01  2.675214e-02
      1109 2012  372_2418626 MorisitaHornDiss  7.092588e-02  4.657165e-02
      1110 2012  372_2418626   BrayCurtisDiss  4.315789e-01  5.217656e-02
      1111 2012  372_2409154      JaccardDiss  8.571429e-01  8.241758e-02
      1112 2012  372_2409154 MorisitaHornDiss  9.202249e-01  1.538714e-02
      1113 2012  372_2409154   BrayCurtisDiss  8.833333e-01  4.833333e-02
      1114 2011  372_2409154      JaccardDiss  7.500000e-01  8.241758e-02
      1115 2011  372_2409154 MorisitaHornDiss  6.929362e-01  1.538714e-02
      1116 2011  372_2409154   BrayCurtisDiss  7.364341e-01  4.833333e-02
      1117 2010  372_2409154      JaccardDiss  6.923077e-01  8.241758e-02
      1118 2010  372_2409154 MorisitaHornDiss  8.894506e-01  1.538714e-02
      1119 2010  372_2409154   BrayCurtisDiss  7.866667e-01  4.833333e-02
      1120 2009  372_2403315      JaccardDiss  4.716981e-01  1.501231e-02
      1121 2009  372_2403315 MorisitaHornDiss  1.800569e-01  1.465136e-02
      1122 2009  372_2403315   BrayCurtisDiss  3.270736e-01  1.707517e-02
      1123 2010  372_2403315      JaccardDiss  3.269231e-01  1.501231e-02
      1124 2010  372_2403315 MorisitaHornDiss  1.352085e-01  1.465136e-02
      1125 2010  372_2403315   BrayCurtisDiss  4.404973e-01  1.707517e-02
      1126 2011  372_2403315      JaccardDiss  3.269231e-01  1.501231e-02
      1127 2011  372_2403315 MorisitaHornDiss  2.811926e-01  1.465136e-02
      1128 2011  372_2403315   BrayCurtisDiss  4.429370e-01  1.707517e-02
      1129 2012  372_2403315      JaccardDiss  5.217391e-01  1.501231e-02
      1130 2012  372_2403315 MorisitaHornDiss  1.802334e-01  1.465136e-02
      1131 2012  372_2403315   BrayCurtisDiss  3.831776e-01  1.707517e-02
      1132 2009  372_2400400      JaccardDiss  4.736842e-01 -1.197160e-02
      1133 2009  372_2400400 MorisitaHornDiss  4.254107e-01 -3.070471e-02
      1134 2009  372_2400400   BrayCurtisDiss  5.267176e-01 -1.644182e-02
      1135 2010  372_2400400      JaccardDiss  4.705882e-01 -1.197160e-02
      1136 2010  372_2400400 MorisitaHornDiss  5.130669e-01 -3.070471e-02
      1137 2010  372_2400400   BrayCurtisDiss  6.260163e-01 -1.644182e-02
      1138 2012  372_2400400      JaccardDiss  4.666667e-01 -1.197160e-02
      1139 2012  372_2400400 MorisitaHornDiss  3.644333e-01 -3.070471e-02
      1140 2012  372_2400400   BrayCurtisDiss  5.185185e-01 -1.644182e-02
      1141 2008  372_2400400      JaccardDiss  4.285714e-01 -1.197160e-02
      1142 2008  372_2400400 MorisitaHornDiss  4.890925e-01 -3.070471e-02
      1143 2008  372_2400400   BrayCurtisDiss  5.238095e-01 -1.644182e-02
      1144 2011  372_2400400      JaccardDiss  2.777778e-01 -1.197160e-02
      1145 2011  372_2400400 MorisitaHornDiss  3.676820e-01 -3.070471e-02
      1146 2011  372_2400400   BrayCurtisDiss  3.728814e-01 -1.644182e-02
      1147 2010  372_2393850      JaccardDiss  4.137931e-01 -1.885947e-02
      1148 2010  372_2393850 MorisitaHornDiss  8.110272e-02 -3.452875e-02
      1149 2010  372_2393850   BrayCurtisDiss  3.175676e-01  4.323548e-03
      1150 2012  372_2393850      JaccardDiss  4.375000e-01 -1.885947e-02
      1151 2012  372_2393850 MorisitaHornDiss  7.250671e-02 -3.452875e-02
      1152 2012  372_2393850   BrayCurtisDiss  3.671875e-01  4.323548e-03
      1153 2009  372_2393850      JaccardDiss  4.814815e-01 -1.885947e-02
      1154 2009  372_2393850 MorisitaHornDiss  2.077675e-01 -3.452875e-02
      1155 2009  372_2393850   BrayCurtisDiss  3.520249e-01  4.323548e-03
      1156 2011  372_2393850      JaccardDiss  3.571429e-01 -1.885947e-02
      1157 2011  372_2393850 MorisitaHornDiss  1.415976e-01 -3.452875e-02
      1158 2011  372_2393850   BrayCurtisDiss  3.153153e-01  4.323548e-03
      1159 2008  372_2398940      JaccardDiss  4.255319e-01 -1.118064e-02
      1160 2008  372_2398940 MorisitaHornDiss  5.425655e-01  7.639250e-03
      1161 2008  372_2398940   BrayCurtisDiss  6.348774e-01  1.142780e-02
      1162 2009  372_2398940      JaccardDiss  3.529412e-01 -1.118064e-02
      1163 2009  372_2398940 MorisitaHornDiss  9.917019e-02  7.639250e-03
      1164 2009  372_2398940   BrayCurtisDiss  2.391858e-01  1.142780e-02
      1165 2010  372_2398940      JaccardDiss  5.531915e-01 -1.118064e-02
      1166 2010  372_2398940 MorisitaHornDiss  5.525126e-01  7.639250e-03
      1167 2010  372_2398940   BrayCurtisDiss  7.227723e-01  1.142780e-02
      1168 2011  372_2398940      JaccardDiss  4.255319e-01 -1.118064e-02
      1169 2011  372_2398940 MorisitaHornDiss  4.634528e-01  7.639250e-03
      1170 2011  372_2398940   BrayCurtisDiss  5.511182e-01  1.142780e-02
      1171 2012  372_2398940      JaccardDiss  3.333333e-01 -1.118064e-02
      1172 2012  372_2398940 MorisitaHornDiss  3.986204e-01  7.639250e-03
      1173 2012  372_2398940   BrayCurtisDiss  5.360502e-01  1.142780e-02
      1174 2010  372_2375616      JaccardDiss  5.714286e-01  1.680985e-01
      1175 2010  372_2375616 MorisitaHornDiss  1.313217e-01  1.358939e-01
      1176 2010  372_2375616   BrayCurtisDiss  3.589109e-01  1.406088e-01
      1177 2011  372_2375616      JaccardDiss  5.600000e-01  1.680985e-01
      1178 2011  372_2375616 MorisitaHornDiss  2.772760e-01  1.358939e-01
      1179 2011  372_2375616   BrayCurtisDiss  4.505495e-01  1.406088e-01
      1180 2012  372_2375616      JaccardDiss  7.241379e-01  1.680985e-01
      1181 2012  372_2375616 MorisitaHornDiss  4.481263e-01  1.358939e-01
      1182 2012  372_2375616   BrayCurtisDiss  6.276923e-01  1.406088e-01
      1183 2009  372_2375616      JaccardDiss  1.600000e-01  1.680985e-01
      1184 2009  372_2375616 MorisitaHornDiss  4.379822e-02  1.358939e-01
      1185 2009  372_2375616   BrayCurtisDiss  1.895425e-01  1.406088e-01
      1186 2009  372_2363236      JaccardDiss  3.658537e-01 -4.190119e-02
      1187 2009  372_2363236 MorisitaHornDiss  1.586114e-01  7.660150e-02
      1188 2009  372_2363236   BrayCurtisDiss  3.484295e-01  3.945431e-02
      1189 2010  372_2363236      JaccardDiss  2.702703e-01 -4.190119e-02
      1190 2010  372_2363236 MorisitaHornDiss  4.068590e-01  7.660150e-02
      1191 2010  372_2363236   BrayCurtisDiss  4.354354e-01  3.945431e-02
      1192 2011  372_2363236      JaccardDiss  2.820513e-01 -4.190119e-02
      1193 2011  372_2363236 MorisitaHornDiss  3.118144e-01  7.660150e-02
      1194 2011  372_2363236   BrayCurtisDiss  4.273381e-01  3.945431e-02
      1195 2009  372_2365397      JaccardDiss  5.294118e-01  7.987777e-02
      1196 2009  372_2365397 MorisitaHornDiss  4.240506e-01  9.318934e-02
      1197 2009  372_2365397   BrayCurtisDiss  5.882353e-01  4.531129e-02
      1198 2011  372_2365397      JaccardDiss  7.142857e-01  7.987777e-02
      1199 2011  372_2365397 MorisitaHornDiss  5.491115e-01  9.318934e-02
      1200 2011  372_2365397   BrayCurtisDiss  6.666667e-01  4.531129e-02
      1201 2012  372_2365397      JaccardDiss  8.000000e-01  7.987777e-02
      1202 2012  372_2365397 MorisitaHornDiss  7.697368e-01  9.318934e-02
      1203 2012  372_2365397   BrayCurtisDiss  7.428571e-01  4.531129e-02
      1204 2010  372_2365397      JaccardDiss  7.272727e-01  7.987777e-02
      1205 2010  372_2365397 MorisitaHornDiss  6.542768e-01  9.318934e-02
      1206 2010  372_2365397   BrayCurtisDiss  6.774194e-01  4.531129e-02
      1207 2009  372_2434649      JaccardDiss  4.705882e-01  1.463890e-02
      1208 2009  372_2434649 MorisitaHornDiss  3.879873e-01  5.507792e-02
      1209 2009  372_2434649   BrayCurtisDiss  5.000000e-01  2.377130e-02
      1210 2012  372_2434649      JaccardDiss  7.142857e-01  1.463890e-02
      1211 2012  372_2434649 MorisitaHornDiss  6.353000e-01  5.507792e-02
      1212 2012  372_2434649   BrayCurtisDiss  7.706422e-01  2.377130e-02
      1213 2010  372_2434649      JaccardDiss  2.857143e-01  1.463890e-02
      1214 2010  372_2434649 MorisitaHornDiss  7.052090e-01  5.507792e-02
      1215 2010  372_2434649   BrayCurtisDiss  6.040609e-01  2.377130e-02
      1216 2011  372_2434649      JaccardDiss  6.666667e-01  1.463890e-02
      1217 2011  372_2434649 MorisitaHornDiss  5.900054e-01  5.507792e-02
      1218 2011  372_2434649   BrayCurtisDiss  6.250000e-01  2.377130e-02
      1219 2008  372_2434649      JaccardDiss  7.391304e-01  1.463890e-02
      1220 2008  372_2434649 MorisitaHornDiss  4.609194e-01  5.507792e-02
      1221 2008  372_2434649   BrayCurtisDiss  7.142857e-01  2.377130e-02
      1222 2006  372_2432468      JaccardDiss  0.000000e+00  1.785714e-02
      1223 2006  372_2432468 MorisitaHornDiss  0.000000e+00 -2.668053e-02
      1224 2006  372_2432468   BrayCurtisDiss  0.000000e+00  2.126770e-02
      1225 2007  372_2432468      JaccardDiss  0.000000e+00  1.785714e-02
      1226 2007  372_2432468 MorisitaHornDiss  0.000000e+00 -2.668053e-02
      1227 2007  372_2432468   BrayCurtisDiss  6.000000e-01  2.126770e-02
      1228 2008  372_2432468      JaccardDiss  5.000000e-01  1.785714e-02
      1229 2008  372_2432468 MorisitaHornDiss  9.009009e-01 -2.668053e-02
      1230 2008  372_2432468   BrayCurtisDiss  8.378378e-01  2.126770e-02
      1231 2009  372_2432468      JaccardDiss  0.000000e+00  1.785714e-02
      1232 2009  372_2432468 MorisitaHornDiss  0.000000e+00 -2.668053e-02
      1233 2009  372_2432468   BrayCurtisDiss  1.111111e-01  2.126770e-02
      1234 2010  372_2432468      JaccardDiss  0.000000e+00  1.785714e-02
      1235 2010  372_2432468 MorisitaHornDiss  0.000000e+00 -2.668053e-02
      1236 2010  372_2432468   BrayCurtisDiss  3.333333e-01  2.126770e-02
      1237 2011  372_2432468      JaccardDiss  5.000000e-01  1.785714e-02
      1238 2011  372_2432468 MorisitaHornDiss  7.692308e-02 -2.668053e-02
      1239 2011  372_2432468   BrayCurtisDiss  2.500000e-01  2.126770e-02
      1240 2012  372_2432468      JaccardDiss  0.000000e+00  1.785714e-02
      1241 2012  372_2432468 MorisitaHornDiss  0.000000e+00 -2.668053e-02
      1242 2012  372_2432468   BrayCurtisDiss  6.000000e-01  2.126770e-02
      1243 2011  372_2433200      JaccardDiss  0.000000e+00 -7.142857e-02
      1244 2011  372_2433200 MorisitaHornDiss  0.000000e+00 -7.142857e-02
      1245 2011  372_2433200   BrayCurtisDiss  3.333333e-01 -4.761905e-02
      1246 2012  372_2433200      JaccardDiss  1.000000e+00 -7.142857e-02
      1247 2012  372_2433200 MorisitaHornDiss  1.000000e+00 -7.142857e-02
      1248 2012  372_2433200   BrayCurtisDiss  1.000000e+00 -4.761905e-02
      1249 2009  372_2433200      JaccardDiss  1.000000e+00 -7.142857e-02
      1250 2009  372_2433200 MorisitaHornDiss  1.000000e+00 -7.142857e-02
      1251 2009  372_2433200   BrayCurtisDiss  1.000000e+00 -4.761905e-02
      1252 2009  372_2425914      JaccardDiss  0.000000e+00  2.500000e-01
      1253 2009  372_2425914 MorisitaHornDiss  1.111111e-01 -1.709402e-02
      1254 2009  372_2425914   BrayCurtisDiss  3.333333e-01 -2.466750e-14
      1255 2011  372_2425914      JaccardDiss  5.000000e-01  2.500000e-01
      1256 2011  372_2425914 MorisitaHornDiss  7.692308e-02 -1.709402e-02
      1257 2011  372_2425914   BrayCurtisDiss  3.333333e-01 -2.466750e-14
      1258 2010  372_2425914      JaccardDiss  5.000000e-01  2.500000e-01
      1259 2010  372_2425914 MorisitaHornDiss  3.333333e-01 -1.709402e-02
      1260 2010  372_2425914   BrayCurtisDiss  5.000000e-01 -2.466750e-14
      1261 2009  372_2428090      JaccardDiss  0.000000e+00  6.666667e-02
      1262 2009  372_2428090 MorisitaHornDiss  2.949853e-03  4.454125e-02
      1263 2009  372_2428090   BrayCurtisDiss  1.034483e-01  4.828942e-02
      1264 2010  372_2428090      JaccardDiss  0.000000e+00  6.666667e-02
      1265 2010  372_2428090 MorisitaHornDiss  5.545874e-03  4.454125e-02
      1266 2010  372_2428090   BrayCurtisDiss  1.475410e-01  4.828942e-02
      1267 2011  372_2428090      JaccardDiss  6.666667e-01  6.666667e-02
      1268 2011  372_2428090 MorisitaHornDiss  4.585840e-01  4.454125e-02
      1269 2011  372_2428090   BrayCurtisDiss  8.064516e-01  4.828942e-02
      1270 2012  372_2428090      JaccardDiss  0.000000e+00  6.666667e-02
      1271 2012  372_2428090 MorisitaHornDiss  4.079967e-04  4.454125e-02
      1272 2012  372_2428090   BrayCurtisDiss  4.477612e-02  4.828942e-02
      1273 2009  372_2414240      JaccardDiss  5.000000e-01 -2.500000e-01
      1274 2009  372_2414240 MorisitaHornDiss  1.321004e-03 -6.605020e-04
      1275 2009  372_2414240   BrayCurtisDiss  2.444444e-01  5.777778e-02
      1276 2010  372_2414240      JaccardDiss  5.000000e-01 -2.500000e-01
      1277 2010  372_2414240 MorisitaHornDiss  1.321004e-03 -6.605020e-04
      1278 2010  372_2414240   BrayCurtisDiss  5.555556e-01  5.777778e-02
      1279 2011  372_2414240      JaccardDiss  0.000000e+00 -2.500000e-01
      1280 2011  372_2414240 MorisitaHornDiss  0.000000e+00 -6.605020e-04
      1281 2011  372_2414240   BrayCurtisDiss  3.600000e-01  5.777778e-02
      1282 2010  402_3191114      JaccardDiss  5.531915e-01  2.186312e-02
      1283 2010  402_3191114 MorisitaHornDiss  5.004134e-01  3.233182e-02
      1284 2010  402_3191114   BrayCurtisDiss  6.871705e-01  1.709095e-02
      1285 2014  402_3191114      JaccardDiss  8.421053e-01  2.186312e-02
      1286 2014  402_3191114 MorisitaHornDiss  9.041700e-01  3.233182e-02
      1287 2014  402_3191114   BrayCurtisDiss  9.016393e-01  1.709095e-02
      1288 2015  402_3191114      JaccardDiss  4.468085e-01  2.186312e-02
      1289 2015  402_3191114 MorisitaHornDiss  3.541297e-01  3.233182e-02
      1290 2015  402_3191114   BrayCurtisDiss  5.171650e-01  1.709095e-02
      1291 2011  402_3191114      JaccardDiss  4.897959e-01  2.186312e-02
      1292 2011  402_3191114 MorisitaHornDiss  3.424950e-01  3.233182e-02
      1293 2011  402_3191114   BrayCurtisDiss  4.800000e-01  1.709095e-02
      1294 2012  402_3191114      JaccardDiss  5.833333e-01  2.186312e-02
      1295 2012  402_3191114 MorisitaHornDiss  3.921076e-01  3.233182e-02
      1296 2012  402_3191114   BrayCurtisDiss  5.019868e-01  1.709095e-02
      1297 2013  402_3191114      JaccardDiss  8.235294e-01  2.186312e-02
      1298 2013  402_3191114 MorisitaHornDiss  5.701148e-01  3.233182e-02
      1299 2013  402_3191114   BrayCurtisDiss  6.852792e-01  1.709095e-02
      1300 2013  402_3191113      JaccardDiss  4.736842e-01  3.448525e-03
      1301 2013  402_3191113 MorisitaHornDiss  3.343443e-02  6.673655e-02
      1302 2013  402_3191113   BrayCurtisDiss  2.098093e-01  3.459048e-02
      1303 2010  402_3191113      JaccardDiss  9.230769e-01  3.448525e-03
      1304 2010  402_3191113 MorisitaHornDiss  8.325100e-01  6.673655e-02
      1305 2010  402_3191113   BrayCurtisDiss  9.668508e-01  3.459048e-02
      1306 2011  402_3191113      JaccardDiss  5.263158e-01  3.448525e-03
      1307 2011  402_3191113 MorisitaHornDiss  3.072035e-02  6.673655e-02
      1308 2011  402_3191113   BrayCurtisDiss  2.372372e-01  3.459048e-02
      1309 2012  402_3191113      JaccardDiss  9.230769e-01  3.448525e-03
      1310 2012  402_3191113 MorisitaHornDiss  1.625500e-01  6.673655e-02
      1311 2012  402_3191113   BrayCurtisDiss  9.777778e-01  3.459048e-02
      1312 2014  402_3191113      JaccardDiss  6.923077e-01  3.448525e-03
      1313 2014  402_3191113 MorisitaHornDiss  7.395752e-01  6.673655e-02
      1314 2014  402_3191113   BrayCurtisDiss  8.936170e-01  3.459048e-02
      1315 2015  402_3191113      JaccardDiss  9.375000e-01  3.448525e-03
      1316 2015  402_3191113 MorisitaHornDiss  9.001761e-01  6.673655e-02
      1317 2015  402_3191113   BrayCurtisDiss  9.687500e-01  3.459048e-02
      1318 2010  402_3190383      JaccardDiss  5.625000e-01  4.005833e-03
      1319 2010  402_3190383 MorisitaHornDiss  5.613498e-01 -4.031774e-02
      1320 2010  402_3190383   BrayCurtisDiss  5.865922e-01  4.349580e-04
      1321 2012  402_3190383      JaccardDiss  3.571429e-01  4.005833e-03
      1322 2012  402_3190383 MorisitaHornDiss  7.075511e-01 -4.031774e-02
      1323 2012  402_3190383   BrayCurtisDiss  5.517241e-01  4.349580e-04
      1324 2013  402_3190383      JaccardDiss  5.882353e-01  4.005833e-03
      1325 2013  402_3190383 MorisitaHornDiss  7.625654e-01 -4.031774e-02
      1326 2013  402_3190383   BrayCurtisDiss  6.525822e-01  4.349580e-04
      1327 2014  402_3190383      JaccardDiss  9.230769e-01  4.005833e-03
      1328 2014  402_3190383 MorisitaHornDiss  8.984982e-01 -4.031774e-02
      1329 2014  402_3190383   BrayCurtisDiss  9.797980e-01  4.349580e-04
      1330 2011  402_3190383      JaccardDiss  5.714286e-01  4.005833e-03
      1331 2011  402_3190383 MorisitaHornDiss  8.896221e-01 -4.031774e-02
      1332 2011  402_3190383   BrayCurtisDiss  7.671233e-01  4.349580e-04
      1333 2015  402_3190383      JaccardDiss  3.333333e-01  4.005833e-03
      1334 2015  402_3190383 MorisitaHornDiss  2.627971e-01 -4.031774e-02
      1335 2015  402_3190383   BrayCurtisDiss  4.418605e-01  4.349580e-04
      1336 2004  431_5117859      JaccardDiss  5.000000e-01  5.180328e-02
      1337 2004  431_5117859 MorisitaHornDiss  2.023162e-01  6.592913e-02
      1338 2004  431_5117859   BrayCurtisDiss  4.423077e-01  7.456779e-02
      1339 2003  431_5117859      JaccardDiss  5.000000e-01  5.180328e-02
      1340 2003  431_5117859 MorisitaHornDiss  1.673485e-03  6.592913e-02
      1341 2003  431_5117859   BrayCurtisDiss  3.563218e-01  7.456779e-02
      1342 2010  431_5117859      JaccardDiss  8.000000e-01  5.180328e-02
      1343 2010  431_5117859 MorisitaHornDiss  1.773182e-01  6.592913e-02
      1344 2010  431_5117859   BrayCurtisDiss  9.354839e-01  7.456779e-02
      1345 2011  431_5117859      JaccardDiss  1.000000e+00  5.180328e-02
      1346 2011  431_5117859 MorisitaHornDiss  1.000000e+00  6.592913e-02
      1347 2011  431_5117859   BrayCurtisDiss  1.000000e+00  7.456779e-02
      1348 2006  431_5117859      JaccardDiss  1.000000e+00  5.180328e-02
      1349 2006  431_5117859 MorisitaHornDiss  1.000000e+00  6.592913e-02
      1350 2006  431_5117859   BrayCurtisDiss  1.000000e+00  7.456779e-02
      1351 2007  431_5117859      JaccardDiss  6.000000e-01  5.180328e-02
      1352 2007  431_5117859 MorisitaHornDiss  2.172052e-01  6.592913e-02
      1353 2007  431_5117859   BrayCurtisDiss  6.836158e-01  7.456779e-02
      1354 2011  431_5122228      JaccardDiss  8.333333e-01 -3.291206e-03
      1355 2011  431_5122228 MorisitaHornDiss  5.165848e-01 -2.487144e-02
      1356 2011  431_5122228   BrayCurtisDiss  9.061728e-01 -9.481166e-04
      1357 2001  431_5122228      JaccardDiss  1.000000e+00 -3.291206e-03
      1358 2001  431_5122228 MorisitaHornDiss  1.000000e+00 -2.487144e-02
      1359 2001  431_5122228   BrayCurtisDiss  1.000000e+00 -9.481166e-04
      1360 2008  431_5122228      JaccardDiss  5.000000e-01 -3.291206e-03
      1361 2008  431_5122228 MorisitaHornDiss  3.321928e-05 -2.487144e-02
      1362 2008  431_5122228   BrayCurtisDiss  9.885714e-01 -9.481166e-04
      1363 2010  431_5122228      JaccardDiss  1.000000e+00 -3.291206e-03
      1364 2010  431_5122228 MorisitaHornDiss  1.000000e+00 -2.487144e-02
      1365 2010  431_5122228   BrayCurtisDiss  1.000000e+00 -9.481166e-04
      1366 1992  431_5122228      JaccardDiss  8.333333e-01 -3.291206e-03
      1367 1992  431_5122228 MorisitaHornDiss  9.602441e-01 -2.487144e-02
      1368 1992  431_5122228   BrayCurtisDiss  9.661017e-01 -9.481166e-04
      1369 1993  431_4765005      JaccardDiss  1.000000e+00 -8.928571e-02
      1370 1993  431_4765005 MorisitaHornDiss  1.000000e+00 -8.928571e-02
      1371 1993  431_4765005   BrayCurtisDiss  1.000000e+00 -7.423756e-02
      1372 1989  431_4765005      JaccardDiss  1.000000e+00 -8.928571e-02
      1373 1989  431_4765005 MorisitaHornDiss  1.000000e+00 -8.928571e-02
      1374 1989  431_4765005   BrayCurtisDiss  1.000000e+00 -7.423756e-02
      1375 2001  431_4765005      JaccardDiss  0.000000e+00 -8.928571e-02
      1376 2001  431_4765005 MorisitaHornDiss  0.000000e+00 -8.928571e-02
      1377 2001  431_4765005   BrayCurtisDiss  1.685393e-01 -7.423756e-02
      1378 1994  431_5102575      JaccardDiss  8.333333e-01 -5.209739e-14
      1379 1994  431_5102575 MorisitaHornDiss  9.948285e-01 -1.616762e-15
      1380 1994  431_5102575   BrayCurtisDiss  9.655172e-01 -1.078309e-14
      1381 1995  431_5102575      JaccardDiss  1.000000e+00 -5.209739e-14
      1382 1995  431_5102575 MorisitaHornDiss  1.000000e+00 -1.616762e-15
      1383 1995  431_5102575   BrayCurtisDiss  1.000000e+00 -1.078309e-14
      1384 1993  431_5102575      JaccardDiss  1.000000e+00 -5.209739e-14
      1385 1993  431_5102575 MorisitaHornDiss  1.000000e+00 -1.616762e-15
      1386 1993  431_5102575   BrayCurtisDiss  1.000000e+00 -1.078309e-14
      1387 1996  431_4748960      JaccardDiss  0.000000e+00  1.590331e-02
      1388 1996  431_4748960 MorisitaHornDiss  0.000000e+00  1.618948e-02
      1389 1996  431_4748960   BrayCurtisDiss  0.000000e+00  3.173926e-02
      1390 1997  431_4748960      JaccardDiss  0.000000e+00  1.590331e-02
      1391 1997  431_4748960 MorisitaHornDiss  9.641434e-02  1.618948e-02
      1392 1997  431_4748960   BrayCurtisDiss  6.470588e-01  3.173926e-02
      1393 1998  431_4748960      JaccardDiss  6.666667e-01  1.590331e-02
      1394 1998  431_4748960 MorisitaHornDiss  6.842105e-01  1.618948e-02
      1395 1998  431_4748960   BrayCurtisDiss  6.000000e-01  3.173926e-02
      1396 2001  431_4748960      JaccardDiss  6.666667e-01  1.590331e-02
      1397 2001  431_4748960 MorisitaHornDiss  6.000000e-01  1.618948e-02
      1398 2001  431_4748960   BrayCurtisDiss  6.666667e-01  3.173926e-02
      1399 2004  431_4748960      JaccardDiss  1.000000e+00  1.590331e-02
      1400 2004  431_4748960 MorisitaHornDiss  1.000000e+00  1.618948e-02
      1401 2004  431_4748960   BrayCurtisDiss  1.000000e+00  3.173926e-02
      1402 1995  431_4748960      JaccardDiss  1.000000e+00  1.590331e-02
      1403 1995  431_4748960 MorisitaHornDiss  1.000000e+00  1.618948e-02
      1404 1995  431_4748960   BrayCurtisDiss  1.000000e+00  3.173926e-02
      1405 2003  431_4748960      JaccardDiss  0.000000e+00  1.590331e-02
      1406 2003  431_4748960 MorisitaHornDiss  9.641434e-02  1.618948e-02
      1407 2003  431_4748960   BrayCurtisDiss  6.470588e-01  3.173926e-02
      1408 2001  431_4749689      JaccardDiss  1.000000e+00  6.024096e-03
      1409 2001  431_4749689 MorisitaHornDiss  1.000000e+00  1.199820e-02
      1410 2001  431_4749689   BrayCurtisDiss  1.000000e+00  3.804692e-03
      1411 1995  431_4749689      JaccardDiss  1.000000e+00  6.024096e-03
      1412 1995  431_4749689 MorisitaHornDiss  1.000000e+00  1.199820e-02
      1413 1995  431_4749689   BrayCurtisDiss  1.000000e+00  3.804692e-03
      1414 1996  431_4749689      JaccardDiss  1.000000e+00  6.024096e-03
      1415 1996  431_4749689 MorisitaHornDiss  1.000000e+00  1.199820e-02
      1416 1996  431_4749689   BrayCurtisDiss  1.000000e+00  3.804692e-03
      1417 1997  431_4749689      JaccardDiss  5.000000e-01  6.024096e-03
      1418 1997  431_4749689 MorisitaHornDiss  4.149378e-03  1.199820e-02
      1419 1997  431_4749689   BrayCurtisDiss  6.842105e-01  3.804692e-03
      1420 1999  431_4751148      JaccardDiss  3.333333e-01  2.222222e-02
      1421 1999  431_4751148 MorisitaHornDiss  3.114562e-01  2.295146e-02
      1422 1999  431_4751148   BrayCurtisDiss  4.805195e-01  1.731602e-02
      1423 1997  431_4751148      JaccardDiss  1.000000e+00  2.222222e-02
      1424 1997  431_4751148 MorisitaHornDiss  1.000000e+00  2.295146e-02
      1425 1997  431_4751148   BrayCurtisDiss  1.000000e+00  1.731602e-02
      1426 2000  431_4751148      JaccardDiss  1.000000e+00  2.222222e-02
      1427 2000  431_4751148 MorisitaHornDiss  1.000000e+00  2.295146e-02
      1428 2000  431_4751148   BrayCurtisDiss  1.000000e+00  1.731602e-02
      1429 2006  431_4751148      JaccardDiss  1.000000e+00  2.222222e-02
      1430 2006  431_4751148 MorisitaHornDiss  1.000000e+00  2.295146e-02
      1431 2006  431_4751148   BrayCurtisDiss  1.000000e+00  1.731602e-02
      1432 1989  431_5120046      JaccardDiss  0.000000e+00  1.808804e-02
      1433 1989  431_5120046 MorisitaHornDiss  8.264463e-03  1.296495e-02
      1434 1989  431_5120046   BrayCurtisDiss  2.500000e-01  1.687106e-02
      1435 2008  431_5120046      JaccardDiss  6.666667e-01  1.808804e-02
      1436 2008  431_5120046 MorisitaHornDiss  1.328467e-01  1.296495e-02
      1437 2008  431_5120046   BrayCurtisDiss  7.142857e-01  1.687106e-02
      1438 2004  431_5120046      JaccardDiss  1.000000e+00  1.808804e-02
      1439 2004  431_5120046 MorisitaHornDiss  1.000000e+00  1.296495e-02
      1440 2004  431_5120046   BrayCurtisDiss  1.000000e+00  1.687106e-02
      1441 2007  431_5120046      JaccardDiss  1.000000e+00  1.808804e-02
      1442 2007  431_5120046 MorisitaHornDiss  1.000000e+00  1.296495e-02
      1443 2007  431_5120046   BrayCurtisDiss  1.000000e+00  1.687106e-02
      1444 2012  431_5120046      JaccardDiss  5.000000e-01  1.808804e-02
      1445 2012  431_5120046 MorisitaHornDiss  1.428571e-01  1.296495e-02
      1446 2012  431_5120046   BrayCurtisDiss  5.000000e-01  1.687106e-02
      1447 1988  431_5120046      JaccardDiss  5.000000e-01  1.808804e-02
      1448 1988  431_5120046 MorisitaHornDiss  1.428571e-01  1.296495e-02
      1449 1988  431_5120046   BrayCurtisDiss  2.000000e-01  1.687106e-02
      1450 1992  431_5120046      JaccardDiss  5.000000e-01  1.808804e-02
      1451 1992  431_5120046 MorisitaHornDiss  1.428571e-01  1.296495e-02
      1452 1992  431_5120046   BrayCurtisDiss  7.333333e-01  1.687106e-02
      1453 1998  431_5120046      JaccardDiss  5.000000e-01  1.808804e-02
      1454 1998  431_5120046 MorisitaHornDiss  1.428571e-01  1.296495e-02
      1455 1998  431_5120046   BrayCurtisDiss  6.666667e-01  1.687106e-02
      1456 2005  431_5120046      JaccardDiss  5.000000e-01  1.808804e-02
      1457 2005  431_5120046 MorisitaHornDiss  1.428571e-01  1.296495e-02
      1458 2005  431_5120046   BrayCurtisDiss  7.647059e-01  1.687106e-02
      1459 2010  431_5120046      JaccardDiss  6.666667e-01  1.808804e-02
      1460 2010  431_5120046 MorisitaHornDiss  1.968632e-01  1.296495e-02
      1461 2010  431_5120046   BrayCurtisDiss  6.250000e-01  1.687106e-02
      1462 2009  431_5132431      JaccardDiss  0.000000e+00 -3.007519e-02
      1463 2009  431_5132431 MorisitaHornDiss  4.326241e-01 -1.846813e-02
      1464 2009  431_5132431   BrayCurtisDiss  5.000000e-01 -1.617138e-02
      1465 2010  431_5132431      JaccardDiss  8.000000e-01 -3.007519e-02
      1466 2010  431_5132431 MorisitaHornDiss  9.540230e-01 -1.846813e-02
      1467 2010  431_5132431   BrayCurtisDiss  8.571429e-01 -1.617138e-02
      1468 1998  431_5132431      JaccardDiss  8.000000e-01 -3.007519e-02
      1469 1998  431_5132431 MorisitaHornDiss  9.409158e-01 -1.846813e-02
      1470 1998  431_5132431   BrayCurtisDiss  8.888889e-01 -1.617138e-02
      1471 1998  431_5133160      JaccardDiss  6.666667e-01 -3.237179e-17
      1472 1998  431_5133160 MorisitaHornDiss  3.188854e-01  8.851463e-03
      1473 1998  431_5133160   BrayCurtisDiss  6.470588e-01  1.251574e-02
      1474 2009  431_5133160      JaccardDiss  6.666667e-01 -3.237179e-17
      1475 2009  431_5133160 MorisitaHornDiss  3.188854e-01  8.851463e-03
      1476 2009  431_5133160   BrayCurtisDiss  8.461538e-01  1.251574e-02
      1477 2010  431_5133160      JaccardDiss  6.666667e-01 -3.237179e-17
      1478 2010  431_5133160 MorisitaHornDiss  5.000000e-01  8.851463e-03
      1479 2010  431_5133160   BrayCurtisDiss  7.500000e-01  1.251574e-02
      1480 1998  431_5132432      JaccardDiss  8.000000e-01 -5.907173e-03
      1481 1998  431_5132432 MorisitaHornDiss  9.803672e-01  1.146888e-02
      1482 1998  431_5132432   BrayCurtisDiss  9.743590e-01  1.217561e-03
      1483 2003  431_5132432      JaccardDiss  6.666667e-01 -5.907173e-03
      1484 2003  431_5132432 MorisitaHornDiss  9.090909e-02  1.146888e-02
      1485 2003  431_5132432   BrayCurtisDiss  8.181818e-01  1.217561e-03
      1486 2010  431_5132432      JaccardDiss  1.000000e+00 -5.907173e-03
      1487 2010  431_5132432 MorisitaHornDiss  1.000000e+00  1.146888e-02
      1488 2010  431_5132432   BrayCurtisDiss  1.000000e+00  1.217561e-03
      1489 2004  431_5132432      JaccardDiss  1.000000e+00 -5.907173e-03
      1490 2004  431_5132432 MorisitaHornDiss  1.000000e+00  1.146888e-02
      1491 2004  431_5132432   BrayCurtisDiss  1.000000e+00  1.217561e-03
      1492 2009  431_5132432      JaccardDiss  4.000000e-01 -5.907173e-03
      1493 2009  431_5132432 MorisitaHornDiss  8.374721e-01  1.146888e-02
      1494 2009  431_5132432   BrayCurtisDiss  9.080460e-01  1.217561e-03
      1495 1996  431_4744569      JaccardDiss  1.000000e+00 -2.482930e-02
      1496 1996  431_4744569 MorisitaHornDiss  1.000000e+00 -3.773556e-02
      1497 1996  431_4744569   BrayCurtisDiss  1.000000e+00 -1.971152e-02
      1498 2011  431_4744569      JaccardDiss  6.666667e-01 -2.482930e-02
      1499 2011  431_4744569 MorisitaHornDiss  8.339656e-01 -3.773556e-02
      1500 2011  431_4744569   BrayCurtisDiss  7.590361e-01 -1.971152e-02
      1501 2013  431_4744569      JaccardDiss  6.666667e-01 -2.482930e-02
      1502 2013  431_4744569 MorisitaHornDiss  5.535938e-01 -3.773556e-02
      1503 2013  431_4744569   BrayCurtisDiss  6.571429e-01 -1.971152e-02
      1504 2014  431_4744569      JaccardDiss  5.000000e-01 -2.482930e-02
      1505 2014  431_4744569 MorisitaHornDiss  9.652510e-02 -3.773556e-02
      1506 2014  431_4744569   BrayCurtisDiss  6.750000e-01 -1.971152e-02
      1507 2010  431_4744569      JaccardDiss  5.000000e-01 -2.482930e-02
      1508 2010  431_4744569 MorisitaHornDiss  2.721088e-02 -3.773556e-02
      1509 2010  431_4744569   BrayCurtisDiss  5.217391e-01 -1.971152e-02
      1510 2012  431_5104025      JaccardDiss  3.333333e-01 -1.484480e-02
      1511 2012  431_5104025 MorisitaHornDiss  7.948718e-01 -4.567632e-03
      1512 2012  431_5104025   BrayCurtisDiss  6.666667e-01 -7.422402e-03
      1513 2015  431_5104025      JaccardDiss  1.000000e+00 -1.484480e-02
      1514 2015  431_5104025 MorisitaHornDiss  1.000000e+00 -4.567632e-03
      1515 2015  431_5104025   BrayCurtisDiss  1.000000e+00 -7.422402e-03
      1516 1998  431_5104025      JaccardDiss  1.000000e+00 -1.484480e-02
      1517 1998  431_5104025 MorisitaHornDiss  1.000000e+00 -4.567632e-03
      1518 1998  431_5104025   BrayCurtisDiss  1.000000e+00 -7.422402e-03
      1519 1989  431_4764276      JaccardDiss  1.000000e+00 -3.211009e-02
      1520 1989  431_4764276 MorisitaHornDiss  1.000000e+00 -3.211009e-02
      1521 1989  431_4764276   BrayCurtisDiss  1.000000e+00 -3.211009e-02
      1522 2006  431_4764276      JaccardDiss  1.000000e+00 -3.211009e-02
      1523 2006  431_4764276 MorisitaHornDiss  1.000000e+00 -3.211009e-02
      1524 2006  431_4764276   BrayCurtisDiss  1.000000e+00 -3.211009e-02
      1525 2008  431_4764276      JaccardDiss  0.000000e+00 -3.211009e-02
      1526 2008  431_4764276 MorisitaHornDiss  0.000000e+00 -3.211009e-02
      1527 2008  431_4764276   BrayCurtisDiss  0.000000e+00 -3.211009e-02
      1528 1992  431_5122229      JaccardDiss  7.500000e-01  4.537954e-03
      1529 1992  431_5122229 MorisitaHornDiss  9.994119e-01 -1.513857e-02
      1530 1992  431_5122229   BrayCurtisDiss  9.980658e-01 -1.263375e-03
      1531 2004  431_5122229      JaccardDiss  0.000000e+00  4.537954e-03
      1532 2004  431_5122229 MorisitaHornDiss  2.424242e-01 -1.513857e-02
      1533 2004  431_5122229   BrayCurtisDiss  5.000000e-01 -1.263375e-03
      1534 2009  431_5122229      JaccardDiss  6.666667e-01  4.537954e-03
      1535 2009  431_5122229 MorisitaHornDiss  9.783862e-01 -1.513857e-02
      1536 2009  431_5122229   BrayCurtisDiss  9.285714e-01 -1.263375e-03
      1537 2012  431_5122229      JaccardDiss  1.000000e+00  4.537954e-03
      1538 2012  431_5122229 MorisitaHornDiss  1.000000e+00 -1.513857e-02
      1539 2012  431_5122229   BrayCurtisDiss  1.000000e+00 -1.263375e-03
      1540 2011  431_5122229      JaccardDiss  5.000000e-01  4.537954e-03
      1541 2011  431_5122229 MorisitaHornDiss  1.098901e-02 -1.513857e-02
      1542 2011  431_5122229   BrayCurtisDiss  8.200000e-01 -1.263375e-03
      1543 2006  431_5122229      JaccardDiss  7.500000e-01  4.537954e-03
      1544 2006  431_5122229 MorisitaHornDiss  9.963574e-01 -1.513857e-02
      1545 2006  431_5122229   BrayCurtisDiss  9.941748e-01 -1.263375e-03
      1546 2000  431_5100388      JaccardDiss  0.000000e+00  1.086957e-02
      1547 2000  431_5100388 MorisitaHornDiss  0.000000e+00  1.086957e-02
      1548 2000  431_5100388   BrayCurtisDiss  0.000000e+00  1.086957e-02
      1549 2003  431_5100388      JaccardDiss  1.000000e+00  1.086957e-02
      1550 2003  431_5100388 MorisitaHornDiss  1.000000e+00  1.086957e-02
      1551 2003  431_5100388   BrayCurtisDiss  1.000000e+00  1.086957e-02
      1552 1999  431_5100388      JaccardDiss  1.000000e+00  1.086957e-02
      1553 1999  431_5100388 MorisitaHornDiss  1.000000e+00  1.086957e-02
      1554 1999  431_5100388   BrayCurtisDiss  1.000000e+00  1.086957e-02
      1555 2007  431_5100388      JaccardDiss  1.000000e+00  1.086957e-02
      1556 2007  431_5100388 MorisitaHornDiss  1.000000e+00  1.086957e-02
      1557 2007  431_5100388   BrayCurtisDiss  1.000000e+00  1.086957e-02
      1558 1993  431_5100388      JaccardDiss  1.000000e+00  1.086957e-02
      1559 1993  431_5100388 MorisitaHornDiss  1.000000e+00  1.086957e-02
      1560 1993  431_5100388   BrayCurtisDiss  1.000000e+00  1.086957e-02
      1561 2010  431_5100388      JaccardDiss  1.000000e+00  1.086957e-02
      1562 2010  431_5100388 MorisitaHornDiss  1.000000e+00  1.086957e-02
      1563 2010  431_5100388   BrayCurtisDiss  1.000000e+00  1.086957e-02
      1564 2001  431_5100387      JaccardDiss  1.000000e+00 -1.065574e-01
      1565 2001  431_5100387 MorisitaHornDiss  1.000000e+00 -1.065574e-01
      1566 2001  431_5100387   BrayCurtisDiss  1.000000e+00 -1.989071e-02
      1567 2000  431_5100387      JaccardDiss  1.000000e+00 -1.065574e-01
      1568 2000  431_5100387 MorisitaHornDiss  1.000000e+00 -1.065574e-01
      1569 2000  431_5100387   BrayCurtisDiss  1.000000e+00 -1.989071e-02
      1570 2003  431_5100387      JaccardDiss  1.000000e+00 -1.065574e-01
      1571 2003  431_5100387 MorisitaHornDiss  1.000000e+00 -1.065574e-01
      1572 2003  431_5100387   BrayCurtisDiss  1.000000e+00 -1.989071e-02
      1573 2010  431_5100387      JaccardDiss  0.000000e+00 -1.065574e-01
      1574 2010  431_5100387 MorisitaHornDiss  0.000000e+00 -1.065574e-01
      1575 2010  431_5100387   BrayCurtisDiss  8.133333e-01 -1.989071e-02
      1576 2003  431_5101114      JaccardDiss  1.000000e+00  0.000000e+00
      1577 2003  431_5101114 MorisitaHornDiss  1.000000e+00  0.000000e+00
      1578 2003  431_5101114   BrayCurtisDiss  1.000000e+00  0.000000e+00
      1579 1993  431_5101114      JaccardDiss  1.000000e+00  0.000000e+00
      1580 1993  431_5101114 MorisitaHornDiss  1.000000e+00  0.000000e+00
      1581 1993  431_5101114   BrayCurtisDiss  1.000000e+00  0.000000e+00
      1582 2001  431_5101114      JaccardDiss  1.000000e+00  0.000000e+00
      1583 2001  431_5101114 MorisitaHornDiss  1.000000e+00  0.000000e+00
      1584 2001  431_5101114   BrayCurtisDiss  1.000000e+00  0.000000e+00
      1585 2010  431_5101114      JaccardDiss  1.000000e+00  0.000000e+00
      1586 2010  431_5101114 MorisitaHornDiss  1.000000e+00  0.000000e+00
      1587 2010  431_5101114   BrayCurtisDiss  1.000000e+00  0.000000e+00
      1588 2003  431_5101115      JaccardDiss  0.000000e+00  1.340996e-02
      1589 2003  431_5101115 MorisitaHornDiss  6.493506e-02  4.954471e-02
      1590 2003  431_5101115   BrayCurtisDiss  4.545455e-01 -2.232268e-04
      1591 2010  431_5101115      JaccardDiss  6.666667e-01  1.340996e-02
      1592 2010  431_5101115 MorisitaHornDiss  9.606277e-01  4.954471e-02
      1593 2010  431_5101115   BrayCurtisDiss  9.230769e-01 -2.232268e-04
      1594 2006  431_5101115      JaccardDiss  6.666667e-01  1.340996e-02
      1595 2006  431_5101115 MorisitaHornDiss  9.894803e-01  4.954471e-02
      1596 2006  431_5101115   BrayCurtisDiss  9.880240e-01 -2.232268e-04
      1597 2007  431_5101115      JaccardDiss  5.000000e-01  1.340996e-02
      1598 2007  431_5101115 MorisitaHornDiss  1.428571e-01  4.954471e-02
      1599 2007  431_5101115   BrayCurtisDiss  7.142857e-01 -2.232268e-04
      1600 1999  431_5101115      JaccardDiss  5.000000e-01  1.340996e-02
      1601 1999  431_5101115 MorisitaHornDiss  1.428571e-01  4.954471e-02
      1602 1999  431_5101115   BrayCurtisDiss  8.787879e-01 -2.232268e-04
      1603 2000  431_5101115      JaccardDiss  5.000000e-01  1.340996e-02
      1604 2000  431_5101115 MorisitaHornDiss  1.428571e-01  4.954471e-02
      1605 2000  431_5101115   BrayCurtisDiss  9.215686e-01 -2.232268e-04
      1606 2001  431_5101115      JaccardDiss  6.666667e-01  1.340996e-02
      1607 2001  431_5101115 MorisitaHornDiss  9.551922e-01  4.954471e-02
      1608 2001  431_5101115   BrayCurtisDiss  9.354839e-01 -2.232268e-04
      1609 1999  431_4763547      JaccardDiss  1.000000e+00  2.750809e-02
      1610 1999  431_4763547 MorisitaHornDiss  1.000000e+00  3.841647e-02
      1611 1999  431_4763547   BrayCurtisDiss  1.000000e+00  3.300971e-02
      1612 1998  431_4763547      JaccardDiss  6.666667e-01  2.750809e-02
      1613 1998  431_4763547 MorisitaHornDiss  5.344828e-01  3.841647e-02
      1614 1998  431_4763547   BrayCurtisDiss  6.000000e-01  3.300971e-02
      1615 2003  431_4763547      JaccardDiss  1.000000e+00  2.750809e-02
      1616 2003  431_4763547 MorisitaHornDiss  1.000000e+00  3.841647e-02
      1617 2003  431_4763547   BrayCurtisDiss  1.000000e+00  3.300971e-02
      1618 2001  431_4763547      JaccardDiss  1.000000e+00  2.750809e-02
      1619 2001  431_4763547 MorisitaHornDiss  1.000000e+00  3.841647e-02
      1620 2001  431_4763547   BrayCurtisDiss  1.000000e+00  3.300971e-02
      1621 2006  431_4763547      JaccardDiss  1.000000e+00  2.750809e-02
      1622 2006  431_4763547 MorisitaHornDiss  1.000000e+00  3.841647e-02
      1623 2006  431_4763547   BrayCurtisDiss  1.000000e+00  3.300971e-02
      1624 2005  431_4743109      JaccardDiss  1.000000e+00 -1.599462e-02
      1625 2005  431_4743109 MorisitaHornDiss  1.000000e+00 -9.767695e-03
      1626 2005  431_4743109   BrayCurtisDiss  1.000000e+00 -5.385945e-03
      1627 2006  431_4743109      JaccardDiss  8.000000e-01 -1.599462e-02
      1628 2006  431_4743109 MorisitaHornDiss  5.777262e-01 -9.767695e-03
      1629 2006  431_4743109   BrayCurtisDiss  8.000000e-01 -5.385945e-03
      1630 2012  431_4743109      JaccardDiss  6.000000e-01 -1.599462e-02
      1631 2012  431_4743109 MorisitaHornDiss  6.119403e-01 -9.767695e-03
      1632 2012  431_4743109   BrayCurtisDiss  8.285714e-01 -5.385945e-03
      1633 2014  431_4743109      JaccardDiss  1.000000e+00 -1.599462e-02
      1634 2014  431_4743109 MorisitaHornDiss  1.000000e+00 -9.767695e-03
      1635 2014  431_4743109   BrayCurtisDiss  1.000000e+00 -5.385945e-03
      1636 2009  431_4743109      JaccardDiss  1.000000e+00 -1.599462e-02
      1637 2009  431_4743109 MorisitaHornDiss  1.000000e+00 -9.767695e-03
      1638 2009  431_4743109   BrayCurtisDiss  1.000000e+00 -5.385945e-03
      1639 2010  431_4743109      JaccardDiss  1.000000e+00 -1.599462e-02
      1640 2010  431_4743109 MorisitaHornDiss  1.000000e+00 -9.767695e-03
      1641 2010  431_4743109   BrayCurtisDiss  1.000000e+00 -5.385945e-03
      1642 2013  431_4743109      JaccardDiss  6.666667e-01 -1.599462e-02
      1643 2013  431_4743109 MorisitaHornDiss  5.261239e-01 -9.767695e-03
      1644 2013  431_4743109   BrayCurtisDiss  7.500000e-01 -5.385945e-03
      1645 2005  431_5122232      JaccardDiss  1.000000e+00  1.639344e-02
      1646 2005  431_5122232 MorisitaHornDiss  1.000000e+00  3.249151e-02
      1647 2005  431_5122232   BrayCurtisDiss  1.000000e+00  2.761001e-02
      1648 1991  431_5122232      JaccardDiss  1.000000e+00  1.639344e-02
      1649 1991  431_5122232 MorisitaHornDiss  1.000000e+00  3.249151e-02
      1650 1991  431_5122232   BrayCurtisDiss  1.000000e+00  2.761001e-02
      1651 1992  431_5122232      JaccardDiss  5.000000e-01  1.639344e-02
      1652 1992  431_5122232 MorisitaHornDiss  9.009009e-03  3.249151e-02
      1653 1992  431_5122232   BrayCurtisDiss  1.578947e-01  2.761001e-02
      1654 2006  431_5110583      JaccardDiss  1.000000e+00  8.741259e-03
      1655 2006  431_5110583 MorisitaHornDiss  1.000000e+00  3.414554e-02
      1656 2006  431_5110583   BrayCurtisDiss  1.000000e+00  2.622378e-02
      1657 2001  431_5110583      JaccardDiss  7.500000e-01  8.741259e-03
      1658 2001  431_5110583 MorisitaHornDiss  2.343750e-02  3.414554e-02
      1659 2001  431_5110583   BrayCurtisDiss  9.354839e-01  2.622378e-02
      1660 2004  431_5110583      JaccardDiss  7.500000e-01  8.741259e-03
      1661 2004  431_5110583 MorisitaHornDiss  2.343750e-02  3.414554e-02
      1662 2004  431_5110583   BrayCurtisDiss  2.500000e-01  2.622378e-02
      1663 2010  431_5110583      JaccardDiss  7.500000e-01  8.741259e-03
      1664 2010  431_5110583 MorisitaHornDiss  2.343750e-02  3.414554e-02
      1665 2010  431_5110583   BrayCurtisDiss  9.354839e-01  2.622378e-02
      1666 2011  431_5110583      JaccardDiss  7.500000e-01  8.741259e-03
      1667 2011  431_5110583 MorisitaHornDiss  2.343750e-02  3.414554e-02
      1668 2011  431_5110583   BrayCurtisDiss  9.354839e-01  2.622378e-02
      1669 2012  431_5110583      JaccardDiss  1.000000e+00  8.741259e-03
      1670 2012  431_5110583 MorisitaHornDiss  1.000000e+00  3.414554e-02
      1671 2012  431_5110583   BrayCurtisDiss  1.000000e+00  2.622378e-02
      1672 2006  431_5122961      JaccardDiss  1.000000e+00  3.080569e-02
      1673 2006  431_5122961 MorisitaHornDiss  1.000000e+00  3.080569e-02
      1674 2006  431_5122961   BrayCurtisDiss  1.000000e+00  2.738283e-02
      1675 1991  431_5122961      JaccardDiss  1.000000e+00  3.080569e-02
      1676 1991  431_5122961 MorisitaHornDiss  1.000000e+00  3.080569e-02
      1677 1991  431_5122961   BrayCurtisDiss  1.000000e+00  2.738283e-02
      1678 1992  431_5122961      JaccardDiss  0.000000e+00  3.080569e-02
      1679 1992  431_5122961 MorisitaHornDiss  0.000000e+00  3.080569e-02
      1680 1992  431_5122961   BrayCurtisDiss  1.111111e-01  2.738283e-02
      1681 2006  431_5122960      JaccardDiss  3.333333e-01  1.184834e-03
      1682 2006  431_5122960 MorisitaHornDiss  1.603186e-02 -1.784007e-03
      1683 2006  431_5122960   BrayCurtisDiss  3.103448e-01  5.220287e-03
      1684 2007  431_5122960      JaccardDiss  6.666667e-01  1.184834e-03
      1685 2007  431_5122960 MorisitaHornDiss  1.030928e-02 -1.784007e-03
      1686 2007  431_5122960   BrayCurtisDiss  5.652174e-01  5.220287e-03
      1687 1992  431_5122960      JaccardDiss  5.000000e-01  1.184834e-03
      1688 1992  431_5122960 MorisitaHornDiss  3.883495e-02 -1.784007e-03
      1689 1992  431_5122960   BrayCurtisDiss  3.750000e-01  5.220287e-03
      1690 2007  431_5120044      JaccardDiss  1.000000e+00  6.761833e-03
      1691 2007  431_5120044 MorisitaHornDiss  1.000000e+00  1.343753e-02
      1692 2007  431_5120044   BrayCurtisDiss  1.000000e+00  9.492101e-03
      1693 2005  431_5120044      JaccardDiss  5.000000e-01  6.761833e-03
      1694 2005  431_5120044 MorisitaHornDiss  6.369427e-03  1.343753e-02
      1695 2005  431_5120044   BrayCurtisDiss  5.294118e-01  9.492101e-03
      1696 1985  431_5120044      JaccardDiss  5.000000e-01  6.761833e-03
      1697 1985  431_5120044 MorisitaHornDiss  6.369427e-03  1.343753e-02
      1698 1985  431_5120044   BrayCurtisDiss  4.444444e-01  9.492101e-03
      1699 1992  431_5120044      JaccardDiss  1.000000e+00  6.761833e-03
      1700 1992  431_5120044 MorisitaHornDiss  1.000000e+00  1.343753e-02
      1701 1992  431_5120044   BrayCurtisDiss  1.000000e+00  9.492101e-03
      1702 2007  431_4756232      JaccardDiss  5.000000e-01  1.459391e-02
      1703 2007  431_4756232 MorisitaHornDiss  6.923077e-01  7.637371e-02
      1704 2007  431_4756232   BrayCurtisDiss  6.842105e-01  5.498469e-02
      1705 2010  431_4756232      JaccardDiss  7.500000e-01  1.459391e-02
      1706 2010  431_4756232 MorisitaHornDiss  6.871508e-01  7.637371e-02
      1707 2010  431_4756232   BrayCurtisDiss  7.692308e-01  5.498469e-02
      1708 2011  431_4756232      JaccardDiss  5.000000e-01  1.459391e-02
      1709 2011  431_4756232 MorisitaHornDiss  6.923077e-01  7.637371e-02
      1710 2011  431_4756232   BrayCurtisDiss  8.461538e-01  5.498469e-02
      1711 2012  431_4756232      JaccardDiss  1.000000e+00  1.459391e-02
      1712 2012  431_4756232 MorisitaHornDiss  1.000000e+00  7.637371e-02
      1713 2012  431_4756232   BrayCurtisDiss  1.000000e+00  5.498469e-02
      1714 2001  431_4756232      JaccardDiss  6.666667e-01  1.459391e-02
      1715 2001  431_4756232 MorisitaHornDiss  1.754386e-02  7.637371e-02
      1716 2001  431_4756232   BrayCurtisDiss  3.333333e-01  5.498469e-02
      1717 2001  431_5124412      JaccardDiss  1.000000e+00  1.967131e-31
      1718 2001  431_5124412 MorisitaHornDiss  1.000000e+00  1.967131e-31
      1719 2001  431_5124412   BrayCurtisDiss  1.000000e+00  1.967131e-31
      1720 1991  431_5124412      JaccardDiss  1.000000e+00  1.967131e-31
      1721 1991  431_5124412 MorisitaHornDiss  1.000000e+00  1.967131e-31
      1722 1991  431_5124412   BrayCurtisDiss  1.000000e+00  1.967131e-31
      1723 2011  431_5124412      JaccardDiss  1.000000e+00  1.967131e-31
      1724 2011  431_5124412 MorisitaHornDiss  1.000000e+00  1.967131e-31
      1725 2011  431_5124412   BrayCurtisDiss  1.000000e+00  1.967131e-31
      1726 1999  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1727 1999  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1728 1999  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1729 2004  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1730 2004  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1731 2004  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1732 2011  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1733 2011  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1734 2011  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1735 1988  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1736 1988  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1737 1988  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1738 1989  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1739 1989  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1740 1989  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1741 1992  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1742 1992  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1743 1992  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1744 1993  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1745 1993  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1746 1993  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1747 1998  431_5119317      JaccardDiss  1.000000e+00 -7.392473e-03
      1748 1998  431_5119317 MorisitaHornDiss  1.000000e+00 -1.454063e-02
      1749 1998  431_5119317   BrayCurtisDiss  1.000000e+00 -6.133015e-03
      1750 2005  431_5119317      JaccardDiss  5.000000e-01 -7.392473e-03
      1751 2005  431_5119317 MorisitaHornDiss  1.652489e-02 -1.454063e-02
      1752 2005  431_5119317   BrayCurtisDiss  5.851852e-01 -6.133015e-03
      1753 1993  431_4748231      JaccardDiss  6.666667e-01  5.343732e-03
      1754 1993  431_4748231 MorisitaHornDiss  5.970450e-01  1.722827e-02
      1755 1993  431_4748231   BrayCurtisDiss  5.454545e-01  1.409240e-02
      1756 1995  431_4748231      JaccardDiss  5.000000e-01  5.343732e-03
      1757 1995  431_4748231 MorisitaHornDiss  3.225806e-02  1.722827e-02
      1758 1995  431_4748231   BrayCurtisDiss  5.000000e-01  1.409240e-02
      1759 1998  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1760 1998  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1761 1998  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1762 1996  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1763 1996  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1764 1996  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1765 1997  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1766 1997  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1767 1997  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1768 2001  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1769 2001  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1770 2001  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1771 2002  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1772 2002  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1773 2002  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1774 2004  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1775 2004  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1776 2004  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1777 2007  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1778 2007  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1779 2007  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1780 2008  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1781 2008  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1782 2008  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1783 2009  431_4748231      JaccardDiss  1.000000e+00  5.343732e-03
      1784 2009  431_4748231 MorisitaHornDiss  1.000000e+00  1.722827e-02
      1785 2009  431_4748231   BrayCurtisDiss  1.000000e+00  1.409240e-02
      1786 2010  431_4748231      JaccardDiss  5.000000e-01  5.343732e-03
      1787 2010  431_4748231 MorisitaHornDiss  6.019900e-01  1.722827e-02
      1788 2010  431_4748231   BrayCurtisDiss  7.777778e-01  1.409240e-02
      1789 1997  431_4755525      JaccardDiss  5.000000e-01 -2.096774e-02
      1790 1997  431_4755525 MorisitaHornDiss  3.225806e-02 -1.352758e-03
      1791 1997  431_4755525   BrayCurtisDiss  7.058824e-01  2.866395e-02
      1792 1999  431_4755525      JaccardDiss  5.000000e-01 -2.096774e-02
      1793 1999  431_4755525 MorisitaHornDiss  3.225806e-02 -1.352758e-03
      1794 1999  431_4755525   BrayCurtisDiss  9.090909e-02  2.866395e-02
      1795 2005  431_4755525      JaccardDiss  5.000000e-01 -2.096774e-02
      1796 2005  431_4755525 MorisitaHornDiss  3.225806e-02 -1.352758e-03
      1797 2005  431_4755525   BrayCurtisDiss  3.333333e-01  2.866395e-02
      1798 2006  431_4755525      JaccardDiss  5.000000e-01 -2.096774e-02
      1799 2006  431_4755525 MorisitaHornDiss  3.225806e-02 -1.352758e-03
      1800 2006  431_4755525   BrayCurtisDiss  8.461538e-01  2.866395e-02
      1801 2007  431_4755525      JaccardDiss  5.000000e-01 -2.096774e-02
      1802 2007  431_4755525 MorisitaHornDiss  3.225806e-02 -1.352758e-03
      1803 2007  431_4755525   BrayCurtisDiss  7.959184e-01  2.866395e-02
      1804 2008  431_4755525      JaccardDiss  0.000000e+00 -2.096774e-02
      1805 2008  431_4755525 MorisitaHornDiss  0.000000e+00 -1.352758e-03
      1806 2008  431_4755525   BrayCurtisDiss  6.969697e-01  2.866395e-02
      1807 1999  431_5101846      JaccardDiss  5.000000e-01 -1.329787e-03
      1808 1999  431_5101846 MorisitaHornDiss  6.410256e-01 -1.496792e-02
      1809 1999  431_5101846   BrayCurtisDiss  5.555556e-01 -1.614309e-02
      1810 2003  431_5101846      JaccardDiss  6.666667e-01 -1.329787e-03
      1811 2003  431_5101846 MorisitaHornDiss  6.387803e-01 -1.496792e-02
      1812 2003  431_5101846   BrayCurtisDiss  7.777778e-01 -1.614309e-02
      1813 2005  431_5101846      JaccardDiss  7.500000e-01 -1.329787e-03
      1814 2005  431_5101846 MorisitaHornDiss  8.480312e-02 -1.496792e-02
      1815 2005  431_5101846   BrayCurtisDiss  5.833333e-01 -1.614309e-02
      1816 1994  431_5101846      JaccardDiss  1.000000e+00 -1.329787e-03
      1817 1994  431_5101846 MorisitaHornDiss  1.000000e+00 -1.496792e-02
      1818 1994  431_5101846   BrayCurtisDiss  1.000000e+00 -1.614309e-02
      1819 1993  431_5101846      JaccardDiss  5.000000e-01 -1.329787e-03
      1820 1993  431_5101846 MorisitaHornDiss  3.883495e-02 -1.496792e-02
      1821 1993  431_5101846   BrayCurtisDiss  6.923077e-01 -1.614309e-02
      1822 2002  431_5101844      JaccardDiss  0.000000e+00  5.102041e-02
      1823 2002  431_5101844 MorisitaHornDiss  0.000000e+00  5.102041e-02
      1824 2002  431_5101844   BrayCurtisDiss  0.000000e+00  5.102041e-02
      1825 2005  431_5101844      JaccardDiss  1.000000e+00  5.102041e-02
      1826 2005  431_5101844 MorisitaHornDiss  1.000000e+00  5.102041e-02
      1827 2005  431_5101844   BrayCurtisDiss  1.000000e+00  5.102041e-02
      1828 2001  431_5101844      JaccardDiss  1.000000e+00  5.102041e-02
      1829 2001  431_5101844 MorisitaHornDiss  1.000000e+00  5.102041e-02
      1830 2001  431_5101844   BrayCurtisDiss  1.000000e+00  5.102041e-02
      1831 2010  431_5101844      JaccardDiss  1.000000e+00  5.102041e-02
      1832 2010  431_5101844 MorisitaHornDiss  1.000000e+00  5.102041e-02
      1833 2010  431_5101844   BrayCurtisDiss  1.000000e+00  5.102041e-02
      1834 2001  431_5113493      JaccardDiss  7.142857e-01  3.421454e-02
      1835 2001  431_5113493 MorisitaHornDiss  8.861009e-01 -2.306356e-02
      1836 2001  431_5113493   BrayCurtisDiss  8.830189e-01 -1.369075e-02
      1837 2003  431_5113493      JaccardDiss  6.666667e-01  3.421454e-02
      1838 2003  431_5113493 MorisitaHornDiss  3.052902e-01 -2.306356e-02
      1839 2003  431_5113493   BrayCurtisDiss  8.648649e-01 -1.369075e-02
      1840 2006  431_5113493      JaccardDiss  8.571429e-01  3.421454e-02
      1841 2006  431_5113493 MorisitaHornDiss  6.273394e-01 -2.306356e-02
      1842 2006  431_5113493   BrayCurtisDiss  7.542857e-01 -1.369075e-02
      1843 2005  431_5113493      JaccardDiss  8.333333e-01  3.421454e-02
      1844 2005  431_5113493 MorisitaHornDiss  8.911464e-01 -2.306356e-02
      1845 2005  431_5113493   BrayCurtisDiss  9.809524e-01 -1.369075e-02
      1846 1998  431_5113493      JaccardDiss  8.000000e-01  3.421454e-02
      1847 1998  431_5113493 MorisitaHornDiss  8.510097e-01 -2.306356e-02
      1848 1998  431_5113493   BrayCurtisDiss  9.624413e-01 -1.369075e-02
      1849 2000  431_5113493      JaccardDiss  2.000000e-01  3.421454e-02
      1850 2000  431_5113493 MorisitaHornDiss  7.775121e-01 -2.306356e-02
      1851 2000  431_5113493   BrayCurtisDiss  9.195402e-01 -1.369075e-02
      1852 2002  431_4770091      JaccardDiss  7.500000e-01 -2.325581e-02
      1853 2002  431_4770091 MorisitaHornDiss  6.446469e-01 -3.305610e-02
      1854 2002  431_4770091   BrayCurtisDiss  6.470588e-01 -3.283174e-02
      1855 1995  431_4770091      JaccardDiss  1.000000e+00 -2.325581e-02
      1856 1995  431_4770091 MorisitaHornDiss  1.000000e+00 -3.305610e-02
      1857 1995  431_4770091   BrayCurtisDiss  1.000000e+00 -3.283174e-02
      1858 2001  431_4770091      JaccardDiss  1.000000e+00 -2.325581e-02
      1859 2001  431_4770091 MorisitaHornDiss  1.000000e+00 -3.305610e-02
      1860 2001  431_4770091   BrayCurtisDiss  1.000000e+00 -3.283174e-02
      1861 2001  431_5101116      JaccardDiss  5.000000e-01  3.571429e-02
      1862 2001  431_5101116 MorisitaHornDiss  9.546351e-01  3.240349e-03
      1863 2001  431_5101116   BrayCurtisDiss  9.166667e-01  5.952381e-03
      1864 2003  431_5101116      JaccardDiss  1.000000e+00  3.571429e-02
      1865 2003  431_5101116 MorisitaHornDiss  1.000000e+00  3.240349e-03
      1866 2003  431_5101116   BrayCurtisDiss  1.000000e+00  5.952381e-03
      1867 2000  431_5101116      JaccardDiss  1.000000e+00  3.571429e-02
      1868 2000  431_5101116 MorisitaHornDiss  1.000000e+00  3.240349e-03
      1869 2000  431_5101116   BrayCurtisDiss  1.000000e+00  5.952381e-03
      1870 2007  431_5101118      JaccardDiss  1.000000e+00  1.413694e-17
      1871 2007  431_5101118 MorisitaHornDiss  1.000000e+00  1.413694e-17
      1872 2007  431_5101118   BrayCurtisDiss  1.000000e+00  1.413694e-17
      1873 1994  431_5101118      JaccardDiss  1.000000e+00  1.413694e-17
      1874 1994  431_5101118 MorisitaHornDiss  1.000000e+00  1.413694e-17
      1875 1994  431_5101118   BrayCurtisDiss  1.000000e+00  1.413694e-17
      1876 2005  431_5101118      JaccardDiss  1.000000e+00  1.413694e-17
      1877 2005  431_5101118 MorisitaHornDiss  1.000000e+00  1.413694e-17
      1878 2005  431_5101118   BrayCurtisDiss  1.000000e+00  1.413694e-17
      1879 2002  431_5101118      JaccardDiss  1.000000e+00  1.413694e-17
      1880 2002  431_5101118 MorisitaHornDiss  1.000000e+00  1.413694e-17
      1881 2002  431_5101118   BrayCurtisDiss  1.000000e+00  1.413694e-17
      1882 2000  431_5101118      JaccardDiss  1.000000e+00  1.413694e-17
      1883 2000  431_5101118 MorisitaHornDiss  1.000000e+00  1.413694e-17
      1884 2000  431_5101118   BrayCurtisDiss  1.000000e+00  1.413694e-17
      1885 2010  431_5101118      JaccardDiss  1.000000e+00  1.413694e-17
      1886 2010  431_5101118 MorisitaHornDiss  1.000000e+00  1.413694e-17
      1887 2010  431_5101118   BrayCurtisDiss  1.000000e+00  1.413694e-17
      1888 2009  431_5123684      JaccardDiss  1.000000e+00 -2.226721e-02
      1889 2009  431_5123684 MorisitaHornDiss  1.000000e+00 -2.226721e-02
      1890 2009  431_5123684   BrayCurtisDiss  1.000000e+00 -1.484480e-02
      1891 1992  431_5123684      JaccardDiss  1.000000e+00 -2.226721e-02
      1892 1992  431_5123684 MorisitaHornDiss  1.000000e+00 -2.226721e-02
      1893 1992  431_5123684   BrayCurtisDiss  1.000000e+00 -1.484480e-02
      1894 2006  431_5123684      JaccardDiss  0.000000e+00 -2.226721e-02
      1895 2006  431_5123684 MorisitaHornDiss  0.000000e+00 -2.226721e-02
      1896 2006  431_5123684   BrayCurtisDiss  3.333333e-01 -1.484480e-02
      1897 2004  431_5100389      JaccardDiss  3.333333e-01 -9.713701e-03
      1898 2004  431_5100389 MorisitaHornDiss  9.783296e-01  3.001290e-02
      1899 2004  431_5100389   BrayCurtisDiss  9.439252e-01  1.571547e-02
      1900 2007  431_5100389      JaccardDiss  8.333333e-01 -9.713701e-03
      1901 2007  431_5100389 MorisitaHornDiss  9.919118e-01  3.001290e-02
      1902 2007  431_5100389   BrayCurtisDiss  9.676113e-01  1.571547e-02
      1903 1993  431_5100389      JaccardDiss  8.000000e-01 -9.713701e-03
      1904 1993  431_5100389 MorisitaHornDiss  5.961973e-01  3.001290e-02
      1905 1993  431_5100389   BrayCurtisDiss  7.551020e-01  1.571547e-02
      1906 1994  431_5120772      JaccardDiss  6.666667e-01  1.133461e-02
      1907 1994  431_5120772 MorisitaHornDiss  9.244686e-01  7.173865e-03
      1908 1994  431_5120772   BrayCurtisDiss  8.913043e-01  9.481333e-03
      1909 2011  431_5120772      JaccardDiss  7.500000e-01  1.133461e-02
      1910 2011  431_5120772 MorisitaHornDiss  3.400104e-01  7.173865e-03
      1911 2011  431_5120772   BrayCurtisDiss  9.555556e-01  9.481333e-03
      1912 1993  431_5120772      JaccardDiss  6.666667e-01  1.133461e-02
      1913 1993  431_5120772 MorisitaHornDiss  1.087300e-01  7.173865e-03
      1914 1993  431_5120772   BrayCurtisDiss  7.551020e-01  9.481333e-03
      1915 2008  431_5120772      JaccardDiss  1.000000e+00  1.133461e-02
      1916 2008  431_5120772 MorisitaHornDiss  1.000000e+00  7.173865e-03
      1917 2008  431_5120772   BrayCurtisDiss  1.000000e+00  9.481333e-03
      1918 1995  431_4748961      JaccardDiss  1.000000e+00  9.450914e-18
      1919 1995  431_4748961 MorisitaHornDiss  1.000000e+00  9.450914e-18
      1920 1995  431_4748961   BrayCurtisDiss  1.000000e+00  9.450914e-18
      1921 2004  431_4748961      JaccardDiss  1.000000e+00  9.450914e-18
      1922 2004  431_4748961 MorisitaHornDiss  1.000000e+00  9.450914e-18
      1923 2004  431_4748961   BrayCurtisDiss  1.000000e+00  9.450914e-18
      1924 1992  431_4748961      JaccardDiss  1.000000e+00  9.450914e-18
      1925 1992  431_4748961 MorisitaHornDiss  1.000000e+00  9.450914e-18
      1926 1992  431_4748961   BrayCurtisDiss  1.000000e+00  9.450914e-18
      1927 1997  431_4748961      JaccardDiss  1.000000e+00  9.450914e-18
      1928 1997  431_4748961 MorisitaHornDiss  1.000000e+00  9.450914e-18
      1929 1997  431_4748961   BrayCurtisDiss  1.000000e+00  9.450914e-18
      1930 2008  431_4748961      JaccardDiss  1.000000e+00  9.450914e-18
      1931 2008  431_4748961 MorisitaHornDiss  1.000000e+00  9.450914e-18
      1932 2008  431_4748961   BrayCurtisDiss  1.000000e+00  9.450914e-18
      1933 1997  431_4749690      JaccardDiss  1.000000e+00 -2.721088e-02
      1934 1997  431_4749690 MorisitaHornDiss  1.000000e+00 -5.014577e-02
      1935 1997  431_4749690   BrayCurtisDiss  1.000000e+00 -3.710575e-03
      1936 1995  431_4749690      JaccardDiss  1.000000e+00 -2.721088e-02
      1937 1995  431_4749690 MorisitaHornDiss  1.000000e+00 -5.014577e-02
      1938 1995  431_4749690   BrayCurtisDiss  1.000000e+00 -3.710575e-03
      1939 2008  431_4749690      JaccardDiss  6.666667e-01 -2.721088e-02
      1940 2008  431_4749690 MorisitaHornDiss  3.857143e-01 -5.014577e-02
      1941 2008  431_4749690   BrayCurtisDiss  9.545455e-01 -3.710575e-03
      1942 2007  431_4781017      JaccardDiss  0.000000e+00  1.428571e-01
      1943 2007  431_4781017 MorisitaHornDiss  0.000000e+00  1.428571e-01
      1944 2007  431_4781017   BrayCurtisDiss  0.000000e+00  1.428571e-01
      1945 2008  431_4781017      JaccardDiss  1.000000e+00  1.428571e-01
      1946 2008  431_4781017 MorisitaHornDiss  1.000000e+00  1.428571e-01
      1947 2008  431_4781017   BrayCurtisDiss  1.000000e+00  1.428571e-01
      1948 2012  431_4781017      JaccardDiss  1.000000e+00  1.428571e-01
      1949 2012  431_4781017 MorisitaHornDiss  1.000000e+00  1.428571e-01
      1950 2012  431_4781017   BrayCurtisDiss  1.000000e+00  1.428571e-01
      1951 2005  431_4748944      JaccardDiss  5.000000e-01 -1.289683e-02
      1952 2005  431_4748944 MorisitaHornDiss  9.009009e-01  2.221815e-03
      1953 2005  431_4748944   BrayCurtisDiss  9.841270e-01  3.456043e-03
      1954 2006  431_4748944      JaccardDiss  5.000000e-01 -1.289683e-02
      1955 2006  431_4748944 MorisitaHornDiss  9.009009e-01  2.221815e-03
      1956 2006  431_4748944   BrayCurtisDiss  9.534884e-01  3.456043e-03
      1957 2007  431_4748944      JaccardDiss  6.666667e-01 -1.289683e-02
      1958 2007  431_4748944 MorisitaHornDiss  9.632270e-01  2.221815e-03
      1959 2007  431_4748944   BrayCurtisDiss  9.487179e-01  3.456043e-03
      1960 1991  431_4748944      JaccardDiss  6.666667e-01 -1.289683e-02
      1961 1991  431_4748944 MorisitaHornDiss  7.599302e-01  2.221815e-03
      1962 1991  431_4748944   BrayCurtisDiss  8.095238e-01  3.456043e-03
      1963 1993  431_4748944      JaccardDiss  5.000000e-01 -1.289683e-02
      1964 1993  431_4748944 MorisitaHornDiss  9.009009e-03  2.221815e-03
      1965 1993  431_4748944   BrayCurtisDiss  5.121951e-01  3.456043e-03
      1966 1997  431_4748944      JaccardDiss  5.000000e-01 -1.289683e-02
      1967 1997  431_4748944 MorisitaHornDiss  9.009009e-03  2.221815e-03
      1968 1997  431_4748944   BrayCurtisDiss  8.843931e-01  3.456043e-03
      1969 2010  431_4748944      JaccardDiss  5.000000e-01 -1.289683e-02
      1970 2010  431_4748944 MorisitaHornDiss  9.009009e-03  2.221815e-03
      1971 2010  431_4748944   BrayCurtisDiss  7.500000e-01  3.456043e-03
      1972 2011  431_4748944      JaccardDiss  0.000000e+00 -1.289683e-02
      1973 2011  431_4748944 MorisitaHornDiss  0.000000e+00  2.221815e-03
      1974 2011  431_4748944   BrayCurtisDiss  5.646259e-01  3.456043e-03
      1975 1992  431_5122956      JaccardDiss  6.000000e-01  6.422018e-03
      1976 1992  431_5122956 MorisitaHornDiss  4.378620e-01  2.514320e-02
      1977 1992  431_5122956   BrayCurtisDiss  5.728155e-01  1.863932e-02
      1978 2009  431_5122956      JaccardDiss  6.000000e-01  6.422018e-03
      1979 2009  431_5122956 MorisitaHornDiss  8.002173e-01  2.514320e-02
      1980 2009  431_5122956   BrayCurtisDiss  8.333333e-01  1.863932e-02
      1981 2011  431_5122956      JaccardDiss  8.000000e-01  6.422018e-03
      1982 2011  431_5122956 MorisitaHornDiss  9.620677e-01  2.514320e-02
      1983 2011  431_5122956   BrayCurtisDiss  9.672131e-01  1.863932e-02
      1984 1984  431_4739485      JaccardDiss  6.666667e-01  1.546602e-02
      1985 1984  431_4739485 MorisitaHornDiss  7.222222e-01  5.426672e-03
      1986 1984  431_4739485   BrayCurtisDiss  6.666667e-01  1.546602e-02
      1987 1999  431_4739485      JaccardDiss  6.666667e-01  1.546602e-02
      1988 1999  431_4739485 MorisitaHornDiss  1.666667e-01  5.426672e-03
      1989 1999  431_4739485   BrayCurtisDiss  6.666667e-01  1.546602e-02
      1990 2000  431_4739485      JaccardDiss  1.000000e+00  1.546602e-02
      1991 2000  431_4739485 MorisitaHornDiss  1.000000e+00  5.426672e-03
      1992 2000  431_4739485   BrayCurtisDiss  1.000000e+00  1.546602e-02
      1993 2002  431_4739485      JaccardDiss  1.000000e+00  1.546602e-02
      1994 2002  431_4739485 MorisitaHornDiss  1.000000e+00  5.426672e-03
      1995 2002  431_4739485   BrayCurtisDiss  1.000000e+00  1.546602e-02
      1996 1993  431_5120045      JaccardDiss  7.500000e-01 -1.590909e-02
      1997 1993  431_5120045 MorisitaHornDiss  9.930460e-01 -4.171421e-02
      1998 1993  431_5120045   BrayCurtisDiss  9.893048e-01 -1.675299e-02
      1999 2004  431_5120045      JaccardDiss  1.000000e+00 -1.590909e-02
      2000 2004  431_5120045 MorisitaHornDiss  1.000000e+00 -4.171421e-02
      2001 2004  431_5120045   BrayCurtisDiss  1.000000e+00 -1.675299e-02
      2002 1997  431_5120045      JaccardDiss  1.000000e+00 -1.590909e-02
      2003 1997  431_5120045 MorisitaHornDiss  1.000000e+00 -4.171421e-02
      2004 1997  431_5120045   BrayCurtisDiss  1.000000e+00 -1.675299e-02
      2005 2001  431_5120045      JaccardDiss  1.000000e+00 -1.590909e-02
      2006 2001  431_5120045 MorisitaHornDiss  1.000000e+00 -4.171421e-02
      2007 2001  431_5120045   BrayCurtisDiss  1.000000e+00 -1.675299e-02
      2008 2012  431_5120045      JaccardDiss  5.000000e-01 -1.590909e-02
      2009 2012  431_5120045 MorisitaHornDiss  7.692308e-02 -4.171421e-02
      2010 2012  431_5120045   BrayCurtisDiss  6.250000e-01 -1.675299e-02
      2011 2005  431_5120045      JaccardDiss  7.500000e-01 -1.590909e-02
      2012 2005  431_5120045 MorisitaHornDiss  9.970193e-01 -4.171421e-02
      2013 2005  431_5120045   BrayCurtisDiss  9.893617e-01 -1.675299e-02
      2014 2006  431_5115676      JaccardDiss  6.666667e-01 -1.724138e-02
      2015 2006  431_5115676 MorisitaHornDiss  1.111111e-01 -4.597701e-02
      2016 2006  431_5115676   BrayCurtisDiss  5.000000e-01 -3.287682e-02
      2017 2008  431_5115676      JaccardDiss  6.666667e-01 -1.724138e-02
      2018 2008  431_5115676 MorisitaHornDiss  7.777778e-01 -4.597701e-02
      2019 2008  431_5115676   BrayCurtisDiss  9.090909e-01 -3.287682e-02
      2020 2001  431_5115676      JaccardDiss  6.666667e-01 -1.724138e-02
      2021 2001  431_5115676 MorisitaHornDiss  7.777778e-01 -4.597701e-02
      2022 2001  431_5115676   BrayCurtisDiss  9.672131e-01 -3.287682e-02
      2023 2003  431_5115676      JaccardDiss  1.000000e+00 -1.724138e-02
      2024 2003  431_5115676 MorisitaHornDiss  1.000000e+00 -4.597701e-02
      2025 2003  431_5115676   BrayCurtisDiss  1.000000e+00 -3.287682e-02
      2026 2011  431_4742381      JaccardDiss  5.000000e-01 -1.558074e-02
      2027 2011  431_4742381 MorisitaHornDiss  5.714286e-01 -1.780656e-02
      2028 2011  431_4742381   BrayCurtisDiss  8.000000e-01  1.931067e-02
      2029 1996  431_4742381      JaccardDiss  5.000000e-01 -1.558074e-02
      2030 1996  431_4742381 MorisitaHornDiss  5.714286e-01 -1.780656e-02
      2031 1996  431_4742381   BrayCurtisDiss  5.000000e-01  1.931067e-02
      2032 2005  431_4742381      JaccardDiss  5.000000e-01 -1.558074e-02
      2033 2005  431_4742381 MorisitaHornDiss  5.714286e-01 -1.780656e-02
      2034 2005  431_4742381   BrayCurtisDiss  6.000000e-01  1.931067e-02
      2035 2006  431_4742381      JaccardDiss  5.000000e-01 -1.558074e-02
      2036 2006  431_4742381 MorisitaHornDiss  5.714286e-01 -1.780656e-02
      2037 2006  431_4742381   BrayCurtisDiss  6.666667e-01  1.931067e-02
      2038 2010  431_4742381      JaccardDiss  0.000000e+00 -1.558074e-02
      2039 2010  431_4742381 MorisitaHornDiss  0.000000e+00 -1.780656e-02
      2040 2010  431_4742381   BrayCurtisDiss  7.500000e-01  1.931067e-02
      2041 2001  431_4763546      JaccardDiss  5.000000e-01 -1.428571e-01
      2042 2001  431_4763546 MorisitaHornDiss  3.333333e-01 -1.904762e-01
      2043 2001  431_4763546   BrayCurtisDiss  6.000000e-01 -1.142857e-01
      2044 2000  431_4763546      JaccardDiss  1.000000e+00 -1.428571e-01
      2045 2000  431_4763546 MorisitaHornDiss  1.000000e+00 -1.904762e-01
      2046 2000  431_4763546   BrayCurtisDiss  1.000000e+00 -1.142857e-01
      2047 1998  431_4763546      JaccardDiss  1.000000e+00 -1.428571e-01
      2048 1998  431_4763546 MorisitaHornDiss  1.000000e+00 -1.904762e-01
      2049 1998  431_4763546   BrayCurtisDiss  1.000000e+00 -1.142857e-01
      2050 1998  431_4750418      JaccardDiss  1.000000e+00  5.555556e-03
      2051 1998  431_4750418 MorisitaHornDiss  1.000000e+00  7.407407e-03
      2052 1998  431_4750418   BrayCurtisDiss  1.000000e+00  5.555556e-03
      2053 2000  431_4750418      JaccardDiss  1.000000e+00  5.555556e-03
      2054 2000  431_4750418 MorisitaHornDiss  1.000000e+00  7.407407e-03
      2055 2000  431_4750418   BrayCurtisDiss  1.000000e+00  5.555556e-03
      2056 2001  431_4750418      JaccardDiss  5.000000e-01  5.555556e-03
      2057 2001  431_4750418 MorisitaHornDiss  3.333333e-01  7.407407e-03
      2058 2001  431_4750418   BrayCurtisDiss  5.000000e-01  5.555556e-03
      2059 2007  431_4750418      JaccardDiss  1.000000e+00  5.555556e-03
      2060 2007  431_4750418 MorisitaHornDiss  1.000000e+00  7.407407e-03
      2061 2007  431_4750418   BrayCurtisDiss  1.000000e+00  5.555556e-03
      2062 1985  431_4743129      JaccardDiss  0.000000e+00  1.700087e-02
      2063 1985  431_4743129 MorisitaHornDiss  0.000000e+00  1.700087e-02
      2064 1985  431_4743129   BrayCurtisDiss  4.285714e-01  9.714784e-03
      2065 1986  431_4743129      JaccardDiss  1.000000e+00  1.700087e-02
      2066 1986  431_4743129 MorisitaHornDiss  1.000000e+00  1.700087e-02
      2067 1986  431_4743129   BrayCurtisDiss  1.000000e+00  9.714784e-03
      2068 1984  431_4743129      JaccardDiss  1.000000e+00  1.700087e-02
      2069 1984  431_4743129 MorisitaHornDiss  1.000000e+00  1.700087e-02
      2070 1984  431_4743129   BrayCurtisDiss  1.000000e+00  9.714784e-03
      2071 2004  431_4743129      JaccardDiss  1.000000e+00  1.700087e-02
      2072 2004  431_4743129 MorisitaHornDiss  1.000000e+00  1.700087e-02
      2073 2004  431_4743129   BrayCurtisDiss  1.000000e+00  9.714784e-03
      2074 2005  431_4743129      JaccardDiss  1.000000e+00  1.700087e-02
      2075 2005  431_4743129 MorisitaHornDiss  1.000000e+00  1.700087e-02
      2076 2005  431_4743129   BrayCurtisDiss  1.000000e+00  9.714784e-03
      2077 2010  431_5125142      JaccardDiss  6.666667e-01 -1.797862e-02
      2078 2010  431_5125142 MorisitaHornDiss  2.466974e-03 -2.498702e-02
      2079 2010  431_5125142   BrayCurtisDiss  1.742424e-01 -2.096175e-02
      2080 2011  431_5125142      JaccardDiss  6.666667e-01 -1.797862e-02
      2081 2011  431_5125142 MorisitaHornDiss  9.908483e-01 -2.498702e-02
      2082 2011  431_5125142   BrayCurtisDiss  9.829060e-01 -2.096175e-02
      2083 1992  431_5125142      JaccardDiss  1.000000e+00 -1.797862e-02
      2084 1992  431_5125142 MorisitaHornDiss  1.000000e+00 -2.498702e-02
      2085 1992  431_5125142   BrayCurtisDiss  1.000000e+00 -2.096175e-02
      2086 2013  431_4757692      JaccardDiss  3.333333e-01 -4.166667e-02
      2087 2013  431_4757692 MorisitaHornDiss  4.091165e-01  1.158437e-01
      2088 2013  431_4757692   BrayCurtisDiss  6.862745e-01  1.365067e-01
      2089 2011  431_4757692      JaccardDiss  6.666667e-01 -4.166667e-02
      2090 2011  431_4757692 MorisitaHornDiss  1.030928e-02  1.158437e-01
      2091 2011  431_4757692   BrayCurtisDiss  1.612903e-01  1.365067e-01
      2092 2015  431_4757692      JaccardDiss  5.000000e-01 -4.166667e-02
      2093 2015  431_4757692 MorisitaHornDiss  4.736842e-01  1.158437e-01
      2094 2015  431_4757692   BrayCurtisDiss  7.073171e-01  1.365067e-01
      2095 2009  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2096 2009  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2097 2009  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2098 2008  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2099 2008  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2100 2008  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2101 2010  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2102 2010  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2103 2010  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2104 2011  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2105 2011  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2106 2011  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2107 2012  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2108 2012  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2109 2012  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2110 2013  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2111 2013  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2112 2013  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2113 2014  431_4755504      JaccardDiss  1.000000e+00 -8.333333e-02
      2114 2014  431_4755504 MorisitaHornDiss  1.000000e+00 -8.333333e-02
      2115 2014  431_4755504   BrayCurtisDiss  1.000000e+00 -2.192982e-02
      2116 2015  431_4755504      JaccardDiss  0.000000e+00 -8.333333e-02
      2117 2015  431_4755504 MorisitaHornDiss  0.000000e+00 -8.333333e-02
      2118 2015  431_4755504   BrayCurtisDiss  7.368421e-01 -2.192982e-02
      2119 2001  431_5112765      JaccardDiss  8.000000e-01  4.452381e-02
      2120 2001  431_5112765 MorisitaHornDiss  7.914692e-01  3.414783e-02
      2121 2001  431_5112765   BrayCurtisDiss  8.095238e-01  3.542237e-02
      2122 1997  431_5112765      JaccardDiss  7.500000e-01  4.452381e-02
      2123 1997  431_5112765 MorisitaHornDiss  7.666667e-01  3.414783e-02
      2124 1997  431_5112765   BrayCurtisDiss  7.500000e-01  3.542237e-02
      2125 1998  431_5112765      JaccardDiss  6.666667e-01  4.452381e-02
      2126 1998  431_5112765 MorisitaHornDiss  8.636364e-01  3.414783e-02
      2127 1998  431_5112765   BrayCurtisDiss  8.750000e-01  3.542237e-02
      2128 1999  431_5112765      JaccardDiss  5.000000e-01  4.452381e-02
      2129 1999  431_5112765 MorisitaHornDiss  3.333333e-01  3.414783e-02
      2130 1999  431_5112765   BrayCurtisDiss  4.117647e-01  3.542237e-02
      2131 2003  431_5112765      JaccardDiss  1.000000e+00  4.452381e-02
      2132 2003  431_5112765 MorisitaHornDiss  1.000000e+00  3.414783e-02
      2133 2003  431_5112765   BrayCurtisDiss  1.000000e+00  3.542237e-02
      2134 2000  431_5112765      JaccardDiss  2.500000e-01  4.452381e-02
      2135 2000  431_5112765 MorisitaHornDiss  3.426529e-01  3.414783e-02
      2136 2000  431_5112765   BrayCurtisDiss  4.400000e-01  3.542237e-02
      2137 1985  431_4735113      JaccardDiss  8.000000e-01  1.036916e-02
      2138 1985  431_4735113 MorisitaHornDiss  9.114583e-01  4.503762e-03
      2139 1985  431_4735113   BrayCurtisDiss  9.000000e-01  5.863192e-03
      2140 2002  431_4735113      JaccardDiss  1.000000e+00  1.036916e-02
      2141 2002  431_4735113 MorisitaHornDiss  1.000000e+00  4.503762e-03
      2142 2002  431_4735113   BrayCurtisDiss  1.000000e+00  5.863192e-03
      2143 1984  431_4735113      JaccardDiss  8.333333e-01  1.036916e-02
      2144 1984  431_4735113 MorisitaHornDiss  9.290188e-01  4.503762e-03
      2145 1984  431_4735113   BrayCurtisDiss  8.947368e-01  5.863192e-03
      2146 2000  431_5101117      JaccardDiss  5.000000e-01 -8.333333e-05
      2147 2000  431_5101117 MorisitaHornDiss  9.706129e-01 -7.000943e-03
      2148 2000  431_5101117   BrayCurtisDiss  9.444444e-01 -4.840580e-03
      2149 2010  431_5101117      JaccardDiss  6.666667e-01 -8.333333e-05
      2150 2010  431_5101117 MorisitaHornDiss  7.684211e-01 -7.000943e-03
      2151 2010  431_5101117   BrayCurtisDiss  8.333333e-01 -4.840580e-03
      2152 2011  431_5101117      JaccardDiss  1.000000e+00 -8.333333e-05
      2153 2011  431_5101117 MorisitaHornDiss  1.000000e+00 -7.000943e-03
      2154 2011  431_5101117   BrayCurtisDiss  1.000000e+00 -4.840580e-03
      2155 1999  431_5101117      JaccardDiss  1.000000e+00 -8.333333e-05
      2156 1999  431_5101117 MorisitaHornDiss  1.000000e+00 -7.000943e-03
      2157 1999  431_5101117   BrayCurtisDiss  1.000000e+00 -4.840580e-03
      2158 2003  431_5101117      JaccardDiss  1.000000e+00 -8.333333e-05
      2159 2003  431_5101117 MorisitaHornDiss  1.000000e+00 -7.000943e-03
      2160 2003  431_5101117   BrayCurtisDiss  1.000000e+00 -4.840580e-03
      2161 2004  431_5101117      JaccardDiss  1.000000e+00 -8.333333e-05
      2162 2004  431_5101117 MorisitaHornDiss  1.000000e+00 -7.000943e-03
      2163 2004  431_5101117   BrayCurtisDiss  1.000000e+00 -4.840580e-03
      2164 2009  431_5101117      JaccardDiss  7.500000e-01 -8.333333e-05
      2165 2009  431_5101117 MorisitaHornDiss  9.931410e-01 -7.000943e-03
      2166 2009  431_5101117   BrayCurtisDiss  9.565217e-01 -4.840580e-03
      2167 2008  431_4751862      JaccardDiss  1.000000e+00 -8.568980e-04
      2168 2008  431_4751862 MorisitaHornDiss  1.000000e+00 -1.130686e-02
      2169 2008  431_4751862   BrayCurtisDiss  1.000000e+00 -4.116877e-03
      2170 2013  431_4751862      JaccardDiss  6.666667e-01 -8.568980e-04
      2171 2013  431_4751862 MorisitaHornDiss  8.077056e-01 -1.130686e-02
      2172 2013  431_4751862   BrayCurtisDiss  9.324324e-01 -4.116877e-03
      2173 1999  431_4751862      JaccardDiss  6.666667e-01 -8.568980e-04
      2174 1999  431_4751862 MorisitaHornDiss  8.766048e-01 -1.130686e-02
      2175 1999  431_4751862   BrayCurtisDiss  8.620690e-01 -4.116877e-03
      2176 2000  431_4751862      JaccardDiss  1.000000e+00 -8.568980e-04
      2177 2000  431_4751862 MorisitaHornDiss  1.000000e+00 -1.130686e-02
      2178 2000  431_4751862   BrayCurtisDiss  1.000000e+00 -4.116877e-03
      2179 2004  431_4751862      JaccardDiss  1.000000e+00 -8.568980e-04
      2180 2004  431_4751862 MorisitaHornDiss  1.000000e+00 -1.130686e-02
      2181 2004  431_4751862   BrayCurtisDiss  1.000000e+00 -4.116877e-03
      2182 2007  431_4751862      JaccardDiss  6.666667e-01 -8.568980e-04
      2183 2007  431_4751862 MorisitaHornDiss  8.200374e-03 -1.130686e-02
      2184 2007  431_4751862   BrayCurtisDiss  6.153846e-01 -4.116877e-03
      2185 2009  431_4751862      JaccardDiss  6.666667e-01 -8.568980e-04
      2186 2009  431_4751862 MorisitaHornDiss  3.972065e-02 -1.130686e-02
      2187 2009  431_4751862   BrayCurtisDiss  2.380952e-01 -4.116877e-03
      2188 2010  431_4751862      JaccardDiss  1.000000e+00 -8.568980e-04
      2189 2010  431_4751862 MorisitaHornDiss  1.000000e+00 -1.130686e-02
      2190 2010  431_4751862   BrayCurtisDiss  1.000000e+00 -4.116877e-03
      2191 2012  431_4751862      JaccardDiss  6.666667e-01 -8.568980e-04
      2192 2012  431_4751862 MorisitaHornDiss  7.710878e-02 -1.130686e-02
      2193 2012  431_4751862   BrayCurtisDiss  8.969072e-01 -4.116877e-03
      2194 2014  431_4751862      JaccardDiss  5.000000e-01 -8.568980e-04
      2195 2014  431_4751862 MorisitaHornDiss  9.009009e-03 -1.130686e-02
      2196 2014  431_4751862   BrayCurtisDiss  6.923077e-01 -4.116877e-03
      2197 2002  431_4751862      JaccardDiss  5.000000e-01 -8.568980e-04
      2198 2002  431_4751862 MorisitaHornDiss  9.009009e-03 -1.130686e-02
      2199 2002  431_4751862   BrayCurtisDiss  8.333333e-01 -4.116877e-03
      2200 2003  431_4751862      JaccardDiss  5.000000e-01 -8.568980e-04
      2201 2003  431_4751862 MorisitaHornDiss  9.009009e-03 -1.130686e-02
      2202 2003  431_4751862   BrayCurtisDiss  7.916667e-01 -4.116877e-03
      2203 2011  431_4751862      JaccardDiss  5.000000e-01 -8.568980e-04
      2204 2011  431_4751862 MorisitaHornDiss  9.009009e-03 -1.130686e-02
      2205 2011  431_4751862   BrayCurtisDiss  6.923077e-01 -4.116877e-03
      2206 2015  431_4751862      JaccardDiss  1.000000e+00 -8.568980e-04
      2207 2015  431_4751862 MorisitaHornDiss  1.000000e+00 -1.130686e-02
      2208 2015  431_4751862   BrayCurtisDiss  1.000000e+00 -4.116877e-03
      2209 1999  431_4754796      JaccardDiss  1.000000e+00 -1.494446e-17
      2210 1999  431_4754796 MorisitaHornDiss  1.000000e+00 -1.494446e-17
      2211 1999  431_4754796   BrayCurtisDiss  1.000000e+00 -1.494446e-17
      2212 2000  431_4754796      JaccardDiss  1.000000e+00 -1.494446e-17
      2213 2000  431_4754796 MorisitaHornDiss  1.000000e+00 -1.494446e-17
      2214 2000  431_4754796   BrayCurtisDiss  1.000000e+00 -1.494446e-17
      2215 2005  431_4754796      JaccardDiss  1.000000e+00 -1.494446e-17
      2216 2005  431_4754796 MorisitaHornDiss  1.000000e+00 -1.494446e-17
      2217 2005  431_4754796   BrayCurtisDiss  1.000000e+00 -1.494446e-17
      2218 2009  431_4753316      JaccardDiss  2.500000e-01  1.388889e-02
      2219 2009  431_4753316 MorisitaHornDiss  4.634146e-01 -8.793290e-03
      2220 2009  431_4753316   BrayCurtisDiss  6.000000e-01  1.111111e-02
      2221 2012  431_4753316      JaccardDiss  7.500000e-01  1.388889e-02
      2222 2012  431_4753316 MorisitaHornDiss  6.875000e-01 -8.793290e-03
      2223 2012  431_4753316   BrayCurtisDiss  8.000000e-01  1.111111e-02
      2224 2006  431_4753316      JaccardDiss  6.666667e-01  1.388889e-02
      2225 2006  431_4753316 MorisitaHornDiss  7.402597e-01 -8.793290e-03
      2226 2006  431_4753316   BrayCurtisDiss  7.333333e-01  1.111111e-02
      2227 2006  431_4748945      JaccardDiss  1.000000e+00 -2.093973e-02
      2228 2006  431_4748945 MorisitaHornDiss  1.000000e+00 -2.791965e-02
      2229 2006  431_4748945   BrayCurtisDiss  1.000000e+00 -1.080760e-02
      2230 1993  431_4748945      JaccardDiss  1.000000e+00 -2.093973e-02
      2231 1993  431_4748945 MorisitaHornDiss  1.000000e+00 -2.791965e-02
      2232 1993  431_4748945   BrayCurtisDiss  1.000000e+00 -1.080760e-02
      2233 2005  431_4748945      JaccardDiss  1.000000e+00 -2.093973e-02
      2234 2005  431_4748945 MorisitaHornDiss  1.000000e+00 -2.791965e-02
      2235 2005  431_4748945   BrayCurtisDiss  1.000000e+00 -1.080760e-02
      2236 2015  431_4748945      JaccardDiss  5.000000e-01 -2.093973e-02
      2237 2015  431_4748945 MorisitaHornDiss  3.333333e-01 -2.791965e-02
      2238 2015  431_4748945   BrayCurtisDiss  7.419355e-01 -1.080760e-02
      2239 1986  431_4780294      JaccardDiss  6.666667e-01 -3.846154e-02
      2240 1986  431_4780294 MorisitaHornDiss  2.352941e-01 -1.357466e-02
      2241 1986  431_4780294   BrayCurtisDiss  3.000000e-01  2.838338e-03
      2242 1996  431_4780294      JaccardDiss  6.666667e-01 -3.846154e-02
      2243 1996  431_4780294 MorisitaHornDiss  2.352941e-01 -1.357466e-02
      2244 1996  431_4780294   BrayCurtisDiss  5.294118e-01  2.838338e-03
      2245 2000  431_4780294      JaccardDiss  0.000000e+00 -3.846154e-02
      2246 2000  431_4780294 MorisitaHornDiss  0.000000e+00 -1.357466e-02
      2247 2000  431_4780294   BrayCurtisDiss  2.727273e-01  2.838338e-03
      2248 1996  431_4743840      JaccardDiss  5.000000e-01 -1.060838e-02
      2249 1996  431_4743840 MorisitaHornDiss  3.333333e-01 -7.072256e-03
      2250 1996  431_4743840   BrayCurtisDiss  7.142857e-01 -6.539992e-03
      2251 1990  431_4743840      JaccardDiss  5.000000e-01 -1.060838e-02
      2252 1990  431_4743840 MorisitaHornDiss  3.333333e-01 -7.072256e-03
      2253 1990  431_4743840   BrayCurtisDiss  9.689922e-01 -6.539992e-03
      2254 1995  431_4743840      JaccardDiss  5.000000e-01 -1.060838e-02
      2255 1995  431_4743840 MorisitaHornDiss  3.333333e-01 -7.072256e-03
      2256 1995  431_4743840   BrayCurtisDiss  6.000000e-01 -6.539992e-03
      2257 1998  431_4743840      JaccardDiss  5.000000e-01 -1.060838e-02
      2258 1998  431_4743840 MorisitaHornDiss  3.333333e-01 -7.072256e-03
      2259 1998  431_4743840   BrayCurtisDiss  6.000000e-01 -6.539992e-03
      2260 2009  431_4743840      JaccardDiss  5.000000e-01 -1.060838e-02
      2261 2009  431_4743840 MorisitaHornDiss  3.333333e-01 -7.072256e-03
      2262 2009  431_4743840   BrayCurtisDiss  8.095238e-01 -6.539992e-03
      2263 2013  431_4743840      JaccardDiss  5.000000e-01 -1.060838e-02
      2264 2013  431_4743840 MorisitaHornDiss  3.333333e-01 -7.072256e-03
      2265 2013  431_4743840   BrayCurtisDiss  3.333333e-01 -6.539992e-03
      2266 2014  431_4743840      JaccardDiss  0.000000e+00 -1.060838e-02
      2267 2014  431_4743840 MorisitaHornDiss  0.000000e+00 -7.072256e-03
      2268 2014  431_4743840   BrayCurtisDiss  8.518519e-01 -6.539992e-03
      2269 2008  431_4780288      JaccardDiss  1.000000e+00 -2.241379e-02
      2270 2008  431_4780288 MorisitaHornDiss  1.000000e+00 -1.066733e-03
      2271 2008  431_4780288   BrayCurtisDiss  1.000000e+00 -1.949025e-03
      2272 1996  431_4780288      JaccardDiss  1.000000e+00 -2.241379e-02
      2273 1996  431_4780288 MorisitaHornDiss  1.000000e+00 -1.066733e-03
      2274 1996  431_4780288   BrayCurtisDiss  1.000000e+00 -1.949025e-03
      2275 1997  431_4780288      JaccardDiss  1.000000e+00 -2.241379e-02
      2276 1997  431_4780288 MorisitaHornDiss  1.000000e+00 -1.066733e-03
      2277 1997  431_4780288   BrayCurtisDiss  1.000000e+00 -1.949025e-03
      2278 2009  431_4780288      JaccardDiss  5.000000e-01 -2.241379e-02
      2279 2009  431_4780288 MorisitaHornDiss  9.762037e-01 -1.066733e-03
      2280 2009  431_4780288   BrayCurtisDiss  9.565217e-01 -1.949025e-03
      2281 2008  431_4780295      JaccardDiss  6.666667e-01 -1.889339e-02
      2282 2008  431_4780295 MorisitaHornDiss  3.513514e-02 -9.957326e-04
      2283 2008  431_4780295   BrayCurtisDiss  9.090909e-01 -6.455116e-03
      2284 1995  431_4780295      JaccardDiss  6.666667e-01 -1.889339e-02
      2285 1995  431_4780295 MorisitaHornDiss  3.513514e-02 -9.957326e-04
      2286 1995  431_4780295   BrayCurtisDiss  8.260870e-01 -6.455116e-03
      2287 2000  431_4780295      JaccardDiss  6.666667e-01 -1.889339e-02
      2288 2000  431_4780295 MorisitaHornDiss  3.513514e-02 -9.957326e-04
      2289 2000  431_4780295   BrayCurtisDiss  6.800000e-01 -6.455116e-03
      2290 2003  431_4780295      JaccardDiss  6.666667e-01 -1.889339e-02
      2291 2003  431_4780295 MorisitaHornDiss  3.513514e-02 -9.957326e-04
      2292 2003  431_4780295   BrayCurtisDiss  7.500000e-01 -6.455116e-03
      2293 2005  431_4780295      JaccardDiss  0.000000e+00 -1.889339e-02
      2294 2005  431_4780295 MorisitaHornDiss  0.000000e+00 -9.957326e-04
      2295 2005  431_4780295   BrayCurtisDiss  3.333333e-01 -6.455116e-03
      2296 2000  431_4737299      JaccardDiss  1.000000e+00  8.928571e-02
      2297 2000  431_4737299 MorisitaHornDiss  1.000000e+00  9.973736e-03
      2298 2000  431_4737299   BrayCurtisDiss  1.000000e+00  3.401361e-02
      2299 1997  431_4737299      JaccardDiss  7.500000e-01  8.928571e-02
      2300 1997  431_4737299 MorisitaHornDiss  9.720735e-01  9.973736e-03
      2301 1997  431_4737299   BrayCurtisDiss  9.047619e-01  3.401361e-02
      2302 1999  431_4737299      JaccardDiss  1.000000e+00  8.928571e-02
      2303 1999  431_4737299 MorisitaHornDiss  1.000000e+00  9.973736e-03
      2304 1999  431_4737299   BrayCurtisDiss  1.000000e+00  3.401361e-02
      2305 2004  431_4763548      JaccardDiss  1.000000e+00 -9.677419e-02
      2306 2004  431_4763548 MorisitaHornDiss  1.000000e+00 -9.677419e-02
      2307 2004  431_4763548   BrayCurtisDiss  1.000000e+00 -2.764977e-02
      2308 2001  431_4763548      JaccardDiss  1.000000e+00 -9.677419e-02
      2309 2001  431_4763548 MorisitaHornDiss  1.000000e+00 -9.677419e-02
      2310 2001  431_4763548   BrayCurtisDiss  1.000000e+00 -2.764977e-02
      2311 2006  431_4763548      JaccardDiss  1.000000e+00 -9.677419e-02
      2312 2006  431_4763548 MorisitaHornDiss  1.000000e+00 -9.677419e-02
      2313 2006  431_4763548   BrayCurtisDiss  1.000000e+00 -2.764977e-02
      2314 2007  431_4763548      JaccardDiss  1.000000e+00 -9.677419e-02
      2315 2007  431_4763548 MorisitaHornDiss  1.000000e+00 -9.677419e-02
      2316 2007  431_4763548   BrayCurtisDiss  1.000000e+00 -2.764977e-02
      2317 2009  431_4763548      JaccardDiss  0.000000e+00 -9.677419e-02
      2318 2009  431_4763548 MorisitaHornDiss  0.000000e+00 -9.677419e-02
      2319 2009  431_4763548   BrayCurtisDiss  7.142857e-01 -2.764977e-02
      2320 1997  431_4780289      JaccardDiss  1.000000e+00 -2.027027e-02
      2321 1997  431_4780289 MorisitaHornDiss  1.000000e+00 -4.052584e-02
      2322 1997  431_4780289   BrayCurtisDiss  1.000000e+00  3.134821e-02
      2323 2007  431_4780289      JaccardDiss  5.000000e-01 -2.027027e-02
      2324 2007  431_4780289 MorisitaHornDiss  3.627131e-04 -4.052584e-02
      2325 2007  431_4780289   BrayCurtisDiss  8.928571e-01  3.134821e-02
      2326 1996  431_4780289      JaccardDiss  5.000000e-01 -2.027027e-02
      2327 1996  431_4780289 MorisitaHornDiss  3.627131e-04 -4.052584e-02
      2328 1996  431_4780289   BrayCurtisDiss  2.325581e-01  3.134821e-02
      2329 2000  431_4780289      JaccardDiss  1.000000e+00 -2.027027e-02
      2330 2000  431_4780289 MorisitaHornDiss  1.000000e+00 -4.052584e-02
      2331 2000  431_4780289   BrayCurtisDiss  1.000000e+00  3.134821e-02
      2332 1999  431_5113490      JaccardDiss  1.000000e+00 -4.891304e-02
      2333 1999  431_5113490 MorisitaHornDiss  1.000000e+00 -7.178244e-02
      2334 1999  431_5113490   BrayCurtisDiss  1.000000e+00 -4.745710e-02
      2335 2001  431_5113490      JaccardDiss  1.000000e+00 -4.891304e-02
      2336 2001  431_5113490 MorisitaHornDiss  1.000000e+00 -7.178244e-02
      2337 2001  431_5113490   BrayCurtisDiss  1.000000e+00 -4.745710e-02
      2338 2004  431_5113490      JaccardDiss  7.500000e-01 -4.891304e-02
      2339 2004  431_5113490 MorisitaHornDiss  9.318613e-01 -7.178244e-02
      2340 2004  431_5113490   BrayCurtisDiss  9.509202e-01 -4.745710e-02
      2341 2010  431_5113490      JaccardDiss  5.000000e-01 -4.891304e-02
      2342 2010  431_5113490 MorisitaHornDiss  2.432432e-01 -7.178244e-02
      2343 2010  431_5113490   BrayCurtisDiss  5.000000e-01 -4.745710e-02
      2344 2006  431_5111311      JaccardDiss  1.000000e+00 -6.024096e-02
      2345 2006  431_5111311 MorisitaHornDiss  1.000000e+00 -1.188315e-01
      2346 2006  431_5111311   BrayCurtisDiss  1.000000e+00 -4.184009e-02
      2347 2012  431_5111311      JaccardDiss  5.000000e-01 -6.024096e-02
      2348 2012  431_5111311 MorisitaHornDiss  1.369863e-02 -1.188315e-01
      2349 2012  431_5111311   BrayCurtisDiss  6.363636e-01 -4.184009e-02
      2350 2010  431_5111311      JaccardDiss  5.000000e-01 -6.024096e-02
      2351 2010  431_5111311 MorisitaHornDiss  1.369863e-02 -1.188315e-01
      2352 2010  431_5111311   BrayCurtisDiss  8.000000e-01 -4.184009e-02
      2353 2011  431_5111311      JaccardDiss  1.000000e+00 -6.024096e-02
      2354 2011  431_5111311 MorisitaHornDiss  1.000000e+00 -1.188315e-01
      2355 2011  431_5111311   BrayCurtisDiss  1.000000e+00 -4.184009e-02
      2356 2008  431_5114950      JaccardDiss  3.333333e-01  8.333333e-02
      2357 2008  431_5114950 MorisitaHornDiss  4.377916e-03  1.719318e-02
      2358 2008  431_5114950   BrayCurtisDiss  4.423077e-01  1.716479e-02
      2359 2010  431_5114950      JaccardDiss  6.666667e-01  8.333333e-02
      2360 2010  431_5114950 MorisitaHornDiss  8.957286e-01  1.719318e-02
      2361 2010  431_5114950   BrayCurtisDiss  9.794872e-01  1.716479e-02
      2362 2006  431_5114950      JaccardDiss  3.333333e-01  8.333333e-02
      2363 2006  431_5114950 MorisitaHornDiss  8.269559e-01  1.719318e-02
      2364 2006  431_5114950   BrayCurtisDiss  9.108280e-01  1.716479e-02
      2365 1997  431_4750417      JaccardDiss  1.000000e+00 -5.000000e-01
      2366 1997  431_4750417 MorisitaHornDiss  1.000000e+00 -5.000000e-01
      2367 1997  431_4750417   BrayCurtisDiss  1.000000e+00 -3.333333e-01
      2368 1996  431_4750417      JaccardDiss  1.000000e+00 -5.000000e-01
      2369 1996  431_4750417 MorisitaHornDiss  1.000000e+00 -5.000000e-01
      2370 1996  431_4750417   BrayCurtisDiss  1.000000e+00 -3.333333e-01
      2371 1998  431_4750417      JaccardDiss  0.000000e+00 -5.000000e-01
      2372 1998  431_4750417 MorisitaHornDiss  0.000000e+00 -5.000000e-01
      2373 1998  431_4750417   BrayCurtisDiss  3.333333e-01 -3.333333e-01
      2374 1985  431_4735842      JaccardDiss  1.000000e+00  1.829268e-02
      2375 1985  431_4735842 MorisitaHornDiss  1.000000e+00  3.377111e-02
      2376 1985  431_4735842   BrayCurtisDiss  1.000000e+00  2.439024e-02
      2377 1984  431_4735842      JaccardDiss  5.000000e-01  1.829268e-02
      2378 1984  431_4735842 MorisitaHornDiss  7.692308e-02  3.377111e-02
      2379 1984  431_4735842   BrayCurtisDiss  3.333333e-01  2.439024e-02
      2380 1997  431_4735842      JaccardDiss  1.000000e+00  1.829268e-02
      2381 1997  431_4735842 MorisitaHornDiss  1.000000e+00  3.377111e-02
      2382 1997  431_4735842   BrayCurtisDiss  1.000000e+00  2.439024e-02
      2383 2000  431_4735842      JaccardDiss  1.000000e+00  1.829268e-02
      2384 2000  431_4735842 MorisitaHornDiss  1.000000e+00  3.377111e-02
      2385 2000  431_4735842   BrayCurtisDiss  1.000000e+00  2.439024e-02
      2386 1999  431_4735842      JaccardDiss  1.000000e+00  1.829268e-02
      2387 1999  431_4735842 MorisitaHornDiss  1.000000e+00  3.377111e-02
      2388 1999  431_4735842   BrayCurtisDiss  1.000000e+00  2.439024e-02
      2389 2003  431_5139691      JaccardDiss  1.000000e+00 -1.326531e-01
      2390 2003  431_5139691 MorisitaHornDiss  1.000000e+00 -1.326531e-01
      2391 2003  431_5139691   BrayCurtisDiss  1.000000e+00 -1.105442e-01
      2392 2000  431_5139691      JaccardDiss  1.000000e+00 -1.326531e-01
      2393 2000  431_5139691 MorisitaHornDiss  1.000000e+00 -1.326531e-01
      2394 2000  431_5139691   BrayCurtisDiss  1.000000e+00 -1.105442e-01
      2395 2008  431_5139691      JaccardDiss  0.000000e+00 -1.326531e-01
      2396 2008  431_5139691 MorisitaHornDiss  0.000000e+00 -1.326531e-01
      2397 2008  431_5139691   BrayCurtisDiss  1.666667e-01 -1.105442e-01
      2398 2004  431_4775942      JaccardDiss  0.000000e+00  2.815315e-02
      2399 2004  431_4775942 MorisitaHornDiss  2.507740e-01  2.290603e-03
      2400 2004  431_4775942   BrayCurtisDiss  5.294118e-01 -3.504187e-03
      2401 2006  431_4775942      JaccardDiss  6.666667e-01  2.815315e-02
      2402 2006  431_4775942 MorisitaHornDiss  5.000000e-01  2.290603e-03
      2403 2006  431_4775942   BrayCurtisDiss  7.500000e-01 -3.504187e-03
      2404 2011  431_4775942      JaccardDiss  5.000000e-01  2.815315e-02
      2405 2011  431_4775942 MorisitaHornDiss  3.333333e-01  2.290603e-03
      2406 2011  431_4775942   BrayCurtisDiss  4.545455e-01 -3.504187e-03
      2407 2002  431_4775942      JaccardDiss  5.000000e-01  2.815315e-02
      2408 2002  431_4775942 MorisitaHornDiss  3.333333e-01  2.290603e-03
      2409 2002  431_4775942   BrayCurtisDiss  6.000000e-01 -3.504187e-03
      2410 2007  431_4775942      JaccardDiss  5.000000e-01  2.815315e-02
      2411 2007  431_4775942 MorisitaHornDiss  3.333333e-01  2.290603e-03
      2412 2007  431_4775942   BrayCurtisDiss  5.714286e-01 -3.504187e-03
      2413 2008  431_4775942      JaccardDiss  6.666667e-01  2.815315e-02
      2414 2008  431_4775942 MorisitaHornDiss  3.188854e-01  2.290603e-03
      2415 2008  431_4775942   BrayCurtisDiss  8.461538e-01 -3.504187e-03
      2416 2006  431_4751863      JaccardDiss  7.500000e-01 -3.759398e-03
      2417 2006  431_4751863 MorisitaHornDiss  9.416363e-01 -3.455693e-02
      2418 2006  431_4751863   BrayCurtisDiss  9.354839e-01 -2.388407e-02
      2419 2005  431_4751863      JaccardDiss  7.500000e-01 -3.759398e-03
      2420 2005  431_4751863 MorisitaHornDiss  9.419659e-01 -3.455693e-02
      2421 2005  431_4751863   BrayCurtisDiss  9.310345e-01 -2.388407e-02
      2422 2003  431_4751863      JaccardDiss  1.000000e+00 -3.759398e-03
      2423 2003  431_4751863 MorisitaHornDiss  1.000000e+00 -3.455693e-02
      2424 2003  431_4751863   BrayCurtisDiss  1.000000e+00 -2.388407e-02
      2425 2004  431_4751863      JaccardDiss  5.000000e-01 -3.759398e-03
      2426 2004  431_4751863 MorisitaHornDiss  4.010889e-01 -3.455693e-02
      2427 2004  431_4751863   BrayCurtisDiss  6.333333e-01 -2.388407e-02
      2428 2007  431_4751863      JaccardDiss  3.333333e-01 -3.759398e-03
      2429 2007  431_4751863 MorisitaHornDiss  9.300401e-01 -3.455693e-02
      2430 2007  431_4751863   BrayCurtisDiss  9.503106e-01 -2.388407e-02
      2431 2013  431_4751863      JaccardDiss  7.500000e-01 -3.759398e-03
      2432 2013  431_4751863 MorisitaHornDiss  9.418797e-01 -3.455693e-02
      2433 2013  431_4751863   BrayCurtisDiss  9.565217e-01 -2.388407e-02
      2434 2009  431_4751863      JaccardDiss  6.666667e-01 -3.759398e-03
      2435 2009  431_4751863 MorisitaHornDiss  9.432624e-01 -3.455693e-02
      2436 2009  431_4751863   BrayCurtisDiss  9.310345e-01 -2.388407e-02
      2437 2002  431_4751863      JaccardDiss  6.666667e-01 -3.759398e-03
      2438 2002  431_4751863 MorisitaHornDiss  9.432624e-01 -3.455693e-02
      2439 2002  431_4751863   BrayCurtisDiss  9.200000e-01 -2.388407e-02
      2440 2008  431_4751863      JaccardDiss  6.666667e-01 -3.759398e-03
      2441 2008  431_4751863 MorisitaHornDiss  9.432624e-01 -3.455693e-02
      2442 2008  431_4751863   BrayCurtisDiss  9.200000e-01 -2.388407e-02
      2443 2015  431_4751863      JaccardDiss  6.666667e-01 -3.759398e-03
      2444 2015  431_4751863 MorisitaHornDiss  4.436860e-02 -3.455693e-02
      2445 2015  431_4751863   BrayCurtisDiss  3.333333e-01 -2.388407e-02
      2446 1999  431_5109126      JaccardDiss  7.500000e-01 -1.282051e-02
      2447 1999  431_5109126 MorisitaHornDiss  9.608510e-01 -2.680414e-02
      2448 1999  431_5109126   BrayCurtisDiss  9.047619e-01 -2.574003e-02
      2449 1993  431_5109126      JaccardDiss  6.666667e-01 -1.282051e-02
      2450 1993  431_5109126 MorisitaHornDiss  9.086614e-01 -2.680414e-02
      2451 1993  431_5109126   BrayCurtisDiss  8.918919e-01 -2.574003e-02
      2452 2001  431_5109126      JaccardDiss  5.000000e-01 -1.282051e-02
      2453 2001  431_5109126 MorisitaHornDiss  6.090226e-01 -2.680414e-02
      2454 2001  431_5109126   BrayCurtisDiss  6.190476e-01 -2.574003e-02
      2455 2003  431_4744587      JaccardDiss  5.000000e-01  4.331683e-03
      2456 2003  431_4744587 MorisitaHornDiss  3.333333e-01  1.650165e-02
      2457 2003  431_4744587   BrayCurtisDiss  3.333333e-01  6.188119e-03
      2458 2008  431_4744587      JaccardDiss  5.000000e-01  4.331683e-03
      2459 2008  431_4744587 MorisitaHornDiss  3.333333e-01  1.650165e-02
      2460 2008  431_4744587   BrayCurtisDiss  3.333333e-01  6.188119e-03
      2461 2010  431_4744587      JaccardDiss  1.000000e+00  4.331683e-03
      2462 2010  431_4744587 MorisitaHornDiss  1.000000e+00  1.650165e-02
      2463 2010  431_4744587   BrayCurtisDiss  1.000000e+00  6.188119e-03
      2464 2002  431_4744587      JaccardDiss  5.000000e-01  4.331683e-03
      2465 2002  431_4744587 MorisitaHornDiss  3.333333e-01  1.650165e-02
      2466 2002  431_4744587   BrayCurtisDiss  5.000000e-01  6.188119e-03
      2467 1998  431_4744587      JaccardDiss  5.000000e-01  4.331683e-03
      2468 1998  431_4744587 MorisitaHornDiss  3.333333e-01  1.650165e-02
      2469 1998  431_4744587   BrayCurtisDiss  5.000000e-01  6.188119e-03
      2470 2007  431_4744587      JaccardDiss  5.000000e-01  4.331683e-03
      2471 2007  431_4744587 MorisitaHornDiss  3.333333e-01  1.650165e-02
      2472 2007  431_4744587   BrayCurtisDiss  6.666667e-01  6.188119e-03
      2473 2009  431_4744587      JaccardDiss  0.000000e+00  4.331683e-03
      2474 2009  431_4744587 MorisitaHornDiss  0.000000e+00  1.650165e-02
      2475 2009  431_4744587   BrayCurtisDiss  0.000000e+00  6.188119e-03
      2476 2009  431_4739476      JaccardDiss  6.000000e-01 -4.489796e-02
      2477 2009  431_4739476 MorisitaHornDiss  5.211918e-01 -5.374378e-02
      2478 2009  431_4739476   BrayCurtisDiss  9.550562e-01 -5.044715e-03
      2479 2006  431_4739476      JaccardDiss  1.000000e+00 -4.489796e-02
      2480 2006  431_4739476 MorisitaHornDiss  1.000000e+00 -5.374378e-02
      2481 2006  431_4739476   BrayCurtisDiss  1.000000e+00 -5.044715e-03
      2482 2001  431_4739476      JaccardDiss  1.000000e+00 -4.489796e-02
      2483 2001  431_4739476 MorisitaHornDiss  1.000000e+00 -5.374378e-02
      2484 2001  431_4739476   BrayCurtisDiss  1.000000e+00 -5.044715e-03
      2485 2009  431_4753322      JaccardDiss  7.500000e-01 -1.416795e-03
      2486 2009  431_4753322 MorisitaHornDiss  4.407953e-01  1.130055e-02
      2487 2009  431_4753322   BrayCurtisDiss  9.868421e-01  5.358431e-03
      2488 2004  431_4753322      JaccardDiss  5.000000e-01 -1.416795e-03
      2489 2004  431_4753322 MorisitaHornDiss  4.027051e-02  1.130055e-02
      2490 2004  431_4753322   BrayCurtisDiss  1.919771e-01  5.358431e-03
      2491 2010  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2492 2010  431_4753322 MorisitaHornDiss  6.186478e-04  1.130055e-02
      2493 2010  431_4753322   BrayCurtisDiss  3.333333e-01  5.358431e-03
      2494 1999  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2495 1999  431_4753322 MorisitaHornDiss  2.945157e-02  1.130055e-02
      2496 1999  431_4753322   BrayCurtisDiss  5.384615e-01  5.358431e-03
      2497 2001  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2498 2001  431_4753322 MorisitaHornDiss  2.504573e-01  1.130055e-02
      2499 2001  431_4753322   BrayCurtisDiss  4.800000e-01  5.358431e-03
      2500 2002  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2501 2002  431_4753322 MorisitaHornDiss  1.851901e-01  1.130055e-02
      2502 2002  431_4753322   BrayCurtisDiss  8.518519e-01  5.358431e-03
      2503 2005  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2504 2005  431_4753322 MorisitaHornDiss  1.954599e-04  1.130055e-02
      2505 2005  431_4753322   BrayCurtisDiss  5.625000e-01  5.358431e-03
      2506 2006  431_4753322      JaccardDiss  6.666667e-01 -1.416795e-03
      2507 2006  431_4753322 MorisitaHornDiss  2.540406e-01  1.130055e-02
      2508 2006  431_4753322   BrayCurtisDiss  9.867550e-01  5.358431e-03
      2509 2007  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2510 2007  431_4753322 MorisitaHornDiss  3.417258e-01  1.130055e-02
      2511 2007  431_4753322   BrayCurtisDiss  8.518519e-01  5.358431e-03
      2512 2008  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2513 2008  431_4753322 MorisitaHornDiss  3.402851e-02  1.130055e-02
      2514 2008  431_4753322   BrayCurtisDiss  2.875536e-01  5.358431e-03
      2515 2012  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2516 2012  431_4753322 MorisitaHornDiss  2.146301e-01  1.130055e-02
      2517 2012  431_4753322   BrayCurtisDiss  2.820513e-01  5.358431e-03
      2518 2013  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2519 2013  431_4753322 MorisitaHornDiss  1.483128e-01  1.130055e-02
      2520 2013  431_4753322   BrayCurtisDiss  2.700730e-01  5.358431e-03
      2521 2014  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2522 2014  431_4753322 MorisitaHornDiss  3.417258e-01  1.130055e-02
      2523 2014  431_4753322   BrayCurtisDiss  8.518519e-01  5.358431e-03
      2524 2015  431_4753322      JaccardDiss  3.333333e-01 -1.416795e-03
      2525 2015  431_4753322 MorisitaHornDiss  3.417887e-01  1.130055e-02
      2526 2015  431_4753322   BrayCurtisDiss  9.800995e-01  5.358431e-03
      2527 1996  431_4754067      JaccardDiss  1.000000e+00 -1.173184e-01
      2528 1996  431_4754067 MorisitaHornDiss  1.000000e+00 -1.173184e-01
      2529 1996  431_4754067   BrayCurtisDiss  1.000000e+00 -5.865922e-02
      2530 1998  431_4754067      JaccardDiss  1.000000e+00 -1.173184e-01
      2531 1998  431_4754067 MorisitaHornDiss  1.000000e+00 -1.173184e-01
      2532 1998  431_4754067   BrayCurtisDiss  1.000000e+00 -5.865922e-02
      2533 2000  431_4754067      JaccardDiss  1.000000e+00 -1.173184e-01
      2534 2000  431_4754067 MorisitaHornDiss  1.000000e+00 -1.173184e-01
      2535 2000  431_4754067   BrayCurtisDiss  1.000000e+00 -5.865922e-02
      2536 2005  431_4754067      JaccardDiss  0.000000e+00 -1.173184e-01
      2537 2005  431_4754067 MorisitaHornDiss  0.000000e+00 -1.173184e-01
      2538 2005  431_4754067   BrayCurtisDiss  5.000000e-01 -5.865922e-02
      2539 2006  431_4749675      JaccardDiss  0.000000e+00  1.790634e-02
      2540 2006  431_4749675 MorisitaHornDiss  3.985178e-02  2.876920e-04
      2541 2006  431_4749675   BrayCurtisDiss  8.690702e-01  1.275975e-02
      2542 2013  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2543 2013  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2544 2013  431_4749675   BrayCurtisDiss  7.278912e-01  1.275975e-02
      2545 2005  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2546 2005  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2547 2005  431_4749675   BrayCurtisDiss  5.480226e-01  1.275975e-02
      2548 2007  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2549 2007  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2550 2007  431_4749675   BrayCurtisDiss  3.388430e-01  1.275975e-02
      2551 2008  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2552 2008  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2553 2008  431_4749675   BrayCurtisDiss  8.653199e-01  1.275975e-02
      2554 2009  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2555 2009  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2556 2009  431_4749675   BrayCurtisDiss  8.319328e-01  1.275975e-02
      2557 2010  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2558 2010  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2559 2010  431_4749675   BrayCurtisDiss  8.230088e-01  1.275975e-02
      2560 2012  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2561 2012  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2562 2012  431_4749675   BrayCurtisDiss  7.752809e-01  1.275975e-02
      2563 2014  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2564 2014  431_4749675 MorisitaHornDiss  2.335462e-01  2.876920e-04
      2565 2014  431_4749675   BrayCurtisDiss  8.950131e-01  1.275975e-02
      2566 2015  431_4749675      JaccardDiss  5.000000e-01  1.790634e-02
      2567 2015  431_4749675 MorisitaHornDiss  9.157002e-02  2.876920e-04
      2568 2015  431_4749675   BrayCurtisDiss  6.280992e-01  1.275975e-02
      2569 2008  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2570 2008  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2571 2008  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2572 1999  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2573 1999  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2574 1999  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2575 2002  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2576 2002  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2577 2002  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2578 1990  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2579 1990  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2580 1990  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2581 1995  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2582 1995  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2583 1995  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2584 1996  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2585 1996  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2586 1996  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2587 2001  431_4744570      JaccardDiss  1.000000e+00 -2.592781e-02
      2588 2001  431_4744570 MorisitaHornDiss  1.000000e+00 -2.591678e-02
      2589 2001  431_4744570   BrayCurtisDiss  1.000000e+00 -1.607096e-02
      2590 2006  431_4744570      JaccardDiss  0.000000e+00 -2.592781e-02
      2591 2006  431_4744570 MorisitaHornDiss  4.251936e-04 -2.591678e-02
      2592 2006  431_4744570   BrayCurtisDiss  3.801653e-01 -1.607096e-02
      2593 2008  431_5094559      JaccardDiss  6.666667e-01 -2.000000e-01
      2594 2008  431_5094559 MorisitaHornDiss  1.925466e-01 -5.776398e-02
      2595 2008  431_5094559   BrayCurtisDiss  4.117647e-01 -9.184727e-03
      2596 2009  431_5094559      JaccardDiss  6.666667e-01 -2.000000e-01
      2597 2009  431_5094559 MorisitaHornDiss  1.925466e-01 -5.776398e-02
      2598 2009  431_5094559   BrayCurtisDiss  3.333333e-01 -9.184727e-03
      2599 2010  431_5094559      JaccardDiss  6.666667e-01 -2.000000e-01
      2600 2010  431_5094559 MorisitaHornDiss  1.925466e-01 -5.776398e-02
      2601 2010  431_5094559   BrayCurtisDiss  5.294118e-01 -9.184727e-03
      2602 2011  431_5094559      JaccardDiss  0.000000e+00 -2.000000e-01
      2603 2011  431_5094559 MorisitaHornDiss  0.000000e+00 -5.776398e-02
      2604 2011  431_5094559   BrayCurtisDiss  3.157895e-01 -9.184727e-03
      2605 2006  431_4751864      JaccardDiss  0.000000e+00 -4.830918e-03
      2606 2006  431_4751864 MorisitaHornDiss  5.184233e-02  7.614260e-03
      2607 2006  431_4751864   BrayCurtisDiss  8.893281e-01 -2.488044e-02
      2608 2007  431_4751864      JaccardDiss  3.333333e-01 -4.830918e-03
      2609 2007  431_4751864 MorisitaHornDiss  1.995439e-01  7.614260e-03
      2610 2007  431_4751864   BrayCurtisDiss  8.705036e-01 -2.488044e-02
      2611 2010  431_4751864      JaccardDiss  6.666667e-01 -4.830918e-03
      2612 2010  431_4751864 MorisitaHornDiss  5.104895e-01  7.614260e-03
      2613 2010  431_4751864   BrayCurtisDiss  5.000000e-01 -2.488044e-02
      2614 2003  431_4751864      JaccardDiss  6.666667e-01 -4.830918e-03
      2615 2003  431_4751864 MorisitaHornDiss  5.104895e-01  7.614260e-03
      2616 2003  431_4751864   BrayCurtisDiss  5.238095e-01 -2.488044e-02
      2617 2015  431_4751864      JaccardDiss  3.333333e-01 -4.830918e-03
      2618 2015  431_4751864 MorisitaHornDiss  3.999457e-01  7.614260e-03
      2619 2015  431_4751864   BrayCurtisDiss  4.065934e-01 -2.488044e-02
      2620 2000  431_4752592      JaccardDiss  3.333333e-01 -1.885831e-02
      2621 2000  431_4752592 MorisitaHornDiss  3.701105e-02  1.707199e-02
      2622 2000  431_4752592   BrayCurtisDiss  7.428571e-01  1.785911e-02
      2623 2004  431_4752592      JaccardDiss  3.333333e-01 -1.885831e-02
      2624 2004  431_4752592 MorisitaHornDiss  2.718878e-01  1.707199e-02
      2625 2004  431_4752592   BrayCurtisDiss  4.080000e-01  1.785911e-02
      2626 2010  431_4752592      JaccardDiss  6.666667e-01 -1.885831e-02
      2627 2010  431_4752592 MorisitaHornDiss  1.794690e-01  1.707199e-02
      2628 2010  431_4752592   BrayCurtisDiss  6.944444e-01  1.785911e-02
      2629 1999  431_4752592      JaccardDiss  6.666667e-01 -1.885831e-02
      2630 1999  431_4752592 MorisitaHornDiss  1.794690e-01  1.707199e-02
      2631 1999  431_4752592   BrayCurtisDiss  2.830189e-01  1.785911e-02
      2632 2006  431_4752592      JaccardDiss  6.666667e-01 -1.885831e-02
      2633 2006  431_4752592 MorisitaHornDiss  1.794690e-01  1.707199e-02
      2634 2006  431_4752592   BrayCurtisDiss  4.452555e-01  1.785911e-02
      2635 2007  431_4752592      JaccardDiss  6.666667e-01 -1.885831e-02
      2636 2007  431_4752592 MorisitaHornDiss  1.794690e-01  1.707199e-02
      2637 2007  431_4752592   BrayCurtisDiss  4.878049e-01  1.785911e-02
      2638 2015  431_4752592      JaccardDiss  0.000000e+00 -1.885831e-02
      2639 2015  431_4752592 MorisitaHornDiss  4.558882e-01  1.707199e-02
      2640 2015  431_4752592   BrayCurtisDiss  7.534247e-01  1.785911e-02
      2641 2002  431_4751135      JaccardDiss  0.000000e+00  1.564380e-02
      2642 2002  431_4751135 MorisitaHornDiss  2.318244e-01  2.371961e-02
      2643 2002  431_4751135   BrayCurtisDiss  6.216216e-01  6.391916e-03
      2644 2003  431_4751135      JaccardDiss  5.000000e-01  1.564380e-02
      2645 2003  431_4751135 MorisitaHornDiss  4.761905e-02  2.371961e-02
      2646 2003  431_4751135   BrayCurtisDiss  5.789474e-01  6.391916e-03
      2647 2004  431_4751135      JaccardDiss  6.666667e-01  1.564380e-02
      2648 2004  431_4751135 MorisitaHornDiss  4.060198e-02  2.371961e-02
      2649 2004  431_4751135   BrayCurtisDiss  2.916667e-01  6.391916e-03
      2650 2007  431_4751135      JaccardDiss  5.000000e-01  1.564380e-02
      2651 2007  431_4751135 MorisitaHornDiss  4.761905e-02  2.371961e-02
      2652 2007  431_4751135   BrayCurtisDiss  6.666667e-01  6.391916e-03
      2653 2015  431_4751135      JaccardDiss  5.000000e-01  1.564380e-02
      2654 2015  431_4751135 MorisitaHornDiss  4.324324e-01  2.371961e-02
      2655 2015  431_4751135   BrayCurtisDiss  6.000000e-01  6.391916e-03
      2656 1996  431_4743110      JaccardDiss  5.000000e-01 -6.329114e-04
      2657 1996  431_4743110 MorisitaHornDiss  6.923077e-01 -8.179163e-03
      2658 1996  431_4743110   BrayCurtisDiss  8.888889e-01 -9.584087e-03
      2659 1998  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2660 1998  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2661 1998  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2662 1990  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2663 1990  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2664 1990  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2665 1999  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2666 1999  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2667 1999  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2668 2000  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2669 2000  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2670 2000  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2671 2001  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2672 2001  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2673 2001  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2674 2002  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2675 2002  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2676 2002  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2677 2005  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2678 2005  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2679 2005  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2680 2006  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2681 2006  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2682 2006  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2683 2007  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2684 2007  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2685 2007  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2686 2008  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2687 2008  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2688 2008  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2689 2009  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2690 2009  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2691 2009  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2692 2010  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2693 2010  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2694 2010  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2695 2012  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2696 2012  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2697 2012  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2698 2013  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2699 2013  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2700 2013  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2701 2014  431_4743110      JaccardDiss  1.000000e+00 -6.329114e-04
      2702 2014  431_4743110 MorisitaHornDiss  1.000000e+00 -8.179163e-03
      2703 2014  431_4743110   BrayCurtisDiss  1.000000e+00 -9.584087e-03
      2704 2015  431_4743110      JaccardDiss  5.000000e-01 -6.329114e-04
      2705 2015  431_4743110 MorisitaHornDiss  7.692308e-02 -8.179163e-03
      2706 2015  431_4743110   BrayCurtisDiss  1.428571e-01 -9.584087e-03
      2707 1986  431_4755503      JaccardDiss  0.000000e+00  1.759324e-02
      2708 1986  431_4755503 MorisitaHornDiss  1.983886e-03  3.241454e-02
      2709 1986  431_4755503   BrayCurtisDiss  2.592593e-01  2.269273e-02
      2710 2005  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2711 2005  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2712 2005  431_4755503   BrayCurtisDiss  9.259259e-01  2.269273e-02
      2713 2008  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2714 2008  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2715 2008  431_4755503   BrayCurtisDiss  9.200000e-01  2.269273e-02
      2716 2010  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2717 2010  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2718 2010  431_4755503   BrayCurtisDiss  9.354839e-01  2.269273e-02
      2719 2011  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2720 2011  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2721 2011  431_4755503   BrayCurtisDiss  9.000000e-01  2.269273e-02
      2722 2012  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2723 2012  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2724 2012  431_4755503   BrayCurtisDiss  9.622642e-01  2.269273e-02
      2725 2013  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2726 2013  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2727 2013  431_4755503   BrayCurtisDiss  8.888889e-01  2.269273e-02
      2728 2014  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2729 2014  431_4755503 MorisitaHornDiss  9.377289e-01  3.241454e-02
      2730 2014  431_4755503   BrayCurtisDiss  8.888889e-01  2.269273e-02
      2731 2015  431_4755503      JaccardDiss  5.000000e-01  1.759324e-02
      2732 2015  431_4755503 MorisitaHornDiss  8.901099e-01  3.241454e-02
      2733 2015  431_4755503   BrayCurtisDiss  9.000000e-01  2.269273e-02
      2734 2003  431_4753319      JaccardDiss  5.000000e-01  1.960704e-14
      2735 2003  431_4753319 MorisitaHornDiss  3.858268e-01  1.513751e-14
      2736 2003  431_4753319   BrayCurtisDiss  4.444444e-01  2.777778e-02
      2737 2005  431_4753319      JaccardDiss  0.000000e+00  1.960704e-14
      2738 2005  431_4753319 MorisitaHornDiss  0.000000e+00  1.513751e-14
      2739 2005  431_4753319   BrayCurtisDiss  4.736842e-01  2.777778e-02
      2740 2007  431_4753319      JaccardDiss  5.000000e-01  1.960704e-14
      2741 2007  431_4753319 MorisitaHornDiss  3.858268e-01  1.513751e-14
      2742 2007  431_4753319   BrayCurtisDiss  5.555556e-01  2.777778e-02
      2743 2004  431_4752591      JaccardDiss  5.000000e-01  2.521930e-02
      2744 2004  431_4752591 MorisitaHornDiss  4.739336e-03  7.522657e-02
      2745 2004  431_4752591   BrayCurtisDiss  2.500000e-01  5.516779e-02
      2746 2007  431_4752591      JaccardDiss  5.000000e-01  2.521930e-02
      2747 2007  431_4752591 MorisitaHornDiss  4.739336e-03  7.522657e-02
      2748 2007  431_4752591   BrayCurtisDiss  5.000000e-01  5.516779e-02
      2749 2009  431_4752591      JaccardDiss  5.000000e-01  2.521930e-02
      2750 2009  431_4752591 MorisitaHornDiss  4.739336e-03  7.522657e-02
      2751 2009  431_4752591   BrayCurtisDiss  7.647059e-01  5.516779e-02
      2752 2015  431_4752591      JaccardDiss  5.000000e-01  2.521930e-02
      2753 2015  431_4752591 MorisitaHornDiss  9.289100e-01  7.522657e-02
      2754 2015  431_4752591   BrayCurtisDiss  8.750000e-01  5.516779e-02
      2755 2003  431_4752591      JaccardDiss  0.000000e+00  2.521930e-02
      2756 2003  431_4752591 MorisitaHornDiss  0.000000e+00  7.522657e-02
      2757 2003  431_4752591   BrayCurtisDiss  2.857143e-01  5.516779e-02
      2758 2003  431_4752590      JaccardDiss  0.000000e+00  7.231405e-03
      2759 2003  431_4752590 MorisitaHornDiss  0.000000e+00  7.829491e-03
      2760 2003  431_4752590   BrayCurtisDiss  3.333333e-01  1.584022e-02
      2761 2004  431_4752590      JaccardDiss  0.000000e+00  7.231405e-03
      2762 2004  431_4752590 MorisitaHornDiss  0.000000e+00  7.829491e-03
      2763 2004  431_4752590   BrayCurtisDiss  0.000000e+00  1.584022e-02
      2764 2005  431_4752590      JaccardDiss  5.000000e-01  7.231405e-03
      2765 2005  431_4752590 MorisitaHornDiss  4.736842e-01  7.829491e-03
      2766 2005  431_4752590   BrayCurtisDiss  6.666667e-01  1.584022e-02
      2767 2009  431_4752590      JaccardDiss  1.000000e+00  7.231405e-03
      2768 2009  431_4752590 MorisitaHornDiss  1.000000e+00  7.829491e-03
      2769 2009  431_4752590   BrayCurtisDiss  1.000000e+00  1.584022e-02
      2770 2015  431_4752590      JaccardDiss  0.000000e+00  7.231405e-03
      2771 2015  431_4752590 MorisitaHornDiss  0.000000e+00  7.829491e-03
      2772 2015  431_4752590   BrayCurtisDiss  3.333333e-01  1.584022e-02
      2773 2015  431_4753317      JaccardDiss  1.000000e+00 -7.142857e-02
      2774 2015  431_4753317 MorisitaHornDiss  1.000000e+00 -7.142857e-02
      2775 2015  431_4753317   BrayCurtisDiss  1.000000e+00 -6.122449e-02
      2776 2012  431_4753317      JaccardDiss  1.000000e+00 -7.142857e-02
      2777 2012  431_4753317 MorisitaHornDiss  1.000000e+00 -7.142857e-02
      2778 2012  431_4753317   BrayCurtisDiss  1.000000e+00 -6.122449e-02
      2779 2014  431_4753317      JaccardDiss  0.000000e+00 -7.142857e-02
      2780 2014  431_4753317 MorisitaHornDiss  0.000000e+00 -7.142857e-02
      2781 2014  431_4753317   BrayCurtisDiss  1.428571e-01 -6.122449e-02
      2782 1986   466_544452      JaccardDiss  5.000000e-01  2.181455e-03
      2783 1986   466_544452 MorisitaHornDiss  5.350099e-01 -2.924266e-02
      2784 1986   466_544452   BrayCurtisDiss  6.471401e-01 -1.718643e-02
      2785 1995   466_544452      JaccardDiss  4.000000e-01  2.181455e-03
      2786 1995   466_544452 MorisitaHornDiss  8.236720e-01 -2.924266e-02
      2787 1995   466_544452   BrayCurtisDiss  7.666113e-01 -1.718643e-02
      2788 2006   466_544452      JaccardDiss  5.000000e-01  2.181455e-03
      2789 2006   466_544452 MorisitaHornDiss  1.857261e-01 -2.924266e-02
      2790 2006   466_544452   BrayCurtisDiss  6.513521e-01 -1.718643e-02
      2791 2007   466_544452      JaccardDiss  5.185185e-01  2.181455e-03
      2792 2007   466_544452 MorisitaHornDiss  1.217843e-01 -2.924266e-02
      2793 2007   466_544452   BrayCurtisDiss  2.700000e-01 -1.718643e-02
      2794 1988   466_544452      JaccardDiss  4.400000e-01  2.181455e-03
      2795 1988   466_544452 MorisitaHornDiss  9.072515e-01 -2.924266e-02
      2796 1988   466_544452   BrayCurtisDiss  9.442478e-01 -1.718643e-02
      2797 1986   466_541548      JaccardDiss  5.000000e-01 -4.942806e-05
      2798 1986   466_541548 MorisitaHornDiss  1.264450e-01  4.724493e-03
      2799 1986   466_541548   BrayCurtisDiss  3.369624e-01  6.320733e-03
      2800 1990   466_541548      JaccardDiss  3.636364e-01 -4.942806e-05
      2801 1990   466_541548 MorisitaHornDiss  1.325438e-01  4.724493e-03
      2802 1990   466_541548   BrayCurtisDiss  4.521452e-01  6.320733e-03
      2803 2002   466_541548      JaccardDiss  4.782609e-01 -4.942806e-05
      2804 2002   466_541548 MorisitaHornDiss  7.216664e-02  4.724493e-03
      2805 2002   466_541548   BrayCurtisDiss  4.113291e-01  6.320733e-03
      2806 2005   466_541548      JaccardDiss  4.285714e-01 -4.942806e-05
      2807 2005   466_541548 MorisitaHornDiss  2.960042e-01  4.724493e-03
      2808 2005   466_541548   BrayCurtisDiss  5.310245e-01  6.320733e-03
      2809 1994   466_544451      JaccardDiss  3.448276e-01  4.808308e-03
      2810 1994   466_544451 MorisitaHornDiss  1.530498e-01  4.602297e-03
      2811 1994   466_544451   BrayCurtisDiss  7.864647e-01  5.531085e-03
      2812 1989   466_544451      JaccardDiss  2.307692e-01  4.808308e-03
      2813 1989   466_544451 MorisitaHornDiss  7.536790e-02  4.602297e-03
      2814 1989   466_544451   BrayCurtisDiss  6.649011e-01  5.531085e-03
      2815 1990   466_544451      JaccardDiss  4.814815e-01  4.808308e-03
      2816 1990   466_544451 MorisitaHornDiss  2.164094e-01  4.602297e-03
      2817 1990   466_544451   BrayCurtisDiss  4.080232e-01  5.531085e-03
      2818 1991   466_544451      JaccardDiss  2.962963e-01  4.808308e-03
      2819 1991   466_544451 MorisitaHornDiss  1.560444e-01  4.602297e-03
      2820 1991   466_544451   BrayCurtisDiss  3.112912e-01  5.531085e-03
      2821 1992   466_544451      JaccardDiss  4.400000e-01  4.808308e-03
      2822 1992   466_544451 MorisitaHornDiss  4.534356e-01  4.602297e-03
      2823 1992   466_544451   BrayCurtisDiss  5.776285e-01  5.531085e-03
      2824 1993   466_544451      JaccardDiss  5.357143e-01  4.808308e-03
      2825 1993   466_544451 MorisitaHornDiss  3.342823e-01  4.602297e-03
      2826 1993   466_544451   BrayCurtisDiss  4.484038e-01  5.531085e-03
      2827 1996   466_544451      JaccardDiss  3.461538e-01  4.808308e-03
      2828 1996   466_544451 MorisitaHornDiss  1.215146e-01  4.602297e-03
      2829 1996   466_544451   BrayCurtisDiss  6.320762e-01  5.531085e-03
      2830 1998   466_544451      JaccardDiss  3.333333e-01  4.808308e-03
      2831 1998   466_544451 MorisitaHornDiss  2.858784e-01  4.602297e-03
      2832 1998   466_544451   BrayCurtisDiss  4.938114e-01  5.531085e-03
      2833 1999   466_544451      JaccardDiss  2.592593e-01  4.808308e-03
      2834 1999   466_544451 MorisitaHornDiss  3.553651e-01  4.602297e-03
      2835 1999   466_544451   BrayCurtisDiss  5.572836e-01  5.531085e-03
      2836 2000   466_544451      JaccardDiss  3.461538e-01  4.808308e-03
      2837 2000   466_544451 MorisitaHornDiss  6.514180e-01  4.602297e-03
      2838 2000   466_544451   BrayCurtisDiss  6.423745e-01  5.531085e-03
      2839 2001   466_544451      JaccardDiss  3.703704e-01  4.808308e-03
      2840 2001   466_544451 MorisitaHornDiss  4.776508e-01  4.602297e-03
      2841 2001   466_544451   BrayCurtisDiss  6.235153e-01  5.531085e-03
      2842 2002   466_544451      JaccardDiss  2.857143e-01  4.808308e-03
      2843 2002   466_544451 MorisitaHornDiss  1.162334e-01  4.602297e-03
      2844 2002   466_544451   BrayCurtisDiss  4.184161e-01  5.531085e-03
      2845 2003   466_544451      JaccardDiss  4.000000e-01  4.808308e-03
      2846 2003   466_544451 MorisitaHornDiss  2.745795e-01  4.602297e-03
      2847 2003   466_544451   BrayCurtisDiss  6.227177e-01  5.531085e-03
      2848 2006   466_544451      JaccardDiss  3.703704e-01  4.808308e-03
      2849 2006   466_544451 MorisitaHornDiss  1.683274e-01  4.602297e-03
      2850 2006   466_544451   BrayCurtisDiss  6.100694e-01  5.531085e-03
      2851 2007   466_544451      JaccardDiss  3.461538e-01  4.808308e-03
      2852 2007   466_544451 MorisitaHornDiss  1.329162e-01  4.602297e-03
      2853 2007   466_544451   BrayCurtisDiss  7.531049e-01  5.531085e-03
      2854 2008   466_544451      JaccardDiss  4.400000e-01  4.808308e-03
      2855 2008   466_544451 MorisitaHornDiss  1.424699e-01  4.602297e-03
      2856 2008   466_544451   BrayCurtisDiss  2.771128e-01  5.531085e-03
      2857 2004   466_544451      JaccardDiss  8.400000e-01  4.808308e-03
      2858 2004   466_544451 MorisitaHornDiss  5.692394e-01  4.602297e-03
      2859 2004   466_544451   BrayCurtisDiss  6.652856e-01  5.531085e-03
      2860 1988   466_544451      JaccardDiss  3.076923e-01  4.808308e-03
      2861 1988   466_544451 MorisitaHornDiss  1.091796e-01  4.602297e-03
      2862 1988   466_544451   BrayCurtisDiss  3.079607e-01  5.531085e-03
      2863 1991   466_541547      JaccardDiss  4.090909e-01 -1.918908e-03
      2864 1991   466_541547 MorisitaHornDiss  2.456276e-01  1.018797e-02
      2865 1991   466_541547   BrayCurtisDiss  6.625357e-01  1.163314e-02
      2866 1994   466_541547      JaccardDiss  3.181818e-01 -1.918908e-03
      2867 1994   466_541547 MorisitaHornDiss  1.779027e-02  1.018797e-02
      2868 1994   466_541547   BrayCurtisDiss  4.453919e-01  1.163314e-02
      2869 1998   466_541547      JaccardDiss  3.913043e-01 -1.918908e-03
      2870 1998   466_541547 MorisitaHornDiss  6.667402e-01  1.018797e-02
      2871 1998   466_541547   BrayCurtisDiss  6.930872e-01  1.163314e-02
      2872 2000   466_541547      JaccardDiss  2.857143e-01 -1.918908e-03
      2873 2000   466_541547 MorisitaHornDiss  5.291372e-01  1.018797e-02
      2874 2000   466_541547   BrayCurtisDiss  6.093591e-01  1.163314e-02
      2875 2003   466_541547      JaccardDiss  3.684211e-01 -1.918908e-03
      2876 2003   466_541547 MorisitaHornDiss  4.737335e-01  1.018797e-02
      2877 2003   466_541547   BrayCurtisDiss  7.318230e-01  1.163314e-02
      2878 1988   466_541547      JaccardDiss  3.684211e-01 -1.918908e-03
      2879 1988   466_541547 MorisitaHornDiss  1.350022e-01  1.018797e-02
      2880 1988   466_541547   BrayCurtisDiss  3.104668e-01  1.163314e-02
      2881 1995   466_541547      JaccardDiss  4.736842e-01 -1.918908e-03
      2882 1995   466_541547 MorisitaHornDiss  5.743608e-01  1.018797e-02
      2883 1995   466_541547   BrayCurtisDiss  5.816286e-01  1.163314e-02
      2884 2001   466_541547      JaccardDiss  4.736842e-01 -1.918908e-03
      2885 2001   466_541547 MorisitaHornDiss  1.433838e-01  1.018797e-02
      2886 2001   466_541547   BrayCurtisDiss  5.492240e-01  1.163314e-02
      2887 2006   466_541547      JaccardDiss  4.000000e-01 -1.918908e-03
      2888 2006   466_541547 MorisitaHornDiss  5.458216e-01  1.018797e-02
      2889 2006   466_541547   BrayCurtisDiss  6.138865e-01  1.163314e-02
      2890 2007   466_541547      JaccardDiss  2.941176e-01 -1.918908e-03
      2891 2007   466_541547 MorisitaHornDiss  5.447875e-01  1.018797e-02
      2892 2007   466_541547   BrayCurtisDiss  7.490222e-01  1.163314e-02
      2893 1997   466_541547      JaccardDiss  4.761905e-01 -1.918908e-03
      2894 1997   466_541547 MorisitaHornDiss  5.845291e-01  1.018797e-02
      2895 1997   466_541547   BrayCurtisDiss  8.493521e-01  1.163314e-02
      2896 2004   466_541547      JaccardDiss  4.761905e-01 -1.918908e-03
      2897 2004   466_541547 MorisitaHornDiss  5.486245e-01  1.018797e-02
      2898 2004   466_541547   BrayCurtisDiss  6.008440e-01  1.163314e-02
      2899 1996   466_541547      JaccardDiss  4.444444e-01 -1.918908e-03
      2900 1996   466_541547 MorisitaHornDiss  5.482778e-01  1.018797e-02
      2901 1996   466_541547   BrayCurtisDiss  8.350404e-01  1.163314e-02
      2902 1999   466_541547      JaccardDiss  5.000000e-01 -1.918908e-03
      2903 1999   466_541547 MorisitaHornDiss  5.570440e-01  1.018797e-02
      2904 1999   466_541547   BrayCurtisDiss  8.483774e-01  1.163314e-02
      2905 2008   466_541547      JaccardDiss  3.478261e-01 -1.918908e-03
      2906 2008   466_541547 MorisitaHornDiss  1.564153e-01  1.018797e-02
      2907 2008   466_541547   BrayCurtisDiss  7.926970e-01  1.163314e-02
      2908 2002   466_544453      JaccardDiss  4.666667e-01  2.217612e-03
      2909 2002   466_544453 MorisitaHornDiss  3.977599e-02 -4.184819e-03
      2910 2002   466_544453   BrayCurtisDiss  3.119715e-01  1.365771e-02
      2911 1991   466_544453      JaccardDiss  4.444444e-01  2.217612e-03
      2912 1991   466_544453 MorisitaHornDiss  1.665826e-01 -4.184819e-03
      2913 1991   466_544453   BrayCurtisDiss  4.979121e-01  1.365771e-02
      2914 1992   466_544453      JaccardDiss  3.333333e-01  2.217612e-03
      2915 1992   466_544453 MorisitaHornDiss  7.588926e-02 -4.184819e-03
      2916 1992   466_544453   BrayCurtisDiss  5.272143e-01  1.365771e-02
      2917 1993   466_544453      JaccardDiss  4.444444e-01  2.217612e-03
      2918 1993   466_544453 MorisitaHornDiss  1.033715e-01 -4.184819e-03
      2919 1993   466_544453   BrayCurtisDiss  7.540161e-01  1.365771e-02
      2920 1994   466_544453      JaccardDiss  4.583333e-01  2.217612e-03
      2921 1994   466_544453 MorisitaHornDiss  2.634484e-02 -4.184819e-03
      2922 1994   466_544453   BrayCurtisDiss  2.623830e-01  1.365771e-02
      2923 1996   466_544453      JaccardDiss  5.384615e-01  2.217612e-03
      2924 1996   466_544453 MorisitaHornDiss  1.260348e-02 -4.184819e-03
      2925 1996   466_544453   BrayCurtisDiss  4.436607e-01  1.365771e-02
      2926 1997   466_544453      JaccardDiss  4.000000e-01  2.217612e-03
      2927 1997   466_544453 MorisitaHornDiss  1.204413e-02 -4.184819e-03
      2928 1997   466_544453   BrayCurtisDiss  1.737455e-01  1.365771e-02
      2929 1998   466_544453      JaccardDiss  4.583333e-01  2.217612e-03
      2930 1998   466_544453 MorisitaHornDiss  5.929519e-02 -4.184819e-03
      2931 1998   466_544453   BrayCurtisDiss  8.107794e-01  1.365771e-02
      2932 1999   466_544453      JaccardDiss  5.000000e-01  2.217612e-03
      2933 1999   466_544453 MorisitaHornDiss  2.003736e-01 -4.184819e-03
      2934 1999   466_544453   BrayCurtisDiss  5.140943e-01  1.365771e-02
      2935 2000   466_544453      JaccardDiss  3.478261e-01  2.217612e-03
      2936 2000   466_544453 MorisitaHornDiss  1.134001e-01 -4.184819e-03
      2937 2000   466_544453   BrayCurtisDiss  7.395662e-01  1.365771e-02
      2938 2003   466_544453      JaccardDiss  4.166667e-01  2.217612e-03
      2939 2003   466_544453 MorisitaHornDiss  5.459169e-02 -4.184819e-03
      2940 2003   466_544453   BrayCurtisDiss  5.961954e-01  1.365771e-02
      2941 2004   466_544453      JaccardDiss  5.000000e-01  2.217612e-03
      2942 2004   466_544453 MorisitaHornDiss  6.353890e-02 -4.184819e-03
      2943 2004   466_544453   BrayCurtisDiss  8.850166e-01  1.365771e-02
      2944 2006   466_544453      JaccardDiss  4.814815e-01  2.217612e-03
      2945 2006   466_544453 MorisitaHornDiss  1.009635e-01 -4.184819e-03
      2946 2006   466_544453   BrayCurtisDiss  8.751205e-01  1.365771e-02
      2947 2007   466_544453      JaccardDiss  3.913043e-01  2.217612e-03
      2948 2007   466_544453 MorisitaHornDiss  6.767967e-02 -4.184819e-03
      2949 2007   466_544453   BrayCurtisDiss  9.146819e-01  1.365771e-02
      2950 1989   466_544453      JaccardDiss  5.833333e-01  2.217612e-03
      2951 1989   466_544453 MorisitaHornDiss  4.717143e-01 -4.184819e-03
      2952 1989   466_544453   BrayCurtisDiss  8.191828e-01  1.365771e-02
      2953 2001   466_544453      JaccardDiss  4.000000e-01  2.217612e-03
      2954 2001   466_544453 MorisitaHornDiss  9.247489e-01 -4.184819e-03
      2955 2001   466_544453   BrayCurtisDiss  9.408110e-01  1.365771e-02
      2956 1988   466_544453      JaccardDiss  2.222222e-01  2.217612e-03
      2957 1988   466_544453 MorisitaHornDiss  2.145197e-01 -4.184819e-03
      2958 1988   466_544453   BrayCurtisDiss  5.994628e-01  1.365771e-02
      2959 1992   466_540093      JaccardDiss  3.461538e-01  3.492897e-03
      2960 1992   466_540093 MorisitaHornDiss  4.401476e-02  2.110121e-02
      2961 1992   466_540093   BrayCurtisDiss  5.423280e-01  1.537645e-02
      2962 1993   466_540093      JaccardDiss  5.000000e-01  3.492897e-03
      2963 1993   466_540093 MorisitaHornDiss  7.621292e-02  2.110121e-02
      2964 1993   466_540093   BrayCurtisDiss  6.070144e-01  1.537645e-02
      2965 1988   466_540093      JaccardDiss  5.714286e-01  3.492897e-03
      2966 1988   466_540093 MorisitaHornDiss  1.425052e-01  2.110121e-02
      2967 1988   466_540093   BrayCurtisDiss  3.085896e-01  1.537645e-02
      2968 2006   466_540093      JaccardDiss  4.137931e-01  3.492897e-03
      2969 2006   466_540093 MorisitaHornDiss  5.853023e-01  2.110121e-02
      2970 2006   466_540093   BrayCurtisDiss  5.293088e-01  1.537645e-02
      2971 2007   466_540093      JaccardDiss  4.230769e-01  3.492897e-03
      2972 2007   466_540093 MorisitaHornDiss  6.025475e-01  2.110121e-02
      2973 2007   466_540093   BrayCurtisDiss  7.356932e-01  1.537645e-02
      2974 2008   466_540093      JaccardDiss  6.000000e-01  3.492897e-03
      2975 2008   466_540093 MorisitaHornDiss  7.074514e-02  2.110121e-02
      2976 2008   466_540093   BrayCurtisDiss  7.967573e-01  1.537645e-02
      2977 1996   466_540093      JaccardDiss  4.583333e-01  3.492897e-03
      2978 1996   466_540093 MorisitaHornDiss  7.151432e-02  2.110121e-02
      2979 1996   466_540093   BrayCurtisDiss  5.764289e-01  1.537645e-02
      2980 2003   466_540093      JaccardDiss  4.800000e-01  3.492897e-03
      2981 2003   466_540093 MorisitaHornDiss  5.524466e-01  2.110121e-02
      2982 2003   466_540093   BrayCurtisDiss  7.933319e-01  1.537645e-02
      2983 2004   466_540093      JaccardDiss  5.769231e-01  3.492897e-03
      2984 2004   466_540093 MorisitaHornDiss  1.715893e-01  2.110121e-02
      2985 2004   466_540093   BrayCurtisDiss  3.210634e-01  1.537645e-02
      2986 2005   466_540093      JaccardDiss  6.000000e-01  3.492897e-03
      2987 2005   466_540093 MorisitaHornDiss  4.370725e-01  2.110121e-02
      2988 2005   466_540093   BrayCurtisDiss  6.594324e-01  1.537645e-02
      2989 1995   466_540093      JaccardDiss  3.500000e-01  3.492897e-03
      2990 1995   466_540093 MorisitaHornDiss  4.738046e-02  2.110121e-02
      2991 1995   466_540093   BrayCurtisDiss  2.191617e-01  1.537645e-02
      2992 1992   466_548093      JaccardDiss  3.870968e-01  5.566496e-03
      2993 1992   466_548093 MorisitaHornDiss  6.068968e-01  9.367824e-03
      2994 1992   466_548093   BrayCurtisDiss  5.711512e-01  1.361468e-02
      2995 1986   466_548093      JaccardDiss  4.285714e-01  5.566496e-03
      2996 1986   466_548093 MorisitaHornDiss  2.717572e-02  9.367824e-03
      2997 1986   466_548093   BrayCurtisDiss  1.472759e-01  1.361468e-02
      2998 1987   466_548093      JaccardDiss  4.137931e-01  5.566496e-03
      2999 1987   466_548093 MorisitaHornDiss  3.999129e-03  9.367824e-03
      3000 1987   466_548093   BrayCurtisDiss  6.072526e-01  1.361468e-02
      3001 1993   466_548093      JaccardDiss  2.500000e-01  5.566496e-03
      3002 1993   466_548093 MorisitaHornDiss  7.163224e-02  9.367824e-03
      3003 1993   466_548093   BrayCurtisDiss  2.078135e-01  1.361468e-02
      3004 1995   466_548093      JaccardDiss  4.666667e-01  5.566496e-03
      3005 1995   466_548093 MorisitaHornDiss  3.348779e-03  9.367824e-03
      3006 1995   466_548093   BrayCurtisDiss  2.817840e-01  1.361468e-02
      3007 1996   466_548093      JaccardDiss  4.666667e-01  5.566496e-03
      3008 1996   466_548093 MorisitaHornDiss  6.145940e-02  9.367824e-03
      3009 1996   466_548093   BrayCurtisDiss  5.507601e-01  1.361468e-02
      3010 1997   466_548093      JaccardDiss  3.793103e-01  5.566496e-03
      3011 1997   466_548093 MorisitaHornDiss  3.271667e-01  9.367824e-03
      3012 1997   466_548093   BrayCurtisDiss  4.290052e-01  1.361468e-02
      3013 1998   466_548093      JaccardDiss  4.814815e-01  5.566496e-03
      3014 1998   466_548093 MorisitaHornDiss  1.287822e-01  9.367824e-03
      3015 1998   466_548093   BrayCurtisDiss  4.619935e-01  1.361468e-02
      3016 1999   466_548093      JaccardDiss  3.928571e-01  5.566496e-03
      3017 1999   466_548093 MorisitaHornDiss  1.476088e-01  9.367824e-03
      3018 1999   466_548093   BrayCurtisDiss  4.183961e-01  1.361468e-02
      3019 2000   466_548093      JaccardDiss  4.285714e-01  5.566496e-03
      3020 2000   466_548093 MorisitaHornDiss  3.593995e-01  9.367824e-03
      3021 2000   466_548093   BrayCurtisDiss  4.665389e-01  1.361468e-02
      3022 2002   466_548093      JaccardDiss  5.483871e-01  5.566496e-03
      3023 2002   466_548093 MorisitaHornDiss  4.426566e-01  9.367824e-03
      3024 2002   466_548093   BrayCurtisDiss  5.470055e-01  1.361468e-02
      3025 2003   466_548093      JaccardDiss  4.444444e-01  5.566496e-03
      3026 2003   466_548093 MorisitaHornDiss  2.532221e-01  9.367824e-03
      3027 2003   466_548093   BrayCurtisDiss  4.197455e-01  1.361468e-02
      3028 2004   466_548093      JaccardDiss  5.312500e-01  5.566496e-03
      3029 2004   466_548093 MorisitaHornDiss  2.498987e-01  9.367824e-03
      3030 2004   466_548093   BrayCurtisDiss  6.378149e-01  1.361468e-02
      3031 2005   466_548093      JaccardDiss  5.000000e-01  5.566496e-03
      3032 2005   466_548093 MorisitaHornDiss  4.929771e-01  9.367824e-03
      3033 2005   466_548093   BrayCurtisDiss  7.665840e-01  1.361468e-02
      3034 2008   466_548093      JaccardDiss  5.172414e-01  5.566496e-03
      3035 2008   466_548093 MorisitaHornDiss  1.140715e-01  9.367824e-03
      3036 2008   466_548093   BrayCurtisDiss  7.451151e-01  1.361468e-02
      3037 2007   466_548093      JaccardDiss  4.642857e-01  5.566496e-03
      3038 2007   466_548093 MorisitaHornDiss  1.455573e-01  9.367824e-03
      3039 2007   466_548093   BrayCurtisDiss  4.455782e-01  1.361468e-02
      3040 2001   466_548093      JaccardDiss  3.333333e-01  5.566496e-03
      3041 2001   466_548093 MorisitaHornDiss  4.271475e-01  9.367824e-03
      3042 2001   466_548093   BrayCurtisDiss  4.360518e-01  1.361468e-02
      3043 1993   466_560475      JaccardDiss  4.500000e-01  3.262346e-03
      3044 1993   466_560475 MorisitaHornDiss  2.779001e-02  6.332215e-03
      3045 1993   466_560475   BrayCurtisDiss  4.303440e-01  7.109016e-03
      3046 1991   466_560475      JaccardDiss  3.703704e-01  3.262346e-03
      3047 1991   466_560475 MorisitaHornDiss  8.926445e-02  6.332215e-03
      3048 1991   466_560475   BrayCurtisDiss  3.391077e-01  7.109016e-03
      3049 1992   466_560475      JaccardDiss  3.636364e-01  3.262346e-03
      3050 1992   466_560475 MorisitaHornDiss  1.440560e-01  6.332215e-03
      3051 1992   466_560475   BrayCurtisDiss  3.865680e-01  7.109016e-03
      3052 2004   466_560475      JaccardDiss  5.714286e-01  3.262346e-03
      3053 2004   466_560475 MorisitaHornDiss  2.919392e-01  6.332215e-03
      3054 2004   466_560475   BrayCurtisDiss  6.821149e-01  7.109016e-03
      3055 2008   466_560475      JaccardDiss  3.181818e-01  3.262346e-03
      3056 2008   466_560475 MorisitaHornDiss  1.537726e-01  6.332215e-03
      3057 2008   466_560475   BrayCurtisDiss  3.361939e-01  7.109016e-03
      3058 1997   466_560475      JaccardDiss  5.000000e-01  3.262346e-03
      3059 1997   466_560475 MorisitaHornDiss  6.467027e-02  6.332215e-03
      3060 1997   466_560475   BrayCurtisDiss  6.915919e-01  7.109016e-03
      3061 2005   466_560475      JaccardDiss  5.200000e-01  3.262346e-03
      3062 2005   466_560475 MorisitaHornDiss  1.095362e-01  6.332215e-03
      3063 2005   466_560475   BrayCurtisDiss  5.922830e-01  7.109016e-03
      3064 1993   466_542986      JaccardDiss  3.913043e-01 -1.666144e-03
      3065 1993   466_542986 MorisitaHornDiss  8.965125e-01  1.777544e-02
      3066 1993   466_542986   BrayCurtisDiss  8.802779e-01  9.802613e-03
      3067 1996   466_542986      JaccardDiss  3.913043e-01 -1.666144e-03
      3068 1996   466_542986 MorisitaHornDiss  3.013275e-01  1.777544e-02
      3069 1996   466_542986   BrayCurtisDiss  3.995181e-01  9.802613e-03
      3070 2000   466_542986      JaccardDiss  4.400000e-01 -1.666144e-03
      3071 2000   466_542986 MorisitaHornDiss  3.700878e-01  1.777544e-02
      3072 2000   466_542986   BrayCurtisDiss  4.933075e-01  9.802613e-03
      3073 2001   466_542986      JaccardDiss  4.285714e-01 -1.666144e-03
      3074 2001   466_542986 MorisitaHornDiss  8.336298e-01  1.777544e-02
      3075 2001   466_542986   BrayCurtisDiss  7.675418e-01  9.802613e-03
      3076 1997   466_542986      JaccardDiss  5.000000e-01 -1.666144e-03
      3077 1997   466_542986 MorisitaHornDiss  1.799012e-01  1.777544e-02
      3078 1997   466_542986   BrayCurtisDiss  3.541263e-01  9.802613e-03
      3079 1987   466_542986      JaccardDiss  5.925926e-01 -1.666144e-03
      3080 1987   466_542986 MorisitaHornDiss  3.244507e-01  1.777544e-02
      3081 1987   466_542986   BrayCurtisDiss  4.029851e-01  9.802613e-03
      3082 1988   466_542986      JaccardDiss  3.750000e-01 -1.666144e-03
      3083 1988   466_542986 MorisitaHornDiss  2.737998e-01  1.777544e-02
      3084 1988   466_542986   BrayCurtisDiss  6.994582e-01  9.802613e-03
      3085 1989   466_542986      JaccardDiss  4.400000e-01 -1.666144e-03
      3086 1989   466_542986 MorisitaHornDiss  4.636104e-01  1.777544e-02
      3087 1989   466_542986   BrayCurtisDiss  6.454990e-01  9.802613e-03
      3088 1990   466_542986      JaccardDiss  4.782609e-01 -1.666144e-03
      3089 1990   466_542986 MorisitaHornDiss  1.765310e-01  1.777544e-02
      3090 1990   466_542986   BrayCurtisDiss  4.231857e-01  9.802613e-03
      3091 1994   466_542986      JaccardDiss  4.347826e-01 -1.666144e-03
      3092 1994   466_542986 MorisitaHornDiss  9.617554e-01  1.777544e-02
      3093 1994   466_542986   BrayCurtisDiss  9.288376e-01  9.802613e-03
      3094 1998   466_542986      JaccardDiss  4.347826e-01 -1.666144e-03
      3095 1998   466_542986 MorisitaHornDiss  3.170446e-01  1.777544e-02
      3096 1998   466_542986   BrayCurtisDiss  7.987382e-01  9.802613e-03
      3097 1999   466_542986      JaccardDiss  4.583333e-01 -1.666144e-03
      3098 1999   466_542986 MorisitaHornDiss  3.156534e-01  1.777544e-02
      3099 1999   466_542986   BrayCurtisDiss  6.425508e-01  9.802613e-03
      3100 2002   466_542986      JaccardDiss  4.761905e-01 -1.666144e-03
      3101 2002   466_542986 MorisitaHornDiss  9.123626e-01  1.777544e-02
      3102 2002   466_542986   BrayCurtisDiss  8.770344e-01  9.802613e-03
      3103 1994   466_569206      JaccardDiss  4.375000e-01  6.338206e-03
      3104 1994   466_569206 MorisitaHornDiss  6.274018e-01  2.377133e-02
      3105 1994   466_569206   BrayCurtisDiss  7.001404e-01  7.353310e-03
      3106 1999   466_569206      JaccardDiss  3.548387e-01  6.338206e-03
      3107 1999   466_569206 MorisitaHornDiss  6.169653e-01  2.377133e-02
      3108 1999   466_569206   BrayCurtisDiss  6.557462e-01  7.353310e-03
      3109 2002   466_569206      JaccardDiss  3.103448e-01  6.338206e-03
      3110 2002   466_569206 MorisitaHornDiss  4.814073e-01  2.377133e-02
      3111 2002   466_569206   BrayCurtisDiss  6.292310e-01  7.353310e-03
      3112 1992   466_569206      JaccardDiss  5.000000e-01  6.338206e-03
      3113 1992   466_569206 MorisitaHornDiss  5.350430e-02  2.377133e-02
      3114 1992   466_569206   BrayCurtisDiss  2.932382e-01  7.353310e-03
      3115 1995   466_569206      JaccardDiss  3.703704e-01  6.338206e-03
      3116 1995   466_569206 MorisitaHornDiss  8.511951e-01  2.377133e-02
      3117 1995   466_569206   BrayCurtisDiss  8.811757e-01  7.353310e-03
      3118 1997   466_569206      JaccardDiss  3.333333e-01  6.338206e-03
      3119 1997   466_569206 MorisitaHornDiss  2.768769e-01  2.377133e-02
      3120 1997   466_569206   BrayCurtisDiss  4.079886e-01  7.353310e-03
      3121 1998   466_569206      JaccardDiss  5.185185e-01  6.338206e-03
      3122 1998   466_569206 MorisitaHornDiss  8.996164e-02  2.377133e-02
      3123 1998   466_569206   BrayCurtisDiss  3.000000e-01  7.353310e-03
      3124 2001   466_569206      JaccardDiss  5.925926e-01  6.338206e-03
      3125 2001   466_569206 MorisitaHornDiss  6.086557e-02  2.377133e-02
      3126 2001   466_569206   BrayCurtisDiss  3.940476e-01  7.353310e-03
      3127 2004   466_569206      JaccardDiss  5.483871e-01  6.338206e-03
      3128 2004   466_569206 MorisitaHornDiss  8.278685e-01  2.377133e-02
      3129 2004   466_569206   BrayCurtisDiss  8.991889e-01  7.353310e-03
      3130 2005   466_569206      JaccardDiss  6.153846e-01  6.338206e-03
      3131 2005   466_569206 MorisitaHornDiss  5.954871e-01  2.377133e-02
      3132 2005   466_569206   BrayCurtisDiss  7.940161e-01  7.353310e-03
      3133 2006   466_569206      JaccardDiss  5.862069e-01  6.338206e-03
      3134 2006   466_569206 MorisitaHornDiss  9.417530e-01  2.377133e-02
      3135 2006   466_569206   BrayCurtisDiss  8.956262e-01  7.353310e-03
      3136 2007   466_569206      JaccardDiss  5.333333e-01  6.338206e-03
      3137 2007   466_569206 MorisitaHornDiss  4.731135e-01  2.377133e-02
      3138 2007   466_569206   BrayCurtisDiss  6.504469e-01  7.353310e-03
      3139 2008   466_569206      JaccardDiss  5.769231e-01  6.338206e-03
      3140 2008   466_569206 MorisitaHornDiss  5.586846e-01  2.377133e-02
      3141 2008   466_569206   BrayCurtisDiss  6.212737e-01  7.353310e-03
      3142 1991   466_569206      JaccardDiss  4.642857e-01  6.338206e-03
      3143 1991   466_569206 MorisitaHornDiss  6.348030e-02  2.377133e-02
      3144 1991   466_569206   BrayCurtisDiss  6.997500e-01  7.353310e-03
      3145 1993   466_569206      JaccardDiss  4.444444e-01  6.338206e-03
      3146 1993   466_569206 MorisitaHornDiss  1.994657e-01  2.377133e-02
      3147 1993   466_569206   BrayCurtisDiss  6.929581e-01  7.353310e-03
      3148 1996   466_569206      JaccardDiss  5.925926e-01  6.338206e-03
      3149 1996   466_569206 MorisitaHornDiss  3.378702e-01  2.377133e-02
      3150 1996   466_569206   BrayCurtisDiss  6.127724e-01  7.353310e-03
      3151 2000   466_569206      JaccardDiss  5.483871e-01  6.338206e-03
      3152 2000   466_569206 MorisitaHornDiss  8.454828e-01  2.377133e-02
      3153 2000   466_569206   BrayCurtisDiss  8.435556e-01  7.353310e-03
      3154 2003   466_569206      JaccardDiss  3.103448e-01  6.338206e-03
      3155 2003   466_569206 MorisitaHornDiss  6.204092e-02  2.377133e-02
      3156 2003   466_569206   BrayCurtisDiss  2.835900e-01  7.353310e-03
      3157 1994   466_540822      JaccardDiss  4.137931e-01 -7.147194e-03
      3158 1994   466_540822 MorisitaHornDiss  3.638447e-01 -2.365925e-03
      3159 1994   466_540822   BrayCurtisDiss  6.703117e-01  1.059367e-02
      3160 1997   466_540822      JaccardDiss  2.916667e-01 -7.147194e-03
      3161 1997   466_540822 MorisitaHornDiss  1.659697e-01 -2.365925e-03
      3162 1997   466_540822   BrayCurtisDiss  7.389941e-01  1.059367e-02
      3163 1998   466_540822      JaccardDiss  5.000000e-01 -7.147194e-03
      3164 1998   466_540822 MorisitaHornDiss  5.691602e-01 -2.365925e-03
      3165 1998   466_540822   BrayCurtisDiss  8.714499e-01  1.059367e-02
      3166 1999   466_540822      JaccardDiss  3.750000e-01 -7.147194e-03
      3167 1999   466_540822 MorisitaHornDiss  1.985018e-01 -2.365925e-03
      3168 1999   466_540822   BrayCurtisDiss  3.763724e-01  1.059367e-02
      3169 2002   466_540822      JaccardDiss  4.000000e-01 -7.147194e-03
      3170 2002   466_540822 MorisitaHornDiss  8.262644e-02 -2.365925e-03
      3171 2002   466_540822   BrayCurtisDiss  3.779367e-01  1.059367e-02
      3172 2003   466_540822      JaccardDiss  4.400000e-01 -7.147194e-03
      3173 2003   466_540822 MorisitaHornDiss  1.129999e-01 -2.365925e-03
      3174 2003   466_540822   BrayCurtisDiss  4.523175e-01  1.059367e-02
      3175 1990   466_540822      JaccardDiss  6.000000e-01 -7.147194e-03
      3176 1990   466_540822 MorisitaHornDiss  1.146671e-01 -2.365925e-03
      3177 1990   466_540822   BrayCurtisDiss  2.498005e-01  1.059367e-02
      3178 1991   466_540822      JaccardDiss  4.347826e-01 -7.147194e-03
      3179 1991   466_540822 MorisitaHornDiss  7.764437e-02 -2.365925e-03
      3180 1991   466_540822   BrayCurtisDiss  2.339880e-01  1.059367e-02
      3181 2001   466_540822      JaccardDiss  5.000000e-01 -7.147194e-03
      3182 2001   466_540822 MorisitaHornDiss  1.585194e-01 -2.365925e-03
      3183 2001   466_540822   BrayCurtisDiss  6.554990e-01  1.059367e-02
      3184 2000   466_540822      JaccardDiss  3.333333e-01 -7.147194e-03
      3185 2000   466_540822 MorisitaHornDiss  6.355287e-02 -2.365925e-03
      3186 2000   466_540822   BrayCurtisDiss  2.241465e-01  1.059367e-02
      3187 1994   466_540821      JaccardDiss  4.166667e-01 -9.086712e-03
      3188 1994   466_540821 MorisitaHornDiss  6.927230e-02  1.533477e-02
      3189 1994   466_540821   BrayCurtisDiss  3.791741e-01  2.116950e-02
      3190 1997   466_540821      JaccardDiss  4.090909e-01 -9.086712e-03
      3191 1997   466_540821 MorisitaHornDiss  2.587678e-01  1.533477e-02
      3192 1997   466_540821   BrayCurtisDiss  4.350987e-01  2.116950e-02
      3193 1999   466_540821      JaccardDiss  3.684211e-01 -9.086712e-03
      3194 1999   466_540821 MorisitaHornDiss  1.254474e-01  1.533477e-02
      3195 1999   466_540821   BrayCurtisDiss  4.861050e-01  2.116950e-02
      3196 1995   466_542996      JaccardDiss  4.062500e-01  7.308527e-03
      3197 1995   466_542996 MorisitaHornDiss  5.262450e-02  1.248350e-02
      3198 1995   466_542996   BrayCurtisDiss  7.952136e-01  1.618624e-02
      3199 1996   466_542996      JaccardDiss  3.214286e-01  7.308527e-03
      3200 1996   466_542996 MorisitaHornDiss  4.767427e-02  1.248350e-02
      3201 1996   466_542996   BrayCurtisDiss  3.862302e-01  1.618624e-02
      3202 2001   466_542996      JaccardDiss  5.000000e-01  7.308527e-03
      3203 2001   466_542996 MorisitaHornDiss  1.700134e-01  1.248350e-02
      3204 2001   466_542996   BrayCurtisDiss  6.489002e-01  1.618624e-02
      3205 2000   466_542996      JaccardDiss  2.500000e-01  7.308527e-03
      3206 2000   466_542996 MorisitaHornDiss  7.316921e-02  1.248350e-02
      3207 2000   466_542996   BrayCurtisDiss  2.726501e-01  1.618624e-02
      3208 1992   466_542996      JaccardDiss  3.928571e-01  7.308527e-03
      3209 1992   466_542996 MorisitaHornDiss  2.501326e-02  1.248350e-02
      3210 1992   466_542996   BrayCurtisDiss  4.076231e-01  1.618624e-02
      3211 1993   466_542996      JaccardDiss  3.571429e-01  7.308527e-03
      3212 1993   466_542996 MorisitaHornDiss  3.560690e-02  1.248350e-02
      3213 1993   466_542996   BrayCurtisDiss  2.307370e-01  1.618624e-02
      3214 1997   466_542996      JaccardDiss  3.214286e-01  7.308527e-03
      3215 1997   466_542996 MorisitaHornDiss  1.609765e-02  1.248350e-02
      3216 1997   466_542996   BrayCurtisDiss  2.633552e-01  1.618624e-02
      3217 1998   466_542996      JaccardDiss  2.222222e-01  7.308527e-03
      3218 1998   466_542996 MorisitaHornDiss  1.650726e-01  1.248350e-02
      3219 1998   466_542996   BrayCurtisDiss  3.349020e-01  1.618624e-02
      3220 2002   466_542996      JaccardDiss  4.333333e-01  7.308527e-03
      3221 2002   466_542996 MorisitaHornDiss  5.243868e-01  1.248350e-02
      3222 2002   466_542996   BrayCurtisDiss  6.365419e-01  1.618624e-02
      3223 2005   466_542996      JaccardDiss  5.000000e-01  7.308527e-03
      3224 2005   466_542996 MorisitaHornDiss  9.290019e-02  1.248350e-02
      3225 2005   466_542996   BrayCurtisDiss  6.476437e-01  1.618624e-02
      3226 2006   466_542996      JaccardDiss  4.000000e-01  7.308527e-03
      3227 2006   466_542996 MorisitaHornDiss  2.293150e-02  1.248350e-02
      3228 2006   466_542996   BrayCurtisDiss  1.601599e-01  1.618624e-02
      3229 2003   466_542996      JaccardDiss  4.285714e-01  7.308527e-03
      3230 2003   466_542996 MorisitaHornDiss  1.228120e-01  1.248350e-02
      3231 2003   466_542996   BrayCurtisDiss  9.177947e-01  1.618624e-02
      3232 2008   466_542996      JaccardDiss  4.687500e-01  7.308527e-03
      3233 2008   466_542996 MorisitaHornDiss  7.410664e-02  1.248350e-02
      3234 2008   466_542996   BrayCurtisDiss  9.161498e-01  1.618624e-02
      3235 2007   466_542996      JaccardDiss  3.571429e-01  7.308527e-03
      3236 2007   466_542996 MorisitaHornDiss  5.445933e-01  1.248350e-02
      3237 2007   466_542996   BrayCurtisDiss  7.011986e-01  1.618624e-02
      3238 2004   466_542996      JaccardDiss  5.357143e-01  7.308527e-03
      3239 2004   466_542996 MorisitaHornDiss  7.775255e-02  1.248350e-02
      3240 2004   466_542996   BrayCurtisDiss  1.969088e-01  1.618624e-02
      3241 1999   466_542996      JaccardDiss  4.827586e-01  7.308527e-03
      3242 1999   466_542996 MorisitaHornDiss  1.753879e-01  1.248350e-02
      3243 1999   466_542996   BrayCurtisDiss  9.013827e-01  1.618624e-02
      3244 1997   466_541536      JaccardDiss  3.600000e-01  2.491035e-03
      3245 1997   466_541536 MorisitaHornDiss  1.592462e-02  8.046738e-03
      3246 1997   466_541536   BrayCurtisDiss  6.548387e-01  2.930729e-03
      3247 1992   466_541536      JaccardDiss  3.200000e-01  2.491035e-03
      3248 1992   466_541536 MorisitaHornDiss  6.447258e-02  8.046738e-03
      3249 1992   466_541536   BrayCurtisDiss  3.449845e-01  2.930729e-03
      3250 1993   466_541536      JaccardDiss  2.727273e-01  2.491035e-03
      3251 1993   466_541536 MorisitaHornDiss  4.497405e-02  8.046738e-03
      3252 1993   466_541536   BrayCurtisDiss  8.071728e-01  2.930729e-03
      3253 1995   466_541536      JaccardDiss  2.083333e-01  2.491035e-03
      3254 1995   466_541536 MorisitaHornDiss  1.747218e-02  8.046738e-03
      3255 1995   466_541536   BrayCurtisDiss  1.318205e-01  2.930729e-03
      3256 1998   466_541536      JaccardDiss  4.347826e-01  2.491035e-03
      3257 1998   466_541536 MorisitaHornDiss  1.195085e-02  8.046738e-03
      3258 1998   466_541536   BrayCurtisDiss  2.950024e-01  2.930729e-03
      3259 2000   466_541536      JaccardDiss  3.636364e-01  2.491035e-03
      3260 2000   466_541536 MorisitaHornDiss  2.843235e-01  8.046738e-03
      3261 2000   466_541536   BrayCurtisDiss  4.049476e-01  2.930729e-03
      3262 2001   466_541536      JaccardDiss  3.333333e-01  2.491035e-03
      3263 2001   466_541536 MorisitaHornDiss  9.827190e-02  8.046738e-03
      3264 2001   466_541536   BrayCurtisDiss  5.685464e-01  2.930729e-03
      3265 2002   466_541536      JaccardDiss  4.347826e-01  2.491035e-03
      3266 2002   466_541536 MorisitaHornDiss  8.911778e-02  8.046738e-03
      3267 2002   466_541536   BrayCurtisDiss  5.341248e-01  2.930729e-03
      3268 2004   466_541536      JaccardDiss  4.166667e-01  2.491035e-03
      3269 2004   466_541536 MorisitaHornDiss  5.516629e-01  8.046738e-03
      3270 2004   466_541536   BrayCurtisDiss  8.066128e-01  2.930729e-03
      3271 2005   466_541536      JaccardDiss  2.083333e-01  2.491035e-03
      3272 2005   466_541536 MorisitaHornDiss  1.042995e-01  8.046738e-03
      3273 2005   466_541536   BrayCurtisDiss  4.193010e-01  2.930729e-03
      3274 2006   466_541536      JaccardDiss  2.083333e-01  2.491035e-03
      3275 2006   466_541536 MorisitaHornDiss  1.191691e-01  8.046738e-03
      3276 2006   466_541536   BrayCurtisDiss  7.254839e-01  2.930729e-03
      3277 2007   466_541536      JaccardDiss  4.545455e-01  2.491035e-03
      3278 2007   466_541536 MorisitaHornDiss  5.135240e-03  8.046738e-03
      3279 2007   466_541536   BrayCurtisDiss  1.320579e-01  2.930729e-03
      3280 1999   466_541536      JaccardDiss  5.000000e-01  2.491035e-03
      3281 1999   466_541536 MorisitaHornDiss  2.325758e-01  8.046738e-03
      3282 1999   466_541536   BrayCurtisDiss  3.609359e-01  2.930729e-03
      3283 2003   466_541536      JaccardDiss  3.461538e-01  2.491035e-03
      3284 2003   466_541536 MorisitaHornDiss  1.684720e-02  8.046738e-03
      3285 2003   466_541536   BrayCurtisDiss  5.201736e-01  2.930729e-03
      3286 1990   466_545180      JaccardDiss  2.857143e-01  5.616501e-03
      3287 1990   466_545180 MorisitaHornDiss  2.465951e-02  3.466361e-03
      3288 1990   466_545180   BrayCurtisDiss  5.271000e-01 -4.570755e-03
      3289 1991   466_545180      JaccardDiss  3.043478e-01  5.616501e-03
      3290 1991   466_545180 MorisitaHornDiss  5.241579e-02  3.466361e-03
      3291 1991   466_545180   BrayCurtisDiss  3.466363e-01 -4.570755e-03
      3292 1992   466_545180      JaccardDiss  2.916667e-01  5.616501e-03
      3293 1992   466_545180 MorisitaHornDiss  1.223539e-01  3.466361e-03
      3294 1992   466_545180   BrayCurtisDiss  5.727222e-01 -4.570755e-03
      3295 1993   466_545180      JaccardDiss  2.916667e-01  5.616501e-03
      3296 1993   466_545180 MorisitaHornDiss  1.213207e-02  3.466361e-03
      3297 1993   466_545180   BrayCurtisDiss  7.556189e-01 -4.570755e-03
      3298 1994   466_545180      JaccardDiss  3.478261e-01  5.616501e-03
      3299 1994   466_545180 MorisitaHornDiss  1.744012e-01  3.466361e-03
      3300 1994   466_545180   BrayCurtisDiss  3.125197e-01 -4.570755e-03
      3301 1995   466_545180      JaccardDiss  3.478261e-01  5.616501e-03
      3302 1995   466_545180 MorisitaHornDiss  2.350988e-01  3.466361e-03
      3303 1995   466_545180   BrayCurtisDiss  7.901681e-01 -4.570755e-03
      3304 1996   466_545180      JaccardDiss  3.333333e-01  5.616501e-03
      3305 1996   466_545180 MorisitaHornDiss  2.902258e-02  3.466361e-03
      3306 1996   466_545180   BrayCurtisDiss  8.262330e-01 -4.570755e-03
      3307 1998   466_545180      JaccardDiss  5.000000e-01  5.616501e-03
      3308 1998   466_545180 MorisitaHornDiss  1.915896e-02  3.466361e-03
      3309 1998   466_545180   BrayCurtisDiss  3.975510e-01 -4.570755e-03
      3310 1999   466_545180      JaccardDiss  2.272727e-01  5.616501e-03
      3311 1999   466_545180 MorisitaHornDiss  3.927639e-02  3.466361e-03
      3312 1999   466_545180   BrayCurtisDiss  6.016347e-01 -4.570755e-03
      3313 2000   466_545180      JaccardDiss  3.750000e-01  5.616501e-03
      3314 2000   466_545180 MorisitaHornDiss  4.541624e-01  3.466361e-03
      3315 2000   466_545180   BrayCurtisDiss  5.314657e-01 -4.570755e-03
      3316 2001   466_545180      JaccardDiss  3.043478e-01  5.616501e-03
      3317 2001   466_545180 MorisitaHornDiss  2.439910e-02  3.466361e-03
      3318 2001   466_545180   BrayCurtisDiss  2.828685e-01 -4.570755e-03
      3319 2002   466_545180      JaccardDiss  3.913043e-01  5.616501e-03
      3320 2002   466_545180 MorisitaHornDiss  4.443298e-02  3.466361e-03
      3321 2002   466_545180   BrayCurtisDiss  7.846861e-01 -4.570755e-03
      3322 2003   466_545180      JaccardDiss  3.478261e-01  5.616501e-03
      3323 2003   466_545180 MorisitaHornDiss  5.894951e-02  3.466361e-03
      3324 2003   466_545180   BrayCurtisDiss  2.964684e-01 -4.570755e-03
      3325 1989   466_545180      JaccardDiss  5.000000e-01  5.616501e-03
      3326 1989   466_545180 MorisitaHornDiss  3.748179e-02  3.466361e-03
      3327 1989   466_545180   BrayCurtisDiss  5.886920e-01 -4.570755e-03
      3328 2004   466_545180      JaccardDiss  4.400000e-01  5.616501e-03
      3329 2004   466_545180 MorisitaHornDiss  7.619631e-02  3.466361e-03
      3330 2004   466_545180   BrayCurtisDiss  5.578008e-01 -4.570755e-03
      3331 2007   466_545180      JaccardDiss  5.454545e-01  5.616501e-03
      3332 2007   466_545180 MorisitaHornDiss  1.799565e-01  3.466361e-03
      3333 2007   466_545180   BrayCurtisDiss  6.268456e-01 -4.570755e-03
      3334 2005   466_545180      JaccardDiss  3.913043e-01  5.616501e-03
      3335 2005   466_545180 MorisitaHornDiss  9.112995e-02  3.466361e-03
      3336 2005   466_545180   BrayCurtisDiss  3.222048e-01 -4.570755e-03
      3337 2000   466_559014      JaccardDiss  2.857143e-01 -6.114440e-03
      3338 2000   466_559014 MorisitaHornDiss  6.019927e-01  1.128614e-02
      3339 2000   466_559014   BrayCurtisDiss  7.962172e-01 -2.539869e-03
      3340 2003   466_559014      JaccardDiss  3.928571e-01 -6.114440e-03
      3341 2003   466_559014 MorisitaHornDiss  5.243664e-01  1.128614e-02
      3342 2003   466_559014   BrayCurtisDiss  8.172617e-01 -2.539869e-03
      3343 2004   466_559014      JaccardDiss  4.333333e-01 -6.114440e-03
      3344 2004   466_559014 MorisitaHornDiss  1.772607e-01  1.128614e-02
      3345 2004   466_559014   BrayCurtisDiss  3.274352e-01 -2.539869e-03
      3346 1989   466_559014      JaccardDiss  4.666667e-01 -6.114440e-03
      3347 1989   466_559014 MorisitaHornDiss  1.651203e-01  1.128614e-02
      3348 1989   466_559014   BrayCurtisDiss  7.318321e-01 -2.539869e-03
      3349 1993   466_559014      JaccardDiss  4.642857e-01 -6.114440e-03
      3350 1993   466_559014 MorisitaHornDiss  1.486670e-01  1.128614e-02
      3351 1993   466_559014   BrayCurtisDiss  3.987433e-01 -2.539869e-03
      3352 1995   466_559014      JaccardDiss  4.285714e-01 -6.114440e-03
      3353 1995   466_559014 MorisitaHornDiss  1.332978e-01  1.128614e-02
      3354 1995   466_559014   BrayCurtisDiss  4.925460e-01 -2.539869e-03
      3355 1998   466_559014      JaccardDiss  4.285714e-01 -6.114440e-03
      3356 1998   466_559014 MorisitaHornDiss  1.675986e-01  1.128614e-02
      3357 1998   466_559014   BrayCurtisDiss  3.966391e-01 -2.539869e-03
      3358 1986   466_559014      JaccardDiss  4.827586e-01 -6.114440e-03
      3359 1986   466_559014 MorisitaHornDiss  1.656531e-01  1.128614e-02
      3360 1986   466_559014   BrayCurtisDiss  6.882653e-01 -2.539869e-03
      3361 1987   466_559014      JaccardDiss  5.357143e-01 -6.114440e-03
      3362 1987   466_559014 MorisitaHornDiss  1.851814e-01  1.128614e-02
      3363 1987   466_559014   BrayCurtisDiss  7.343745e-01 -2.539869e-03
      3364 1991   466_559014      JaccardDiss  4.838710e-01 -6.114440e-03
      3365 1991   466_559014 MorisitaHornDiss  1.762321e-01  1.128614e-02
      3366 1991   466_559014   BrayCurtisDiss  4.647861e-01 -2.539869e-03
      3367 1994   466_559014      JaccardDiss  2.692308e-01 -6.114440e-03
      3368 1994   466_559014 MorisitaHornDiss  1.879126e-01  1.128614e-02
      3369 1994   466_559014   BrayCurtisDiss  3.742245e-01 -2.539869e-03
      3370 2002   466_559014      JaccardDiss  5.185185e-01 -6.114440e-03
      3371 2002   466_559014 MorisitaHornDiss  1.276986e-01  1.128614e-02
      3372 2002   466_559014   BrayCurtisDiss  6.961166e-01 -2.539869e-03
      3373 1999   466_559014      JaccardDiss  4.642857e-01 -6.114440e-03
      3374 1999   466_559014 MorisitaHornDiss  8.591327e-02  1.128614e-02
      3375 1999   466_559014   BrayCurtisDiss  5.213001e-01 -2.539869e-03
      3376 2001   466_559014      JaccardDiss  5.925926e-01 -6.114440e-03
      3377 2001   466_559014 MorisitaHornDiss  9.856049e-01  1.128614e-02
      3378 2001   466_559014   BrayCurtisDiss  9.825581e-01 -2.539869e-03
      3379 2007   466_559014      JaccardDiss  2.083333e-01 -6.114440e-03
      3380 2007   466_559014 MorisitaHornDiss  1.406489e-01  1.128614e-02
      3381 2007   466_559014   BrayCurtisDiss  3.812601e-01 -2.539869e-03
      3382 2001   466_543722      JaccardDiss  5.000000e-01 -3.632479e-02
      3383 2001   466_543722 MorisitaHornDiss  1.904024e-01 -2.997645e-02
      3384 2001   466_543722   BrayCurtisDiss  4.526807e-01 -1.767765e-02
      3385 2004   466_543722      JaccardDiss  5.833333e-01 -3.632479e-02
      3386 2004   466_543722 MorisitaHornDiss  7.476435e-02 -2.997645e-02
      3387 2004   466_543722   BrayCurtisDiss  4.276680e-01 -1.767765e-02
      3388 2005   466_543722      JaccardDiss  2.777778e-01 -3.632479e-02
      3389 2005   466_543722 MorisitaHornDiss  8.078003e-02 -2.997645e-02
      3390 2005   466_543722   BrayCurtisDiss  3.707619e-01 -1.767765e-02
      3391 1992   466_547367      JaccardDiss  3.750000e-01  3.338002e-03
      3392 1992   466_547367 MorisitaHornDiss  1.097167e-02  2.150318e-02
      3393 1992   466_547367   BrayCurtisDiss  7.579957e-01  2.209557e-02
      3394 1990   466_547367      JaccardDiss  4.400000e-01  3.338002e-03
      3395 1990   466_547367 MorisitaHornDiss  1.911836e-02  2.150318e-02
      3396 1990   466_547367   BrayCurtisDiss  3.770509e-01  2.209557e-02
      3397 1991   466_547367      JaccardDiss  4.444444e-01  3.338002e-03
      3398 1991   466_547367 MorisitaHornDiss  1.401734e-02  2.150318e-02
      3399 1991   466_547367   BrayCurtisDiss  1.177469e-01  2.209557e-02
      3400 1993   466_547367      JaccardDiss  3.200000e-01  3.338002e-03
      3401 1993   466_547367 MorisitaHornDiss  1.079760e-02  2.150318e-02
      3402 1993   466_547367   BrayCurtisDiss  4.752094e-01  2.209557e-02
      3403 2002   466_547367      JaccardDiss  3.913043e-01  3.338002e-03
      3404 2002   466_547367 MorisitaHornDiss  5.475700e-01  2.150318e-02
      3405 2002   466_547367   BrayCurtisDiss  7.172775e-01  2.209557e-02
      3406 2004   466_547367      JaccardDiss  5.000000e-01  3.338002e-03
      3407 2004   466_547367 MorisitaHornDiss  1.159823e-01  2.150318e-02
      3408 2004   466_547367   BrayCurtisDiss  3.699907e-01  2.209557e-02
      3409 2003   466_547367      JaccardDiss  5.384615e-01  3.338002e-03
      3410 2003   466_547367 MorisitaHornDiss  2.887905e-01  2.150318e-02
      3411 2003   466_547367   BrayCurtisDiss  7.630910e-01  2.209557e-02
      3412 2005   466_547367      JaccardDiss  2.800000e-01  3.338002e-03
      3413 2005   466_547367 MorisitaHornDiss  9.813249e-03  2.150318e-02
      3414 2005   466_547367   BrayCurtisDiss  8.118403e-02  2.209557e-02
      3415 1994   466_547367      JaccardDiss  3.846154e-01  3.338002e-03
      3416 1994   466_547367 MorisitaHornDiss  6.749284e-03  2.150318e-02
      3417 1994   466_547367   BrayCurtisDiss  1.021810e-01  2.209557e-02
      3418 1986   466_547367      JaccardDiss  3.750000e-01  3.338002e-03
      3419 1986   466_547367 MorisitaHornDiss  2.365716e-02  2.150318e-02
      3420 1986   466_547367   BrayCurtisDiss  3.317825e-01  2.209557e-02
      3421 1996   466_547367      JaccardDiss  3.750000e-01  3.338002e-03
      3422 1996   466_547367 MorisitaHornDiss  3.212658e-02  2.150318e-02
      3423 1996   466_547367   BrayCurtisDiss  3.068212e-01  2.209557e-02
      3424 1997   466_547367      JaccardDiss  5.454545e-01  3.338002e-03
      3425 1997   466_547367 MorisitaHornDiss  7.334772e-03  2.150318e-02
      3426 1997   466_547367   BrayCurtisDiss  5.597122e-01  2.209557e-02
      3427 1995   466_547367      JaccardDiss  3.913043e-01  3.338002e-03
      3428 1995   466_547367 MorisitaHornDiss  2.742694e-02  2.150318e-02
      3429 1995   466_547367   BrayCurtisDiss  1.804901e-01  2.209557e-02
      3430 1998   466_547367      JaccardDiss  4.782609e-01  3.338002e-03
      3431 1998   466_547367 MorisitaHornDiss  4.035119e-02  2.150318e-02
      3432 1998   466_547367   BrayCurtisDiss  4.807845e-01  2.209557e-02
      3433 1999   466_547367      JaccardDiss  5.000000e-01  3.338002e-03
      3434 1999   466_547367 MorisitaHornDiss  1.108197e-02  2.150318e-02
      3435 1999   466_547367   BrayCurtisDiss  1.902155e-01  2.209557e-02
      3436 2000   466_547367      JaccardDiss  4.347826e-01  3.338002e-03
      3437 2000   466_547367 MorisitaHornDiss  3.041055e-03  2.150318e-02
      3438 2000   466_547367   BrayCurtisDiss  7.158708e-02  2.209557e-02
      3439 2001   466_547367      JaccardDiss  5.600000e-01  3.338002e-03
      3440 2001   466_547367 MorisitaHornDiss  9.447351e-01  2.150318e-02
      3441 2001   466_547367   BrayCurtisDiss  9.455600e-01  2.209557e-02
      3442 2007   466_547367      JaccardDiss  5.833333e-01  3.338002e-03
      3443 2007   466_547367 MorisitaHornDiss  7.572200e-01  2.150318e-02
      3444 2007   466_547367   BrayCurtisDiss  9.093555e-01  2.209557e-02
      3445 2008   466_547367      JaccardDiss  4.545455e-01  3.338002e-03
      3446 2008   466_547367 MorisitaHornDiss  3.394911e-01  2.150318e-02
      3447 2008   466_547367   BrayCurtisDiss  8.677990e-01  2.209557e-02
      3448 2006   466_547367      JaccardDiss  3.000000e-01  3.338002e-03
      3449 2006   466_547367 MorisitaHornDiss  2.722925e-02  2.150318e-02
      3450 2006   466_547367   BrayCurtisDiss  8.520915e-01  2.209557e-02
      3451 1999   466_565568      JaccardDiss  3.000000e-01 -3.815971e-04
      3452 1999   466_565568 MorisitaHornDiss  9.778336e-01  1.620381e-02
      3453 1999   466_565568   BrayCurtisDiss  9.083900e-01 -1.136943e-03
      3454 2002   466_565568      JaccardDiss  4.000000e-01 -3.815971e-04
      3455 2002   466_565568 MorisitaHornDiss  2.713994e-02  1.620381e-02
      3456 2002   466_565568   BrayCurtisDiss  1.877850e-01 -1.136943e-03
      3457 1988   466_565568      JaccardDiss  5.000000e-01 -3.815971e-04
      3458 1988   466_565568 MorisitaHornDiss  1.110053e-03  1.620381e-02
      3459 1988   466_565568   BrayCurtisDiss  7.930511e-01 -1.136943e-03
      3460 1994   466_565568      JaccardDiss  4.800000e-01 -3.815971e-04
      3461 1994   466_565568 MorisitaHornDiss  9.716059e-01  1.620381e-02
      3462 1994   466_565568   BrayCurtisDiss  8.716069e-01 -1.136943e-03
      3463 1997   466_565568      JaccardDiss  4.545455e-01 -3.815971e-04
      3464 1997   466_565568 MorisitaHornDiss  7.095768e-02  1.620381e-02
      3465 1997   466_565568   BrayCurtisDiss  2.366995e-01 -1.136943e-03
      3466 2000   466_565568      JaccardDiss  6.190476e-01 -3.815971e-04
      3467 2000   466_565568 MorisitaHornDiss  9.761422e-01  1.620381e-02
      3468 2000   466_565568   BrayCurtisDiss  9.215403e-01 -1.136943e-03
      3469 2006   466_565568      JaccardDiss  4.444444e-01 -3.815971e-04
      3470 2006   466_565568 MorisitaHornDiss  5.699993e-01  1.620381e-02
      3471 2006   466_565568   BrayCurtisDiss  7.621129e-01 -1.136943e-03
      3472 1992   466_565568      JaccardDiss  4.166667e-01 -3.815971e-04
      3473 1992   466_565568 MorisitaHornDiss  9.670598e-01  1.620381e-02
      3474 1992   466_565568   BrayCurtisDiss  8.956999e-01 -1.136943e-03
      3475 1993   466_565568      JaccardDiss  4.285714e-01 -3.815971e-04
      3476 1993   466_565568 MorisitaHornDiss  1.940313e-03  1.620381e-02
      3477 1993   466_565568   BrayCurtisDiss  4.969870e-01 -1.136943e-03
      3478 1996   466_565568      JaccardDiss  4.090909e-01 -3.815971e-04
      3479 1996   466_565568 MorisitaHornDiss  9.609742e-01  1.620381e-02
      3480 1996   466_565568   BrayCurtisDiss  8.834706e-01 -1.136943e-03
      3481 2001   466_565568      JaccardDiss  6.250000e-01 -3.815971e-04
      3482 2001   466_565568 MorisitaHornDiss  9.690226e-01  1.620381e-02
      3483 2001   466_565568   BrayCurtisDiss  8.627582e-01 -1.136943e-03
      3484 2005   466_565568      JaccardDiss  4.782609e-01 -3.815971e-04
      3485 2005   466_565568 MorisitaHornDiss  9.675320e-01  1.620381e-02
      3486 2005   466_565568   BrayCurtisDiss  8.944043e-01 -1.136943e-03
      3487 2007   466_565568      JaccardDiss  4.347826e-01 -3.815971e-04
      3488 2007   466_565568 MorisitaHornDiss  9.695631e-01  1.620381e-02
      3489 2007   466_565568   BrayCurtisDiss  8.941799e-01 -1.136943e-03
      3490 2003   466_565568      JaccardDiss  5.000000e-01 -3.815971e-04
      3491 2003   466_565568 MorisitaHornDiss  1.686093e-01  1.620381e-02
      3492 2003   466_565568   BrayCurtisDiss  4.710597e-01 -1.136943e-03
      3493 1990   466_565568      JaccardDiss  5.909091e-01 -3.815971e-04
      3494 1990   466_565568 MorisitaHornDiss  8.272885e-01  1.620381e-02
      3495 1990   466_565568   BrayCurtisDiss  9.121398e-01 -1.136943e-03
      3496 2008   466_565568      JaccardDiss  5.185185e-01 -3.815971e-04
      3497 2008   466_565568 MorisitaHornDiss  9.363366e-01  1.620381e-02
      3498 2008   466_565568   BrayCurtisDiss  8.698482e-01 -1.136943e-03
      3499 2007   466_562656      JaccardDiss  5.000000e-01 -2.525585e-02
      3500 2007   466_562656 MorisitaHornDiss  4.105611e-01  8.872603e-03
      3501 2007   466_562656   BrayCurtisDiss  6.063536e-01 -2.470670e-02
      3502 2004   466_562656      JaccardDiss  5.263158e-01 -2.525585e-02
      3503 2004   466_562656 MorisitaHornDiss  2.231754e-01  8.872603e-03
      3504 2004   466_562656   BrayCurtisDiss  5.073478e-01 -2.470670e-02
      3505 2005   466_562656      JaccardDiss  5.625000e-01 -2.525585e-02
      3506 2005   466_562656 MorisitaHornDiss  5.747702e-01  8.872603e-03
      3507 2005   466_562656   BrayCurtisDiss  7.814297e-01 -2.470670e-02
      3508 2006   466_562656      JaccardDiss  3.888889e-01 -2.525585e-02
      3509 2006   466_562656 MorisitaHornDiss  1.013394e-01  8.872603e-03
      3510 2006   466_562656   BrayCurtisDiss  2.373453e-01 -2.470670e-02
      3511 1995   466_559741      JaccardDiss  4.166667e-01 -1.562245e-02
      3512 1995   466_559741 MorisitaHornDiss  2.805987e-02 -2.534734e-03
      3513 1995   466_559741   BrayCurtisDiss  1.347798e-01  1.617009e-02
      3514 1992   466_559741      JaccardDiss  4.642857e-01 -1.562245e-02
      3515 1992   466_559741 MorisitaHornDiss  4.230689e-02 -2.534734e-03
      3516 1992   466_559741   BrayCurtisDiss  6.617920e-01  1.617009e-02
      3517 1994   466_559741      JaccardDiss  4.400000e-01 -1.562245e-02
      3518 1994   466_559741 MorisitaHornDiss  6.054924e-01 -2.534734e-03
      3519 1994   466_559741   BrayCurtisDiss  7.251919e-01  1.617009e-02
      3520 2002   466_559741      JaccardDiss  3.636364e-01 -1.562245e-02
      3521 2002   466_559741 MorisitaHornDiss  2.788541e-01 -2.534734e-03
      3522 2002   466_559741   BrayCurtisDiss  8.363067e-01  1.617009e-02
      3523 2003   466_559741      JaccardDiss  2.500000e-01 -1.562245e-02
      3524 2003   466_559741 MorisitaHornDiss  1.086848e-01 -2.534734e-03
      3525 2003   466_559741   BrayCurtisDiss  6.278932e-01  1.617009e-02
      3526 2002   466_560470      JaccardDiss  4.761905e-01  8.761798e-04
      3527 2002   466_560470 MorisitaHornDiss  3.320450e-02  1.074408e-02
      3528 2002   466_560470   BrayCurtisDiss  5.560143e-01 -5.535577e-03
      3529 2008   466_560470      JaccardDiss  4.800000e-01  8.761798e-04
      3530 2008   466_560470 MorisitaHornDiss  1.630787e-02  1.074408e-02
      3531 2008   466_560470   BrayCurtisDiss  2.361982e-01 -5.535577e-03
      3532 1993   466_560470      JaccardDiss  5.600000e-01  8.761798e-04
      3533 1993   466_560470 MorisitaHornDiss  5.980779e-03  1.074408e-02
      3534 1993   466_560470   BrayCurtisDiss  2.585086e-01 -5.535577e-03
      3535 2001   466_560470      JaccardDiss  3.913043e-01  8.761798e-04
      3536 2001   466_560470 MorisitaHornDiss  7.244791e-02  1.074408e-02
      3537 2001   466_560470   BrayCurtisDiss  6.187616e-01 -5.535577e-03
      3538 1988   466_560470      JaccardDiss  4.000000e-01  8.761798e-04
      3539 1988   466_560470 MorisitaHornDiss  1.794887e-02  1.074408e-02
      3540 1988   466_560470   BrayCurtisDiss  4.912230e-01 -5.535577e-03
      3541 1998   466_560470      JaccardDiss  3.684211e-01  8.761798e-04
      3542 1998   466_560470 MorisitaHornDiss  6.394448e-01  1.074408e-02
      3543 1998   466_560470   BrayCurtisDiss  8.312223e-01 -5.535577e-03
      3544 2003   466_560470      JaccardDiss  5.384615e-01  8.761798e-04
      3545 2003   466_560470 MorisitaHornDiss  6.838480e-01  1.074408e-02
      3546 2003   466_560470   BrayCurtisDiss  8.999660e-01 -5.535577e-03
      3547 2004   466_560470      JaccardDiss  4.583333e-01  8.761798e-04
      3548 2004   466_560470 MorisitaHornDiss  7.908373e-01  1.074408e-02
      3549 2004   466_560470   BrayCurtisDiss  9.389569e-01 -5.535577e-03
      3550 2005   466_560470      JaccardDiss  4.285714e-01  8.761798e-04
      3551 2005   466_560470 MorisitaHornDiss  9.792944e-01  1.074408e-02
      3552 2005   466_560470   BrayCurtisDiss  9.577211e-01 -5.535577e-03
      3553 2007   466_560470      JaccardDiss  4.347826e-01  8.761798e-04
      3554 2007   466_560470 MorisitaHornDiss  4.725666e-03  1.074408e-02
      3555 2007   466_560470   BrayCurtisDiss  7.671044e-02 -5.535577e-03
      3556 2000   466_560470      JaccardDiss  4.782609e-01  8.761798e-04
      3557 2000   466_560470 MorisitaHornDiss  2.410612e-01  1.074408e-02
      3558 2000   466_560470   BrayCurtisDiss  7.476636e-01 -5.535577e-03
      3559 1990   466_560470      JaccardDiss  5.238095e-01  8.761798e-04
      3560 1990   466_560470 MorisitaHornDiss  3.626987e-01  1.074408e-02
      3561 1990   466_560470   BrayCurtisDiss  9.271828e-01 -5.535577e-03
      3562 1999   466_560470      JaccardDiss  4.500000e-01  8.761798e-04
      3563 1999   466_560470 MorisitaHornDiss  6.244577e-01  1.074408e-02
      3564 1999   466_560470   BrayCurtisDiss  9.123450e-01 -5.535577e-03
      3565 2006   466_560470      JaccardDiss  6.842105e-01  8.761798e-04
      3566 2006   466_560470 MorisitaHornDiss  3.869005e-02  1.074408e-02
      3567 2006   466_560470   BrayCurtisDiss  5.639543e-01 -5.535577e-03
      3568 1991   466_560470      JaccardDiss  5.185185e-01  8.761798e-04
      3569 1991   466_560470 MorisitaHornDiss  1.339342e-02  1.074408e-02
      3570 1991   466_560470   BrayCurtisDiss  6.297743e-01 -5.535577e-03
      3571 2002   466_545900      JaccardDiss  5.500000e-01  5.774811e-03
      3572 2002   466_545900 MorisitaHornDiss  5.929576e-01 -2.754593e-02
      3573 2002   466_545900   BrayCurtisDiss  6.679358e-01  4.444171e-03
      3574 2001   466_545900      JaccardDiss  5.500000e-01  5.774811e-03
      3575 2001   466_545900 MorisitaHornDiss  4.764429e-01 -2.754593e-02
      3576 2001   466_545900   BrayCurtisDiss  9.118515e-01  4.444171e-03
      3577 1992   466_545900      JaccardDiss  4.782609e-01  5.774811e-03
      3578 1992   466_545900 MorisitaHornDiss  6.038199e-01 -2.754593e-02
      3579 1992   466_545900   BrayCurtisDiss  7.443805e-01  4.444171e-03
      3580 1994   466_545900      JaccardDiss  5.789474e-01  5.774811e-03
      3581 1994   466_545900 MorisitaHornDiss  5.556370e-01 -2.754593e-02
      3582 1994   466_545900   BrayCurtisDiss  8.104720e-01  4.444171e-03
      3583 2005   466_545900      JaccardDiss  6.818182e-01  5.774811e-03
      3584 2005   466_545900 MorisitaHornDiss  1.910030e-01 -2.754593e-02
      3585 2005   466_545900   BrayCurtisDiss  7.912218e-01  4.444171e-03
      3586 2008   466_545900      JaccardDiss  6.000000e-01  5.774811e-03
      3587 2008   466_545900 MorisitaHornDiss  1.263450e-01 -2.754593e-02
      3588 2008   466_545900   BrayCurtisDiss  8.550247e-01  4.444171e-03
      3589 2004   466_545900      JaccardDiss  5.000000e-01  5.774811e-03
      3590 2004   466_545900 MorisitaHornDiss  3.422776e-01 -2.754593e-02
      3591 2004   466_545900   BrayCurtisDiss  8.852353e-01  4.444171e-03
      3592 2002   466_545893      JaccardDiss  4.800000e-01 -1.286032e-03
      3593 2002   466_545893 MorisitaHornDiss  5.579740e-01  1.769830e-02
      3594 2002   466_545893   BrayCurtisDiss  8.532161e-01  1.463310e-02
      3595 1989   466_545893      JaccardDiss  5.200000e-01 -1.286032e-03
      3596 1989   466_545893 MorisitaHornDiss  4.085412e-01  1.769830e-02
      3597 1989   466_545893   BrayCurtisDiss  7.081421e-01  1.463310e-02
      3598 1992   466_545893      JaccardDiss  4.827586e-01 -1.286032e-03
      3599 1992   466_545893 MorisitaHornDiss  1.313266e-01  1.769830e-02
      3600 1992   466_545893   BrayCurtisDiss  4.054827e-01  1.463310e-02
      3601 1999   466_545893      JaccardDiss  4.444444e-01 -1.286032e-03
      3602 1999   466_545893 MorisitaHornDiss  8.821900e-02  1.769830e-02
      3603 1999   466_545893   BrayCurtisDiss  6.456656e-01  1.463310e-02
      3604 2000   466_545893      JaccardDiss  5.000000e-01 -1.286032e-03
      3605 2000   466_545893 MorisitaHornDiss  1.328272e-01  1.769830e-02
      3606 2000   466_545893   BrayCurtisDiss  2.540181e-01  1.463310e-02
      3607 2001   466_545893      JaccardDiss  5.185185e-01 -1.286032e-03
      3608 2001   466_545893 MorisitaHornDiss  5.529116e-02  1.769830e-02
      3609 2001   466_545893   BrayCurtisDiss  5.379775e-01  1.463310e-02
      3610 2004   466_545893      JaccardDiss  4.814815e-01 -1.286032e-03
      3611 2004   466_545893 MorisitaHornDiss  8.190519e-01  1.769830e-02
      3612 2004   466_545893   BrayCurtisDiss  8.071625e-01  1.463310e-02
      3613 2007   466_545893      JaccardDiss  5.200000e-01 -1.286032e-03
      3614 2007   466_545893 MorisitaHornDiss  1.783297e-01  1.769830e-02
      3615 2007   466_545893   BrayCurtisDiss  5.208703e-01  1.463310e-02
      3616 1993   466_545893      JaccardDiss  5.416667e-01 -1.286032e-03
      3617 1993   466_545893 MorisitaHornDiss  6.812826e-02  1.769830e-02
      3618 1993   466_545893   BrayCurtisDiss  3.206489e-01  1.463310e-02
      3619 1997   466_545893      JaccardDiss  4.814815e-01 -1.286032e-03
      3620 1997   466_545893 MorisitaHornDiss  2.559357e-01  1.769830e-02
      3621 1997   466_545893   BrayCurtisDiss  8.627939e-01  1.463310e-02
      3622 2006   466_545893      JaccardDiss  5.000000e-01 -1.286032e-03
      3623 2006   466_545893 MorisitaHornDiss  5.501606e-01  1.769830e-02
      3624 2006   466_545893   BrayCurtisDiss  7.361327e-01  1.463310e-02
      3625 2005   466_545893      JaccardDiss  5.000000e-01 -1.286032e-03
      3626 2005   466_545893 MorisitaHornDiss  5.035484e-01  1.769830e-02
      3627 2005   466_545893   BrayCurtisDiss  7.643411e-01  1.463310e-02
      3628 1988   466_545893      JaccardDiss  3.846154e-01 -1.286032e-03
      3629 1988   466_545893 MorisitaHornDiss  1.525221e-02  1.769830e-02
      3630 1988   466_545893   BrayCurtisDiss  1.725304e-01  1.463310e-02
      3631 2003   466_545893      JaccardDiss  5.000000e-01 -1.286032e-03
      3632 2003   466_545893 MorisitaHornDiss  6.672948e-01  1.769830e-02
      3633 2003   466_545893   BrayCurtisDiss  8.000532e-01  1.463310e-02
      3634 2008   466_545893      JaccardDiss  2.777778e-01 -1.286032e-03
      3635 2008   466_545893 MorisitaHornDiss  2.626590e-01  1.769830e-02
      3636 2008   466_545893   BrayCurtisDiss  4.876937e-01  1.463310e-02
      3637 1986   466_548775      JaccardDiss  3.333333e-01 -3.146853e-04
      3638 1986   466_548775 MorisitaHornDiss  3.381919e-01  5.837714e-04
      3639 1986   466_548775   BrayCurtisDiss  4.652640e-01  5.248246e-03
      3640 1992   466_548775      JaccardDiss  4.285714e-01 -3.146853e-04
      3641 1992   466_548775 MorisitaHornDiss  5.933951e-02  5.837714e-04
      3642 1992   466_548775   BrayCurtisDiss  4.869195e-01  5.248246e-03
      3643 1997   466_548775      JaccardDiss  4.375000e-01 -3.146853e-04
      3644 1997   466_548775 MorisitaHornDiss  8.479086e-01  5.837714e-04
      3645 1997   466_548775   BrayCurtisDiss  8.616421e-01  5.248246e-03
      3646 2007   466_548775      JaccardDiss  4.285714e-01 -3.146853e-04
      3647 2007   466_548775 MorisitaHornDiss  2.904100e-01  5.837714e-04
      3648 2007   466_548775   BrayCurtisDiss  7.714885e-01  5.248246e-03
      3649 2008   466_548775      JaccardDiss  2.857143e-01 -3.146853e-04
      3650 2008   466_548775 MorisitaHornDiss  2.597878e-02  5.837714e-04
      3651 2008   466_548775   BrayCurtisDiss  5.407745e-01  5.248246e-03
      3652 1988   466_548775      JaccardDiss  3.076923e-01 -3.146853e-04
      3653 1988   466_548775 MorisitaHornDiss  4.462941e-02  5.837714e-04
      3654 1988   466_548775   BrayCurtisDiss  4.540943e-01  5.248246e-03
      3655 2002   466_548775      JaccardDiss  3.571429e-01 -3.146853e-04
      3656 2002   466_548775 MorisitaHornDiss  1.572111e-01  5.837714e-04
      3657 2002   466_548775   BrayCurtisDiss  6.037975e-01  5.248246e-03
      3658 2006   466_548775      JaccardDiss  5.000000e-01 -3.146853e-04
      3659 2006   466_548775 MorisitaHornDiss  4.835152e-02  5.837714e-04
      3660 2006   466_548775   BrayCurtisDiss  4.406528e-01  5.248246e-03
      3661 1996   466_548775      JaccardDiss  5.333333e-01 -3.146853e-04
      3662 1996   466_548775 MorisitaHornDiss  1.703563e-01  5.837714e-04
      3663 1996   466_548775   BrayCurtisDiss  4.977328e-01  5.248246e-03
      3664 1995   466_548775      JaccardDiss  5.000000e-01 -3.146853e-04
      3665 1995   466_548775 MorisitaHornDiss  4.357078e-02  5.837714e-04
      3666 1995   466_548775   BrayCurtisDiss  2.559761e-01  5.248246e-03
      3667 2003   466_548775      JaccardDiss  3.846154e-01 -3.146853e-04
      3668 2003   466_548775 MorisitaHornDiss  4.728764e-01  5.837714e-04
      3669 2003   466_548775   BrayCurtisDiss  7.840397e-01  5.248246e-03
      3670 2005   466_548775      JaccardDiss  5.000000e-01 -3.146853e-04
      3671 2005   466_548775 MorisitaHornDiss  3.278687e-02  5.837714e-04
      3672 2005   466_548775   BrayCurtisDiss  4.837862e-01  5.248246e-03
      3673 1987   466_548775      JaccardDiss  4.615385e-01 -3.146853e-04
      3674 1987   466_548775 MorisitaHornDiss  4.203121e-02  5.837714e-04
      3675 1987   466_548775   BrayCurtisDiss  6.920020e-01  5.248246e-03
      3676 1990   466_548775      JaccardDiss  4.285714e-01 -3.146853e-04
      3677 1990   466_548775 MorisitaHornDiss  5.208643e-02  5.837714e-04
      3678 1990   466_548775   BrayCurtisDiss  4.833047e-01  5.248246e-03
      3679 1991   466_548775      JaccardDiss  4.285714e-01 -3.146853e-04
      3680 1991   466_548775 MorisitaHornDiss  4.165255e-02  5.837714e-04
      3681 1991   466_548775   BrayCurtisDiss  4.846102e-01  5.248246e-03
      3682 1993   466_548775      JaccardDiss  5.000000e-01 -3.146853e-04
      3683 1993   466_548775 MorisitaHornDiss  7.952539e-01  5.837714e-04
      3684 1993   466_548775   BrayCurtisDiss  7.681053e-01  5.248246e-03
      3685 1999   466_548775      JaccardDiss  5.384615e-01 -3.146853e-04
      3686 1999   466_548775 MorisitaHornDiss  5.919447e-01  5.837714e-04
      3687 1999   466_548775   BrayCurtisDiss  9.171468e-01  5.248246e-03
      3688 2001   466_548775      JaccardDiss  2.307692e-01 -3.146853e-04
      3689 2001   466_548775 MorisitaHornDiss  1.777523e-01  5.837714e-04
      3690 2001   466_548775   BrayCurtisDiss  6.234097e-01  5.248246e-03
      3691 1989   466_552414      JaccardDiss  2.500000e-01  5.196382e-03
      3692 1989   466_552414 MorisitaHornDiss  2.888653e-01 -2.841765e-03
      3693 1989   466_552414   BrayCurtisDiss  6.129288e-01 -3.692346e-03
      3694 1991   466_552414      JaccardDiss  2.666667e-01  5.196382e-03
      3695 1991   466_552414 MorisitaHornDiss  6.684975e-02 -2.841765e-03
      3696 1991   466_552414   BrayCurtisDiss  5.531357e-01 -3.692346e-03
      3697 1996   466_552414      JaccardDiss  2.500000e-01  5.196382e-03
      3698 1996   466_552414 MorisitaHornDiss  2.646095e-01 -2.841765e-03
      3699 1996   466_552414   BrayCurtisDiss  4.338983e-01 -3.692346e-03
      3700 2005   466_552414      JaccardDiss  4.285714e-01  5.196382e-03
      3701 2005   466_552414 MorisitaHornDiss  1.436065e-01 -2.841765e-03
      3702 2005   466_552414   BrayCurtisDiss  3.676998e-01 -3.692346e-03
      3703 2006   466_552414      JaccardDiss  3.333333e-01  5.196382e-03
      3704 2006   466_552414 MorisitaHornDiss  1.962209e-01 -2.841765e-03
      3705 2006   466_552414   BrayCurtisDiss  5.585381e-01 -3.692346e-03
      3706 1993   466_552414      JaccardDiss  3.076923e-01  5.196382e-03
      3707 1993   466_552414 MorisitaHornDiss  7.756126e-02 -2.841765e-03
      3708 1993   466_552414   BrayCurtisDiss  7.468323e-01 -3.692346e-03
      3709 1995   466_552414      JaccardDiss  3.333333e-01  5.196382e-03
      3710 1995   466_552414 MorisitaHornDiss  9.483954e-02 -2.841765e-03
      3711 1995   466_552414   BrayCurtisDiss  4.261380e-01 -3.692346e-03
      3712 1999   466_552414      JaccardDiss  3.333333e-01  5.196382e-03
      3713 1999   466_552414 MorisitaHornDiss  2.342585e-01 -2.841765e-03
      3714 1999   466_552414   BrayCurtisDiss  6.049912e-01 -3.692346e-03
      3715 2001   466_552414      JaccardDiss  4.166667e-01  5.196382e-03
      3716 2001   466_552414 MorisitaHornDiss  2.961072e-01 -2.841765e-03
      3717 2001   466_552414   BrayCurtisDiss  7.669271e-01 -3.692346e-03
      3718 2008   466_552414      JaccardDiss  4.285714e-01  5.196382e-03
      3719 2008   466_552414 MorisitaHornDiss  6.217161e-02 -2.841765e-03
      3720 2008   466_552414   BrayCurtisDiss  2.732394e-01 -3.692346e-03
      3721 2007   466_552414      JaccardDiss  3.846154e-01  5.196382e-03
      3722 2007   466_552414 MorisitaHornDiss  9.191038e-02 -2.841765e-03
      3723 2007   466_552414   BrayCurtisDiss  5.637382e-01 -3.692346e-03
      3724 2003   466_552414      JaccardDiss  2.727273e-01  5.196382e-03
      3725 2003   466_552414 MorisitaHornDiss  3.668085e-01 -2.841765e-03
      3726 2003   466_552414   BrayCurtisDiss  8.492778e-01 -3.692346e-03
      3727 1986   466_552414      JaccardDiss  3.076923e-01  5.196382e-03
      3728 1986   466_552414 MorisitaHornDiss  2.709761e-01 -2.841765e-03
      3729 1986   466_552414   BrayCurtisDiss  6.855234e-01 -3.692346e-03
      3730 1988   466_552414      JaccardDiss  3.571429e-01  5.196382e-03
      3731 1988   466_552414 MorisitaHornDiss  2.392966e-01 -2.841765e-03
      3732 1988   466_552414   BrayCurtisDiss  5.028815e-01 -3.692346e-03
      3733 1990   466_552414      JaccardDiss  2.500000e-01  5.196382e-03
      3734 1990   466_552414 MorisitaHornDiss  2.419852e-01 -2.841765e-03
      3735 1990   466_552414   BrayCurtisDiss  4.650388e-01 -3.692346e-03
      3736 1994   466_552414      JaccardDiss  4.615385e-01  5.196382e-03
      3737 1994   466_552414 MorisitaHornDiss  1.512525e-01 -2.841765e-03
      3738 1994   466_552414   BrayCurtisDiss  3.183362e-01 -3.692346e-03
      3739 1997   466_552414      JaccardDiss  3.333333e-01  5.196382e-03
      3740 1997   466_552414 MorisitaHornDiss  1.172550e-01 -2.841765e-03
      3741 1997   466_552414   BrayCurtisDiss  3.291885e-01 -3.692346e-03
      3742 2002   466_552414      JaccardDiss  4.375000e-01  5.196382e-03
      3743 2002   466_552414 MorisitaHornDiss  1.566960e-01 -2.841765e-03
      3744 2002   466_552414   BrayCurtisDiss  3.656267e-01 -3.692346e-03
      3745 1986   466_553870      JaccardDiss  3.846154e-01 -2.151694e-02
      3746 1986   466_553870 MorisitaHornDiss  2.092318e-01 -1.850300e-02
      3747 1986   466_553870   BrayCurtisDiss  3.387337e-01 -3.295757e-02
      3748 1991   466_553870      JaccardDiss  2.727273e-01 -2.151694e-02
      3749 1991   466_553870 MorisitaHornDiss  1.080994e-01 -1.850300e-02
      3750 1991   466_553870   BrayCurtisDiss  2.035916e-01 -3.295757e-02
      3751 1988   466_553870      JaccardDiss  3.333333e-01 -2.151694e-02
      3752 1988   466_553870 MorisitaHornDiss  4.615868e-03 -1.850300e-02
      3753 1988   466_553870   BrayCurtisDiss  3.522805e-01 -3.295757e-02
      3754 1989   466_553870      JaccardDiss  3.333333e-01 -2.151694e-02
      3755 1989   466_553870 MorisitaHornDiss  2.919978e-02 -1.850300e-02
      3756 1989   466_553870   BrayCurtisDiss  1.710946e-01 -3.295757e-02
      3757 1986   466_555327      JaccardDiss  3.846154e-01  4.991688e-03
      3758 1986   466_555327 MorisitaHornDiss  2.138173e-01  6.716408e-03
      3759 1986   466_555327   BrayCurtisDiss  6.280463e-01 -9.115196e-03
      3760 1988   466_555327      JaccardDiss  4.285714e-01  4.991688e-03
      3761 1988   466_555327 MorisitaHornDiss  1.743699e-01  6.716408e-03
      3762 1988   466_555327   BrayCurtisDiss  6.678592e-01 -9.115196e-03
      3763 1992   466_555327      JaccardDiss  3.846154e-01  4.991688e-03
      3764 1992   466_555327 MorisitaHornDiss  2.440937e-02  6.716408e-03
      3765 1992   466_555327   BrayCurtisDiss  7.613107e-01 -9.115196e-03
      3766 1989   466_555327      JaccardDiss  4.615385e-01  4.991688e-03
      3767 1989   466_555327 MorisitaHornDiss  2.286502e-01  6.716408e-03
      3768 1989   466_555327   BrayCurtisDiss  7.363800e-01 -9.115196e-03
      3769 1990   466_555327      JaccardDiss  4.615385e-01  4.991688e-03
      3770 1990   466_555327 MorisitaHornDiss  1.294648e-01  6.716408e-03
      3771 1990   466_555327   BrayCurtisDiss  8.042313e-01 -9.115196e-03
      3772 1994   466_555327      JaccardDiss  4.615385e-01  4.991688e-03
      3773 1994   466_555327 MorisitaHornDiss  9.706880e-01  6.716408e-03
      3774 1994   466_555327   BrayCurtisDiss  9.539079e-01 -9.115196e-03
      3775 2008   466_555327      JaccardDiss  5.384615e-01  4.991688e-03
      3776 2008   466_555327 MorisitaHornDiss  2.953494e-02  6.716408e-03
      3777 2008   466_555327   BrayCurtisDiss  5.380952e-01 -9.115196e-03
      3778 1991   466_555327      JaccardDiss  5.384615e-01  4.991688e-03
      3779 1991   466_555327 MorisitaHornDiss  3.882526e-02  6.716408e-03
      3780 1991   466_555327   BrayCurtisDiss  6.759259e-01 -9.115196e-03
      3781 1993   466_555327      JaccardDiss  6.923077e-01  4.991688e-03
      3782 1993   466_555327 MorisitaHornDiss  1.683798e-01  6.716408e-03
      3783 1993   466_555327   BrayCurtisDiss  8.777771e-01 -9.115196e-03
      3784 1996   466_555327      JaccardDiss  5.714286e-01  4.991688e-03
      3785 1996   466_555327 MorisitaHornDiss  9.179884e-02  6.716408e-03
      3786 1996   466_555327   BrayCurtisDiss  6.741094e-01 -9.115196e-03
      3787 1997   466_555327      JaccardDiss  6.153846e-01  4.991688e-03
      3788 1997   466_555327 MorisitaHornDiss  9.078094e-01  6.716408e-03
      3789 1997   466_555327   BrayCurtisDiss  9.543407e-01 -9.115196e-03
      3790 1999   466_555327      JaccardDiss  5.384615e-01  4.991688e-03
      3791 1999   466_555327 MorisitaHornDiss  5.911318e-01  6.716408e-03
      3792 1999   466_555327   BrayCurtisDiss  8.604724e-01 -9.115196e-03
      3793 2001   466_555327      JaccardDiss  6.153846e-01  4.991688e-03
      3794 2001   466_555327 MorisitaHornDiss  6.851685e-01  6.716408e-03
      3795 2001   466_555327   BrayCurtisDiss  8.544112e-01 -9.115196e-03
      3796 2002   466_555327      JaccardDiss  3.571429e-01  4.991688e-03
      3797 2002   466_555327 MorisitaHornDiss  5.690227e-03  6.716408e-03
      3798 2002   466_555327   BrayCurtisDiss  1.308683e-01 -9.115196e-03
      3799 1986   466_558967      JaccardDiss  1.111111e-01  5.158377e-03
      3800 1986   466_558967 MorisitaHornDiss  3.432570e-01 -9.856499e-03
      3801 1986   466_558967   BrayCurtisDiss  7.700070e-01 -1.448712e-03
      3802 1994   466_558967      JaccardDiss  5.000000e-01  5.158377e-03
      3803 1994   466_558967 MorisitaHornDiss  8.206277e-03 -9.856499e-03
      3804 1994   466_558967   BrayCurtisDiss  5.818692e-01 -1.448712e-03
      3805 1991   466_558967      JaccardDiss  5.000000e-01  5.158377e-03
      3806 1991   466_558967 MorisitaHornDiss  2.520090e-04 -9.856499e-03
      3807 1991   466_558967   BrayCurtisDiss  6.793372e-01 -1.448712e-03
      3808 1992   466_558967      JaccardDiss  3.636364e-01  5.158377e-03
      3809 1992   466_558967 MorisitaHornDiss  6.447133e-01 -9.856499e-03
      3810 1992   466_558967   BrayCurtisDiss  6.526865e-01 -1.448712e-03
      3811 1997   466_558967      JaccardDiss  5.714286e-01  5.158377e-03
      3812 1997   466_558967 MorisitaHornDiss  7.680417e-03 -9.856499e-03
      3813 1997   466_558967   BrayCurtisDiss  2.702357e-01 -1.448712e-03
      3814 2006   466_558967      JaccardDiss  4.615385e-01  5.158377e-03
      3815 2006   466_558967 MorisitaHornDiss  3.474949e-03 -9.856499e-03
      3816 2006   466_558967   BrayCurtisDiss  5.503407e-01 -1.448712e-03
      3817 2008   466_558967      JaccardDiss  5.384615e-01  5.158377e-03
      3818 2008   466_558967 MorisitaHornDiss  3.726434e-04 -9.856499e-03
      3819 2008   466_558967   BrayCurtisDiss  6.056732e-01 -1.448712e-03
      3820 2005   466_558967      JaccardDiss  4.166667e-01  5.158377e-03
      3821 2005   466_558967 MorisitaHornDiss  4.489624e-02 -9.856499e-03
      3822 2005   466_558967   BrayCurtisDiss  2.770180e-01 -1.448712e-03
      3823 2003   466_558967      JaccardDiss  2.222222e-01  5.158377e-03
      3824 2003   466_558967 MorisitaHornDiss  1.452242e-03 -9.856499e-03
      3825 2003   466_558967   BrayCurtisDiss  5.210671e-02 -1.448712e-03
      3826 1988   466_558967      JaccardDiss  4.000000e-01  5.158377e-03
      3827 1988   466_558967 MorisitaHornDiss  4.210700e-03 -9.856499e-03
      3828 1988   466_558967   BrayCurtisDiss  1.310796e-01 -1.448712e-03
      3829 1989   466_558967      JaccardDiss  3.333333e-01  5.158377e-03
      3830 1989   466_558967 MorisitaHornDiss  4.097250e-03 -9.856499e-03
      3831 1989   466_558967   BrayCurtisDiss  8.822794e-02 -1.448712e-03
      3832 1990   466_558967      JaccardDiss  4.444444e-01  5.158377e-03
      3833 1990   466_558967 MorisitaHornDiss  9.674232e-05 -9.856499e-03
      3834 1990   466_558967   BrayCurtisDiss  3.365385e-01 -1.448712e-03
      3835 1987   466_558967      JaccardDiss  4.166667e-01  5.158377e-03
      3836 1987   466_558967 MorisitaHornDiss  3.260212e-01 -9.856499e-03
      3837 1987   466_558967   BrayCurtisDiss  3.744362e-01 -1.448712e-03
      3838 1987   466_553871      JaccardDiss  6.428571e-01 -4.839089e-03
      3839 1987   466_553871 MorisitaHornDiss  5.201534e-01 -1.981906e-02
      3840 1987   466_553871   BrayCurtisDiss  6.293790e-01 -3.013013e-04
      3841 1999   466_553871      JaccardDiss  5.000000e-01 -4.839089e-03
      3842 1999   466_553871 MorisitaHornDiss  6.766717e-02 -1.981906e-02
      3843 1999   466_553871   BrayCurtisDiss  5.471818e-01 -3.013013e-04
      3844 2008   466_553871      JaccardDiss  3.846154e-01 -4.839089e-03
      3845 2008   466_553871 MorisitaHornDiss  6.153222e-02 -1.981906e-02
      3846 2008   466_553871   BrayCurtisDiss  2.475206e-01 -3.013013e-04
      3847 1990   466_553871      JaccardDiss  6.428571e-01 -4.839089e-03
      3848 1990   466_553871 MorisitaHornDiss  6.194464e-01 -1.981906e-02
      3849 1990   466_553871   BrayCurtisDiss  5.774407e-01 -3.013013e-04
      3850 2001   466_553871      JaccardDiss  6.153846e-01 -4.839089e-03
      3851 2001   466_553871 MorisitaHornDiss  1.835957e-01 -1.981906e-02
      3852 2001   466_553871   BrayCurtisDiss  4.300589e-01 -3.013013e-04
      3853 2003   466_553871      JaccardDiss  6.923077e-01 -4.839089e-03
      3854 2003   466_553871 MorisitaHornDiss  7.691488e-02 -1.981906e-02
      3855 2003   466_553871   BrayCurtisDiss  7.996234e-01 -3.013013e-04
      3856 2005   466_553871      JaccardDiss  6.923077e-01 -4.839089e-03
      3857 2005   466_553871 MorisitaHornDiss  1.132514e-02 -1.981906e-02
      3858 2005   466_553871   BrayCurtisDiss  3.210137e-01 -3.013013e-04
      3859 2006   466_553871      JaccardDiss  5.000000e-01 -4.839089e-03
      3860 2006   466_553871 MorisitaHornDiss  6.176838e-02 -1.981906e-02
      3861 2006   466_553871   BrayCurtisDiss  6.353333e-01 -3.013013e-04
      3862 2007   466_553871      JaccardDiss  5.000000e-01 -4.839089e-03
      3863 2007   466_553871 MorisitaHornDiss  1.672655e-03 -1.981906e-02
      3864 2007   466_553871   BrayCurtisDiss  5.178866e-01 -3.013013e-04
      3865 1992   466_553871      JaccardDiss  6.153846e-01 -4.839089e-03
      3866 1992   466_553871 MorisitaHornDiss  4.976430e-02 -1.981906e-02
      3867 1992   466_553871   BrayCurtisDiss  4.391022e-01 -3.013013e-04
      3868 1994   466_553871      JaccardDiss  5.833333e-01 -4.839089e-03
      3869 1994   466_553871 MorisitaHornDiss  2.860062e-02 -1.981906e-02
      3870 1994   466_553871   BrayCurtisDiss  2.052354e-01 -3.013013e-04
      3871 1995   466_553871      JaccardDiss  5.000000e-01 -4.839089e-03
      3872 1995   466_553871 MorisitaHornDiss  6.242346e-02 -1.981906e-02
      3873 1995   466_553871   BrayCurtisDiss  2.355500e-01 -3.013013e-04
      3874 1996   466_553871      JaccardDiss  5.833333e-01 -4.839089e-03
      3875 1996   466_553871 MorisitaHornDiss  9.243215e-02 -1.981906e-02
      3876 1996   466_553871   BrayCurtisDiss  3.302284e-01 -3.013013e-04
      3877 1997   466_553871      JaccardDiss  5.833333e-01 -4.839089e-03
      3878 1997   466_553871 MorisitaHornDiss  1.523445e-01 -1.981906e-02
      3879 1997   466_553871   BrayCurtisDiss  2.500000e-01 -3.013013e-04
      3880 2002   466_553871      JaccardDiss  5.454545e-01 -4.839089e-03
      3881 2002   466_553871 MorisitaHornDiss  2.473191e-02 -1.981906e-02
      3882 2002   466_553871   BrayCurtisDiss  5.924626e-01 -3.013013e-04
      3883 1993   466_553871      JaccardDiss  5.384615e-01 -4.839089e-03
      3884 1993   466_553871 MorisitaHornDiss  3.782401e-01 -1.981906e-02
      3885 1993   466_553871   BrayCurtisDiss  6.042246e-01 -3.013013e-04
      3886 1988   466_552418      JaccardDiss  3.333333e-01  5.772440e-03
      3887 1988   466_552418 MorisitaHornDiss  1.996862e-04  1.773788e-03
      3888 1988   466_552418   BrayCurtisDiss  1.029601e-01 -2.280796e-03
      3889 1992   466_552418      JaccardDiss  1.666667e-01  5.772440e-03
      3890 1992   466_552418 MorisitaHornDiss  8.332415e-02  1.773788e-03
      3891 1992   466_552418   BrayCurtisDiss  4.016194e-01 -2.280796e-03
      3892 1995   466_552418      JaccardDiss  4.285714e-01  5.772440e-03
      3893 1995   466_552418 MorisitaHornDiss  1.986678e-02  1.773788e-03
      3894 1995   466_552418   BrayCurtisDiss  3.813877e-01 -2.280796e-03
      3895 2001   466_552418      JaccardDiss  4.285714e-01  5.772440e-03
      3896 2001   466_552418 MorisitaHornDiss  1.074048e-01  1.773788e-03
      3897 2001   466_552418   BrayCurtisDiss  6.357906e-01 -2.280796e-03
      3898 2002   466_552418      JaccardDiss  5.333333e-01  5.772440e-03
      3899 2002   466_552418 MorisitaHornDiss  8.523724e-03  1.773788e-03
      3900 2002   466_552418   BrayCurtisDiss  6.321883e-01 -2.280796e-03
      3901 1990   466_552418      JaccardDiss  3.571429e-01  5.772440e-03
      3902 1990   466_552418 MorisitaHornDiss  9.926709e-02  1.773788e-03
      3903 1990   466_552418   BrayCurtisDiss  7.329469e-01 -2.280796e-03
      3904 2003   466_552418      JaccardDiss  5.333333e-01  5.772440e-03
      3905 2003   466_552418 MorisitaHornDiss  1.446735e-01  1.773788e-03
      3906 2003   466_552418   BrayCurtisDiss  5.862290e-01 -2.280796e-03
      3907 2006   466_552418      JaccardDiss  3.571429e-01  5.772440e-03
      3908 2006   466_552418 MorisitaHornDiss  1.510817e-02  1.773788e-03
      3909 2006   466_552418   BrayCurtisDiss  2.428797e-01 -2.280796e-03
      3910 1994   466_552418      JaccardDiss  4.666667e-01  5.772440e-03
      3911 1994   466_552418 MorisitaHornDiss  7.012814e-02  1.773788e-03
      3912 1994   466_552418   BrayCurtisDiss  3.908156e-01 -2.280796e-03
      3913 1997   466_552418      JaccardDiss  5.333333e-01  5.772440e-03
      3914 1997   466_552418 MorisitaHornDiss  2.354247e-03  1.773788e-03
      3915 1997   466_552418   BrayCurtisDiss  1.969309e-01 -2.280796e-03
      3916 2005   466_552418      JaccardDiss  3.571429e-01  5.772440e-03
      3917 2005   466_552418 MorisitaHornDiss  1.264144e-01  1.773788e-03
      3918 2005   466_552418   BrayCurtisDiss  6.470588e-01 -2.280796e-03
      3919 2007   466_552418      JaccardDiss  4.615385e-01  5.772440e-03
      3920 2007   466_552418 MorisitaHornDiss  2.378263e-04  1.773788e-03
      3921 2007   466_552418   BrayCurtisDiss  9.397433e-02 -2.280796e-03
      3922 1989   466_552418      JaccardDiss  3.846154e-01  5.772440e-03
      3923 1989   466_552418 MorisitaHornDiss  8.961636e-03  1.773788e-03
      3924 1989   466_552418   BrayCurtisDiss  7.742336e-01 -2.280796e-03
      3925 1991   466_552418      JaccardDiss  4.615385e-01  5.772440e-03
      3926 1991   466_552418 MorisitaHornDiss  4.961478e-04  1.773788e-03
      3927 1991   466_552418   BrayCurtisDiss  3.008116e-01 -2.280796e-03
      3928 1993   466_552418      JaccardDiss  3.333333e-01  5.772440e-03
      3929 1993   466_552418 MorisitaHornDiss  9.949641e-03  1.773788e-03
      3930 1993   466_552418   BrayCurtisDiss  4.441828e-01 -2.280796e-03
      3931 1996   466_552418      JaccardDiss  1.818182e-01  5.772440e-03
      3932 1996   466_552418 MorisitaHornDiss  8.252333e-02  1.773788e-03
      3933 1996   466_552418   BrayCurtisDiss  4.448771e-01 -2.280796e-03
      3934 1988   466_553142      JaccardDiss  4.545455e-01 -2.050786e-03
      3935 1988   466_553142 MorisitaHornDiss  5.017605e-02  4.355277e-03
      3936 1988   466_553142   BrayCurtisDiss  2.108907e-01 -3.968367e-03
      3937 1995   466_553142      JaccardDiss  3.636364e-01 -2.050786e-03
      3938 1995   466_553142 MorisitaHornDiss  2.143970e-02  4.355277e-03
      3939 1995   466_553142   BrayCurtisDiss  5.116037e-01 -3.968367e-03
      3940 2002   466_553142      JaccardDiss  4.166667e-01 -2.050786e-03
      3941 2002   466_553142 MorisitaHornDiss  4.770285e-02  4.355277e-03
      3942 2002   466_553142   BrayCurtisDiss  2.916792e-01 -3.968367e-03
      3943 1991   466_553142      JaccardDiss  3.333333e-01 -2.050786e-03
      3944 1991   466_553142 MorisitaHornDiss  1.423779e-02  4.355277e-03
      3945 1991   466_553142   BrayCurtisDiss  3.749269e-01 -3.968367e-03
      3946 1993   466_553142      JaccardDiss  5.000000e-01 -2.050786e-03
      3947 1993   466_553142 MorisitaHornDiss  4.368302e-02  4.355277e-03
      3948 1993   466_553142   BrayCurtisDiss  3.188741e-01 -3.968367e-03
      3949 1994   466_553142      JaccardDiss  5.384615e-01 -2.050786e-03
      3950 1994   466_553142 MorisitaHornDiss  9.296119e-02  4.355277e-03
      3951 1994   466_553142   BrayCurtisDiss  4.260970e-01 -3.968367e-03
      3952 1996   466_553142      JaccardDiss  5.000000e-01 -2.050786e-03
      3953 1996   466_553142 MorisitaHornDiss  2.532428e-02  4.355277e-03
      3954 1996   466_553142   BrayCurtisDiss  2.567177e-01 -3.968367e-03
      3955 1997   466_553142      JaccardDiss  5.384615e-01 -2.050786e-03
      3956 1997   466_553142 MorisitaHornDiss  2.972518e-01  4.355277e-03
      3957 1997   466_553142   BrayCurtisDiss  4.239525e-01 -3.968367e-03
      3958 2001   466_553142      JaccardDiss  4.615385e-01 -2.050786e-03
      3959 2001   466_553142 MorisitaHornDiss  2.443783e-01  4.355277e-03
      3960 2001   466_553142   BrayCurtisDiss  6.450038e-01 -3.968367e-03
      3961 2007   466_553142      JaccardDiss  2.000000e-01 -2.050786e-03
      3962 2007   466_553142 MorisitaHornDiss  5.420558e-02  4.355277e-03
      3963 2007   466_553142   BrayCurtisDiss  1.701236e-01 -3.968367e-03
      3964 1989   466_553142      JaccardDiss  2.727273e-01 -2.050786e-03
      3965 1989   466_553142 MorisitaHornDiss  5.865428e-02  4.355277e-03
      3966 1989   466_553142   BrayCurtisDiss  4.730690e-01 -3.968367e-03
      3967 1990   466_553142      JaccardDiss  3.000000e-01 -2.050786e-03
      3968 1990   466_553142 MorisitaHornDiss  5.831143e-02  4.355277e-03
      3969 1990   466_553142   BrayCurtisDiss  4.951284e-01 -3.968367e-03
      3970 1988   466_553146      JaccardDiss  2.307692e-01  7.842190e-03
      3971 1988   466_553146 MorisitaHornDiss  2.633166e-02  3.225244e-04
      3972 1988   466_553146   BrayCurtisDiss  4.913964e-01 -7.902522e-03
      3973 1995   466_553146      JaccardDiss  4.285714e-01  7.842190e-03
      3974 1995   466_553146 MorisitaHornDiss  1.249447e-02  3.225244e-04
      3975 1995   466_553146   BrayCurtisDiss  2.902556e-01 -7.902522e-03
      3976 2005   466_553146      JaccardDiss  5.294118e-01  7.842190e-03
      3977 2005   466_553146 MorisitaHornDiss  1.623140e-02  3.225244e-04
      3978 2005   466_553146   BrayCurtisDiss  2.122734e-01 -7.902522e-03
      3979 2002   466_553146      JaccardDiss  3.571429e-01  7.842190e-03
      3980 2002   466_553146 MorisitaHornDiss  1.303011e-02  3.225244e-04
      3981 2002   466_553146   BrayCurtisDiss  6.555152e-01 -7.902522e-03
      3982 1993   466_553146      JaccardDiss  3.846154e-01  7.842190e-03
      3983 1993   466_553146 MorisitaHornDiss  7.161083e-03  3.225244e-04
      3984 1993   466_553146   BrayCurtisDiss  1.122995e-01 -7.902522e-03
      3985 2001   466_553146      JaccardDiss  3.333333e-01  7.842190e-03
      3986 2001   466_553146 MorisitaHornDiss  8.869006e-02  3.225244e-04
      3987 2001   466_553146   BrayCurtisDiss  4.759036e-01 -7.902522e-03
      3988 2007   466_553146      JaccardDiss  4.615385e-01  7.842190e-03
      3989 2007   466_553146 MorisitaHornDiss  7.226454e-03  3.225244e-04
      3990 2007   466_553146   BrayCurtisDiss  3.506125e-01 -7.902522e-03
      3991 2006   466_553146      JaccardDiss  3.571429e-01  7.842190e-03
      3992 2006   466_553146 MorisitaHornDiss  8.883173e-03  3.225244e-04
      3993 2006   466_553146   BrayCurtisDiss  1.000274e-01 -7.902522e-03
      3994 1989   466_553146      JaccardDiss  2.500000e-01  7.842190e-03
      3995 1989   466_553146 MorisitaHornDiss  1.078866e-02  3.225244e-04
      3996 1989   466_553146   BrayCurtisDiss  2.408112e-01 -7.902522e-03
      3997 1991   466_553146      JaccardDiss  2.857143e-01  7.842190e-03
      3998 1991   466_553146 MorisitaHornDiss  1.311645e-02  3.225244e-04
      3999 1991   466_553146   BrayCurtisDiss  8.121218e-01 -7.902522e-03
      4000 1996   466_553146      JaccardDiss  3.333333e-01  7.842190e-03
      4001 1996   466_553146 MorisitaHornDiss  1.642269e-01  3.225244e-04
      4002 1996   466_553146   BrayCurtisDiss  4.242600e-01 -7.902522e-03
      4003 1997   466_553146      JaccardDiss  4.166667e-01  7.842190e-03
      4004 1997   466_553146 MorisitaHornDiss  1.491043e-02  3.225244e-04
      4005 1997   466_553146   BrayCurtisDiss  5.235101e-01 -7.902522e-03
      4006 1999   466_553146      JaccardDiss  2.500000e-01  7.842190e-03
      4007 1999   466_553146 MorisitaHornDiss  4.437029e-01  3.225244e-04
      4008 1999   466_553146   BrayCurtisDiss  7.776831e-01 -7.902522e-03
      4009 2008   466_553146      JaccardDiss  3.846154e-01  7.842190e-03
      4010 2008   466_553146 MorisitaHornDiss  3.546047e-02  3.225244e-04
      4011 2008   466_553146   BrayCurtisDiss  2.710005e-01 -7.902522e-03
      4012 1988   466_556057      JaccardDiss  4.285714e-01  2.817695e-04
      4013 1988   466_556057 MorisitaHornDiss  2.237181e-02  1.099562e-02
      4014 1988   466_556057   BrayCurtisDiss  2.482412e-01  1.659003e-02
      4015 1995   466_556057      JaccardDiss  3.333333e-01  2.817695e-04
      4016 1995   466_556057 MorisitaHornDiss  2.987000e-01  1.099562e-02
      4017 1995   466_556057   BrayCurtisDiss  5.603927e-01  1.659003e-02
      4018 2003   466_556057      JaccardDiss  4.285714e-01  2.817695e-04
      4019 2003   466_556057 MorisitaHornDiss  1.959739e-01  1.099562e-02
      4020 2003   466_556057   BrayCurtisDiss  5.056143e-01  1.659003e-02
      4021 1988   466_557512      JaccardDiss  3.333333e-01  2.501878e-03
      4022 1988   466_557512 MorisitaHornDiss  4.519385e-02 -1.018956e-03
      4023 1988   466_557512   BrayCurtisDiss  2.491444e-01 -1.361824e-03
      4024 2005   466_557512      JaccardDiss  3.529412e-01  2.501878e-03
      4025 2005   466_557512 MorisitaHornDiss  5.757078e-02 -1.018956e-03
      4026 2005   466_557512   BrayCurtisDiss  3.467610e-01 -1.361824e-03
      4027 2008   466_557512      JaccardDiss  4.000000e-01  2.501878e-03
      4028 2008   466_557512 MorisitaHornDiss  4.241818e-02 -1.018956e-03
      4029 2008   466_557512   BrayCurtisDiss  4.670515e-01 -1.361824e-03
      4030 1989   466_557512      JaccardDiss  4.375000e-01  2.501878e-03
      4031 1989   466_557512 MorisitaHornDiss  2.081951e-02 -1.018956e-03
      4032 1989   466_557512   BrayCurtisDiss  2.993548e-01 -1.361824e-03
      4033 2006   466_557512      JaccardDiss  3.571429e-01  2.501878e-03
      4034 2006   466_557512 MorisitaHornDiss  5.716175e-02 -1.018956e-03
      4035 2006   466_557512   BrayCurtisDiss  7.891825e-01 -1.361824e-03
      4036 1992   466_557512      JaccardDiss  2.857143e-01  2.501878e-03
      4037 1992   466_557512 MorisitaHornDiss  1.501644e-02 -1.018956e-03
      4038 1992   466_557512   BrayCurtisDiss  5.066667e-01 -1.361824e-03
      4039 1996   466_557512      JaccardDiss  4.285714e-01  2.501878e-03
      4040 1996   466_557512 MorisitaHornDiss  6.730287e-02 -1.018956e-03
      4041 1996   466_557512   BrayCurtisDiss  4.465812e-01 -1.361824e-03
      4042 2001   466_557512      JaccardDiss  4.666667e-01  2.501878e-03
      4043 2001   466_557512 MorisitaHornDiss  2.308199e-02 -1.018956e-03
      4044 2001   466_557512   BrayCurtisDiss  2.674762e-01 -1.361824e-03
      4045 2003   466_557512      JaccardDiss  4.375000e-01  2.501878e-03
      4046 2003   466_557512 MorisitaHornDiss  7.450242e-02 -1.018956e-03
      4047 2003   466_557512   BrayCurtisDiss  2.395754e-01 -1.361824e-03
      4048 2007   466_557512      JaccardDiss  4.666667e-01  2.501878e-03
      4049 2007   466_557512 MorisitaHornDiss  3.249052e-02 -1.018956e-03
      4050 2007   466_557512   BrayCurtisDiss  1.799228e-01 -1.361824e-03
      4051 1999   466_557512      JaccardDiss  3.571429e-01  2.501878e-03
      4052 1999   466_557512 MorisitaHornDiss  2.129865e-01 -1.018956e-03
      4053 1999   466_557512   BrayCurtisDiss  6.384819e-01 -1.361824e-03
      4054 1993   466_557512      JaccardDiss  3.076923e-01  2.501878e-03
      4055 1993   466_557512 MorisitaHornDiss  2.800798e-01 -1.018956e-03
      4056 1993   466_557512   BrayCurtisDiss  7.760851e-01 -1.361824e-03
      4057 1994   466_557512      JaccardDiss  4.615385e-01  2.501878e-03
      4058 1994   466_557512 MorisitaHornDiss  3.205815e-02 -1.018956e-03
      4059 1994   466_557512   BrayCurtisDiss  6.717050e-01 -1.361824e-03
      4060 1995   466_557512      JaccardDiss  3.846154e-01  2.501878e-03
      4061 1995   466_557512 MorisitaHornDiss  2.158450e-02 -1.018956e-03
      4062 1995   466_557512   BrayCurtisDiss  3.277058e-01 -1.361824e-03
      4063 1997   466_557512      JaccardDiss  4.117647e-01  2.501878e-03
      4064 1997   466_557512 MorisitaHornDiss  1.579619e-01 -1.018956e-03
      4065 1997   466_557512   BrayCurtisDiss  4.806100e-01 -1.361824e-03
      4066 1988   466_554599      JaccardDiss  2.666667e-01  2.045639e-04
      4067 1988   466_554599 MorisitaHornDiss  4.887330e-01 -1.024306e-02
      4068 1988   466_554599   BrayCurtisDiss  5.937262e-01 -6.092638e-03
      4069 1995   466_554599      JaccardDiss  4.000000e-01  2.045639e-04
      4070 1995   466_554599 MorisitaHornDiss  7.512581e-02 -1.024306e-02
      4071 1995   466_554599   BrayCurtisDiss  6.853253e-01 -6.092638e-03
      4072 2007   466_554599      JaccardDiss  3.076923e-01  2.045639e-04
      4073 2007   466_554599 MorisitaHornDiss  2.148584e-02 -1.024306e-02
      4074 2007   466_554599   BrayCurtisDiss  3.540075e-01 -6.092638e-03
      4075 1989   466_554599      JaccardDiss  3.076923e-01  2.045639e-04
      4076 1989   466_554599 MorisitaHornDiss  1.852045e-03 -1.024306e-02
      4077 1989   466_554599   BrayCurtisDiss  2.801487e-01 -6.092638e-03
      4078 1991   466_554599      JaccardDiss  4.285714e-01  2.045639e-04
      4079 1991   466_554599 MorisitaHornDiss  2.191163e-02 -1.024306e-02
      4080 1991   466_554599   BrayCurtisDiss  2.013823e-01 -6.092638e-03
      4081 1994   466_554599      JaccardDiss  5.000000e-01  2.045639e-04
      4082 1994   466_554599 MorisitaHornDiss  4.198523e-02 -1.024306e-02
      4083 1994   466_554599   BrayCurtisDiss  7.105923e-01 -6.092638e-03
      4084 2008   466_554599      JaccardDiss  4.615385e-01  2.045639e-04
      4085 2008   466_554599 MorisitaHornDiss  3.714626e-03 -1.024306e-02
      4086 2008   466_554599   BrayCurtisDiss  3.849516e-01 -6.092638e-03
      4087 1992   466_554599      JaccardDiss  4.285714e-01  2.045639e-04
      4088 1992   466_554599 MorisitaHornDiss  5.605614e-03 -1.024306e-02
      4089 1992   466_554599   BrayCurtisDiss  6.382997e-01 -6.092638e-03
      4090 1996   466_554599      JaccardDiss  3.076923e-01  2.045639e-04
      4091 1996   466_554599 MorisitaHornDiss  3.362931e-02 -1.024306e-02
      4092 1996   466_554599   BrayCurtisDiss  1.965911e-01 -6.092638e-03
      4093 1997   466_554599      JaccardDiss  3.846154e-01  2.045639e-04
      4094 1997   466_554599 MorisitaHornDiss  1.177861e-01 -1.024306e-02
      4095 1997   466_554599   BrayCurtisDiss  4.176277e-01 -6.092638e-03
      4096 2001   466_554599      JaccardDiss  3.571429e-01  2.045639e-04
      4097 2001   466_554599 MorisitaHornDiss  3.085795e-03 -1.024306e-02
      4098 2001   466_554599   BrayCurtisDiss  6.260870e-01 -6.092638e-03
      4099 1990   466_554599      JaccardDiss  5.000000e-01  2.045639e-04
      4100 1990   466_554599 MorisitaHornDiss  2.534712e-01 -1.024306e-02
      4101 1990   466_554599   BrayCurtisDiss  7.646889e-01 -6.092638e-03
      4102 1988   466_553872      JaccardDiss  4.666667e-01  6.733826e-03
      4103 1988   466_553872 MorisitaHornDiss  7.613346e-02 -1.920963e-02
      4104 1988   466_553872   BrayCurtisDiss  2.616712e-01 -3.632217e-03
      4105 1994   466_553872      JaccardDiss  3.333333e-01  6.733826e-03
      4106 1994   466_553872 MorisitaHornDiss  2.590469e-03 -1.920963e-02
      4107 1994   466_553872   BrayCurtisDiss  3.393039e-01 -3.632217e-03
      4108 2001   466_553872      JaccardDiss  3.333333e-01  6.733826e-03
      4109 2001   466_553872 MorisitaHornDiss  2.908693e-03 -1.920963e-02
      4110 2001   466_553872   BrayCurtisDiss  3.669647e-01 -3.632217e-03
      4111 2002   466_553872      JaccardDiss  5.000000e-01  6.733826e-03
      4112 2002   466_553872 MorisitaHornDiss  1.888233e-03 -1.920963e-02
      4113 2002   466_553872   BrayCurtisDiss  2.561587e-01 -3.632217e-03
      4114 1986   466_553872      JaccardDiss  2.727273e-01  6.733826e-03
      4115 1986   466_553872 MorisitaHornDiss  5.464248e-01 -1.920963e-02
      4116 1986   466_553872   BrayCurtisDiss  5.559589e-01 -3.632217e-03
      4117 1990   466_553872      JaccardDiss  1.818182e-01  6.733826e-03
      4118 1990   466_553872 MorisitaHornDiss  2.385968e-03 -1.920963e-02
      4119 1990   466_553872   BrayCurtisDiss  2.367265e-01 -3.632217e-03
      4120 1993   466_553872      JaccardDiss  1.818182e-01  6.733826e-03
      4121 1993   466_553872 MorisitaHornDiss  2.656220e-02 -1.920963e-02
      4122 1993   466_553872   BrayCurtisDiss  1.676859e-01 -3.632217e-03
      4123 1996   466_553872      JaccardDiss  2.500000e-01  6.733826e-03
      4124 1996   466_553872 MorisitaHornDiss  7.940723e-02 -1.920963e-02
      4125 1996   466_553872   BrayCurtisDiss  4.977901e-01 -3.632217e-03
      4126 1989   466_549505      JaccardDiss  2.307692e-01 -4.589679e-04
      4127 1989   466_549505 MorisitaHornDiss  6.521696e-02  9.191012e-04
      4128 1989   466_549505   BrayCurtisDiss  1.871658e-01  2.397324e-02
      4129 1996   466_549505      JaccardDiss  1.666667e-01 -4.589679e-04
      4130 1996   466_549505 MorisitaHornDiss  2.336005e-01  9.191012e-04
      4131 1996   466_549505   BrayCurtisDiss  6.485680e-01  2.397324e-02
      4132 1997   466_549505      JaccardDiss  2.307692e-01 -4.589679e-04
      4133 1997   466_549505 MorisitaHornDiss  8.056362e-01  9.191012e-04
      4134 1997   466_549505   BrayCurtisDiss  9.167702e-01  2.397324e-02
      4135 2007   466_549505      JaccardDiss  2.500000e-01 -4.589679e-04
      4136 2007   466_549505 MorisitaHornDiss  4.361856e-03  9.191012e-04
      4137 2007   466_549505   BrayCurtisDiss  4.723941e-01  2.397324e-02
      4138 1994   466_549505      JaccardDiss  1.666667e-01 -4.589679e-04
      4139 1994   466_549505 MorisitaHornDiss  9.486045e-03  9.191012e-04
      4140 1994   466_549505   BrayCurtisDiss  9.738460e-02  2.397324e-02
      4141 1993   466_549505      JaccardDiss  3.571429e-01 -4.589679e-04
      4142 1993   466_549505 MorisitaHornDiss  7.877680e-02  9.191012e-04
      4143 1993   466_549505   BrayCurtisDiss  1.827495e-01  2.397324e-02
      4144 1995   466_549505      JaccardDiss  3.333333e-01 -4.589679e-04
      4145 1995   466_549505 MorisitaHornDiss  7.289097e-01  9.191012e-04
      4146 1995   466_549505   BrayCurtisDiss  8.265388e-01  2.397324e-02
      4147 1999   466_549505      JaccardDiss  3.076923e-01 -4.589679e-04
      4148 1999   466_549505 MorisitaHornDiss  9.771025e-03  9.191012e-04
      4149 1999   466_549505   BrayCurtisDiss  8.389589e-01  2.397324e-02
      4150 1990   466_549505      JaccardDiss  2.500000e-01 -4.589679e-04
      4151 1990   466_549505 MorisitaHornDiss  1.796409e-02  9.191012e-04
      4152 1990   466_549505   BrayCurtisDiss  2.661290e-01  2.397324e-02
      4153 1992   466_549505      JaccardDiss  2.727273e-01 -4.589679e-04
      4154 1992   466_549505 MorisitaHornDiss  5.478318e-03  9.191012e-04
      4155 1992   466_549505   BrayCurtisDiss  4.470914e-01  2.397324e-02
      4156 2001   466_549505      JaccardDiss  2.307692e-01 -4.589679e-04
      4157 2001   466_549505 MorisitaHornDiss  7.614576e-02  9.191012e-04
      4158 2001   466_549505   BrayCurtisDiss  5.272559e-01  2.397324e-02
      4159 1989   466_551687      JaccardDiss  1.666667e-01 -9.879219e-04
      4160 1989   466_551687 MorisitaHornDiss  6.488580e-01  4.089065e-03
      4161 1989   466_551687   BrayCurtisDiss  9.677897e-01  5.908842e-03
      4162 1997   466_551687      JaccardDiss  4.666667e-01 -9.879219e-04
      4163 1997   466_551687 MorisitaHornDiss  9.728253e-01  4.089065e-03
      4164 1997   466_551687   BrayCurtisDiss  9.701493e-01  5.908842e-03
      4165 2007   466_551687      JaccardDiss  2.500000e-01 -9.879219e-04
      4166 2007   466_551687 MorisitaHornDiss  4.733921e-01  4.089065e-03
      4167 2007   466_551687   BrayCurtisDiss  9.182288e-01  5.908842e-03
      4168 2001   466_551687      JaccardDiss  3.571429e-01 -9.879219e-04
      4169 2001   466_551687 MorisitaHornDiss  3.768345e-01  4.089065e-03
      4170 2001   466_551687   BrayCurtisDiss  9.320489e-01  5.908842e-03
      4171 2006   466_551687      JaccardDiss  9.090909e-02 -9.879219e-04
      4172 2006   466_551687 MorisitaHornDiss  2.239645e-01  4.089065e-03
      4173 2006   466_551687   BrayCurtisDiss  9.161192e-01  5.908842e-03
      4174 1988   466_551687      JaccardDiss  2.500000e-01 -9.879219e-04
      4175 1988   466_551687 MorisitaHornDiss  1.002206e-02  4.089065e-03
      4176 1988   466_551687   BrayCurtisDiss  6.340091e-01  5.908842e-03
      4177 1992   466_551687      JaccardDiss  1.818182e-01 -9.879219e-04
      4178 1992   466_551687 MorisitaHornDiss  4.826364e-02  4.089065e-03
      4179 1992   466_551687   BrayCurtisDiss  8.957755e-01  5.908842e-03
      4180 1993   466_551687      JaccardDiss  2.727273e-01 -9.879219e-04
      4181 1993   466_551687 MorisitaHornDiss  3.953427e-01  4.089065e-03
      4182 1993   466_551687   BrayCurtisDiss  9.126788e-01  5.908842e-03
      4183 1995   466_551687      JaccardDiss  4.666667e-01 -9.879219e-04
      4184 1995   466_551687 MorisitaHornDiss  9.220163e-01  4.089065e-03
      4185 1995   466_551687   BrayCurtisDiss  8.845612e-01  5.908842e-03
      4186 1989   466_550229      JaccardDiss  2.666667e-01  4.740399e-03
      4187 1989   466_550229 MorisitaHornDiss  1.296316e-01 -1.046224e-02
      4188 1989   466_550229   BrayCurtisDiss  4.711864e-01 -1.007217e-02
      4189 1993   466_550229      JaccardDiss  2.142857e-01  4.740399e-03
      4190 1993   466_550229 MorisitaHornDiss  6.011498e-01 -1.046224e-02
      4191 1993   466_550229   BrayCurtisDiss  6.307838e-01 -1.007217e-02
      4192 1996   466_550229      JaccardDiss  3.846154e-01  4.740399e-03
      4193 1996   466_550229 MorisitaHornDiss  6.158924e-01 -1.046224e-02
      4194 1996   466_550229   BrayCurtisDiss  6.312233e-01 -1.007217e-02
      4195 2003   466_550229      JaccardDiss  5.384615e-01  4.740399e-03
      4196 2003   466_550229 MorisitaHornDiss  8.392827e-01 -1.046224e-02
      4197 2003   466_550229   BrayCurtisDiss  9.078668e-01 -1.007217e-02
      4198 2007   466_550229      JaccardDiss  3.076923e-01  4.740399e-03
      4199 2007   466_550229 MorisitaHornDiss  1.229010e-02 -1.046224e-02
      4200 2007   466_550229   BrayCurtisDiss  3.133179e-01 -1.007217e-02
      4201 1992   466_550229      JaccardDiss  3.076923e-01  4.740399e-03
      4202 1992   466_550229 MorisitaHornDiss  6.879612e-01 -1.046224e-02
      4203 1992   466_550229   BrayCurtisDiss  7.121867e-01 -1.007217e-02
      4204 2005   466_550229      JaccardDiss  4.166667e-01  4.740399e-03
      4205 2005   466_550229 MorisitaHornDiss  9.363364e-02 -1.046224e-02
      4206 2005   466_550229   BrayCurtisDiss  3.736988e-01 -1.007217e-02
      4207 2001   466_550229      JaccardDiss  3.076923e-01  4.740399e-03
      4208 2001   466_550229 MorisitaHornDiss  6.485843e-01 -1.046224e-02
      4209 2001   466_550229   BrayCurtisDiss  6.660200e-01 -1.007217e-02
      4210 2006   466_550229      JaccardDiss  9.090909e-02  4.740399e-03
      4211 2006   466_550229 MorisitaHornDiss  5.069080e-03 -1.046224e-02
      4212 2006   466_550229   BrayCurtisDiss  1.497041e-01 -1.007217e-02
      4213 1990   466_550229      JaccardDiss  9.090909e-02  4.740399e-03
      4214 1990   466_550229 MorisitaHornDiss  6.878345e-02 -1.046224e-02
      4215 1990   466_550229   BrayCurtisDiss  3.122137e-01 -1.007217e-02
      4216 1997   466_550229      JaccardDiss  3.636364e-01  4.740399e-03
      4217 1997   466_550229 MorisitaHornDiss  6.305674e-01 -1.046224e-02
      4218 1997   466_550229   BrayCurtisDiss  6.886503e-01 -1.007217e-02
      4219 2008   466_550229      JaccardDiss  2.941176e-01  4.740399e-03
      4220 2008   466_550229 MorisitaHornDiss  2.424412e-01 -1.046224e-02
      4221 2008   466_550229   BrayCurtisDiss  3.288647e-01 -1.007217e-02
      4222 1989   466_549503      JaccardDiss  1.538462e-01  7.794353e-04
      4223 1989   466_549503 MorisitaHornDiss  1.779228e-01  3.286505e-03
      4224 1989   466_549503   BrayCurtisDiss  3.637062e-01  4.011155e-03
      4225 1990   466_549503      JaccardDiss  3.076923e-01  7.794353e-04
      4226 1990   466_549503 MorisitaHornDiss  3.033820e-02  3.286505e-03
      4227 1990   466_549503   BrayCurtisDiss  4.447874e-01  4.011155e-03
      4228 1994   466_549503      JaccardDiss  2.500000e-01  7.794353e-04
      4229 1994   466_549503 MorisitaHornDiss  4.085993e-01  3.286505e-03
      4230 1994   466_549503   BrayCurtisDiss  5.734834e-01  4.011155e-03
      4231 2001   466_549503      JaccardDiss  2.500000e-01  7.794353e-04
      4232 2001   466_549503 MorisitaHornDiss  1.936984e-02  3.286505e-03
      4233 2001   466_549503   BrayCurtisDiss  1.590066e-01  4.011155e-03
      4234 2003   466_549503      JaccardDiss  4.166667e-01  7.794353e-04
      4235 2003   466_549503 MorisitaHornDiss  3.080249e-02  3.286505e-03
      4236 2003   466_549503   BrayCurtisDiss  4.351997e-01  4.011155e-03
      4237 1993   466_549503      JaccardDiss  5.000000e-01  7.794353e-04
      4238 1993   466_549503 MorisitaHornDiss  2.559437e-01  3.286505e-03
      4239 1993   466_549503   BrayCurtisDiss  5.056146e-01  4.011155e-03
      4240 1996   466_549503      JaccardDiss  3.846154e-01  7.794353e-04
      4241 1996   466_549503 MorisitaHornDiss  9.572045e-02  3.286505e-03
      4242 1996   466_549503   BrayCurtisDiss  3.002248e-01  4.011155e-03
      4243 1991   466_549503      JaccardDiss  3.846154e-01  7.794353e-04
      4244 1991   466_549503 MorisitaHornDiss  5.514247e-01  3.286505e-03
      4245 1991   466_549503   BrayCurtisDiss  5.905303e-01  4.011155e-03
      4246 1999   466_549503      JaccardDiss  4.166667e-01  7.794353e-04
      4247 1999   466_549503 MorisitaHornDiss  1.464363e-01  3.286505e-03
      4248 1999   466_549503   BrayCurtisDiss  5.268405e-01  4.011155e-03
      4249 2005   466_549503      JaccardDiss  2.500000e-01  7.794353e-04
      4250 2005   466_549503 MorisitaHornDiss  1.081726e-02  3.286505e-03
      4251 2005   466_549503   BrayCurtisDiss  5.944821e-01  4.011155e-03
      4252 1992   466_549503      JaccardDiss  3.846154e-01  7.794353e-04
      4253 1992   466_549503 MorisitaHornDiss  2.497408e-02  3.286505e-03
      4254 1992   466_549503   BrayCurtisDiss  6.982861e-01  4.011155e-03
      4255 1995   466_549503      JaccardDiss  3.636364e-01  7.794353e-04
      4256 1995   466_549503 MorisitaHornDiss  2.774410e-02  3.286505e-03
      4257 1995   466_549503   BrayCurtisDiss  3.281030e-01  4.011155e-03
      4258 1997   466_549503      JaccardDiss  4.615385e-01  7.794353e-04
      4259 1997   466_549503 MorisitaHornDiss  8.448807e-01  3.286505e-03
      4260 1997   466_549503   BrayCurtisDiss  9.111269e-01  4.011155e-03
      4261 2007   466_549503      JaccardDiss  4.166667e-01  7.794353e-04
      4262 2007   466_549503 MorisitaHornDiss  8.139490e-01  3.286505e-03
      4263 2007   466_549503   BrayCurtisDiss  7.687296e-01  4.011155e-03
      4264 2008   466_549503      JaccardDiss  2.857143e-01  7.794353e-04
      4265 2008   466_549503 MorisitaHornDiss  1.519434e-01  3.286505e-03
      4266 2008   466_549503   BrayCurtisDiss  5.242958e-01  4.011155e-03
      4267 1989   466_553873      JaccardDiss  2.307692e-01  3.543041e-03
      4268 1989   466_553873 MorisitaHornDiss  4.682924e-03  1.166123e-02
      4269 1989   466_553873   BrayCurtisDiss  1.609472e-01  1.392752e-02
      4270 1990   466_553873      JaccardDiss  3.846154e-01  3.543041e-03
      4271 1990   466_553873 MorisitaHornDiss  1.831933e-03  1.166123e-02
      4272 1990   466_553873   BrayCurtisDiss  2.526489e-01  1.392752e-02
      4273 1991   466_553873      JaccardDiss  4.000000e-01  3.543041e-03
      4274 1991   466_553873 MorisitaHornDiss  1.777708e-01  1.166123e-02
      4275 1991   466_553873   BrayCurtisDiss  4.989196e-01  1.392752e-02
      4276 2006   466_553873      JaccardDiss  5.000000e-01  3.543041e-03
      4277 2006   466_553873 MorisitaHornDiss  1.477024e-03  1.166123e-02
      4278 2006   466_553873   BrayCurtisDiss  5.212423e-01  1.392752e-02
      4279 2003   466_553873      JaccardDiss  6.153846e-01  3.543041e-03
      4280 2003   466_553873 MorisitaHornDiss  1.878993e-02  1.166123e-02
      4281 2003   466_553873   BrayCurtisDiss  3.776569e-01  1.392752e-02
      4282 2005   466_553873      JaccardDiss  3.636364e-01  3.543041e-03
      4283 2005   466_553873 MorisitaHornDiss  4.901974e-02  1.166123e-02
      4284 2005   466_553873   BrayCurtisDiss  4.631316e-01  1.392752e-02
      4285 1995   466_553873      JaccardDiss  3.636364e-01  3.543041e-03
      4286 1995   466_553873 MorisitaHornDiss  1.504996e-03  1.166123e-02
      4287 1995   466_553873   BrayCurtisDiss  5.680075e-01  1.392752e-02
      4288 1997   466_553873      JaccardDiss  3.636364e-01  3.543041e-03
      4289 1997   466_553873 MorisitaHornDiss  2.377393e-01  1.166123e-02
      4290 1997   466_553873   BrayCurtisDiss  5.141654e-01  1.392752e-02
      4291 2007   466_553873      JaccardDiss  2.000000e-01  3.543041e-03
      4292 2007   466_553873 MorisitaHornDiss  9.548417e-01  1.166123e-02
      4293 2007   466_553873   BrayCurtisDiss  9.215799e-01  1.392752e-02
      4294 2008   466_553873      JaccardDiss  4.000000e-01  3.543041e-03
      4295 2008   466_553873 MorisitaHornDiss  5.743649e-03  1.166123e-02
      4296 2008   466_553873   BrayCurtisDiss  3.828851e-01  1.392752e-02
      4297 1991   466_550233      JaccardDiss  1.666667e-01 -8.051593e-03
      4298 1991   466_550233 MorisitaHornDiss  7.200635e-02 -1.017695e-02
      4299 1991   466_550233   BrayCurtisDiss  1.778225e-01 -1.263522e-02
      4300 1993   466_550233      JaccardDiss  5.714286e-01 -8.051593e-03
      4301 1993   466_550233 MorisitaHornDiss  2.133986e-03 -1.017695e-02
      4302 1993   466_550233   BrayCurtisDiss  4.326923e-01 -1.263522e-02
      4303 1986   466_550233      JaccardDiss  4.166667e-01 -8.051593e-03
      4304 1986   466_550233 MorisitaHornDiss  3.247643e-01 -1.017695e-02
      4305 1986   466_550233   BrayCurtisDiss  3.407353e-01 -1.263522e-02
      4306 1995   466_550233      JaccardDiss  3.846154e-01 -8.051593e-03
      4307 1995   466_550233 MorisitaHornDiss  1.125668e-02 -1.017695e-02
      4308 1995   466_550233   BrayCurtisDiss  6.271292e-01 -1.263522e-02
      4309 2006   466_550233      JaccardDiss  9.090909e-02 -8.051593e-03
      4310 2006   466_550233 MorisitaHornDiss  2.954927e-04 -1.017695e-02
      4311 2006   466_550233   BrayCurtisDiss  2.338076e-02 -1.263522e-02
      4312 1989   466_550233      JaccardDiss  2.500000e-01 -8.051593e-03
      4313 1989   466_550233 MorisitaHornDiss  1.865566e-04 -1.017695e-02
      4314 1989   466_550233   BrayCurtisDiss  4.942057e-01 -1.263522e-02
      4315 1990   466_550233      JaccardDiss  1.818182e-01 -8.051593e-03
      4316 1990   466_550233 MorisitaHornDiss  8.764026e-05 -1.017695e-02
      4317 1990   466_550233   BrayCurtisDiss  1.582877e-01 -1.263522e-02
      4318 1992   466_550233      JaccardDiss  1.818182e-01 -8.051593e-03
      4319 1992   466_550233 MorisitaHornDiss  3.402811e-01 -1.017695e-02
      4320 1992   466_550233   BrayCurtisDiss  4.674225e-01 -1.263522e-02
      4321 1994   466_550233      JaccardDiss  6.666667e-01 -8.051593e-03
      4322 1994   466_550233 MorisitaHornDiss  6.769391e-02 -1.017695e-02
      4323 1994   466_550233   BrayCurtisDiss  5.435795e-01 -1.263522e-02
      4324 1989   466_556056      JaccardDiss  2.666667e-01  4.191409e-03
      4325 1989   466_556056 MorisitaHornDiss  1.609294e-03 -9.839310e-03
      4326 1989   466_556056   BrayCurtisDiss  4.884237e-01 -8.450760e-03
      4327 1993   466_556056      JaccardDiss  4.117647e-01  4.191409e-03
      4328 1993   466_556056 MorisitaHornDiss  6.084900e-01 -9.839310e-03
      4329 1993   466_556056   BrayCurtisDiss  6.582700e-01 -8.450760e-03
      4330 2008   466_556056      JaccardDiss  2.857143e-01  4.191409e-03
      4331 2008   466_556056 MorisitaHornDiss  5.941025e-03 -9.839310e-03
      4332 2008   466_556056   BrayCurtisDiss  1.039668e-01 -8.450760e-03
      4333 1990   466_556056      JaccardDiss  3.750000e-01  4.191409e-03
      4334 1990   466_556056 MorisitaHornDiss  9.266926e-02 -9.839310e-03
      4335 1990   466_556056   BrayCurtisDiss  3.239700e-01 -8.450760e-03
      4336 1994   466_556056      JaccardDiss  4.117647e-01  4.191409e-03
      4337 1994   466_556056 MorisitaHornDiss  5.988159e-03 -9.839310e-03
      4338 1994   466_556056   BrayCurtisDiss  3.695078e-01 -8.450760e-03
      4339 1996   466_556056      JaccardDiss  3.076923e-01  4.191409e-03
      4340 1996   466_556056 MorisitaHornDiss  1.261086e-02 -9.839310e-03
      4341 1996   466_556056   BrayCurtisDiss  1.862813e-01 -8.450760e-03
      4342 1997   466_556056      JaccardDiss  2.857143e-01  4.191409e-03
      4343 1997   466_556056 MorisitaHornDiss  2.885975e-01 -9.839310e-03
      4344 1997   466_556056   BrayCurtisDiss  5.884881e-01 -8.450760e-03
      4345 1999   466_556056      JaccardDiss  4.285714e-01  4.191409e-03
      4346 1999   466_556056 MorisitaHornDiss  2.747662e-01 -9.839310e-03
      4347 1999   466_556056   BrayCurtisDiss  6.054044e-01 -8.450760e-03
      4348 2001   466_556056      JaccardDiss  4.375000e-01  4.191409e-03
      4349 2001   466_556056 MorisitaHornDiss  2.208354e-02 -9.839310e-03
      4350 2001   466_556056   BrayCurtisDiss  5.625342e-01 -8.450760e-03
      4351 2006   466_556056      JaccardDiss  5.263158e-01  4.191409e-03
      4352 2006   466_556056 MorisitaHornDiss  3.823411e-01 -9.839310e-03
      4353 2006   466_556056   BrayCurtisDiss  6.527120e-01 -8.450760e-03
      4354 2007   466_556056      JaccardDiss  4.705882e-01  4.191409e-03
      4355 2007   466_556056 MorisitaHornDiss  1.536164e-01 -9.839310e-03
      4356 2007   466_556056   BrayCurtisDiss  4.229439e-01 -8.450760e-03
      4357 2005   466_556056      JaccardDiss  4.285714e-01  4.191409e-03
      4358 2005   466_556056 MorisitaHornDiss  6.646778e-03 -9.839310e-03
      4359 2005   466_556056   BrayCurtisDiss  1.989738e-01 -8.450760e-03
      4360 1991   466_556056      JaccardDiss  3.846154e-01  4.191409e-03
      4361 1991   466_556056 MorisitaHornDiss  5.535939e-01 -9.839310e-03
      4362 1991   466_556056   BrayCurtisDiss  5.499955e-01 -8.450760e-03
      4363 1992   466_556056      JaccardDiss  4.117647e-01  4.191409e-03
      4364 1992   466_556056 MorisitaHornDiss  5.706472e-01 -9.839310e-03
      4365 1992   466_556056   BrayCurtisDiss  6.491347e-01 -8.450760e-03
      4366 1989   466_556058      JaccardDiss  1.666667e-01  6.989608e-03
      4367 1989   466_556058 MorisitaHornDiss  7.987133e-03  6.501669e-03
      4368 1989   466_556058   BrayCurtisDiss  3.774370e-01  1.903990e-02
      4369 1991   466_556058      JaccardDiss  3.571429e-01  6.989608e-03
      4370 1991   466_556058 MorisitaHornDiss  1.605886e-01  6.501669e-03
      4371 1991   466_556058   BrayCurtisDiss  3.274854e-01  1.903990e-02
      4372 2006   466_556058      JaccardDiss  5.625000e-01  6.989608e-03
      4373 2006   466_556058 MorisitaHornDiss  2.126017e-03  6.501669e-03
      4374 2006   466_556058   BrayCurtisDiss  3.833873e-01  1.903990e-02
      4375 2005   466_556058      JaccardDiss  3.333333e-01  6.989608e-03
      4376 2005   466_556058 MorisitaHornDiss  3.477517e-01  6.501669e-03
      4377 2005   466_556058   BrayCurtisDiss  8.406820e-01  1.903990e-02
      4378 2008   466_556058      JaccardDiss  5.333333e-01  6.989608e-03
      4379 2008   466_556058 MorisitaHornDiss  2.804027e-01  6.501669e-03
      4380 2008   466_556058   BrayCurtisDiss  8.075014e-01  1.903990e-02
      4381 2007   466_556058      JaccardDiss  3.333333e-01  6.989608e-03
      4382 2007   466_556058 MorisitaHornDiss  3.504949e-03  6.501669e-03
      4383 2007   466_556058   BrayCurtisDiss  4.537835e-01  1.903990e-02
      4384 1987   466_556058      JaccardDiss  9.090909e-02  6.989608e-03
      4385 1987   466_556058 MorisitaHornDiss  3.408782e-03  6.501669e-03
      4386 1987   466_556058   BrayCurtisDiss  1.219366e-01  1.903990e-02
      4387 1988   466_556058      JaccardDiss  3.333333e-01  6.989608e-03
      4388 1988   466_556058 MorisitaHornDiss  9.370369e-03  6.501669e-03
      4389 1988   466_556058   BrayCurtisDiss  3.779924e-01  1.903990e-02
      4390 1994   466_556058      JaccardDiss  3.333333e-01  6.989608e-03
      4391 1994   466_556058 MorisitaHornDiss  8.003335e-03  6.501669e-03
      4392 1994   466_556058   BrayCurtisDiss  2.346013e-01  1.903990e-02
      4393 1986   466_556058      JaccardDiss  5.000000e-01  6.989608e-03
      4394 1986   466_556058 MorisitaHornDiss  9.226674e-03  6.501669e-03
      4395 1986   466_556058   BrayCurtisDiss  1.402484e-01  1.903990e-02
      4396 1990   466_556058      JaccardDiss  4.666667e-01  6.989608e-03
      4397 1990   466_556058 MorisitaHornDiss  1.155769e-01  6.501669e-03
      4398 1990   466_556058   BrayCurtisDiss  4.279195e-01  1.903990e-02
      4399 1989   466_556059      JaccardDiss  3.846154e-01  5.505845e-03
      4400 1989   466_556059 MorisitaHornDiss  9.915053e-02 -8.091482e-04
      4401 1989   466_556059   BrayCurtisDiss  9.466650e-01 -1.812052e-02
      4402 1993   466_556059      JaccardDiss  4.666667e-01  5.505845e-03
      4403 1993   466_556059 MorisitaHornDiss  9.734884e-02 -8.091482e-04
      4404 1993   466_556059   BrayCurtisDiss  7.540984e-01 -1.812052e-02
      4405 2002   466_556059      JaccardDiss  4.285714e-01  5.505845e-03
      4406 2002   466_556059 MorisitaHornDiss  4.167075e-02 -8.091482e-04
      4407 2002   466_556059   BrayCurtisDiss  1.480996e-01 -1.812052e-02
      4408 1991   466_556059      JaccardDiss  5.882353e-01  5.505845e-03
      4409 1991   466_556059 MorisitaHornDiss  1.677635e-01 -8.091482e-04
      4410 1991   466_556059   BrayCurtisDiss  3.304158e-01 -1.812052e-02
      4411 1999   466_556059      JaccardDiss  5.294118e-01  5.505845e-03
      4412 1999   466_556059 MorisitaHornDiss  6.356692e-02 -8.091482e-04
      4413 1999   466_556059   BrayCurtisDiss  6.099250e-01 -1.812052e-02
      4414 2006   466_556059      JaccardDiss  5.000000e-01  5.505845e-03
      4415 2006   466_556059 MorisitaHornDiss  3.850293e-02 -8.091482e-04
      4416 2006   466_556059   BrayCurtisDiss  5.504994e-01 -1.812052e-02
      4417 1988   466_556059      JaccardDiss  4.285714e-01  5.505845e-03
      4418 1988   466_556059 MorisitaHornDiss  9.774571e-02 -8.091482e-04
      4419 1988   466_556059   BrayCurtisDiss  7.355183e-01 -1.812052e-02
      4420 1990   466_556059      JaccardDiss  4.285714e-01  5.505845e-03
      4421 1990   466_556059 MorisitaHornDiss  1.268238e-01 -8.091482e-04
      4422 1990   466_556059   BrayCurtisDiss  9.186129e-01 -1.812052e-02
      4423 1992   466_556059      JaccardDiss  5.333333e-01  5.505845e-03
      4424 1992   466_556059 MorisitaHornDiss  3.048574e-02 -8.091482e-04
      4425 1992   466_556059   BrayCurtisDiss  4.624113e-01 -1.812052e-02
      4426 2001   466_556059      JaccardDiss  5.882353e-01  5.505845e-03
      4427 2001   466_556059 MorisitaHornDiss  6.007421e-01 -8.091482e-04
      4428 2001   466_556059   BrayCurtisDiss  6.829268e-01 -1.812052e-02
      4429 2007   466_556059      JaccardDiss  4.000000e-01  5.505845e-03
      4430 2007   466_556059 MorisitaHornDiss  6.229086e-02 -8.091482e-04
      4431 2007   466_556059   BrayCurtisDiss  2.181070e-01 -1.812052e-02
      4432 2008   466_556059      JaccardDiss  5.000000e-01  5.505845e-03
      4433 2008   466_556059 MorisitaHornDiss  7.441794e-02 -8.091482e-04
      4434 2008   466_556059   BrayCurtisDiss  5.133240e-01 -1.812052e-02
      4435 2003   466_556059      JaccardDiss  5.000000e-01  5.505845e-03
      4436 2003   466_556059 MorisitaHornDiss  6.405743e-02 -8.091482e-04
      4437 2003   466_556059   BrayCurtisDiss  4.722422e-01 -1.812052e-02
      4438 1994   466_556059      JaccardDiss  3.846154e-01  5.505845e-03
      4439 1994   466_556059 MorisitaHornDiss  8.420286e-01 -8.091482e-04
      4440 1994   466_556059   BrayCurtisDiss  9.198638e-01 -1.812052e-02
      4441 1995   466_556059      JaccardDiss  4.166667e-01  5.505845e-03
      4442 1995   466_556059 MorisitaHornDiss  9.107349e-02 -8.091482e-04
      4443 1995   466_556059   BrayCurtisDiss  5.927396e-01 -1.812052e-02
      4444 1996   466_556059      JaccardDiss  3.333333e-01  5.505845e-03
      4445 1996   466_556059 MorisitaHornDiss  5.280702e-02 -8.091482e-04
      4446 1996   466_556059   BrayCurtisDiss  4.520548e-01 -1.812052e-02
      4447 1997   466_556059      JaccardDiss  5.714286e-01  5.505845e-03
      4448 1997   466_556059 MorisitaHornDiss  1.266549e-01 -8.091482e-04
      4449 1997   466_556059   BrayCurtisDiss  8.825516e-01 -1.812052e-02
      4450 1986   466_556059      JaccardDiss  1.818182e-01  5.505845e-03
      4451 1986   466_556059 MorisitaHornDiss  1.337923e-03 -8.091482e-04
      4452 1986   466_556059   BrayCurtisDiss  6.939872e-01 -1.812052e-02
      4453 1989   466_553874      JaccardDiss  2.500000e-01  8.143085e-03
      4454 1989   466_553874 MorisitaHornDiss  3.655060e-03  1.128132e-02
      4455 1989   466_553874   BrayCurtisDiss  4.187200e-01  2.332390e-04
      4456 1993   466_553874      JaccardDiss  4.666667e-01  8.143085e-03
      4457 1993   466_553874 MorisitaHornDiss  1.207297e-02  1.128132e-02
      4458 1993   466_553874   BrayCurtisDiss  6.235994e-01  2.332390e-04
      4459 2003   466_553874      JaccardDiss  5.333333e-01  8.143085e-03
      4460 2003   466_553874 MorisitaHornDiss  8.059569e-01  1.128132e-02
      4461 2003   466_553874   BrayCurtisDiss  8.808830e-01  2.332390e-04
      4462 2008   466_553874      JaccardDiss  3.076923e-01  8.143085e-03
      4463 2008   466_553874 MorisitaHornDiss  6.464392e-04  1.128132e-02
      4464 2008   466_553874   BrayCurtisDiss  1.219638e-01  2.332390e-04
      4465 1994   466_553874      JaccardDiss  4.666667e-01  8.143085e-03
      4466 1994   466_553874 MorisitaHornDiss  9.470339e-04  1.128132e-02
      4467 1994   466_553874   BrayCurtisDiss  3.602215e-01  2.332390e-04
      4468 1995   466_553874      JaccardDiss  5.000000e-01  8.143085e-03
      4469 1995   466_553874 MorisitaHornDiss  5.239939e-02  1.128132e-02
      4470 1995   466_553874   BrayCurtisDiss  5.878121e-01  2.332390e-04
      4471 1992   466_553874      JaccardDiss  4.615385e-01  8.143085e-03
      4472 1992   466_553874 MorisitaHornDiss  6.798329e-04  1.128132e-02
      4473 1992   466_553874   BrayCurtisDiss  9.990906e-02  2.332390e-04
      4474 2001   466_553874      JaccardDiss  4.615385e-01  8.143085e-03
      4475 2001   466_553874 MorisitaHornDiss  1.629512e-03  1.128132e-02
      4476 2001   466_553874   BrayCurtisDiss  3.329613e-01  2.332390e-04
      4477 2002   466_553874      JaccardDiss  5.625000e-01  8.143085e-03
      4478 2002   466_553874 MorisitaHornDiss  6.599378e-04  1.128132e-02
      4479 2002   466_553874   BrayCurtisDiss  1.213585e-01  2.332390e-04
      4480 2005   466_553874      JaccardDiss  6.000000e-01  8.143085e-03
      4481 2005   466_553874 MorisitaHornDiss  4.438187e-02  1.128132e-02
      4482 2005   466_553874   BrayCurtisDiss  8.487882e-01  2.332390e-04
      4483 2007   466_553874      JaccardDiss  6.428571e-01  8.143085e-03
      4484 2007   466_553874 MorisitaHornDiss  1.516731e-02  1.128132e-02
      4485 2007   466_553874   BrayCurtisDiss  3.936249e-01  2.332390e-04
      4486 2006   466_553874      JaccardDiss  4.166667e-01  8.143085e-03
      4487 2006   466_553874 MorisitaHornDiss  4.746502e-01  1.128132e-02
      4488 2006   466_553874   BrayCurtisDiss  4.936869e-01  2.332390e-04
      4489 1988   466_553874      JaccardDiss  2.500000e-01  8.143085e-03
      4490 1988   466_553874 MorisitaHornDiss  1.070083e-03  1.128132e-02
      4491 1988   466_553874   BrayCurtisDiss  4.850820e-01  2.332390e-04
      4492 1991   466_553874      JaccardDiss  5.384615e-01  8.143085e-03
      4493 1991   466_553874 MorisitaHornDiss  1.534602e-03  1.128132e-02
      4494 1991   466_553874   BrayCurtisDiss  6.379402e-01  2.332390e-04
      4495 1996   466_553874      JaccardDiss  4.166667e-01  8.143085e-03
      4496 1996   466_553874 MorisitaHornDiss  5.985820e-04  1.128132e-02
      4497 1996   466_553874   BrayCurtisDiss  6.305624e-01  2.332390e-04
      4498 1997   466_553874      JaccardDiss  3.333333e-01  8.143085e-03
      4499 1997   466_553874 MorisitaHornDiss  1.091332e-03  1.128132e-02
      4500 1997   466_553874   BrayCurtisDiss  1.942064e-01  2.332390e-04
      4501 1986   466_553874      JaccardDiss  3.636364e-01  8.143085e-03
      4502 1986   466_553874 MorisitaHornDiss  5.377473e-04  1.128132e-02
      4503 1986   466_553874   BrayCurtisDiss  1.555916e-01  2.332390e-04
      4504 1990   466_553874      JaccardDiss  3.076923e-01  8.143085e-03
      4505 1990   466_553874 MorisitaHornDiss  1.191345e-02  1.128132e-02
      4506 1990   466_553874   BrayCurtisDiss  8.243534e-01  2.332390e-04
      4507 1991   466_552417      JaccardDiss  3.333333e-01  7.538214e-03
      4508 1991   466_552417 MorisitaHornDiss  7.582671e-03 -4.184841e-04
      4509 1991   466_552417   BrayCurtisDiss  2.267099e-01  1.809373e-03
      4510 1992   466_552417      JaccardDiss  3.333333e-01  7.538214e-03
      4511 1992   466_552417 MorisitaHornDiss  1.522304e-01 -4.184841e-04
      4512 1992   466_552417   BrayCurtisDiss  4.156139e-01  1.809373e-03
      4513 1997   466_552417      JaccardDiss  3.750000e-01  7.538214e-03
      4514 1997   466_552417 MorisitaHornDiss  5.432970e-02 -4.184841e-04
      4515 1997   466_552417   BrayCurtisDiss  3.994531e-01  1.809373e-03
      4516 2002   466_552417      JaccardDiss  2.307692e-01  7.538214e-03
      4517 2002   466_552417 MorisitaHornDiss  5.542352e-02 -4.184841e-04
      4518 2002   466_552417   BrayCurtisDiss  4.924662e-01  1.809373e-03
      4519 1996   466_552417      JaccardDiss  3.571429e-01  7.538214e-03
      4520 1996   466_552417 MorisitaHornDiss  5.157548e-02 -4.184841e-04
      4521 1996   466_552417   BrayCurtisDiss  5.075063e-01  1.809373e-03
      4522 2001   466_552417      JaccardDiss  2.857143e-01  7.538214e-03
      4523 2001   466_552417 MorisitaHornDiss  1.405438e-02 -4.184841e-04
      4524 2001   466_552417   BrayCurtisDiss  4.915548e-01  1.809373e-03
      4525 2003   466_552417      JaccardDiss  4.285714e-01  7.538214e-03
      4526 2003   466_552417 MorisitaHornDiss  3.748868e-04 -4.184841e-04
      4527 2003   466_552417   BrayCurtisDiss  4.602731e-01  1.809373e-03
      4528 1999   466_552417      JaccardDiss  5.000000e-01  7.538214e-03
      4529 1999   466_552417 MorisitaHornDiss  9.364157e-01 -4.184841e-04
      4530 1999   466_552417   BrayCurtisDiss  9.185330e-01  1.809373e-03
      4531 2008   466_552417      JaccardDiss  5.000000e-01  7.538214e-03
      4532 2008   466_552417 MorisitaHornDiss  1.107770e-03 -4.184841e-04
      4533 2008   466_552417   BrayCurtisDiss  2.909454e-01  1.809373e-03
      4534 2005   466_552417      JaccardDiss  5.000000e-01  7.538214e-03
      4535 2005   466_552417 MorisitaHornDiss  9.299879e-04 -4.184841e-04
      4536 2005   466_552417   BrayCurtisDiss  2.920607e-01  1.809373e-03
      4537 1986   466_552417      JaccardDiss  2.857143e-01  7.538214e-03
      4538 1986   466_552417 MorisitaHornDiss  5.117162e-03 -4.184841e-04
      4539 1986   466_552417   BrayCurtisDiss  4.444352e-01  1.809373e-03
      4540 1993   466_552417      JaccardDiss  3.846154e-01  7.538214e-03
      4541 1993   466_552417 MorisitaHornDiss  1.184608e-01 -4.184841e-04
      4542 1993   466_552417   BrayCurtisDiss  2.286625e-01  1.809373e-03
      4543 1995   466_552417      JaccardDiss  2.857143e-01  7.538214e-03
      4544 1995   466_552417 MorisitaHornDiss  1.110208e-01 -4.184841e-04
      4545 1995   466_552417   BrayCurtisDiss  4.688694e-01  1.809373e-03
      4546 1991   466_554601      JaccardDiss  2.727273e-01  3.517876e-03
      4547 1991   466_554601 MorisitaHornDiss  7.382661e-03 -7.503771e-03
      4548 1991   466_554601   BrayCurtisDiss  6.144971e-01  4.465410e-04
      4549 1992   466_554601      JaccardDiss  4.615385e-01  3.517876e-03
      4550 1992   466_554601 MorisitaHornDiss  7.951163e-02 -7.503771e-03
      4551 1992   466_554601   BrayCurtisDiss  2.391250e-01  4.465410e-04
      4552 2005   466_554601      JaccardDiss  5.384615e-01  3.517876e-03
      4553 2005   466_554601 MorisitaHornDiss  9.495120e-03 -7.503771e-03
      4554 2005   466_554601   BrayCurtisDiss  2.700922e-01  4.465410e-04
      4555 1996   466_554601      JaccardDiss  5.000000e-01  3.517876e-03
      4556 1996   466_554601 MorisitaHornDiss  2.882210e-02 -7.503771e-03
      4557 1996   466_554601   BrayCurtisDiss  3.742056e-01  4.465410e-04
      4558 2006   466_554601      JaccardDiss  4.444444e-01  3.517876e-03
      4559 2006   466_554601 MorisitaHornDiss  3.856005e-02 -7.503771e-03
      4560 2006   466_554601   BrayCurtisDiss  8.015345e-01  4.465410e-04
      4561 1986   466_554601      JaccardDiss  5.000000e-01  3.517876e-03
      4562 1986   466_554601 MorisitaHornDiss  3.979533e-02 -7.503771e-03
      4563 1986   466_554601   BrayCurtisDiss  5.790409e-01  4.465410e-04
      4564 2003   466_554601      JaccardDiss  4.545455e-01  3.517876e-03
      4565 2003   466_554601 MorisitaHornDiss  2.027507e-02 -7.503771e-03
      4566 2003   466_554601   BrayCurtisDiss  7.218900e-01  4.465410e-04
      4567 1990   466_554601      JaccardDiss  3.636364e-01  3.517876e-03
      4568 1990   466_554601 MorisitaHornDiss  2.771247e-02 -7.503771e-03
      4569 1990   466_554601   BrayCurtisDiss  3.157765e-01  4.465410e-04
      4570 1988   466_554601      JaccardDiss  4.545455e-01  3.517876e-03
      4571 1988   466_554601 MorisitaHornDiss  4.671980e-01 -7.503771e-03
      4572 1988   466_554601   BrayCurtisDiss  8.998667e-01  4.465410e-04
      4573 1994   466_554601      JaccardDiss  3.571429e-01  3.517876e-03
      4574 1994   466_554601 MorisitaHornDiss  9.690729e-02 -7.503771e-03
      4575 1994   466_554601   BrayCurtisDiss  6.475943e-01  4.465410e-04
      4576 1991   466_556784      JaccardDiss  2.307692e-01  3.196803e-02
      4577 1991   466_556784 MorisitaHornDiss  3.998231e-02  2.271581e-03
      4578 1991   466_556784   BrayCurtisDiss  3.193874e-01  4.400392e-02
      4579 1988   466_556784      JaccardDiss  1.538462e-01  3.196803e-02
      4580 1988   466_556784 MorisitaHornDiss  4.198017e-02  2.271581e-03
      4581 1988   466_556784   BrayCurtisDiss  1.968900e-01  4.400392e-02
      4582 1989   466_556784      JaccardDiss  9.090909e-02  3.196803e-02
      4583 1989   466_556784 MorisitaHornDiss  1.886939e-04  2.271581e-03
      4584 1989   466_556784   BrayCurtisDiss  1.933220e-01  4.400392e-02
      4585 1991   466_556055      JaccardDiss  4.666667e-01  9.444121e-04
      4586 1991   466_556055 MorisitaHornDiss  2.591907e-01  2.208803e-02
      4587 1991   466_556055   BrayCurtisDiss  4.370927e-01  9.670032e-03
      4588 2001   466_556055      JaccardDiss  4.285714e-01  9.444121e-04
      4589 2001   466_556055 MorisitaHornDiss  4.243831e-01  2.208803e-02
      4590 2001   466_556055   BrayCurtisDiss  4.773015e-01  9.670032e-03
      4591 1999   466_556055      JaccardDiss  3.529412e-01  9.444121e-04
      4592 1999   466_556055 MorisitaHornDiss  1.734831e-01  2.208803e-02
      4593 1999   466_556055   BrayCurtisDiss  3.562412e-01  9.670032e-03
      4594 2007   466_556055      JaccardDiss  3.571429e-01  9.444121e-04
      4595 2007   466_556055 MorisitaHornDiss  3.297312e-01  2.208803e-02
      4596 2007   466_556055   BrayCurtisDiss  4.301878e-01  9.670032e-03
      4597 2003   466_556055      JaccardDiss  4.285714e-01  9.444121e-04
      4598 2003   466_556055 MorisitaHornDiss  4.966508e-01  2.208803e-02
      4599 2003   466_556055   BrayCurtisDiss  5.954059e-01  9.670032e-03
      4600 1992   466_556055      JaccardDiss  2.307692e-01  9.444121e-04
      4601 1992   466_556055 MorisitaHornDiss  1.019445e-02  2.208803e-02
      4602 1992   466_556055   BrayCurtisDiss  3.493208e-01  9.670032e-03
      4603 1993   466_556055      JaccardDiss  4.666667e-01  9.444121e-04
      4604 1993   466_556055 MorisitaHornDiss  6.805471e-02  2.208803e-02
      4605 1993   466_556055   BrayCurtisDiss  3.583149e-01  9.670032e-03
      4606 1996   466_556055      JaccardDiss  2.727273e-01  9.444121e-04
      4607 1996   466_556055 MorisitaHornDiss  3.023452e-02  2.208803e-02
      4608 1996   466_556055   BrayCurtisDiss  1.265207e-01  9.670032e-03
      4609 1991   466_550230      JaccardDiss  2.142857e-01  7.608125e-03
      4610 1991   466_550230 MorisitaHornDiss  7.860923e-02  5.821357e-03
      4611 1991   466_550230   BrayCurtisDiss  4.294100e-01 -1.357561e-03
      4612 1994   466_550230      JaccardDiss  3.750000e-01  7.608125e-03
      4613 1994   466_550230 MorisitaHornDiss  6.144231e-01  5.821357e-03
      4614 1994   466_550230   BrayCurtisDiss  7.008874e-01 -1.357561e-03
      4615 1999   466_550230      JaccardDiss  4.375000e-01  7.608125e-03
      4616 1999   466_550230 MorisitaHornDiss  7.400466e-01  5.821357e-03
      4617 1999   466_550230   BrayCurtisDiss  7.718509e-01 -1.357561e-03
      4618 2002   466_550230      JaccardDiss  3.750000e-01  7.608125e-03
      4619 2002   466_550230 MorisitaHornDiss  6.381695e-01  5.821357e-03
      4620 2002   466_550230   BrayCurtisDiss  7.354668e-01 -1.357561e-03
      4621 2003   466_550230      JaccardDiss  4.000000e-01  7.608125e-03
      4622 2003   466_550230 MorisitaHornDiss  7.924386e-01  5.821357e-03
      4623 2003   466_550230   BrayCurtisDiss  8.188721e-01 -1.357561e-03
      4624 2005   466_550230      JaccardDiss  3.571429e-01  7.608125e-03
      4625 2005   466_550230 MorisitaHornDiss  3.503018e-01  5.821357e-03
      4626 2005   466_550230   BrayCurtisDiss  4.713674e-01 -1.357561e-03
      4627 1995   466_550230      JaccardDiss  4.285714e-01  7.608125e-03
      4628 1995   466_550230 MorisitaHornDiss  8.677891e-01  5.821357e-03
      4629 1995   466_550230   BrayCurtisDiss  8.470520e-01 -1.357561e-03
      4630 2008   466_550230      JaccardDiss  4.666667e-01  7.608125e-03
      4631 2008   466_550230 MorisitaHornDiss  4.724617e-01  5.821357e-03
      4632 2008   466_550230   BrayCurtisDiss  5.577400e-01 -1.357561e-03
      4633 1992   466_553875      JaccardDiss  4.000000e-01  3.318250e-03
      4634 1992   466_553875 MorisitaHornDiss  5.278436e-01 -1.761834e-02
      4635 1992   466_553875   BrayCurtisDiss  7.667506e-01 -7.096022e-03
      4636 1993   466_553875      JaccardDiss  4.117647e-01  3.318250e-03
      4637 1993   466_553875 MorisitaHornDiss  4.783926e-02 -1.761834e-02
      4638 1993   466_553875   BrayCurtisDiss  2.695435e-01 -7.096022e-03
      4639 1997   466_553875      JaccardDiss  4.000000e-01  3.318250e-03
      4640 1997   466_553875 MorisitaHornDiss  1.846448e-04 -1.761834e-02
      4641 1997   466_553875   BrayCurtisDiss  5.605084e-01 -7.096022e-03
      4642 1996   466_553875      JaccardDiss  5.625000e-01  3.318250e-03
      4643 1996   466_553875 MorisitaHornDiss  1.920267e-02 -1.761834e-02
      4644 1996   466_553875   BrayCurtisDiss  7.823908e-01 -7.096022e-03
      4645 2001   466_553875      JaccardDiss  5.625000e-01  3.318250e-03
      4646 2001   466_553875 MorisitaHornDiss  5.715616e-02 -1.761834e-02
      4647 2001   466_553875   BrayCurtisDiss  6.087220e-01 -7.096022e-03
      4648 2006   466_553875      JaccardDiss  5.333333e-01  3.318250e-03
      4649 2006   466_553875 MorisitaHornDiss  8.136611e-02 -1.761834e-02
      4650 2006   466_553875   BrayCurtisDiss  6.901860e-01 -7.096022e-03
      4651 1999   466_553875      JaccardDiss  4.375000e-01  3.318250e-03
      4652 1999   466_553875 MorisitaHornDiss  7.072859e-01 -1.761834e-02
      4653 1999   466_553875   BrayCurtisDiss  9.178886e-01 -7.096022e-03
      4654 2008   466_553875      JaccardDiss  4.615385e-01  3.318250e-03
      4655 2008   466_553875 MorisitaHornDiss  4.651398e-03 -1.761834e-02
      4656 2008   466_553875   BrayCurtisDiss  3.798283e-01 -7.096022e-03
      4657 2005   466_553875      JaccardDiss  4.615385e-01  3.318250e-03
      4658 2005   466_553875 MorisitaHornDiss  3.272095e-04 -1.761834e-02
      4659 2005   466_553875   BrayCurtisDiss  3.939319e-01 -7.096022e-03
      4660 1995   466_553875      JaccardDiss  6.153846e-01  3.318250e-03
      4661 1995   466_553875 MorisitaHornDiss  4.319969e-05 -1.761834e-02
      4662 1995   466_553875   BrayCurtisDiss  1.209344e-01 -7.096022e-03
      4663 1986   466_553875      JaccardDiss  4.117647e-01  3.318250e-03
      4664 1986   466_553875 MorisitaHornDiss  4.934013e-01 -1.761834e-02
      4665 1986   466_553875   BrayCurtisDiss  7.934564e-01 -7.096022e-03
      4666 1992   466_555330      JaccardDiss  3.846154e-01  2.052134e-04
      4667 1992   466_555330 MorisitaHornDiss  7.019278e-03  4.522033e-04
      4668 1992   466_555330   BrayCurtisDiss  3.759574e-01  1.447145e-02
      4669 1995   466_555330      JaccardDiss  3.076923e-01  2.052134e-04
      4670 1995   466_555330 MorisitaHornDiss  8.680129e-03  4.522033e-04
      4671 1995   466_555330   BrayCurtisDiss  4.471831e-01  1.447145e-02
      4672 2002   466_555330      JaccardDiss  3.076923e-01  2.052134e-04
      4673 2002   466_555330 MorisitaHornDiss  1.969503e-03  4.522033e-04
      4674 2002   466_555330   BrayCurtisDiss  5.052964e-01  1.447145e-02
      4675 2005   466_555330      JaccardDiss  4.666667e-01  2.052134e-04
      4676 2005   466_555330 MorisitaHornDiss  8.089501e-02  4.522033e-04
      4677 2005   466_555330   BrayCurtisDiss  3.612073e-01  1.447145e-02
      4678 1997   466_555330      JaccardDiss  4.285714e-01  2.052134e-04
      4679 1997   466_555330 MorisitaHornDiss  2.577221e-01  4.522033e-04
      4680 1997   466_555330   BrayCurtisDiss  7.503968e-01  1.447145e-02
      4681 2001   466_555330      JaccardDiss  3.333333e-01  2.052134e-04
      4682 2001   466_555330 MorisitaHornDiss  8.156565e-03  4.522033e-04
      4683 2001   466_555330   BrayCurtisDiss  6.828506e-01  1.447145e-02
      4684 2003   466_555330      JaccardDiss  3.636364e-01  2.052134e-04
      4685 2003   466_555330 MorisitaHornDiss  2.116189e-03  4.522033e-04
      4686 2003   466_555330   BrayCurtisDiss  4.677274e-01  1.447145e-02
      4687 1986   466_555330      JaccardDiss  4.166667e-01  2.052134e-04
      4688 1986   466_555330 MorisitaHornDiss  3.998117e-02  4.522033e-04
      4689 1986   466_555330   BrayCurtisDiss  2.326064e-01  1.447145e-02
      4690 1996   466_555330      JaccardDiss  3.846154e-01  2.052134e-04
      4691 1996   466_555330 MorisitaHornDiss  2.704223e-01  4.522033e-04
      4692 1996   466_555330   BrayCurtisDiss  8.876616e-01  1.447145e-02
      4693 1999   466_555330      JaccardDiss  5.384615e-01  2.052134e-04
      4694 1999   466_555330 MorisitaHornDiss  7.566273e-04  4.522033e-04
      4695 1999   466_555330   BrayCurtisDiss  1.825051e-01  1.447145e-02
      4696 1987   466_555330      JaccardDiss  3.846154e-01  2.052134e-04
      4697 1987   466_555330 MorisitaHornDiss  9.548052e-04  4.522033e-04
      4698 1987   466_555330   BrayCurtisDiss  1.212284e-01  1.447145e-02
      4699 1992   466_559695      JaccardDiss  2.727273e-01 -5.299836e-04
      4700 1992   466_559695 MorisitaHornDiss  6.186984e-02 -6.946520e-03
      4701 1992   466_559695   BrayCurtisDiss  5.388514e-01 -1.230094e-03
      4702 1995   466_559695      JaccardDiss  3.333333e-01 -5.299836e-04
      4703 1995   466_559695 MorisitaHornDiss  2.006648e-01 -6.946520e-03
      4704 1995   466_559695   BrayCurtisDiss  7.093333e-01 -1.230094e-03
      4705 1999   466_559695      JaccardDiss  4.615385e-01 -5.299836e-04
      4706 1999   466_559695 MorisitaHornDiss  1.806613e-02 -6.946520e-03
      4707 1999   466_559695   BrayCurtisDiss  7.378133e-01 -1.230094e-03
      4708 1988   466_559695      JaccardDiss  3.636364e-01 -5.299836e-04
      4709 1988   466_559695 MorisitaHornDiss  2.691335e-01 -6.946520e-03
      4710 1988   466_559695   BrayCurtisDiss  5.319617e-01 -1.230094e-03
      4711 1993   466_559695      JaccardDiss  4.615385e-01 -5.299836e-04
      4712 1993   466_559695 MorisitaHornDiss  3.230804e-01 -6.946520e-03
      4713 1993   466_559695   BrayCurtisDiss  5.692570e-01 -1.230094e-03
      4714 1994   466_559695      JaccardDiss  4.166667e-01 -5.299836e-04
      4715 1994   466_559695 MorisitaHornDiss  1.571845e-02 -6.946520e-03
      4716 1994   466_559695   BrayCurtisDiss  8.121916e-01 -1.230094e-03
      4717 2001   466_559695      JaccardDiss  5.000000e-01 -5.299836e-04
      4718 2001   466_559695 MorisitaHornDiss  7.777229e-03 -6.946520e-03
      4719 2001   466_559695   BrayCurtisDiss  8.300442e-01 -1.230094e-03
      4720 2008   466_559695      JaccardDiss  5.000000e-01 -5.299836e-04
      4721 2008   466_559695 MorisitaHornDiss  4.012973e-02 -6.946520e-03
      4722 2008   466_559695   BrayCurtisDiss  6.776452e-01 -1.230094e-03
      4723 2006   466_559695      JaccardDiss  4.545455e-01 -5.299836e-04
      4724 2006   466_559695 MorisitaHornDiss  1.994107e-02 -6.946520e-03
      4725 2006   466_559695   BrayCurtisDiss  6.545478e-01 -1.230094e-03
      4726 2007   466_559695      JaccardDiss  1.250000e-01 -5.299836e-04
      4727 2007   466_559695 MorisitaHornDiss  2.062745e-02 -6.946520e-03
      4728 2007   466_559695   BrayCurtisDiss  3.227635e-01 -1.230094e-03
      4729 1989   466_559695      JaccardDiss  5.000000e-01 -5.299836e-04
      4730 1989   466_559695 MorisitaHornDiss  2.140159e-02 -6.946520e-03
      4731 1989   466_559695   BrayCurtisDiss  8.393921e-01 -1.230094e-03
      4732 1991   466_559695      JaccardDiss  3.636364e-01 -5.299836e-04
      4733 1991   466_559695 MorisitaHornDiss  1.803425e-02 -6.946520e-03
      4734 1991   466_559695   BrayCurtisDiss  3.516174e-01 -1.230094e-03
      4735 1996   466_559695      JaccardDiss  2.222222e-01 -5.299836e-04
      4736 1996   466_559695 MorisitaHornDiss  1.984930e-01 -6.946520e-03
      4737 1996   466_559695   BrayCurtisDiss  8.654735e-01 -1.230094e-03
      4738 1997   466_559695      JaccardDiss  2.307692e-01 -5.299836e-04
      4739 1997   466_559695 MorisitaHornDiss  5.684165e-02 -6.946520e-03
      4740 1997   466_559695   BrayCurtisDiss  3.090278e-01 -1.230094e-03
      4741 1992   466_557513      JaccardDiss  4.000000e-01  8.767036e-04
      4742 1992   466_557513 MorisitaHornDiss  9.420468e-03 -1.815568e-03
      4743 1992   466_557513   BrayCurtisDiss  1.566721e-01  1.190416e-03
      4744 1987   466_557513      JaccardDiss  3.636364e-01  8.767036e-04
      4745 1987   466_557513 MorisitaHornDiss  2.985822e-02 -1.815568e-03
      4746 1987   466_557513   BrayCurtisDiss  2.475186e-01  1.190416e-03
      4747 1994   466_557513      JaccardDiss  3.636364e-01  8.767036e-04
      4748 1994   466_557513 MorisitaHornDiss  1.583658e-02 -1.815568e-03
      4749 1994   466_557513   BrayCurtisDiss  6.092475e-01  1.190416e-03
      4750 1991   466_557513      JaccardDiss  3.333333e-01  8.767036e-04
      4751 1991   466_557513 MorisitaHornDiss  5.521647e-03 -1.815568e-03
      4752 1991   466_557513   BrayCurtisDiss  2.678777e-01  1.190416e-03
      4753 1990   466_557513      JaccardDiss  3.846154e-01  8.767036e-04
      4754 1990   466_557513 MorisitaHornDiss  2.443054e-01 -1.815568e-03
      4755 1990   466_557513   BrayCurtisDiss  7.197851e-01  1.190416e-03
      4756 1999   466_557513      JaccardDiss  4.615385e-01  8.767036e-04
      4757 1999   466_557513 MorisitaHornDiss  6.131224e-03 -1.815568e-03
      4758 1999   466_557513   BrayCurtisDiss  4.633360e-01  1.190416e-03
      4759 2008   466_557513      JaccardDiss  5.333333e-01  8.767036e-04
      4760 2008   466_557513 MorisitaHornDiss  5.360033e-03 -1.815568e-03
      4761 2008   466_557513   BrayCurtisDiss  1.139447e-01  1.190416e-03
      4762 2005   466_557513      JaccardDiss  3.846154e-01  8.767036e-04
      4763 2005   466_557513 MorisitaHornDiss  8.622569e-02 -1.815568e-03
      4764 2005   466_557513   BrayCurtisDiss  6.137230e-01  1.190416e-03
      4765 2007   466_557513      JaccardDiss  2.727273e-01  8.767036e-04
      4766 2007   466_557513 MorisitaHornDiss  1.671583e-02 -1.815568e-03
      4767 2007   466_557513   BrayCurtisDiss  1.022129e-01  1.190416e-03
      4768 1988   466_557513      JaccardDiss  3.636364e-01  8.767036e-04
      4769 1988   466_557513 MorisitaHornDiss  2.568003e-03 -1.815568e-03
      4770 1988   466_557513   BrayCurtisDiss  2.115887e-01  1.190416e-03
      4771 2006   466_557513      JaccardDiss  3.000000e-01  8.767036e-04
      4772 2006   466_557513 MorisitaHornDiss  1.395687e-03 -1.815568e-03
      4773 2006   466_557513   BrayCurtisDiss  6.816237e-01  1.190416e-03
      4774 1993   466_557513      JaccardDiss  2.222222e-01  8.767036e-04
      4775 1993   466_557513 MorisitaHornDiss  4.433320e-03 -1.815568e-03
      4776 1993   466_557513   BrayCurtisDiss  6.342637e-01  1.190416e-03
      4777 1995   466_557513      JaccardDiss  3.333333e-01  8.767036e-04
      4778 1995   466_557513 MorisitaHornDiss  2.195107e-02 -1.815568e-03
      4779 1995   466_557513   BrayCurtisDiss  3.035285e-01  1.190416e-03
      4780 1996   466_557513      JaccardDiss  3.000000e-01  8.767036e-04
      4781 1996   466_557513 MorisitaHornDiss  7.215258e-02 -1.815568e-03
      4782 1996   466_557513   BrayCurtisDiss  5.001862e-01  1.190416e-03
      4783 2001   466_557513      JaccardDiss  6.363636e-01  8.767036e-04
      4784 2001   466_557513 MorisitaHornDiss  1.151504e-02 -1.815568e-03
      4785 2001   466_557513   BrayCurtisDiss  5.708770e-01  1.190416e-03
      4786 1986   466_557513      JaccardDiss  5.454545e-01  8.767036e-04
      4787 1986   466_557513 MorisitaHornDiss  6.332960e-02 -1.815568e-03
      4788 1986   466_557513   BrayCurtisDiss  3.654524e-01  1.190416e-03
      4789 1993   466_550231      JaccardDiss  9.090909e-02  1.394254e-03
      4790 1993   466_550231 MorisitaHornDiss  5.080825e-03 -3.693305e-03
      4791 1993   466_550231   BrayCurtisDiss  2.556442e-01  1.216864e-02
      4792 1995   466_550231      JaccardDiss  3.333333e-01  1.394254e-03
      4793 1995   466_550231 MorisitaHornDiss  1.927896e-01 -3.693305e-03
      4794 1995   466_550231   BrayCurtisDiss  5.552860e-01  1.216864e-02
      4795 1997   466_550231      JaccardDiss  5.000000e-01  1.394254e-03
      4796 1997   466_550231 MorisitaHornDiss  3.582092e-02 -3.693305e-03
      4797 1997   466_550231   BrayCurtisDiss  5.921868e-01  1.216864e-02
      4798 1986   466_550231      JaccardDiss  3.846154e-01  1.394254e-03
      4799 1986   466_550231 MorisitaHornDiss  3.100765e-02 -3.693305e-03
      4800 1986   466_550231   BrayCurtisDiss  8.593750e-01  1.216864e-02
      4801 1988   466_550231      JaccardDiss  2.307692e-01  1.394254e-03
      4802 1988   466_550231 MorisitaHornDiss  2.357252e-01 -3.693305e-03
      4803 1988   466_550231   BrayCurtisDiss  5.498738e-01  1.216864e-02
      4804 2002   466_550231      JaccardDiss  3.333333e-01  1.394254e-03
      4805 2002   466_550231 MorisitaHornDiss  7.550553e-02 -3.693305e-03
      4806 2002   466_550231   BrayCurtisDiss  6.682061e-01  1.216864e-02
      4807 2006   466_550231      JaccardDiss  3.076923e-01  1.394254e-03
      4808 2006   466_550231 MorisitaHornDiss  3.330239e-02 -3.693305e-03
      4809 2006   466_550231   BrayCurtisDiss  6.395464e-01  1.216864e-02
      4810 1989   466_550231      JaccardDiss  3.846154e-01  1.394254e-03
      4811 1989   466_550231 MorisitaHornDiss  3.987937e-02 -3.693305e-03
      4812 1989   466_550231   BrayCurtisDiss  4.311508e-01  1.216864e-02
      4813 1990   466_550231      JaccardDiss  4.166667e-01  1.394254e-03
      4814 1990   466_550231 MorisitaHornDiss  4.556252e-02 -3.693305e-03
      4815 1990   466_550231   BrayCurtisDiss  1.997837e-01  1.216864e-02
      4816 1992   466_550231      JaccardDiss  3.333333e-01  1.394254e-03
      4817 1992   466_550231 MorisitaHornDiss  3.083398e-02 -3.693305e-03
      4818 1992   466_550231   BrayCurtisDiss  2.616955e-01  1.216864e-02
      4819 1994   466_550231      JaccardDiss  3.076923e-01  1.394254e-03
      4820 1994   466_550231 MorisitaHornDiss  2.684157e-01 -3.693305e-03
      4821 1994   466_550231   BrayCurtisDiss  6.169644e-01  1.216864e-02
      4822 1996   466_550231      JaccardDiss  1.818182e-01  1.394254e-03
      4823 1996   466_550231 MorisitaHornDiss  2.822387e-01 -3.693305e-03
      4824 1996   466_550231   BrayCurtisDiss  8.014147e-01  1.216864e-02
      4825 2001   466_550231      JaccardDiss  1.818182e-01  1.394254e-03
      4826 2001   466_550231 MorisitaHornDiss  1.933234e-02 -3.693305e-03
      4827 2001   466_550231   BrayCurtisDiss  6.743367e-01  1.216864e-02
      4828 2003   466_550231      JaccardDiss  5.000000e-01  1.394254e-03
      4829 2003   466_550231 MorisitaHornDiss  4.088661e-02 -3.693305e-03
      4830 2003   466_550231   BrayCurtisDiss  7.376047e-01  1.216864e-02
      4831 1987   466_550231      JaccardDiss  2.727273e-01  1.394254e-03
      4832 1987   466_550231 MorisitaHornDiss  1.920218e-01 -3.693305e-03
      4833 1987   466_550231   BrayCurtisDiss  4.090972e-01  1.216864e-02
      4834 1993   466_554603      JaccardDiss  5.882353e-01 -6.758422e-03
      4835 1993   466_554603 MorisitaHornDiss  4.804896e-02 -2.091910e-03
      4836 1993   466_554603   BrayCurtisDiss  6.616097e-01 -1.364530e-03
      4837 2006   466_554603      JaccardDiss  3.076923e-01 -6.758422e-03
      4838 2006   466_554603 MorisitaHornDiss  6.521329e-03 -2.091910e-03
      4839 2006   466_554603   BrayCurtisDiss  6.945515e-01 -1.364530e-03
      4840 1997   466_554603      JaccardDiss  2.500000e-01 -6.758422e-03
      4841 1997   466_554603 MorisitaHornDiss  1.238342e-01 -2.091910e-03
      4842 1997   466_554603   BrayCurtisDiss  7.809059e-01 -1.364530e-03
      4843 2001   466_554603      JaccardDiss  3.571429e-01 -6.758422e-03
      4844 2001   466_554603 MorisitaHornDiss  2.397933e-03 -2.091910e-03
      4845 2001   466_554603   BrayCurtisDiss  5.676430e-01 -1.364530e-03
      4846 2003   466_554603      JaccardDiss  3.846154e-01 -6.758422e-03
      4847 2003   466_554603 MorisitaHornDiss  8.794484e-03 -2.091910e-03
      4848 2003   466_554603   BrayCurtisDiss  6.851477e-01 -1.364530e-03
      4849 2005   466_554603      JaccardDiss  2.500000e-01 -6.758422e-03
      4850 2005   466_554603 MorisitaHornDiss  3.294481e-04 -2.091910e-03
      4851 2005   466_554603   BrayCurtisDiss  4.236584e-01 -1.364530e-03
      4852 1992   466_554603      JaccardDiss  3.846154e-01 -6.758422e-03
      4853 1992   466_554603 MorisitaHornDiss  3.829471e-02 -2.091910e-03
      4854 1992   466_554603   BrayCurtisDiss  8.943803e-01 -1.364530e-03
      4855 1994   466_554603      JaccardDiss  3.333333e-01 -6.758422e-03
      4856 1994   466_554603 MorisitaHornDiss  3.260662e-04 -2.091910e-03
      4857 1994   466_554603   BrayCurtisDiss  1.524356e-01 -1.364530e-03
      4858 1995   466_554603      JaccardDiss  2.727273e-01 -6.758422e-03
      4859 1995   466_554603 MorisitaHornDiss  2.668521e-03 -2.091910e-03
      4860 1995   466_554603   BrayCurtisDiss  1.788055e-01 -1.364530e-03
      4861 1996   466_554603      JaccardDiss  3.636364e-01 -6.758422e-03
      4862 1996   466_554603 MorisitaHornDiss  5.140734e-04 -2.091910e-03
      4863 1996   466_554603   BrayCurtisDiss  5.740599e-01 -1.364530e-03
      4864 2002   466_554603      JaccardDiss  4.000000e-01 -6.758422e-03
      4865 2002   466_554603 MorisitaHornDiss  2.907517e-02 -2.091910e-03
      4866 2002   466_554603   BrayCurtisDiss  2.369186e-01 -1.364530e-03
      4867 1993   466_554600      JaccardDiss  5.000000e-01 -1.378457e-02
      4868 1993   466_554600 MorisitaHornDiss  2.086014e-01 -5.764409e-03
      4869 1993   466_554600   BrayCurtisDiss  4.984610e-01  3.064574e-03
      4870 2006   466_554600      JaccardDiss  2.727273e-01 -1.378457e-02
      4871 2006   466_554600 MorisitaHornDiss  3.910134e-02 -5.764409e-03
      4872 2006   466_554600   BrayCurtisDiss  6.776896e-01  3.064574e-03
      4873 2003   466_554600      JaccardDiss  3.636364e-01 -1.378457e-02
      4874 2003   466_554600 MorisitaHornDiss  3.574221e-01 -5.764409e-03
      4875 2003   466_554600   BrayCurtisDiss  5.890870e-01  3.064574e-03
      4876 2005   466_554600      JaccardDiss  3.636364e-01 -1.378457e-02
      4877 2005   466_554600 MorisitaHornDiss  1.028486e-01 -5.764409e-03
      4878 2005   466_554600   BrayCurtisDiss  4.022105e-01  3.064574e-03
      4879 1995   466_554600      JaccardDiss  5.000000e-01 -1.378457e-02
      4880 1995   466_554600 MorisitaHornDiss  1.954174e-01 -5.764409e-03
      4881 1995   466_554600   BrayCurtisDiss  5.582634e-01  3.064574e-03
      4882 1999   466_554600      JaccardDiss  2.000000e-01 -1.378457e-02
      4883 1999   466_554600 MorisitaHornDiss  9.200110e-02 -5.764409e-03
      4884 1999   466_554600   BrayCurtisDiss  4.405528e-01  3.064574e-03
      4885 2002   466_554600      JaccardDiss  3.571429e-01 -1.378457e-02
      4886 2002   466_554600 MorisitaHornDiss  1.802760e-01 -5.764409e-03
      4887 2002   466_554600   BrayCurtisDiss  4.367347e-01  3.064574e-03
      4888 1994   466_553147      JaccardDiss  4.285714e-01  7.110727e-03
      4889 1994   466_553147 MorisitaHornDiss  1.100124e-01  5.338690e-03
      4890 1994   466_553147   BrayCurtisDiss  4.039569e-01  1.206797e-02
      4891 1986   466_553147      JaccardDiss  3.333333e-01  7.110727e-03
      4892 1986   466_553147 MorisitaHornDiss  2.175750e-02  5.338690e-03
      4893 1986   466_553147   BrayCurtisDiss  5.546513e-01  1.206797e-02
      4894 1999   466_553147      JaccardDiss  3.571429e-01  7.110727e-03
      4895 1999   466_553147 MorisitaHornDiss  7.559513e-02  5.338690e-03
      4896 1999   466_553147   BrayCurtisDiss  6.968510e-01  1.206797e-02
      4897 2005   466_553147      JaccardDiss  3.846154e-01  7.110727e-03
      4898 2005   466_553147 MorisitaHornDiss  5.829129e-02  5.338690e-03
      4899 2005   466_553147   BrayCurtisDiss  8.077676e-01  1.206797e-02
      4900 1990   466_553147      JaccardDiss  3.333333e-01  7.110727e-03
      4901 1990   466_553147 MorisitaHornDiss  3.403244e-02  5.338690e-03
      4902 1990   466_553147   BrayCurtisDiss  4.373946e-01  1.206797e-02
      4903 1992   466_553147      JaccardDiss  2.727273e-01  7.110727e-03
      4904 1992   466_553147 MorisitaHornDiss  6.078858e-02  5.338690e-03
      4905 1992   466_553147   BrayCurtisDiss  6.020217e-01  1.206797e-02
      4906 2003   466_553147      JaccardDiss  5.294118e-01  7.110727e-03
      4907 2003   466_553147 MorisitaHornDiss  2.082636e-01  5.338690e-03
      4908 2003   466_553147   BrayCurtisDiss  5.478605e-01  1.206797e-02
      4909 1994   466_556785      JaccardDiss  2.727273e-01  9.161660e-04
      4910 1994   466_556785 MorisitaHornDiss  6.395091e-01  1.214852e-03
      4911 1994   466_556785   BrayCurtisDiss  6.562809e-01 -4.376833e-03
      4912 2003   466_556785      JaccardDiss  3.636364e-01  9.161660e-04
      4913 2003   466_556785 MorisitaHornDiss  5.707415e-02  1.214852e-03
      4914 2003   466_556785   BrayCurtisDiss  6.314213e-01 -4.376833e-03
      4915 1997   466_556785      JaccardDiss  3.636364e-01  9.161660e-04
      4916 1997   466_556785 MorisitaHornDiss  1.511626e-01  1.214852e-03
      4917 1997   466_556785   BrayCurtisDiss  7.665000e-01 -4.376833e-03
      4918 1999   466_556785      JaccardDiss  5.384615e-01  9.161660e-04
      4919 1999   466_556785 MorisitaHornDiss  1.795829e-01  1.214852e-03
      4920 1999   466_556785   BrayCurtisDiss  7.363615e-01 -4.376833e-03
      4921 2007   466_556785      JaccardDiss  4.615385e-01  9.161660e-04
      4922 2007   466_556785 MorisitaHornDiss  4.288510e-01  1.214852e-03
      4923 2007   466_556785   BrayCurtisDiss  4.911855e-01 -4.376833e-03
      4924 2005   466_556785      JaccardDiss  3.000000e-01  9.161660e-04
      4925 2005   466_556785 MorisitaHornDiss  2.730552e-02  1.214852e-03
      4926 2005   466_556785   BrayCurtisDiss  5.222772e-01 -4.376833e-03
      4927 1992   466_556785      JaccardDiss  4.166667e-01  9.161660e-04
      4928 1992   466_556785 MorisitaHornDiss  5.536803e-03  1.214852e-03
      4929 1992   466_556785   BrayCurtisDiss  6.981756e-01 -4.376833e-03
      4930 1993   466_556785      JaccardDiss  3.636364e-01  9.161660e-04
      4931 1993   466_556785 MorisitaHornDiss  7.072426e-03  1.214852e-03
      4932 1993   466_556785   BrayCurtisDiss  2.599758e-01 -4.376833e-03
      4933 1995   466_556785      JaccardDiss  5.555556e-01  9.161660e-04
      4934 1995   466_556785 MorisitaHornDiss  3.563525e-03  1.214852e-03
      4935 1995   466_556785   BrayCurtisDiss  4.446361e-01 -4.376833e-03
      4936 1986   466_556785      JaccardDiss  3.750000e-01  9.161660e-04
      4937 1986   466_556785 MorisitaHornDiss  1.714020e-03  1.214852e-03
      4938 1986   466_556785   BrayCurtisDiss  6.874088e-01 -4.376833e-03
      4939 1987   466_556785      JaccardDiss  3.846154e-01  9.161660e-04
      4940 1987   466_556785 MorisitaHornDiss  4.207783e-01  1.214852e-03
      4941 1987   466_556785   BrayCurtisDiss  6.848044e-01 -4.376833e-03
      4942 1994   466_550958      JaccardDiss  3.076923e-01  8.712207e-03
      4943 1994   466_550958 MorisitaHornDiss  1.764115e-01 -7.859960e-03
      4944 1994   466_550958   BrayCurtisDiss  3.972886e-01  8.478502e-03
      4945 1999   466_550958      JaccardDiss  2.857143e-01  8.712207e-03
      4946 1999   466_550958 MorisitaHornDiss  2.855899e-02 -7.859960e-03
      4947 1999   466_550958   BrayCurtisDiss  6.447670e-01  8.478502e-03
      4948 2003   466_550958      JaccardDiss  4.285714e-01  8.712207e-03
      4949 2003   466_550958 MorisitaHornDiss  1.303499e-01 -7.859960e-03
      4950 2003   466_550958   BrayCurtisDiss  6.789673e-01  8.478502e-03
      4951 2005   466_550958      JaccardDiss  5.555556e-01  8.712207e-03
      4952 2005   466_550958 MorisitaHornDiss  2.157706e-02 -7.859960e-03
      4953 2005   466_550958   BrayCurtisDiss  7.208495e-01  8.478502e-03
      4954 2007   466_550958      JaccardDiss  5.000000e-01  8.712207e-03
      4955 2007   466_550958 MorisitaHornDiss  1.878402e-01 -7.859960e-03
      4956 2007   466_550958   BrayCurtisDiss  5.219024e-01  8.478502e-03
      4957 2008   466_550958      JaccardDiss  2.857143e-01  8.712207e-03
      4958 2008   466_550958 MorisitaHornDiss  5.662598e-01 -7.859960e-03
      4959 2008   466_550958   BrayCurtisDiss  6.198371e-01  8.478502e-03
      4960 1993   466_550958      JaccardDiss  3.571429e-01  8.712207e-03
      4961 1993   466_550958 MorisitaHornDiss  5.635800e-01 -7.859960e-03
      4962 1993   466_550958   BrayCurtisDiss  6.230508e-01  8.478502e-03
      4963 1996   466_550958      JaccardDiss  3.076923e-01  8.712207e-03
      4964 1996   466_550958 MorisitaHornDiss  3.710412e-01 -7.859960e-03
      4965 1996   466_550958   BrayCurtisDiss  5.081534e-01  8.478502e-03
      4966 1995   466_550958      JaccardDiss  3.076923e-01  8.712207e-03
      4967 1995   466_550958 MorisitaHornDiss  3.685062e-01 -7.859960e-03
      4968 1995   466_550958   BrayCurtisDiss  5.393426e-01  8.478502e-03
      4969 1997   466_550958      JaccardDiss  3.076923e-01  8.712207e-03
      4970 1997   466_550958 MorisitaHornDiss  2.191418e-01 -7.859960e-03
      4971 1997   466_550958   BrayCurtisDiss  4.384555e-01  8.478502e-03
      4972 2002   466_550958      JaccardDiss  3.076923e-01  8.712207e-03
      4973 2002   466_550958 MorisitaHornDiss  8.504985e-02 -7.859960e-03
      4974 2002   466_550958   BrayCurtisDiss  5.243816e-01  8.478502e-03
      4975 1995   466_561148      JaccardDiss  5.625000e-01  8.343963e-03
      4976 1995   466_561148 MorisitaHornDiss  2.300747e-02  4.260279e-03
      4977 1995   466_561148   BrayCurtisDiss  8.219429e-01  5.498779e-03
      4978 1999   466_561148      JaccardDiss  6.428571e-01  8.343963e-03
      4979 1999   466_561148 MorisitaHornDiss  1.098585e-01  4.260279e-03
      4980 1999   466_561148   BrayCurtisDiss  5.342489e-01  5.498779e-03
      4981 1987   466_561148      JaccardDiss  5.333333e-01  8.343963e-03
      4982 1987   466_561148 MorisitaHornDiss  4.477314e-02  4.260279e-03
      4983 1987   466_561148   BrayCurtisDiss  5.302013e-01  5.498779e-03
      4984 1995   466_558238      JaccardDiss  2.500000e-01  6.431943e-03
      4985 1995   466_558238 MorisitaHornDiss  4.506225e-01  2.085448e-02
      4986 1995   466_558238   BrayCurtisDiss  5.501047e-01  1.452774e-02
      4987 2005   466_558238      JaccardDiss  3.333333e-01  6.431943e-03
      4988 2005   466_558238 MorisitaHornDiss  8.537837e-01  2.085448e-02
      4989 2005   466_558238   BrayCurtisDiss  7.506436e-01  1.452774e-02
      4990 1992   466_558238      JaccardDiss  2.500000e-01  6.431943e-03
      4991 1992   466_558238 MorisitaHornDiss  1.320657e-02  2.085448e-02
      4992 1992   466_558238   BrayCurtisDiss  5.498181e-01  1.452774e-02
      4993 1994   466_558238      JaccardDiss  2.500000e-01  6.431943e-03
      4994 1994   466_558238 MorisitaHornDiss  1.943237e-02  2.085448e-02
      4995 1994   466_558238   BrayCurtisDiss  1.280582e-01  1.452774e-02
      4996 1996   466_558238      JaccardDiss  1.818182e-01  6.431943e-03
      4997 1996   466_558238 MorisitaHornDiss  4.387075e-03  2.085448e-02
      4998 1996   466_558238   BrayCurtisDiss  1.417730e-01  1.452774e-02
      4999 1997   466_558238      JaccardDiss  3.076923e-01  6.431943e-03
      5000 1997   466_558238 MorisitaHornDiss  9.366346e-02  2.085448e-02
      5001 1997   466_558238   BrayCurtisDiss  5.793981e-01  1.452774e-02
      5002 2003   466_558238      JaccardDiss  5.625000e-01  6.431943e-03
      5003 2003   466_558238 MorisitaHornDiss  2.547712e-02  2.085448e-02
      5004 2003   466_558238   BrayCurtisDiss  6.735593e-01  1.452774e-02
      5005 2007   466_558238      JaccardDiss  3.333333e-01  6.431943e-03
      5006 2007   466_558238 MorisitaHornDiss  2.485187e-02  2.085448e-02
      5007 2007   466_558238   BrayCurtisDiss  3.379421e-01  1.452774e-02
      5008 1988   466_558238      JaccardDiss  3.846154e-01  6.431943e-03
      5009 1988   466_558238 MorisitaHornDiss  5.952759e-03  2.085448e-02
      5010 1988   466_558238   BrayCurtisDiss  3.735734e-01  1.452774e-02
      5011 1993   466_558238      JaccardDiss  3.333333e-01  6.431943e-03
      5012 1993   466_558238 MorisitaHornDiss  3.713873e-01  2.085448e-02
      5013 1993   466_558238   BrayCurtisDiss  5.472008e-01  1.452774e-02
      5014 2001   466_558238      JaccardDiss  4.166667e-01  6.431943e-03
      5015 2001   466_558238 MorisitaHornDiss  9.144433e-01  2.085448e-02
      5016 2001   466_558238   BrayCurtisDiss  9.012602e-01  1.452774e-02
      5017 1995   466_555329      JaccardDiss  3.333333e-01  1.278317e-02
      5018 1995   466_555329 MorisitaHornDiss  9.257587e-02  3.006158e-03
      5019 1995   466_555329   BrayCurtisDiss  8.115352e-01  1.521419e-02
      5020 2001   466_555329      JaccardDiss  3.333333e-01  1.278317e-02
      5021 2001   466_555329 MorisitaHornDiss  2.949820e-01  3.006158e-03
      5022 2001   466_555329   BrayCurtisDiss  8.263785e-01  1.521419e-02
      5023 2002   466_555329      JaccardDiss  4.615385e-01  1.278317e-02
      5024 2002   466_555329 MorisitaHornDiss  1.674466e-01  3.006158e-03
      5025 2002   466_555329   BrayCurtisDiss  9.578590e-01  1.521419e-02
      5026 2007   466_555329      JaccardDiss  4.615385e-01  1.278317e-02
      5027 2007   466_555329 MorisitaHornDiss  1.432065e-03  3.006158e-03
      5028 2007   466_555329   BrayCurtisDiss  3.847906e-01  1.521419e-02
      5029 1987   466_555329      JaccardDiss  1.818182e-01  1.278317e-02
      5030 1987   466_555329 MorisitaHornDiss  1.319074e-01  3.006158e-03
      5031 1987   466_555329   BrayCurtisDiss  4.559505e-01  1.521419e-02
      5032 1989   466_555329      JaccardDiss  2.500000e-01  1.278317e-02
      5033 1989   466_555329 MorisitaHornDiss  4.910618e-03  3.006158e-03
      5034 1989   466_555329   BrayCurtisDiss  2.201659e-01  1.521419e-02
      5035 1993   466_555329      JaccardDiss  2.727273e-01  1.278317e-02
      5036 1993   466_555329 MorisitaHornDiss  1.516891e-03  3.006158e-03
      5037 1993   466_555329   BrayCurtisDiss  4.471485e-01  1.521419e-02
      5038 1997   466_555329      JaccardDiss  0.000000e+00  1.278317e-02
      5039 1997   466_555329 MorisitaHornDiss  8.235400e-02  3.006158e-03
      5040 1997   466_555329   BrayCurtisDiss  1.951290e-01  1.521419e-02
      5041 1996   466_553143      JaccardDiss  4.285714e-01 -6.669585e-04
      5042 1996   466_553143 MorisitaHornDiss  2.362432e-01 -1.858945e-03
      5043 1996   466_553143   BrayCurtisDiss  5.249542e-01  2.234746e-03
      5044 2003   466_553143      JaccardDiss  5.333333e-01 -6.669585e-04
      5045 2003   466_553143 MorisitaHornDiss  2.054570e-01 -1.858945e-03
      5046 2003   466_553143   BrayCurtisDiss  6.138449e-01  2.234746e-03
      5047 2008   466_553143      JaccardDiss  4.000000e-01 -6.669585e-04
      5048 2008   466_553143 MorisitaHornDiss  2.527278e-01 -1.858945e-03
      5049 2008   466_553143   BrayCurtisDiss  7.071624e-01  2.234746e-03
      5050 1991   466_553143      JaccardDiss  4.285714e-01 -6.669585e-04
      5051 1991   466_553143 MorisitaHornDiss  2.068371e-01 -1.858945e-03
      5052 1991   466_553143   BrayCurtisDiss  4.439391e-01  2.234746e-03
      5053 1999   466_553143      JaccardDiss  3.571429e-01 -6.669585e-04
      5054 1999   466_553143 MorisitaHornDiss  4.239471e-01 -1.858945e-03
      5055 1999   466_553143   BrayCurtisDiss  5.403805e-01  2.234746e-03
      5056 2006   466_553143      JaccardDiss  4.285714e-01 -6.669585e-04
      5057 2006   466_553143 MorisitaHornDiss  2.226064e-01 -1.858945e-03
      5058 2006   466_553143   BrayCurtisDiss  4.528212e-01  2.234746e-03
      5059 2002   466_553143      JaccardDiss  4.615385e-01 -6.669585e-04
      5060 2002   466_553143 MorisitaHornDiss  2.026195e-01 -1.858945e-03
      5061 2002   466_553143   BrayCurtisDiss  7.078261e-01  2.234746e-03
      5062 2005   466_553143      JaccardDiss  6.875000e-01 -6.669585e-04
      5063 2005   466_553143 MorisitaHornDiss  2.637841e-01 -1.858945e-03
      5064 2005   466_553143   BrayCurtisDiss  7.749309e-01  2.234746e-03
      5065 1986   466_553143      JaccardDiss  5.714286e-01 -6.669585e-04
      5066 1986   466_553143 MorisitaHornDiss  3.070702e-01 -1.858945e-03
      5067 1986   466_553143   BrayCurtisDiss  7.397071e-01  2.234746e-03
      5068 1997   466_556054      JaccardDiss  5.384615e-01  3.590039e-03
      5069 1997   466_556054 MorisitaHornDiss  1.482263e-02  1.384183e-02
      5070 1997   466_556054   BrayCurtisDiss  5.691835e-01  5.680998e-03
      5071 1988   466_556054      JaccardDiss  4.166667e-01  3.590039e-03
      5072 1988   466_556054 MorisitaHornDiss  7.989237e-02  1.384183e-02
      5073 1988   466_556054   BrayCurtisDiss  6.162826e-01  5.680998e-03
      5074 1995   466_556054      JaccardDiss  4.000000e-01  3.590039e-03
      5075 1995   466_556054 MorisitaHornDiss  7.519181e-01  1.384183e-02
      5076 1995   466_556054   BrayCurtisDiss  9.014950e-01  5.680998e-03
      5077 2008   466_556054      JaccardDiss  3.846154e-01  3.590039e-03
      5078 2008   466_556054 MorisitaHornDiss  3.342701e-01  1.384183e-02
      5079 2008   466_556054   BrayCurtisDiss  7.684758e-01  5.680998e-03
      5080 1989   466_556054      JaccardDiss  2.727273e-01  3.590039e-03
      5081 1989   466_556054 MorisitaHornDiss  4.198888e-04  1.384183e-02
      5082 1989   466_556054   BrayCurtisDiss  7.554802e-01  5.680998e-03
      5083 1994   466_556054      JaccardDiss  2.222222e-01  3.590039e-03
      5084 1994   466_556054 MorisitaHornDiss  2.895211e-02  1.384183e-02
      5085 1994   466_556054   BrayCurtisDiss  1.795211e-01  5.680998e-03
      5086 1999   466_548776      JaccardDiss  4.615385e-01  9.157509e-03
      5087 1999   466_548776 MorisitaHornDiss  5.252101e-01  5.178200e-02
      5088 1999   466_548776   BrayCurtisDiss  5.843452e-01  1.192940e-02
      5089 1992   466_548776      JaccardDiss  3.333333e-01  9.157509e-03
      5090 1992   466_548776 MorisitaHornDiss  1.698220e-01  5.178200e-02
      5091 1992   466_548776   BrayCurtisDiss  4.819466e-01  1.192940e-02
      5092 2001   466_548776      JaccardDiss  3.333333e-01  9.157509e-03
      5093 2001   466_548776 MorisitaHornDiss  6.262726e-01  5.178200e-02
      5094 2001   466_548776   BrayCurtisDiss  6.513892e-01  1.192940e-02
      5095 2003   466_548776      JaccardDiss  4.615385e-01  9.157509e-03
      5096 2003   466_548776 MorisitaHornDiss  6.848327e-01  5.178200e-02
      5097 2003   466_548776   BrayCurtisDiss  7.200115e-01  1.192940e-02
      5098 1993   466_548776      JaccardDiss  3.333333e-01  9.157509e-03
      5099 1993   466_548776 MorisitaHornDiss  1.482758e-01  5.178200e-02
      5100 1993   466_548776   BrayCurtisDiss  6.709324e-01  1.192940e-02
      5101 1999   466_550232      JaccardDiss  2.500000e-01 -3.435724e-03
      5102 1999   466_550232 MorisitaHornDiss  2.944266e-01  1.777076e-03
      5103 1999   466_550232   BrayCurtisDiss  4.380038e-01  2.839962e-03
      5104 2005   466_550232      JaccardDiss  4.615385e-01 -3.435724e-03
      5105 2005   466_550232 MorisitaHornDiss  8.711853e-01  1.777076e-03
      5106 2005   466_550232   BrayCurtisDiss  9.027517e-01  2.839962e-03
      5107 2007   466_550232      JaccardDiss  5.384615e-01 -3.435724e-03
      5108 2007   466_550232 MorisitaHornDiss  8.628737e-01  1.777076e-03
      5109 2007   466_550232   BrayCurtisDiss  8.742515e-01  2.839962e-03
      5110 2008   466_550232      JaccardDiss  3.846154e-01 -3.435724e-03
      5111 2008   466_550232 MorisitaHornDiss  2.307454e-01  1.777076e-03
      5112 2008   466_550232   BrayCurtisDiss  4.079031e-01  2.839962e-03
      5113 1991   466_550232      JaccardDiss  6.000000e-01 -3.435724e-03
      5114 1991   466_550232 MorisitaHornDiss  8.774037e-01  1.777076e-03
      5115 1991   466_550232   BrayCurtisDiss  7.944018e-01  2.839962e-03
      5116 1986   466_550232      JaccardDiss  5.333333e-01 -3.435724e-03
      5117 1986   466_550232 MorisitaHornDiss  6.791850e-01  1.777076e-03
      5118 1986   466_550232   BrayCurtisDiss  8.451556e-01  2.839962e-03
      5119 1988   466_550232      JaccardDiss  3.636364e-01 -3.435724e-03
      5120 1988   466_550232 MorisitaHornDiss  2.556251e-01  1.777076e-03
      5121 1988   466_550232   BrayCurtisDiss  3.286999e-01  2.839962e-03
      5122 2001   466_550232      JaccardDiss  3.000000e-01 -3.435724e-03
      5123 2001   466_550232 MorisitaHornDiss  4.142753e-01  1.777076e-03
      5124 2001   466_550232   BrayCurtisDiss  4.834538e-01  2.839962e-03
      5125 2003   466_550232      JaccardDiss  3.571429e-01 -3.435724e-03
      5126 2003   466_550232 MorisitaHornDiss  7.187099e-01  1.777076e-03
      5127 2003   466_550232   BrayCurtisDiss  8.748869e-01  2.839962e-03
      5128 1999   466_558968      JaccardDiss  5.000000e-01  6.860373e-03
      5129 1999   466_558968 MorisitaHornDiss  5.479934e-01  2.235289e-04
      5130 1999   466_558968   BrayCurtisDiss  5.537463e-01 -9.176009e-04
      5131 1993   466_558968      JaccardDiss  2.500000e-01  6.860373e-03
      5132 1993   466_558968 MorisitaHornDiss  7.362498e-01  2.235289e-04
      5133 1993   466_558968   BrayCurtisDiss  7.276292e-01 -9.176009e-04
      5134 1995   466_558968      JaccardDiss  2.500000e-01  6.860373e-03
      5135 1995   466_558968 MorisitaHornDiss  8.137094e-01  2.235289e-04
      5136 1995   466_558968   BrayCurtisDiss  7.098540e-01 -9.176009e-04
      5137 1996   466_558968      JaccardDiss  4.705882e-01  6.860373e-03
      5138 1996   466_558968 MorisitaHornDiss  7.863383e-01  2.235289e-04
      5139 1996   466_558968   BrayCurtisDiss  6.488529e-01 -9.176009e-04
      5140 2007   466_558968      JaccardDiss  4.166667e-01  6.860373e-03
      5141 2007   466_558968 MorisitaHornDiss  8.504467e-01  2.235289e-04
      5142 2007   466_558968   BrayCurtisDiss  7.991736e-01 -9.176009e-04
      5143 2003   466_558968      JaccardDiss  3.846154e-01  6.860373e-03
      5144 2003   466_558968 MorisitaHornDiss  7.941788e-01  2.235289e-04
      5145 2003   466_558968   BrayCurtisDiss  6.834197e-01 -9.176009e-04
      5146 2005   466_558968      JaccardDiss  3.333333e-01  6.860373e-03
      5147 2005   466_558968 MorisitaHornDiss  7.835052e-01  2.235289e-04
      5148 2005   466_558968   BrayCurtisDiss  6.004524e-01 -9.176009e-04
      5149 2001   466_558968      JaccardDiss  4.615385e-01  6.860373e-03
      5150 2001   466_558968 MorisitaHornDiss  3.332473e-02  2.235289e-04
      5151 2001   466_558968   BrayCurtisDiss  3.504351e-01 -9.176009e-04
      5152 2001   466_559696      JaccardDiss  4.705882e-01 -2.585281e-03
      5153 2001   466_559696 MorisitaHornDiss  9.617462e-02 -1.345982e-03
      5154 2001   466_559696   BrayCurtisDiss  3.101406e-01 -1.590025e-02
      5155 2008   466_559696      JaccardDiss  4.375000e-01 -2.585281e-03
      5156 2008   466_559696 MorisitaHornDiss  8.598586e-02 -1.345982e-03
      5157 2008   466_559696   BrayCurtisDiss  3.523707e-01 -1.590025e-02
      5158 2007   466_559696      JaccardDiss  3.076923e-01 -2.585281e-03
      5159 2007   466_559696 MorisitaHornDiss  4.128538e-02 -1.345982e-03
      5160 2007   466_559696   BrayCurtisDiss  5.664217e-01 -1.590025e-02
      5161 2003   466_559696      JaccardDiss  3.333333e-01 -2.585281e-03
      5162 2003   466_559696 MorisitaHornDiss  9.892308e-02 -1.345982e-03
      5163 2003   466_559696   BrayCurtisDiss  5.196640e-01 -1.590025e-02
      5164 1988   466_559696      JaccardDiss  5.000000e-01 -2.585281e-03
      5165 1988   466_559696 MorisitaHornDiss  6.059011e-02 -1.345982e-03
      5166 1988   466_559696   BrayCurtisDiss  8.115882e-01 -1.590025e-02
      5167 1992   466_559696      JaccardDiss  3.076923e-01 -2.585281e-03
      5168 1992   466_559696 MorisitaHornDiss  4.624031e-02 -1.345982e-03
      5169 1992   466_559696   BrayCurtisDiss  5.545731e-01 -1.590025e-02
      5170 1993   466_559696      JaccardDiss  4.285714e-01 -2.585281e-03
      5171 1993   466_559696 MorisitaHornDiss  7.427383e-02 -1.345982e-03
      5172 1993   466_559696   BrayCurtisDiss  7.267100e-01 -1.590025e-02
      5173 1996   466_559696      JaccardDiss  4.166667e-01 -2.585281e-03
      5174 1996   466_559696 MorisitaHornDiss  4.924845e-03 -1.345982e-03
      5175 1996   466_559696   BrayCurtisDiss  3.834640e-01 -1.590025e-02
      5176 1997   466_559696      JaccardDiss  2.500000e-01 -2.585281e-03
      5177 1997   466_559696 MorisitaHornDiss  7.572892e-01 -1.345982e-03
      5178 1997   466_559696   BrayCurtisDiss  6.288314e-01 -1.590025e-02
      5179 1999   466_559696      JaccardDiss  4.117647e-01 -2.585281e-03
      5180 1999   466_559696 MorisitaHornDiss  2.580102e-03 -1.345982e-03
      5181 1999   466_559696   BrayCurtisDiss  3.590627e-01 -1.590025e-02
      5182 1999   466_551690      JaccardDiss  4.285714e-01  5.415690e-03
      5183 1999   466_551690 MorisitaHornDiss  2.837987e-01  9.375239e-04
      5184 1999   466_551690   BrayCurtisDiss  3.777619e-01  9.760425e-03
      5185 2003   466_551690      JaccardDiss  3.333333e-01  5.415690e-03
      5186 2003   466_551690 MorisitaHornDiss  3.863124e-01  9.375239e-04
      5187 2003   466_551690   BrayCurtisDiss  5.374097e-01  9.760425e-03
      5188 1996   466_551690      JaccardDiss  4.666667e-01  5.415690e-03
      5189 1996   466_551690 MorisitaHornDiss  4.801811e-01  9.375239e-04
      5190 1996   466_551690   BrayCurtisDiss  5.914703e-01  9.760425e-03
      5191 2006   466_551690      JaccardDiss  4.666667e-01  5.415690e-03
      5192 2006   466_551690 MorisitaHornDiss  5.483210e-01  9.375239e-04
      5193 2006   466_551690   BrayCurtisDiss  8.744802e-01  9.760425e-03
      5194 2005   466_551690      JaccardDiss  6.428571e-01  5.415690e-03
      5195 2005   466_551690 MorisitaHornDiss  4.443195e-01  9.375239e-04
      5196 2005   466_551690   BrayCurtisDiss  6.469310e-01  9.760425e-03
      5197 2007   466_551690      JaccardDiss  4.166667e-01  5.415690e-03
      5198 2007   466_551690 MorisitaHornDiss  5.604057e-01  9.375239e-04
      5199 2007   466_551690   BrayCurtisDiss  8.096886e-01  9.760425e-03
      5200 1989   466_551690      JaccardDiss  3.636364e-01  5.415690e-03
      5201 1989   466_551690 MorisitaHornDiss  4.915534e-01  9.375239e-04
      5202 1989   466_551690   BrayCurtisDiss  6.518135e-01  9.760425e-03
      5203 2001   466_551690      JaccardDiss  3.636364e-01  5.415690e-03
      5204 2001   466_551690 MorisitaHornDiss  4.858039e-01  9.375239e-04
      5205 2001   466_551690   BrayCurtisDiss  5.928718e-01  9.760425e-03
      5206 2002   466_551690      JaccardDiss  4.285714e-01  5.415690e-03
      5207 2002   466_551690 MorisitaHornDiss  3.888048e-02  9.375239e-04
      5208 2002   466_551690   BrayCurtisDiss  5.082034e-01  9.760425e-03
      5209 2002   466_553145      JaccardDiss  3.125000e-01 -1.951443e-03
      5210 2002   466_553145 MorisitaHornDiss  2.664992e-03  1.625672e-02
      5211 2002   466_553145   BrayCurtisDiss  8.138623e-02  9.276566e-03
      5212 2003   466_553145      JaccardDiss  5.000000e-01 -1.951443e-03
      5213 2003   466_553145 MorisitaHornDiss  8.341961e-01  1.625672e-02
      5214 2003   466_553145   BrayCurtisDiss  8.937921e-01  9.276566e-03
      5215 2008   466_553145      JaccardDiss  4.000000e-01 -1.951443e-03
      5216 2008   466_553145 MorisitaHornDiss  4.470028e-02  1.625672e-02
      5217 2008   466_553145   BrayCurtisDiss  2.101167e-01  9.276566e-03
      5218 1991   466_553145      JaccardDiss  3.571429e-01 -1.951443e-03
      5219 1991   466_553145 MorisitaHornDiss  4.153724e-02  1.625672e-02
      5220 1991   466_553145   BrayCurtisDiss  3.040217e-01  9.276566e-03
      5221 1997   466_553145      JaccardDiss  3.571429e-01 -1.951443e-03
      5222 1997   466_553145 MorisitaHornDiss  3.559392e-02  1.625672e-02
      5223 1997   466_553145   BrayCurtisDiss  3.230027e-01  9.276566e-03
      5224 1993   466_553145      JaccardDiss  2.857143e-01 -1.951443e-03
      5225 1993   466_553145 MorisitaHornDiss  2.775452e-02  1.625672e-02
      5226 1993   466_553145   BrayCurtisDiss  2.883295e-01  9.276566e-03
      5227 1996   466_553145      JaccardDiss  4.375000e-01 -1.951443e-03
      5228 1996   466_553145 MorisitaHornDiss  3.826865e-02  1.625672e-02
      5229 1996   466_553145   BrayCurtisDiss  6.012239e-01  9.276566e-03
      5230 1994   466_553145      JaccardDiss  3.076923e-01 -1.951443e-03
      5231 1994   466_553145 MorisitaHornDiss  1.734470e-02  1.625672e-02
      5232 1994   466_553145   BrayCurtisDiss  1.752955e-01  9.276566e-03
      5233 2001   466_553145      JaccardDiss  7.142857e-01 -1.951443e-03
      5234 2001   466_553145 MorisitaHornDiss  5.015578e-02  1.625672e-02
      5235 2001   466_553145   BrayCurtisDiss  6.212400e-01  9.276566e-03
      5236 1986   466_553145      JaccardDiss  5.625000e-01 -1.951443e-03
      5237 1986   466_553145 MorisitaHornDiss  2.586950e-02  1.625672e-02
      5238 1986   466_553145   BrayCurtisDiss  3.030747e-01  9.276566e-03
      5239 1988   466_553145      JaccardDiss  5.294118e-01 -1.951443e-03
      5240 1988   466_553145 MorisitaHornDiss  4.177281e-02  1.625672e-02
      5241 1988   466_553145   BrayCurtisDiss  2.459016e-01  9.276566e-03
      5242 1989   466_553145      JaccardDiss  5.333333e-01 -1.951443e-03
      5243 1989   466_553145 MorisitaHornDiss  4.322437e-02  1.625672e-02
      5244 1989   466_553145   BrayCurtisDiss  2.636615e-01  9.276566e-03
      5245 1990   466_553145      JaccardDiss  4.285714e-01 -1.951443e-03
      5246 1990   466_553145 MorisitaHornDiss  4.471502e-02  1.625672e-02
      5247 1990   466_553145   BrayCurtisDiss  5.342999e-01  9.276566e-03
      5248 1992   466_553145      JaccardDiss  5.000000e-01 -1.951443e-03
      5249 1992   466_553145 MorisitaHornDiss  5.812370e-02  1.625672e-02
      5250 1992   466_553145   BrayCurtisDiss  4.856061e-01  9.276566e-03
      5251 1995   466_553145      JaccardDiss  4.285714e-01 -1.951443e-03
      5252 1995   466_553145 MorisitaHornDiss  5.000194e-02  1.625672e-02
      5253 1995   466_553145   BrayCurtisDiss  4.887247e-01  9.276566e-03
      5254 1999   466_553145      JaccardDiss  4.444444e-01 -1.951443e-03
      5255 1999   466_553145 MorisitaHornDiss  8.438139e-01  1.625672e-02
      5256 1999   466_553145   BrayCurtisDiss  8.910944e-01  9.276566e-03
      5257 2003   466_558966      JaccardDiss  5.000000e-01  6.174105e-03
      5258 2003   466_558966 MorisitaHornDiss  5.643470e-02  4.633222e-04
      5259 2003   466_558966   BrayCurtisDiss  4.101097e-01 -1.644795e-03
      5260 1994   466_558966      JaccardDiss  4.666667e-01  6.174105e-03
      5261 1994   466_558966 MorisitaHornDiss  2.068587e-01  4.633222e-04
      5262 1994   466_558966   BrayCurtisDiss  3.414647e-01 -1.644795e-03
      5263 1995   466_558966      JaccardDiss  4.000000e-01  6.174105e-03
      5264 1995   466_558966 MorisitaHornDiss  8.722989e-02  4.633222e-04
      5265 1995   466_558966   BrayCurtisDiss  3.330664e-01 -1.644795e-03
      5266 1997   466_558966      JaccardDiss  1.666667e-01  6.174105e-03
      5267 1997   466_558966 MorisitaHornDiss  5.081548e-01  4.633222e-04
      5268 1997   466_558966   BrayCurtisDiss  5.137176e-01 -1.644795e-03
      5269 2006   466_558966      JaccardDiss  4.117647e-01  6.174105e-03
      5270 2006   466_558966 MorisitaHornDiss  5.140576e-01  4.633222e-04
      5271 2006   466_558966   BrayCurtisDiss  6.923077e-01 -1.644795e-03
      5272 2007   466_558966      JaccardDiss  4.285714e-01  6.174105e-03
      5273 2007   466_558966 MorisitaHornDiss  6.430996e-02  4.633222e-04
      5274 2007   466_558966   BrayCurtisDiss  3.511568e-01 -1.644795e-03
      5275 2008   466_558966      JaccardDiss  4.285714e-01  6.174105e-03
      5276 2008   466_558966 MorisitaHornDiss  2.248444e-01  4.633222e-04
      5277 2008   466_558966   BrayCurtisDiss  3.496298e-01 -1.644795e-03
      5278 1996   466_558966      JaccardDiss  2.727273e-01  6.174105e-03
      5279 1996   466_558966 MorisitaHornDiss  2.547797e-01  4.633222e-04
      5280 1996   466_558966   BrayCurtisDiss  7.663212e-01 -1.644795e-03
      5281 1999   466_558966      JaccardDiss  5.000000e-01  6.174105e-03
      5282 1999   466_558966 MorisitaHornDiss  1.156789e-01  4.633222e-04
      5283 1999   466_558966   BrayCurtisDiss  4.235798e-01 -1.644795e-03
      5284 2001   466_558966      JaccardDiss  3.333333e-01  6.174105e-03
      5285 2001   466_558966 MorisitaHornDiss  4.142689e-01  4.633222e-04
      5286 2001   466_558966   BrayCurtisDiss  5.373508e-01 -1.644795e-03
      5287 2003   466_550962      JaccardDiss  2.727273e-01 -2.295512e-02
      5288 2003   466_550962 MorisitaHornDiss  5.142993e-01 -1.599981e-02
      5289 2003   466_550962   BrayCurtisDiss  4.822818e-01 -3.077323e-02
      5290 1999   466_550962      JaccardDiss  5.714286e-01 -2.295512e-02
      5291 1999   466_550962 MorisitaHornDiss  2.574130e-01 -1.599981e-02
      5292 1999   466_550962   BrayCurtisDiss  5.387362e-01 -3.077323e-02
      5293 2008   466_550962      JaccardDiss  3.333333e-01 -2.295512e-02
      5294 2008   466_550962 MorisitaHornDiss  3.080848e-02 -1.599981e-02
      5295 2008   466_550962   BrayCurtisDiss  1.937837e-01 -3.077323e-02
      5296 2005   466_550962      JaccardDiss  4.166667e-01 -2.295512e-02
      5297 2005   466_550962 MorisitaHornDiss  6.348068e-01 -1.599981e-02
      5298 2005   466_550962   BrayCurtisDiss  6.252574e-01 -3.077323e-02
      5299 2005   466_556053      JaccardDiss  6.000000e-01  6.642498e-03
      5300 2005   466_556053 MorisitaHornDiss  3.048250e-01  1.127743e-02
      5301 2005   466_556053   BrayCurtisDiss  5.902291e-01  1.505001e-02
      5302 1995   466_556053      JaccardDiss  5.333333e-01  6.642498e-03
      5303 1995   466_556053 MorisitaHornDiss  1.011444e-01  1.127743e-02
      5304 1995   466_556053   BrayCurtisDiss  3.782825e-01  1.505001e-02
      5305 2003   466_556053      JaccardDiss  5.714286e-01  6.642498e-03
      5306 2003   466_556053 MorisitaHornDiss  4.010519e-02  1.127743e-02
      5307 2003   466_556053   BrayCurtisDiss  3.443069e-01  1.505001e-02
      5308 1996   466_556053      JaccardDiss  5.384615e-01  6.642498e-03
      5309 1996   466_556053 MorisitaHornDiss  3.966624e-02  1.127743e-02
      5310 1996   466_556053   BrayCurtisDiss  1.989768e-01  1.505001e-02
      5311 1997   466_556053      JaccardDiss  5.384615e-01  6.642498e-03
      5312 1997   466_556053 MorisitaHornDiss  2.099519e-01  1.127743e-02
      5313 1997   466_556053   BrayCurtisDiss  5.708571e-01  1.505001e-02
      5314 1999   466_556053      JaccardDiss  3.571429e-01  6.642498e-03
      5315 1999   466_556053 MorisitaHornDiss  1.100971e-01  1.127743e-02
      5316 1999   466_556053   BrayCurtisDiss  6.190569e-01  1.505001e-02
      5317 2005   466_560424      JaccardDiss  4.615385e-01 -2.204136e-03
      5318 2005   466_560424 MorisitaHornDiss  3.460344e-02 -2.312653e-02
      5319 2005   466_560424   BrayCurtisDiss  7.966389e-01 -5.924146e-03
      5320 1996   466_560424      JaccardDiss  4.615385e-01 -2.204136e-03
      5321 1996   466_560424 MorisitaHornDiss  2.138867e-02 -2.312653e-02
      5322 1996   466_560424   BrayCurtisDiss  6.471021e-01 -5.924146e-03
      5323 1992   466_560424      JaccardDiss  4.615385e-01 -2.204136e-03
      5324 1992   466_560424 MorisitaHornDiss  4.212265e-01 -2.312653e-02
      5325 1992   466_560424   BrayCurtisDiss  6.703030e-01 -5.924146e-03
      5326 1993   466_560424      JaccardDiss  3.636364e-01 -2.204136e-03
      5327 1993   466_560424 MorisitaHornDiss  1.990931e-02 -2.312653e-02
      5328 1993   466_560424   BrayCurtisDiss  8.024827e-01 -5.924146e-03
      5329 1994   466_560424      JaccardDiss  3.636364e-01 -2.204136e-03
      5330 1994   466_560424 MorisitaHornDiss  3.943032e-01 -2.312653e-02
      5331 1994   466_560424   BrayCurtisDiss  7.898477e-01 -5.924146e-03
      5332 1995   466_560424      JaccardDiss  5.000000e-01 -2.204136e-03
      5333 1995   466_560424 MorisitaHornDiss  2.641173e-01 -2.312653e-02
      5334 1995   466_560424   BrayCurtisDiss  7.855185e-01 -5.924146e-03
      5335 1999   466_560424      JaccardDiss  1.818182e-01 -2.204136e-03
      5336 1999   466_560424 MorisitaHornDiss  1.993717e-02 -2.312653e-02
      5337 1999   466_560424   BrayCurtisDiss  3.168457e-01 -5.924146e-03
      5338 2006   466_549502      JaccardDiss  4.166667e-01 -2.327339e-03
      5339 2006   466_549502 MorisitaHornDiss  1.387833e-01  1.247347e-03
      5340 2006   466_549502   BrayCurtisDiss  2.809541e-01 -3.163443e-03
      5341 2003   466_549502      JaccardDiss  3.076923e-01 -2.327339e-03
      5342 2003   466_549502 MorisitaHornDiss  6.171693e-01  1.247347e-03
      5343 2003   466_549502   BrayCurtisDiss  5.672306e-01 -3.163443e-03
      5344 2007   466_549502      JaccardDiss  4.666667e-01 -2.327339e-03
      5345 2007   466_549502 MorisitaHornDiss  1.850946e-01  1.247347e-03
      5346 2007   466_549502   BrayCurtisDiss  3.296764e-01 -3.163443e-03
      5347 1988   466_549502      JaccardDiss  3.846154e-01 -2.327339e-03
      5348 1988   466_549502 MorisitaHornDiss  4.243499e-01  1.247347e-03
      5349 1988   466_549502   BrayCurtisDiss  5.714700e-01 -3.163443e-03
      5350 1990   466_549502      JaccardDiss  5.384615e-01 -2.327339e-03
      5351 1990   466_549502 MorisitaHornDiss  1.506595e-01  1.247347e-03
      5352 1990   466_549502   BrayCurtisDiss  3.133208e-01 -3.163443e-03
      5353 2002   466_549502      JaccardDiss  4.166667e-01 -2.327339e-03
      5354 2002   466_549502 MorisitaHornDiss  7.618074e-01  1.247347e-03
      5355 2002   466_549502   BrayCurtisDiss  6.926755e-01 -3.163443e-03
      5356 2006   466_550234      JaccardDiss  4.545455e-01 -9.034893e-06
      5357 2006   466_550234 MorisitaHornDiss  6.453005e-01 -2.546814e-02
      5358 2006   466_550234   BrayCurtisDiss  7.585702e-01 -2.449557e-02
      5359 2008   466_550234      JaccardDiss  5.384615e-01 -9.034893e-06
      5360 2008   466_550234 MorisitaHornDiss  3.732479e-02 -2.546814e-02
      5361 2008   466_550234   BrayCurtisDiss  1.600458e-01 -2.449557e-02
      5362 2002   466_550234      JaccardDiss  4.166667e-01 -9.034893e-06
      5363 2002   466_550234 MorisitaHornDiss  2.299193e-02 -2.546814e-02
      5364 2002   466_550234   BrayCurtisDiss  1.582807e-01 -2.449557e-02
      5365 2003   466_550234      JaccardDiss  3.333333e-01 -9.034893e-06
      5366 2003   466_550234 MorisitaHornDiss  1.240679e-01 -2.546814e-02
      5367 2003   466_550234   BrayCurtisDiss  2.756452e-01 -2.449557e-02
      5368 2005   466_550234      JaccardDiss  5.384615e-01 -9.034893e-06
      5369 2005   466_550234 MorisitaHornDiss  1.018397e-01 -2.546814e-02
      5370 2005   466_550234   BrayCurtisDiss  3.035332e-01 -2.449557e-02
      5371 1988   466_550234      JaccardDiss  5.000000e-01 -9.034893e-06
      5372 1988   466_550234 MorisitaHornDiss  7.003942e-01 -2.546814e-02
      5373 1988   466_550234   BrayCurtisDiss  8.214755e-01 -2.449557e-02
      5374 1989   466_542276      JaccardDiss  4.210526e-01 -1.438899e-02
      5375 1989   466_542276 MorisitaHornDiss  2.019598e-01  7.273145e-03
      5376 1989   466_542276   BrayCurtisDiss  4.369474e-01  1.072674e-02
      5377 1987   466_542276      JaccardDiss  4.761905e-01 -1.438899e-02
      5378 1987   466_542276 MorisitaHornDiss  1.970443e-02  7.273145e-03
      5379 1987   466_542276   BrayCurtisDiss  6.342575e-01  1.072674e-02
      5380 2002   466_542276      JaccardDiss  2.500000e-01 -1.438899e-02
      5381 2002   466_542276 MorisitaHornDiss  1.946873e-01  7.273145e-03
      5382 2002   466_542276   BrayCurtisDiss  7.092158e-01  1.072674e-02
      5383 1997   466_565560      JaccardDiss  5.200000e-01  6.297398e-03
      5384 1997   466_565560 MorisitaHornDiss  1.747088e-01 -1.903651e-02
      5385 1997   466_565560   BrayCurtisDiss  5.364807e-01 -1.478078e-02
      5386 1996   466_565560      JaccardDiss  4.800000e-01  6.297398e-03
      5387 1996   466_565560 MorisitaHornDiss  9.751010e-01 -1.903651e-02
      5388 1996   466_565560   BrayCurtisDiss  9.445255e-01 -1.478078e-02
      5389 2003   466_565560      JaccardDiss  4.782609e-01  6.297398e-03
      5390 2003   466_565560 MorisitaHornDiss  9.652094e-01 -1.903651e-02
      5391 2003   466_565560   BrayCurtisDiss  9.079118e-01 -1.478078e-02
      5392 2005   466_565560      JaccardDiss  5.384615e-01  6.297398e-03
      5393 2005   466_565560 MorisitaHornDiss  1.493418e-01 -1.903651e-02
      5394 2005   466_565560   BrayCurtisDiss  3.355482e-01 -1.478078e-02
      5395 1991   466_565560      JaccardDiss  5.714286e-01  6.297398e-03
      5396 1991   466_565560 MorisitaHornDiss  9.416684e-01 -1.903651e-02
      5397 1991   466_565560   BrayCurtisDiss  8.645833e-01 -1.478078e-02
      5398 2000   466_565560      JaccardDiss  6.190476e-01  6.297398e-03
      5399 2000   466_565560 MorisitaHornDiss  9.448731e-01 -1.903651e-02
      5400 2000   466_565560   BrayCurtisDiss  9.846815e-01 -1.478078e-02
      5401 2001   466_565560      JaccardDiss  5.000000e-01  6.297398e-03
      5402 2001   466_565560 MorisitaHornDiss  9.761662e-01 -1.903651e-02
      5403 2001   466_565560   BrayCurtisDiss  9.818581e-01 -1.478078e-02
      5404 2002   466_565560      JaccardDiss  5.833333e-01  6.297398e-03
      5405 2002   466_565560 MorisitaHornDiss  9.217527e-01 -1.903651e-02
      5406 2002   466_565560   BrayCurtisDiss  9.288958e-01 -1.478078e-02
      5407 2004   466_565560      JaccardDiss  5.652174e-01  6.297398e-03
      5408 2004   466_565560 MorisitaHornDiss  9.616505e-01 -1.903651e-02
      5409 2004   466_565560   BrayCurtisDiss  9.387199e-01 -1.478078e-02
      5410 2006   466_565560      JaccardDiss  6.086957e-01  6.297398e-03
      5411 2006   466_565560 MorisitaHornDiss  6.272108e-01 -1.903651e-02
      5412 2006   466_565560   BrayCurtisDiss  6.332255e-01 -1.478078e-02
      5413 2007   466_565560      JaccardDiss  6.800000e-01  6.297398e-03
      5414 2007   466_565560 MorisitaHornDiss  4.000409e-01 -1.903651e-02
      5415 2007   466_565560   BrayCurtisDiss  4.985755e-01 -1.478078e-02
      5416 1986   466_565560      JaccardDiss  4.400000e-01  6.297398e-03
      5417 1986   466_565560 MorisitaHornDiss  9.918093e-01 -1.903651e-02
      5418 1986   466_565560   BrayCurtisDiss  9.448629e-01 -1.478078e-02
      5419 1999   466_553903      JaccardDiss  4.782609e-01 -8.406543e-03
      5420 1999   466_553903 MorisitaHornDiss  1.399917e-01  2.676387e-02
      5421 1999   466_553903   BrayCurtisDiss  2.837647e-01  3.995098e-03
      5422 2001   466_553903      JaccardDiss  5.555556e-01 -8.406543e-03
      5423 2001   466_553903 MorisitaHornDiss  2.958879e-01  2.676387e-02
      5424 2001   466_553903   BrayCurtisDiss  4.156522e-01  3.995098e-03
      5425 2003   466_553903      JaccardDiss  3.461538e-01 -8.406543e-03
      5426 2003   466_553903 MorisitaHornDiss  2.901138e-01  2.676387e-02
      5427 2003   466_553903   BrayCurtisDiss  3.929471e-01  3.995098e-03
      5428 2004   466_553903      JaccardDiss  6.250000e-01 -8.406543e-03
      5429 2004   466_553903 MorisitaHornDiss  3.927344e-01  2.676387e-02
      5430 2004   466_553903   BrayCurtisDiss  5.109573e-01  3.995098e-03
      5431 1997   466_553903      JaccardDiss  5.555556e-01 -8.406543e-03
      5432 1997   466_553903 MorisitaHornDiss  5.281522e-02  2.676387e-02
      5433 1997   466_553903   BrayCurtisDiss  6.125585e-01  3.995098e-03
      5434 2000   466_553903      JaccardDiss  3.913043e-01 -8.406543e-03
      5435 2000   466_553903 MorisitaHornDiss  5.087685e-01  2.676387e-02
      5436 2000   466_553903   BrayCurtisDiss  5.506608e-01  3.995098e-03
      5437 2005   466_553903      JaccardDiss  4.000000e-01 -8.406543e-03
      5438 2005   466_553903 MorisitaHornDiss  5.457191e-01  2.676387e-02
      5439 2005   466_553903   BrayCurtisDiss  6.166957e-01  3.995098e-03
      5440 2006   466_553903      JaccardDiss  4.583333e-01 -8.406543e-03
      5441 2006   466_553903 MorisitaHornDiss  7.849928e-01  2.676387e-02
      5442 2006   466_553903   BrayCurtisDiss  8.421851e-01  3.995098e-03
      5443 2008   466_553903      JaccardDiss  4.545455e-01 -8.406543e-03
      5444 2008   466_553903 MorisitaHornDiss  3.988281e-01  2.676387e-02
      5445 2008   466_553903   BrayCurtisDiss  5.116805e-01  3.995098e-03
      5446 2002   466_553903      JaccardDiss  6.400000e-01 -8.406543e-03
      5447 2002   466_553903 MorisitaHornDiss  4.846224e-01  2.676387e-02
      5448 2002   466_553903   BrayCurtisDiss  7.287879e-01  3.995098e-03
      5449 2007   466_553903      JaccardDiss  4.000000e-01 -8.406543e-03
      5450 2007   466_553903 MorisitaHornDiss  1.291210e-01  2.676387e-02
      5451 2007   466_553903   BrayCurtisDiss  2.882788e-01  3.995098e-03
      5452 2000   466_562645      JaccardDiss  4.000000e-01  1.295038e-06
      5453 2000   466_562645 MorisitaHornDiss  4.065960e-01  1.548090e-03
      5454 2000   466_562645   BrayCurtisDiss  5.283320e-01  1.949124e-03
      5455 2003   466_562645      JaccardDiss  4.347826e-01  1.295038e-06
      5456 2003   466_562645 MorisitaHornDiss  7.056660e-01  1.548090e-03
      5457 2003   466_562645   BrayCurtisDiss  7.072814e-01  1.949124e-03
      5458 2007   466_562645      JaccardDiss  4.800000e-01  1.295038e-06
      5459 2007   466_562645 MorisitaHornDiss  3.931738e-01  1.548090e-03
      5460 2007   466_562645   BrayCurtisDiss  4.976269e-01  1.949124e-03
      5461 2002   466_562645      JaccardDiss  3.750000e-01  1.295038e-06
      5462 2002   466_562645 MorisitaHornDiss  8.934524e-01  1.548090e-03
      5463 2002   466_562645   BrayCurtisDiss  8.358474e-01  1.949124e-03
      5464 1992   466_562645      JaccardDiss  5.000000e-01  1.295038e-06
      5465 1992   466_562645 MorisitaHornDiss  7.295695e-01  1.548090e-03
      5466 1992   466_562645   BrayCurtisDiss  7.284957e-01  1.949124e-03
      5467 1999   466_562645      JaccardDiss  4.347826e-01  1.295038e-06
      5468 1999   466_562645 MorisitaHornDiss  4.194672e-01  1.548090e-03
      5469 1999   466_562645   BrayCurtisDiss  6.668109e-01  1.949124e-03
      5470 2001   466_562645      JaccardDiss  4.285714e-01  1.295038e-06
      5471 2001   466_562645 MorisitaHornDiss  6.048256e-01  1.548090e-03
      5472 2001   466_562645   BrayCurtisDiss  6.915167e-01  1.949124e-03
      5473 2005   466_562645      JaccardDiss  4.285714e-01  1.295038e-06
      5474 2005   466_562645 MorisitaHornDiss  5.680235e-01  1.548090e-03
      5475 2005   466_562645   BrayCurtisDiss  5.944931e-01  1.949124e-03
      5476 2004   466_562645      JaccardDiss  4.166667e-01  1.295038e-06
      5477 2004   466_562645 MorisitaHornDiss  7.421418e-01  1.548090e-03
      5478 2004   466_562645   BrayCurtisDiss  8.143308e-01  1.949124e-03
      5479 2008   466_562645      JaccardDiss  4.545455e-01  1.295038e-06
      5480 2008   466_562645 MorisitaHornDiss  4.011192e-01  1.548090e-03
      5481 2008   466_562645   BrayCurtisDiss  6.851852e-01  1.949124e-03
      5482 1998   466_562645      JaccardDiss  4.736842e-01  1.295038e-06
      5483 1998   466_562645 MorisitaHornDiss  1.844402e-01  1.548090e-03
      5484 1998   466_562645   BrayCurtisDiss  6.216462e-01  1.949124e-03
      5485 2006   466_562645      JaccardDiss  3.809524e-01  1.295038e-06
      5486 2006   466_562645 MorisitaHornDiss  4.791961e-01  1.548090e-03
      5487 2006   466_562645   BrayCurtisDiss  5.631478e-01  1.949124e-03
      5488 1996   466_562645      JaccardDiss  4.500000e-01  1.295038e-06
      5489 1996   466_562645 MorisitaHornDiss  3.973191e-01  1.548090e-03
      5490 1996   466_562645   BrayCurtisDiss  4.244052e-01  1.949124e-03
      5491 1997   466_562645      JaccardDiss  2.608696e-01  1.295038e-06
      5492 1997   466_562645 MorisitaHornDiss  3.757873e-01  1.548090e-03
      5493 1997   466_562645   BrayCurtisDiss  5.459395e-01  1.949124e-03
      5494 2000   466_556817      JaccardDiss  5.600000e-01 -7.014685e-02
      5495 2000   466_556817 MorisitaHornDiss  3.279600e-01  5.164715e-02
      5496 2000   466_556817   BrayCurtisDiss  4.899488e-01  2.040163e-02
      5497 2002   466_556817      JaccardDiss  5.833333e-01 -7.014685e-02
      5498 2002   466_556817 MorisitaHornDiss  6.331766e-02  5.164715e-02
      5499 2002   466_556817   BrayCurtisDiss  4.419684e-01  2.040163e-02
      5500 2001   466_556817      JaccardDiss  5.769231e-01 -7.014685e-02
      5501 2001   466_556817 MorisitaHornDiss  8.828637e-02  5.164715e-02
      5502 2001   466_556817   BrayCurtisDiss  3.646123e-01  2.040163e-02
      5503 2003   466_556817      JaccardDiss  4.500000e-01 -7.014685e-02
      5504 2003   466_556817 MorisitaHornDiss  9.731970e-01  5.164715e-02
      5505 2003   466_556817   BrayCurtisDiss  9.399252e-01  2.040163e-02
      5506 2004   466_556817      JaccardDiss  2.727273e-01 -7.014685e-02
      5507 2004   466_556817 MorisitaHornDiss  1.437405e-01  5.164715e-02
      5508 2004   466_556817   BrayCurtisDiss  3.043005e-01  2.040163e-02
      5509 2000   466_571385      JaccardDiss  4.375000e-01  7.049411e-03
      5510 2000   466_571385 MorisitaHornDiss  7.093410e-01 -2.644278e-02
      5511 2000   466_571385   BrayCurtisDiss  6.907830e-01 -2.457077e-02
      5512 2007   466_571385      JaccardDiss  3.214286e-01  7.049411e-03
      5513 2007   466_571385 MorisitaHornDiss  2.756210e-01 -2.644278e-02
      5514 2007   466_571385   BrayCurtisDiss  4.357204e-01 -2.457077e-02
      5515 2001   466_571385      JaccardDiss  3.333333e-01  7.049411e-03
      5516 2001   466_571385 MorisitaHornDiss  1.441937e-01 -2.644278e-02
      5517 2001   466_571385   BrayCurtisDiss  5.598179e-01 -2.457077e-02
      5518 2002   466_571385      JaccardDiss  4.642857e-01  7.049411e-03
      5519 2002   466_571385 MorisitaHornDiss  4.064963e-01 -2.644278e-02
      5520 2002   466_571385   BrayCurtisDiss  4.814159e-01 -2.457077e-02
      5521 2005   466_571385      JaccardDiss  4.333333e-01  7.049411e-03
      5522 2005   466_571385 MorisitaHornDiss  2.797534e-01 -2.644278e-02
      5523 2005   466_571385   BrayCurtisDiss  5.512821e-01 -2.457077e-02
      5524 2006   466_571385      JaccardDiss  5.483871e-01  7.049411e-03
      5525 2006   466_571385 MorisitaHornDiss  1.144031e-01 -2.644278e-02
      5526 2006   466_571385   BrayCurtisDiss  3.473154e-01 -2.457077e-02
      5527 2008   466_571385      JaccardDiss  5.000000e-01  7.049411e-03
      5528 2008   466_571385 MorisitaHornDiss  4.922791e-01 -2.644278e-02
      5529 2008   466_571385   BrayCurtisDiss  5.441696e-01 -2.457077e-02
      5530 2004   466_571385      JaccardDiss  5.000000e-01  7.049411e-03
      5531 2004   466_571385 MorisitaHornDiss  5.671469e-01 -2.644278e-02
      5532 2004   466_571385   BrayCurtisDiss  6.548721e-01 -2.457077e-02
      5533 2003   466_571385      JaccardDiss  3.928571e-01  7.049411e-03
      5534 2003   466_571385 MorisitaHornDiss  8.081680e-01 -2.644278e-02
      5535 2003   466_571385   BrayCurtisDiss  7.985816e-01 -2.457077e-02
      5536 2000   466_565564      JaccardDiss  3.600000e-01 -4.987458e-03
      5537 2000   466_565564 MorisitaHornDiss  4.438938e-01 -2.921194e-02
      5538 2000   466_565564   BrayCurtisDiss  5.886560e-01 -1.147446e-02
      5539 2004   466_565564      JaccardDiss  3.043478e-01 -4.987458e-03
      5540 2004   466_565564 MorisitaHornDiss  2.160894e-01 -2.921194e-02
      5541 2004   466_565564   BrayCurtisDiss  7.126270e-01 -1.147446e-02
      5542 2006   466_565564      JaccardDiss  3.200000e-01 -4.987458e-03
      5543 2006   466_565564 MorisitaHornDiss  2.204527e-01 -2.921194e-02
      5544 2006   466_565564   BrayCurtisDiss  3.950304e-01 -1.147446e-02
      5545 1997   466_565564      JaccardDiss  4.444444e-01 -4.987458e-03
      5546 1997   466_565564 MorisitaHornDiss  1.092963e-01 -2.921194e-02
      5547 1997   466_565564   BrayCurtisDiss  5.080257e-01 -1.147446e-02
      5548 2005   466_565564      JaccardDiss  5.172414e-01 -4.987458e-03
      5549 2005   466_565564 MorisitaHornDiss  8.561114e-01 -2.921194e-02
      5550 2005   466_565564   BrayCurtisDiss  8.935429e-01 -1.147446e-02
      5551 1992   466_565564      JaccardDiss  5.200000e-01 -4.987458e-03
      5552 1992   466_565564 MorisitaHornDiss  9.561311e-01 -2.921194e-02
      5553 1992   466_565564   BrayCurtisDiss  9.763501e-01 -1.147446e-02
      5554 1994   466_565564      JaccardDiss  3.200000e-01 -4.987458e-03
      5555 1994   466_565564 MorisitaHornDiss  2.660057e-01 -2.921194e-02
      5556 1994   466_565564   BrayCurtisDiss  3.706692e-01 -1.147446e-02
      5557 1999   466_565564      JaccardDiss  4.583333e-01 -4.987458e-03
      5558 1999   466_565564 MorisitaHornDiss  5.375450e-01 -2.921194e-02
      5559 1999   466_565564   BrayCurtisDiss  6.048096e-01 -1.147446e-02
      5560 2008   466_565564      JaccardDiss  4.583333e-01 -4.987458e-03
      5561 2008   466_565564 MorisitaHornDiss  5.509156e-02 -2.921194e-02
      5562 2008   466_565564   BrayCurtisDiss  2.015758e-01 -1.147446e-02
      5563 2003   466_565564      JaccardDiss  4.285714e-01 -4.987458e-03
      5564 2003   466_565564 MorisitaHornDiss  3.073362e-01 -2.921194e-02
      5565 2003   466_565564   BrayCurtisDiss  4.532414e-01 -1.147446e-02
      5566 1995   466_565564      JaccardDiss  5.454545e-01 -4.987458e-03
      5567 1995   466_565564 MorisitaHornDiss  7.636448e-01 -2.921194e-02
      5568 1995   466_565564   BrayCurtisDiss  6.719291e-01 -1.147446e-02
      5569 1996   466_565564      JaccardDiss  4.545455e-01 -4.987458e-03
      5570 1996   466_565564 MorisitaHornDiss  6.784535e-01 -2.921194e-02
      5571 1996   466_565564   BrayCurtisDiss  7.675458e-01 -1.147446e-02
      5572 2007   466_565564      JaccardDiss  3.636364e-01 -4.987458e-03
      5573 2007   466_565564 MorisitaHornDiss  1.783060e-01 -2.921194e-02
      5574 2007   466_565564   BrayCurtisDiss  8.022901e-01 -1.147446e-02
      5575 2001   466_565565      JaccardDiss  3.636364e-01  2.423301e-02
      5576 2001   466_565565 MorisitaHornDiss  8.630011e-01  3.991889e-02
      5577 2001   466_565565   BrayCurtisDiss  7.952065e-01 -2.879694e-03
      5578 1993   466_565565      JaccardDiss  2.500000e-01  2.423301e-02
      5579 1993   466_565565 MorisitaHornDiss  1.320973e-01  3.991889e-02
      5580 1993   466_565565   BrayCurtisDiss  5.147911e-01 -2.879694e-03
      5581 1996   466_565565      JaccardDiss  2.272727e-01  2.423301e-02
      5582 1996   466_565565 MorisitaHornDiss  1.258124e-01  3.991889e-02
      5583 1996   466_565565   BrayCurtisDiss  7.040000e-01 -2.879694e-03
      5584 1998   466_565565      JaccardDiss  2.173913e-01  2.423301e-02
      5585 1998   466_565565 MorisitaHornDiss  3.854076e-02  3.991889e-02
      5586 1998   466_565565   BrayCurtisDiss  5.747898e-01 -2.879694e-03
      5587 2002   466_565565      JaccardDiss  4.782609e-01  2.423301e-02
      5588 2002   466_565565 MorisitaHornDiss  8.676868e-01  3.991889e-02
      5589 2002   466_565565   BrayCurtisDiss  6.957467e-01 -2.879694e-03
      5590 2004   466_565565      JaccardDiss  4.545455e-01  2.423301e-02
      5591 2004   466_565565 MorisitaHornDiss  4.653716e-02  3.991889e-02
      5592 2004   466_565565   BrayCurtisDiss  3.711978e-01 -2.879694e-03
      5593 1999   466_565565      JaccardDiss  4.166667e-01  2.423301e-02
      5594 1999   466_565565 MorisitaHornDiss  4.236659e-01  3.991889e-02
      5595 1999   466_565565   BrayCurtisDiss  5.980606e-01 -2.879694e-03
      5596 2002   466_541532      JaccardDiss  4.166667e-01 -1.257115e-02
      5597 2002   466_541532 MorisitaHornDiss  3.982436e-01  4.978552e-02
      5598 2002   466_541532   BrayCurtisDiss  7.931526e-01  2.486101e-03
      5599 2006   466_541532      JaccardDiss  4.347826e-01 -1.257115e-02
      5600 2006   466_541532 MorisitaHornDiss  8.260065e-01  4.978552e-02
      5601 2006   466_541532   BrayCurtisDiss  9.076625e-01  2.486101e-03
      5602 2007   466_541532      JaccardDiss  3.684211e-01 -1.257115e-02
      5603 2007   466_541532 MorisitaHornDiss  3.734596e-01  4.978552e-02
      5604 2007   466_541532   BrayCurtisDiss  8.708906e-01  2.486101e-03
      5605 2004   466_541532      JaccardDiss  3.684211e-01 -1.257115e-02
      5606 2004   466_541532 MorisitaHornDiss  3.651432e-02  4.978552e-02
      5607 2004   466_541532   BrayCurtisDiss  4.608867e-01  2.486101e-03
      5608 1996   466_541532      JaccardDiss  5.000000e-01 -1.257115e-02
      5609 1996   466_541532 MorisitaHornDiss  1.121794e-01  4.978552e-02
      5610 1996   466_541532   BrayCurtisDiss  7.658828e-01  2.486101e-03
      5611 2003   466_541532      JaccardDiss  5.000000e-01 -1.257115e-02
      5612 2003   466_541532 MorisitaHornDiss  7.268128e-01  4.978552e-02
      5613 2003   466_541532   BrayCurtisDiss  7.297201e-01  2.486101e-03
      5614 2005   466_541532      JaccardDiss  6.363636e-01 -1.257115e-02
      5615 2005   466_541532 MorisitaHornDiss  8.475496e-01  4.978552e-02
      5616 2005   466_541532   BrayCurtisDiss  9.241556e-01  2.486101e-03
      5617 2008   466_541532      JaccardDiss  2.608696e-01 -1.257115e-02
      5618 2008   466_541532 MorisitaHornDiss  8.019978e-01  4.978552e-02
      5619 2008   466_541532   BrayCurtisDiss  6.436860e-01  2.486101e-03
      5620 2003   466_546629      JaccardDiss  4.400000e-01 -8.764503e-03
      5621 2003   466_546629 MorisitaHornDiss  7.729014e-01  4.149174e-02
      5622 2003   466_546629   BrayCurtisDiss  6.139206e-01  2.010270e-02
      5623 1997   466_546629      JaccardDiss  5.454545e-01 -8.764503e-03
      5624 1997   466_546629 MorisitaHornDiss  8.406724e-01  4.149174e-02
      5625 1997   466_546629   BrayCurtisDiss  7.122569e-01  2.010270e-02
      5626 1998   466_546629      JaccardDiss  3.913043e-01 -8.764503e-03
      5627 1998   466_546629 MorisitaHornDiss  1.118011e-02  4.149174e-02
      5628 1998   466_546629   BrayCurtisDiss  1.302404e-01  2.010270e-02
      5629 2003   466_566288      JaccardDiss  3.750000e-01  4.853078e-03
      5630 2003   466_566288 MorisitaHornDiss  9.702173e-01  5.332898e-03
      5631 2003   466_566288   BrayCurtisDiss  9.592750e-01  1.949147e-03
      5632 1993   466_566288      JaccardDiss  5.000000e-01  4.853078e-03
      5633 1993   466_566288 MorisitaHornDiss  4.162951e-03  5.332898e-03
      5634 1993   466_566288   BrayCurtisDiss  2.103115e-01  1.949147e-03
      5635 1996   466_566288      JaccardDiss  1.904762e-01  4.853078e-03
      5636 1996   466_566288 MorisitaHornDiss  5.782270e-02  5.332898e-03
      5637 1996   466_566288   BrayCurtisDiss  8.402073e-01  1.949147e-03
      5638 1997   466_566288      JaccardDiss  5.238095e-01  4.853078e-03
      5639 1997   466_566288 MorisitaHornDiss  7.535126e-01  5.332898e-03
      5640 1997   466_566288   BrayCurtisDiss  8.908755e-01  1.949147e-03
      5641 2004   466_566288      JaccardDiss  4.000000e-01  4.853078e-03
      5642 2004   466_566288 MorisitaHornDiss  9.748428e-01  5.332898e-03
      5643 2004   466_566288   BrayCurtisDiss  9.447895e-01  1.949147e-03
      5644 1987   466_566288      JaccardDiss  3.478261e-01  4.853078e-03
      5645 1987   466_566288 MorisitaHornDiss  9.751909e-01  5.332898e-03
      5646 1987   466_566288   BrayCurtisDiss  9.146919e-01  1.949147e-03
      5647 1994   466_566288      JaccardDiss  3.500000e-01  4.853078e-03
      5648 1994   466_566288 MorisitaHornDiss  9.631062e-01  5.332898e-03
      5649 1994   466_566288   BrayCurtisDiss  9.196843e-01  1.949147e-03
      5650 2005   466_566288      JaccardDiss  5.238095e-01  4.853078e-03
      5651 2005   466_566288 MorisitaHornDiss  9.077448e-04  5.332898e-03
      5652 2005   466_566288   BrayCurtisDiss  2.648592e-01  1.949147e-03
      5653 2008   466_566288      JaccardDiss  4.545455e-01  4.853078e-03
      5654 2008   466_566288 MorisitaHornDiss  9.788795e-01  5.332898e-03
      5655 2008   466_566288   BrayCurtisDiss  9.555556e-01  1.949147e-03
      5656 1999   466_566288      JaccardDiss  4.000000e-01  4.853078e-03
      5657 1999   466_566288 MorisitaHornDiss  9.450675e-01  5.332898e-03
      5658 1999   466_566288   BrayCurtisDiss  8.960625e-01  1.949147e-03
      5659 2006   466_542993      JaccardDiss  4.666667e-01 -3.562373e-02
      5660 2006   466_542993 MorisitaHornDiss  4.872197e-01 -1.128847e-02
      5661 2006   466_542993   BrayCurtisDiss  9.429242e-01  3.080334e-02
      5662 2002   466_542993      JaccardDiss  5.172414e-01 -3.562373e-02
      5663 2002   466_542993 MorisitaHornDiss  9.655345e-01 -1.128847e-02
      5664 2002   466_542993   BrayCurtisDiss  8.525189e-01  3.080334e-02
      5665 2003   466_542993      JaccardDiss  6.333333e-01 -3.562373e-02
      5666 2003   466_542993 MorisitaHornDiss  4.990105e-01 -1.128847e-02
      5667 2003   466_542993   BrayCurtisDiss  6.808707e-01  3.080334e-02
      5668 2007   466_542993      JaccardDiss  3.750000e-01 -3.562373e-02
      5669 2007   466_542993 MorisitaHornDiss  8.958474e-01 -1.128847e-02
      5670 2007   466_542993   BrayCurtisDiss  9.047495e-01  3.080334e-02
      5671 2002   466_542258      JaccardDiss  5.000000e-01  2.908177e-05
      5672 2002   466_542258 MorisitaHornDiss  4.997818e-02 -4.714018e-03
      5673 2002   466_542258   BrayCurtisDiss  4.884560e-01  8.237754e-03
      5674 2004   466_542258      JaccardDiss  6.111111e-01  2.908177e-05
      5675 2004   466_542258 MorisitaHornDiss  9.478486e-01 -4.714018e-03
      5676 2004   466_542258   BrayCurtisDiss  9.244375e-01  8.237754e-03
      5677 1991   466_542258      JaccardDiss  5.000000e-01  2.908177e-05
      5678 1991   466_542258 MorisitaHornDiss  6.514570e-01 -4.714018e-03
      5679 1991   466_542258   BrayCurtisDiss  6.657218e-01  8.237754e-03
      5680 1995   466_542258      JaccardDiss  6.250000e-01  2.908177e-05
      5681 1995   466_542258 MorisitaHornDiss  4.730230e-01 -4.714018e-03
      5682 1995   466_542258   BrayCurtisDiss  6.552352e-01  8.237754e-03
      5683 1996   466_542258      JaccardDiss  6.000000e-01  2.908177e-05
      5684 1996   466_542258 MorisitaHornDiss  2.441228e-02 -4.714018e-03
      5685 1996   466_542258   BrayCurtisDiss  6.464646e-01  8.237754e-03
      5686 2003   466_542258      JaccardDiss  5.500000e-01  2.908177e-05
      5687 2003   466_542258 MorisitaHornDiss  2.876115e-02 -4.714018e-03
      5688 2003   466_542258   BrayCurtisDiss  2.423881e-01  8.237754e-03
      5689 2005   466_542258      JaccardDiss  5.555556e-01  2.908177e-05
      5690 2005   466_542258 MorisitaHornDiss  4.773499e-02 -4.714018e-03
      5691 2005   466_542258   BrayCurtisDiss  4.421513e-01  8.237754e-03
      5692 2006   466_542258      JaccardDiss  5.555556e-01  2.908177e-05
      5693 2006   466_542258 MorisitaHornDiss  1.008714e-01 -4.714018e-03
      5694 2006   466_542258   BrayCurtisDiss  9.034355e-01  8.237754e-03
      5695 2007   466_542258      JaccardDiss  6.666667e-01  2.908177e-05
      5696 2007   466_542258 MorisitaHornDiss  1.381859e-02 -4.714018e-03
      5697 2007   466_542258   BrayCurtisDiss  7.429175e-01  8.237754e-03
      5698 2008   466_542258      JaccardDiss  4.666667e-01  2.908177e-05
      5699 2008   466_542258 MorisitaHornDiss  9.501947e-01 -4.714018e-03
      5700 2008   466_542258   BrayCurtisDiss  9.155816e-01  8.237754e-03
      5701 1991   466_564839      JaccardDiss  4.400000e-01  1.356043e-02
      5702 1991   466_564839 MorisitaHornDiss  6.169673e-02 -1.580292e-02
      5703 1991   466_564839   BrayCurtisDiss  3.843544e-01 -2.001872e-03
      5704 1986   466_564839      JaccardDiss  2.608696e-01  1.356043e-02
      5705 1986   466_564839 MorisitaHornDiss  9.501377e-01 -1.580292e-02
      5706 1986   466_564839   BrayCurtisDiss  8.668478e-01 -2.001872e-03
      5707 1989   466_564839      JaccardDiss  4.090909e-01  1.356043e-02
      5708 1989   466_564839 MorisitaHornDiss  8.193850e-01 -1.580292e-02
      5709 1989   466_564839   BrayCurtisDiss  8.254426e-01 -2.001872e-03
      5710 1995   466_564839      JaccardDiss  4.545455e-01  1.356043e-02
      5711 1995   466_564839 MorisitaHornDiss  9.206244e-01 -1.580292e-02
      5712 1995   466_564839   BrayCurtisDiss  8.826653e-01 -2.001872e-03
      5713 1987   466_564839      JaccardDiss  4.583333e-01  1.356043e-02
      5714 1987   466_564839 MorisitaHornDiss  7.518192e-01 -1.580292e-02
      5715 1987   466_564839   BrayCurtisDiss  6.888718e-01 -2.001872e-03
      5716 1993   466_558274      JaccardDiss  6.400000e-01 -3.488915e-04
      5717 1993   466_558274 MorisitaHornDiss  9.990795e-01  4.022079e-03
      5718 1993   466_558274   BrayCurtisDiss  9.795155e-01 -1.213371e-03
      5719 2005   466_558274      JaccardDiss  6.774194e-01 -3.488915e-04
      5720 2005   466_558274 MorisitaHornDiss  9.970008e-01  4.022079e-03
      5721 2005   466_558274   BrayCurtisDiss  9.183246e-01 -1.213371e-03
      5722 1992   466_558274      JaccardDiss  7.500000e-01 -3.488915e-04
      5723 1992   466_558274 MorisitaHornDiss  9.984321e-01  4.022079e-03
      5724 1992   466_558274   BrayCurtisDiss  9.740566e-01 -1.213371e-03
      5725 2007   466_558274      JaccardDiss  6.923077e-01 -3.488915e-04
      5726 2007   466_558274 MorisitaHornDiss  9.999151e-01  4.022079e-03
      5727 2007   466_558274   BrayCurtisDiss  9.969228e-01 -1.213371e-03
      5728 2008   466_558274      JaccardDiss  6.956522e-01 -3.488915e-04
      5729 2008   466_558274 MorisitaHornDiss  9.840529e-01  4.022079e-03
      5730 2008   466_558274   BrayCurtisDiss  9.160187e-01 -1.213371e-03
      5731 1986   466_558274      JaccardDiss  6.000000e-01 -3.488915e-04
      5732 1986   466_558274 MorisitaHornDiss  9.828201e-01  4.022079e-03
      5733 1986   466_558274   BrayCurtisDiss  9.521484e-01 -1.213371e-03
      5734 1996   466_558274      JaccardDiss  7.200000e-01 -3.488915e-04
      5735 1996   466_558274 MorisitaHornDiss  9.964106e-01  4.022079e-03
      5736 1996   466_558274   BrayCurtisDiss  9.642538e-01 -1.213371e-03
      5737 1999   466_558274      JaccardDiss  6.818182e-01 -3.488915e-04
      5738 1999   466_558274 MorisitaHornDiss  9.994931e-01  4.022079e-03
      5739 1999   466_558274   BrayCurtisDiss  9.750708e-01 -1.213371e-03
      5740 2001   466_558274      JaccardDiss  6.190476e-01 -3.488915e-04
      5741 2001   466_558274 MorisitaHornDiss  9.941288e-01  4.022079e-03
      5742 2001   466_558274   BrayCurtisDiss  9.499218e-01 -1.213371e-03
      5743 2002   466_558274      JaccardDiss  6.363636e-01 -3.488915e-04
      5744 2002   466_558274 MorisitaHornDiss  9.966063e-01  4.022079e-03
      5745 2002   466_558274   BrayCurtisDiss  9.367470e-01 -1.213371e-03
      5746 2004   466_558274      JaccardDiss  7.200000e-01 -3.488915e-04
      5747 2004   466_558274 MorisitaHornDiss  9.989259e-01  4.022079e-03
      5748 2004   466_558274   BrayCurtisDiss  9.645036e-01 -1.213371e-03
      5749 2006   466_558274      JaccardDiss  5.714286e-01 -3.488915e-04
      5750 2006   466_558274 MorisitaHornDiss  9.767494e-01  4.022079e-03
      5751 2006   466_558274   BrayCurtisDiss  9.150402e-01 -1.213371e-03
      5752 1995   466_558274      JaccardDiss  7.826087e-01 -3.488915e-04
      5753 1995   466_558274 MorisitaHornDiss  9.993341e-01  4.022079e-03
      5754 1995   466_558274   BrayCurtisDiss  9.808195e-01 -1.213371e-03
      5755 1997   466_558274      JaccardDiss  6.296296e-01 -3.488915e-04
      5756 1997   466_558274 MorisitaHornDiss  3.253917e-02  4.022079e-03
      5757 1997   466_558274   BrayCurtisDiss  8.516309e-01 -1.213371e-03
      5758 1994   466_541535      JaccardDiss  2.962963e-01  2.283507e-03
      5759 1994   466_541535 MorisitaHornDiss  2.221055e-01  1.147045e-02
      5760 1994   466_541535   BrayCurtisDiss  4.618488e-01  1.061172e-02
      5761 1987   466_541535      JaccardDiss  3.846154e-01  2.283507e-03
      5762 1987   466_541535 MorisitaHornDiss  5.342354e-02  1.147045e-02
      5763 1987   466_541535   BrayCurtisDiss  5.335877e-01  1.061172e-02
      5764 1990   466_541535      JaccardDiss  4.615385e-01  2.283507e-03
      5765 1990   466_541535 MorisitaHornDiss  3.234408e-01  1.147045e-02
      5766 1990   466_541535   BrayCurtisDiss  5.635052e-01  1.061172e-02
      5767 1991   466_541535      JaccardDiss  3.750000e-01  2.283507e-03
      5768 1991   466_541535 MorisitaHornDiss  5.778568e-02  1.147045e-02
      5769 1991   466_541535   BrayCurtisDiss  2.409368e-01  1.061172e-02
      5770 2002   466_541535      JaccardDiss  3.846154e-01  2.283507e-03
      5771 2002   466_541535 MorisitaHornDiss  3.867680e-01  1.147045e-02
      5772 2002   466_541535   BrayCurtisDiss  7.034855e-01  1.061172e-02
      5773 2003   466_541535      JaccardDiss  4.615385e-01  2.283507e-03
      5774 2003   466_541535 MorisitaHornDiss  7.789838e-01  1.147045e-02
      5775 2003   466_541535   BrayCurtisDiss  7.571066e-01  1.061172e-02
      5776 2004   466_541535      JaccardDiss  5.000000e-01  2.283507e-03
      5777 2004   466_541535 MorisitaHornDiss  4.566387e-02  1.147045e-02
      5778 2004   466_541535   BrayCurtisDiss  5.190274e-01  1.061172e-02
      5779 1988   466_541535      JaccardDiss  5.652174e-01  2.283507e-03
      5780 1988   466_541535 MorisitaHornDiss  5.722225e-01  1.147045e-02
      5781 1988   466_541535   BrayCurtisDiss  6.544939e-01  1.061172e-02
      5782 1989   466_541535      JaccardDiss  2.962963e-01  2.283507e-03
      5783 1989   466_541535 MorisitaHornDiss  7.491712e-02  1.147045e-02
      5784 1989   466_541535   BrayCurtisDiss  3.791754e-01  1.061172e-02
      5785 1996   466_568472      JaccardDiss  4.347826e-01  5.741980e-03
      5786 1996   466_568472 MorisitaHornDiss  8.151742e-01 -7.163903e-03
      5787 1996   466_568472   BrayCurtisDiss  7.181943e-01 -1.531253e-03
      5788 1987   466_568472      JaccardDiss  4.444444e-01  5.741980e-03
      5789 1987   466_568472 MorisitaHornDiss  6.264828e-01 -7.163903e-03
      5790 1987   466_568472   BrayCurtisDiss  5.377268e-01 -1.531253e-03
      5791 1991   466_568472      JaccardDiss  3.461538e-01  5.741980e-03
      5792 1991   466_568472 MorisitaHornDiss  4.927071e-01 -7.163903e-03
      5793 1991   466_568472   BrayCurtisDiss  4.925075e-01 -1.531253e-03
      5794 1992   466_568472      JaccardDiss  4.230769e-01  5.741980e-03
      5795 1992   466_568472 MorisitaHornDiss  6.489986e-01 -7.163903e-03
      5796 1992   466_568472   BrayCurtisDiss  6.056587e-01 -1.531253e-03
      5797 1993   466_568472      JaccardDiss  3.750000e-01  5.741980e-03
      5798 1993   466_568472 MorisitaHornDiss  1.461995e-01 -7.163903e-03
      5799 1993   466_568472   BrayCurtisDiss  5.259922e-01 -1.531253e-03
      5800 1994   466_568472      JaccardDiss  1.739130e-01  5.741980e-03
      5801 1994   466_568472 MorisitaHornDiss  8.351083e-02 -7.163903e-03
      5802 1994   466_568472   BrayCurtisDiss  2.848665e-01 -1.531253e-03
      5803 1997   466_568472      JaccardDiss  3.200000e-01  5.741980e-03
      5804 1997   466_568472 MorisitaHornDiss  4.837407e-01 -7.163903e-03
      5805 1997   466_568472   BrayCurtisDiss  5.932679e-01 -1.531253e-03
      5806 1999   466_568472      JaccardDiss  5.000000e-01  5.741980e-03
      5807 1999   466_568472 MorisitaHornDiss  7.493591e-01 -7.163903e-03
      5808 1999   466_568472   BrayCurtisDiss  7.238403e-01 -1.531253e-03
      5809 2002   466_568472      JaccardDiss  4.000000e-01  5.741980e-03
      5810 2002   466_568472 MorisitaHornDiss  7.196083e-01 -7.163903e-03
      5811 2002   466_568472   BrayCurtisDiss  6.433365e-01 -1.531253e-03
      5812 1995   466_568472      JaccardDiss  8.095238e-01  5.741980e-03
      5813 1995   466_568472 MorisitaHornDiss  9.118489e-01 -7.163903e-03
      5814 1995   466_568472   BrayCurtisDiss  9.558824e-01 -1.531253e-03
      5815 2000   466_568472      JaccardDiss  6.000000e-01  5.741980e-03
      5816 2000   466_568472 MorisitaHornDiss  2.333710e-01 -7.163903e-03
      5817 2000   466_568472   BrayCurtisDiss  5.470968e-01 -1.531253e-03
      5818 2004   466_568472      JaccardDiss  4.545455e-01  5.741980e-03
      5819 2004   466_568472 MorisitaHornDiss  4.428694e-01 -7.163903e-03
      5820 2004   466_568472   BrayCurtisDiss  5.485961e-01 -1.531253e-03
      5821 2005   466_568472      JaccardDiss  5.600000e-01  5.741980e-03
      5822 2005   466_568472 MorisitaHornDiss  4.392089e-01 -7.163903e-03
      5823 2005   466_568472   BrayCurtisDiss  4.862543e-01 -1.531253e-03
      5824 2006   466_568472      JaccardDiss  5.769231e-01  5.741980e-03
      5825 2006   466_568472 MorisitaHornDiss  6.350899e-01 -7.163903e-03
      5826 2006   466_568472   BrayCurtisDiss  6.085919e-01 -1.531253e-03
      5827 1986   466_568472      JaccardDiss  4.285714e-01  5.741980e-03
      5828 1986   466_568472 MorisitaHornDiss  6.358253e-01 -7.163903e-03
      5829 1986   466_568472   BrayCurtisDiss  7.105943e-01 -1.531253e-03
      5830 1989   466_568472      JaccardDiss  4.761905e-01  5.741980e-03
      5831 1989   466_568472 MorisitaHornDiss  5.829397e-01 -7.163903e-03
      5832 1989   466_568472   BrayCurtisDiss  6.195122e-01 -1.531253e-03
      5833 2001   466_568472      JaccardDiss  4.545455e-01  5.741980e-03
      5834 2001   466_568472 MorisitaHornDiss  6.479875e-01 -7.163903e-03
      5835 2001   466_568472   BrayCurtisDiss  7.922849e-01 -1.531253e-03
      5836 2007   466_568472      JaccardDiss  5.000000e-01  5.741980e-03
      5837 2007   466_568472 MorisitaHornDiss  6.543596e-02 -7.163903e-03
      5838 2007   466_568472   BrayCurtisDiss  4.723757e-01 -1.531253e-03
      5839 1997   466_561929      JaccardDiss  3.703704e-01  6.798114e-03
      5840 1997   466_561929 MorisitaHornDiss  2.565391e-01 -2.967797e-02
      5841 1997   466_561929   BrayCurtisDiss  5.147291e-01 -2.713978e-02
      5842 2002   466_561929      JaccardDiss  5.714286e-01  6.798114e-03
      5843 2002   466_561929 MorisitaHornDiss  7.839734e-01 -2.967797e-02
      5844 2002   466_561929   BrayCurtisDiss  9.415608e-01 -2.713978e-02
      5845 2006   466_561929      JaccardDiss  3.913043e-01  6.798114e-03
      5846 2006   466_561929 MorisitaHornDiss  4.838802e-02 -2.967797e-02
      5847 2006   466_561929   BrayCurtisDiss  2.710190e-01 -2.713978e-02
      5848 2000   466_561929      JaccardDiss  3.333333e-01  6.798114e-03
      5849 2000   466_561929 MorisitaHornDiss  7.670418e-01 -2.967797e-02
      5850 2000   466_561929   BrayCurtisDiss  7.554331e-01 -2.713978e-02
      5851 2001   466_561929      JaccardDiss  4.444444e-01  6.798114e-03
      5852 2001   466_561929 MorisitaHornDiss  6.587204e-01 -2.967797e-02
      5853 2001   466_561929   BrayCurtisDiss  7.367039e-01 -2.713978e-02
      5854 1998   466_568473      JaccardDiss  5.000000e-01 -3.818182e-03
      5855 1998   466_568473 MorisitaHornDiss  9.726339e-01 -3.585546e-02
      5856 1998   466_568473   BrayCurtisDiss  8.793503e-01 -1.465479e-02
      5857 2008   466_568473      JaccardDiss  5.600000e-01 -3.818182e-03
      5858 2008   466_568473 MorisitaHornDiss  2.552240e-01 -3.585546e-02
      5859 2008   466_568473   BrayCurtisDiss  6.271605e-01 -1.465479e-02
      5860 1988   466_568473      JaccardDiss  6.363636e-01 -3.818182e-03
      5861 1988   466_568473 MorisitaHornDiss  9.723332e-01 -3.585546e-02
      5862 1988   466_568473   BrayCurtisDiss  9.202563e-01 -1.465479e-02
      5863 2001   466_553907      JaccardDiss  3.846154e-01  2.715259e-03
      5864 2001   466_553907 MorisitaHornDiss  1.398363e-01 -6.624911e-05
      5865 2001   466_553907   BrayCurtisDiss  4.894804e-01 -3.452460e-03
      5866 1986   466_553907      JaccardDiss  3.461538e-01  2.715259e-03
      5867 1986   466_553907 MorisitaHornDiss  5.437599e-01 -6.624911e-05
      5868 1986   466_553907   BrayCurtisDiss  8.873239e-01 -3.452460e-03
      5869 1992   466_553907      JaccardDiss  4.074074e-01  2.715259e-03
      5870 1992   466_553907 MorisitaHornDiss  3.719420e-01 -6.624911e-05
      5871 1992   466_553907   BrayCurtisDiss  7.594135e-01 -3.452460e-03
      5872 1993   466_553907      JaccardDiss  3.333333e-01  2.715259e-03
      5873 1993   466_553907 MorisitaHornDiss  3.330940e-01 -6.624911e-05
      5874 1993   466_553907   BrayCurtisDiss  7.430564e-01 -3.452460e-03
      5875 1996   466_553907      JaccardDiss  2.500000e-01  2.715259e-03
      5876 1996   466_553907 MorisitaHornDiss  2.439765e-01 -6.624911e-05
      5877 1996   466_553907   BrayCurtisDiss  5.005917e-01 -3.452460e-03
      5878 1999   466_553907      JaccardDiss  4.400000e-01  2.715259e-03
      5879 1999   466_553907 MorisitaHornDiss  5.484489e-01 -6.624911e-05
      5880 1999   466_553907   BrayCurtisDiss  7.902275e-01 -3.452460e-03
      5881 2000   466_553907      JaccardDiss  3.600000e-01  2.715259e-03
      5882 2000   466_553907 MorisitaHornDiss  5.394857e-01 -6.624911e-05
      5883 2000   466_553907   BrayCurtisDiss  6.552984e-01 -3.452460e-03
      5884 2003   466_553907      JaccardDiss  5.200000e-01  2.715259e-03
      5885 2003   466_553907 MorisitaHornDiss  3.097374e-01 -6.624911e-05
      5886 2003   466_553907   BrayCurtisDiss  3.976420e-01 -3.452460e-03
      5887 2004   466_553907      JaccardDiss  4.347826e-01  2.715259e-03
      5888 2004   466_553907 MorisitaHornDiss  1.945888e-01 -6.624911e-05
      5889 2004   466_553907   BrayCurtisDiss  3.135725e-01 -3.452460e-03
      5890 2005   466_553907      JaccardDiss  4.000000e-01  2.715259e-03
      5891 2005   466_553907 MorisitaHornDiss  2.470068e-01 -6.624911e-05
      5892 2005   466_553907   BrayCurtisDiss  4.123847e-01 -3.452460e-03
      5893 2007   466_553907      JaccardDiss  5.000000e-01  2.715259e-03
      5894 2007   466_553907 MorisitaHornDiss  3.385757e-01 -6.624911e-05
      5895 2007   466_553907   BrayCurtisDiss  8.281718e-01 -3.452460e-03
      5896 1987   466_553907      JaccardDiss  4.782609e-01  2.715259e-03
      5897 1987   466_553907 MorisitaHornDiss  2.480184e-01 -6.624911e-05
      5898 1987   466_553907   BrayCurtisDiss  4.314323e-01 -3.452460e-03
      5899 1989   466_553907      JaccardDiss  4.800000e-01  2.715259e-03
      5900 1989   466_553907 MorisitaHornDiss  3.251763e-01 -6.624911e-05
      5901 1989   466_553907   BrayCurtisDiss  5.346722e-01 -3.452460e-03
      5902 2002   466_553907      JaccardDiss  5.384615e-01  2.715259e-03
      5903 2002   466_553907 MorisitaHornDiss  3.135851e-01 -6.624911e-05
      5904 2002   466_553907   BrayCurtisDiss  6.775539e-01 -3.452460e-03
      5905 2006   466_553907      JaccardDiss  4.074074e-01  2.715259e-03
      5906 2006   466_553907 MorisitaHornDiss  7.156444e-01 -6.624911e-05
      5907 2006   466_553907   BrayCurtisDiss  8.232952e-01 -3.452460e-03
      5908 2002   466_564114      JaccardDiss  4.400000e-01 -5.049218e-03
      5909 2002   466_564114 MorisitaHornDiss  6.529107e-01 -1.331742e-02
      5910 2002   466_564114   BrayCurtisDiss  7.196885e-01  1.324963e-02
      5911 2005   466_564114      JaccardDiss  6.250000e-01 -5.049218e-03
      5912 2005   466_564114 MorisitaHornDiss  8.491216e-01 -1.331742e-02
      5913 2005   466_564114   BrayCurtisDiss  7.456464e-01  1.324963e-02
      5914 2004   466_564114      JaccardDiss  5.185185e-01 -5.049218e-03
      5915 2004   466_564114 MorisitaHornDiss  6.699978e-01 -1.331742e-02
      5916 2004   466_564114   BrayCurtisDiss  6.380729e-01  1.324963e-02
      5917 2006   466_564114      JaccardDiss  5.200000e-01 -5.049218e-03
      5918 2006   466_564114 MorisitaHornDiss  7.346048e-01 -1.331742e-02
      5919 2006   466_564114   BrayCurtisDiss  7.771907e-01  1.324963e-02
      5920 2007   466_564114      JaccardDiss  4.347826e-01 -5.049218e-03
      5921 2007   466_564114 MorisitaHornDiss  9.593669e-02 -1.331742e-02
      5922 2007   466_564114   BrayCurtisDiss  5.437956e-01  1.324963e-02
      5923 2001   466_564114      JaccardDiss  4.615385e-01 -5.049218e-03
      5924 2001   466_564114 MorisitaHornDiss  5.467883e-01 -1.331742e-02
      5925 2001   466_564114   BrayCurtisDiss  4.990654e-01  1.324963e-02
      5926 2003   466_564114      JaccardDiss  4.347826e-01 -5.049218e-03
      5927 2003   466_564114 MorisitaHornDiss  9.240929e-01 -1.331742e-02
      5928 2003   466_564114   BrayCurtisDiss  8.565985e-01  1.324963e-02
      5929 2008   466_564114      JaccardDiss  3.529412e-01 -5.049218e-03
      5930 2008   466_564114 MorisitaHornDiss  8.404379e-01 -1.331742e-02
      5931 2008   466_564114   BrayCurtisDiss  8.023631e-01  1.324963e-02
      5932 1990   466_564831      JaccardDiss  5.909091e-01 -8.373206e-03
      5933 1990   466_564831 MorisitaHornDiss  9.288958e-01 -3.023311e-02
      5934 1990   466_564831   BrayCurtisDiss  9.059829e-01 -2.580806e-02
      5935 2002   466_564831      JaccardDiss  6.818182e-01 -8.373206e-03
      5936 2002   466_564831 MorisitaHornDiss  9.520429e-01 -3.023311e-02
      5937 2002   466_564831   BrayCurtisDiss  9.088905e-01 -2.580806e-02
      5938 2001   466_564831      JaccardDiss  2.500000e-01 -8.373206e-03
      5939 2001   466_564831 MorisitaHornDiss  9.460386e-02 -3.023311e-02
      5940 2001   466_564831   BrayCurtisDiss  2.157086e-01 -2.580806e-02
      5941 1986   466_545908      JaccardDiss  4.347826e-01  2.498283e-03
      5942 1986   466_545908 MorisitaHornDiss  4.033939e-01 -1.721705e-03
      5943 1986   466_545908   BrayCurtisDiss  4.978784e-01 -4.832561e-03
      5944 1988   466_545908      JaccardDiss  3.913043e-01  2.498283e-03
      5945 1988   466_545908 MorisitaHornDiss  9.219058e-03 -1.721705e-03
      5946 1988   466_545908   BrayCurtisDiss  2.947217e-01 -4.832561e-03
      5947 1991   466_545908      JaccardDiss  3.846154e-01  2.498283e-03
      5948 1991   466_545908 MorisitaHornDiss  2.454193e-02 -1.721705e-03
      5949 1991   466_545908   BrayCurtisDiss  6.393374e-01 -4.832561e-03
      5950 1994   466_545908      JaccardDiss  4.782609e-01  2.498283e-03
      5951 1994   466_545908 MorisitaHornDiss  7.429304e-02 -1.721705e-03
      5952 1994   466_545908   BrayCurtisDiss  2.273152e-01 -4.832561e-03
      5953 1997   466_545908      JaccardDiss  3.636364e-01  2.498283e-03
      5954 1997   466_545908 MorisitaHornDiss  6.160838e-03 -1.721705e-03
      5955 1997   466_545908   BrayCurtisDiss  1.323256e-01 -4.832561e-03
      5956 2001   466_545908      JaccardDiss  5.416667e-01  2.498283e-03
      5957 2001   466_545908 MorisitaHornDiss  2.348151e-01 -1.721705e-03
      5958 2001   466_545908   BrayCurtisDiss  3.688620e-01 -4.832561e-03
      5959 2005   466_545908      JaccardDiss  5.454545e-01  2.498283e-03
      5960 2005   466_545908 MorisitaHornDiss  2.568344e-01 -1.721705e-03
      5961 2005   466_545908   BrayCurtisDiss  4.123872e-01 -4.832561e-03
      5962 1987   466_545908      JaccardDiss  4.545455e-01  2.498283e-03
      5963 1987   466_545908 MorisitaHornDiss  7.782864e-01 -1.721705e-03
      5964 1987   466_545908   BrayCurtisDiss  7.793779e-01 -4.832561e-03
      5965 2006   466_545908      JaccardDiss  3.684211e-01  2.498283e-03
      5966 2006   466_545908 MorisitaHornDiss  4.810572e-01 -1.721705e-03
      5967 2006   466_545908   BrayCurtisDiss  6.073620e-01 -4.832561e-03
      5968 1996   466_550992      JaccardDiss  2.400000e-01  2.539930e-03
      5969 1996   466_550992 MorisitaHornDiss  1.196729e-01 -7.720058e-04
      5970 1996   466_550992   BrayCurtisDiss  4.840465e-01 -2.682994e-03
      5971 1997   466_550992      JaccardDiss  3.703704e-01  2.539930e-03
      5972 1997   466_550992 MorisitaHornDiss  5.133270e-01 -7.720058e-04
      5973 1997   466_550992   BrayCurtisDiss  7.825636e-01 -2.682994e-03
      5974 1999   466_550992      JaccardDiss  4.230769e-01  2.539930e-03
      5975 1999   466_550992 MorisitaHornDiss  4.866628e-01 -7.720058e-04
      5976 1999   466_550992   BrayCurtisDiss  7.466657e-01 -2.682994e-03
      5977 2001   466_550992      JaccardDiss  4.137931e-01  2.539930e-03
      5978 2001   466_550992 MorisitaHornDiss  2.693700e-01 -7.720058e-04
      5979 2001   466_550992   BrayCurtisDiss  4.492326e-01 -2.682994e-03
      5980 1986   466_550992      JaccardDiss  5.833333e-01  2.539930e-03
      5981 1986   466_550992 MorisitaHornDiss  3.879672e-01 -7.720058e-04
      5982 1986   466_550992   BrayCurtisDiss  8.755033e-01 -2.682994e-03
      5983 2005   466_550992      JaccardDiss  5.200000e-01  2.539930e-03
      5984 2005   466_550992 MorisitaHornDiss  2.636316e-01 -7.720058e-04
      5985 2005   466_550992   BrayCurtisDiss  8.075561e-01 -2.682994e-03
      5986 2007   466_550992      JaccardDiss  4.230769e-01  2.539930e-03
      5987 2007   466_550992 MorisitaHornDiss  1.629212e-01 -7.720058e-04
      5988 2007   466_550992   BrayCurtisDiss  3.979513e-01 -2.682994e-03
      5989 1987   466_550992      JaccardDiss  5.217391e-01  2.539930e-03
      5990 1987   466_550992 MorisitaHornDiss  3.345280e-01 -7.720058e-04
      5991 1987   466_550992   BrayCurtisDiss  4.917154e-01 -2.682994e-03
      5992 1989   466_550992      JaccardDiss  5.000000e-01  2.539930e-03
      5993 1989   466_550992 MorisitaHornDiss  2.530599e-01 -7.720058e-04
      5994 1989   466_550992   BrayCurtisDiss  6.885544e-01 -2.682994e-03
      5995 2003   466_550992      JaccardDiss  3.913043e-01  2.539930e-03
      5996 2003   466_550992 MorisitaHornDiss  5.824355e-01 -7.720058e-04
      5997 2003   466_550992   BrayCurtisDiss  7.882480e-01 -2.682994e-03
      5998 2004   466_550992      JaccardDiss  5.769231e-01  2.539930e-03
      5999 2004   466_550992 MorisitaHornDiss  7.803128e-01 -7.720058e-04
      6000 2004   466_550992   BrayCurtisDiss  9.078229e-01 -2.682994e-03
      6001 2006   466_550992      JaccardDiss  6.956522e-01  2.539930e-03
      6002 2006   466_550992 MorisitaHornDiss  2.164038e-02 -7.720058e-04
      6003 2006   466_550992   BrayCurtisDiss  6.764624e-01 -2.682994e-03
      6004 1991   466_550992      JaccardDiss  2.400000e-01  2.539930e-03
      6005 1991   466_550992 MorisitaHornDiss  3.670239e-01 -7.720058e-04
      6006 1991   466_550992   BrayCurtisDiss  8.740810e-01 -2.682994e-03
      6007 1986   466_569932      JaccardDiss  4.400000e-01  4.086957e-02
      6008 1986   466_569932 MorisitaHornDiss  7.582846e-01 -2.588588e-02
      6009 1986   466_569932   BrayCurtisDiss  7.943810e-01 -1.511925e-02
      6010 1987   466_569932      JaccardDiss  3.888889e-01  4.086957e-02
      6011 1987   466_569932 MorisitaHornDiss  2.788731e-02 -2.588588e-02
      6012 1987   466_569932   BrayCurtisDiss  2.180451e-01 -1.511925e-02
      6013 1988   466_569932      JaccardDiss  5.217391e-01  4.086957e-02
      6014 1988   466_569932 MorisitaHornDiss  7.065129e-01 -2.588588e-02
      6015 1988   466_569932   BrayCurtisDiss  7.641425e-01 -1.511925e-02
      6016 1986   466_556102      JaccardDiss  3.913043e-01 -1.656315e-02
      6017 1986   466_556102 MorisitaHornDiss  8.063975e-03  3.667825e-02
      6018 1986   466_556102   BrayCurtisDiss  7.514747e-01  3.496328e-02
      6019 1987   466_556102      JaccardDiss  4.782609e-01 -1.656315e-02
      6020 1987   466_556102 MorisitaHornDiss  2.752408e-02  3.667825e-02
      6021 1987   466_556102   BrayCurtisDiss  4.933103e-01  3.496328e-02
      6022 1988   466_556102      JaccardDiss  3.333333e-01 -1.656315e-02
      6023 1988   466_556102 MorisitaHornDiss  1.000517e-03  3.667825e-02
      6024 1988   466_556102   BrayCurtisDiss  7.134157e-01  3.496328e-02
      6025 1989   466_556102      JaccardDiss  4.285714e-01 -1.656315e-02
      6026 1989   466_556102 MorisitaHornDiss  3.865065e-01  3.667825e-02
      6027 1989   466_556102   BrayCurtisDiss  5.707317e-01  3.496328e-02
      6028 1990   466_556102      JaccardDiss  3.333333e-01 -1.656315e-02
      6029 1990   466_556102 MorisitaHornDiss  1.196400e-02  3.667825e-02
      6030 1990   466_556102   BrayCurtisDiss  8.875804e-01  3.496328e-02
      6031 1989   466_558277      JaccardDiss  3.636364e-01  9.815704e-04
      6032 1989   466_558277 MorisitaHornDiss  4.121810e-01  1.127579e-03
      6033 1989   466_558277   BrayCurtisDiss  5.061728e-01  2.239759e-03
      6034 2003   466_558277      JaccardDiss  3.157895e-01  9.815704e-04
      6035 2003   466_558277 MorisitaHornDiss  5.521169e-01  1.127579e-03
      6036 2003   466_558277   BrayCurtisDiss  6.030075e-01  2.239759e-03
      6037 1987   466_558277      JaccardDiss  4.210526e-01  9.815704e-04
      6038 1987   466_558277 MorisitaHornDiss  4.268414e-01  1.127579e-03
      6039 1987   466_558277   BrayCurtisDiss  6.522523e-01  2.239759e-03
      6040 2004   466_558277      JaccardDiss  5.263158e-01  9.815704e-04
      6041 2004   466_558277 MorisitaHornDiss  3.615547e-01  1.127579e-03
      6042 2004   466_558277   BrayCurtisDiss  5.952782e-01  2.239759e-03
      6043 2007   466_558277      JaccardDiss  5.000000e-01  9.815704e-04
      6044 2007   466_558277 MorisitaHornDiss  4.057516e-01  1.127579e-03
      6045 2007   466_558277   BrayCurtisDiss  7.436823e-01  2.239759e-03
      6046 2008   466_558277      JaccardDiss  3.157895e-01  9.815704e-04
      6047 2008   466_558277 MorisitaHornDiss  4.682963e-01  1.127579e-03
      6048 2008   466_558277   BrayCurtisDiss  5.489914e-01  2.239759e-03
      6049 1987   466_557546      JaccardDiss  5.789474e-01  1.479661e-03
      6050 1987   466_557546 MorisitaHornDiss  1.275220e-01  2.874984e-02
      6051 1987   466_557546   BrayCurtisDiss  3.901465e-01  1.993242e-02
      6052 2003   466_557546      JaccardDiss  3.809524e-01  1.479661e-03
      6053 2003   466_557546 MorisitaHornDiss  5.042415e-01  2.874984e-02
      6054 2003   466_557546   BrayCurtisDiss  6.684015e-01  1.993242e-02
      6055 1989   466_557546      JaccardDiss  5.000000e-01  1.479661e-03
      6056 1989   466_557546 MorisitaHornDiss  1.524204e-01  2.874984e-02
      6057 1989   466_557546   BrayCurtisDiss  5.645570e-01  1.993242e-02
      6058 2005   466_557546      JaccardDiss  7.142857e-01  1.479661e-03
      6059 2005   466_557546 MorisitaHornDiss  6.844343e-01  2.874984e-02
      6060 2005   466_557546   BrayCurtisDiss  8.852041e-01  1.993242e-02
      6061 1990   466_547347      JaccardDiss  4.545455e-01  2.111757e-03
      6062 1990   466_547347 MorisitaHornDiss  9.962145e-01  3.868340e-02
      6063 1990   466_547347   BrayCurtisDiss  9.864264e-01  2.481293e-02
      6064 1997   466_547347      JaccardDiss  3.888889e-01  2.111757e-03
      6065 1997   466_547347 MorisitaHornDiss  4.877933e-02  3.868340e-02
      6066 1997   466_547347   BrayCurtisDiss  2.558714e-01  2.481293e-02
      6067 1991   466_547347      JaccardDiss  4.210526e-01  2.111757e-03
      6068 1991   466_547347 MorisitaHornDiss  6.791840e-02  3.868340e-02
      6069 1991   466_547347   BrayCurtisDiss  2.997033e-01  2.481293e-02
      6070 1996   466_547347      JaccardDiss  3.333333e-01  2.111757e-03
      6071 1996   466_547347 MorisitaHornDiss  9.785088e-01  3.868340e-02
      6072 1996   466_547347   BrayCurtisDiss  9.248644e-01  2.481293e-02
      6073 2003   466_547347      JaccardDiss  5.200000e-01  2.111757e-03
      6074 2003   466_547347 MorisitaHornDiss  8.651417e-01  3.868340e-02
      6075 2003   466_547347   BrayCurtisDiss  9.176360e-01  2.481293e-02
      6076 1987   466_547347      JaccardDiss  6.000000e-01  2.111757e-03
      6077 1987   466_547347 MorisitaHornDiss  4.739951e-02  3.868340e-02
      6078 1987   466_547347   BrayCurtisDiss  3.728620e-01  2.481293e-02
      6079 2001   466_547347      JaccardDiss  4.761905e-01  2.111757e-03
      6080 2001   466_547347 MorisitaHornDiss  9.509361e-01  3.868340e-02
      6081 2001   466_547347   BrayCurtisDiss  8.250000e-01  2.481293e-02
      6082 2006   466_547347      JaccardDiss  5.909091e-01  2.111757e-03
      6083 2006   466_547347 MorisitaHornDiss  9.959717e-01  3.868340e-02
      6084 2006   466_547347   BrayCurtisDiss  9.895773e-01  2.481293e-02
      6085 1996   466_548076      JaccardDiss  3.214286e-01 -1.350997e-03
      6086 1996   466_548076 MorisitaHornDiss  1.051953e-02 -4.398099e-03
      6087 1996   466_548076   BrayCurtisDiss  1.299636e-01  2.626921e-03
      6088 1997   466_548076      JaccardDiss  4.482759e-01 -1.350997e-03
      6089 1997   466_548076 MorisitaHornDiss  4.725155e-02 -4.398099e-03
      6090 1997   466_548076   BrayCurtisDiss  5.975873e-01  2.626921e-03
      6091 1998   466_548076      JaccardDiss  5.714286e-01 -1.350997e-03
      6092 1998   466_548076 MorisitaHornDiss  2.491413e-02 -4.398099e-03
      6093 1998   466_548076   BrayCurtisDiss  2.875694e-01  2.626921e-03
      6094 2000   466_548076      JaccardDiss  4.615385e-01 -1.350997e-03
      6095 2000   466_548076 MorisitaHornDiss  8.195026e-01 -4.398099e-03
      6096 2000   466_548076   BrayCurtisDiss  7.416010e-01  2.626921e-03
      6097 2004   466_548076      JaccardDiss  5.862069e-01 -1.350997e-03
      6098 2004   466_548076 MorisitaHornDiss  9.114037e-01 -4.398099e-03
      6099 2004   466_548076   BrayCurtisDiss  9.408819e-01  2.626921e-03
      6100 2006   466_548076      JaccardDiss  5.172414e-01 -1.350997e-03
      6101 2006   466_548076 MorisitaHornDiss  1.535009e-02 -4.398099e-03
      6102 2006   466_548076   BrayCurtisDiss  5.736192e-01  2.626921e-03
      6103 1994   466_548076      JaccardDiss  5.185185e-01 -1.350997e-03
      6104 1994   466_548076 MorisitaHornDiss  8.180363e-01 -4.398099e-03
      6105 1994   466_548076   BrayCurtisDiss  9.138725e-01  2.626921e-03
      6106 1991   466_548076      JaccardDiss  5.714286e-01 -1.350997e-03
      6107 1991   466_548076 MorisitaHornDiss  8.286262e-01 -4.398099e-03
      6108 1991   466_548076   BrayCurtisDiss  8.664882e-01  2.626921e-03
      6109 1999   466_548076      JaccardDiss  5.357143e-01 -1.350997e-03
      6110 1999   466_548076 MorisitaHornDiss  2.407514e-02 -4.398099e-03
      6111 1999   466_548076   BrayCurtisDiss  1.683705e-01  2.626921e-03
      6112 1987   466_548076      JaccardDiss  5.666667e-01 -1.350997e-03
      6113 1987   466_548076 MorisitaHornDiss  3.705157e-01 -4.398099e-03
      6114 1987   466_548076   BrayCurtisDiss  6.376071e-01  2.626921e-03
      6115 2002   466_548076      JaccardDiss  5.555556e-01 -1.350997e-03
      6116 2002   466_548076 MorisitaHornDiss  8.277329e-01 -4.398099e-03
      6117 2002   466_548076   BrayCurtisDiss  7.567092e-01  2.626921e-03
      6118 2005   466_548076      JaccardDiss  6.296296e-01 -1.350997e-03
      6119 2005   466_548076 MorisitaHornDiss  8.742045e-01 -4.398099e-03
      6120 2005   466_548076   BrayCurtisDiss  9.289922e-01  2.626921e-03
      6121 2008   466_548076      JaccardDiss  3.703704e-01 -1.350997e-03
      6122 2008   466_548076 MorisitaHornDiss  1.484541e-02 -4.398099e-03
      6123 2008   466_548076   BrayCurtisDiss  5.440692e-01  2.626921e-03
      6124 1987   466_544438      JaccardDiss  5.294118e-01 -3.625215e-03
      6125 1987   466_544438 MorisitaHornDiss  2.076437e-01  2.225333e-02
      6126 1987   466_544438   BrayCurtisDiss  6.567705e-01 -5.065063e-03
      6127 1988   466_544438      JaccardDiss  5.500000e-01 -3.625215e-03
      6128 1988   466_544438 MorisitaHornDiss  2.486419e-01  2.225333e-02
      6129 1988   466_544438   BrayCurtisDiss  8.421053e-01 -5.065063e-03
      6130 1999   466_544438      JaccardDiss  4.444444e-01 -3.625215e-03
      6131 1999   466_544438 MorisitaHornDiss  3.687796e-01  2.225333e-02
      6132 1999   466_544438   BrayCurtisDiss  6.540035e-01 -5.065063e-03
      6133 2002   466_544438      JaccardDiss  5.263158e-01 -3.625215e-03
      6134 2002   466_544438 MorisitaHornDiss  6.170664e-01  2.225333e-02
      6135 2002   466_544438   BrayCurtisDiss  6.645821e-01 -5.065063e-03
      6136 1993   466_544438      JaccardDiss  5.882353e-01 -3.625215e-03
      6137 1993   466_544438 MorisitaHornDiss  2.920210e-01  2.225333e-02
      6138 1993   466_544438   BrayCurtisDiss  4.818942e-01 -5.065063e-03
      6139 1988   466_554645      JaccardDiss  3.478261e-01  3.590344e-03
      6140 1988   466_554645 MorisitaHornDiss  4.343480e-01  4.861742e-03
      6141 1988   466_554645   BrayCurtisDiss  8.883653e-01 -3.071948e-03
      6142 1989   466_554645      JaccardDiss  3.181818e-01  3.590344e-03
      6143 1989   466_554645 MorisitaHornDiss  2.008446e-01  4.861742e-03
      6144 1989   466_554645   BrayCurtisDiss  5.450049e-01 -3.071948e-03
      6145 1993   466_554645      JaccardDiss  4.583333e-01  3.590344e-03
      6146 1993   466_554645 MorisitaHornDiss  2.799288e-01  4.861742e-03
      6147 1993   466_554645   BrayCurtisDiss  4.945736e-01 -3.071948e-03
      6148 2000   466_554645      JaccardDiss  2.857143e-01  3.590344e-03
      6149 2000   466_554645 MorisitaHornDiss  8.552486e-01  4.861742e-03
      6150 2000   466_554645   BrayCurtisDiss  7.884406e-01 -3.071948e-03
      6151 2008   466_554645      JaccardDiss  3.913043e-01  3.590344e-03
      6152 2008   466_554645 MorisitaHornDiss  3.764669e-01  4.861742e-03
      6153 2008   466_554645   BrayCurtisDiss  7.879548e-01 -3.071948e-03
      6154 1994   466_554645      JaccardDiss  4.444444e-01  3.590344e-03
      6155 1994   466_554645 MorisitaHornDiss  5.280012e-01  4.861742e-03
      6156 1994   466_554645   BrayCurtisDiss  6.425121e-01 -3.071948e-03
      6157 1990   466_554645      JaccardDiss  3.478261e-01  3.590344e-03
      6158 1990   466_554645 MorisitaHornDiss  4.357209e-01  4.861742e-03
      6159 1990   466_554645   BrayCurtisDiss  7.997750e-01 -3.071948e-03
      6160 2002   466_554645      JaccardDiss  3.181818e-01  3.590344e-03
      6161 2002   466_554645 MorisitaHornDiss  5.192946e-01  4.861742e-03
      6162 2002   466_554645   BrayCurtisDiss  7.822199e-01 -3.071948e-03
      6163 2003   466_554645      JaccardDiss  4.347826e-01  3.590344e-03
      6164 2003   466_554645 MorisitaHornDiss  2.853223e-01  4.861742e-03
      6165 2003   466_554645   BrayCurtisDiss  5.270108e-01 -3.071948e-03
      6166 1995   466_554645      JaccardDiss  3.913043e-01  3.590344e-03
      6167 1995   466_554645 MorisitaHornDiss  3.739070e-01  4.861742e-03
      6168 1995   466_554645   BrayCurtisDiss  9.404267e-01 -3.071948e-03
      6169 1998   466_554645      JaccardDiss  2.380952e-01  3.590344e-03
      6170 1998   466_554645 MorisitaHornDiss  2.473234e-01  4.861742e-03
      6171 1998   466_554645   BrayCurtisDiss  5.500000e-01 -3.071948e-03
      6172 1986   466_554645      JaccardDiss  1.818182e-01  3.590344e-03
      6173 1986   466_554645 MorisitaHornDiss  4.149021e-01  4.861742e-03
      6174 1986   466_554645   BrayCurtisDiss  9.505374e-01 -3.071948e-03
      6175 1987   466_554645      JaccardDiss  4.583333e-01  3.590344e-03
      6176 1987   466_554645 MorisitaHornDiss  3.468534e-01  4.861742e-03
      6177 1987   466_554645   BrayCurtisDiss  7.891037e-01 -3.071948e-03
      6178 1991   466_554645      JaccardDiss  3.913043e-01  3.590344e-03
      6179 1991   466_554645 MorisitaHornDiss  3.179547e-01  4.861742e-03
      6180 1991   466_554645   BrayCurtisDiss  5.341702e-01 -3.071948e-03
      6181 1999   466_554645      JaccardDiss  4.782609e-01  3.590344e-03
      6182 1999   466_554645 MorisitaHornDiss  4.882784e-01  4.861742e-03
      6183 1999   466_554645   BrayCurtisDiss  7.979695e-01 -3.071948e-03
      6184 2004   466_554645      JaccardDiss  5.714286e-01  3.590344e-03
      6185 2004   466_554645 MorisitaHornDiss  7.633954e-01  4.861742e-03
      6186 2004   466_554645   BrayCurtisDiss  6.932271e-01 -3.071948e-03
      6187 2005   466_554645      JaccardDiss  3.500000e-01  3.590344e-03
      6188 2005   466_554645 MorisitaHornDiss  1.400213e-01  4.861742e-03
      6189 2005   466_554645   BrayCurtisDiss  7.005614e-01 -3.071948e-03
      6190 1988   466_565559      JaccardDiss  5.238095e-01 -4.516758e-05
      6191 1988   466_565559 MorisitaHornDiss  4.713826e-01  5.971692e-03
      6192 1988   466_565559   BrayCurtisDiss  5.785055e-01  6.204392e-03
      6193 1999   466_565559      JaccardDiss  5.454545e-01 -4.516758e-05
      6194 1999   466_565559 MorisitaHornDiss  9.826166e-01  5.971692e-03
      6195 1999   466_565559   BrayCurtisDiss  9.673640e-01  6.204392e-03
      6196 1992   466_565559      JaccardDiss  3.529412e-01 -4.516758e-05
      6197 1992   466_565559 MorisitaHornDiss  8.329919e-01  5.971692e-03
      6198 1992   466_565559   BrayCurtisDiss  8.032211e-01  6.204392e-03
      6199 1995   466_565559      JaccardDiss  5.625000e-01 -4.516758e-05
      6200 1995   466_565559 MorisitaHornDiss  9.751835e-01  5.971692e-03
      6201 1995   466_565559   BrayCurtisDiss  9.174917e-01  6.204392e-03
      6202 2006   466_565559      JaccardDiss  4.705882e-01 -4.516758e-05
      6203 2006   466_565559 MorisitaHornDiss  9.909637e-01  5.971692e-03
      6204 2006   466_565559   BrayCurtisDiss  9.777191e-01  6.204392e-03
      6205 2007   466_565559      JaccardDiss  5.000000e-01 -4.516758e-05
      6206 2007   466_565559 MorisitaHornDiss  1.429868e-01  5.971692e-03
      6207 2007   466_565559   BrayCurtisDiss  3.543092e-01  6.204392e-03
      6208 1989   466_565559      JaccardDiss  5.000000e-01 -4.516758e-05
      6209 1989   466_565559 MorisitaHornDiss  2.765327e-01  5.971692e-03
      6210 1989   466_565559   BrayCurtisDiss  4.285714e-01  6.204392e-03
      6211 1998   466_565559      JaccardDiss  3.181818e-01 -4.516758e-05
      6212 1998   466_565559 MorisitaHornDiss  9.879324e-01  5.971692e-03
      6213 1998   466_565559   BrayCurtisDiss  9.460807e-01  6.204392e-03
      6214 2005   466_561921      JaccardDiss  4.166667e-01 -8.137000e-04
      6215 2005   466_561921 MorisitaHornDiss  6.141894e-01 -1.993046e-02
      6216 2005   466_561921   BrayCurtisDiss  7.676951e-01 -1.314992e-02
      6217 1997   466_561921      JaccardDiss  4.827586e-01 -8.137000e-04
      6218 1997   466_561921 MorisitaHornDiss  6.955909e-01 -1.993046e-02
      6219 1997   466_561921   BrayCurtisDiss  8.434082e-01 -1.314992e-02
      6220 2007   466_561921      JaccardDiss  3.636364e-01 -8.137000e-04
      6221 2007   466_561921 MorisitaHornDiss  4.918192e-01 -1.993046e-02
      6222 2007   466_561921   BrayCurtisDiss  6.657645e-01 -1.314992e-02
      6223 1986   466_561921      JaccardDiss  3.600000e-01 -8.137000e-04
      6224 1986   466_561921 MorisitaHornDiss  9.113375e-01 -1.993046e-02
      6225 1986   466_561921   BrayCurtisDiss  9.676072e-01 -1.314992e-02
      6226 1988   466_561921      JaccardDiss  4.400000e-01 -8.137000e-04
      6227 1988   466_561921 MorisitaHornDiss  5.417763e-01 -1.993046e-02
      6228 1988   466_561921   BrayCurtisDiss  8.102241e-01 -1.314992e-02
      6229 1995   466_561921      JaccardDiss  5.185185e-01 -8.137000e-04
      6230 1995   466_561921 MorisitaHornDiss  7.249309e-01 -1.993046e-02
      6231 1995   466_561921   BrayCurtisDiss  7.384988e-01 -1.314992e-02
      6232 1998   466_561921      JaccardDiss  5.000000e-01 -8.137000e-04
      6233 1998   466_561921 MorisitaHornDiss  6.378564e-01 -1.993046e-02
      6234 1998   466_561921   BrayCurtisDiss  6.924939e-01 -1.314992e-02
      6235 1999   466_561921      JaccardDiss  5.357143e-01 -8.137000e-04
      6236 1999   466_561921 MorisitaHornDiss  8.350517e-01 -1.993046e-02
      6237 1999   466_561921   BrayCurtisDiss  7.659574e-01 -1.314992e-02
      6238 2000   466_561921      JaccardDiss  3.000000e-01 -8.137000e-04
      6239 2000   466_561921 MorisitaHornDiss  3.560783e-01 -1.993046e-02
      6240 2000   466_561921   BrayCurtisDiss  4.005525e-01 -1.314992e-02
      6241 2002   466_561921      JaccardDiss  3.636364e-01 -8.137000e-04
      6242 2002   466_561921 MorisitaHornDiss  5.527559e-01 -1.993046e-02
      6243 2002   466_561921   BrayCurtisDiss  6.186830e-01 -1.314992e-02
      6244 2003   466_561921      JaccardDiss  4.210526e-01 -8.137000e-04
      6245 2003   466_561921 MorisitaHornDiss  6.678288e-02 -1.993046e-02
      6246 2003   466_561921   BrayCurtisDiss  3.193277e-01 -1.314992e-02
      6247 1991   466_561921      JaccardDiss  3.157895e-01 -8.137000e-04
      6248 1991   466_561921 MorisitaHornDiss  8.597607e-01 -1.993046e-02
      6249 1991   466_561921   BrayCurtisDiss  9.327709e-01 -1.314992e-02
      6250 1993   466_561921      JaccardDiss  5.384615e-01 -8.137000e-04
      6251 1993   466_561921 MorisitaHornDiss  4.817579e-01 -1.993046e-02
      6252 1993   466_561921   BrayCurtisDiss  5.610425e-01 -1.314992e-02
      6253 2004   466_561921      JaccardDiss  3.684211e-01 -8.137000e-04
      6254 2004   466_561921 MorisitaHornDiss  5.722242e-01 -1.993046e-02
      6255 2004   466_561921   BrayCurtisDiss  5.918367e-01 -1.314992e-02
      6256 2006   466_561921      JaccardDiss  4.000000e-01 -8.137000e-04
      6257 2006   466_561921 MorisitaHornDiss  1.313288e-01 -1.993046e-02
      6258 2006   466_561921   BrayCurtisDiss  8.451362e-01 -1.314992e-02
      6259 1987   466_561921      JaccardDiss  3.750000e-01 -8.137000e-04
      6260 1987   466_561921 MorisitaHornDiss  8.060919e-01 -1.993046e-02
      6261 1987   466_561921   BrayCurtisDiss  9.544599e-01 -1.314992e-02
      6262 1992   466_561921      JaccardDiss  4.285714e-01 -8.137000e-04
      6263 1992   466_561921 MorisitaHornDiss  5.440778e-01 -1.993046e-02
      6264 1992   466_561921   BrayCurtisDiss  6.421612e-01 -1.314992e-02
      6265 1998   466_548075      JaccardDiss  5.416667e-01 -8.532812e-04
      6266 1998   466_548075 MorisitaHornDiss  4.617197e-01  1.589980e-02
      6267 1998   466_548075   BrayCurtisDiss  5.325402e-01  4.628494e-03
      6268 1986   466_548075      JaccardDiss  4.444444e-01 -8.532812e-04
      6269 1986   466_548075 MorisitaHornDiss  5.658797e-01  1.589980e-02
      6270 1986   466_548075   BrayCurtisDiss  5.991591e-01  4.628494e-03
      6271 1994   466_548075      JaccardDiss  5.555556e-01 -8.532812e-04
      6272 1994   466_548075 MorisitaHornDiss  3.594284e-01  1.589980e-02
      6273 1994   466_548075   BrayCurtisDiss  5.023299e-01  4.628494e-03
      6274 1999   466_548075      JaccardDiss  3.913043e-01 -8.532812e-04
      6275 1999   466_548075 MorisitaHornDiss  1.026096e-01  1.589980e-02
      6276 1999   466_548075   BrayCurtisDiss  3.385147e-01  4.628494e-03
      6277 2000   466_548075      JaccardDiss  4.090909e-01 -8.532812e-04
      6278 2000   466_548075 MorisitaHornDiss  2.663274e-02  1.589980e-02
      6279 2000   466_548075   BrayCurtisDiss  2.011070e-01  4.628494e-03
      6280 2003   466_548075      JaccardDiss  4.000000e-01 -8.532812e-04
      6281 2003   466_548075 MorisitaHornDiss  1.424091e-02  1.589980e-02
      6282 2003   466_548075   BrayCurtisDiss  2.584693e-01  4.628494e-03
      6283 1997   466_548075      JaccardDiss  5.217391e-01 -8.532812e-04
      6284 1997   466_548075 MorisitaHornDiss  2.608389e-01  1.589980e-02
      6285 1997   466_548075   BrayCurtisDiss  4.206897e-01  4.628494e-03
      6286 1992   466_548075      JaccardDiss  4.583333e-01 -8.532812e-04
      6287 1992   466_548075 MorisitaHornDiss  1.010497e-01  1.589980e-02
      6288 1992   466_548075   BrayCurtisDiss  3.523588e-01  4.628494e-03
      6289 1993   466_548075      JaccardDiss  5.217391e-01 -8.532812e-04
      6290 1993   466_548075 MorisitaHornDiss  1.744188e-02  1.589980e-02
      6291 1993   466_548075   BrayCurtisDiss  2.035714e-01  4.628494e-03
      6292 1995   466_548075      JaccardDiss  5.384615e-01 -8.532812e-04
      6293 1995   466_548075 MorisitaHornDiss  6.431581e-01  1.589980e-02
      6294 1995   466_548075   BrayCurtisDiss  6.164103e-01  4.628494e-03
      6295 2001   466_548075      JaccardDiss  5.600000e-01 -8.532812e-04
      6296 2001   466_548075 MorisitaHornDiss  9.459251e-01  1.589980e-02
      6297 2001   466_548075   BrayCurtisDiss  9.054868e-01  4.628494e-03
      6298 2004   466_548075      JaccardDiss  4.782609e-01 -8.532812e-04
      6299 2004   466_548075 MorisitaHornDiss  5.869919e-01  1.589980e-02
      6300 2004   466_548075   BrayCurtisDiss  6.169394e-01  4.628494e-03
      6301 2006   466_548075      JaccardDiss  5.200000e-01 -8.532812e-04
      6302 2006   466_548075 MorisitaHornDiss  5.780916e-01  1.589980e-02
      6303 2006   466_548075   BrayCurtisDiss  6.349296e-01  4.628494e-03
      6304 2007   466_548075      JaccardDiss  5.652174e-01 -8.532812e-04
      6305 2007   466_548075 MorisitaHornDiss  6.736643e-01  1.589980e-02
      6306 2007   466_548075   BrayCurtisDiss  5.422177e-01  4.628494e-03
      6307 2008   466_548075      JaccardDiss  5.600000e-01 -8.532812e-04
      6308 2008   466_548075 MorisitaHornDiss  8.314523e-01  1.589980e-02
      6309 2008   466_548075   BrayCurtisDiss  7.505995e-01  4.628494e-03
      6310 1988   466_548075      JaccardDiss  5.600000e-01 -8.532812e-04
      6311 1988   466_548075 MorisitaHornDiss  4.375692e-02  1.589980e-02
      6312 1988   466_548075   BrayCurtisDiss  6.092796e-01  4.628494e-03
      6313 1989   466_548075      JaccardDiss  5.925926e-01 -8.532812e-04
      6314 1989   466_548075 MorisitaHornDiss  9.714202e-01  1.589980e-02
      6315 1989   466_548075   BrayCurtisDiss  9.061288e-01  4.628494e-03
      6316 2005   466_548075      JaccardDiss  5.416667e-01 -8.532812e-04
      6317 2005   466_548075 MorisitaHornDiss  9.627414e-01  1.589980e-02
      6318 2005   466_548075   BrayCurtisDiss  9.144649e-01  4.628494e-03
      6319 1996   466_548075      JaccardDiss  5.714286e-01 -8.532812e-04
      6320 1996   466_548075 MorisitaHornDiss  1.957924e-02  1.589980e-02
      6321 1996   466_548075   BrayCurtisDiss  2.809430e-01  4.628494e-03
      6322 2002   466_548075      JaccardDiss  3.913043e-01 -8.532812e-04
      6323 2002   466_548075 MorisitaHornDiss  5.082972e-01  1.589980e-02
      6324 2002   466_548075   BrayCurtisDiss  6.042714e-01  4.628494e-03
      6325 1993   466_564102      JaccardDiss  6.086957e-01  4.327937e-04
      6326 1993   466_564102 MorisitaHornDiss  4.401770e-01 -5.425329e-02
      6327 1993   466_564102   BrayCurtisDiss  6.174242e-01 -7.417269e-03
      6328 1989   466_564102      JaccardDiss  3.913043e-01  4.327937e-04
      6329 1989   466_564102 MorisitaHornDiss  6.176793e-01 -5.425329e-02
      6330 1989   466_564102   BrayCurtisDiss  6.659664e-01 -7.417269e-03
      6331 1994   466_564102      JaccardDiss  3.181818e-01  4.327937e-04
      6332 1994   466_564102 MorisitaHornDiss  5.738060e-01 -5.425329e-02
      6333 1994   466_564102   BrayCurtisDiss  6.033835e-01 -7.417269e-03
      6334 1995   466_564102      JaccardDiss  4.117647e-01  4.327937e-04
      6335 1995   466_564102 MorisitaHornDiss  1.614400e-01 -5.425329e-02
      6336 1995   466_564102   BrayCurtisDiss  6.377246e-01 -7.417269e-03
      6337 1990   466_544454      JaccardDiss  2.272727e-01  3.163689e-03
      6338 1990   466_544454 MorisitaHornDiss  4.795508e-02  2.137532e-02
      6339 1990   466_544454   BrayCurtisDiss  2.614796e-01  3.177439e-02
      6340 1994   466_544454      JaccardDiss  4.090909e-01  3.163689e-03
      6341 1994   466_544454 MorisitaHornDiss  2.984853e-01  2.137532e-02
      6342 1994   466_544454   BrayCurtisDiss  6.720735e-01  3.177439e-02
      6343 1995   466_544454      JaccardDiss  4.166667e-01  3.163689e-03
      6344 1995   466_544454 MorisitaHornDiss  2.484305e-02  2.137532e-02
      6345 1995   466_544454   BrayCurtisDiss  2.693093e-01  3.177439e-02
      6346 2004   466_544454      JaccardDiss  3.181818e-01  3.163689e-03
      6347 2004   466_544454 MorisitaHornDiss  7.098887e-01  2.137532e-02
      6348 2004   466_544454   BrayCurtisDiss  9.151104e-01  3.177439e-02
      6349 2005   466_544454      JaccardDiss  4.800000e-01  3.163689e-03
      6350 2005   466_544454 MorisitaHornDiss  4.513677e-01  2.137532e-02
      6351 2005   466_544454   BrayCurtisDiss  9.345930e-01  3.177439e-02
      6352 2008   466_544454      JaccardDiss  3.157895e-01  3.163689e-03
      6353 2008   466_544454 MorisitaHornDiss  2.198568e-01  2.137532e-02
      6354 2008   466_544454   BrayCurtisDiss  6.914526e-01  3.177439e-02
      6355 2002   466_557549      JaccardDiss  4.814815e-01  9.330232e-03
      6356 2002   466_557549 MorisitaHornDiss  2.670370e-01 -1.436087e-02
      6357 2002   466_557549   BrayCurtisDiss  4.214598e-01 -1.597297e-02
      6358 1990   466_557549      JaccardDiss  2.857143e-01  9.330232e-03
      6359 1990   466_557549 MorisitaHornDiss  5.573200e-01 -1.436087e-02
      6360 1990   466_557549   BrayCurtisDiss  8.182657e-01 -1.597297e-02
      6361 2005   466_557549      JaccardDiss  4.545455e-01  9.330232e-03
      6362 2005   466_557549 MorisitaHornDiss  3.324196e-01 -1.436087e-02
      6363 2005   466_557549   BrayCurtisDiss  7.000000e-01 -1.597297e-02
      6364 2006   466_557549      JaccardDiss  5.000000e-01  9.330232e-03
      6365 2006   466_557549 MorisitaHornDiss  6.129827e-02 -1.436087e-02
      6366 2006   466_557549   BrayCurtisDiss  1.970061e-01 -1.597297e-02
      6367 2007   466_557549      JaccardDiss  3.750000e-01  9.330232e-03
      6368 2007   466_557549 MorisitaHornDiss  5.318757e-01 -1.436087e-02
      6369 2007   466_557549   BrayCurtisDiss  7.664813e-01 -1.597297e-02
      6370 1991   466_543710      JaccardDiss  3.913043e-01  7.189794e-03
      6371 1991   466_543710 MorisitaHornDiss  3.453202e-01  7.005575e-03
      6372 1991   466_543710   BrayCurtisDiss  4.525140e-01  3.602279e-03
      6373 1996   466_543710      JaccardDiss  3.750000e-01  7.189794e-03
      6374 1996   466_543710 MorisitaHornDiss  5.247570e-01  7.005575e-03
      6375 1996   466_543710   BrayCurtisDiss  7.041199e-01  3.602279e-03
      6376 2001   466_543710      JaccardDiss  4.761905e-01  7.189794e-03
      6377 2001   466_543710 MorisitaHornDiss  3.734941e-01  7.005575e-03
      6378 2001   466_543710   BrayCurtisDiss  6.785110e-01  3.602279e-03
      6379 2000   466_543710      JaccardDiss  4.615385e-01  7.189794e-03
      6380 2000   466_543710 MorisitaHornDiss  2.719736e-01  7.005575e-03
      6381 2000   466_543710   BrayCurtisDiss  6.830295e-01  3.602279e-03
      6382 1992   466_543710      JaccardDiss  3.636364e-01  7.189794e-03
      6383 1992   466_543710 MorisitaHornDiss  2.880839e-01  7.005575e-03
      6384 1992   466_543710   BrayCurtisDiss  5.462963e-01  3.602279e-03
      6385 2007   466_543710      JaccardDiss  4.000000e-01  7.189794e-03
      6386 2007   466_543710 MorisitaHornDiss  4.809787e-01  7.005575e-03
      6387 2007   466_543710   BrayCurtisDiss  5.816993e-01  3.602279e-03
      6388 2008   466_543710      JaccardDiss  4.545455e-01  7.189794e-03
      6389 2008   466_543710 MorisitaHornDiss  5.250185e-01  7.005575e-03
      6390 2008   466_543710   BrayCurtisDiss  6.592593e-01  3.602279e-03
      6391 2003   466_543710      JaccardDiss  7.000000e-01  7.189794e-03
      6392 2003   466_543710 MorisitaHornDiss  5.608365e-01  7.005575e-03
      6393 2003   466_543710   BrayCurtisDiss  6.363636e-01  3.602279e-03
      6394 2004   466_543710      JaccardDiss  5.714286e-01  7.189794e-03
      6395 2004   466_543710 MorisitaHornDiss  5.169220e-01  7.005575e-03
      6396 2004   466_543710   BrayCurtisDiss  6.106870e-01  3.602279e-03
      6397 2005   466_543710      JaccardDiss  4.347826e-01  7.189794e-03
      6398 2005   466_543710 MorisitaHornDiss  1.824520e-01  7.005575e-03
      6399 2005   466_543710   BrayCurtisDiss  4.472050e-01  3.602279e-03
      6400 1991   466_553178      JaccardDiss  3.600000e-01  3.001146e-03
      6401 1991   466_553178 MorisitaHornDiss  1.372503e-01  1.713427e-02
      6402 1991   466_553178   BrayCurtisDiss  4.651560e-01  1.590489e-02
      6403 1997   466_553178      JaccardDiss  4.230769e-01  3.001146e-03
      6404 1997   466_553178 MorisitaHornDiss  8.542940e-01  1.713427e-02
      6405 1997   466_553178   BrayCurtisDiss  8.290669e-01  1.590489e-02
      6406 2004   466_553178      JaccardDiss  3.846154e-01  3.001146e-03
      6407 2004   466_553178 MorisitaHornDiss  8.256235e-01  1.713427e-02
      6408 2004   466_553178   BrayCurtisDiss  8.975511e-01  1.590489e-02
      6409 2006   466_553178      JaccardDiss  4.615385e-01  3.001146e-03
      6410 2006   466_553178 MorisitaHornDiss  1.046030e-01  1.713427e-02
      6411 2006   466_553178   BrayCurtisDiss  4.808102e-01  1.590489e-02
      6412 2007   466_553178      JaccardDiss  4.090909e-01  3.001146e-03
      6413 2007   466_553178 MorisitaHornDiss  6.278330e-01  1.713427e-02
      6414 2007   466_553178   BrayCurtisDiss  9.000461e-01  1.590489e-02
      6415 2005   466_553178      JaccardDiss  4.000000e-01  3.001146e-03
      6416 2005   466_553178 MorisitaHornDiss  9.413888e-01  1.713427e-02
      6417 2005   466_553178   BrayCurtisDiss  9.068925e-01  1.590489e-02
      6418 1992   466_551721      JaccardDiss  2.173913e-01  1.602412e-02
      6419 1992   466_551721 MorisitaHornDiss  4.752337e-03  1.318070e-02
      6420 1992   466_551721   BrayCurtisDiss  7.666256e-02  1.198336e-02
      6421 1993   466_551721      JaccardDiss  2.916667e-01  1.602412e-02
      6422 1993   466_551721 MorisitaHornDiss  2.574770e-01  1.318070e-02
      6423 1993   466_551721   BrayCurtisDiss  3.844379e-01  1.198336e-02
      6424 1995   466_551721      JaccardDiss  2.500000e-01  1.602412e-02
      6425 1995   466_551721 MorisitaHornDiss  1.485881e-01  1.318070e-02
      6426 1995   466_551721   BrayCurtisDiss  7.518420e-01  1.198336e-02
      6427 1996   466_551721      JaccardDiss  2.608696e-01  1.602412e-02
      6428 1996   466_551721 MorisitaHornDiss  4.786711e-02  1.318070e-02
      6429 1996   466_551721   BrayCurtisDiss  1.599307e-01  1.198336e-02
      6430 1997   466_551721      JaccardDiss  3.333333e-01  1.602412e-02
      6431 1997   466_551721 MorisitaHornDiss  6.768839e-02  1.318070e-02
      6432 1997   466_551721   BrayCurtisDiss  3.348748e-01  1.198336e-02
      6433 1998   466_551721      JaccardDiss  3.600000e-01  1.602412e-02
      6434 1998   466_551721 MorisitaHornDiss  1.399827e-01  1.318070e-02
      6435 1998   466_551721   BrayCurtisDiss  7.285091e-01  1.198336e-02
      6436 1999   466_551721      JaccardDiss  2.916667e-01  1.602412e-02
      6437 1999   466_551721 MorisitaHornDiss  4.373223e-02  1.318070e-02
      6438 1999   466_551721   BrayCurtisDiss  5.779774e-01  1.198336e-02
      6439 2000   466_551721      JaccardDiss  4.230769e-01  1.602412e-02
      6440 2000   466_551721 MorisitaHornDiss  6.615722e-01  1.318070e-02
      6441 2000   466_551721   BrayCurtisDiss  5.951075e-01  1.198336e-02
      6442 1988   466_551721      JaccardDiss  1.739130e-01  1.602412e-02
      6443 1988   466_551721 MorisitaHornDiss  3.953012e-01  1.318070e-02
      6444 1988   466_551721   BrayCurtisDiss  4.516757e-01  1.198336e-02
      6445 1994   466_551721      JaccardDiss  3.181818e-01  1.602412e-02
      6446 1994   466_551721 MorisitaHornDiss  6.113114e-01  1.318070e-02
      6447 1994   466_551721   BrayCurtisDiss  6.979985e-01  1.198336e-02
      6448 2001   466_551721      JaccardDiss  4.000000e-01  1.602412e-02
      6449 2001   466_551721 MorisitaHornDiss  6.726306e-01  1.318070e-02
      6450 2001   466_551721   BrayCurtisDiss  7.691116e-01  1.198336e-02
      6451 2002   466_551721      JaccardDiss  4.583333e-01  1.602412e-02
      6452 2002   466_551721 MorisitaHornDiss  8.693499e-01  1.318070e-02
      6453 2002   466_551721   BrayCurtisDiss  8.273736e-01  1.198336e-02
      6454 2008   466_551721      JaccardDiss  4.615385e-01  1.602412e-02
      6455 2008   466_551721 MorisitaHornDiss  2.076644e-01  1.318070e-02
      6456 2008   466_551721   BrayCurtisDiss  3.294758e-01  1.198336e-02
      6457 1988   466_550989      JaccardDiss  5.238095e-01  1.057744e-03
      6458 1988   466_550989 MorisitaHornDiss  8.949827e-01 -1.183905e-02
      6459 1988   466_550989   BrayCurtisDiss  7.799250e-01 -6.618058e-03
      6460 1993   466_550989      JaccardDiss  4.545455e-01  1.057744e-03
      6461 1993   466_550989 MorisitaHornDiss  6.698750e-03 -1.183905e-02
      6462 1993   466_550989   BrayCurtisDiss  3.952046e-01 -6.618058e-03
      6463 1994   466_550989      JaccardDiss  4.500000e-01  1.057744e-03
      6464 1994   466_550989 MorisitaHornDiss  9.063533e-01 -1.183905e-02
      6465 1994   466_550989   BrayCurtisDiss  8.548476e-01 -6.618058e-03
      6466 1995   466_550989      JaccardDiss  5.000000e-01  1.057744e-03
      6467 1995   466_550989 MorisitaHornDiss  5.963513e-01 -1.183905e-02
      6468 1995   466_550989   BrayCurtisDiss  7.855446e-01 -6.618058e-03
      6469 1996   466_550989      JaccardDiss  5.000000e-01  1.057744e-03
      6470 1996   466_550989 MorisitaHornDiss  9.181471e-01 -1.183905e-02
      6471 1996   466_550989   BrayCurtisDiss  8.544053e-01 -6.618058e-03
      6472 1997   466_550989      JaccardDiss  4.782609e-01  1.057744e-03
      6473 1997   466_550989 MorisitaHornDiss  7.887507e-01 -1.183905e-02
      6474 1997   466_550989   BrayCurtisDiss  8.660798e-01 -6.618058e-03
      6475 1998   466_550989      JaccardDiss  5.200000e-01  1.057744e-03
      6476 1998   466_550989 MorisitaHornDiss  1.760222e-03 -1.183905e-02
      6477 1998   466_550989   BrayCurtisDiss  1.192156e-01 -6.618058e-03
      6478 2000   466_550989      JaccardDiss  4.800000e-01  1.057744e-03
      6479 2000   466_550989 MorisitaHornDiss  2.946764e-02 -1.183905e-02
      6480 2000   466_550989   BrayCurtisDiss  3.601874e-01 -6.618058e-03
      6481 2002   466_550989      JaccardDiss  5.000000e-01  1.057744e-03
      6482 2002   466_550989 MorisitaHornDiss  1.527456e-01 -1.183905e-02
      6483 2002   466_550989   BrayCurtisDiss  6.557204e-01 -6.618058e-03
      6484 1999   466_550989      JaccardDiss  5.263158e-01  1.057744e-03
      6485 1999   466_550989 MorisitaHornDiss  1.844960e-02 -1.183905e-02
      6486 1999   466_550989   BrayCurtisDiss  7.593332e-01 -6.618058e-03
      6487 2007   466_550989      JaccardDiss  5.000000e-01  1.057744e-03
      6488 2007   466_550989 MorisitaHornDiss  8.478429e-01 -1.183905e-02
      6489 2007   466_550989   BrayCurtisDiss  9.550739e-01 -6.618058e-03
      6490 2008   466_550989      JaccardDiss  5.000000e-01  1.057744e-03
      6491 2008   466_550989 MorisitaHornDiss  5.104861e-02 -1.183905e-02
      6492 2008   466_550989   BrayCurtisDiss  2.405857e-01 -6.618058e-03
      6493 1992   466_550989      JaccardDiss  3.888889e-01  1.057744e-03
      6494 1992   466_550989 MorisitaHornDiss  1.527474e-02 -1.183905e-02
      6495 1992   466_550989   BrayCurtisDiss  5.822135e-01 -6.618058e-03
      6496 2001   466_550989      JaccardDiss  3.684211e-01  1.057744e-03
      6497 2001   466_550989 MorisitaHornDiss  8.852730e-01 -1.183905e-02
      6498 2001   466_550989   BrayCurtisDiss  8.540541e-01 -6.618058e-03
      6499 1995   466_559007      JaccardDiss  3.461538e-01  1.318869e-02
      6500 1995   466_559007 MorisitaHornDiss  5.615269e-02 -8.673699e-03
      6501 1995   466_559007   BrayCurtisDiss  8.099260e-01  7.895299e-04
      6502 1996   466_559007      JaccardDiss  2.380952e-01  1.318869e-02
      6503 1996   466_559007 MorisitaHornDiss  3.794392e-01 -8.673699e-03
      6504 1996   466_559007   BrayCurtisDiss  9.682766e-01  7.895299e-04
      6505 1998   466_559007      JaccardDiss  2.608696e-01  1.318869e-02
      6506 1998   466_559007 MorisitaHornDiss  1.496077e-01 -8.673699e-03
      6507 1998   466_559007   BrayCurtisDiss  8.238872e-01  7.895299e-04
      6508 1993   466_559007      JaccardDiss  4.230769e-01  1.318869e-02
      6509 1993   466_559007 MorisitaHornDiss  5.316232e-01 -8.673699e-03
      6510 1993   466_559007   BrayCurtisDiss  9.620108e-01  7.895299e-04
      6511 1997   466_559007      JaccardDiss  4.230769e-01  1.318869e-02
      6512 1997   466_559007 MorisitaHornDiss  2.569210e-01 -8.673699e-03
      6513 1997   466_559007   BrayCurtisDiss  9.810139e-01  7.895299e-04
      6514 2000   466_559007      JaccardDiss  4.615385e-01  1.318869e-02
      6515 2000   466_559007 MorisitaHornDiss  2.674391e-03 -8.673699e-03
      6516 2000   466_559007   BrayCurtisDiss  6.285965e-01  7.895299e-04
      6517 2002   466_559007      JaccardDiss  5.000000e-01  1.318869e-02
      6518 2002   466_559007 MorisitaHornDiss  3.509340e-01 -8.673699e-03
      6519 2002   466_559007   BrayCurtisDiss  9.534236e-01  7.895299e-04
      6520 2007   466_559007      JaccardDiss  5.000000e-01  1.318869e-02
      6521 2007   466_559007 MorisitaHornDiss  6.827634e-02 -8.673699e-03
      6522 2007   466_559007   BrayCurtisDiss  9.493097e-01  7.895299e-04
      6523 2003   466_559007      JaccardDiss  5.000000e-01  1.318869e-02
      6524 2003   466_559007 MorisitaHornDiss  8.192253e-01 -8.673699e-03
      6525 2003   466_559007   BrayCurtisDiss  9.868227e-01  7.895299e-04
      6526 2004   466_559007      JaccardDiss  4.545455e-01  1.318869e-02
      6527 2004   466_559007 MorisitaHornDiss  3.268164e-02 -8.673699e-03
      6528 2004   466_559007   BrayCurtisDiss  8.918713e-01  7.895299e-04
      6529 2001   466_559007      JaccardDiss  3.703704e-01  1.318869e-02
      6530 2001   466_559007 MorisitaHornDiss  2.148077e-01 -8.673699e-03
      6531 2001   466_559007   BrayCurtisDiss  7.727811e-01  7.895299e-04
      6532 1993   466_557560      JaccardDiss  4.000000e-01 -1.276812e-02
      6533 1993   466_557560 MorisitaHornDiss  3.261759e-02  1.477756e-01
      6534 1993   466_557560   BrayCurtisDiss  1.448853e-01  1.538916e-01
      6535 1996   466_557560      JaccardDiss  3.200000e-01 -1.276812e-02
      6536 1996   466_557560 MorisitaHornDiss  3.687157e-01  1.477756e-01
      6537 1996   466_557560   BrayCurtisDiss  5.294283e-01  1.538916e-01
      6538 1994   466_557560      JaccardDiss  3.043478e-01 -1.276812e-02
      6539 1994   466_557560 MorisitaHornDiss  3.097418e-02  1.477756e-01
      6540 1994   466_557560   BrayCurtisDiss  2.359971e-01  1.538916e-01
      6541 1995   466_557560      JaccardDiss  4.166667e-01 -1.276812e-02
      6542 1995   466_557560 MorisitaHornDiss  5.004360e-01  1.477756e-01
      6543 1995   466_557560   BrayCurtisDiss  6.212837e-01  1.538916e-01
      6544 1994   466_559735      JaccardDiss  4.000000e-01  6.802721e-04
      6545 1994   466_559735 MorisitaHornDiss  4.374756e-01 -2.712453e-03
      6546 1994   466_559735   BrayCurtisDiss  5.823940e-01  4.278733e-02
      6547 1997   466_559735      JaccardDiss  4.000000e-01  6.802721e-04
      6548 1997   466_559735 MorisitaHornDiss  7.815528e-01 -2.712453e-03
      6549 1997   466_559735   BrayCurtisDiss  8.558891e-01  4.278733e-02
      6550 1999   466_559735      JaccardDiss  6.000000e-01  6.802721e-04
      6551 1999   466_559735 MorisitaHornDiss  9.942423e-01 -2.712453e-03
      6552 1999   466_559735   BrayCurtisDiss  9.692616e-01  4.278733e-02
      6553 2000   466_559735      JaccardDiss  2.857143e-01  6.802721e-04
      6554 2000   466_559735 MorisitaHornDiss  1.494465e-01 -2.712453e-03
      6555 2000   466_559735   BrayCurtisDiss  7.643860e-01  4.278733e-02
      6556 1988   466_554635      JaccardDiss  4.347826e-01 -1.992771e-03
      6557 1988   466_554635 MorisitaHornDiss  1.185817e-01  1.817421e-02
      6558 1988   466_554635   BrayCurtisDiss  2.851905e-01  1.901468e-02
      6559 1994   466_554635      JaccardDiss  3.846154e-01 -1.992771e-03
      6560 1994   466_554635 MorisitaHornDiss  3.613177e-01  1.817421e-02
      6561 1994   466_554635   BrayCurtisDiss  7.638308e-01  1.901468e-02
      6562 1996   466_554635      JaccardDiss  3.846154e-01 -1.992771e-03
      6563 1996   466_554635 MorisitaHornDiss  1.910564e-01  1.817421e-02
      6564 1996   466_554635   BrayCurtisDiss  6.604765e-01  1.901468e-02
      6565 1997   466_554635      JaccardDiss  4.166667e-01 -1.992771e-03
      6566 1997   466_554635 MorisitaHornDiss  1.428915e-01  1.817421e-02
      6567 1997   466_554635   BrayCurtisDiss  3.003658e-01  1.901468e-02
      6568 1998   466_554635      JaccardDiss  5.416667e-01 -1.992771e-03
      6569 1998   466_554635 MorisitaHornDiss  2.461619e-01  1.817421e-02
      6570 1998   466_554635   BrayCurtisDiss  4.397343e-01  1.901468e-02
      6571 1999   466_554635      JaccardDiss  3.181818e-01 -1.992771e-03
      6572 1999   466_554635 MorisitaHornDiss  5.085759e-01  1.817421e-02
      6573 1999   466_554635   BrayCurtisDiss  7.061491e-01  1.901468e-02
      6574 1995   466_554635      JaccardDiss  4.800000e-01 -1.992771e-03
      6575 1995   466_554635 MorisitaHornDiss  5.828207e-01  1.817421e-02
      6576 1995   466_554635   BrayCurtisDiss  8.151219e-01  1.901468e-02
      6577 2001   466_547348      JaccardDiss  3.888889e-01  2.171760e-03
      6578 2001   466_547348 MorisitaHornDiss  2.969133e-01 -1.293819e-02
      6579 2001   466_547348   BrayCurtisDiss  6.017660e-01 -1.296756e-02
      6580 2007   466_547348      JaccardDiss  3.684211e-01  2.171760e-03
      6581 2007   466_547348 MorisitaHornDiss  1.159869e-01 -1.293819e-02
      6582 2007   466_547348   BrayCurtisDiss  4.848485e-01 -1.296756e-02
      6583 1995   466_547348      JaccardDiss  3.684211e-01  2.171760e-03
      6584 1995   466_547348 MorisitaHornDiss  1.137089e-01 -1.293819e-02
      6585 1995   466_547348   BrayCurtisDiss  6.324747e-01 -1.296756e-02
      6586 2003   466_547348      JaccardDiss  5.000000e-01  2.171760e-03
      6587 2003   466_547348 MorisitaHornDiss  4.422863e-01 -1.293819e-02
      6588 2003   466_547348   BrayCurtisDiss  6.059528e-01 -1.296756e-02
      6589 1996   466_547348      JaccardDiss  4.000000e-01  2.171760e-03
      6590 1996   466_547348 MorisitaHornDiss  6.279650e-01 -1.293819e-02
      6591 1996   466_547348   BrayCurtisDiss  6.835353e-01 -1.296756e-02
      6592 1996   466_550260      JaccardDiss  5.000000e-01  8.686718e-04
      6593 1996   466_550260 MorisitaHornDiss  2.358325e-01  3.876020e-02
      6594 1996   466_550260   BrayCurtisDiss  7.336392e-01  3.339690e-02
      6595 1997   466_550260      JaccardDiss  5.833333e-01  8.686718e-04
      6596 1997   466_550260 MorisitaHornDiss  2.127493e-01  3.876020e-02
      6597 1997   466_550260   BrayCurtisDiss  3.386424e-01  3.339690e-02
      6598 2001   466_550260      JaccardDiss  5.172414e-01  8.686718e-04
      6599 2001   466_550260 MorisitaHornDiss  7.521330e-02  3.876020e-02
      6600 2001   466_550260   BrayCurtisDiss  6.914826e-01  3.339690e-02
      6601 2002   466_550260      JaccardDiss  3.750000e-01  8.686718e-04
      6602 2002   466_550260 MorisitaHornDiss  2.261750e-01  3.876020e-02
      6603 2002   466_550260   BrayCurtisDiss  5.738522e-01  3.339690e-02
      6604 2005   466_550260      JaccardDiss  5.625000e-01  8.686718e-04
      6605 2005   466_550260 MorisitaHornDiss  8.063681e-01  3.876020e-02
      6606 2005   466_550260   BrayCurtisDiss  9.555753e-01  3.339690e-02
      6607 2006   466_550260      JaccardDiss  5.769231e-01  8.686718e-04
      6608 2006   466_550260 MorisitaHornDiss  5.307274e-01  3.876020e-02
      6609 2006   466_550260   BrayCurtisDiss  9.378034e-01  3.339690e-02
      6610 2007   466_550260      JaccardDiss  5.172414e-01  8.686718e-04
      6611 2007   466_550260 MorisitaHornDiss  3.946001e-01  3.876020e-02
      6612 2007   466_550260   BrayCurtisDiss  7.671142e-01  3.339690e-02
      6613 2003   466_550260      JaccardDiss  5.555556e-01  8.686718e-04
      6614 2003   466_550260 MorisitaHornDiss  2.816324e-01  3.876020e-02
      6615 2003   466_550260   BrayCurtisDiss  8.611914e-01  3.339690e-02
      6616 2004   466_550260      JaccardDiss  4.761905e-01  8.686718e-04
      6617 2004   466_550260 MorisitaHornDiss  7.047547e-01  3.876020e-02
      6618 2004   466_550260   BrayCurtisDiss  7.793811e-01  3.339690e-02
      6619 1996   466_561192      JaccardDiss  4.642857e-01  2.931352e-04
      6620 1996   466_561192 MorisitaHornDiss  7.486629e-01 -9.150244e-03
      6621 1996   466_561192   BrayCurtisDiss  7.850340e-01 -1.088462e-02
      6622 2003   466_561192      JaccardDiss  4.074074e-01  2.931352e-04
      6623 2003   466_561192 MorisitaHornDiss  6.086066e-01 -9.150244e-03
      6624 2003   466_561192   BrayCurtisDiss  6.134904e-01 -1.088462e-02
      6625 2007   466_561192      JaccardDiss  4.137931e-01  2.931352e-04
      6626 2007   466_561192 MorisitaHornDiss  5.255715e-01 -9.150244e-03
      6627 2007   466_561192   BrayCurtisDiss  5.615561e-01 -1.088462e-02
      6628 1997   466_561192      JaccardDiss  5.000000e-01  2.931352e-04
      6629 1997   466_561192 MorisitaHornDiss  6.379498e-01 -9.150244e-03
      6630 1997   466_561192   BrayCurtisDiss  7.408066e-01 -1.088462e-02
      6631 1999   466_561192      JaccardDiss  2.916667e-01  2.931352e-04
      6632 1999   466_561192 MorisitaHornDiss  4.580290e-01 -9.150244e-03
      6633 1999   466_561192   BrayCurtisDiss  5.801457e-01 -1.088462e-02
      6634 2001   466_561192      JaccardDiss  2.800000e-01  2.931352e-04
      6635 2001   466_561192 MorisitaHornDiss  7.127433e-01 -9.150244e-03
      6636 2001   466_561192   BrayCurtisDiss  7.215640e-01 -1.088462e-02
      6637 2002   466_561192      JaccardDiss  5.185185e-01  2.931352e-04
      6638 2002   466_561192 MorisitaHornDiss  8.628396e-01 -9.150244e-03
      6639 2002   466_561192   BrayCurtisDiss  8.568588e-01 -1.088462e-02
      6640 2006   466_561192      JaccardDiss  4.444444e-01  2.931352e-04
      6641 2006   466_561192 MorisitaHornDiss  5.085242e-01 -9.150244e-03
      6642 2006   466_561192   BrayCurtisDiss  6.694427e-01 -1.088462e-02
      6643 2000   466_561192      JaccardDiss  5.000000e-01  2.931352e-04
      6644 2000   466_561192 MorisitaHornDiss  8.693593e-01 -9.150244e-03
      6645 2000   466_561192   BrayCurtisDiss  8.827634e-01 -1.088462e-02
      6646 2005   466_561192      JaccardDiss  4.800000e-01  2.931352e-04
      6647 2005   466_561192 MorisitaHornDiss  6.748916e-01 -9.150244e-03
      6648 2005   466_561192   BrayCurtisDiss  7.147846e-01 -1.088462e-02
      6649 2004   466_561192      JaccardDiss  5.769231e-01  2.931352e-04
      6650 2004   466_561192 MorisitaHornDiss  9.052599e-01 -9.150244e-03
      6651 2004   466_561192   BrayCurtisDiss  8.451357e-01 -1.088462e-02
      6652 2008   466_561192      JaccardDiss  4.000000e-01  2.931352e-04
      6653 2008   466_561192 MorisitaHornDiss  5.998104e-01 -9.150244e-03
      6654 2008   466_561192   BrayCurtisDiss  6.305221e-01 -1.088462e-02
      6655 2007   466_557559      JaccardDiss  5.806452e-01 -9.784353e-03
      6656 2007   466_557559 MorisitaHornDiss  5.542819e-01 -4.944007e-03
      6657 2007   466_557559   BrayCurtisDiss  5.730876e-01  2.488356e-03
      6658 1997   466_557559      JaccardDiss  6.875000e-01 -9.784353e-03
      6659 1997   466_557559 MorisitaHornDiss  6.547139e-01 -4.944007e-03
      6660 1997   466_557559   BrayCurtisDiss  6.180538e-01  2.488356e-03
      6661 2000   466_557559      JaccardDiss  5.714286e-01 -9.784353e-03
      6662 2000   466_557559 MorisitaHornDiss  8.154472e-01 -4.944007e-03
      6663 2000   466_557559   BrayCurtisDiss  7.983282e-01  2.488356e-03
      6664 2002   466_557559      JaccardDiss  4.827586e-01 -9.784353e-03
      6665 2002   466_557559 MorisitaHornDiss  2.477330e-01 -4.944007e-03
      6666 2002   466_557559   BrayCurtisDiss  5.511918e-01  2.488356e-03
      6667 2005   466_557559      JaccardDiss  2.307692e-01 -9.784353e-03
      6668 2005   466_557559 MorisitaHornDiss  2.811152e-01 -4.944007e-03
      6669 2005   466_557559   BrayCurtisDiss  7.296530e-01  2.488356e-03
      6670 2008   466_557559      JaccardDiss  5.357143e-01 -9.784353e-03
      6671 2008   466_557559 MorisitaHornDiss  7.067142e-01 -4.944007e-03
      6672 2008   466_557559   BrayCurtisDiss  6.837289e-01  2.488356e-03
      6673 1999   466_557559      JaccardDiss  6.000000e-01 -9.784353e-03
      6674 1999   466_557559 MorisitaHornDiss  4.945495e-01 -4.944007e-03
      6675 1999   466_557559   BrayCurtisDiss  7.083101e-01  2.488356e-03
      6676 2004   466_557559      JaccardDiss  6.000000e-01 -9.784353e-03
      6677 2004   466_557559 MorisitaHornDiss  2.183690e-01 -4.944007e-03
      6678 2004   466_557559   BrayCurtisDiss  7.040706e-01  2.488356e-03
      6679 2006   466_557559      JaccardDiss  5.806452e-01 -9.784353e-03
      6680 2006   466_557559 MorisitaHornDiss  6.215089e-01 -4.944007e-03
      6681 2006   466_557559   BrayCurtisDiss  6.453506e-01  2.488356e-03
      6682 1998   466_557559      JaccardDiss  5.806452e-01 -9.784353e-03
      6683 1998   466_557559 MorisitaHornDiss  6.664915e-01 -4.944007e-03
      6684 1998   466_557559   BrayCurtisDiss  6.665981e-01  2.488356e-03
      6685 2003   466_557559      JaccardDiss  6.428571e-01 -9.784353e-03
      6686 2003   466_557559 MorisitaHornDiss  7.949202e-01 -4.944007e-03
      6687 2003   466_557559   BrayCurtisDiss  7.978628e-01  2.488356e-03
      6688 2001   466_557559      JaccardDiss  4.166667e-01 -9.784353e-03
      6689 2001   466_557559 MorisitaHornDiss  1.318176e-01 -4.944007e-03
      6690 2001   466_557559   BrayCurtisDiss  2.479839e-01  2.488356e-03
      6691 1997   466_559013      JaccardDiss  3.076923e-01  5.968463e-03
      6692 1997   466_559013 MorisitaHornDiss  2.796620e-01  3.452341e-03
      6693 1997   466_559013   BrayCurtisDiss  4.200187e-01  1.878804e-02
      6694 1996   466_559013      JaccardDiss  5.769231e-01  5.968463e-03
      6695 1996   466_559013 MorisitaHornDiss  2.544851e-01  3.452341e-03
      6696 1996   466_559013   BrayCurtisDiss  4.596899e-01  1.878804e-02
      6697 2005   466_559013      JaccardDiss  6.250000e-01  5.968463e-03
      6698 2005   466_559013 MorisitaHornDiss  4.899654e-01  3.452341e-03
      6699 2005   466_559013   BrayCurtisDiss  6.016807e-01  1.878804e-02
      6700 2006   466_559013      JaccardDiss  5.185185e-01  5.968463e-03
      6701 2006   466_559013 MorisitaHornDiss  4.287522e-01  3.452341e-03
      6702 2006   466_559013   BrayCurtisDiss  5.618238e-01  1.878804e-02
      6703 2008   466_559013      JaccardDiss  5.000000e-01  5.968463e-03
      6704 2008   466_559013 MorisitaHornDiss  6.503728e-02  3.452341e-03
      6705 2008   466_559013   BrayCurtisDiss  5.622162e-01  1.878804e-02
      6706 2004   466_559013      JaccardDiss  5.185185e-01  5.968463e-03
      6707 2004   466_559013 MorisitaHornDiss  2.711704e-01  3.452341e-03
      6708 2004   466_559013   BrayCurtisDiss  4.718666e-01  1.878804e-02
      6709 2007   466_559013      JaccardDiss  4.800000e-01  5.968463e-03
      6710 2007   466_559013 MorisitaHornDiss  5.505172e-01  3.452341e-03
      6711 2007   466_559013   BrayCurtisDiss  8.819700e-01  1.878804e-02
      6712 2001   466_559013      JaccardDiss  5.000000e-01  5.968463e-03
      6713 2001   466_559013 MorisitaHornDiss  5.540542e-01  3.452341e-03
      6714 2001   466_559013   BrayCurtisDiss  6.281206e-01  1.878804e-02
      6715 1999   466_546637      JaccardDiss  2.666667e-01  2.698413e-02
      6716 1999   466_546637 MorisitaHornDiss  4.818153e-02 -7.740778e-02
      6717 1999   466_546637   BrayCurtisDiss  2.867009e-01 -8.936618e-02
      6718 2000   466_546637      JaccardDiss  4.444444e-01  2.698413e-02
      6719 2000   466_546637 MorisitaHornDiss  1.997623e-01 -7.740778e-02
      6720 2000   466_546637   BrayCurtisDiss  3.433650e-01 -8.936618e-02
      6721 1997   466_546637      JaccardDiss  3.333333e-01  2.698413e-02
      6722 1997   466_546637 MorisitaHornDiss  3.861880e-01 -7.740778e-02
      6723 1997   466_546637   BrayCurtisDiss  5.822575e-01 -8.936618e-02
      6724 1998   466_565569      JaccardDiss  3.750000e-01  6.432412e-03
      6725 1998   466_565569 MorisitaHornDiss  9.558177e-01 -5.614719e-02
      6726 1998   466_565569   BrayCurtisDiss  8.286761e-01 -2.924079e-02
      6727 2003   466_565569      JaccardDiss  3.809524e-01  6.432412e-03
      6728 2003   466_565569 MorisitaHornDiss  9.284501e-01 -5.614719e-02
      6729 2003   466_565569   BrayCurtisDiss  8.261079e-01 -2.924079e-02
      6730 2004   466_565569      JaccardDiss  4.285714e-01  6.432412e-03
      6731 2004   466_565569 MorisitaHornDiss  4.741526e-01 -5.614719e-02
      6732 2004   466_565569   BrayCurtisDiss  5.711538e-01 -2.924079e-02
      6733 1999   466_555373      JaccardDiss  4.090909e-01 -1.683420e-03
      6734 1999   466_555373 MorisitaHornDiss  1.805223e-01 -3.868789e-03
      6735 1999   466_555373   BrayCurtisDiss  5.217772e-01 -1.658038e-02
      6736 2001   466_555373      JaccardDiss  5.217391e-01 -1.683420e-03
      6737 2001   466_555373 MorisitaHornDiss  2.426741e-03 -3.868789e-03
      6738 2001   466_555373   BrayCurtisDiss  5.471918e-01 -1.658038e-02
      6739 2002   466_555373      JaccardDiss  4.090909e-01 -1.683420e-03
      6740 2002   466_555373 MorisitaHornDiss  3.300483e-01 -3.868789e-03
      6741 2002   466_555373   BrayCurtisDiss  4.572097e-01 -1.658038e-02
      6742 2003   466_555373      JaccardDiss  3.500000e-01 -1.683420e-03
      6743 2003   466_555373 MorisitaHornDiss  7.968905e-01 -3.868789e-03
      6744 2003   466_555373   BrayCurtisDiss  7.380998e-01 -1.658038e-02
      6745 2005   466_555373      JaccardDiss  4.583333e-01 -1.683420e-03
      6746 2005   466_555373 MorisitaHornDiss  3.520748e-02 -3.868789e-03
      6747 2005   466_555373   BrayCurtisDiss  6.516368e-01 -1.658038e-02
      6748 1996   466_555373      JaccardDiss  5.909091e-01 -1.683420e-03
      6749 1996   466_555373 MorisitaHornDiss  8.084917e-01 -3.868789e-03
      6750 1996   466_555373   BrayCurtisDiss  7.570613e-01 -1.658038e-02
      6751 2006   466_555373      JaccardDiss  3.684211e-01 -1.683420e-03
      6752 2006   466_555373 MorisitaHornDiss  2.266758e-02 -3.868789e-03
      6753 2006   466_555373   BrayCurtisDiss  3.952949e-01 -1.658038e-02
      6754 2000   466_555373      JaccardDiss  4.545455e-01 -1.683420e-03
      6755 2000   466_555373 MorisitaHornDiss  6.168845e-01 -3.868789e-03
      6756 2000   466_555373   BrayCurtisDiss  6.430530e-01 -1.658038e-02
      6757 2004   466_555373      JaccardDiss  6.363636e-01 -1.683420e-03
      6758 2004   466_555373 MorisitaHornDiss  8.255392e-01 -3.868789e-03
      6759 2004   466_555373   BrayCurtisDiss  8.932883e-01 -1.658038e-02
      6760 2007   466_555373      JaccardDiss  5.000000e-01 -1.683420e-03
      6761 2007   466_555373 MorisitaHornDiss  5.851293e-02 -3.868789e-03
      6762 2007   466_555373   BrayCurtisDiss  2.024024e-01 -1.658038e-02
      6763 1992   466_555373      JaccardDiss  5.000000e-01 -1.683420e-03
      6764 1992   466_555373 MorisitaHornDiss  8.820962e-03 -3.868789e-03
      6765 1992   466_555373   BrayCurtisDiss  6.114177e-01 -1.658038e-02
      6766 1997   466_555373      JaccardDiss  3.333333e-01 -1.683420e-03
      6767 1997   466_555373 MorisitaHornDiss  1.873279e-01 -3.868789e-03
      6768 1997   466_555373   BrayCurtisDiss  7.626400e-01 -1.658038e-02
      6769 2001   466_559006      JaccardDiss  4.800000e-01  5.556527e-03
      6770 2001   466_559006 MorisitaHornDiss  6.411167e-01 -4.618376e-02
      6771 2001   466_559006   BrayCurtisDiss  8.320395e-01 -3.097889e-02
      6772 2007   466_559006      JaccardDiss  4.400000e-01  5.556527e-03
      6773 2007   466_559006 MorisitaHornDiss  4.691513e-01 -4.618376e-02
      6774 2007   466_559006   BrayCurtisDiss  6.384181e-01 -3.097889e-02
      6775 2002   466_559006      JaccardDiss  5.416667e-01  5.556527e-03
      6776 2002   466_559006 MorisitaHornDiss  6.312030e-01 -4.618376e-02
      6777 2002   466_559006   BrayCurtisDiss  7.622642e-01 -3.097889e-02
      6778 2008   466_559006      JaccardDiss  5.909091e-01  5.556527e-03
      6779 2008   466_559006 MorisitaHornDiss  4.373113e-01 -4.618376e-02
      6780 2008   466_559006   BrayCurtisDiss  6.375546e-01 -3.097889e-02
      6781 2005   466_559006      JaccardDiss  5.416667e-01  5.556527e-03
      6782 2005   466_559006 MorisitaHornDiss  5.983529e-01 -4.618376e-02
      6783 2005   466_559006   BrayCurtisDiss  7.090909e-01 -3.097889e-02
      6784 2006   466_559006      JaccardDiss  5.384615e-01  5.556527e-03
      6785 2006   466_559006 MorisitaHornDiss  3.465573e-01 -4.618376e-02
      6786 2006   466_559006   BrayCurtisDiss  7.168142e-01 -3.097889e-02
      6787 2004   466_559006      JaccardDiss  4.583333e-01  5.556527e-03
      6788 2004   466_559006 MorisitaHornDiss  5.284231e-01 -4.618376e-02
      6789 2004   466_559006   BrayCurtisDiss  8.265896e-01 -3.097889e-02
      6790 2003   466_559006      JaccardDiss  5.000000e-01  5.556527e-03
      6791 2003   466_559006 MorisitaHornDiss  9.173805e-01 -4.618376e-02
      6792 2003   466_559006   BrayCurtisDiss  8.848485e-01 -3.097889e-02
      6793 2002   466_542997      JaccardDiss  2.307692e-01  3.854910e-04
      6794 2002   466_542997 MorisitaHornDiss  3.455779e-02  9.138167e-03
      6795 2002   466_542997   BrayCurtisDiss  6.458187e-01 -9.225698e-03
      6796 2003   466_542997      JaccardDiss  4.074074e-01  3.854910e-04
      6797 2003   466_542997 MorisitaHornDiss  1.008426e-01  9.138167e-03
      6798 2003   466_542997   BrayCurtisDiss  3.069307e-01 -9.225698e-03
      6799 2005   466_542997      JaccardDiss  3.076923e-01  3.854910e-04
      6800 2005   466_542997 MorisitaHornDiss  3.654088e-02  9.138167e-03
      6801 2005   466_542997   BrayCurtisDiss  6.558275e-01 -9.225698e-03
      6802 2001   466_542997      JaccardDiss  4.814815e-01  3.854910e-04
      6803 2001   466_542997 MorisitaHornDiss  5.161858e-02  9.138167e-03
      6804 2001   466_542997   BrayCurtisDiss  6.090835e-01 -9.225698e-03
      6805 2004   466_542997      JaccardDiss  4.285714e-01  3.854910e-04
      6806 2004   466_542997 MorisitaHornDiss  3.006292e-01  9.138167e-03
      6807 2004   466_542997   BrayCurtisDiss  4.749734e-01 -9.225698e-03
      6808 2006   466_542997      JaccardDiss  5.517241e-01  3.854910e-04
      6809 2006   466_542997 MorisitaHornDiss  1.981871e-01  9.138167e-03
      6810 2006   466_542997   BrayCurtisDiss  3.715925e-01 -9.225698e-03
      6811 2007   466_542997      JaccardDiss  3.043478e-01  3.854910e-04
      6812 2007   466_542997 MorisitaHornDiss  4.925586e-02  9.138167e-03
      6813 2007   466_542997   BrayCurtisDiss  5.894955e-01 -9.225698e-03
      6814 1986   466_549551      JaccardDiss  2.777778e-01  4.040248e-03
      6815 1986   466_549551 MorisitaHornDiss  1.649196e-02  9.728633e-03
      6816 1986   466_549551   BrayCurtisDiss  5.201916e-01 -3.214772e-03
      6817 1987   466_549551      JaccardDiss  3.000000e-01  4.040248e-03
      6818 1987   466_549551 MorisitaHornDiss  2.495333e-01  9.728633e-03
      6819 1987   466_549551   BrayCurtisDiss  6.909200e-01 -3.214772e-03
      6820 1993   466_549551      JaccardDiss  3.333333e-01  4.040248e-03
      6821 1993   466_549551 MorisitaHornDiss  5.904705e-01  9.728633e-03
      6822 1993   466_549551   BrayCurtisDiss  5.775367e-01 -3.214772e-03
      6823 1994   466_549551      JaccardDiss  3.636364e-01  4.040248e-03
      6824 1994   466_549551 MorisitaHornDiss  1.640853e-01  9.728633e-03
      6825 1994   466_549551   BrayCurtisDiss  4.601227e-01 -3.214772e-03
      6826 1995   466_549551      JaccardDiss  3.157895e-01  4.040248e-03
      6827 1995   466_549551 MorisitaHornDiss  1.793659e-01  9.728633e-03
      6828 1995   466_549551   BrayCurtisDiss  6.234829e-01 -3.214772e-03
      6829 1997   466_549551      JaccardDiss  2.777778e-01  4.040248e-03
      6830 1997   466_549551 MorisitaHornDiss  2.274838e-01  9.728633e-03
      6831 1997   466_549551   BrayCurtisDiss  7.645516e-01 -3.214772e-03
      6832 1998   466_549551      JaccardDiss  1.764706e-01  4.040248e-03
      6833 1998   466_549551 MorisitaHornDiss  1.916609e-01  9.728633e-03
      6834 1998   466_549551   BrayCurtisDiss  4.296788e-01 -3.214772e-03
      6835 1999   466_549551      JaccardDiss  3.500000e-01  4.040248e-03
      6836 1999   466_549551 MorisitaHornDiss  2.449982e-01  9.728633e-03
      6837 1999   466_549551   BrayCurtisDiss  4.836643e-01 -3.214772e-03
      6838 2002   466_549551      JaccardDiss  5.500000e-01  4.040248e-03
      6839 2002   466_549551 MorisitaHornDiss  2.092434e-01  9.728633e-03
      6840 2002   466_549551   BrayCurtisDiss  7.787913e-01 -3.214772e-03
      6841 2006   466_549551      JaccardDiss  4.545455e-01  4.040248e-03
      6842 2006   466_549551 MorisitaHornDiss  1.863512e-02  9.728633e-03
      6843 2006   466_549551   BrayCurtisDiss  4.396396e-01 -3.214772e-03
      6844 1988   466_549551      JaccardDiss  5.500000e-01  4.040248e-03
      6845 1988   466_549551 MorisitaHornDiss  3.962017e-02  9.728633e-03
      6846 1988   466_549551   BrayCurtisDiss  8.761235e-01 -3.214772e-03
      6847 2003   466_549551      JaccardDiss  4.210526e-01  4.040248e-03
      6848 2003   466_549551 MorisitaHornDiss  2.209726e-01  9.728633e-03
      6849 2003   466_549551   BrayCurtisDiss  5.853946e-01 -3.214772e-03
      6850 1991   466_549551      JaccardDiss  4.000000e-01  4.040248e-03
      6851 1991   466_549551 MorisitaHornDiss  5.873055e-02  9.728633e-03
      6852 1991   466_549551   BrayCurtisDiss  3.674242e-01 -3.214772e-03
      6853 2000   466_549551      JaccardDiss  5.714286e-01  4.040248e-03
      6854 2000   466_549551 MorisitaHornDiss  8.926958e-01  9.728633e-03
      6855 2000   466_549551   BrayCurtisDiss  8.808140e-01 -3.214772e-03
      6856 2007   466_549551      JaccardDiss  3.157895e-01  4.040248e-03
      6857 2007   466_549551 MorisitaHornDiss  3.684781e-02  9.728633e-03
      6858 2007   466_549551   BrayCurtisDiss  1.964179e-01 -3.214772e-03
      6859 1996   466_549551      JaccardDiss  2.777778e-01  4.040248e-03
      6860 1996   466_549551 MorisitaHornDiss  9.532655e-02  9.728633e-03
      6861 1996   466_549551   BrayCurtisDiss  4.730101e-01 -3.214772e-03
      6862 2001   466_549551      JaccardDiss  4.444444e-01  4.040248e-03
      6863 2001   466_549551 MorisitaHornDiss  4.069022e-02  9.728633e-03
      6864 2001   466_549551   BrayCurtisDiss  1.810811e-01 -3.214772e-03
      6865 2004   466_549551      JaccardDiss  6.250000e-01  4.040248e-03
      6866 2004   466_549551 MorisitaHornDiss  5.430311e-01  9.728633e-03
      6867 2004   466_549551   BrayCurtisDiss  9.302615e-01 -3.214772e-03
      6868 2005   466_549551      JaccardDiss  4.705882e-01  4.040248e-03
      6869 2005   466_549551 MorisitaHornDiss  8.498807e-01  9.728633e-03
      6870 2005   466_549551   BrayCurtisDiss  8.409854e-01 -3.214772e-03
      6871 2008   466_549551      JaccardDiss  2.631579e-01  4.040248e-03
      6872 2008   466_549551 MorisitaHornDiss  2.840907e-01  9.728633e-03
      6873 2008   466_549551   BrayCurtisDiss  5.155385e-01 -3.214772e-03
      6874 1988   466_547364      JaccardDiss  3.684211e-01 -4.677615e-04
      6875 1988   466_547364 MorisitaHornDiss  6.255552e-02  1.436329e-02
      6876 1988   466_547364   BrayCurtisDiss  2.719665e-01  1.542822e-02
      6877 2002   466_547364      JaccardDiss  3.157895e-01 -4.677615e-04
      6878 2002   466_547364 MorisitaHornDiss  5.511364e-02  1.436329e-02
      6879 2002   466_547364   BrayCurtisDiss  4.857027e-01  1.542822e-02
      6880 2003   466_547364      JaccardDiss  3.157895e-01 -4.677615e-04
      6881 2003   466_547364 MorisitaHornDiss  8.624394e-01  1.436329e-02
      6882 2003   466_547364   BrayCurtisDiss  7.973600e-01  1.542822e-02
      6883 2001   466_547364      JaccardDiss  5.263158e-01 -4.677615e-04
      6884 2001   466_547364 MorisitaHornDiss  8.977444e-01  1.436329e-02
      6885 2001   466_547364   BrayCurtisDiss  9.077498e-01  1.542822e-02
      6886 2006   466_547364      JaccardDiss  3.000000e-01 -4.677615e-04
      6887 2006   466_547364 MorisitaHornDiss  1.556945e-01  1.436329e-02
      6888 2006   466_547364   BrayCurtisDiss  4.751186e-01  1.542822e-02
      6889 2004   466_547364      JaccardDiss  3.684211e-01 -4.677615e-04
      6890 2004   466_547364 MorisitaHornDiss  7.376151e-01  1.436329e-02
      6891 2004   466_547364   BrayCurtisDiss  8.641822e-01  1.542822e-02
      6892 2005   466_547364      JaccardDiss  4.736842e-01 -4.677615e-04
      6893 2005   466_547364 MorisitaHornDiss  1.153411e-02  1.436329e-02
      6894 2005   466_547364   BrayCurtisDiss  2.747278e-01  1.542822e-02
      6895 2002   466_550991      JaccardDiss  2.500000e-01 -2.019163e-03
      6896 2002   466_550991 MorisitaHornDiss  1.492084e-01 -2.733600e-02
      6897 2002   466_550991   BrayCurtisDiss  6.728838e-01 -4.188695e-02
      6898 2005   466_550991      JaccardDiss  4.285714e-01 -2.019163e-03
      6899 2005   466_550991 MorisitaHornDiss  4.971554e-01 -2.733600e-02
      6900 2005   466_550991   BrayCurtisDiss  6.021913e-01 -4.188695e-02
      6901 2007   466_550991      JaccardDiss  2.500000e-01 -2.019163e-03
      6902 2007   466_550991 MorisitaHornDiss  2.826622e-01 -2.733600e-02
      6903 2007   466_550991   BrayCurtisDiss  6.148981e-01 -4.188695e-02
      6904 2004   466_550991      JaccardDiss  4.827586e-01 -2.019163e-03
      6905 2004   466_550991 MorisitaHornDiss  6.655929e-01 -2.733600e-02
      6906 2004   466_550991   BrayCurtisDiss  6.839536e-01 -4.188695e-02
      6907 2006   466_550991      JaccardDiss  4.230769e-01 -2.019163e-03
      6908 2006   466_550991 MorisitaHornDiss  2.885952e-01 -2.733600e-02
      6909 2006   466_550991   BrayCurtisDiss  4.168174e-01 -4.188695e-02
      6910 2003   466_550991      JaccardDiss  4.285714e-01 -2.019163e-03
      6911 2003   466_550991 MorisitaHornDiss  7.737924e-01 -2.733600e-02
      6912 2003   466_550991   BrayCurtisDiss  7.816016e-01 -4.188695e-02
      6913 2003   466_543709      JaccardDiss  3.888889e-01 -8.428047e-17
      6914 2003   466_543709 MorisitaHornDiss  2.435148e-02  8.470660e-02
      6915 2003   466_543709   BrayCurtisDiss  3.114035e-01  3.013440e-02
      6916 2005   466_543709      JaccardDiss  3.888889e-01 -8.428047e-17
      6917 2005   466_543709 MorisitaHornDiss  7.150436e-01  8.470660e-02
      6918 2005   466_543709   BrayCurtisDiss  6.908328e-01  3.013440e-02
      6919 2006   466_543709      JaccardDiss  4.000000e-01 -8.428047e-17
      6920 2006   466_543709 MorisitaHornDiss  6.622078e-01  8.470660e-02
      6921 2006   466_543709   BrayCurtisDiss  5.602923e-01  3.013440e-02
      6922 2002   466_543709      JaccardDiss  4.000000e-01 -8.428047e-17
      6923 2002   466_543709 MorisitaHornDiss  5.840209e-01  8.470660e-02
      6924 2002   466_543709   BrayCurtisDiss  5.993350e-01  3.013440e-02
      6925 1988   466_558285      JaccardDiss  4.230769e-01  1.502166e-03
      6926 1988   466_558285 MorisitaHornDiss  3.938646e-01  1.509121e-02
      6927 1988   466_558285   BrayCurtisDiss  8.655185e-01 -5.537518e-03
      6928 2000   466_558285      JaccardDiss  5.357143e-01  1.502166e-03
      6929 2000   466_558285 MorisitaHornDiss  5.213024e-01  1.509121e-02
      6930 2000   466_558285   BrayCurtisDiss  5.352785e-01 -5.537518e-03
      6931 2003   466_558285      JaccardDiss  5.666667e-01  1.502166e-03
      6932 2003   466_558285 MorisitaHornDiss  7.266076e-01  1.509121e-02
      6933 2003   466_558285   BrayCurtisDiss  6.396614e-01 -5.537518e-03
      6934 2004   466_558285      JaccardDiss  4.482759e-01  1.502166e-03
      6935 2004   466_558285 MorisitaHornDiss  3.237672e-01  1.509121e-02
      6936 2004   466_558285   BrayCurtisDiss  8.442869e-01 -5.537518e-03
      6937 1990   466_558285      JaccardDiss  4.800000e-01  1.502166e-03
      6938 1990   466_558285 MorisitaHornDiss  2.888696e-01  1.509121e-02
      6939 1990   466_558285   BrayCurtisDiss  7.791815e-01 -5.537518e-03
      6940 2001   466_558285      JaccardDiss  5.000000e-01  1.502166e-03
      6941 2001   466_558285 MorisitaHornDiss  1.392794e-01  1.509121e-02
      6942 2001   466_558285   BrayCurtisDiss  6.766542e-01 -5.537518e-03
      6943 2002   466_558285      JaccardDiss  5.357143e-01  1.502166e-03
      6944 2002   466_558285 MorisitaHornDiss  7.603268e-01  1.509121e-02
      6945 2002   466_558285   BrayCurtisDiss  7.078449e-01 -5.537518e-03
      6946 2005   466_558285      JaccardDiss  4.583333e-01  1.502166e-03
      6947 2005   466_558285 MorisitaHornDiss  6.294866e-01  1.509121e-02
      6948 2005   466_558285   BrayCurtisDiss  6.297710e-01 -5.537518e-03
      6949 2007   466_558285      JaccardDiss  4.347826e-01  1.502166e-03
      6950 2007   466_558285 MorisitaHornDiss  6.549363e-01  1.509121e-02
      6951 2007   466_558285   BrayCurtisDiss  8.162358e-01 -5.537518e-03
      6952 2006   466_559742      JaccardDiss  3.913043e-01 -3.024845e-02
      6953 2006   466_559742 MorisitaHornDiss  5.359811e-01  1.058186e-01
      6954 2006   466_559742   BrayCurtisDiss  5.796738e-01  5.665359e-02
      6955 2008   466_559742      JaccardDiss  2.380952e-01 -3.024845e-02
      6956 2008   466_559742 MorisitaHornDiss  6.457551e-01  1.058186e-01
      6957 2008   466_559742   BrayCurtisDiss  7.162481e-01  5.665359e-02
      6958 2004   466_559742      JaccardDiss  3.500000e-01 -3.024845e-02
      6959 2004   466_559742 MorisitaHornDiss  2.547746e-01  1.058186e-01
      6960 2004   466_559742   BrayCurtisDiss  4.154282e-01  5.665359e-02
      6961 2005   466_559742      JaccardDiss  3.809524e-01 -3.024845e-02
      6962 2005   466_559742 MorisitaHornDiss  2.869011e-01  1.058186e-01
      6963 2005   466_559742   BrayCurtisDiss  7.116781e-01  5.665359e-02
      6964 2003   466_541538      JaccardDiss  4.000000e-01 -7.894737e-03
      6965 2003   466_541538 MorisitaHornDiss  2.948255e-02  8.900149e-03
      6966 2003   466_541538   BrayCurtisDiss  5.370166e-01 -7.372180e-02
      6967 2005   466_541538      JaccardDiss  3.913043e-01 -7.894737e-03
      6968 2005   466_541538 MorisitaHornDiss  5.423220e-02  8.900149e-03
      6969 2005   466_541538   BrayCurtisDiss  5.450183e-01 -7.372180e-02
      6970 2007   466_541538      JaccardDiss  3.684211e-01 -7.894737e-03
      6971 2007   466_541538 MorisitaHornDiss  6.508315e-02  8.900149e-03
      6972 2007   466_541538   BrayCurtisDiss  2.421294e-01 -7.372180e-02
      6973 1994   466_548092      JaccardDiss  3.500000e-01  4.895659e-03
      6974 1994   466_548092 MorisitaHornDiss  3.338623e-02  7.366200e-03
      6975 1994   466_548092   BrayCurtisDiss  7.721911e-01 -1.152791e-02
      6976 2006   466_548092      JaccardDiss  4.500000e-01  4.895659e-03
      6977 2006   466_548092 MorisitaHornDiss  1.918429e-01  7.366200e-03
      6978 2006   466_548092   BrayCurtisDiss  5.762920e-01 -1.152791e-02
      6979 1991   466_548092      JaccardDiss  4.736842e-01  4.895659e-03
      6980 1991   466_548092 MorisitaHornDiss  2.183533e-01  7.366200e-03
      6981 1991   466_548092   BrayCurtisDiss  6.845838e-01 -1.152791e-02
      6982 2002   466_548092      JaccardDiss  5.714286e-01  4.895659e-03
      6983 2002   466_548092 MorisitaHornDiss  3.478474e-01  7.366200e-03
      6984 2002   466_548092   BrayCurtisDiss  5.626978e-01 -1.152791e-02
      6985 2006   466_546636      JaccardDiss  3.888889e-01  9.126984e-02
      6986 2006   466_546636 MorisitaHornDiss  6.526075e-01 -2.025256e-01
      6987 2006   466_546636   BrayCurtisDiss  6.078431e-01  8.509944e-02
      6988 2008   466_546636      JaccardDiss  5.714286e-01  9.126984e-02
      6989 2008   466_546636 MorisitaHornDiss  2.475563e-01 -2.025256e-01
      6990 2008   466_546636   BrayCurtisDiss  7.780420e-01  8.509944e-02
      6991 2007   466_546636      JaccardDiss  5.500000e-01  9.126984e-02
      6992 2007   466_546636 MorisitaHornDiss  5.322484e-01 -2.025256e-01
      6993 2007   466_546636   BrayCurtisDiss  8.229942e-01  8.509944e-02
      6994 2000   466_554647      JaccardDiss  2.941176e-01  1.890206e-02
      6995 2000   466_554647 MorisitaHornDiss  1.881258e-01 -2.688611e-03
      6996 2000   466_554647   BrayCurtisDiss  3.731148e-01 -1.612770e-03
      6997 2001   466_554647      JaccardDiss  3.750000e-01  1.890206e-02
      6998 2001   466_554647 MorisitaHornDiss  8.850861e-01 -2.688611e-03
      6999 2001   466_554647   BrayCurtisDiss  8.638106e-01 -1.612770e-03
      7000 2006   466_554647      JaccardDiss  4.444444e-01  1.890206e-02
      7001 2006   466_554647 MorisitaHornDiss  5.444850e-01 -2.688611e-03
      7002 2006   466_554647   BrayCurtisDiss  5.704790e-01 -1.612770e-03
      7003 2004   466_554647      JaccardDiss  6.190476e-01  1.890206e-02
      7004 2004   466_554647 MorisitaHornDiss  9.141845e-01 -2.688611e-03
      7005 2004   466_554647   BrayCurtisDiss  9.086521e-01 -1.612770e-03
      7006 2007   466_554647      JaccardDiss  5.789474e-01  1.890206e-02
      7007 2007   466_554647 MorisitaHornDiss  7.124331e-01 -2.688611e-03
      7008 2007   466_554647   BrayCurtisDiss  7.807457e-01 -1.612770e-03
      7009 2008   466_554647      JaccardDiss  4.117647e-01  1.890206e-02
      7010 2008   466_554647 MorisitaHornDiss  3.810551e-01 -2.688611e-03
      7011 2008   466_554647   BrayCurtisDiss  4.821504e-01 -1.612770e-03
      7012 2002   466_554647      JaccardDiss  4.375000e-01  1.890206e-02
      7013 2002   466_554647 MorisitaHornDiss  7.493339e-01 -2.688611e-03
      7014 2002   466_554647   BrayCurtisDiss  7.107232e-01 -1.612770e-03
      7015 2007   466_555328      JaccardDiss  3.333333e-01 -2.818646e-03
      7016 2007   466_555328 MorisitaHornDiss  5.168950e-01  7.969224e-03
      7017 2007   466_555328   BrayCurtisDiss  6.933055e-01  5.812112e-03
      7018 1988   466_555328      JaccardDiss  4.285714e-01 -2.818646e-03
      7019 1988   466_555328 MorisitaHornDiss  3.815770e-01  7.969224e-03
      7020 1988   466_555328   BrayCurtisDiss  4.577233e-01  5.812112e-03
      7021 1991   466_555328      JaccardDiss  5.294118e-01 -2.818646e-03
      7022 1991   466_555328 MorisitaHornDiss  5.063574e-01  7.969224e-03
      7023 1991   466_555328   BrayCurtisDiss  8.900912e-01  5.812112e-03
      7024 1996   466_555328      JaccardDiss  3.076923e-01 -2.818646e-03
      7025 1996   466_555328 MorisitaHornDiss  3.615073e-01  7.969224e-03
      7026 1996   466_555328   BrayCurtisDiss  4.094050e-01  5.812112e-03
      7027 2003   466_555328      JaccardDiss  3.333333e-01 -2.818646e-03
      7028 2003   466_555328 MorisitaHornDiss  3.445976e-01  7.969224e-03
      7029 2003   466_555328   BrayCurtisDiss  5.040461e-01  5.812112e-03
      7030 2005   466_555328      JaccardDiss  3.846154e-01 -2.818646e-03
      7031 2005   466_555328 MorisitaHornDiss  4.316796e-01  7.969224e-03
      7032 2005   466_555328   BrayCurtisDiss  6.905455e-01  5.812112e-03
      7033 1995   466_555328      JaccardDiss  3.846154e-01 -2.818646e-03
      7034 1995   466_555328 MorisitaHornDiss  5.440191e-01  7.969224e-03
      7035 1995   466_555328   BrayCurtisDiss  8.441760e-01  5.812112e-03
      7036 1997   466_555328      JaccardDiss  6.923077e-01 -2.818646e-03
      7037 1997   466_555328 MorisitaHornDiss  4.646612e-01  7.969224e-03
      7038 1997   466_555328   BrayCurtisDiss  5.184722e-01  5.812112e-03
      7039 1990   466_555328      JaccardDiss  2.500000e-01 -2.818646e-03
      7040 1990   466_555328 MorisitaHornDiss  3.004549e-02  7.969224e-03
      7041 1990   466_555328   BrayCurtisDiss  3.374495e-01  5.812112e-03
      7042 2007   466_554598      JaccardDiss  5.000000e-01  1.041667e-02
      7043 2007   466_554598 MorisitaHornDiss  1.378248e-01 -4.522714e-02
      7044 2007   466_554598   BrayCurtisDiss  4.905395e-01 -1.649966e-02
      7045 1999   466_554598      JaccardDiss  4.166667e-01  1.041667e-02
      7046 1999   466_554598 MorisitaHornDiss  4.996419e-01 -4.522714e-02
      7047 1999   466_554598   BrayCurtisDiss  6.225368e-01 -1.649966e-02
      7048 2003   466_554598      JaccardDiss  1.111111e-01  1.041667e-02
      7049 2003   466_554598 MorisitaHornDiss  2.129913e-01 -4.522714e-02
      7050 2003   466_554598   BrayCurtisDiss  3.656444e-01 -1.649966e-02
      7051 1988   466_551691      JaccardDiss  4.615385e-01 -3.947202e-03
      7052 1988   466_551691 MorisitaHornDiss  4.809014e-03  5.159309e-04
      7053 1988   466_551691   BrayCurtisDiss  7.829895e-01 -3.315786e-02
      7054 1990   466_551691      JaccardDiss  3.333333e-01 -3.947202e-03
      7055 1990   466_551691 MorisitaHornDiss  7.841189e-03  5.159309e-04
      7056 1990   466_551691   BrayCurtisDiss  6.407464e-01 -3.315786e-02
      7057 1991   466_551691      JaccardDiss  5.000000e-01 -3.947202e-03
      7058 1991   466_551691 MorisitaHornDiss  1.296926e-02  5.159309e-04
      7059 1991   466_551691   BrayCurtisDiss  3.707820e-01 -3.315786e-02
      7060 1997   466_551691      JaccardDiss  3.846154e-01 -3.947202e-03
      7061 1997   466_551691 MorisitaHornDiss  1.096208e-02  5.159309e-04
      7062 1997   466_551691   BrayCurtisDiss  2.286479e-01 -3.315786e-02
      7063 1992   466_551691      JaccardDiss  5.384615e-01 -3.947202e-03
      7064 1992   466_551691 MorisitaHornDiss  7.741613e-03  5.159309e-04
      7065 1992   466_551691   BrayCurtisDiss  5.265461e-01 -3.315786e-02
      7066 1993   466_551691      JaccardDiss  5.384615e-01 -3.947202e-03
      7067 1993   466_551691 MorisitaHornDiss  8.038284e-03  5.159309e-04
      7068 1993   466_551691   BrayCurtisDiss  6.316264e-01 -3.315786e-02
      7069 1994   466_551691      JaccardDiss  5.384615e-01 -3.947202e-03
      7070 1994   466_551691 MorisitaHornDiss  2.554558e-02  5.159309e-04
      7071 1994   466_551691   BrayCurtisDiss  2.136068e-01 -3.315786e-02
      7072 1995   466_551691      JaccardDiss  3.571429e-01 -3.947202e-03
      7073 1995   466_551691 MorisitaHornDiss  1.130146e-03  5.159309e-04
      7074 1995   466_551691   BrayCurtisDiss  9.425880e-01 -3.315786e-02
      7075 1988   466_551689      JaccardDiss  3.571429e-01 -1.129450e-02
      7076 1988   466_551689 MorisitaHornDiss  6.671855e-03  1.758418e-03
      7077 1988   466_551689   BrayCurtisDiss  1.457984e-01  2.010090e-02
      7078 2006   466_551689      JaccardDiss  2.307692e-01 -1.129450e-02
      7079 2006   466_551689 MorisitaHornDiss  2.830974e-02  1.758418e-03
      7080 2006   466_551689   BrayCurtisDiss  5.647949e-01  2.010090e-02
      7081 1989   466_551689      JaccardDiss  4.666667e-01 -1.129450e-02
      7082 1989   466_551689 MorisitaHornDiss  1.406216e-02  1.758418e-03
      7083 1989   466_551689   BrayCurtisDiss  3.490735e-01  2.010090e-02
      7084 2007   466_551689      JaccardDiss  1.818182e-01 -1.129450e-02
      7085 2007   466_551689 MorisitaHornDiss  5.408043e-02  1.758418e-03
      7086 2007   466_551689   BrayCurtisDiss  6.404468e-01  2.010090e-02
      7087 1988   466_558239      JaccardDiss  2.307692e-01 -2.166650e-03
      7088 1988   466_558239 MorisitaHornDiss  4.523237e-03 -1.092335e-04
      7089 1988   466_558239   BrayCurtisDiss  1.713493e-01 -1.431536e-03
      7090 1989   466_558239      JaccardDiss  5.625000e-01 -2.166650e-03
      7091 1989   466_558239 MorisitaHornDiss  1.184042e-02 -1.092335e-04
      7092 1989   466_558239   BrayCurtisDiss  4.154445e-01 -1.431536e-03
      7093 1990   466_558239      JaccardDiss  5.625000e-01 -2.166650e-03
      7094 1990   466_558239 MorisitaHornDiss  6.758416e-03 -1.092335e-04
      7095 1990   466_558239   BrayCurtisDiss  4.607314e-01 -1.431536e-03
      7096 2003   466_558239      JaccardDiss  4.000000e-01 -2.166650e-03
      7097 2003   466_558239 MorisitaHornDiss  6.896279e-03 -1.092335e-04
      7098 2003   466_558239   BrayCurtisDiss  2.984480e-01 -1.431536e-03
      7099 1991   466_558239      JaccardDiss  5.333333e-01 -2.166650e-03
      7100 1991   466_558239 MorisitaHornDiss  1.599730e-02 -1.092335e-04
      7101 1991   466_558239   BrayCurtisDiss  3.136797e-01 -1.431536e-03
      7102 1991   466_552415      JaccardDiss  2.727273e-01  1.104283e-02
      7103 1991   466_552415 MorisitaHornDiss  5.216273e-01 -9.007643e-03
      7104 1991   466_552415   BrayCurtisDiss  6.389834e-01  8.338384e-03
      7105 1999   466_552415      JaccardDiss  3.076923e-01  1.104283e-02
      7106 1999   466_552415 MorisitaHornDiss  3.729537e-02 -9.007643e-03
      7107 1999   466_552415   BrayCurtisDiss  3.274087e-01  8.338384e-03
      7108 2003   466_552415      JaccardDiss  2.500000e-01  1.104283e-02
      7109 2003   466_552415 MorisitaHornDiss  1.194636e-03 -9.007643e-03
      7110 2003   466_552415   BrayCurtisDiss  4.526295e-01  8.338384e-03
      7111 1989   466_552415      JaccardDiss  9.090909e-02  1.104283e-02
      7112 1989   466_552415 MorisitaHornDiss  1.763430e-04 -9.007643e-03
      7113 1989   466_552415   BrayCurtisDiss  2.888034e-01  8.338384e-03
      7114 1990   466_552415      JaccardDiss  9.090909e-02  1.104283e-02
      7115 1990   466_552415 MorisitaHornDiss  3.303472e-03 -9.007643e-03
      7116 1990   466_552415   BrayCurtisDiss  1.205522e-01  8.338384e-03
      7117 1992   466_552415      JaccardDiss  2.727273e-01  1.104283e-02
      7118 1992   466_552415 MorisitaHornDiss  1.302073e-01 -9.007643e-03
      7119 1992   466_552415   BrayCurtisDiss  2.818444e-01  8.338384e-03
      7120 1994   466_552415      JaccardDiss  2.727273e-01  1.104283e-02
      7121 1994   466_552415 MorisitaHornDiss  6.918676e-02 -9.007643e-03
      7122 1994   466_552415   BrayCurtisDiss  6.090426e-01  8.338384e-03
      7123 1995   466_552415      JaccardDiss  4.166667e-01  1.104283e-02
      7124 1995   466_552415 MorisitaHornDiss  3.296377e-01 -9.007643e-03
      7125 1995   466_552415   BrayCurtisDiss  4.314297e-01  8.338384e-03
      7126 1994   466_557511      JaccardDiss  4.666667e-01  1.057999e-03
      7127 1994   466_557511 MorisitaHornDiss  2.292994e-01 -5.567672e-03
      7128 1994   466_557511   BrayCurtisDiss  4.404428e-01 -7.174921e-03
      7129 1995   466_557511      JaccardDiss  5.294118e-01  1.057999e-03
      7130 1995   466_557511 MorisitaHornDiss  6.886156e-01 -5.567672e-03
      7131 1995   466_557511   BrayCurtisDiss  6.362063e-01 -7.174921e-03
      7132 1996   466_557511      JaccardDiss  3.636364e-01  1.057999e-03
      7133 1996   466_557511 MorisitaHornDiss  1.010885e-01 -5.567672e-03
      7134 1996   466_557511   BrayCurtisDiss  7.060024e-01 -7.174921e-03
      7135 2001   466_557511      JaccardDiss  6.000000e-01  1.057999e-03
      7136 2001   466_557511 MorisitaHornDiss  9.223315e-02 -5.567672e-03
      7137 2001   466_557511   BrayCurtisDiss  4.758765e-01 -7.174921e-03
      7138 2006   466_557511      JaccardDiss  5.882353e-01  1.057999e-03
      7139 2006   466_557511 MorisitaHornDiss  7.699415e-01 -5.567672e-03
      7140 2006   466_557511   BrayCurtisDiss  8.182565e-01 -7.174921e-03
      7141 2007   466_557511      JaccardDiss  5.000000e-01  1.057999e-03
      7142 2007   466_557511 MorisitaHornDiss  5.090061e-02 -5.567672e-03
      7143 2007   466_557511   BrayCurtisDiss  1.627558e-01 -7.174921e-03
      7144 1992   466_557511      JaccardDiss  6.153846e-01  1.057999e-03
      7145 1992   466_557511 MorisitaHornDiss  2.450463e-03 -5.567672e-03
      7146 1992   466_557511   BrayCurtisDiss  3.432223e-01 -7.174921e-03
      7147 2005   466_557511      JaccardDiss  4.000000e-01  1.057999e-03
      7148 2005   466_557511 MorisitaHornDiss  1.677978e-03 -5.567672e-03
      7149 2005   466_557511   BrayCurtisDiss  4.390538e-01 -7.174921e-03
      7150 1993   466_557511      JaccardDiss  4.000000e-01  1.057999e-03
      7151 1993   466_557511 MorisitaHornDiss  2.651987e-02 -5.567672e-03
      7152 1993   466_557511   BrayCurtisDiss  6.095957e-01 -7.174921e-03
      7153 1997   466_557511      JaccardDiss  4.545455e-01  1.057999e-03
      7154 1997   466_557511 MorisitaHornDiss  4.111521e-01 -5.567672e-03
      7155 1997   466_557511   BrayCurtisDiss  6.498708e-01 -7.174921e-03
      7156 1999   466_557511      JaccardDiss  4.166667e-01  1.057999e-03
      7157 1999   466_557511 MorisitaHornDiss  6.076326e-02 -5.567672e-03
      7158 1999   466_557511   BrayCurtisDiss  4.731303e-01 -7.174921e-03
      7159 1990   466_557511      JaccardDiss  5.000000e-01  1.057999e-03
      7160 1990   466_557511 MorisitaHornDiss  6.851858e-01 -5.567672e-03
      7161 1990   466_557511   BrayCurtisDiss  6.568604e-01 -7.174921e-03
      7162 2001   466_553144      JaccardDiss  1.666667e-01  3.732822e-03
      7163 2001   466_553144 MorisitaHornDiss  2.113662e-02  2.301636e-02
      7164 2001   466_553144   BrayCurtisDiss  4.883016e-01  1.158134e-02
      7165 2005   466_553144      JaccardDiss  3.571429e-01  3.732822e-03
      7166 2005   466_553144 MorisitaHornDiss  8.795579e-02  2.301636e-02
      7167 2005   466_553144   BrayCurtisDiss  3.068717e-01  1.158134e-02
      7168 2006   466_553144      JaccardDiss  5.000000e-01  3.732822e-03
      7169 2006   466_553144 MorisitaHornDiss  9.661016e-01  2.301636e-02
      7170 2006   466_553144   BrayCurtisDiss  9.255000e-01  1.158134e-02
      7171 2007   466_553144      JaccardDiss  4.615385e-01  3.732822e-03
      7172 2007   466_553144 MorisitaHornDiss  7.348139e-01  2.301636e-02
      7173 2007   466_553144   BrayCurtisDiss  7.735317e-01  1.158134e-02
      7174 2008   466_553144      JaccardDiss  2.500000e-01  3.732822e-03
      7175 2008   466_553144 MorisitaHornDiss  3.305373e-02  2.301636e-02
      7176 2008   466_553144   BrayCurtisDiss  2.653877e-01  1.158134e-02
      7177 1988   466_553144      JaccardDiss  3.076923e-01  3.732822e-03
      7178 1988   466_553144 MorisitaHornDiss  2.452669e-03  2.301636e-02
      7179 1988   466_553144   BrayCurtisDiss  1.877441e-01  1.158134e-02
      7180 1989   466_553144      JaccardDiss  3.846154e-01  3.732822e-03
      7181 1989   466_553144 MorisitaHornDiss  9.082907e-03  2.301636e-02
      7182 1989   466_553144   BrayCurtisDiss  3.277541e-01  1.158134e-02
      7183 1990   466_553144      JaccardDiss  2.500000e-01  3.732822e-03
      7184 1990   466_553144 MorisitaHornDiss  9.762220e-03  2.301636e-02
      7185 1990   466_553144   BrayCurtisDiss  6.092744e-01  1.158134e-02
      7186 1995   466_553144      JaccardDiss  1.818182e-01  3.732822e-03
      7187 1995   466_553144 MorisitaHornDiss  6.987344e-02  2.301636e-02
      7188 1995   466_553144   BrayCurtisDiss  3.117499e-01  1.158134e-02
      7189 2002   466_553144      JaccardDiss  2.307692e-01  3.732822e-03
      7190 2002   466_553144 MorisitaHornDiss  2.750019e-02  2.301636e-02
      7191 2002   466_553144   BrayCurtisDiss  3.847260e-01  1.158134e-02
      7192 1986   466_564837      JaccardDiss  3.076923e-01  2.419896e-02
      7193 1986   466_564837 MorisitaHornDiss  4.701505e-01  5.045750e-03
      7194 1986   466_564837   BrayCurtisDiss  6.092619e-01  2.107561e-02
      7195 1988   466_564837      JaccardDiss  3.928571e-01  2.419896e-02
      7196 1988   466_564837 MorisitaHornDiss  2.692022e-01  5.045750e-03
      7197 1988   466_564837   BrayCurtisDiss  4.475921e-01  2.107561e-02
      7198 1989   466_564837      JaccardDiss  5.200000e-01  2.419896e-02
      7199 1989   466_564837 MorisitaHornDiss  7.001878e-01  5.045750e-03
      7200 1989   466_564837   BrayCurtisDiss  8.273684e-01  2.107561e-02
      7201 1990   466_564837      JaccardDiss  4.615385e-01  2.419896e-02
      7202 1990   466_564837 MorisitaHornDiss  9.728388e-01  5.045750e-03
      7203 1990   466_564837   BrayCurtisDiss  9.958287e-01  2.107561e-02
      7204 2002   466_564837      JaccardDiss  7.083333e-01  2.419896e-02
      7205 2002   466_564837 MorisitaHornDiss  4.594505e-01  5.045750e-03
      7206 2002   466_564837   BrayCurtisDiss  9.280119e-01  2.107561e-02
      7207 1987   466_564837      JaccardDiss  2.916667e-01  2.419896e-02
      7208 1987   466_564837 MorisitaHornDiss  1.687015e-01  5.045750e-03
      7209 1987   466_564837   BrayCurtisDiss  6.162246e-01  2.107561e-02
      7210 1994   466_556782      JaccardDiss  4.000000e-01  1.324078e-03
      7211 1994   466_556782 MorisitaHornDiss  2.189155e-01  2.283108e-02
      7212 1994   466_556782   BrayCurtisDiss  8.729259e-01  1.701608e-04
      7213 2007   466_556782      JaccardDiss  3.846154e-01  1.324078e-03
      7214 2007   466_556782 MorisitaHornDiss  8.357467e-01  2.283108e-02
      7215 2007   466_556782   BrayCurtisDiss  9.073099e-01  1.701608e-04
      7216 2008   466_556782      JaccardDiss  4.545455e-01  1.324078e-03
      7217 2008   466_556782 MorisitaHornDiss  2.605569e-01  2.283108e-02
      7218 2008   466_556782   BrayCurtisDiss  4.791235e-01  1.701608e-04
      7219 1992   466_556782      JaccardDiss  4.166667e-01  1.324078e-03
      7220 1992   466_556782 MorisitaHornDiss  2.625400e-01  2.283108e-02
      7221 1992   466_556782   BrayCurtisDiss  5.201703e-01  1.701608e-04
      7222 1993   466_556782      JaccardDiss  3.333333e-01  1.324078e-03
      7223 1993   466_556782 MorisitaHornDiss  1.972685e-01  2.283108e-02
      7224 1993   466_556782   BrayCurtisDiss  6.957715e-01  1.701608e-04
      7225 2001   466_556782      JaccardDiss  2.307692e-01  1.324078e-03
      7226 2001   466_556782 MorisitaHornDiss  7.037812e-01  2.283108e-02
      7227 2001   466_556782   BrayCurtisDiss  6.726103e-01  1.701608e-04
      7228 1999   466_557509      JaccardDiss  3.333333e-01  5.063966e-03
      7229 1999   466_557509 MorisitaHornDiss  3.961992e-01 -1.924580e-02
      7230 1999   466_557509   BrayCurtisDiss  6.006601e-01  3.156164e-03
      7231 2008   466_557509      JaccardDiss  3.571429e-01  5.063966e-03
      7232 2008   466_557509 MorisitaHornDiss  3.297970e-01 -1.924580e-02
      7233 2008   466_557509   BrayCurtisDiss  7.064275e-01  3.156164e-03
      7234 2006   466_557509      JaccardDiss  4.166667e-01  5.063966e-03
      7235 2006   466_557509 MorisitaHornDiss  2.649657e-02 -1.924580e-02
      7236 2006   466_557509   BrayCurtisDiss  4.525569e-01  3.156164e-03
      7237 2007   466_550961      JaccardDiss  5.384615e-01 -1.418911e-03
      7238 2007   466_550961 MorisitaHornDiss  6.877476e-01 -3.289577e-03
      7239 2007   466_550961   BrayCurtisDiss  8.920188e-01 -1.608775e-03
      7240 1988   466_550961      JaccardDiss  5.714286e-01 -1.418911e-03
      7241 1988   466_550961 MorisitaHornDiss  7.492017e-01 -3.289577e-03
      7242 1988   466_550961   BrayCurtisDiss  9.204056e-01 -1.608775e-03
      7243 1996   466_550961      JaccardDiss  5.000000e-01 -1.418911e-03
      7244 1996   466_550961 MorisitaHornDiss  7.333638e-01 -3.289577e-03
      7245 1996   466_550961   BrayCurtisDiss  9.293347e-01 -1.608775e-03
      7246 1997   466_550961      JaccardDiss  2.500000e-01 -1.418911e-03
      7247 1997   466_550961 MorisitaHornDiss  4.303531e-01 -3.289577e-03
      7248 1997   466_550961   BrayCurtisDiss  4.449778e-01 -1.608775e-03
      7249 1989   466_558241      JaccardDiss  2.000000e-01 -1.552366e-02
      7250 1989   466_558241 MorisitaHornDiss  3.743507e-01 -4.393220e-03
      7251 1989   466_558241   BrayCurtisDiss  5.358911e-01  2.696486e-02
      7252 1990   466_558241      JaccardDiss  2.727273e-01 -1.552366e-02
      7253 1990   466_558241 MorisitaHornDiss  8.885028e-02 -4.393220e-03
      7254 1990   466_558241   BrayCurtisDiss  7.256236e-01  2.696486e-02
      7255 1997   466_558241      JaccardDiss  1.111111e-01 -1.552366e-02
      7256 1997   466_558241 MorisitaHornDiss  2.267621e-01 -4.393220e-03
      7257 1997   466_558241   BrayCurtisDiss  8.167170e-01  2.696486e-02
      7258 1989   466_559694      JaccardDiss  0.000000e+00  1.111111e-01
      7259 1989   466_559694 MorisitaHornDiss  1.153384e-03  1.795053e-01
      7260 1989   466_559694   BrayCurtisDiss  3.677617e-01  8.115448e-02
      7261 1990   466_559694      JaccardDiss  2.222222e-01  1.111111e-01
      7262 1990   466_559694 MorisitaHornDiss  3.647132e-01  1.795053e-01
      7263 1990   466_559694   BrayCurtisDiss  6.976235e-01  8.115448e-02
      7264 1991   466_559694      JaccardDiss  2.222222e-01  1.111111e-01
      7265 1991   466_559694 MorisitaHornDiss  3.601640e-01  1.795053e-01
      7266 1991   466_559694   BrayCurtisDiss  5.300706e-01  8.115448e-02
      7267 1992   466_562606      JaccardDiss  1.111111e-01  2.000000e-02
      7268 1992   466_562606 MorisitaHornDiss  3.745877e-04  2.470599e-04
      7269 1992   466_562606   BrayCurtisDiss  5.736402e-01 -7.089079e-02
      7270 1993   466_562606      JaccardDiss  0.000000e+00  2.000000e-02
      7271 1993   466_562606 MorisitaHornDiss  9.607562e-04  2.470599e-04
      7272 1993   466_562606   BrayCurtisDiss  3.835154e-01 -7.089079e-02
      7273 1994   466_562606      JaccardDiss  2.000000e-01  2.000000e-02
      7274 1994   466_562606 MorisitaHornDiss  1.236865e-03  2.470599e-04
      7275 1994   466_562606   BrayCurtisDiss  5.743864e-01 -7.089079e-02
      7276 1995   466_562606      JaccardDiss  1.111111e-01  2.000000e-02
      7277 1995   466_562606 MorisitaHornDiss  1.106084e-03  2.470599e-04
      7278 1995   466_562606   BrayCurtisDiss  2.737139e-01 -7.089079e-02
      7279 1980   211_528514      JaccardDiss  6.176471e-01  6.120307e-03
      7280 1980   211_528514 MorisitaHornDiss  2.605090e-01  1.537886e-02
      7281 1980   211_528514   BrayCurtisDiss  4.685990e-01  8.847987e-03
      7282 1982   211_528514      JaccardDiss  6.944444e-01  6.120307e-03
      7283 1982   211_528514 MorisitaHornDiss  3.434752e-01  1.537886e-02
      7284 1982   211_528514   BrayCurtisDiss  6.193896e-01  8.847987e-03
      7285 1985   211_528514      JaccardDiss  7.500000e-01  6.120307e-03
      7286 1985   211_528514 MorisitaHornDiss  5.337583e-01  1.537886e-02
      7287 1985   211_528514   BrayCurtisDiss  7.020316e-01  8.847987e-03
      7288 1986   211_528514      JaccardDiss  7.837838e-01  6.120307e-03
      7289 1986   211_528514 MorisitaHornDiss  6.385683e-01  1.537886e-02
      7290 1986   211_528514   BrayCurtisDiss  7.353846e-01  8.847987e-03
      7291 1987   211_528514      JaccardDiss  5.833333e-01  6.120307e-03
      7292 1987   211_528514 MorisitaHornDiss  1.469909e-01  1.537886e-02
      7293 1987   211_528514   BrayCurtisDiss  4.137353e-01  8.847987e-03
      7294 1983   211_524878      JaccardDiss  5.500000e-01 -1.936575e-02
      7295 1983   211_524878 MorisitaHornDiss  1.743713e-01 -3.508865e-02
      7296 1983   211_524878   BrayCurtisDiss  4.472727e-01 -7.389946e-03
      7297 1980   211_524878      JaccardDiss  7.000000e-01 -1.936575e-02
      7298 1980   211_524878 MorisitaHornDiss  9.731841e-01 -3.508865e-02
      7299 1980   211_524878   BrayCurtisDiss  9.357430e-01 -7.389946e-03
      7300 1987   211_524878      JaccardDiss  5.000000e-01 -1.936575e-02
      7301 1987   211_524878 MorisitaHornDiss  3.437346e-01 -3.508865e-02
      7302 1987   211_524878   BrayCurtisDiss  6.152450e-01 -7.389946e-03
      7303 1982   211_524878      JaccardDiss  7.894737e-01 -1.936575e-02
      7304 1982   211_524878 MorisitaHornDiss  5.023900e-01 -3.508865e-02
      7305 1982   211_524878   BrayCurtisDiss  6.326531e-01 -7.389946e-03
      7306 1981   211_524878      JaccardDiss  7.083333e-01 -1.936575e-02
      7307 1981   211_524878 MorisitaHornDiss  7.639059e-01 -3.508865e-02
      7308 1981   211_524878   BrayCurtisDiss  7.070423e-01 -7.389946e-03
      7309 1984   211_524878      JaccardDiss  7.142857e-01 -1.936575e-02
      7310 1984   211_524878 MorisitaHornDiss  4.197200e-01 -3.508865e-02
      7311 1984   211_524878   BrayCurtisDiss  6.945813e-01 -7.389946e-03
      7312 1986   211_524878      JaccardDiss  7.222222e-01 -1.936575e-02
      7313 1986   211_524878 MorisitaHornDiss  9.871482e-01 -3.508865e-02
      7314 1986   211_524878   BrayCurtisDiss  9.428571e-01 -7.389946e-03
      7315 1981   211_521245      JaccardDiss  6.666667e-01  1.673756e-02
      7316 1981   211_521245 MorisitaHornDiss  3.001049e-01  6.797044e-02
      7317 1981   211_521245   BrayCurtisDiss  4.743875e-01  5.588878e-02
      7318 1985   211_521245      JaccardDiss  6.444444e-01  1.673756e-02
      7319 1985   211_521245 MorisitaHornDiss  2.885612e-01  6.797044e-02
      7320 1985   211_521245   BrayCurtisDiss  5.016393e-01  5.588878e-02
      7321 1980   211_521245      JaccardDiss  7.058824e-01  1.673756e-02
      7322 1980   211_521245 MorisitaHornDiss  2.634327e-01  6.797044e-02
      7323 1980   211_521245   BrayCurtisDiss  4.728682e-01  5.588878e-02
      7324 1982   211_521245      JaccardDiss  7.142857e-01  1.673756e-02
      7325 1982   211_521245 MorisitaHornDiss  1.125205e-01  6.797044e-02
      7326 1982   211_521245   BrayCurtisDiss  3.487179e-01  5.588878e-02
      7327 1986   211_521245      JaccardDiss  7.096774e-01  1.673756e-02
      7328 1986   211_521245 MorisitaHornDiss  3.802901e-01  6.797044e-02
      7329 1986   211_521245   BrayCurtisDiss  6.303630e-01  5.588878e-02
      7330 1987   211_521245      JaccardDiss  9.000000e-01  1.673756e-02
      7331 1987   211_521245 MorisitaHornDiss  9.604686e-01  6.797044e-02
      7332 1987   211_521245   BrayCurtisDiss  9.683794e-01  5.588878e-02
      7333 1984   211_521245      JaccardDiss  7.608696e-01  1.673756e-02
      7334 1984   211_521245 MorisitaHornDiss  2.236691e-01  6.797044e-02
      7335 1984   211_521245   BrayCurtisDiss  5.141431e-01  5.588878e-02
      7336 1980   211_522693      JaccardDiss  5.263158e-01  2.678272e-03
      7337 1980   211_522693 MorisitaHornDiss  4.531662e-01 -4.485264e-02
      7338 1980   211_522693   BrayCurtisDiss  4.791667e-01 -9.790472e-03
      7339 1984   211_522693      JaccardDiss  6.250000e-01  2.678272e-03
      7340 1984   211_522693 MorisitaHornDiss  1.930122e-01 -4.485264e-02
      7341 1984   211_522693   BrayCurtisDiss  4.775510e-01 -9.790472e-03
      7342 1985   211_522693      JaccardDiss  6.190476e-01  2.678272e-03
      7343 1985   211_522693 MorisitaHornDiss  2.306397e-01 -4.485264e-02
      7344 1985   211_522693   BrayCurtisDiss  6.674260e-01 -9.790472e-03
      7345 1986   211_522693      JaccardDiss  7.222222e-01  2.678272e-03
      7346 1986   211_522693 MorisitaHornDiss  1.501100e-01 -4.485264e-02
      7347 1986   211_522693   BrayCurtisDiss  3.939394e-01 -9.790472e-03
      7348 1987   211_522693      JaccardDiss  6.666667e-01  2.678272e-03
      7349 1987   211_522693 MorisitaHornDiss  1.637844e-01 -4.485264e-02
      7350 1987   211_522693   BrayCurtisDiss  4.300518e-01 -9.790472e-03
      7351 1981   211_522693      JaccardDiss  8.125000e-01  2.678272e-03
      7352 1981   211_522693 MorisitaHornDiss  4.909757e-01 -4.485264e-02
      7353 1981   211_522693   BrayCurtisDiss  5.746269e-01 -9.790472e-03
      7354 1982   211_522693      JaccardDiss  7.333333e-01  2.678272e-03
      7355 1982   211_522693 MorisitaHornDiss  1.542556e-01 -4.485264e-02
      7356 1982   211_522693   BrayCurtisDiss  5.000000e-01 -9.790472e-03
      7357 1983   211_522693      JaccardDiss  5.882353e-01  2.678272e-03
      7358 1983   211_522693 MorisitaHornDiss  4.597857e-01 -4.485264e-02
      7359 1983   211_522693   BrayCurtisDiss  5.549872e-01 -9.790472e-03
      7360 1981   211_516876      JaccardDiss  7.000000e-01  8.888889e-03
      7361 1981   211_516876 MorisitaHornDiss  8.129213e-02 -2.453397e-02
      7362 1981   211_516876   BrayCurtisDiss  4.463668e-01 -1.977515e-02
      7363 1983   211_516876      JaccardDiss  6.000000e-01  8.888889e-03
      7364 1983   211_516876 MorisitaHornDiss  9.355210e-02 -2.453397e-02
      7365 1983   211_516876   BrayCurtisDiss  4.476190e-01 -1.977515e-02
      7366 1980   211_516876      JaccardDiss  5.555556e-01  8.888889e-03
      7367 1980   211_516876 MorisitaHornDiss  3.196742e-01 -2.453397e-02
      7368 1980   211_516876   BrayCurtisDiss  4.904110e-01 -1.977515e-02
      7369 1982   211_516876      JaccardDiss  9.411765e-01  8.888889e-03
      7370 1982   211_516876 MorisitaHornDiss  9.443778e-01 -2.453397e-02
      7371 1982   211_516876   BrayCurtisDiss  9.591837e-01 -1.977515e-02
      7372 1984   211_516876      JaccardDiss  6.500000e-01  8.888889e-03
      7373 1984   211_516876 MorisitaHornDiss  1.908744e-01 -2.453397e-02
      7374 1984   211_516876   BrayCurtisDiss  3.909091e-01 -1.977515e-02
      7375 1984   211_516147      JaccardDiss  6.470588e-01 -4.124650e-02
      7376 1984   211_516147 MorisitaHornDiss  1.384664e-01 -3.759856e-02
      7377 1984   211_516147   BrayCurtisDiss  5.787879e-01 -1.665243e-02
      7378 1985   211_516147      JaccardDiss  5.833333e-01 -4.124650e-02
      7379 1985   211_516147 MorisitaHornDiss  1.542811e-01 -3.759856e-02
      7380 1985   211_516147   BrayCurtisDiss  7.947761e-01 -1.665243e-02
      7381 1982   211_516147      JaccardDiss  7.142857e-01 -4.124650e-02
      7382 1982   211_516147 MorisitaHornDiss  3.216354e-01 -3.759856e-02
      7383 1982   211_516147   BrayCurtisDiss  8.828125e-01 -1.665243e-02
      7384 1983   211_516147      JaccardDiss  6.666667e-01 -4.124650e-02
      7385 1983   211_516147 MorisitaHornDiss  1.238902e-02 -3.759856e-02
      7386 1983   211_516147   BrayCurtisDiss  4.812030e-01 -1.665243e-02
      7387 2011  437_2074469      JaccardDiss  5.652174e-01  1.109139e-02
      7388 2011  437_2074469 MorisitaHornDiss  8.895615e-02  3.186167e-02
      7389 2011  437_2074469   BrayCurtisDiss  3.197556e-01  2.186074e-02
      7390 2012  437_2074469      JaccardDiss  7.142857e-01  1.109139e-02
      7391 2012  437_2074469 MorisitaHornDiss  2.753804e-01  3.186167e-02
      7392 2012  437_2074469   BrayCurtisDiss  4.470990e-01  2.186074e-02
      7393 2016  437_2074469      JaccardDiss  6.666667e-01  1.109139e-02
      7394 2016  437_2074469 MorisitaHornDiss  2.997854e-01  3.186167e-02
      7395 2016  437_2074469   BrayCurtisDiss  4.642202e-01  2.186074e-02
      7396 2010  437_2076657      JaccardDiss  7.500000e-01 -5.698996e-02
      7397 2010  437_2076657 MorisitaHornDiss  7.559667e-01 -1.063864e-01
      7398 2010  437_2076657   BrayCurtisDiss  7.424242e-01 -6.005424e-02
      7399 2011  437_2076657      JaccardDiss  7.121212e-01 -5.698996e-02
      7400 2011  437_2076657 MorisitaHornDiss  8.459120e-01 -1.063864e-01
      7401 2011  437_2076657   BrayCurtisDiss  7.360179e-01 -6.005424e-02
      7402 2012  437_2076657      JaccardDiss  6.986301e-01 -5.698996e-02
      7403 2012  437_2076657 MorisitaHornDiss  7.989993e-01 -1.063864e-01
      7404 2012  437_2076657   BrayCurtisDiss  7.457045e-01 -6.005424e-02
      7405 2016  437_2076657      JaccardDiss  4.186047e-01 -5.698996e-02
      7406 2016  437_2076657 MorisitaHornDiss  2.001459e-01 -1.063864e-01
      7407 2016  437_2076657   BrayCurtisDiss  4.082073e-01 -6.005424e-02
      7408 2010  437_2075929      JaccardDiss  6.953125e-01 -4.041396e-02
      7409 2010  437_2075929 MorisitaHornDiss  1.919106e-01 -2.038973e-02
      7410 2010  437_2075929   BrayCurtisDiss  4.750831e-01 -4.175002e-02
      7411 2011  437_2075929      JaccardDiss  6.803279e-01 -4.041396e-02
      7412 2011  437_2075929 MorisitaHornDiss  2.416241e-01 -2.038973e-02
      7413 2011  437_2075929   BrayCurtisDiss  5.379189e-01 -4.175002e-02
      7414 2012  437_2075929      JaccardDiss  5.801527e-01 -4.041396e-02
      7415 2012  437_2075929 MorisitaHornDiss  2.863184e-01 -2.038973e-02
      7416 2012  437_2075929   BrayCurtisDiss  5.505430e-01 -4.175002e-02
      7417 2016  437_2075929      JaccardDiss  4.590164e-01 -4.041396e-02
      7418 2016  437_2075929 MorisitaHornDiss  1.019525e-01 -2.038973e-02
      7419 2016  437_2075929   BrayCurtisDiss  2.700422e-01 -4.175002e-02
      7420 2011  437_2078113      JaccardDiss  8.152174e-01 -3.790106e-02
      7421 2011  437_2078113 MorisitaHornDiss  7.226764e-01 -3.659966e-02
      7422 2011  437_2078113   BrayCurtisDiss  8.166863e-01 -4.192997e-02
      7423 2010  437_2078113      JaccardDiss  6.455696e-01 -3.790106e-02
      7424 2010  437_2078113 MorisitaHornDiss  4.506728e-01 -3.659966e-02
      7425 2010  437_2078113   BrayCurtisDiss  7.810398e-01 -4.192997e-02
      7426 2016  437_2078113      JaccardDiss  4.893617e-01 -3.790106e-02
      7427 2016  437_2078113 MorisitaHornDiss  3.523397e-01 -3.659966e-02
      7428 2016  437_2078113   BrayCurtisDiss  5.568022e-01 -4.192997e-02
      7429 2012  437_2078113      JaccardDiss  6.000000e-01 -3.790106e-02
      7430 2012  437_2078113 MorisitaHornDiss  6.534296e-01 -3.659966e-02
      7431 2012  437_2078113   BrayCurtisDiss  7.194323e-01 -4.192997e-02
      7432 2012  437_2075928      JaccardDiss  6.046512e-01  1.506136e-02
      7433 2012  437_2075928 MorisitaHornDiss  3.356642e-01  3.914285e-02
      7434 2012  437_2075928   BrayCurtisDiss  4.765432e-01  2.712042e-02
      7435 2011  437_2075928      JaccardDiss  6.122449e-01  1.506136e-02
      7436 2011  437_2075928 MorisitaHornDiss  1.841223e-01  3.914285e-02
      7437 2011  437_2075928   BrayCurtisDiss  4.267241e-01  2.712042e-02
      7438 2016  437_2075928      JaccardDiss  6.800000e-01  1.506136e-02
      7439 2016  437_2075928 MorisitaHornDiss  4.173029e-01  3.914285e-02
      7440 2016  437_2075928   BrayCurtisDiss  5.698925e-01  2.712042e-02
      7441 2012  437_2075200      JaccardDiss  5.945946e-01  1.185796e-02
      7442 2012  437_2075200 MorisitaHornDiss  1.445924e-01  3.628347e-02
      7443 2012  437_2075200   BrayCurtisDiss  4.358047e-01  5.387503e-03
      7444 2011  437_2075200      JaccardDiss  6.833333e-01  1.185796e-02
      7445 2011  437_2075200 MorisitaHornDiss  5.449287e-01  3.628347e-02
      7446 2011  437_2075200   BrayCurtisDiss  6.818851e-01  5.387503e-03
      7447 2016  437_2075200      JaccardDiss  7.090909e-01  1.185796e-02
      7448 2016  437_2075200 MorisitaHornDiss  5.808061e-01  3.628347e-02
      7449 2016  437_2075200   BrayCurtisDiss  6.250000e-01  5.387503e-03
      7450 2011  437_2073742      JaccardDiss  5.777778e-01  1.391352e-02
      7451 2011  437_2073742 MorisitaHornDiss  1.283940e-01  1.591072e-02
      7452 2011  437_2073742   BrayCurtisDiss  3.888889e-01  1.689664e-02
      7453 2012  437_2073742      JaccardDiss  6.896552e-01  1.391352e-02
      7454 2012  437_2073742 MorisitaHornDiss  2.607499e-01  1.591072e-02
      7455 2012  437_2073742   BrayCurtisDiss  4.944072e-01  1.689664e-02
      7456 2016  437_2073742      JaccardDiss  6.800000e-01  1.391352e-02
      7457 2016  437_2073742 MorisitaHornDiss  2.467626e-01  1.591072e-02
      7458 2016  437_2073742   BrayCurtisDiss  5.029126e-01  1.689664e-02
      7459 2011  437_2073741      JaccardDiss  5.744681e-01  3.065634e-02
      7460 2011  437_2073741 MorisitaHornDiss  3.339281e-01 -1.487758e-03
      7461 2011  437_2073741   BrayCurtisDiss  4.641350e-01  3.607616e-02
      7462 2012  437_2073741      JaccardDiss  6.250000e-01  3.065634e-02
      7463 2012  437_2073741 MorisitaHornDiss  4.976496e-01 -1.487758e-03
      7464 2012  437_2073741   BrayCurtisDiss  6.659193e-01  3.607616e-02
      7465 2016  437_2073741      JaccardDiss  7.343750e-01  3.065634e-02
      7466 2016  437_2073741 MorisitaHornDiss  3.815590e-01 -1.487758e-03
      7467 2016  437_2073741   BrayCurtisDiss  6.997519e-01  3.607616e-02
                 pvalue significance     intercept
      1    4.724426e-01            0 -1.804978e+01
      2    1.691434e-01            0 -1.999238e+00
      3    6.554540e-01            0  9.959397e+00
      4    4.724426e-01            0 -1.804978e+01
      5    1.691434e-01            0 -1.999238e+00
      6    6.554540e-01            0  9.959397e+00
      7    4.724426e-01            0 -1.804978e+01
      8    1.691434e-01            0 -1.999238e+00
      9    6.554540e-01            0  9.959397e+00
      10   5.081774e-01            0 -1.970673e+00
      11   4.834322e-01            0 -2.884900e+00
      12   8.537627e-01            0 -3.822126e-01
      13   5.081774e-01            0 -1.970673e+00
      14   4.834322e-01            0 -2.884900e+00
      15   8.537627e-01            0 -3.822126e-01
      16   5.081774e-01            0 -1.970673e+00
      17   4.834322e-01            0 -2.884900e+00
      18   8.537627e-01            0 -3.822126e-01
      19   5.081774e-01            0 -1.970673e+00
      20   4.834322e-01            0 -2.884900e+00
      21   8.537627e-01            0 -3.822126e-01
      22   5.081774e-01            0 -1.970673e+00
      23   4.834322e-01            0 -2.884900e+00
      24   8.537627e-01            0 -3.822126e-01
      25   5.081774e-01            0 -1.970673e+00
      26   4.834322e-01            0 -2.884900e+00
      27   8.537627e-01            0 -3.822126e-01
      28   5.081774e-01            0 -1.970673e+00
      29   4.834322e-01            0 -2.884900e+00
      30   8.537627e-01            0 -3.822126e-01
      31   5.081774e-01            0 -1.970673e+00
      32   4.834322e-01            0 -2.884900e+00
      33   8.537627e-01            0 -3.822126e-01
      34   5.081774e-01            0 -1.970673e+00
      35   4.834322e-01            0 -2.884900e+00
      36   8.537627e-01            0 -3.822126e-01
      37   5.081774e-01            0 -1.970673e+00
      38   4.834322e-01            0 -2.884900e+00
      39   8.537627e-01            0 -3.822126e-01
      40   5.081774e-01            0 -1.970673e+00
      41   4.834322e-01            0 -2.884900e+00
      42   8.537627e-01            0 -3.822126e-01
      43   5.081774e-01            0 -1.970673e+00
      44   4.834322e-01            0 -2.884900e+00
      45   8.537627e-01            0 -3.822126e-01
      46   5.081774e-01            0 -1.970673e+00
      47   4.834322e-01            0 -2.884900e+00
      48   8.537627e-01            0 -3.822126e-01
      49   5.081774e-01            0 -1.970673e+00
      50   4.834322e-01            0 -2.884900e+00
      51   8.537627e-01            0 -3.822126e-01
      52   5.081774e-01            0 -1.970673e+00
      53   4.834322e-01            0 -2.884900e+00
      54   8.537627e-01            0 -3.822126e-01
      55   5.081774e-01            0 -1.970673e+00
      56   4.834322e-01            0 -2.884900e+00
      57   8.537627e-01            0 -3.822126e-01
      58   5.081774e-01            0 -1.970673e+00
      59   4.834322e-01            0 -2.884900e+00
      60   8.537627e-01            0 -3.822126e-01
      61   5.081774e-01            0 -1.970673e+00
      62   4.834322e-01            0 -2.884900e+00
      63   8.537627e-01            0 -3.822126e-01
      64   5.081774e-01            0 -1.970673e+00
      65   4.834322e-01            0 -2.884900e+00
      66   8.537627e-01            0 -3.822126e-01
      67   5.081774e-01            0 -1.970673e+00
      68   4.834322e-01            0 -2.884900e+00
      69   8.537627e-01            0 -3.822126e-01
      70   5.081774e-01            0 -1.970673e+00
      71   4.834322e-01            0 -2.884900e+00
      72   8.537627e-01            0 -3.822126e-01
      73   5.081774e-01            0 -1.970673e+00
      74   4.834322e-01            0 -2.884900e+00
      75   8.537627e-01            0 -3.822126e-01
      76   5.081774e-01            0 -1.970673e+00
      77   4.834322e-01            0 -2.884900e+00
      78   8.537627e-01            0 -3.822126e-01
      79   5.081774e-01            0 -1.970673e+00
      80   4.834322e-01            0 -2.884900e+00
      81   8.537627e-01            0 -3.822126e-01
      82   5.081774e-01            0 -1.970673e+00
      83   4.834322e-01            0 -2.884900e+00
      84   8.537627e-01            0 -3.822126e-01
      85   5.081774e-01            0 -1.970673e+00
      86   4.834322e-01            0 -2.884900e+00
      87   8.537627e-01            0 -3.822126e-01
      88   5.081774e-01            0 -1.970673e+00
      89   4.834322e-01            0 -2.884900e+00
      90   8.537627e-01            0 -3.822126e-01
      91   5.081774e-01            0 -1.970673e+00
      92   4.834322e-01            0 -2.884900e+00
      93   8.537627e-01            0 -3.822126e-01
      94   5.081774e-01            0 -1.970673e+00
      95   4.834322e-01            0 -2.884900e+00
      96   8.537627e-01            0 -3.822126e-01
      97   1.915310e-02            1 -1.407459e+01
      98   2.516155e-02            1 -2.231911e+01
      99   6.489529e-02            0 -1.514317e+01
      100  1.915310e-02            1 -1.407459e+01
      101  2.516155e-02            1 -2.231911e+01
      102  6.489529e-02            0 -1.514317e+01
      103  1.915310e-02            1 -1.407459e+01
      104  2.516155e-02            1 -2.231911e+01
      105  6.489529e-02            0 -1.514317e+01
      106  1.915310e-02            1 -1.407459e+01
      107  2.516155e-02            1 -2.231911e+01
      108  6.489529e-02            0 -1.514317e+01
      109  1.915310e-02            1 -1.407459e+01
      110  2.516155e-02            1 -2.231911e+01
      111  6.489529e-02            0 -1.514317e+01
      112  1.915310e-02            1 -1.407459e+01
      113  2.516155e-02            1 -2.231911e+01
      114  6.489529e-02            0 -1.514317e+01
      115  1.915310e-02            1 -1.407459e+01
      116  2.516155e-02            1 -2.231911e+01
      117  6.489529e-02            0 -1.514317e+01
      118  1.915310e-02            1 -1.407459e+01
      119  2.516155e-02            1 -2.231911e+01
      120  6.489529e-02            0 -1.514317e+01
      121  1.915310e-02            1 -1.407459e+01
      122  2.516155e-02            1 -2.231911e+01
      123  6.489529e-02            0 -1.514317e+01
      124  1.915310e-02            1 -1.407459e+01
      125  2.516155e-02            1 -2.231911e+01
      126  6.489529e-02            0 -1.514317e+01
      127  6.325870e-02            0  5.387659e+01
      128  9.829269e-02            0  3.471294e+01
      129  5.523670e-01            0  1.144514e+01
      130  6.325870e-02            0  5.387659e+01
      131  9.829269e-02            0  3.471294e+01
      132  5.523670e-01            0  1.144514e+01
      133  6.325870e-02            0  5.387659e+01
      134  9.829269e-02            0  3.471294e+01
      135  5.523670e-01            0  1.144514e+01
      136  6.325870e-02            0  5.387659e+01
      137  9.829269e-02            0  3.471294e+01
      138  5.523670e-01            0  1.144514e+01
      139  6.325870e-02            0  5.387659e+01
      140  9.829269e-02            0  3.471294e+01
      141  5.523670e-01            0  1.144514e+01
      142  6.325870e-02            0  5.387659e+01
      143  9.829269e-02            0  3.471294e+01
      144  5.523670e-01            0  1.144514e+01
      145  6.325870e-02            0  5.387659e+01
      146  9.829269e-02            0  3.471294e+01
      147  5.523670e-01            0  1.144514e+01
      148  6.325870e-02            0  5.387659e+01
      149  9.829269e-02            0  3.471294e+01
      150  5.523670e-01            0  1.144514e+01
      151  6.325870e-02            0  5.387659e+01
      152  9.829269e-02            0  3.471294e+01
      153  5.523670e-01            0  1.144514e+01
      154  6.325870e-02            0  5.387659e+01
      155  9.829269e-02            0  3.471294e+01
      156  5.523670e-01            0  1.144514e+01
      157  6.760536e-01            0  3.920699e+00
      158  2.886852e-01            0  4.752706e+00
      159  2.652656e-01            0  8.952811e+00
      160  6.760536e-01            0  3.920699e+00
      161  2.886852e-01            0  4.752706e+00
      162  2.652656e-01            0  8.952811e+00
      163  6.760536e-01            0  3.920699e+00
      164  2.886852e-01            0  4.752706e+00
      165  2.652656e-01            0  8.952811e+00
      166  6.760536e-01            0  3.920699e+00
      167  2.886852e-01            0  4.752706e+00
      168  2.652656e-01            0  8.952811e+00
      169  6.760536e-01            0  3.920699e+00
      170  2.886852e-01            0  4.752706e+00
      171  2.652656e-01            0  8.952811e+00
      172  6.760536e-01            0  3.920699e+00
      173  2.886852e-01            0  4.752706e+00
      174  2.652656e-01            0  8.952811e+00
      175  6.760536e-01            0  3.920699e+00
      176  2.886852e-01            0  4.752706e+00
      177  2.652656e-01            0  8.952811e+00
      178  6.760536e-01            0  3.920699e+00
      179  2.886852e-01            0  4.752706e+00
      180  2.652656e-01            0  8.952811e+00
      181  6.760536e-01            0  3.920699e+00
      182  2.886852e-01            0  4.752706e+00
      183  2.652656e-01            0  8.952811e+00
      184  6.760536e-01            0  3.920699e+00
      185  2.886852e-01            0  4.752706e+00
      186  2.652656e-01            0  8.952811e+00
      187  6.760536e-01            0  3.920699e+00
      188  2.886852e-01            0  4.752706e+00
      189  2.652656e-01            0  8.952811e+00
      190  6.760536e-01            0  3.920699e+00
      191  2.886852e-01            0  4.752706e+00
      192  2.652656e-01            0  8.952811e+00
      193  6.760536e-01            0  3.920699e+00
      194  2.886852e-01            0  4.752706e+00
      195  2.652656e-01            0  8.952811e+00
      196  6.760536e-01            0  3.920699e+00
      197  2.886852e-01            0  4.752706e+00
      198  2.652656e-01            0  8.952811e+00
      199  6.760536e-01            0  3.920699e+00
      200  2.886852e-01            0  4.752706e+00
      201  2.652656e-01            0  8.952811e+00
      202  6.760536e-01            0  3.920699e+00
      203  2.886852e-01            0  4.752706e+00
      204  2.652656e-01            0  8.952811e+00
      205  6.760536e-01            0  3.920699e+00
      206  2.886852e-01            0  4.752706e+00
      207  2.652656e-01            0  8.952811e+00
      208  6.760536e-01            0  3.920699e+00
      209  2.886852e-01            0  4.752706e+00
      210  2.652656e-01            0  8.952811e+00
      211  6.760536e-01            0  3.920699e+00
      212  2.886852e-01            0  4.752706e+00
      213  2.652656e-01            0  8.952811e+00
      214  6.760536e-01            0  3.920699e+00
      215  2.886852e-01            0  4.752706e+00
      216  2.652656e-01            0  8.952811e+00
      217  6.760536e-01            0  3.920699e+00
      218  2.886852e-01            0  4.752706e+00
      219  2.652656e-01            0  8.952811e+00
      220  6.760536e-01            0  3.920699e+00
      221  2.886852e-01            0  4.752706e+00
      222  2.652656e-01            0  8.952811e+00
      223  6.760536e-01            0  3.920699e+00
      224  2.886852e-01            0  4.752706e+00
      225  2.652656e-01            0  8.952811e+00
      226  6.760536e-01            0  3.920699e+00
      227  2.886852e-01            0  4.752706e+00
      228  2.652656e-01            0  8.952811e+00
      229  6.760536e-01            0  3.920699e+00
      230  2.886852e-01            0  4.752706e+00
      231  2.652656e-01            0  8.952811e+00
      232  6.760536e-01            0  3.920699e+00
      233  2.886852e-01            0  4.752706e+00
      234  2.652656e-01            0  8.952811e+00
      235  2.488221e-01            0  5.883433e+00
      236  6.512596e-01            0  4.784630e+00
      237  4.197160e-01            0  5.522305e+00
      238  2.488221e-01            0  5.883433e+00
      239  6.512596e-01            0  4.784630e+00
      240  4.197160e-01            0  5.522305e+00
      241  2.488221e-01            0  5.883433e+00
      242  6.512596e-01            0  4.784630e+00
      243  4.197160e-01            0  5.522305e+00
      244  2.488221e-01            0  5.883433e+00
      245  6.512596e-01            0  4.784630e+00
      246  4.197160e-01            0  5.522305e+00
      247  2.488221e-01            0  5.883433e+00
      248  6.512596e-01            0  4.784630e+00
      249  4.197160e-01            0  5.522305e+00
      250  2.488221e-01            0  5.883433e+00
      251  6.512596e-01            0  4.784630e+00
      252  4.197160e-01            0  5.522305e+00
      253  2.488221e-01            0  5.883433e+00
      254  6.512596e-01            0  4.784630e+00
      255  4.197160e-01            0  5.522305e+00
      256  2.488221e-01            0  5.883433e+00
      257  6.512596e-01            0  4.784630e+00
      258  4.197160e-01            0  5.522305e+00
      259  2.488221e-01            0  5.883433e+00
      260  6.512596e-01            0  4.784630e+00
      261  4.197160e-01            0  5.522305e+00
      262  2.488221e-01            0  5.883433e+00
      263  6.512596e-01            0  4.784630e+00
      264  4.197160e-01            0  5.522305e+00
      265  2.488221e-01            0  5.883433e+00
      266  6.512596e-01            0  4.784630e+00
      267  4.197160e-01            0  5.522305e+00
      268  2.488221e-01            0  5.883433e+00
      269  6.512596e-01            0  4.784630e+00
      270  4.197160e-01            0  5.522305e+00
      271  2.488221e-01            0  5.883433e+00
      272  6.512596e-01            0  4.784630e+00
      273  4.197160e-01            0  5.522305e+00
      274  2.488221e-01            0  5.883433e+00
      275  6.512596e-01            0  4.784630e+00
      276  4.197160e-01            0  5.522305e+00
      277  2.488221e-01            0  5.883433e+00
      278  6.512596e-01            0  4.784630e+00
      279  4.197160e-01            0  5.522305e+00
      280  2.488221e-01            0  5.883433e+00
      281  6.512596e-01            0  4.784630e+00
      282  4.197160e-01            0  5.522305e+00
      283  2.488221e-01            0  5.883433e+00
      284  6.512596e-01            0  4.784630e+00
      285  4.197160e-01            0  5.522305e+00
      286  2.488221e-01            0  5.883433e+00
      287  6.512596e-01            0  4.784630e+00
      288  4.197160e-01            0  5.522305e+00
      289  2.488221e-01            0  5.883433e+00
      290  6.512596e-01            0  4.784630e+00
      291  4.197160e-01            0  5.522305e+00
      292  2.488221e-01            0  5.883433e+00
      293  6.512596e-01            0  4.784630e+00
      294  4.197160e-01            0  5.522305e+00
      295  2.488221e-01            0  5.883433e+00
      296  6.512596e-01            0  4.784630e+00
      297  4.197160e-01            0  5.522305e+00
      298  2.488221e-01            0  5.883433e+00
      299  6.512596e-01            0  4.784630e+00
      300  4.197160e-01            0  5.522305e+00
      301  2.488221e-01            0  5.883433e+00
      302  6.512596e-01            0  4.784630e+00
      303  4.197160e-01            0  5.522305e+00
      304  2.488221e-01            0  5.883433e+00
      305  6.512596e-01            0  4.784630e+00
      306  4.197160e-01            0  5.522305e+00
      307  2.488221e-01            0  5.883433e+00
      308  6.512596e-01            0  4.784630e+00
      309  4.197160e-01            0  5.522305e+00
      310  2.488221e-01            0  5.883433e+00
      311  6.512596e-01            0  4.784630e+00
      312  4.197160e-01            0  5.522305e+00
      313  2.488221e-01            0  5.883433e+00
      314  6.512596e-01            0  4.784630e+00
      315  4.197160e-01            0  5.522305e+00
      316  2.488221e-01            0  5.883433e+00
      317  6.512596e-01            0  4.784630e+00
      318  4.197160e-01            0  5.522305e+00
      319  2.488221e-01            0  5.883433e+00
      320  6.512596e-01            0  4.784630e+00
      321  4.197160e-01            0  5.522305e+00
      322  3.142760e-01            0  3.240007e+01
      323  4.964033e-02            1 -2.616075e+02
      324  3.188759e-01            0 -1.068517e+02
      325  3.142760e-01            0  3.240007e+01
      326  4.964033e-02            1 -2.616075e+02
      327  3.188759e-01            0 -1.068517e+02
      328  3.142760e-01            0  3.240007e+01
      329  4.964033e-02            1 -2.616075e+02
      330  3.188759e-01            0 -1.068517e+02
      331  3.142760e-01            0  3.240007e+01
      332  4.964033e-02            1 -2.616075e+02
      333  3.188759e-01            0 -1.068517e+02
      334  3.142760e-01            0  3.240007e+01
      335  4.964033e-02            1 -2.616075e+02
      336  3.188759e-01            0 -1.068517e+02
      337  8.245280e-01            0  2.560398e+01
      338  6.238235e-01            0  1.801954e+01
      339  7.297483e-01            0  2.891926e+01
      340  8.245280e-01            0  2.560398e+01
      341  6.238235e-01            0  1.801954e+01
      342  7.297483e-01            0  2.891926e+01
      343  8.245280e-01            0  2.560398e+01
      344  6.238235e-01            0  1.801954e+01
      345  7.297483e-01            0  2.891926e+01
      346  8.245280e-01            0  2.560398e+01
      347  6.238235e-01            0  1.801954e+01
      348  7.297483e-01            0  2.891926e+01
      349  6.236134e-01            0 -5.305179e+01
      350  6.251955e-01            0 -4.024566e+01
      351  7.336015e-01            0 -3.355048e+01
      352  6.236134e-01            0 -5.305179e+01
      353  6.251955e-01            0 -4.024566e+01
      354  7.336015e-01            0 -3.355048e+01
      355  6.236134e-01            0 -5.305179e+01
      356  6.251955e-01            0 -4.024566e+01
      357  7.336015e-01            0 -3.355048e+01
      358  6.236134e-01            0 -5.305179e+01
      359  6.251955e-01            0 -4.024566e+01
      360  7.336015e-01            0 -3.355048e+01
      361  6.236134e-01            0 -5.305179e+01
      362  6.251955e-01            0 -4.024566e+01
      363  7.336015e-01            0 -3.355048e+01
      364  3.276767e-01            0  6.486994e+01
      365  7.999080e-03            1 -1.434996e+02
      366  5.171438e-02            0 -7.510583e+01
      367  3.276767e-01            0  6.486994e+01
      368  7.999080e-03            1 -1.434996e+02
      369  5.171438e-02            0 -7.510583e+01
      370  3.276767e-01            0  6.486994e+01
      371  7.999080e-03            1 -1.434996e+02
      372  5.171438e-02            0 -7.510583e+01
      373  3.276767e-01            0  6.486994e+01
      374  7.999080e-03            1 -1.434996e+02
      375  5.171438e-02            0 -7.510583e+01
      376  7.347544e-01            0 -1.570243e+01
      377  8.938796e-01            0  7.966587e+00
      378  3.226826e-01            0  9.772839e+01
      379  7.347544e-01            0 -1.570243e+01
      380  8.938796e-01            0  7.966587e+00
      381  3.226826e-01            0  9.772839e+01
      382  7.347544e-01            0 -1.570243e+01
      383  8.938796e-01            0  7.966587e+00
      384  3.226826e-01            0  9.772839e+01
      385  7.347544e-01            0 -1.570243e+01
      386  8.938796e-01            0  7.966587e+00
      387  3.226826e-01            0  9.772839e+01
      388  4.894483e-01            0 -7.719677e+01
      389  8.666694e-01            0 -2.334456e+01
      390  5.649390e-01            0 -5.355937e+01
      391  4.894483e-01            0 -7.719677e+01
      392  8.666694e-01            0 -2.334456e+01
      393  5.649390e-01            0 -5.355937e+01
      394  4.894483e-01            0 -7.719677e+01
      395  8.666694e-01            0 -2.334456e+01
      396  5.649390e-01            0 -5.355937e+01
      397  4.894483e-01            0 -7.719677e+01
      398  8.666694e-01            0 -2.334456e+01
      399  5.649390e-01            0 -5.355937e+01
      400  9.740336e-01            0 -3.480695e+00
      401  3.106276e-01            0 -2.641117e+02
      402  7.927485e-01            0 -1.919947e+01
      403  9.740336e-01            0 -3.480695e+00
      404  3.106276e-01            0 -2.641117e+02
      405  7.927485e-01            0 -1.919947e+01
      406  9.740336e-01            0 -3.480695e+00
      407  3.106276e-01            0 -2.641117e+02
      408  7.927485e-01            0 -1.919947e+01
      409  9.740336e-01            0 -3.480695e+00
      410  3.106276e-01            0 -2.641117e+02
      411  7.927485e-01            0 -1.919947e+01
      412  2.184631e-01            0 -1.371173e+02
      413  3.221338e-01            0 -6.738831e+01
      414  4.905164e-01            0 -1.705284e+02
      415  2.184631e-01            0 -1.371173e+02
      416  3.221338e-01            0 -6.738831e+01
      417  4.905164e-01            0 -1.705284e+02
      418  2.184631e-01            0 -1.371173e+02
      419  3.221338e-01            0 -6.738831e+01
      420  4.905164e-01            0 -1.705284e+02
      421  2.184631e-01            0 -1.371173e+02
      422  3.221338e-01            0 -6.738831e+01
      423  4.905164e-01            0 -1.705284e+02
      424  2.370084e-01            0  8.110969e+01
      425  3.380696e-01            0  5.439880e+01
      426  4.540856e-01            0  5.070219e+01
      427  2.370084e-01            0  8.110969e+01
      428  3.380696e-01            0  5.439880e+01
      429  4.540856e-01            0  5.070219e+01
      430  2.370084e-01            0  8.110969e+01
      431  3.380696e-01            0  5.439880e+01
      432  4.540856e-01            0  5.070219e+01
      433  2.370084e-01            0  8.110969e+01
      434  3.380696e-01            0  5.439880e+01
      435  4.540856e-01            0  5.070219e+01
      436  8.120209e-01            0 -6.272548e+00
      437  3.231692e-01            0 -6.442602e+01
      438  8.625105e-01            0  6.313164e+00
      439  8.120209e-01            0 -6.272548e+00
      440  3.231692e-01            0 -6.442602e+01
      441  8.625105e-01            0  6.313164e+00
      442  8.120209e-01            0 -6.272548e+00
      443  3.231692e-01            0 -6.442602e+01
      444  8.625105e-01            0  6.313164e+00
      445  8.120209e-01            0 -6.272548e+00
      446  3.231692e-01            0 -6.442602e+01
      447  8.625105e-01            0  6.313164e+00
      448  8.120209e-01            0 -6.272548e+00
      449  3.231692e-01            0 -6.442602e+01
      450  8.625105e-01            0  6.313164e+00
      451  7.081688e-02            0 -6.876055e+01
      452  5.687994e-01            0 -7.096649e+01
      453  3.672420e-01            0 -4.576977e+01
      454  7.081688e-02            0 -6.876055e+01
      455  5.687994e-01            0 -7.096649e+01
      456  3.672420e-01            0 -4.576977e+01
      457  7.081688e-02            0 -6.876055e+01
      458  5.687994e-01            0 -7.096649e+01
      459  3.672420e-01            0 -4.576977e+01
      460  7.081688e-02            0 -6.876055e+01
      461  5.687994e-01            0 -7.096649e+01
      462  3.672420e-01            0 -4.576977e+01
      463  7.081688e-02            0 -6.876055e+01
      464  5.687994e-01            0 -7.096649e+01
      465  3.672420e-01            0 -4.576977e+01
      466  4.983410e-01            0 -4.848805e+01
      467  5.732931e-01            0 -4.269022e+01
      468  1.078828e-01            0 -5.392028e+01
      469  4.983410e-01            0 -4.848805e+01
      470  5.732931e-01            0 -4.269022e+01
      471  1.078828e-01            0 -5.392028e+01
      472  4.983410e-01            0 -4.848805e+01
      473  5.732931e-01            0 -4.269022e+01
      474  1.078828e-01            0 -5.392028e+01
      475  4.983410e-01            0 -4.848805e+01
      476  5.732931e-01            0 -4.269022e+01
      477  1.078828e-01            0 -5.392028e+01
      478  4.983410e-01            0 -4.848805e+01
      479  5.732931e-01            0 -4.269022e+01
      480  1.078828e-01            0 -5.392028e+01
      481  7.835542e-01            0 -1.399176e+01
      482  1.886621e-01            0  4.608524e+01
      483  7.937924e-01            0 -3.135621e+01
      484  7.835542e-01            0 -1.399176e+01
      485  1.886621e-01            0  4.608524e+01
      486  7.937924e-01            0 -3.135621e+01
      487  7.835542e-01            0 -1.399176e+01
      488  1.886621e-01            0  4.608524e+01
      489  7.937924e-01            0 -3.135621e+01
      490  7.835542e-01            0 -1.399176e+01
      491  1.886621e-01            0  4.608524e+01
      492  7.937924e-01            0 -3.135621e+01
      493  7.835542e-01            0 -1.399176e+01
      494  1.886621e-01            0  4.608524e+01
      495  7.937924e-01            0 -3.135621e+01
      496  3.758629e-02            1  1.165526e+02
      497  2.515187e-02            1  1.346312e+02
      498  1.419802e-01            0  8.668817e+01
      499  3.758629e-02            1  1.165526e+02
      500  2.515187e-02            1  1.346312e+02
      501  1.419802e-01            0  8.668817e+01
      502  3.758629e-02            1  1.165526e+02
      503  2.515187e-02            1  1.346312e+02
      504  1.419802e-01            0  8.668817e+01
      505  3.758629e-02            1  1.165526e+02
      506  2.515187e-02            1  1.346312e+02
      507  1.419802e-01            0  8.668817e+01
      508  3.758629e-02            1  1.165526e+02
      509  2.515187e-02            1  1.346312e+02
      510  1.419802e-01            0  8.668817e+01
      511  3.758629e-02            1  1.165526e+02
      512  2.515187e-02            1  1.346312e+02
      513  1.419802e-01            0  8.668817e+01
      514  4.891772e-01            0  4.421498e+01
      515  6.255996e-01            0  3.356476e+01
      516  6.895849e-01            0 -1.983712e+01
      517  4.891772e-01            0  4.421498e+01
      518  6.255996e-01            0  3.356476e+01
      519  6.895849e-01            0 -1.983712e+01
      520  4.891772e-01            0  4.421498e+01
      521  6.255996e-01            0  3.356476e+01
      522  6.895849e-01            0 -1.983712e+01
      523  4.891772e-01            0  4.421498e+01
      524  6.255996e-01            0  3.356476e+01
      525  6.895849e-01            0 -1.983712e+01
      526  4.213752e-01            0  4.529700e+01
      527  4.554872e-01            0  2.998135e+01
      528  9.920045e-01            0  1.614217e+00
      529  4.213752e-01            0  4.529700e+01
      530  4.554872e-01            0  2.998135e+01
      531  9.920045e-01            0  1.614217e+00
      532  4.213752e-01            0  4.529700e+01
      533  4.554872e-01            0  2.998135e+01
      534  9.920045e-01            0  1.614217e+00
      535  4.213752e-01            0  4.529700e+01
      536  4.554872e-01            0  2.998135e+01
      537  9.920045e-01            0  1.614217e+00
      538  7.969859e-01            0 -2.294222e+01
      539  8.751851e-01            0  1.624956e+01
      540  9.958485e-01            0 -6.313400e-02
      541  7.969859e-01            0 -2.294222e+01
      542  8.751851e-01            0  1.624956e+01
      543  9.958485e-01            0 -6.313400e-02
      544  7.969859e-01            0 -2.294222e+01
      545  8.751851e-01            0  1.624956e+01
      546  9.958485e-01            0 -6.313400e-02
      547  7.969859e-01            0 -2.294222e+01
      548  8.751851e-01            0  1.624956e+01
      549  9.958485e-01            0 -6.313400e-02
      550  7.969859e-01            0 -2.294222e+01
      551  8.751851e-01            0  1.624956e+01
      552  9.958485e-01            0 -6.313400e-02
      553  3.592915e-01            0 -7.613724e+01
      554  6.046794e-01            0 -5.139488e+01
      555  3.322929e-01            0 -8.989975e+01
      556  3.592915e-01            0 -7.613724e+01
      557  6.046794e-01            0 -5.139488e+01
      558  3.322929e-01            0 -8.989975e+01
      559  3.592915e-01            0 -7.613724e+01
      560  6.046794e-01            0 -5.139488e+01
      561  3.322929e-01            0 -8.989975e+01
      562  3.592915e-01            0 -7.613724e+01
      563  6.046794e-01            0 -5.139488e+01
      564  3.322929e-01            0 -8.989975e+01
      565  2.017734e-01            0  8.494312e+01
      566  5.290584e-01            0 -2.842951e+01
      567  5.748199e-01            0 -5.114430e+01
      568  2.017734e-01            0  8.494312e+01
      569  5.290584e-01            0 -2.842951e+01
      570  5.748199e-01            0 -5.114430e+01
      571  2.017734e-01            0  8.494312e+01
      572  5.290584e-01            0 -2.842951e+01
      573  5.748199e-01            0 -5.114430e+01
      574  2.017734e-01            0  8.494312e+01
      575  5.290584e-01            0 -2.842951e+01
      576  5.748199e-01            0 -5.114430e+01
      577  2.017734e-01            0  8.494312e+01
      578  5.290584e-01            0 -2.842951e+01
      579  5.748199e-01            0 -5.114430e+01
      580  4.987366e-01            0  5.075741e+01
      581  4.006933e-01            0 -6.368919e+01
      582  7.265263e-01            0 -4.856094e+01
      583  4.987366e-01            0  5.075741e+01
      584  4.006933e-01            0 -6.368919e+01
      585  7.265263e-01            0 -4.856094e+01
      586  4.987366e-01            0  5.075741e+01
      587  4.006933e-01            0 -6.368919e+01
      588  7.265263e-01            0 -4.856094e+01
      589  4.987366e-01            0  5.075741e+01
      590  4.006933e-01            0 -6.368919e+01
      591  7.265263e-01            0 -4.856094e+01
      592  3.373396e-01            0 -5.698399e+02
      593  3.372876e-01            0 -8.817498e+02
      594  3.384415e-01            0 -6.489307e+02
      595  3.373396e-01            0 -5.698399e+02
      596  3.372876e-01            0 -8.817498e+02
      597  3.384415e-01            0 -6.489307e+02
      598  3.373396e-01            0 -5.698399e+02
      599  3.372876e-01            0 -8.817498e+02
      600  3.384415e-01            0 -6.489307e+02
      601  2.906680e-02            1  1.117995e+02
      602  3.850633e-01            0  6.794993e+01
      603  5.276189e-02            0  1.034956e+02
      604  2.906680e-02            1  1.117995e+02
      605  3.850633e-01            0  6.794993e+01
      606  5.276189e-02            0  1.034956e+02
      607  2.906680e-02            1  1.117995e+02
      608  3.850633e-01            0  6.794993e+01
      609  5.276189e-02            0  1.034956e+02
      610  2.906680e-02            1  1.117995e+02
      611  3.850633e-01            0  6.794993e+01
      612  5.276189e-02            0  1.034956e+02
      613  5.329762e-01            0 -3.908339e+01
      614  8.118336e-01            0 -1.835294e+01
      615  8.614280e-01            0  1.056776e+01
      616  5.329762e-01            0 -3.908339e+01
      617  8.118336e-01            0 -1.835294e+01
      618  8.614280e-01            0  1.056776e+01
      619  5.329762e-01            0 -3.908339e+01
      620  8.118336e-01            0 -1.835294e+01
      621  8.614280e-01            0  1.056776e+01
      622  5.329762e-01            0 -3.908339e+01
      623  8.118336e-01            0 -1.835294e+01
      624  8.614280e-01            0  1.056776e+01
      625  5.329762e-01            0 -3.908339e+01
      626  8.118336e-01            0 -1.835294e+01
      627  8.614280e-01            0  1.056776e+01
      628  5.329762e-01            0 -3.908339e+01
      629  8.118336e-01            0 -1.835294e+01
      630  8.614280e-01            0  1.056776e+01
      631  5.329762e-01            0 -3.908339e+01
      632  8.118336e-01            0 -1.835294e+01
      633  8.614280e-01            0  1.056776e+01
      634  5.072509e-01            0 -6.416076e+01
      635  3.657085e-01            0 -1.449302e+02
      636  5.166285e-01            0 -7.154395e+01
      637  5.072509e-01            0 -6.416076e+01
      638  3.657085e-01            0 -1.449302e+02
      639  5.166285e-01            0 -7.154395e+01
      640  5.072509e-01            0 -6.416076e+01
      641  3.657085e-01            0 -1.449302e+02
      642  5.166285e-01            0 -7.154395e+01
      643  5.072509e-01            0 -6.416076e+01
      644  3.657085e-01            0 -1.449302e+02
      645  5.166285e-01            0 -7.154395e+01
      646  5.072509e-01            0 -6.416076e+01
      647  3.657085e-01            0 -1.449302e+02
      648  5.166285e-01            0 -7.154395e+01
      649  2.372321e-01            0 -1.300868e+02
      650  3.600999e-01            0 -1.835367e+02
      651  2.310237e-01            0 -1.574742e+02
      652  2.372321e-01            0 -1.300868e+02
      653  3.600999e-01            0 -1.835367e+02
      654  2.310237e-01            0 -1.574742e+02
      655  2.372321e-01            0 -1.300868e+02
      656  3.600999e-01            0 -1.835367e+02
      657  2.310237e-01            0 -1.574742e+02
      658  2.372321e-01            0 -1.300868e+02
      659  3.600999e-01            0 -1.835367e+02
      660  2.310237e-01            0 -1.574742e+02
      661  5.490335e-01            0  1.438244e+02
      662  3.652473e-01            0  2.277803e+02
      663  3.021670e-01            0  1.796184e+02
      664  5.490335e-01            0  1.438244e+02
      665  3.652473e-01            0  2.277803e+02
      666  3.021670e-01            0  1.796184e+02
      667  5.490335e-01            0  1.438244e+02
      668  3.652473e-01            0  2.277803e+02
      669  3.021670e-01            0  1.796184e+02
      670  5.490335e-01            0  1.438244e+02
      671  3.652473e-01            0  2.277803e+02
      672  3.021670e-01            0  1.796184e+02
      673  3.279625e-01            0 -1.347300e+02
      674  6.493258e-01            0 -1.131658e+02
      675  2.438393e-01            0 -1.812827e+02
      676  3.279625e-01            0 -1.347300e+02
      677  6.493258e-01            0 -1.131658e+02
      678  2.438393e-01            0 -1.812827e+02
      679  3.279625e-01            0 -1.347300e+02
      680  6.493258e-01            0 -1.131658e+02
      681  2.438393e-01            0 -1.812827e+02
      682  3.279625e-01            0 -1.347300e+02
      683  6.493258e-01            0 -1.131658e+02
      684  2.438393e-01            0 -1.812827e+02
      685  2.254033e-01            0  6.039000e+02
      686  2.254033e-01            0  6.039000e+02
      687  2.254033e-01            0  3.455143e+02
      688  2.254033e-01            0  6.039000e+02
      689  2.254033e-01            0  6.039000e+02
      690  2.254033e-01            0  3.455143e+02
      691  2.254033e-01            0  6.039000e+02
      692  2.254033e-01            0  6.039000e+02
      693  2.254033e-01            0  3.455143e+02
      694  2.254033e-01            0  6.039000e+02
      695  2.254033e-01            0  6.039000e+02
      696  2.254033e-01            0  3.455143e+02
      697  2.973036e-01            0 -2.027979e+02
      698  9.765481e-01            0  1.162771e+01
      699  4.663742e-01            0 -1.611396e+02
      700  2.973036e-01            0 -2.027979e+02
      701  9.765481e-01            0  1.162771e+01
      702  4.663742e-01            0 -1.611396e+02
      703  2.973036e-01            0 -2.027979e+02
      704  9.765481e-01            0  1.162771e+01
      705  4.663742e-01            0 -1.611396e+02
      706  7.982051e-01            0  1.550500e+00
      707  1.878822e-01            0 -1.308928e+02
      708  6.916873e-02            0 -1.185636e+02
      709  7.982051e-01            0  1.550500e+00
      710  1.878822e-01            0 -1.308928e+02
      711  6.916873e-02            0 -1.185636e+02
      712  7.982051e-01            0  1.550500e+00
      713  1.878822e-01            0 -1.308928e+02
      714  6.916873e-02            0 -1.185636e+02
      715  7.982051e-01            0  1.550500e+00
      716  1.878822e-01            0 -1.308928e+02
      717  6.916873e-02            0 -1.185636e+02
      718  5.111473e-01            0  5.426184e+01
      719  3.396964e-01            0  9.808603e+01
      720  4.271996e-01            0  4.886042e+01
      721  5.111473e-01            0  5.426184e+01
      722  3.396964e-01            0  9.808603e+01
      723  4.271996e-01            0  4.886042e+01
      724  5.111473e-01            0  5.426184e+01
      725  3.396964e-01            0  9.808603e+01
      726  4.271996e-01            0  4.886042e+01
      727  5.111473e-01            0  5.426184e+01
      728  3.396964e-01            0  9.808603e+01
      729  4.271996e-01            0  4.886042e+01
      730  5.217146e-01            0  4.330899e+01
      731  7.526040e-01            0 -1.136934e+02
      732  6.223725e-01            0 -5.898360e+01
      733  5.217146e-01            0  4.330899e+01
      734  7.526040e-01            0 -1.136934e+02
      735  6.223725e-01            0 -5.898360e+01
      736  5.217146e-01            0  4.330899e+01
      737  7.526040e-01            0 -1.136934e+02
      738  6.223725e-01            0 -5.898360e+01
      739  3.753297e-01            0 -9.466263e+01
      740  5.346975e-01            0  1.082645e+02
      741  8.957821e-01            0  1.625762e+01
      742  3.753297e-01            0 -9.466263e+01
      743  5.346975e-01            0  1.082645e+02
      744  8.957821e-01            0  1.625762e+01
      745  3.753297e-01            0 -9.466263e+01
      746  5.346975e-01            0  1.082645e+02
      747  8.957821e-01            0  1.625762e+01
      748  3.753297e-01            0 -9.466263e+01
      749  5.346975e-01            0  1.082645e+02
      750  8.957821e-01            0  1.625762e+01
      751  1.085237e-01            0  1.516688e+02
      752  8.136895e-01            0 -2.994020e+01
      753  4.528605e-01            0  1.798374e+02
      754  1.085237e-01            0  1.516688e+02
      755  8.136895e-01            0 -2.994020e+01
      756  4.528605e-01            0  1.798374e+02
      757  1.085237e-01            0  1.516688e+02
      758  8.136895e-01            0 -2.994020e+01
      759  4.528605e-01            0  1.798374e+02
      760  1.085237e-01            0  1.516688e+02
      761  8.136895e-01            0 -2.994020e+01
      762  4.528605e-01            0  1.798374e+02
      763  6.931469e-01            0 -4.003162e+01
      764  7.965246e-01            0  4.987970e+01
      765  7.115744e-01            0 -5.259762e+01
      766  6.931469e-01            0 -4.003162e+01
      767  7.965246e-01            0  4.987970e+01
      768  7.115744e-01            0 -5.259762e+01
      769  6.931469e-01            0 -4.003162e+01
      770  7.965246e-01            0  4.987970e+01
      771  7.115744e-01            0 -5.259762e+01
      772  6.931469e-01            0 -4.003162e+01
      773  7.965246e-01            0  4.987970e+01
      774  7.115744e-01            0 -5.259762e+01
      775  6.931469e-01            0 -4.003162e+01
      776  7.965246e-01            0  4.987970e+01
      777  7.115744e-01            0 -5.259762e+01
      778  6.304316e-01            0  2.171078e+01
      779  2.802045e-01            0 -7.905544e+01
      780  6.756241e-01            0 -1.925572e+01
      781  6.304316e-01            0  2.171078e+01
      782  2.802045e-01            0 -7.905544e+01
      783  6.756241e-01            0 -1.925572e+01
      784  6.304316e-01            0  2.171078e+01
      785  2.802045e-01            0 -7.905544e+01
      786  6.756241e-01            0 -1.925572e+01
      787  6.304316e-01            0  2.171078e+01
      788  2.802045e-01            0 -7.905544e+01
      789  6.756241e-01            0 -1.925572e+01
      790  6.304316e-01            0  2.171078e+01
      791  2.802045e-01            0 -7.905544e+01
      792  6.756241e-01            0 -1.925572e+01
      793  6.304316e-01            0  2.171078e+01
      794  2.802045e-01            0 -7.905544e+01
      795  6.756241e-01            0 -1.925572e+01
      796  6.304316e-01            0  2.171078e+01
      797  2.802045e-01            0 -7.905544e+01
      798  6.756241e-01            0 -1.925572e+01
      799  6.304316e-01            0  2.171078e+01
      800  2.802045e-01            0 -7.905544e+01
      801  6.756241e-01            0 -1.925572e+01
      802  8.943325e-01            0  5.832179e+00
      803  8.434507e-01            0 -1.497791e+01
      804  7.983904e-01            0 -2.410039e+01
      805  8.943325e-01            0  5.832179e+00
      806  8.434507e-01            0 -1.497791e+01
      807  7.983904e-01            0 -2.410039e+01
      808  8.943325e-01            0  5.832179e+00
      809  8.434507e-01            0 -1.497791e+01
      810  7.983904e-01            0 -2.410039e+01
      811  8.943325e-01            0  5.832179e+00
      812  8.434507e-01            0 -1.497791e+01
      813  7.983904e-01            0 -2.410039e+01
      814  8.943325e-01            0  5.832179e+00
      815  8.434507e-01            0 -1.497791e+01
      816  7.983904e-01            0 -2.410039e+01
      817  8.943325e-01            0  5.832179e+00
      818  8.434507e-01            0 -1.497791e+01
      819  7.983904e-01            0 -2.410039e+01
      820  8.383167e-01            0 -2.603017e+01
      821  5.643532e-01            0 -1.047205e+02
      822  6.965385e-01            0 -5.419237e+01
      823  8.383167e-01            0 -2.603017e+01
      824  5.643532e-01            0 -1.047205e+02
      825  6.965385e-01            0 -5.419237e+01
      826  8.383167e-01            0 -2.603017e+01
      827  5.643532e-01            0 -1.047205e+02
      828  6.965385e-01            0 -5.419237e+01
      829  8.383167e-01            0 -2.603017e+01
      830  5.643532e-01            0 -1.047205e+02
      831  6.965385e-01            0 -5.419237e+01
      832  8.383167e-01            0 -2.603017e+01
      833  5.643532e-01            0 -1.047205e+02
      834  6.965385e-01            0 -5.419237e+01
      835  8.383167e-01            0 -2.603017e+01
      836  5.643532e-01            0 -1.047205e+02
      837  6.965385e-01            0 -5.419237e+01
      838  8.209582e-01            0 -1.008746e+01
      839  7.999154e-02            0  6.873059e+01
      840  7.161053e-01            0  1.116138e+01
      841  8.209582e-01            0 -1.008746e+01
      842  7.999154e-02            0  6.873059e+01
      843  7.161053e-01            0  1.116138e+01
      844  8.209582e-01            0 -1.008746e+01
      845  7.999154e-02            0  6.873059e+01
      846  7.161053e-01            0  1.116138e+01
      847  8.209582e-01            0 -1.008746e+01
      848  7.999154e-02            0  6.873059e+01
      849  7.161053e-01            0  1.116138e+01
      850  8.209582e-01            0 -1.008746e+01
      851  7.999154e-02            0  6.873059e+01
      852  7.161053e-01            0  1.116138e+01
      853  8.209582e-01            0 -1.008746e+01
      854  7.999154e-02            0  6.873059e+01
      855  7.161053e-01            0  1.116138e+01
      856  6.560140e-01            0 -4.908679e+01
      857  4.372191e-01            0  9.589316e+01
      858  6.144256e-01            0  6.338047e+01
      859  6.560140e-01            0 -4.908679e+01
      860  4.372191e-01            0  9.589316e+01
      861  6.144256e-01            0  6.338047e+01
      862  6.560140e-01            0 -4.908679e+01
      863  4.372191e-01            0  9.589316e+01
      864  6.144256e-01            0  6.338047e+01
      865  9.299985e-01            0 -8.776748e+00
      866  7.347011e-04            1 -1.341886e+02
      867  4.649265e-02            1 -9.715742e+01
      868  9.299985e-01            0 -8.776748e+00
      869  7.347011e-04            1 -1.341886e+02
      870  4.649265e-02            1 -9.715742e+01
      871  9.299985e-01            0 -8.776748e+00
      872  7.347011e-04            1 -1.341886e+02
      873  4.649265e-02            1 -9.715742e+01
      874  9.299985e-01            0 -8.776748e+00
      875  7.347011e-04            1 -1.341886e+02
      876  4.649265e-02            1 -9.715742e+01
      877  9.299985e-01            0 -8.776748e+00
      878  7.347011e-04            1 -1.341886e+02
      879  4.649265e-02            1 -9.715742e+01
      880  1.828928e-01            0 -2.817996e+01
      881  5.313678e-01            0 -4.900061e+01
      882  3.111137e-02            1 -5.019477e+01
      883  1.828928e-01            0 -2.817996e+01
      884  5.313678e-01            0 -4.900061e+01
      885  3.111137e-02            1 -5.019477e+01
      886  1.828928e-01            0 -2.817996e+01
      887  5.313678e-01            0 -4.900061e+01
      888  3.111137e-02            1 -5.019477e+01
      889  1.828928e-01            0 -2.817996e+01
      890  5.313678e-01            0 -4.900061e+01
      891  3.111137e-02            1 -5.019477e+01
      892  1.828928e-01            0 -2.817996e+01
      893  5.313678e-01            0 -4.900061e+01
      894  3.111137e-02            1 -5.019477e+01
      895  4.631785e-02            1  2.239432e+02
      896  9.728178e-02            0  2.335358e+02
      897  5.985326e-03            1  2.604647e+02
      898  4.631785e-02            1  2.239432e+02
      899  9.728178e-02            0  2.335358e+02
      900  5.985326e-03            1  2.604647e+02
      901  4.631785e-02            1  2.239432e+02
      902  9.728178e-02            0  2.335358e+02
      903  5.985326e-03            1  2.604647e+02
      904  4.631785e-02            1  2.239432e+02
      905  9.728178e-02            0  2.335358e+02
      906  5.985326e-03            1  2.604647e+02
      907  2.184093e-01            0 -7.713390e+01
      908  6.990942e-01            0 -2.671465e+01
      909  9.051236e-01            0  7.664907e+00
      910  2.184093e-01            0 -7.713390e+01
      911  6.990942e-01            0 -2.671465e+01
      912  9.051236e-01            0  7.664907e+00
      913  2.184093e-01            0 -7.713390e+01
      914  6.990942e-01            0 -2.671465e+01
      915  9.051236e-01            0  7.664907e+00
      916  2.184093e-01            0 -7.713390e+01
      917  6.990942e-01            0 -2.671465e+01
      918  9.051236e-01            0  7.664907e+00
      919  7.282295e-01            0 -1.962585e+01
      920  5.082200e-01            0 -3.447123e+02
      921  5.997032e-01            0 -1.166229e+02
      922  7.282295e-01            0 -1.962585e+01
      923  5.082200e-01            0 -3.447123e+02
      924  5.997032e-01            0 -1.166229e+02
      925  7.282295e-01            0 -1.962585e+01
      926  5.082200e-01            0 -3.447123e+02
      927  5.997032e-01            0 -1.166229e+02
      928  7.282295e-01            0 -1.962585e+01
      929  5.082200e-01            0 -3.447123e+02
      930  5.997032e-01            0 -1.166229e+02
      931  2.883398e-01            0 -7.629003e+01
      932  9.978861e-01            0  3.886073e-01
      933  6.061358e-01            0 -2.581231e+01
      934  2.883398e-01            0 -7.629003e+01
      935  9.978861e-01            0  3.886073e-01
      936  6.061358e-01            0 -2.581231e+01
      937  2.883398e-01            0 -7.629003e+01
      938  9.978861e-01            0  3.886073e-01
      939  6.061358e-01            0 -2.581231e+01
      940  2.883398e-01            0 -7.629003e+01
      941  9.978861e-01            0  3.886073e-01
      942  6.061358e-01            0 -2.581231e+01
      943  2.883398e-01            0 -7.629003e+01
      944  9.978861e-01            0  3.886073e-01
      945  6.061358e-01            0 -2.581231e+01
      946  4.070038e-01            0  9.140127e+01
      947  2.311720e-01            0  1.488317e+02
      948  2.015178e-01            0  1.120814e+02
      949  4.070038e-01            0  9.140127e+01
      950  2.311720e-01            0  1.488317e+02
      951  2.015178e-01            0  1.120814e+02
      952  4.070038e-01            0  9.140127e+01
      953  2.311720e-01            0  1.488317e+02
      954  2.015178e-01            0  1.120814e+02
      955  4.070038e-01            0  9.140127e+01
      956  2.311720e-01            0  1.488317e+02
      957  2.015178e-01            0  1.120814e+02
      958  1.305816e-01            0  1.552402e+02
      959  2.222157e-01            0  2.811986e+01
      960  1.054395e-01            0  2.860671e+02
      961  1.305816e-01            0  1.552402e+02
      962  2.222157e-01            0  2.811986e+01
      963  1.054395e-01            0  2.860671e+02
      964  1.305816e-01            0  1.552402e+02
      965  2.222157e-01            0  2.811986e+01
      966  1.054395e-01            0  2.860671e+02
      967  4.870820e-01            0  5.602377e+01
      968  4.029351e-01            0 -5.107228e+01
      969  2.984688e-01            0 -1.103936e+02
      970  4.870820e-01            0  5.602377e+01
      971  4.029351e-01            0 -5.107228e+01
      972  2.984688e-01            0 -1.103936e+02
      973  4.870820e-01            0  5.602377e+01
      974  4.029351e-01            0 -5.107228e+01
      975  2.984688e-01            0 -1.103936e+02
      976  4.870820e-01            0  5.602377e+01
      977  4.029351e-01            0 -5.107228e+01
      978  2.984688e-01            0 -1.103936e+02
      979  9.621115e-01            0 -5.995870e+00
      980  8.889956e-01            0 -2.948021e+01
      981  7.726203e-01            0 -2.040743e+01
      982  9.621115e-01            0 -5.995870e+00
      983  8.889956e-01            0 -2.948021e+01
      984  7.726203e-01            0 -2.040743e+01
      985  9.621115e-01            0 -5.995870e+00
      986  8.889956e-01            0 -2.948021e+01
      987  7.726203e-01            0 -2.040743e+01
      988  9.621115e-01            0 -5.995870e+00
      989  8.889956e-01            0 -2.948021e+01
      990  7.726203e-01            0 -2.040743e+01
      991  9.621115e-01            0 -5.995870e+00
      992  8.889956e-01            0 -2.948021e+01
      993  7.726203e-01            0 -2.040743e+01
      994  3.816162e-01            0 -5.376614e+01
      995  5.489180e-01            0 -3.915005e+01
      996  5.939334e-01            0 -5.806915e+01
      997  3.816162e-01            0 -5.376614e+01
      998  5.489180e-01            0 -3.915005e+01
      999  5.939334e-01            0 -5.806915e+01
      1000 3.816162e-01            0 -5.376614e+01
      1001 5.489180e-01            0 -3.915005e+01
      1002 5.939334e-01            0 -5.806915e+01
      1003 3.816162e-01            0 -5.376614e+01
      1004 5.489180e-01            0 -3.915005e+01
      1005 5.939334e-01            0 -5.806915e+01
      1006 8.159946e-02            0  1.967196e+02
      1007 3.568929e-01            0 -4.190912e+01
      1008 7.123754e-01            0  2.367490e+01
      1009 8.159946e-02            0  1.967196e+02
      1010 3.568929e-01            0 -4.190912e+01
      1011 7.123754e-01            0  2.367490e+01
      1012 8.159946e-02            0  1.967196e+02
      1013 3.568929e-01            0 -4.190912e+01
      1014 7.123754e-01            0  2.367490e+01
      1015 8.159946e-02            0  1.967196e+02
      1016 3.568929e-01            0 -4.190912e+01
      1017 7.123754e-01            0  2.367490e+01
      1018 2.537570e-01            0  9.733365e+01
      1019 5.915184e-01            0  4.894269e+01
      1020 4.737276e-01            0  6.374685e+01
      1021 2.537570e-01            0  9.733365e+01
      1022 5.915184e-01            0  4.894269e+01
      1023 4.737276e-01            0  6.374685e+01
      1024 2.537570e-01            0  9.733365e+01
      1025 5.915184e-01            0  4.894269e+01
      1026 4.737276e-01            0  6.374685e+01
      1027 2.537570e-01            0  9.733365e+01
      1028 5.915184e-01            0  4.894269e+01
      1029 4.737276e-01            0  6.374685e+01
      1030 2.537570e-01            0  9.733365e+01
      1031 5.915184e-01            0  4.894269e+01
      1032 4.737276e-01            0  6.374685e+01
      1033 1.102513e-01            0 -6.866112e+01
      1034 6.958127e-01            0 -5.584071e+01
      1035 8.783540e-01            0 -3.577139e+01
      1036 1.102513e-01            0 -6.866112e+01
      1037 6.958127e-01            0 -5.584071e+01
      1038 8.783540e-01            0 -3.577139e+01
      1039 1.102513e-01            0 -6.866112e+01
      1040 6.958127e-01            0 -5.584071e+01
      1041 8.783540e-01            0 -3.577139e+01
      1042 1.102513e-01            0 -6.866112e+01
      1043 6.958127e-01            0 -5.584071e+01
      1044 8.783540e-01            0 -3.577139e+01
      1045 6.433857e-01            0 -9.548228e+01
      1046 9.268249e-02            0 -4.362942e+02
      1047 3.579394e-01            0 -2.649031e+02
      1048 6.433857e-01            0 -9.548228e+01
      1049 9.268249e-02            0 -4.362942e+02
      1050 3.579394e-01            0 -2.649031e+02
      1051 6.433857e-01            0 -9.548228e+01
      1052 9.268249e-02            0 -4.362942e+02
      1053 3.579394e-01            0 -2.649031e+02
      1054 6.433857e-01            0 -9.548228e+01
      1055 9.268249e-02            0 -4.362942e+02
      1056 3.579394e-01            0 -2.649031e+02
      1057 9.655755e-01            0  1.538514e+01
      1058 9.941821e-01            0  9.165185e+00
      1059 9.755970e-01            0 -2.119527e+01
      1060 9.655755e-01            0  1.538514e+01
      1061 9.941821e-01            0  9.165185e+00
      1062 9.755970e-01            0 -2.119527e+01
      1063 9.655755e-01            0  1.538514e+01
      1064 9.941821e-01            0  9.165185e+00
      1065 9.755970e-01            0 -2.119527e+01
      1066 1.413432e-02            1  9.707469e+01
      1067 5.466281e-01            0 -3.245404e+01
      1068 1.427972e-01            0 -2.237147e+02
      1069 1.413432e-02            1  9.707469e+01
      1070 5.466281e-01            0 -3.245404e+01
      1071 1.427972e-01            0 -2.237147e+02
      1072 1.413432e-02            1  9.707469e+01
      1073 5.466281e-01            0 -3.245404e+01
      1074 1.427972e-01            0 -2.237147e+02
      1075 3.333333e-01            0 -6.134537e+02
      1076 3.096330e-01            0 -2.316868e+02
      1077 3.592647e-01            0 -4.277092e+02
      1078 3.333333e-01            0 -6.134537e+02
      1079 3.096330e-01            0 -2.316868e+02
      1080 3.592647e-01            0 -4.277092e+02
      1081 3.333333e-01            0 -6.134537e+02
      1082 3.096330e-01            0 -2.316868e+02
      1083 3.592647e-01            0 -4.277092e+02
      1084 8.610529e-01            0  2.304295e+01
      1085 1.360424e-01            0 -2.181336e+02
      1086 3.052490e-01            0 -1.320682e+02
      1087 8.610529e-01            0  2.304295e+01
      1088 1.360424e-01            0 -2.181336e+02
      1089 3.052490e-01            0 -1.320682e+02
      1090 8.610529e-01            0  2.304295e+01
      1091 1.360424e-01            0 -2.181336e+02
      1092 3.052490e-01            0 -1.320682e+02
      1093 8.610529e-01            0  2.304295e+01
      1094 1.360424e-01            0 -2.181336e+02
      1095 3.052490e-01            0 -1.320682e+02
      1096 6.044321e-01            0 -5.313935e+01
      1097 7.632285e-01            0 -9.318202e+01
      1098 5.371238e-01            0 -1.043233e+02
      1099 6.044321e-01            0 -5.313935e+01
      1100 7.632285e-01            0 -9.318202e+01
      1101 5.371238e-01            0 -1.043233e+02
      1102 6.044321e-01            0 -5.313935e+01
      1103 7.632285e-01            0 -9.318202e+01
      1104 5.371238e-01            0 -1.043233e+02
      1105 6.044321e-01            0 -5.313935e+01
      1106 7.632285e-01            0 -9.318202e+01
      1107 5.371238e-01            0 -1.043233e+02
      1108 6.044321e-01            0 -5.313935e+01
      1109 7.632285e-01            0 -9.318202e+01
      1110 5.371238e-01            0 -1.043233e+02
      1111 1.091826e-01            0 -1.649753e+02
      1112 9.203492e-01            0 -3.010934e+01
      1113 5.517498e-01            0 -9.639619e+01
      1114 1.091826e-01            0 -1.649753e+02
      1115 9.203492e-01            0 -3.010934e+01
      1116 5.517498e-01            0 -9.639619e+01
      1117 1.091826e-01            0 -1.649753e+02
      1118 9.203492e-01            0 -3.010934e+01
      1119 5.517498e-01            0 -9.639619e+01
      1120 8.064582e-01            0 -2.977042e+01
      1121 6.937355e-01            0 -2.926238e+01
      1122 5.991990e-01            0 -3.393120e+01
      1123 8.064582e-01            0 -2.977042e+01
      1124 6.937355e-01            0 -2.926238e+01
      1125 5.991990e-01            0 -3.393120e+01
      1126 8.064582e-01            0 -2.977042e+01
      1127 6.937355e-01            0 -2.926238e+01
      1128 5.991990e-01            0 -3.393120e+01
      1129 8.064582e-01            0 -2.977042e+01
      1130 6.937355e-01            0 -2.926238e+01
      1131 5.991990e-01            0 -3.393120e+01
      1132 7.137114e-01            0  2.448636e+01
      1133 1.769500e-01            0  6.214841e+01
      1134 6.392324e-01            0  3.356165e+01
      1135 7.137114e-01            0  2.448636e+01
      1136 1.769500e-01            0  6.214841e+01
      1137 6.392324e-01            0  3.356165e+01
      1138 7.137114e-01            0  2.448636e+01
      1139 1.769500e-01            0  6.214841e+01
      1140 6.392324e-01            0  3.356165e+01
      1141 7.137114e-01            0  2.448636e+01
      1142 1.769500e-01            0  6.214841e+01
      1143 6.392324e-01            0  3.356165e+01
      1144 7.137114e-01            0  2.448636e+01
      1145 1.769500e-01            0  6.214841e+01
      1146 6.392324e-01            0  3.356165e+01
      1147 5.300142e-01            0  3.833944e+01
      1148 2.894249e-01            0  6.954580e+01
      1149 7.827711e-01            0 -8.354470e+00
      1150 5.300142e-01            0  3.833944e+01
      1151 2.894249e-01            0  6.954580e+01
      1152 7.827711e-01            0 -8.354470e+00
      1153 5.300142e-01            0  3.833944e+01
      1154 2.894249e-01            0  6.954580e+01
      1155 7.827711e-01            0 -8.354470e+00
      1156 5.300142e-01            0  3.833944e+01
      1157 2.894249e-01            0  6.954580e+01
      1158 7.827711e-01            0 -8.354470e+00
      1159 7.410206e-01            0  2.289120e+01
      1160 9.171032e-01            0 -1.494363e+01
      1161 8.740322e-01            0 -2.243308e+01
      1162 7.410206e-01            0  2.289120e+01
      1163 9.171032e-01            0 -1.494363e+01
      1164 8.740322e-01            0 -2.243308e+01
      1165 7.410206e-01            0  2.289120e+01
      1166 9.171032e-01            0 -1.494363e+01
      1167 8.740322e-01            0 -2.243308e+01
      1168 7.410206e-01            0  2.289120e+01
      1169 9.171032e-01            0 -1.494363e+01
      1170 8.740322e-01            0 -2.243308e+01
      1171 7.410206e-01            0  2.289120e+01
      1172 9.171032e-01            0 -1.494363e+01
      1173 8.740322e-01            0 -2.243308e+01
      1174 1.001358e-01            0 -3.374582e+02
      1175 9.565083e-03            1 -2.729895e+02
      1176 6.746103e-03            1 -2.822873e+02
      1177 1.001358e-01            0 -3.374582e+02
      1178 9.565083e-03            1 -2.729895e+02
      1179 6.746103e-03            1 -2.822873e+02
      1180 1.001358e-01            0 -3.374582e+02
      1181 9.565083e-03            1 -2.729895e+02
      1182 6.746103e-03            1 -2.822873e+02
      1183 1.001358e-01            0 -3.374582e+02
      1184 9.565083e-03            1 -2.729895e+02
      1185 6.746103e-03            1 -2.822873e+02
      1186 4.054395e-01            0  8.452745e+01
      1187 5.810774e-01            0 -1.536766e+02
      1188 3.870199e-01            0 -7.889943e+01
      1189 4.054395e-01            0  8.452745e+01
      1190 5.810774e-01            0 -1.536766e+02
      1191 3.870199e-01            0 -7.889943e+01
      1192 4.054395e-01            0  8.452745e+01
      1193 5.810774e-01            0 -1.536766e+02
      1194 3.870199e-01            0 -7.889943e+01
      1195 1.051203e-01            0 -1.599015e+02
      1196 1.845700e-01            0 -1.867579e+02
      1197 7.716041e-02            0 -9.042955e+01
      1198 1.051203e-01            0 -1.599015e+02
      1199 1.845700e-01            0 -1.867579e+02
      1200 7.716041e-02            0 -9.042955e+01
      1201 1.051203e-01            0 -1.599015e+02
      1202 1.845700e-01            0 -1.867579e+02
      1203 7.716041e-02            0 -9.042955e+01
      1204 1.051203e-01            0 -1.599015e+02
      1205 1.845700e-01            0 -1.867579e+02
      1206 7.716041e-02            0 -9.042955e+01
      1207 8.478391e-01            0 -2.884891e+01
      1208 2.131136e-01            0 -1.101507e+02
      1209 5.520392e-01            0 -4.713751e+01
      1210 8.478391e-01            0 -2.884891e+01
      1211 2.131136e-01            0 -1.101507e+02
      1212 5.520392e-01            0 -4.713751e+01
      1213 8.478391e-01            0 -2.884891e+01
      1214 2.131136e-01            0 -1.101507e+02
      1215 5.520392e-01            0 -4.713751e+01
      1216 8.478391e-01            0 -2.884891e+01
      1217 2.131136e-01            0 -1.101507e+02
      1218 5.520392e-01            0 -4.713751e+01
      1219 8.478391e-01            0 -2.884891e+01
      1220 2.131136e-01            0 -1.101507e+02
      1221 5.520392e-01            0 -4.713751e+01
      1222 7.349202e-01            0 -3.573214e+01
      1223 7.137862e-01            0  5.374087e+01
      1224 7.433869e-01            0 -4.233648e+01
      1225 7.349202e-01            0 -3.573214e+01
      1226 7.137862e-01            0  5.374087e+01
      1227 7.433869e-01            0 -4.233648e+01
      1228 7.349202e-01            0 -3.573214e+01
      1229 7.137862e-01            0  5.374087e+01
      1230 7.433869e-01            0 -4.233648e+01
      1231 7.349202e-01            0 -3.573214e+01
      1232 7.137862e-01            0  5.374087e+01
      1233 7.433869e-01            0 -4.233648e+01
      1234 7.349202e-01            0 -3.573214e+01
      1235 7.137862e-01            0  5.374087e+01
      1236 7.433869e-01            0 -4.233648e+01
      1237 7.349202e-01            0 -3.573214e+01
      1238 7.137862e-01            0  5.374087e+01
      1239 7.433869e-01            0 -4.233648e+01
      1240 7.349202e-01            0 -3.573214e+01
      1241 7.137862e-01            0  5.374087e+01
      1242 7.433869e-01            0 -4.233648e+01
      1243 8.789623e-01            0  1.442857e+02
      1244 8.789623e-01            0  1.442857e+02
      1245 8.789623e-01            0  9.652381e+01
      1246 8.789623e-01            0  1.442857e+02
      1247 8.789623e-01            0  1.442857e+02
      1248 8.789623e-01            0  9.652381e+01
      1249 8.789623e-01            0  1.442857e+02
      1250 8.789623e-01            0  1.442857e+02
      1251 8.789623e-01            0  9.652381e+01
      1252 3.333333e-01            0 -5.021667e+02
      1253 9.216369e-01            0  3.453276e+01
      1254 1.000000e+00            0  3.888889e-01
      1255 3.333333e-01            0 -5.021667e+02
      1256 9.216369e-01            0  3.453276e+01
      1257 1.000000e+00            0  3.888889e-01
      1258 3.333333e-01            0 -5.021667e+02
      1259 9.216369e-01            0  3.453276e+01
      1260 1.000000e+00            0  3.888889e-01
      1261 7.418011e-01            0 -1.338667e+02
      1262 7.475942e-01            0 -8.943332e+01
      1263 8.250931e-01            0 -9.681032e+01
      1264 7.418011e-01            0 -1.338667e+02
      1265 7.475942e-01            0 -8.943332e+01
      1266 8.250931e-01            0 -9.681032e+01
      1267 7.418011e-01            0 -1.338667e+02
      1268 7.475942e-01            0 -8.943332e+01
      1269 8.250931e-01            0 -9.681032e+01
      1270 7.418011e-01            0 -1.338667e+02
      1271 7.475942e-01            0 -8.943332e+01
      1272 8.250931e-01            0 -9.681032e+01
      1273 3.333333e-01            0  5.028333e+02
      1274 3.333333e-01            0  1.328490e+00
      1275 7.604948e-01            0 -1.157467e+02
      1276 3.333333e-01            0  5.028333e+02
      1277 3.333333e-01            0  1.328490e+00
      1278 7.604948e-01            0 -1.157467e+02
      1279 3.333333e-01            0  5.028333e+02
      1280 3.333333e-01            0  1.328490e+00
      1281 7.604948e-01            0 -1.157467e+02
      1282 6.448239e-01            0 -4.337640e+01
      1283 5.841660e-01            0 -6.455723e+01
      1284 7.083312e-01            0 -3.376666e+01
      1285 6.448239e-01            0 -4.337640e+01
      1286 5.841660e-01            0 -6.455723e+01
      1287 7.083312e-01            0 -3.376666e+01
      1288 6.448239e-01            0 -4.337640e+01
      1289 5.841660e-01            0 -6.455723e+01
      1290 7.083312e-01            0 -3.376666e+01
      1291 6.448239e-01            0 -4.337640e+01
      1292 5.841660e-01            0 -6.455723e+01
      1293 7.083312e-01            0 -3.376666e+01
      1294 6.448239e-01            0 -4.337640e+01
      1295 5.841660e-01            0 -6.455723e+01
      1296 7.083312e-01            0 -3.376666e+01
      1297 6.448239e-01            0 -4.337640e+01
      1298 5.841660e-01            0 -6.455723e+01
      1299 7.083312e-01            0 -3.376666e+01
      1300 9.543624e-01            0 -6.194163e+00
      1301 5.632078e-01            0 -1.338575e+02
      1302 7.452944e-01            0 -6.890433e+01
      1303 9.543624e-01            0 -6.194163e+00
      1304 5.632078e-01            0 -1.338575e+02
      1305 7.452944e-01            0 -6.890433e+01
      1306 9.543624e-01            0 -6.194163e+00
      1307 5.632078e-01            0 -1.338575e+02
      1308 7.452944e-01            0 -6.890433e+01
      1309 9.543624e-01            0 -6.194163e+00
      1310 5.632078e-01            0 -1.338575e+02
      1311 7.452944e-01            0 -6.890433e+01
      1312 9.543624e-01            0 -6.194163e+00
      1313 5.632078e-01            0 -1.338575e+02
      1314 7.452944e-01            0 -6.890433e+01
      1315 9.543624e-01            0 -6.194163e+00
      1316 5.632078e-01            0 -1.338575e+02
      1317 7.452944e-01            0 -6.890433e+01
      1318 9.470521e-01            0 -7.505786e+00
      1319 5.436513e-01            0  8.181985e+01
      1320 9.935388e-01            0 -2.120729e-01
      1321 9.470521e-01            0 -7.505786e+00
      1322 5.436513e-01            0  8.181985e+01
      1323 9.935388e-01            0 -2.120729e-01
      1324 9.470521e-01            0 -7.505786e+00
      1325 5.436513e-01            0  8.181985e+01
      1326 9.935388e-01            0 -2.120729e-01
      1327 9.470521e-01            0 -7.505786e+00
      1328 5.436513e-01            0  8.181985e+01
      1329 9.935388e-01            0 -2.120729e-01
      1330 9.470521e-01            0 -7.505786e+00
      1331 5.436513e-01            0  8.181985e+01
      1332 9.935388e-01            0 -2.120729e-01
      1333 9.470521e-01            0 -7.505786e+00
      1334 5.436513e-01            0  8.181985e+01
      1335 9.935388e-01            0 -2.120729e-01
      1336 1.166049e-01            0 -1.032272e+02
      1337 3.452383e-01            0 -1.318757e+02
      1338 4.186105e-02            1 -1.489088e+02
      1339 1.166049e-01            0 -1.032272e+02
      1340 3.452383e-01            0 -1.318757e+02
      1341 4.186105e-02            1 -1.489088e+02
      1342 1.166049e-01            0 -1.032272e+02
      1343 3.452383e-01            0 -1.318757e+02
      1344 4.186105e-02            1 -1.489088e+02
      1345 1.166049e-01            0 -1.032272e+02
      1346 3.452383e-01            0 -1.318757e+02
      1347 4.186105e-02            1 -1.489088e+02
      1348 1.166049e-01            0 -1.032272e+02
      1349 3.452383e-01            0 -1.318757e+02
      1350 4.186105e-02            1 -1.489088e+02
      1351 1.166049e-01            0 -1.032272e+02
      1352 3.452383e-01            0 -1.318757e+02
      1353 4.186105e-02            1 -1.489088e+02
      1354 8.371166e-01            0  7.430226e+00
      1355 4.462684e-01            0  5.054768e+01
      1356 7.577490e-01            0  2.872574e+00
      1357 8.371166e-01            0  7.430226e+00
      1358 4.462684e-01            0  5.054768e+01
      1359 7.577490e-01            0  2.872574e+00
      1360 8.371166e-01            0  7.430226e+00
      1361 4.462684e-01            0  5.054768e+01
      1362 7.577490e-01            0  2.872574e+00
      1363 8.371166e-01            0  7.430226e+00
      1364 4.462684e-01            0  5.054768e+01
      1365 7.577490e-01            0  2.872574e+00
      1366 8.371166e-01            0  7.430226e+00
      1367 4.462684e-01            0  5.054768e+01
      1368 7.577490e-01            0  2.872574e+00
      1369 2.122956e-01            0  1.787321e+02
      1370 2.122956e-01            0  1.787321e+02
      1371 2.122956e-01            0  1.487773e+02
      1372 2.122956e-01            0  1.787321e+02
      1373 2.122956e-01            0  1.787321e+02
      1374 2.122956e-01            0  1.487773e+02
      1375 2.122956e-01            0  1.787321e+02
      1376 2.122956e-01            0  1.787321e+02
      1377 2.122956e-01            0  1.487773e+02
      1378 1.000000e+00            0  9.444444e-01
      1379 1.000000e+00            0  9.982762e-01
      1380 1.000000e+00            0  9.885057e-01
      1381 1.000000e+00            0  9.444444e-01
      1382 1.000000e+00            0  9.982762e-01
      1383 1.000000e+00            0  9.885057e-01
      1384 1.000000e+00            0  9.444444e-01
      1385 1.000000e+00            0  9.982762e-01
      1386 1.000000e+00            0  9.885057e-01
      1387 7.967394e-01            0 -3.131679e+01
      1388 7.772329e-01            0 -3.186836e+01
      1389 4.620608e-01            0 -6.279978e+01
      1390 7.967394e-01            0 -3.131679e+01
      1391 7.772329e-01            0 -3.186836e+01
      1392 4.620608e-01            0 -6.279978e+01
      1393 7.967394e-01            0 -3.131679e+01
      1394 7.772329e-01            0 -3.186836e+01
      1395 4.620608e-01            0 -6.279978e+01
      1396 7.967394e-01            0 -3.131679e+01
      1397 7.772329e-01            0 -3.186836e+01
      1398 4.620608e-01            0 -6.279978e+01
      1399 7.967394e-01            0 -3.131679e+01
      1400 7.772329e-01            0 -3.186836e+01
      1401 4.620608e-01            0 -6.279978e+01
      1402 7.967394e-01            0 -3.131679e+01
      1403 7.772329e-01            0 -3.186836e+01
      1404 4.620608e-01            0 -6.279978e+01
      1405 7.967394e-01            0 -3.131679e+01
      1406 7.772329e-01            0 -3.186836e+01
      1407 4.620608e-01            0 -6.279978e+01
      1408 9.366276e-01            0 -1.115663e+01
      1409 9.366276e-01            0 -2.321237e+01
      1410 9.366276e-01            0 -6.677869e+00
      1411 9.366276e-01            0 -1.115663e+01
      1412 9.366276e-01            0 -2.321237e+01
      1413 9.366276e-01            0 -6.677869e+00
      1414 9.366276e-01            0 -1.115663e+01
      1415 9.366276e-01            0 -2.321237e+01
      1416 9.366276e-01            0 -6.677869e+00
      1417 9.366276e-01            0 -1.115663e+01
      1418 9.366276e-01            0 -2.321237e+01
      1419 9.366276e-01            0 -6.677869e+00
      1420 7.418011e-01            0 -4.362222e+01
      1421 7.418011e-01            0 -4.508653e+01
      1422 7.418011e-01            0 -3.377056e+01
      1423 7.418011e-01            0 -4.362222e+01
      1424 7.418011e-01            0 -4.508653e+01
      1425 7.418011e-01            0 -3.377056e+01
      1426 7.418011e-01            0 -4.362222e+01
      1427 7.418011e-01            0 -4.508653e+01
      1428 7.418011e-01            0 -3.377056e+01
      1429 7.418011e-01            0 -4.362222e+01
      1430 7.418011e-01            0 -4.508653e+01
      1431 7.418011e-01            0 -3.377056e+01
      1432 8.990424e-02            0 -3.561625e+01
      1433 3.788816e-01            0 -2.564153e+01
      1434 9.434636e-02            0 -3.311866e+01
      1435 8.990424e-02            0 -3.561625e+01
      1436 3.788816e-01            0 -2.564153e+01
      1437 9.434636e-02            0 -3.311866e+01
      1438 8.990424e-02            0 -3.561625e+01
      1439 3.788816e-01            0 -2.564153e+01
      1440 9.434636e-02            0 -3.311866e+01
      1441 8.990424e-02            0 -3.561625e+01
      1442 3.788816e-01            0 -2.564153e+01
      1443 9.434636e-02            0 -3.311866e+01
      1444 8.990424e-02            0 -3.561625e+01
      1445 3.788816e-01            0 -2.564153e+01
      1446 9.434636e-02            0 -3.311866e+01
      1447 8.990424e-02            0 -3.561625e+01
      1448 3.788816e-01            0 -2.564153e+01
      1449 9.434636e-02            0 -3.311866e+01
      1450 8.990424e-02            0 -3.561625e+01
      1451 3.788816e-01            0 -2.564153e+01
      1452 9.434636e-02            0 -3.311866e+01
      1453 8.990424e-02            0 -3.561625e+01
      1454 3.788816e-01            0 -2.564153e+01
      1455 9.434636e-02            0 -3.311866e+01
      1456 8.990424e-02            0 -3.561625e+01
      1457 3.788816e-01            0 -2.564153e+01
      1458 9.434636e-02            0 -3.311866e+01
      1459 8.990424e-02            0 -3.561625e+01
      1460 3.788816e-01            0 -2.564153e+01
      1461 9.434636e-02            0 -3.311866e+01
      1462 7.145180e-01            0  6.085414e+01
      1463 7.285517e-01            0  3.781677e+01
      1464 6.676811e-01            0  3.318308e+01
      1465 7.145180e-01            0  6.085414e+01
      1466 7.285517e-01            0  3.781677e+01
      1467 6.676811e-01            0  3.318308e+01
      1468 7.145180e-01            0  6.085414e+01
      1469 7.285517e-01            0  3.781677e+01
      1470 6.676811e-01            0  3.318308e+01
      1471 4.785132e-02            1  6.666667e-01
      1472 6.188153e-01            0 -1.737383e+01
      1473 3.686561e-01            0 -2.435466e+01
      1474 4.785132e-02            1  6.666667e-01
      1475 6.188153e-01            0 -1.737383e+01
      1476 3.686561e-01            0 -2.435466e+01
      1477 4.785132e-02            1  6.666667e-01
      1478 6.188153e-01            0 -1.737383e+01
      1479 3.686561e-01            0 -2.435466e+01
      1480 8.550753e-01            0  1.261603e+01
      1481 8.193264e-01            0 -2.221106e+01
      1482 9.031482e-01            0 -1.500849e+00
      1483 8.550753e-01            0  1.261603e+01
      1484 8.193264e-01            0 -2.221106e+01
      1485 9.031482e-01            0 -1.500849e+00
      1486 8.550753e-01            0  1.261603e+01
      1487 8.193264e-01            0 -2.221106e+01
      1488 9.031482e-01            0 -1.500849e+00
      1489 8.550753e-01            0  1.261603e+01
      1490 8.193264e-01            0 -2.221106e+01
      1491 9.031482e-01            0 -1.500849e+00
      1492 8.550753e-01            0  1.261603e+01
      1493 8.193264e-01            0 -2.221106e+01
      1494 9.031482e-01            0 -1.500849e+00
      1495 4.227290e-02            1  5.054376e+01
      1496 2.464556e-01            0  7.630545e+01
      1497 9.168518e-02            0  4.031908e+01
      1498 4.227290e-02            1  5.054376e+01
      1499 2.464556e-01            0  7.630545e+01
      1500 9.168518e-02            0  4.031908e+01
      1501 4.227290e-02            1  5.054376e+01
      1502 2.464556e-01            0  7.630545e+01
      1503 9.168518e-02            0  4.031908e+01
      1504 4.227290e-02            1  5.054376e+01
      1505 2.464556e-01            0  7.630545e+01
      1506 9.168518e-02            0  4.031908e+01
      1507 4.227290e-02            1  5.054376e+01
      1508 2.464556e-01            0  7.630545e+01
      1509 9.168518e-02            0  4.031908e+01
      1510 7.723926e-01            0  3.059109e+01
      1511 7.723926e-01            0  1.010495e+01
      1512 7.723926e-01            0  1.579555e+01
      1513 7.723926e-01            0  3.059109e+01
      1514 7.723926e-01            0  1.010495e+01
      1515 7.723926e-01            0  1.579555e+01
      1516 7.723926e-01            0  3.059109e+01
      1517 7.723926e-01            0  1.010495e+01
      1518 7.723926e-01            0  1.579555e+01
      1519 6.055959e-01            0  6.491896e+01
      1520 6.055959e-01            0  6.491896e+01
      1521 6.055959e-01            0  6.491896e+01
      1522 6.055959e-01            0  6.491896e+01
      1523 6.055959e-01            0  6.491896e+01
      1524 6.055959e-01            0  6.491896e+01
      1525 6.055959e-01            0  6.491896e+01
      1526 6.055959e-01            0  6.491896e+01
      1527 6.055959e-01            0  6.491896e+01
      1528 8.536211e-01            0 -8.490512e+00
      1529 6.399606e-01            0  3.106752e+01
      1530 9.289796e-01            0  3.407378e+00
      1531 8.536211e-01            0 -8.490512e+00
      1532 6.399606e-01            0  3.106752e+01
      1533 9.289796e-01            0  3.407378e+00
      1534 8.536211e-01            0 -8.490512e+00
      1535 6.399606e-01            0  3.106752e+01
      1536 9.289796e-01            0  3.407378e+00
      1537 8.536211e-01            0 -8.490512e+00
      1538 6.399606e-01            0  3.106752e+01
      1539 9.289796e-01            0  3.407378e+00
      1540 8.536211e-01            0 -8.490512e+00
      1541 6.399606e-01            0  3.106752e+01
      1542 9.289796e-01            0  3.407378e+00
      1543 8.536211e-01            0 -8.490512e+00
      1544 6.399606e-01            0  3.106752e+01
      1545 9.289796e-01            0  3.407378e+00
      1546 7.598349e-01            0 -2.092754e+01
      1547 7.598349e-01            0 -2.092754e+01
      1548 7.598349e-01            0 -2.092754e+01
      1549 7.598349e-01            0 -2.092754e+01
      1550 7.598349e-01            0 -2.092754e+01
      1551 7.598349e-01            0 -2.092754e+01
      1552 7.598349e-01            0 -2.092754e+01
      1553 7.598349e-01            0 -2.092754e+01
      1554 7.598349e-01            0 -2.092754e+01
      1555 7.598349e-01            0 -2.092754e+01
      1556 7.598349e-01            0 -2.092754e+01
      1557 7.598349e-01            0 -2.092754e+01
      1558 7.598349e-01            0 -2.092754e+01
      1559 7.598349e-01            0 -2.092754e+01
      1560 7.598349e-01            0 -2.092754e+01
      1561 7.598349e-01            0 -2.092754e+01
      1562 7.598349e-01            0 -2.092754e+01
      1563 7.598349e-01            0 -2.092754e+01
      1564 3.901235e-02            1  2.142377e+02
      1565 3.901235e-02            1  2.142377e+02
      1566 3.901235e-02            1  4.080437e+01
      1567 3.901235e-02            1  2.142377e+02
      1568 3.901235e-02            1  2.142377e+02
      1569 3.901235e-02            1  4.080437e+01
      1570 3.901235e-02            1  2.142377e+02
      1571 3.901235e-02            1  2.142377e+02
      1572 3.901235e-02            1  4.080437e+01
      1573 3.901235e-02            1  2.142377e+02
      1574 3.901235e-02            1  2.142377e+02
      1575 3.901235e-02            1  4.080437e+01
      1576          NaN           NA  1.000000e+00
      1577          NaN           NA  1.000000e+00
      1578          NaN           NA  1.000000e+00
      1579          NaN           NA  1.000000e+00
      1580          NaN           NA  1.000000e+00
      1581          NaN           NA  1.000000e+00
      1582          NaN           NA  1.000000e+00
      1583          NaN           NA  1.000000e+00
      1584          NaN           NA  1.000000e+00
      1585          NaN           NA  1.000000e+00
      1586          NaN           NA  1.000000e+00
      1587          NaN           NA  1.000000e+00
      1588 6.172786e-01            0 -2.636973e+01
      1589 3.163929e-01            0 -9.878790e+01
      1590 9.917517e-01            0  1.278107e+00
      1591 6.172786e-01            0 -2.636973e+01
      1592 3.163929e-01            0 -9.878790e+01
      1593 9.917517e-01            0  1.278107e+00
      1594 6.172786e-01            0 -2.636973e+01
      1595 3.163929e-01            0 -9.878790e+01
      1596 9.917517e-01            0  1.278107e+00
      1597 6.172786e-01            0 -2.636973e+01
      1598 3.163929e-01            0 -9.878790e+01
      1599 9.917517e-01            0  1.278107e+00
      1600 6.172786e-01            0 -2.636973e+01
      1601 3.163929e-01            0 -9.878790e+01
      1602 9.917517e-01            0  1.278107e+00
      1603 6.172786e-01            0 -2.636973e+01
      1604 3.163929e-01            0 -9.878790e+01
      1605 9.917517e-01            0  1.278107e+00
      1606 6.172786e-01            0 -2.636973e+01
      1607 3.163929e-01            0 -9.878790e+01
      1608 9.917517e-01            0  1.278107e+00
      1609 2.927072e-01            0 -5.412136e+01
      1610 2.927072e-01            0 -7.597983e+01
      1611 2.927072e-01            0 -6.514563e+01
      1612 2.927072e-01            0 -5.412136e+01
      1613 2.927072e-01            0 -7.597983e+01
      1614 2.927072e-01            0 -6.514563e+01
      1615 2.927072e-01            0 -5.412136e+01
      1616 2.927072e-01            0 -7.597983e+01
      1617 2.927072e-01            0 -6.514563e+01
      1618 2.927072e-01            0 -5.412136e+01
      1619 2.927072e-01            0 -7.597983e+01
      1620 2.927072e-01            0 -6.514563e+01
      1621 2.927072e-01            0 -5.412136e+01
      1622 2.927072e-01            0 -7.597983e+01
      1623 2.927072e-01            0 -6.514563e+01
      1624 4.962773e-01            0  3.301358e+01
      1625 7.550466e-01            0  2.044821e+01
      1626 7.258333e-01            0  1.173620e+01
      1627 4.962773e-01            0  3.301358e+01
      1628 7.550466e-01            0  2.044821e+01
      1629 7.258333e-01            0  1.173620e+01
      1630 4.962773e-01            0  3.301358e+01
      1631 7.550466e-01            0  2.044821e+01
      1632 7.258333e-01            0  1.173620e+01
      1633 4.962773e-01            0  3.301358e+01
      1634 7.550466e-01            0  2.044821e+01
      1635 7.258333e-01            0  1.173620e+01
      1636 4.962773e-01            0  3.301358e+01
      1637 7.550466e-01            0  2.044821e+01
      1638 7.258333e-01            0  1.173620e+01
      1639 4.962773e-01            0  3.301358e+01
      1640 7.550466e-01            0  2.044821e+01
      1641 7.258333e-01            0  1.173620e+01
      1642 4.962773e-01            0  3.301358e+01
      1643 7.550466e-01            0  2.044821e+01
      1644 7.258333e-01            0  1.173620e+01
      1645 7.074500e-01            0 -3.188798e+01
      1646 7.074500e-01            0 -6.418338e+01
      1647 7.074500e-01            0 -5.439028e+01
      1648 7.074500e-01            0 -3.188798e+01
      1649 7.074500e-01            0 -6.418338e+01
      1650 7.074500e-01            0 -5.439028e+01
      1651 7.074500e-01            0 -3.188798e+01
      1652 7.074500e-01            0 -6.418338e+01
      1653 7.074500e-01            0 -5.439028e+01
      1654 5.694377e-01            0 -1.671329e+01
      1655 5.694377e-01            0 -6.819253e+01
      1656 4.420977e-01            0 -5.179712e+01
      1657 5.694377e-01            0 -1.671329e+01
      1658 5.694377e-01            0 -6.819253e+01
      1659 4.420977e-01            0 -5.179712e+01
      1660 5.694377e-01            0 -1.671329e+01
      1661 5.694377e-01            0 -6.819253e+01
      1662 4.420977e-01            0 -5.179712e+01
      1663 5.694377e-01            0 -1.671329e+01
      1664 5.694377e-01            0 -6.819253e+01
      1665 4.420977e-01            0 -5.179712e+01
      1666 5.694377e-01            0 -1.671329e+01
      1667 5.694377e-01            0 -6.819253e+01
      1668 4.420977e-01            0 -5.179712e+01
      1669 5.694377e-01            0 -1.671329e+01
      1670 5.694377e-01            0 -6.819253e+01
      1671 4.420977e-01            0 -5.179712e+01
      1672 7.046442e-01            0 -6.083175e+01
      1673 7.046442e-01            0 -6.083175e+01
      1674 7.046442e-01            0 -5.396156e+01
      1675 7.046442e-01            0 -6.083175e+01
      1676 7.046442e-01            0 -6.083175e+01
      1677 7.046442e-01            0 -5.396156e+01
      1678 7.046442e-01            0 -6.083175e+01
      1679 7.046442e-01            0 -6.083175e+01
      1680 7.046442e-01            0 -5.396156e+01
      1681 9.620224e-01            0 -1.871643e+00
      1682 8.346166e-02            0  3.592713e+00
      1683 7.856076e-01            0 -1.003242e+01
      1684 9.620224e-01            0 -1.871643e+00
      1685 8.346166e-02            0  3.592713e+00
      1686 7.856076e-01            0 -1.003242e+01
      1687 9.620224e-01            0 -1.871643e+00
      1688 8.346166e-02            0  3.592713e+00
      1689 7.856076e-01            0 -1.003242e+01
      1690 7.533089e-01            0 -1.275507e+01
      1691 7.533089e-01            0 -2.633492e+01
      1692 6.648141e-01            0 -1.821464e+01
      1693 7.533089e-01            0 -1.275507e+01
      1694 7.533089e-01            0 -2.633492e+01
      1695 6.648141e-01            0 -1.821464e+01
      1696 7.533089e-01            0 -1.275507e+01
      1697 7.533089e-01            0 -2.633492e+01
      1698 6.648141e-01            0 -1.821464e+01
      1699 7.533089e-01            0 -1.275507e+01
      1700 7.533089e-01            0 -2.633492e+01
      1701 6.648141e-01            0 -1.821464e+01
      1702 6.090871e-01            0 -2.862415e+01
      1703 1.831525e-02            1 -1.527558e+02
      1704 3.017383e-03            1 -1.096937e+02
      1705 6.090871e-01            0 -2.862415e+01
      1706 1.831525e-02            1 -1.527558e+02
      1707 3.017383e-03            1 -1.096937e+02
      1708 6.090871e-01            0 -2.862415e+01
      1709 1.831525e-02            1 -1.527558e+02
      1710 3.017383e-03            1 -1.096937e+02
      1711 6.090871e-01            0 -2.862415e+01
      1712 1.831525e-02            1 -1.527558e+02
      1713 3.017383e-03            1 -1.096937e+02
      1714 6.090871e-01            0 -2.862415e+01
      1715 1.831525e-02            1 -1.527558e+02
      1716 3.017383e-03            1 -1.096937e+02
      1717 1.000000e+00            0  1.000000e+00
      1718 1.000000e+00            0  1.000000e+00
      1719 1.000000e+00            0  1.000000e+00
      1720 1.000000e+00            0  1.000000e+00
      1721 1.000000e+00            0  1.000000e+00
      1722 1.000000e+00            0  1.000000e+00
      1723 1.000000e+00            0  1.000000e+00
      1724 1.000000e+00            0  1.000000e+00
      1725 1.000000e+00            0  1.000000e+00
      1726 3.569220e-01            0  1.571214e+01
      1727 3.569220e-01            0  2.993805e+01
      1728 3.569220e-01            0  1.320563e+01
      1729 3.569220e-01            0  1.571214e+01
      1730 3.569220e-01            0  2.993805e+01
      1731 3.569220e-01            0  1.320563e+01
      1732 3.569220e-01            0  1.571214e+01
      1733 3.569220e-01            0  2.993805e+01
      1734 3.569220e-01            0  1.320563e+01
      1735 3.569220e-01            0  1.571214e+01
      1736 3.569220e-01            0  2.993805e+01
      1737 3.569220e-01            0  1.320563e+01
      1738 3.569220e-01            0  1.571214e+01
      1739 3.569220e-01            0  2.993805e+01
      1740 3.569220e-01            0  1.320563e+01
      1741 3.569220e-01            0  1.571214e+01
      1742 3.569220e-01            0  2.993805e+01
      1743 3.569220e-01            0  1.320563e+01
      1744 3.569220e-01            0  1.571214e+01
      1745 3.569220e-01            0  2.993805e+01
      1746 3.569220e-01            0  1.320563e+01
      1747 3.569220e-01            0  1.571214e+01
      1748 3.569220e-01            0  2.993805e+01
      1749 3.569220e-01            0  1.320563e+01
      1750 3.569220e-01            0  1.571214e+01
      1751 3.569220e-01            0  2.993805e+01
      1752 3.569220e-01            0  1.320563e+01
      1753 6.326729e-01            0 -9.807481e+00
      1754 2.818609e-01            0 -3.363264e+01
      1755 1.499912e-01            0 -2.730635e+01
      1756 6.326729e-01            0 -9.807481e+00
      1757 2.818609e-01            0 -3.363264e+01
      1758 1.499912e-01            0 -2.730635e+01
      1759 6.326729e-01            0 -9.807481e+00
      1760 2.818609e-01            0 -3.363264e+01
      1761 1.499912e-01            0 -2.730635e+01
      1762 6.326729e-01            0 -9.807481e+00
      1763 2.818609e-01            0 -3.363264e+01
      1764 1.499912e-01            0 -2.730635e+01
      1765 6.326729e-01            0 -9.807481e+00
      1766 2.818609e-01            0 -3.363264e+01
      1767 1.499912e-01            0 -2.730635e+01
      1768 6.326729e-01            0 -9.807481e+00
      1769 2.818609e-01            0 -3.363264e+01
      1770 1.499912e-01            0 -2.730635e+01
      1771 6.326729e-01            0 -9.807481e+00
      1772 2.818609e-01            0 -3.363264e+01
      1773 1.499912e-01            0 -2.730635e+01
      1774 6.326729e-01            0 -9.807481e+00
      1775 2.818609e-01            0 -3.363264e+01
      1776 1.499912e-01            0 -2.730635e+01
      1777 6.326729e-01            0 -9.807481e+00
      1778 2.818609e-01            0 -3.363264e+01
      1779 1.499912e-01            0 -2.730635e+01
      1780 6.326729e-01            0 -9.807481e+00
      1781 2.818609e-01            0 -3.363264e+01
      1782 1.499912e-01            0 -2.730635e+01
      1783 6.326729e-01            0 -9.807481e+00
      1784 2.818609e-01            0 -3.363264e+01
      1785 1.499912e-01            0 -2.730635e+01
      1786 6.326729e-01            0 -9.807481e+00
      1787 2.818609e-01            0 -3.363264e+01
      1788 1.499912e-01            0 -2.730635e+01
      1789 3.504545e-01            0  4.242903e+01
      1790 3.504545e-01            0  2.737357e+00
      1791 3.876781e-01            0 -5.685481e+01
      1792 3.504545e-01            0  4.242903e+01
      1793 3.504545e-01            0  2.737357e+00
      1794 3.876781e-01            0 -5.685481e+01
      1795 3.504545e-01            0  4.242903e+01
      1796 3.504545e-01            0  2.737357e+00
      1797 3.876781e-01            0 -5.685481e+01
      1798 3.504545e-01            0  4.242903e+01
      1799 3.504545e-01            0  2.737357e+00
      1800 3.876781e-01            0 -5.685481e+01
      1801 3.504545e-01            0  4.242903e+01
      1802 3.504545e-01            0  2.737357e+00
      1803 3.876781e-01            0 -5.685481e+01
      1804 3.504545e-01            0  4.242903e+01
      1805 3.504545e-01            0  2.737357e+00
      1806 3.876781e-01            0 -5.685481e+01
      1807 9.566770e-01            0  3.341312e+00
      1808 7.547071e-01            0  3.039856e+01
      1809 4.145060e-01            0  3.298860e+01
      1810 9.566770e-01            0  3.341312e+00
      1811 7.547071e-01            0  3.039856e+01
      1812 4.145060e-01            0  3.298860e+01
      1813 9.566770e-01            0  3.341312e+00
      1814 7.547071e-01            0  3.039856e+01
      1815 4.145060e-01            0  3.298860e+01
      1816 9.566770e-01            0  3.341312e+00
      1817 7.547071e-01            0  3.039856e+01
      1818 4.145060e-01            0  3.298860e+01
      1819 9.566770e-01            0  3.341312e+00
      1820 7.547071e-01            0  3.039856e+01
      1821 4.145060e-01            0  3.298860e+01
      1822 5.876070e-01            0 -1.015204e+02
      1823 5.876070e-01            0 -1.015204e+02
      1824 5.876070e-01            0 -1.015204e+02
      1825 5.876070e-01            0 -1.015204e+02
      1826 5.876070e-01            0 -1.015204e+02
      1827 5.876070e-01            0 -1.015204e+02
      1828 5.876070e-01            0 -1.015204e+02
      1829 5.876070e-01            0 -1.015204e+02
      1830 5.876070e-01            0 -1.015204e+02
      1831 5.876070e-01            0 -1.015204e+02
      1832 5.876070e-01            0 -1.015204e+02
      1833 5.876070e-01            0 -1.015204e+02
      1834 3.987236e-01            0 -6.782464e+01
      1835 5.487857e-01            0  4.690016e+01
      1836 2.982617e-01            0  2.830535e+01
      1837 3.987236e-01            0 -6.782464e+01
      1838 5.487857e-01            0  4.690016e+01
      1839 2.982617e-01            0  2.830535e+01
      1840 3.987236e-01            0 -6.782464e+01
      1841 5.487857e-01            0  4.690016e+01
      1842 2.982617e-01            0  2.830535e+01
      1843 3.987236e-01            0 -6.782464e+01
      1844 5.487857e-01            0  4.690016e+01
      1845 2.982617e-01            0  2.830535e+01
      1846 3.987236e-01            0 -6.782464e+01
      1847 5.487857e-01            0  4.690016e+01
      1848 2.982617e-01            0  2.830535e+01
      1849 3.987236e-01            0 -6.782464e+01
      1850 5.487857e-01            0  4.690016e+01
      1851 2.982617e-01            0  2.830535e+01
      1852 5.823435e-01            0  4.741279e+01
      1853 5.823435e-01            0  6.697171e+01
      1854 5.823435e-01            0  6.652394e+01
      1855 5.823435e-01            0  4.741279e+01
      1856 5.823435e-01            0  6.697171e+01
      1857 5.823435e-01            0  6.652394e+01
      1858 5.823435e-01            0  4.741279e+01
      1859 5.823435e-01            0  6.697171e+01
      1860 5.823435e-01            0  6.652394e+01
      1861 8.789623e-01            0 -7.064286e+01
      1862 8.789623e-01            0 -5.500141e+00
      1863 8.789623e-01            0 -1.094048e+01
      1864 8.789623e-01            0 -7.064286e+01
      1865 8.789623e-01            0 -5.500141e+00
      1866 8.789623e-01            0 -1.094048e+01
      1867 8.789623e-01            0 -7.064286e+01
      1868 8.789623e-01            0 -5.500141e+00
      1869 8.789623e-01            0 -1.094048e+01
      1870 5.011694e-01            0  1.000000e+00
      1871 5.011694e-01            0  1.000000e+00
      1872 5.011694e-01            0  1.000000e+00
      1873 5.011694e-01            0  1.000000e+00
      1874 5.011694e-01            0  1.000000e+00
      1875 5.011694e-01            0  1.000000e+00
      1876 5.011694e-01            0  1.000000e+00
      1877 5.011694e-01            0  1.000000e+00
      1878 5.011694e-01            0  1.000000e+00
      1879 5.011694e-01            0  1.000000e+00
      1880 5.011694e-01            0  1.000000e+00
      1881 5.011694e-01            0  1.000000e+00
      1882 5.011694e-01            0  1.000000e+00
      1883 5.011694e-01            0  1.000000e+00
      1884 5.011694e-01            0  1.000000e+00
      1885 5.011694e-01            0  1.000000e+00
      1886 5.011694e-01            0  1.000000e+00
      1887 5.011694e-01            0  1.000000e+00
      1888 7.723926e-01            0  4.525304e+01
      1889 7.723926e-01            0  4.525304e+01
      1890 7.723926e-01            0  3.050202e+01
      1891 7.723926e-01            0  4.525304e+01
      1892 7.723926e-01            0  4.525304e+01
      1893 7.723926e-01            0  3.050202e+01
      1894 7.723926e-01            0  4.525304e+01
      1895 7.723926e-01            0  4.525304e+01
      1896 7.723926e-01            0  3.050202e+01
      1897 8.351057e-01            0  2.009591e+01
      1898 1.112136e-01            0 -5.921034e+01
      1899 6.560935e-02            0 -3.056302e+01
      1900 8.351057e-01            0  2.009591e+01
      1901 1.112136e-01            0 -5.921034e+01
      1902 6.560935e-02            0 -3.056302e+01
      1903 8.351057e-01            0  2.009591e+01
      1904 1.112136e-01            0 -5.921034e+01
      1905 6.560935e-02            0 -3.056302e+01
      1906 3.298009e-01            0 -2.191539e+01
      1907 8.470315e-01            0 -1.376519e+01
      1908 1.711937e-01            0 -1.807640e+01
      1909 3.298009e-01            0 -2.191539e+01
      1910 8.470315e-01            0 -1.376519e+01
      1911 1.711937e-01            0 -1.807640e+01
      1912 3.298009e-01            0 -2.191539e+01
      1913 8.470315e-01            0 -1.376519e+01
      1914 1.711937e-01            0 -1.807640e+01
      1915 3.298009e-01            0 -2.191539e+01
      1916 8.470315e-01            0 -1.376519e+01
      1917 1.711937e-01            0 -1.807640e+01
      1918 5.574822e-01            0  1.000000e+00
      1919 5.574822e-01            0  1.000000e+00
      1920 5.574822e-01            0  1.000000e+00
      1921 5.574822e-01            0  1.000000e+00
      1922 5.574822e-01            0  1.000000e+00
      1923 5.574822e-01            0  1.000000e+00
      1924 5.574822e-01            0  1.000000e+00
      1925 5.574822e-01            0  1.000000e+00
      1926 5.574822e-01            0  1.000000e+00
      1927 5.574822e-01            0  1.000000e+00
      1928 5.574822e-01            0  1.000000e+00
      1929 5.574822e-01            0  1.000000e+00
      1930 5.574822e-01            0  1.000000e+00
      1931 5.574822e-01            0  1.000000e+00
      1932 5.574822e-01            0  1.000000e+00
      1933 9.125790e-02            0  5.531066e+01
      1934 9.125790e-02            0  1.010868e+02
      1935 9.125790e-02            0  8.405999e+00
      1936 9.125790e-02            0  5.531066e+01
      1937 9.125790e-02            0  1.010868e+02
      1938 9.125790e-02            0  8.405999e+00
      1939 9.125790e-02            0  5.531066e+01
      1940 9.125790e-02            0  1.010868e+02
      1941 9.125790e-02            0  8.405999e+00
      1942 5.456289e-01            0 -2.863333e+02
      1943 5.456289e-01            0 -2.863333e+02
      1944 5.456289e-01            0 -2.863333e+02
      1945 5.456289e-01            0 -2.863333e+02
      1946 5.456289e-01            0 -2.863333e+02
      1947 5.456289e-01            0 -2.863333e+02
      1948 5.456289e-01            0 -2.863333e+02
      1949 5.456289e-01            0 -2.863333e+02
      1950 5.456289e-01            0 -2.863333e+02
      1951 2.276996e-01            0  2.630506e+01
      1952 9.315235e-01            0 -4.005186e+00
      1953 7.256475e-01            0 -6.119842e+00
      1954 2.276996e-01            0  2.630506e+01
      1955 9.315235e-01            0 -4.005186e+00
      1956 7.256475e-01            0 -6.119842e+00
      1957 2.276996e-01            0  2.630506e+01
      1958 9.315235e-01            0 -4.005186e+00
      1959 7.256475e-01            0 -6.119842e+00
      1960 2.276996e-01            0  2.630506e+01
      1961 9.315235e-01            0 -4.005186e+00
      1962 7.256475e-01            0 -6.119842e+00
      1963 2.276996e-01            0  2.630506e+01
      1964 9.315235e-01            0 -4.005186e+00
      1965 7.256475e-01            0 -6.119842e+00
      1966 2.276996e-01            0  2.630506e+01
      1967 9.315235e-01            0 -4.005186e+00
      1968 7.256475e-01            0 -6.119842e+00
      1969 2.276996e-01            0  2.630506e+01
      1970 9.315235e-01            0 -4.005186e+00
      1971 7.256475e-01            0 -6.119842e+00
      1972 2.276996e-01            0  2.630506e+01
      1973 9.315235e-01            0 -4.005186e+00
      1974 7.256475e-01            0 -6.119842e+00
      1975 6.055959e-01            0 -1.220306e+01
      1976 1.338971e-01            0 -4.965358e+01
      1977 1.555691e-01            0 -3.656208e+01
      1978 6.055959e-01            0 -1.220306e+01
      1979 1.338971e-01            0 -4.965358e+01
      1980 1.555691e-01            0 -3.656208e+01
      1981 6.055959e-01            0 -1.220306e+01
      1982 1.338971e-01            0 -4.965358e+01
      1983 1.555691e-01            0 -3.656208e+01
      1984 3.360863e-01            0 -3.004070e+01
      1985 8.858772e-01            0 -1.011077e+01
      1986 3.360863e-01            0 -3.004070e+01
      1987 3.360863e-01            0 -3.004070e+01
      1988 8.858772e-01            0 -1.011077e+01
      1989 3.360863e-01            0 -3.004070e+01
      1990 3.360863e-01            0 -3.004070e+01
      1991 8.858772e-01            0 -1.011077e+01
      1992 3.360863e-01            0 -3.004070e+01
      1993 3.360863e-01            0 -3.004070e+01
      1994 8.858772e-01            0 -1.011077e+01
      1995 3.360863e-01            0 -3.004070e+01
      1996 2.936115e-01            0  3.268333e+01
      1997 9.546698e-02            0  8.435634e+01
      1998 9.686616e-02            0  3.447343e+01
      1999 2.936115e-01            0  3.268333e+01
      2000 9.546698e-02            0  8.435634e+01
      2001 9.686616e-02            0  3.447343e+01
      2002 2.936115e-01            0  3.268333e+01
      2003 9.546698e-02            0  8.435634e+01
      2004 9.686616e-02            0  3.447343e+01
      2005 2.936115e-01            0  3.268333e+01
      2006 9.546698e-02            0  8.435634e+01
      2007 9.686616e-02            0  3.447343e+01
      2008 2.936115e-01            0  3.268333e+01
      2009 9.546698e-02            0  8.435634e+01
      2010 9.686616e-02            0  3.447343e+01
      2011 2.936115e-01            0  3.268333e+01
      2012 9.546698e-02            0  8.435634e+01
      2013 9.686616e-02            0  3.447343e+01
      2014 6.783662e-01            0  3.531034e+01
      2015 6.286093e-01            0  9.282759e+01
      2016 5.602455e-01            0  6.674566e+01
      2017 6.783662e-01            0  3.531034e+01
      2018 6.286093e-01            0  9.282759e+01
      2019 5.602455e-01            0  6.674566e+01
      2020 6.783662e-01            0  3.531034e+01
      2021 6.286093e-01            0  9.282759e+01
      2022 5.602455e-01            0  6.674566e+01
      2023 6.783662e-01            0  3.531034e+01
      2024 6.286093e-01            0  9.282759e+01
      2025 5.602455e-01            0  6.674566e+01
      2026 4.883606e-01            0  3.164873e+01
      2027 4.883606e-01            0  3.616997e+01
      2028 8.821401e-03            1 -3.806615e+01
      2029 4.883606e-01            0  3.164873e+01
      2030 4.883606e-01            0  3.616997e+01
      2031 8.821401e-03            1 -3.806615e+01
      2032 4.883606e-01            0  3.164873e+01
      2033 4.883606e-01            0  3.616997e+01
      2034 8.821401e-03            1 -3.806615e+01
      2035 4.883606e-01            0  3.164873e+01
      2036 4.883606e-01            0  3.616997e+01
      2037 8.821401e-03            1 -3.806615e+01
      2038 4.883606e-01            0  3.164873e+01
      2039 4.883606e-01            0  3.616997e+01
      2040 8.821401e-03            1 -3.806615e+01
      2041 4.543711e-01            0  2.865000e+02
      2042 4.543711e-01            0  3.816667e+02
      2043 4.543711e-01            0  2.294000e+02
      2044 4.543711e-01            0  2.865000e+02
      2045 4.543711e-01            0  3.816667e+02
      2046 4.543711e-01            0  2.294000e+02
      2047 4.543711e-01            0  2.865000e+02
      2048 4.543711e-01            0  3.816667e+02
      2049 4.543711e-01            0  2.294000e+02
      2050 9.139337e-01            0 -1.024444e+01
      2051 9.139337e-01            0 -1.399259e+01
      2052 9.139337e-01            0 -1.024444e+01
      2053 9.139337e-01            0 -1.024444e+01
      2054 9.139337e-01            0 -1.399259e+01
      2055 9.139337e-01            0 -1.024444e+01
      2056 9.139337e-01            0 -1.024444e+01
      2057 9.139337e-01            0 -1.399259e+01
      2058 9.139337e-01            0 -1.024444e+01
      2059 9.139337e-01            0 -1.024444e+01
      2060 9.139337e-01            0 -1.399259e+01
      2061 9.139337e-01            0 -1.024444e+01
      2062 4.963203e-01            0 -3.307934e+01
      2063 4.963203e-01            0 -3.307934e+01
      2064 4.963203e-01            0 -1.847391e+01
      2065 4.963203e-01            0 -3.307934e+01
      2066 4.963203e-01            0 -3.307934e+01
      2067 4.963203e-01            0 -1.847391e+01
      2068 4.963203e-01            0 -3.307934e+01
      2069 4.963203e-01            0 -3.307934e+01
      2070 4.963203e-01            0 -1.847391e+01
      2071 4.963203e-01            0 -3.307934e+01
      2072 4.963203e-01            0 -3.307934e+01
      2073 4.963203e-01            0 -1.847391e+01
      2074 4.963203e-01            0 -3.307934e+01
      2075 4.963203e-01            0 -3.307934e+01
      2076 4.963203e-01            0 -1.847391e+01
      2077 2.977982e-02            1  3.681293e+01
      2078 6.913652e-01            0  5.074675e+01
      2079 6.849153e-01            0  4.273338e+01
      2080 2.977982e-02            1  3.681293e+01
      2081 6.913652e-01            0  5.074675e+01
      2082 6.849153e-01            0  4.273338e+01
      2083 2.977982e-02            1  3.681293e+01
      2084 6.913652e-01            0  5.074675e+01
      2085 6.849153e-01            0  4.273338e+01
      2086 6.666667e-01            0  8.437500e+01
      2087 2.512152e-01            0 -2.328957e+02
      2088 3.116773e-01            0 -2.742697e+02
      2089 6.666667e-01            0  8.437500e+01
      2090 2.512152e-01            0 -2.328957e+02
      2091 3.116773e-01            0 -2.742697e+02
      2092 6.666667e-01            0  8.437500e+01
      2093 2.512152e-01            0 -2.328957e+02
      2094 3.116773e-01            0 -2.742697e+02
      2095 1.339746e-01            0  1.685000e+02
      2096 1.339746e-01            0  1.685000e+02
      2097 1.339746e-01            0  4.507895e+01
      2098 1.339746e-01            0  1.685000e+02
      2099 1.339746e-01            0  1.685000e+02
      2100 1.339746e-01            0  4.507895e+01
      2101 1.339746e-01            0  1.685000e+02
      2102 1.339746e-01            0  1.685000e+02
      2103 1.339746e-01            0  4.507895e+01
      2104 1.339746e-01            0  1.685000e+02
      2105 1.339746e-01            0  1.685000e+02
      2106 1.339746e-01            0  4.507895e+01
      2107 1.339746e-01            0  1.685000e+02
      2108 1.339746e-01            0  1.685000e+02
      2109 1.339746e-01            0  4.507895e+01
      2110 1.339746e-01            0  1.685000e+02
      2111 1.339746e-01            0  1.685000e+02
      2112 1.339746e-01            0  4.507895e+01
      2113 1.339746e-01            0  1.685000e+02
      2114 1.339746e-01            0  1.685000e+02
      2115 1.339746e-01            0  4.507895e+01
      2116 1.339746e-01            0  1.685000e+02
      2117 1.339746e-01            0  1.685000e+02
      2118 1.339746e-01            0  4.507895e+01
      2119 4.697304e-01            0 -8.837167e+01
      2120 6.130112e-01            0 -6.760131e+01
      2121 5.353615e-01            0 -7.011855e+01
      2122 4.697304e-01            0 -8.837167e+01
      2123 6.130112e-01            0 -6.760131e+01
      2124 5.353615e-01            0 -7.011855e+01
      2125 4.697304e-01            0 -8.837167e+01
      2126 6.130112e-01            0 -6.760131e+01
      2127 5.353615e-01            0 -7.011855e+01
      2128 4.697304e-01            0 -8.837167e+01
      2129 6.130112e-01            0 -6.760131e+01
      2130 5.353615e-01            0 -7.011855e+01
      2131 4.697304e-01            0 -8.837167e+01
      2132 6.130112e-01            0 -6.760131e+01
      2133 5.353615e-01            0 -7.011855e+01
      2134 4.697304e-01            0 -8.837167e+01
      2135 6.130112e-01            0 -6.760131e+01
      2136 5.353615e-01            0 -7.011855e+01
      2137 1.309041e-01            0 -1.976031e+01
      2138 1.514210e-01            0 -8.017161e+00
      2139 3.224118e-03            1 -1.073813e+01
      2140 1.309041e-01            0 -1.976031e+01
      2141 1.514210e-01            0 -8.017161e+00
      2142 3.224118e-03            1 -1.073813e+01
      2143 1.309041e-01            0 -1.976031e+01
      2144 1.514210e-01            0 -8.017161e+00
      2145 3.224118e-03            1 -1.073813e+01
      2146 9.966578e-01            0  1.012333e+00
      2147 3.770795e-01            0  1.499963e+01
      2148 3.947298e-01            0  1.066810e+01
      2149 9.966578e-01            0  1.012333e+00
      2150 3.770795e-01            0  1.499963e+01
      2151 3.947298e-01            0  1.066810e+01
      2152 9.966578e-01            0  1.012333e+00
      2153 3.770795e-01            0  1.499963e+01
      2154 3.947298e-01            0  1.066810e+01
      2155 9.966578e-01            0  1.012333e+00
      2156 3.770795e-01            0  1.499963e+01
      2157 3.947298e-01            0  1.066810e+01
      2158 9.966578e-01            0  1.012333e+00
      2159 3.770795e-01            0  1.499963e+01
      2160 3.947298e-01            0  1.066810e+01
      2161 9.966578e-01            0  1.012333e+00
      2162 3.770795e-01            0  1.499963e+01
      2163 3.947298e-01            0  1.066810e+01
      2164 9.966578e-01            0  1.012333e+00
      2165 3.770795e-01            0  1.499963e+01
      2166 3.947298e-01            0  1.066810e+01
      2167 9.428999e-01            0  2.458440e+00
      2168 6.767495e-01            0  2.318910e+01
      2169 7.302800e-01            0  9.090540e+00
      2170 9.428999e-01            0  2.458440e+00
      2171 6.767495e-01            0  2.318910e+01
      2172 7.302800e-01            0  9.090540e+00
      2173 9.428999e-01            0  2.458440e+00
      2174 6.767495e-01            0  2.318910e+01
      2175 7.302800e-01            0  9.090540e+00
      2176 9.428999e-01            0  2.458440e+00
      2177 6.767495e-01            0  2.318910e+01
      2178 7.302800e-01            0  9.090540e+00
      2179 9.428999e-01            0  2.458440e+00
      2180 6.767495e-01            0  2.318910e+01
      2181 7.302800e-01            0  9.090540e+00
      2182 9.428999e-01            0  2.458440e+00
      2183 6.767495e-01            0  2.318910e+01
      2184 7.302800e-01            0  9.090540e+00
      2185 9.428999e-01            0  2.458440e+00
      2186 6.767495e-01            0  2.318910e+01
      2187 7.302800e-01            0  9.090540e+00
      2188 9.428999e-01            0  2.458440e+00
      2189 6.767495e-01            0  2.318910e+01
      2190 7.302800e-01            0  9.090540e+00
      2191 9.428999e-01            0  2.458440e+00
      2192 6.767495e-01            0  2.318910e+01
      2193 7.302800e-01            0  9.090540e+00
      2194 9.428999e-01            0  2.458440e+00
      2195 6.767495e-01            0  2.318910e+01
      2196 7.302800e-01            0  9.090540e+00
      2197 9.428999e-01            0  2.458440e+00
      2198 6.767495e-01            0  2.318910e+01
      2199 7.302800e-01            0  9.090540e+00
      2200 9.428999e-01            0  2.458440e+00
      2201 6.767495e-01            0  2.318910e+01
      2202 7.302800e-01            0  9.090540e+00
      2203 9.428999e-01            0  2.458440e+00
      2204 6.767495e-01            0  2.318910e+01
      2205 7.302800e-01            0  9.090540e+00
      2206 9.428999e-01            0  2.458440e+00
      2207 6.767495e-01            0  2.318910e+01
      2208 7.302800e-01            0  9.090540e+00
      2209 5.672414e-01            0  1.000000e+00
      2210 5.672414e-01            0  1.000000e+00
      2211 5.672414e-01            0  1.000000e+00
      2212 5.672414e-01            0  1.000000e+00
      2213 5.672414e-01            0  1.000000e+00
      2214 5.672414e-01            0  1.000000e+00
      2215 5.672414e-01            0  1.000000e+00
      2216 5.672414e-01            0  1.000000e+00
      2217 5.672414e-01            0  1.000000e+00
      2218 9.005747e-01            0 -2.734722e+01
      2219 8.851274e-01            0  1.829611e+01
      2220 7.877044e-01            0 -2.161111e+01
      2221 9.005747e-01            0 -2.734722e+01
      2222 8.851274e-01            0  1.829611e+01
      2223 7.877044e-01            0 -2.161111e+01
      2224 9.005747e-01            0 -2.734722e+01
      2225 8.851274e-01            0  1.829611e+01
      2226 7.877044e-01            0 -2.161111e+01
      2227 2.434600e-01            0  4.285393e+01
      2228 2.434600e-01            0  5.680524e+01
      2229 2.434600e-01            0  2.260203e+01
      2230 2.434600e-01            0  4.285393e+01
      2231 2.434600e-01            0  5.680524e+01
      2232 2.434600e-01            0  2.260203e+01
      2233 2.434600e-01            0  4.285393e+01
      2234 2.434600e-01            0  5.680524e+01
      2235 2.434600e-01            0  2.260203e+01
      2236 2.434600e-01            0  4.285393e+01
      2237 2.434600e-01            0  5.680524e+01
      2238 2.434600e-01            0  2.260203e+01
      2239 4.877543e-01            0  7.713675e+01
      2240 4.877543e-01            0  2.722474e+01
      2241 9.072507e-01            0 -5.292267e+00
      2242 4.877543e-01            0  7.713675e+01
      2243 4.877543e-01            0  2.722474e+01
      2244 9.072507e-01            0 -5.292267e+00
      2245 4.877543e-01            0  7.713675e+01
      2246 4.877543e-01            0  2.722474e+01
      2247 9.072507e-01            0 -5.292267e+00
      2248 2.090852e-01            0  2.166807e+01
      2249 2.090852e-01            0  1.444538e+01
      2250 5.102856e-01            0  1.379085e+01
      2251 2.090852e-01            0  2.166807e+01
      2252 2.090852e-01            0  1.444538e+01
      2253 5.102856e-01            0  1.379085e+01
      2254 2.090852e-01            0  2.166807e+01
      2255 2.090852e-01            0  1.444538e+01
      2256 5.102856e-01            0  1.379085e+01
      2257 2.090852e-01            0  2.166807e+01
      2258 2.090852e-01            0  1.444538e+01
      2259 5.102856e-01            0  1.379085e+01
      2260 2.090852e-01            0  2.166807e+01
      2261 2.090852e-01            0  1.444538e+01
      2262 5.102856e-01            0  1.379085e+01
      2263 2.090852e-01            0  2.166807e+01
      2264 2.090852e-01            0  1.444538e+01
      2265 5.102856e-01            0  1.379085e+01
      2266 2.090852e-01            0  2.166807e+01
      2267 2.090852e-01            0  1.444538e+01
      2268 5.102856e-01            0  1.379085e+01
      2269 3.766977e-01            0  4.575862e+01
      2270 3.766977e-01            0  3.130183e+00
      2271 3.766977e-01            0  4.892054e+00
      2272 3.766977e-01            0  4.575862e+01
      2273 3.766977e-01            0  3.130183e+00
      2274 3.766977e-01            0  4.892054e+00
      2275 3.766977e-01            0  4.575862e+01
      2276 3.766977e-01            0  3.130183e+00
      2277 3.766977e-01            0  4.892054e+00
      2278 3.766977e-01            0  4.575862e+01
      2279 3.766977e-01            0  3.130183e+00
      2280 3.766977e-01            0  4.892054e+00
      2281 6.057312e-01            0  3.836167e+01
      2282 6.057312e-01            0  2.021764e+00
      2283 8.165650e-01            0  1.362414e+01
      2284 6.057312e-01            0  3.836167e+01
      2285 6.057312e-01            0  2.021764e+00
      2286 8.165650e-01            0  1.362414e+01
      2287 6.057312e-01            0  3.836167e+01
      2288 6.057312e-01            0  2.021764e+00
      2289 8.165650e-01            0  1.362414e+01
      2290 6.057312e-01            0  3.836167e+01
      2291 6.057312e-01            0  2.021764e+00
      2292 8.165650e-01            0  1.362414e+01
      2293 6.057312e-01            0  3.836167e+01
      2294 6.057312e-01            0  2.021764e+00
      2295 8.165650e-01            0  1.362414e+01
      2296 2.122956e-01            0 -1.775357e+02
      2297 2.122956e-01            0 -1.894348e+01
      2298 2.122956e-01            0 -6.701361e+01
      2299 2.122956e-01            0 -1.775357e+02
      2300 2.122956e-01            0 -1.894348e+01
      2301 2.122956e-01            0 -6.701361e+01
      2302 2.122956e-01            0 -1.775357e+02
      2303 2.122956e-01            0 -1.894348e+01
      2304 2.122956e-01            0 -6.701361e+01
      2305 2.255381e-01            0  1.948710e+02
      2306 2.255381e-01            0  1.948710e+02
      2307 2.255381e-01            0  5.639171e+01
      2308 2.255381e-01            0  1.948710e+02
      2309 2.255381e-01            0  1.948710e+02
      2310 2.255381e-01            0  5.639171e+01
      2311 2.255381e-01            0  1.948710e+02
      2312 2.255381e-01            0  1.948710e+02
      2313 2.255381e-01            0  5.639171e+01
      2314 2.255381e-01            0  1.948710e+02
      2315 2.255381e-01            0  1.948710e+02
      2316 2.255381e-01            0  5.639171e+01
      2317 2.255381e-01            0  1.948710e+02
      2318 2.255381e-01            0  1.948710e+02
      2319 2.255381e-01            0  5.639171e+01
      2320 6.512571e-01            0  4.129054e+01
      2321 6.512571e-01            0  8.155185e+01
      2322 5.784500e-01            0 -6.191506e+01
      2323 6.512571e-01            0  4.129054e+01
      2324 6.512571e-01            0  8.155185e+01
      2325 5.784500e-01            0 -6.191506e+01
      2326 6.512571e-01            0  4.129054e+01
      2327 6.512571e-01            0  8.155185e+01
      2328 5.784500e-01            0 -6.191506e+01
      2329 6.512571e-01            0  4.129054e+01
      2330 6.512571e-01            0  8.155185e+01
      2331 5.784500e-01            0 -6.191506e+01
      2332 1.996209e-02            1  9.880978e+01
      2333 6.559911e-02            0  1.446099e+02
      2334 6.309812e-02            0  9.594303e+01
      2335 1.996209e-02            1  9.880978e+01
      2336 6.559911e-02            0  1.446099e+02
      2337 6.309812e-02            0  9.594303e+01
      2338 1.996209e-02            1  9.880978e+01
      2339 6.559911e-02            0  1.446099e+02
      2340 6.309812e-02            0  9.594303e+01
      2341 1.996209e-02            1  9.880978e+01
      2342 6.559911e-02            0  1.446099e+02
      2343 6.309812e-02            0  9.594303e+01
      2344 4.511787e-01            0  1.218193e+02
      2345 4.511787e-01            0  2.393284e+02
      2346 3.743889e-01            0  8.494721e+01
      2347 4.511787e-01            0  1.218193e+02
      2348 4.511787e-01            0  2.393284e+02
      2349 3.743889e-01            0  8.494721e+01
      2350 4.511787e-01            0  1.218193e+02
      2351 4.511787e-01            0  2.393284e+02
      2352 3.743889e-01            0  8.494721e+01
      2353 4.511787e-01            0  1.218193e+02
      2354 4.511787e-01            0  2.393284e+02
      2355 3.743889e-01            0  8.494721e+01
      2356 3.333333e-01            0 -1.668889e+02
      2357 9.558260e-01            0 -3.394822e+01
      2358 9.250695e-01            0 -3.368935e+01
      2359 3.333333e-01            0 -1.668889e+02
      2360 9.558260e-01            0 -3.394822e+01
      2361 9.250695e-01            0 -3.368935e+01
      2362 3.333333e-01            0 -1.668889e+02
      2363 9.558260e-01            0 -3.394822e+01
      2364 9.250695e-01            0 -3.368935e+01
      2365 3.333333e-01            0  9.991667e+02
      2366 3.333333e-01            0  9.991667e+02
      2367 3.333333e-01            0  6.664444e+02
      2368 3.333333e-01            0  9.991667e+02
      2369 3.333333e-01            0  9.991667e+02
      2370 3.333333e-01            0  6.664444e+02
      2371 3.333333e-01            0  9.991667e+02
      2372 3.333333e-01            0  9.991667e+02
      2373 3.333333e-01            0  6.664444e+02
      2374 2.432902e-01            0 -3.555732e+01
      2375 2.432902e-01            0 -6.649043e+01
      2376 2.432902e-01            0 -4.774309e+01
      2377 2.432902e-01            0 -3.555732e+01
      2378 2.432902e-01            0 -6.649043e+01
      2379 2.432902e-01            0 -4.774309e+01
      2380 2.432902e-01            0 -3.555732e+01
      2381 2.432902e-01            0 -6.649043e+01
      2382 2.432902e-01            0 -4.774309e+01
      2383 2.432902e-01            0 -3.555732e+01
      2384 2.432902e-01            0 -6.649043e+01
      2385 2.432902e-01            0 -4.774309e+01
      2386 2.432902e-01            0 -3.555732e+01
      2387 2.432902e-01            0 -6.649043e+01
      2388 2.432902e-01            0 -4.774309e+01
      2389 2.420754e-01            0  2.664592e+02
      2390 2.420754e-01            0  2.664592e+02
      2391 2.420754e-01            0  2.222160e+02
      2392 2.420754e-01            0  2.664592e+02
      2393 2.420754e-01            0  2.664592e+02
      2394 2.420754e-01            0  2.222160e+02
      2395 2.420754e-01            0  2.664592e+02
      2396 2.420754e-01            0  2.664592e+02
      2397 2.420754e-01            0  2.222160e+02
      2398 4.827163e-01            0 -5.601239e+01
      2399 8.694407e-01            0 -4.250771e+00
      2400 8.869376e-01            0  7.655823e+00
      2401 4.827163e-01            0 -5.601239e+01
      2402 8.694407e-01            0 -4.250771e+00
      2403 8.869376e-01            0  7.655823e+00
      2404 4.827163e-01            0 -5.601239e+01
      2405 8.694407e-01            0 -4.250771e+00
      2406 8.869376e-01            0  7.655823e+00
      2407 4.827163e-01            0 -5.601239e+01
      2408 8.694407e-01            0 -4.250771e+00
      2409 8.869376e-01            0  7.655823e+00
      2410 4.827163e-01            0 -5.601239e+01
      2411 8.694407e-01            0 -4.250771e+00
      2412 8.869376e-01            0  7.655823e+00
      2413 4.827163e-01            0 -5.601239e+01
      2414 8.694407e-01            0 -4.250771e+00
      2415 8.869376e-01            0  7.655823e+00
      2416 8.017715e-01            0  8.220865e+00
      2417 1.832194e-01            0  7.016575e+01
      2418 1.559714e-01            0  4.879120e+01
      2419 8.017715e-01            0  8.220865e+00
      2420 1.832194e-01            0  7.016575e+01
      2421 1.559714e-01            0  4.879120e+01
      2422 8.017715e-01            0  8.220865e+00
      2423 1.832194e-01            0  7.016575e+01
      2424 1.559714e-01            0  4.879120e+01
      2425 8.017715e-01            0  8.220865e+00
      2426 1.832194e-01            0  7.016575e+01
      2427 1.559714e-01            0  4.879120e+01
      2428 8.017715e-01            0  8.220865e+00
      2429 1.832194e-01            0  7.016575e+01
      2430 1.559714e-01            0  4.879120e+01
      2431 8.017715e-01            0  8.220865e+00
      2432 1.832194e-01            0  7.016575e+01
      2433 1.559714e-01            0  4.879120e+01
      2434 8.017715e-01            0  8.220865e+00
      2435 1.832194e-01            0  7.016575e+01
      2436 1.559714e-01            0  4.879120e+01
      2437 8.017715e-01            0  8.220865e+00
      2438 1.832194e-01            0  7.016575e+01
      2439 1.559714e-01            0  4.879120e+01
      2440 8.017715e-01            0  8.220865e+00
      2441 1.832194e-01            0  7.016575e+01
      2442 1.559714e-01            0  4.879120e+01
      2443 8.017715e-01            0  8.220865e+00
      2444 1.832194e-01            0  7.016575e+01
      2445 1.559714e-01            0  4.879120e+01
      2446 7.245413e-01            0  2.625000e+01
      2447 6.000201e-01            0  5.437191e+01
      2448 5.376391e-01            0  5.222523e+01
      2449 7.245413e-01            0  2.625000e+01
      2450 6.000201e-01            0  5.437191e+01
      2451 5.376391e-01            0  5.222523e+01
      2452 7.245413e-01            0  2.625000e+01
      2453 6.000201e-01            0  5.437191e+01
      2454 5.376391e-01            0  5.222523e+01
      2455 8.885099e-01            0 -8.186262e+00
      2456 6.021278e-01            0 -3.270957e+01
      2457 8.522831e-01            0 -1.193276e+01
      2458 8.885099e-01            0 -8.186262e+00
      2459 6.021278e-01            0 -3.270957e+01
      2460 8.522831e-01            0 -1.193276e+01
      2461 8.885099e-01            0 -8.186262e+00
      2462 6.021278e-01            0 -3.270957e+01
      2463 8.522831e-01            0 -1.193276e+01
      2464 8.885099e-01            0 -8.186262e+00
      2465 6.021278e-01            0 -3.270957e+01
      2466 8.522831e-01            0 -1.193276e+01
      2467 8.885099e-01            0 -8.186262e+00
      2468 6.021278e-01            0 -3.270957e+01
      2469 8.522831e-01            0 -1.193276e+01
      2470 8.885099e-01            0 -8.186262e+00
      2471 6.021278e-01            0 -3.270957e+01
      2472 8.522831e-01            0 -1.193276e+01
      2473 8.885099e-01            0 -8.186262e+00
      2474 6.021278e-01            0 -3.270957e+01
      2475 8.522831e-01            0 -1.193276e+01
      2476 4.245912e-01            0  9.090204e+01
      2477 4.245912e-01            0  1.086146e+02
      2478 4.245912e-01            0  1.110135e+01
      2479 4.245912e-01            0  9.090204e+01
      2480 4.245912e-01            0  1.086146e+02
      2481 4.245912e-01            0  1.110135e+01
      2482 4.245912e-01            0  9.090204e+01
      2483 4.245912e-01            0  1.086146e+02
      2484 4.245912e-01            0  1.110135e+01
      2485 8.633014e-01            0  3.243026e+00
      2486 1.804487e-01            0 -2.249848e+01
      2487 7.647385e-01            0 -1.015311e+01
      2488 8.633014e-01            0  3.243026e+00
      2489 1.804487e-01            0 -2.249848e+01
      2490 7.647385e-01            0 -1.015311e+01
      2491 8.633014e-01            0  3.243026e+00
      2492 1.804487e-01            0 -2.249848e+01
      2493 7.647385e-01            0 -1.015311e+01
      2494 8.633014e-01            0  3.243026e+00
      2495 1.804487e-01            0 -2.249848e+01
      2496 7.647385e-01            0 -1.015311e+01
      2497 8.633014e-01            0  3.243026e+00
      2498 1.804487e-01            0 -2.249848e+01
      2499 7.647385e-01            0 -1.015311e+01
      2500 8.633014e-01            0  3.243026e+00
      2501 1.804487e-01            0 -2.249848e+01
      2502 7.647385e-01            0 -1.015311e+01
      2503 8.633014e-01            0  3.243026e+00
      2504 1.804487e-01            0 -2.249848e+01
      2505 7.647385e-01            0 -1.015311e+01
      2506 8.633014e-01            0  3.243026e+00
      2507 1.804487e-01            0 -2.249848e+01
      2508 7.647385e-01            0 -1.015311e+01
      2509 8.633014e-01            0  3.243026e+00
      2510 1.804487e-01            0 -2.249848e+01
      2511 7.647385e-01            0 -1.015311e+01
      2512 8.633014e-01            0  3.243026e+00
      2513 1.804487e-01            0 -2.249848e+01
      2514 7.647385e-01            0 -1.015311e+01
      2515 8.633014e-01            0  3.243026e+00
      2516 1.804487e-01            0 -2.249848e+01
      2517 7.647385e-01            0 -1.015311e+01
      2518 8.633014e-01            0  3.243026e+00
      2519 1.804487e-01            0 -2.249848e+01
      2520 7.647385e-01            0 -1.015311e+01
      2521 8.633014e-01            0  3.243026e+00
      2522 1.804487e-01            0 -2.249848e+01
      2523 7.647385e-01            0 -1.015311e+01
      2524 8.633014e-01            0  3.243026e+00
      2525 1.804487e-01            0 -2.249848e+01
      2526 7.647385e-01            0 -1.015311e+01
      2527 9.378311e-02            0  2.353575e+02
      2528 9.378311e-02            0  2.353575e+02
      2529 9.378311e-02            0  1.181788e+02
      2530 9.378311e-02            0  2.353575e+02
      2531 9.378311e-02            0  2.353575e+02
      2532 9.378311e-02            0  1.181788e+02
      2533 9.378311e-02            0  2.353575e+02
      2534 9.378311e-02            0  2.353575e+02
      2535 9.378311e-02            0  1.181788e+02
      2536 9.378311e-02            0  2.353575e+02
      2537 9.378311e-02            0  2.353575e+02
      2538 9.378311e-02            0  1.181788e+02
      2539 2.599978e-01            0 -3.553994e+01
      2540 9.695202e-01            0 -3.782529e-01
      2541 4.850845e-01            0 -2.491557e+01
      2542 2.599978e-01            0 -3.553994e+01
      2543 9.695202e-01            0 -3.782529e-01
      2544 4.850845e-01            0 -2.491557e+01
      2545 2.599978e-01            0 -3.553994e+01
      2546 9.695202e-01            0 -3.782529e-01
      2547 4.850845e-01            0 -2.491557e+01
      2548 2.599978e-01            0 -3.553994e+01
      2549 9.695202e-01            0 -3.782529e-01
      2550 4.850845e-01            0 -2.491557e+01
      2551 2.599978e-01            0 -3.553994e+01
      2552 9.695202e-01            0 -3.782529e-01
      2553 4.850845e-01            0 -2.491557e+01
      2554 2.599978e-01            0 -3.553994e+01
      2555 9.695202e-01            0 -3.782529e-01
      2556 4.850845e-01            0 -2.491557e+01
      2557 2.599978e-01            0 -3.553994e+01
      2558 9.695202e-01            0 -3.782529e-01
      2559 4.850845e-01            0 -2.491557e+01
      2560 2.599978e-01            0 -3.553994e+01
      2561 9.695202e-01            0 -3.782529e-01
      2562 4.850845e-01            0 -2.491557e+01
      2563 2.599978e-01            0 -3.553994e+01
      2564 9.695202e-01            0 -3.782529e-01
      2565 4.850845e-01            0 -2.491557e+01
      2566 2.599978e-01            0 -3.553994e+01
      2567 9.695202e-01            0 -3.782529e-01
      2568 4.850845e-01            0 -2.491557e+01
      2569 2.818823e-01            0  5.272089e+01
      2570 2.818823e-01            0  5.269890e+01
      2571 2.818823e-01            0  3.305841e+01
      2572 2.818823e-01            0  5.272089e+01
      2573 2.818823e-01            0  5.269890e+01
      2574 2.818823e-01            0  3.305841e+01
      2575 2.818823e-01            0  5.272089e+01
      2576 2.818823e-01            0  5.269890e+01
      2577 2.818823e-01            0  3.305841e+01
      2578 2.818823e-01            0  5.272089e+01
      2579 2.818823e-01            0  5.269890e+01
      2580 2.818823e-01            0  3.305841e+01
      2581 2.818823e-01            0  5.272089e+01
      2582 2.818823e-01            0  5.269890e+01
      2583 2.818823e-01            0  3.305841e+01
      2584 2.818823e-01            0  5.272089e+01
      2585 2.818823e-01            0  5.269890e+01
      2586 2.818823e-01            0  3.305841e+01
      2587 2.818823e-01            0  5.272089e+01
      2588 2.818823e-01            0  5.269890e+01
      2589 2.818823e-01            0  3.305841e+01
      2590 2.818823e-01            0  5.272089e+01
      2591 2.818823e-01            0  5.269890e+01
      2592 2.818823e-01            0  3.305841e+01
      2593 2.254033e-01            0  4.024000e+02
      2594 2.254033e-01            0  1.162211e+02
      2595 8.781274e-01            0  1.885428e+01
      2596 2.254033e-01            0  4.024000e+02
      2597 2.254033e-01            0  1.162211e+02
      2598 8.781274e-01            0  1.885428e+01
      2599 2.254033e-01            0  4.024000e+02
      2600 2.254033e-01            0  1.162211e+02
      2601 8.781274e-01            0  1.885428e+01
      2602 2.254033e-01            0  4.024000e+02
      2603 2.254033e-01            0  1.162211e+02
      2604 8.781274e-01            0  1.885428e+01
      2605 8.997586e-01            0  1.010145e+01
      2606 7.834504e-01            0 -1.495649e+01
      2607 3.880657e-01            0  5.060295e+01
      2608 8.997586e-01            0  1.010145e+01
      2609 7.834504e-01            0 -1.495649e+01
      2610 3.880657e-01            0  5.060295e+01
      2611 8.997586e-01            0  1.010145e+01
      2612 7.834504e-01            0 -1.495649e+01
      2613 3.880657e-01            0  5.060295e+01
      2614 8.997586e-01            0  1.010145e+01
      2615 7.834504e-01            0 -1.495649e+01
      2616 3.880657e-01            0  5.060295e+01
      2617 8.997586e-01            0  1.010145e+01
      2618 7.834504e-01            0 -1.495649e+01
      2619 3.880657e-01            0  5.060295e+01
      2620 3.722702e-01            0  3.830326e+01
      2621 5.428723e-02            0 -3.403216e+01
      2622 2.124104e-01            0 -3.527785e+01
      2623 3.722702e-01            0  3.830326e+01
      2624 5.428723e-02            0 -3.403216e+01
      2625 2.124104e-01            0 -3.527785e+01
      2626 3.722702e-01            0  3.830326e+01
      2627 5.428723e-02            0 -3.403216e+01
      2628 2.124104e-01            0 -3.527785e+01
      2629 3.722702e-01            0  3.830326e+01
      2630 5.428723e-02            0 -3.403216e+01
      2631 2.124104e-01            0 -3.527785e+01
      2632 3.722702e-01            0  3.830326e+01
      2633 5.428723e-02            0 -3.403216e+01
      2634 2.124104e-01            0 -3.527785e+01
      2635 3.722702e-01            0  3.830326e+01
      2636 5.428723e-02            0 -3.403216e+01
      2637 2.124104e-01            0 -3.527785e+01
      2638 3.722702e-01            0  3.830326e+01
      2639 5.428723e-02            0 -3.403216e+01
      2640 2.124104e-01            0 -3.527785e+01
      2641 5.927123e-01            0 -3.095126e+01
      2642 1.665767e-01            0 -4.742626e+01
      2643 7.149820e-01            0 -1.227168e+01
      2644 5.927123e-01            0 -3.095126e+01
      2645 1.665767e-01            0 -4.742626e+01
      2646 7.149820e-01            0 -1.227168e+01
      2647 5.927123e-01            0 -3.095126e+01
      2648 1.665767e-01            0 -4.742626e+01
      2649 7.149820e-01            0 -1.227168e+01
      2650 5.927123e-01            0 -3.095126e+01
      2651 1.665767e-01            0 -4.742626e+01
      2652 7.149820e-01            0 -1.227168e+01
      2653 5.927123e-01            0 -3.095126e+01
      2654 1.665767e-01            0 -4.742626e+01
      2655 7.149820e-01            0 -1.227168e+01
      2656 9.187304e-01            0  2.210164e+00
      2657 3.366993e-01            0  1.732682e+01
      2658 2.047706e-01            0  2.015914e+01
      2659 9.187304e-01            0  2.210164e+00
      2660 3.366993e-01            0  1.732682e+01
      2661 2.047706e-01            0  2.015914e+01
      2662 9.187304e-01            0  2.210164e+00
      2663 3.366993e-01            0  1.732682e+01
      2664 2.047706e-01            0  2.015914e+01
      2665 9.187304e-01            0  2.210164e+00
      2666 3.366993e-01            0  1.732682e+01
      2667 2.047706e-01            0  2.015914e+01
      2668 9.187304e-01            0  2.210164e+00
      2669 3.366993e-01            0  1.732682e+01
      2670 2.047706e-01            0  2.015914e+01
      2671 9.187304e-01            0  2.210164e+00
      2672 3.366993e-01            0  1.732682e+01
      2673 2.047706e-01            0  2.015914e+01
      2674 9.187304e-01            0  2.210164e+00
      2675 3.366993e-01            0  1.732682e+01
      2676 2.047706e-01            0  2.015914e+01
      2677 9.187304e-01            0  2.210164e+00
      2678 3.366993e-01            0  1.732682e+01
      2679 2.047706e-01            0  2.015914e+01
      2680 9.187304e-01            0  2.210164e+00
      2681 3.366993e-01            0  1.732682e+01
      2682 2.047706e-01            0  2.015914e+01
      2683 9.187304e-01            0  2.210164e+00
      2684 3.366993e-01            0  1.732682e+01
      2685 2.047706e-01            0  2.015914e+01
      2686 9.187304e-01            0  2.210164e+00
      2687 3.366993e-01            0  1.732682e+01
      2688 2.047706e-01            0  2.015914e+01
      2689 9.187304e-01            0  2.210164e+00
      2690 3.366993e-01            0  1.732682e+01
      2691 2.047706e-01            0  2.015914e+01
      2692 9.187304e-01            0  2.210164e+00
      2693 3.366993e-01            0  1.732682e+01
      2694 2.047706e-01            0  2.015914e+01
      2695 9.187304e-01            0  2.210164e+00
      2696 3.366993e-01            0  1.732682e+01
      2697 2.047706e-01            0  2.015914e+01
      2698 9.187304e-01            0  2.210164e+00
      2699 3.366993e-01            0  1.732682e+01
      2700 2.047706e-01            0  2.015914e+01
      2701 9.187304e-01            0  2.210164e+00
      2702 3.366993e-01            0  1.732682e+01
      2703 2.047706e-01            0  2.015914e+01
      2704 9.187304e-01            0  2.210164e+00
      2705 3.366993e-01            0  1.732682e+01
      2706 2.047706e-01            0  2.015914e+01
      2707 1.848276e-04            1 -3.488670e+01
      2708 3.063158e-04            1 -6.426713e+01
      2709 5.065157e-04            1 -4.472974e+01
      2710 1.848276e-04            1 -3.488670e+01
      2711 3.063158e-04            1 -6.426713e+01
      2712 5.065157e-04            1 -4.472974e+01
      2713 1.848276e-04            1 -3.488670e+01
      2714 3.063158e-04            1 -6.426713e+01
      2715 5.065157e-04            1 -4.472974e+01
      2716 1.848276e-04            1 -3.488670e+01
      2717 3.063158e-04            1 -6.426713e+01
      2718 5.065157e-04            1 -4.472974e+01
      2719 1.848276e-04            1 -3.488670e+01
      2720 3.063158e-04            1 -6.426713e+01
      2721 5.065157e-04            1 -4.472974e+01
      2722 1.848276e-04            1 -3.488670e+01
      2723 3.063158e-04            1 -6.426713e+01
      2724 5.065157e-04            1 -4.472974e+01
      2725 1.848276e-04            1 -3.488670e+01
      2726 3.063158e-04            1 -6.426713e+01
      2727 5.065157e-04            1 -4.472974e+01
      2728 1.848276e-04            1 -3.488670e+01
      2729 3.063158e-04            1 -6.426713e+01
      2730 5.065157e-04            1 -4.472974e+01
      2731 1.848276e-04            1 -3.488670e+01
      2732 3.063158e-04            1 -6.426713e+01
      2733 5.065157e-04            1 -4.472974e+01
      2734 1.000000e+00            0  3.333333e-01
      2735 1.000000e+00            0  2.572178e-01
      2736 1.699483e-01            0 -5.520322e+01
      2737 1.000000e+00            0  3.333333e-01
      2738 1.000000e+00            0  2.572178e-01
      2739 1.699483e-01            0 -5.520322e+01
      2740 1.000000e+00            0  3.333333e-01
      2741 1.000000e+00            0  2.572178e-01
      2742 1.699483e-01            0 -5.520322e+01
      2743 3.490742e-01            0 -5.023026e+01
      2744 5.642870e-02            0 -1.508362e+02
      2745 1.672412e-02            1 -1.102198e+02
      2746 3.490742e-01            0 -5.023026e+01
      2747 5.642870e-02            0 -1.508362e+02
      2748 1.672412e-02            1 -1.102198e+02
      2749 3.490742e-01            0 -5.023026e+01
      2750 5.642870e-02            0 -1.508362e+02
      2751 1.672412e-02            1 -1.102198e+02
      2752 3.490742e-01            0 -5.023026e+01
      2753 5.642870e-02            0 -1.508362e+02
      2754 1.672412e-02            1 -1.102198e+02
      2755 3.490742e-01            0 -5.023026e+01
      2756 5.642870e-02            0 -1.508362e+02
      2757 1.672412e-02            1 -1.102198e+02
      2758 8.988265e-01            0 -1.421488e+01
      2759 8.897914e-01            0 -1.542062e+01
      2760 7.407878e-01            0 -3.132782e+01
      2761 8.988265e-01            0 -1.421488e+01
      2762 8.897914e-01            0 -1.542062e+01
      2763 7.407878e-01            0 -3.132782e+01
      2764 8.988265e-01            0 -1.421488e+01
      2765 8.897914e-01            0 -1.542062e+01
      2766 7.407878e-01            0 -3.132782e+01
      2767 8.988265e-01            0 -1.421488e+01
      2768 8.897914e-01            0 -1.542062e+01
      2769 7.407878e-01            0 -3.132782e+01
      2770 8.988265e-01            0 -1.421488e+01
      2771 8.897914e-01            0 -1.542062e+01
      2772 7.407878e-01            0 -3.132782e+01
      2773 8.789623e-01            0  1.445000e+02
      2774 8.789623e-01            0  1.445000e+02
      2775 8.789623e-01            0  1.240000e+02
      2776 8.789623e-01            0  1.445000e+02
      2777 8.789623e-01            0  1.445000e+02
      2778 8.789623e-01            0  1.240000e+02
      2779 8.789623e-01            0  1.445000e+02
      2780 8.789623e-01            0  1.445000e+02
      2781 8.789623e-01            0  1.240000e+02
      2782 4.705203e-01            0 -3.883352e+00
      2783 1.028374e-01            0  5.889473e+01
      2784 2.044255e-01            0  3.496687e+01
      2785 4.705203e-01            0 -3.883352e+00
      2786 1.028374e-01            0  5.889473e+01
      2787 2.044255e-01            0  3.496687e+01
      2788 4.705203e-01            0 -3.883352e+00
      2789 1.028374e-01            0  5.889473e+01
      2790 2.044255e-01            0  3.496687e+01
      2791 4.705203e-01            0 -3.883352e+00
      2792 1.028374e-01            0  5.889473e+01
      2793 2.044255e-01            0  3.496687e+01
      2794 4.705203e-01            0 -3.883352e+00
      2795 1.028374e-01            0  5.889473e+01
      2796 2.044255e-01            0  3.496687e+01
      2797 9.925071e-01            0  5.412632e-01
      2798 5.515323e-01            0 -9.272118e+00
      2799 2.834745e-01            0 -1.218174e+01
      2800 9.925071e-01            0  5.412632e-01
      2801 5.515323e-01            0 -9.272118e+00
      2802 2.834745e-01            0 -1.218174e+01
      2803 9.925071e-01            0  5.412632e-01
      2804 5.515323e-01            0 -9.272118e+00
      2805 2.834745e-01            0 -1.218174e+01
      2806 9.925071e-01            0  5.412632e-01
      2807 5.515323e-01            0 -9.272118e+00
      2808 2.834745e-01            0 -1.218174e+01
      2809 3.642200e-01            0 -9.218738e+00
      2810 4.944781e-01            0 -8.928324e+00
      2811 3.484513e-01            0 -1.050572e+01
      2812 3.642200e-01            0 -9.218738e+00
      2813 4.944781e-01            0 -8.928324e+00
      2814 3.484513e-01            0 -1.050572e+01
      2815 3.642200e-01            0 -9.218738e+00
      2816 4.944781e-01            0 -8.928324e+00
      2817 3.484513e-01            0 -1.050572e+01
      2818 3.642200e-01            0 -9.218738e+00
      2819 4.944781e-01            0 -8.928324e+00
      2820 3.484513e-01            0 -1.050572e+01
      2821 3.642200e-01            0 -9.218738e+00
      2822 4.944781e-01            0 -8.928324e+00
      2823 3.484513e-01            0 -1.050572e+01
      2824 3.642200e-01            0 -9.218738e+00
      2825 4.944781e-01            0 -8.928324e+00
      2826 3.484513e-01            0 -1.050572e+01
      2827 3.642200e-01            0 -9.218738e+00
      2828 4.944781e-01            0 -8.928324e+00
      2829 3.484513e-01            0 -1.050572e+01
      2830 3.642200e-01            0 -9.218738e+00
      2831 4.944781e-01            0 -8.928324e+00
      2832 3.484513e-01            0 -1.050572e+01
      2833 3.642200e-01            0 -9.218738e+00
      2834 4.944781e-01            0 -8.928324e+00
      2835 3.484513e-01            0 -1.050572e+01
      2836 3.642200e-01            0 -9.218738e+00
      2837 4.944781e-01            0 -8.928324e+00
      2838 3.484513e-01            0 -1.050572e+01
      2839 3.642200e-01            0 -9.218738e+00
      2840 4.944781e-01            0 -8.928324e+00
      2841 3.484513e-01            0 -1.050572e+01
      2842 3.642200e-01            0 -9.218738e+00
      2843 4.944781e-01            0 -8.928324e+00
      2844 3.484513e-01            0 -1.050572e+01
      2845 3.642200e-01            0 -9.218738e+00
      2846 4.944781e-01            0 -8.928324e+00
      2847 3.484513e-01            0 -1.050572e+01
      2848 3.642200e-01            0 -9.218738e+00
      2849 4.944781e-01            0 -8.928324e+00
      2850 3.484513e-01            0 -1.050572e+01
      2851 3.642200e-01            0 -9.218738e+00
      2852 4.944781e-01            0 -8.928324e+00
      2853 3.484513e-01            0 -1.050572e+01
      2854 3.642200e-01            0 -9.218738e+00
      2855 4.944781e-01            0 -8.928324e+00
      2856 3.484513e-01            0 -1.050572e+01
      2857 3.642200e-01            0 -9.218738e+00
      2858 4.944781e-01            0 -8.928324e+00
      2859 3.484513e-01            0 -1.050572e+01
      2860 3.642200e-01            0 -9.218738e+00
      2861 4.944781e-01            0 -8.928324e+00
      2862 3.484513e-01            0 -1.050572e+01
      2863 5.723987e-01            0  4.237972e+00
      2864 3.097263e-01            0 -1.994903e+01
      2865 9.688858e-02            0 -2.259801e+01
      2866 5.723987e-01            0  4.237972e+00
      2867 3.097263e-01            0 -1.994903e+01
      2868 9.688858e-02            0 -2.259801e+01
      2869 5.723987e-01            0  4.237972e+00
      2870 3.097263e-01            0 -1.994903e+01
      2871 9.688858e-02            0 -2.259801e+01
      2872 5.723987e-01            0  4.237972e+00
      2873 3.097263e-01            0 -1.994903e+01
      2874 9.688858e-02            0 -2.259801e+01
      2875 5.723987e-01            0  4.237972e+00
      2876 3.097263e-01            0 -1.994903e+01
      2877 9.688858e-02            0 -2.259801e+01
      2878 5.723987e-01            0  4.237972e+00
      2879 3.097263e-01            0 -1.994903e+01
      2880 9.688858e-02            0 -2.259801e+01
      2881 5.723987e-01            0  4.237972e+00
      2882 3.097263e-01            0 -1.994903e+01
      2883 9.688858e-02            0 -2.259801e+01
      2884 5.723987e-01            0  4.237972e+00
      2885 3.097263e-01            0 -1.994903e+01
      2886 9.688858e-02            0 -2.259801e+01
      2887 5.723987e-01            0  4.237972e+00
      2888 3.097263e-01            0 -1.994903e+01
      2889 9.688858e-02            0 -2.259801e+01
      2890 5.723987e-01            0  4.237972e+00
      2891 3.097263e-01            0 -1.994903e+01
      2892 9.688858e-02            0 -2.259801e+01
      2893 5.723987e-01            0  4.237972e+00
      2894 3.097263e-01            0 -1.994903e+01
      2895 9.688858e-02            0 -2.259801e+01
      2896 5.723987e-01            0  4.237972e+00
      2897 3.097263e-01            0 -1.994903e+01
      2898 9.688858e-02            0 -2.259801e+01
      2899 5.723987e-01            0  4.237972e+00
      2900 3.097263e-01            0 -1.994903e+01
      2901 9.688858e-02            0 -2.259801e+01
      2902 5.723987e-01            0  4.237972e+00
      2903 3.097263e-01            0 -1.994903e+01
      2904 9.688858e-02            0 -2.259801e+01
      2905 5.723987e-01            0  4.237972e+00
      2906 3.097263e-01            0 -1.994903e+01
      2907 9.688858e-02            0 -2.259801e+01
      2908 5.556206e-01            0 -3.995485e+00
      2909 6.795351e-01            0  8.519053e+00
      2910 1.922831e-01            0 -2.665589e+01
      2911 5.556206e-01            0 -3.995485e+00
      2912 6.795351e-01            0  8.519053e+00
      2913 1.922831e-01            0 -2.665589e+01
      2914 5.556206e-01            0 -3.995485e+00
      2915 6.795351e-01            0  8.519053e+00
      2916 1.922831e-01            0 -2.665589e+01
      2917 5.556206e-01            0 -3.995485e+00
      2918 6.795351e-01            0  8.519053e+00
      2919 1.922831e-01            0 -2.665589e+01
      2920 5.556206e-01            0 -3.995485e+00
      2921 6.795351e-01            0  8.519053e+00
      2922 1.922831e-01            0 -2.665589e+01
      2923 5.556206e-01            0 -3.995485e+00
      2924 6.795351e-01            0  8.519053e+00
      2925 1.922831e-01            0 -2.665589e+01
      2926 5.556206e-01            0 -3.995485e+00
      2927 6.795351e-01            0  8.519053e+00
      2928 1.922831e-01            0 -2.665589e+01
      2929 5.556206e-01            0 -3.995485e+00
      2930 6.795351e-01            0  8.519053e+00
      2931 1.922831e-01            0 -2.665589e+01
      2932 5.556206e-01            0 -3.995485e+00
      2933 6.795351e-01            0  8.519053e+00
      2934 1.922831e-01            0 -2.665589e+01
      2935 5.556206e-01            0 -3.995485e+00
      2936 6.795351e-01            0  8.519053e+00
      2937 1.922831e-01            0 -2.665589e+01
      2938 5.556206e-01            0 -3.995485e+00
      2939 6.795351e-01            0  8.519053e+00
      2940 1.922831e-01            0 -2.665589e+01
      2941 5.556206e-01            0 -3.995485e+00
      2942 6.795351e-01            0  8.519053e+00
      2943 1.922831e-01            0 -2.665589e+01
      2944 5.556206e-01            0 -3.995485e+00
      2945 6.795351e-01            0  8.519053e+00
      2946 1.922831e-01            0 -2.665589e+01
      2947 5.556206e-01            0 -3.995485e+00
      2948 6.795351e-01            0  8.519053e+00
      2949 1.922831e-01            0 -2.665589e+01
      2950 5.556206e-01            0 -3.995485e+00
      2951 6.795351e-01            0  8.519053e+00
      2952 1.922831e-01            0 -2.665589e+01
      2953 5.556206e-01            0 -3.995485e+00
      2954 6.795351e-01            0  8.519053e+00
      2955 1.922831e-01            0 -2.665589e+01
      2956 5.556206e-01            0 -3.995485e+00
      2957 6.795351e-01            0  8.519053e+00
      2958 1.922831e-01            0 -2.665589e+01
      2959 4.404870e-01            0 -6.501232e+00
      2960 3.813188e-02            1 -4.194200e+01
      2961 8.110245e-02            0 -3.019516e+01
      2962 4.404870e-01            0 -6.501232e+00
      2963 3.813188e-02            1 -4.194200e+01
      2964 8.110245e-02            0 -3.019516e+01
      2965 4.404870e-01            0 -6.501232e+00
      2966 3.813188e-02            1 -4.194200e+01
      2967 8.110245e-02            0 -3.019516e+01
      2968 4.404870e-01            0 -6.501232e+00
      2969 3.813188e-02            1 -4.194200e+01
      2970 8.110245e-02            0 -3.019516e+01
      2971 4.404870e-01            0 -6.501232e+00
      2972 3.813188e-02            1 -4.194200e+01
      2973 8.110245e-02            0 -3.019516e+01
      2974 4.404870e-01            0 -6.501232e+00
      2975 3.813188e-02            1 -4.194200e+01
      2976 8.110245e-02            0 -3.019516e+01
      2977 4.404870e-01            0 -6.501232e+00
      2978 3.813188e-02            1 -4.194200e+01
      2979 8.110245e-02            0 -3.019516e+01
      2980 4.404870e-01            0 -6.501232e+00
      2981 3.813188e-02            1 -4.194200e+01
      2982 8.110245e-02            0 -3.019516e+01
      2983 4.404870e-01            0 -6.501232e+00
      2984 3.813188e-02            1 -4.194200e+01
      2985 8.110245e-02            0 -3.019516e+01
      2986 4.404870e-01            0 -6.501232e+00
      2987 3.813188e-02            1 -4.194200e+01
      2988 8.110245e-02            0 -3.019516e+01
      2989 4.404870e-01            0 -6.501232e+00
      2990 3.813188e-02            1 -4.194200e+01
      2991 8.110245e-02            0 -3.019516e+01
      2992 5.403057e-02            0 -1.068686e+01
      2993 2.074968e-01            0 -1.849353e+01
      2994 3.190696e-02            1 -2.672892e+01
      2995 5.403057e-02            0 -1.068686e+01
      2996 2.074968e-01            0 -1.849353e+01
      2997 3.190696e-02            1 -2.672892e+01
      2998 5.403057e-02            0 -1.068686e+01
      2999 2.074968e-01            0 -1.849353e+01
      3000 3.190696e-02            1 -2.672892e+01
      3001 5.403057e-02            0 -1.068686e+01
      3002 2.074968e-01            0 -1.849353e+01
      3003 3.190696e-02            1 -2.672892e+01
      3004 5.403057e-02            0 -1.068686e+01
      3005 2.074968e-01            0 -1.849353e+01
      3006 3.190696e-02            1 -2.672892e+01
      3007 5.403057e-02            0 -1.068686e+01
      3008 2.074968e-01            0 -1.849353e+01
      3009 3.190696e-02            1 -2.672892e+01
      3010 5.403057e-02            0 -1.068686e+01
      3011 2.074968e-01            0 -1.849353e+01
      3012 3.190696e-02            1 -2.672892e+01
      3013 5.403057e-02            0 -1.068686e+01
      3014 2.074968e-01            0 -1.849353e+01
      3015 3.190696e-02            1 -2.672892e+01
      3016 5.403057e-02            0 -1.068686e+01
      3017 2.074968e-01            0 -1.849353e+01
      3018 3.190696e-02            1 -2.672892e+01
      3019 5.403057e-02            0 -1.068686e+01
      3020 2.074968e-01            0 -1.849353e+01
      3021 3.190696e-02            1 -2.672892e+01
      3022 5.403057e-02            0 -1.068686e+01
      3023 2.074968e-01            0 -1.849353e+01
      3024 3.190696e-02            1 -2.672892e+01
      3025 5.403057e-02            0 -1.068686e+01
      3026 2.074968e-01            0 -1.849353e+01
      3027 3.190696e-02            1 -2.672892e+01
      3028 5.403057e-02            0 -1.068686e+01
      3029 2.074968e-01            0 -1.849353e+01
      3030 3.190696e-02            1 -2.672892e+01
      3031 5.403057e-02            0 -1.068686e+01
      3032 2.074968e-01            0 -1.849353e+01
      3033 3.190696e-02            1 -2.672892e+01
      3034 5.403057e-02            0 -1.068686e+01
      3035 2.074968e-01            0 -1.849353e+01
      3036 3.190696e-02            1 -2.672892e+01
      3037 5.403057e-02            0 -1.068686e+01
      3038 2.074968e-01            0 -1.849353e+01
      3039 3.190696e-02            1 -2.672892e+01
      3040 5.403057e-02            0 -1.068686e+01
      3041 2.074968e-01            0 -1.849353e+01
      3042 3.190696e-02            1 -2.672892e+01
      3043 5.992842e-01            0 -6.078086e+00
      3044 2.322302e-01            0 -1.252952e+01
      3045 4.898054e-01            0 -1.371385e+01
      3046 5.992842e-01            0 -6.078086e+00
      3047 2.322302e-01            0 -1.252952e+01
      3048 4.898054e-01            0 -1.371385e+01
      3049 5.992842e-01            0 -6.078086e+00
      3050 2.322302e-01            0 -1.252952e+01
      3051 4.898054e-01            0 -1.371385e+01
      3052 5.992842e-01            0 -6.078086e+00
      3053 2.322302e-01            0 -1.252952e+01
      3054 4.898054e-01            0 -1.371385e+01
      3055 5.992842e-01            0 -6.078086e+00
      3056 2.322302e-01            0 -1.252952e+01
      3057 4.898054e-01            0 -1.371385e+01
      3058 5.992842e-01            0 -6.078086e+00
      3059 2.322302e-01            0 -1.252952e+01
      3060 4.898054e-01            0 -1.371385e+01
      3061 5.992842e-01            0 -6.078086e+00
      3062 2.322302e-01            0 -1.252952e+01
      3063 4.898054e-01            0 -1.371385e+01
      3064 6.186920e-01            0  3.773147e+00
      3065 3.062838e-01            0 -3.497396e+01
      3066 4.179580e-01            0 -1.891599e+01
      3067 6.186920e-01            0  3.773147e+00
      3068 3.062838e-01            0 -3.497396e+01
      3069 4.179580e-01            0 -1.891599e+01
      3070 6.186920e-01            0  3.773147e+00
      3071 3.062838e-01            0 -3.497396e+01
      3072 4.179580e-01            0 -1.891599e+01
      3073 6.186920e-01            0  3.773147e+00
      3074 3.062838e-01            0 -3.497396e+01
      3075 4.179580e-01            0 -1.891599e+01
      3076 6.186920e-01            0  3.773147e+00
      3077 3.062838e-01            0 -3.497396e+01
      3078 4.179580e-01            0 -1.891599e+01
      3079 6.186920e-01            0  3.773147e+00
      3080 3.062838e-01            0 -3.497396e+01
      3081 4.179580e-01            0 -1.891599e+01
      3082 6.186920e-01            0  3.773147e+00
      3083 3.062838e-01            0 -3.497396e+01
      3084 4.179580e-01            0 -1.891599e+01
      3085 6.186920e-01            0  3.773147e+00
      3086 3.062838e-01            0 -3.497396e+01
      3087 4.179580e-01            0 -1.891599e+01
      3088 6.186920e-01            0  3.773147e+00
      3089 3.062838e-01            0 -3.497396e+01
      3090 4.179580e-01            0 -1.891599e+01
      3091 6.186920e-01            0  3.773147e+00
      3092 3.062838e-01            0 -3.497396e+01
      3093 4.179580e-01            0 -1.891599e+01
      3094 6.186920e-01            0  3.773147e+00
      3095 3.062838e-01            0 -3.497396e+01
      3096 4.179580e-01            0 -1.891599e+01
      3097 6.186920e-01            0  3.773147e+00
      3098 3.062838e-01            0 -3.497396e+01
      3099 4.179580e-01            0 -1.891599e+01
      3100 6.186920e-01            0  3.773147e+00
      3101 3.062838e-01            0 -3.497396e+01
      3102 4.179580e-01            0 -1.891599e+01
      3103 1.935383e-01            0 -1.219337e+01
      3104 9.210496e-02            0 -4.708837e+01
      3105 4.548669e-01            0 -1.407768e+01
      3106 1.935383e-01            0 -1.219337e+01
      3107 9.210496e-02            0 -4.708837e+01
      3108 4.548669e-01            0 -1.407768e+01
      3109 1.935383e-01            0 -1.219337e+01
      3110 9.210496e-02            0 -4.708837e+01
      3111 4.548669e-01            0 -1.407768e+01
      3112 1.935383e-01            0 -1.219337e+01
      3113 9.210496e-02            0 -4.708837e+01
      3114 4.548669e-01            0 -1.407768e+01
      3115 1.935383e-01            0 -1.219337e+01
      3116 9.210496e-02            0 -4.708837e+01
      3117 4.548669e-01            0 -1.407768e+01
      3118 1.935383e-01            0 -1.219337e+01
      3119 9.210496e-02            0 -4.708837e+01
      3120 4.548669e-01            0 -1.407768e+01
      3121 1.935383e-01            0 -1.219337e+01
      3122 9.210496e-02            0 -4.708837e+01
      3123 4.548669e-01            0 -1.407768e+01
      3124 1.935383e-01            0 -1.219337e+01
      3125 9.210496e-02            0 -4.708837e+01
      3126 4.548669e-01            0 -1.407768e+01
      3127 1.935383e-01            0 -1.219337e+01
      3128 9.210496e-02            0 -4.708837e+01
      3129 4.548669e-01            0 -1.407768e+01
      3130 1.935383e-01            0 -1.219337e+01
      3131 9.210496e-02            0 -4.708837e+01
      3132 4.548669e-01            0 -1.407768e+01
      3133 1.935383e-01            0 -1.219337e+01
      3134 9.210496e-02            0 -4.708837e+01
      3135 4.548669e-01            0 -1.407768e+01
      3136 1.935383e-01            0 -1.219337e+01
      3137 9.210496e-02            0 -4.708837e+01
      3138 4.548669e-01            0 -1.407768e+01
      3139 1.935383e-01            0 -1.219337e+01
      3140 9.210496e-02            0 -4.708837e+01
      3141 4.548669e-01            0 -1.407768e+01
      3142 1.935383e-01            0 -1.219337e+01
      3143 9.210496e-02            0 -4.708837e+01
      3144 4.548669e-01            0 -1.407768e+01
      3145 1.935383e-01            0 -1.219337e+01
      3146 9.210496e-02            0 -4.708837e+01
      3147 4.548669e-01            0 -1.407768e+01
      3148 1.935383e-01            0 -1.219337e+01
      3149 9.210496e-02            0 -4.708837e+01
      3150 4.548669e-01            0 -1.407768e+01
      3151 1.935383e-01            0 -1.219337e+01
      3152 9.210496e-02            0 -4.708837e+01
      3153 4.548669e-01            0 -1.407768e+01
      3154 1.935383e-01            0 -1.219337e+01
      3155 9.210496e-02            0 -4.708837e+01
      3156 4.548669e-01            0 -1.407768e+01
      3157 3.052206e-01            0  1.470538e+01
      3158 8.540286e-01            0  4.916684e+00
      3159 5.701843e-01            0 -2.067577e+01
      3160 3.052206e-01            0  1.470538e+01
      3161 8.540286e-01            0  4.916684e+00
      3162 5.701843e-01            0 -2.067577e+01
      3163 3.052206e-01            0  1.470538e+01
      3164 8.540286e-01            0  4.916684e+00
      3165 5.701843e-01            0 -2.067577e+01
      3166 3.052206e-01            0  1.470538e+01
      3167 8.540286e-01            0  4.916684e+00
      3168 5.701843e-01            0 -2.067577e+01
      3169 3.052206e-01            0  1.470538e+01
      3170 8.540286e-01            0  4.916684e+00
      3171 5.701843e-01            0 -2.067577e+01
      3172 3.052206e-01            0  1.470538e+01
      3173 8.540286e-01            0  4.916684e+00
      3174 5.701843e-01            0 -2.067577e+01
      3175 3.052206e-01            0  1.470538e+01
      3176 8.540286e-01            0  4.916684e+00
      3177 5.701843e-01            0 -2.067577e+01
      3178 3.052206e-01            0  1.470538e+01
      3179 8.540286e-01            0  4.916684e+00
      3180 5.701843e-01            0 -2.067577e+01
      3181 3.052206e-01            0  1.470538e+01
      3182 8.540286e-01            0  4.916684e+00
      3183 5.701843e-01            0 -2.067577e+01
      3184 3.052206e-01            0  1.470538e+01
      3185 8.540286e-01            0  4.916684e+00
      3186 5.701843e-01            0 -2.067577e+01
      3187 3.132445e-01            0  1.854119e+01
      3188 7.404464e-01            0 -3.046727e+01
      3189 5.628495e-02            0 -4.183497e+01
      3190 3.132445e-01            0  1.854119e+01
      3191 7.404464e-01            0 -3.046727e+01
      3192 5.628495e-02            0 -4.183497e+01
      3193 3.132445e-01            0  1.854119e+01
      3194 7.404464e-01            0 -3.046727e+01
      3195 5.628495e-02            0 -4.183497e+01
      3196 1.225223e-01            0 -1.422120e+01
      3197 1.463851e-01            0 -2.483293e+01
      3198 2.698815e-01            0 -3.185247e+01
      3199 1.225223e-01            0 -1.422120e+01
      3200 1.463851e-01            0 -2.483293e+01
      3201 2.698815e-01            0 -3.185247e+01
      3202 1.225223e-01            0 -1.422120e+01
      3203 1.463851e-01            0 -2.483293e+01
      3204 2.698815e-01            0 -3.185247e+01
      3205 1.225223e-01            0 -1.422120e+01
      3206 1.463851e-01            0 -2.483293e+01
      3207 2.698815e-01            0 -3.185247e+01
      3208 1.225223e-01            0 -1.422120e+01
      3209 1.463851e-01            0 -2.483293e+01
      3210 2.698815e-01            0 -3.185247e+01
      3211 1.225223e-01            0 -1.422120e+01
      3212 1.463851e-01            0 -2.483293e+01
      3213 2.698815e-01            0 -3.185247e+01
      3214 1.225223e-01            0 -1.422120e+01
      3215 1.463851e-01            0 -2.483293e+01
      3216 2.698815e-01            0 -3.185247e+01
      3217 1.225223e-01            0 -1.422120e+01
      3218 1.463851e-01            0 -2.483293e+01
      3219 2.698815e-01            0 -3.185247e+01
      3220 1.225223e-01            0 -1.422120e+01
      3221 1.463851e-01            0 -2.483293e+01
      3222 2.698815e-01            0 -3.185247e+01
      3223 1.225223e-01            0 -1.422120e+01
      3224 1.463851e-01            0 -2.483293e+01
      3225 2.698815e-01            0 -3.185247e+01
      3226 1.225223e-01            0 -1.422120e+01
      3227 1.463851e-01            0 -2.483293e+01
      3228 2.698815e-01            0 -3.185247e+01
      3229 1.225223e-01            0 -1.422120e+01
      3230 1.463851e-01            0 -2.483293e+01
      3231 2.698815e-01            0 -3.185247e+01
      3232 1.225223e-01            0 -1.422120e+01
      3233 1.463851e-01            0 -2.483293e+01
      3234 2.698815e-01            0 -3.185247e+01
      3235 1.225223e-01            0 -1.422120e+01
      3236 1.463851e-01            0 -2.483293e+01
      3237 2.698815e-01            0 -3.185247e+01
      3238 1.225223e-01            0 -1.422120e+01
      3239 1.463851e-01            0 -2.483293e+01
      3240 2.698815e-01            0 -3.185247e+01
      3241 1.225223e-01            0 -1.422120e+01
      3242 1.463851e-01            0 -2.483293e+01
      3243 2.698815e-01            0 -3.185247e+01
      3244 6.754793e-01            0 -4.635167e+00
      3245 3.812456e-01            0 -1.597633e+01
      3246 8.310899e-01            0 -5.382877e+00
      3247 6.754793e-01            0 -4.635167e+00
      3248 3.812456e-01            0 -1.597633e+01
      3249 8.310899e-01            0 -5.382877e+00
      3250 6.754793e-01            0 -4.635167e+00
      3251 3.812456e-01            0 -1.597633e+01
      3252 8.310899e-01            0 -5.382877e+00
      3253 6.754793e-01            0 -4.635167e+00
      3254 3.812456e-01            0 -1.597633e+01
      3255 8.310899e-01            0 -5.382877e+00
      3256 6.754793e-01            0 -4.635167e+00
      3257 3.812456e-01            0 -1.597633e+01
      3258 8.310899e-01            0 -5.382877e+00
      3259 6.754793e-01            0 -4.635167e+00
      3260 3.812456e-01            0 -1.597633e+01
      3261 8.310899e-01            0 -5.382877e+00
      3262 6.754793e-01            0 -4.635167e+00
      3263 3.812456e-01            0 -1.597633e+01
      3264 8.310899e-01            0 -5.382877e+00
      3265 6.754793e-01            0 -4.635167e+00
      3266 3.812456e-01            0 -1.597633e+01
      3267 8.310899e-01            0 -5.382877e+00
      3268 6.754793e-01            0 -4.635167e+00
      3269 3.812456e-01            0 -1.597633e+01
      3270 8.310899e-01            0 -5.382877e+00
      3271 6.754793e-01            0 -4.635167e+00
      3272 3.812456e-01            0 -1.597633e+01
      3273 8.310899e-01            0 -5.382877e+00
      3274 6.754793e-01            0 -4.635167e+00
      3275 3.812456e-01            0 -1.597633e+01
      3276 8.310899e-01            0 -5.382877e+00
      3277 6.754793e-01            0 -4.635167e+00
      3278 3.812456e-01            0 -1.597633e+01
      3279 8.310899e-01            0 -5.382877e+00
      3280 6.754793e-01            0 -4.635167e+00
      3281 3.812456e-01            0 -1.597633e+01
      3282 8.310899e-01            0 -5.382877e+00
      3283 6.754793e-01            0 -4.635167e+00
      3284 3.812456e-01            0 -1.597633e+01
      3285 8.310899e-01            0 -5.382877e+00
      3286 1.542209e-01            0 -1.085329e+01
      3287 5.071734e-01            0 -6.825819e+00
      3288 5.965139e-01            0  9.667028e+00
      3289 1.542209e-01            0 -1.085329e+01
      3290 5.071734e-01            0 -6.825819e+00
      3291 5.965139e-01            0  9.667028e+00
      3292 1.542209e-01            0 -1.085329e+01
      3293 5.071734e-01            0 -6.825819e+00
      3294 5.965139e-01            0  9.667028e+00
      3295 1.542209e-01            0 -1.085329e+01
      3296 5.071734e-01            0 -6.825819e+00
      3297 5.965139e-01            0  9.667028e+00
      3298 1.542209e-01            0 -1.085329e+01
      3299 5.071734e-01            0 -6.825819e+00
      3300 5.965139e-01            0  9.667028e+00
      3301 1.542209e-01            0 -1.085329e+01
      3302 5.071734e-01            0 -6.825819e+00
      3303 5.965139e-01            0  9.667028e+00
      3304 1.542209e-01            0 -1.085329e+01
      3305 5.071734e-01            0 -6.825819e+00
      3306 5.965139e-01            0  9.667028e+00
      3307 1.542209e-01            0 -1.085329e+01
      3308 5.071734e-01            0 -6.825819e+00
      3309 5.965139e-01            0  9.667028e+00
      3310 1.542209e-01            0 -1.085329e+01
      3311 5.071734e-01            0 -6.825819e+00
      3312 5.965139e-01            0  9.667028e+00
      3313 1.542209e-01            0 -1.085329e+01
      3314 5.071734e-01            0 -6.825819e+00
      3315 5.965139e-01            0  9.667028e+00
      3316 1.542209e-01            0 -1.085329e+01
      3317 5.071734e-01            0 -6.825819e+00
      3318 5.965139e-01            0  9.667028e+00
      3319 1.542209e-01            0 -1.085329e+01
      3320 5.071734e-01            0 -6.825819e+00
      3321 5.965139e-01            0  9.667028e+00
      3322 1.542209e-01            0 -1.085329e+01
      3323 5.071734e-01            0 -6.825819e+00
      3324 5.965139e-01            0  9.667028e+00
      3325 1.542209e-01            0 -1.085329e+01
      3326 5.071734e-01            0 -6.825819e+00
      3327 5.965139e-01            0  9.667028e+00
      3328 1.542209e-01            0 -1.085329e+01
      3329 5.071734e-01            0 -6.825819e+00
      3330 5.965139e-01            0  9.667028e+00
      3331 1.542209e-01            0 -1.085329e+01
      3332 5.071734e-01            0 -6.825819e+00
      3333 5.965139e-01            0  9.667028e+00
      3334 1.542209e-01            0 -1.085329e+01
      3335 5.071734e-01            0 -6.825819e+00
      3336 5.965139e-01            0  9.667028e+00
      3337 1.622075e-01            0  1.263844e+01
      3338 2.841852e-01            0 -2.226902e+01
      3339 7.732163e-01            0  5.658006e+00
      3340 1.622075e-01            0  1.263844e+01
      3341 2.841852e-01            0 -2.226902e+01
      3342 7.732163e-01            0  5.658006e+00
      3343 1.622075e-01            0  1.263844e+01
      3344 2.841852e-01            0 -2.226902e+01
      3345 7.732163e-01            0  5.658006e+00
      3346 1.622075e-01            0  1.263844e+01
      3347 2.841852e-01            0 -2.226902e+01
      3348 7.732163e-01            0  5.658006e+00
      3349 1.622075e-01            0  1.263844e+01
      3350 2.841852e-01            0 -2.226902e+01
      3351 7.732163e-01            0  5.658006e+00
      3352 1.622075e-01            0  1.263844e+01
      3353 2.841852e-01            0 -2.226902e+01
      3354 7.732163e-01            0  5.658006e+00
      3355 1.622075e-01            0  1.263844e+01
      3356 2.841852e-01            0 -2.226902e+01
      3357 7.732163e-01            0  5.658006e+00
      3358 1.622075e-01            0  1.263844e+01
      3359 2.841852e-01            0 -2.226902e+01
      3360 7.732163e-01            0  5.658006e+00
      3361 1.622075e-01            0  1.263844e+01
      3362 2.841852e-01            0 -2.226902e+01
      3363 7.732163e-01            0  5.658006e+00
      3364 1.622075e-01            0  1.263844e+01
      3365 2.841852e-01            0 -2.226902e+01
      3366 7.732163e-01            0  5.658006e+00
      3367 1.622075e-01            0  1.263844e+01
      3368 2.841852e-01            0 -2.226902e+01
      3369 7.732163e-01            0  5.658006e+00
      3370 1.622075e-01            0  1.263844e+01
      3371 2.841852e-01            0 -2.226902e+01
      3372 7.732163e-01            0  5.658006e+00
      3373 1.622075e-01            0  1.263844e+01
      3374 2.841852e-01            0 -2.226902e+01
      3375 7.732163e-01            0  5.658006e+00
      3376 1.622075e-01            0  1.263844e+01
      3377 2.841852e-01            0 -2.226902e+01
      3378 7.732163e-01            0  5.658006e+00
      3379 1.622075e-01            0  1.263844e+01
      3380 2.841852e-01            0 -2.226902e+01
      3381 7.732163e-01            0  5.658006e+00
      3382 6.821940e-01            0  7.322436e+01
      3383 1.838469e-01            0  6.016813e+01
      3384 3.196719e-01            0  3.583126e+01
      3385 6.821940e-01            0  7.322436e+01
      3386 1.838469e-01            0  6.016813e+01
      3387 3.196719e-01            0  3.583126e+01
      3388 6.821940e-01            0  7.322436e+01
      3389 1.838469e-01            0  6.016813e+01
      3390 3.196719e-01            0  3.583126e+01
      3391 3.126913e-01            0 -6.236921e+00
      3392 3.176488e-02            1 -4.280901e+01
      3393 4.620933e-02            1 -4.368178e+01
      3394 3.126913e-01            0 -6.236921e+00
      3395 3.176488e-02            1 -4.280901e+01
      3396 4.620933e-02            1 -4.368178e+01
      3397 3.126913e-01            0 -6.236921e+00
      3398 3.176488e-02            1 -4.280901e+01
      3399 4.620933e-02            1 -4.368178e+01
      3400 3.126913e-01            0 -6.236921e+00
      3401 3.176488e-02            1 -4.280901e+01
      3402 4.620933e-02            1 -4.368178e+01
      3403 3.126913e-01            0 -6.236921e+00
      3404 3.176488e-02            1 -4.280901e+01
      3405 4.620933e-02            1 -4.368178e+01
      3406 3.126913e-01            0 -6.236921e+00
      3407 3.176488e-02            1 -4.280901e+01
      3408 4.620933e-02            1 -4.368178e+01
      3409 3.126913e-01            0 -6.236921e+00
      3410 3.176488e-02            1 -4.280901e+01
      3411 4.620933e-02            1 -4.368178e+01
      3412 3.126913e-01            0 -6.236921e+00
      3413 3.176488e-02            1 -4.280901e+01
      3414 4.620933e-02            1 -4.368178e+01
      3415 3.126913e-01            0 -6.236921e+00
      3416 3.176488e-02            1 -4.280901e+01
      3417 4.620933e-02            1 -4.368178e+01
      3418 3.126913e-01            0 -6.236921e+00
      3419 3.176488e-02            1 -4.280901e+01
      3420 4.620933e-02            1 -4.368178e+01
      3421 3.126913e-01            0 -6.236921e+00
      3422 3.176488e-02            1 -4.280901e+01
      3423 4.620933e-02            1 -4.368178e+01
      3424 3.126913e-01            0 -6.236921e+00
      3425 3.176488e-02            1 -4.280901e+01
      3426 4.620933e-02            1 -4.368178e+01
      3427 3.126913e-01            0 -6.236921e+00
      3428 3.176488e-02            1 -4.280901e+01
      3429 4.620933e-02            1 -4.368178e+01
      3430 3.126913e-01            0 -6.236921e+00
      3431 3.176488e-02            1 -4.280901e+01
      3432 4.620933e-02            1 -4.368178e+01
      3433 3.126913e-01            0 -6.236921e+00
      3434 3.176488e-02            1 -4.280901e+01
      3435 4.620933e-02            1 -4.368178e+01
      3436 3.126913e-01            0 -6.236921e+00
      3437 3.176488e-02            1 -4.280901e+01
      3438 4.620933e-02            1 -4.368178e+01
      3439 3.126913e-01            0 -6.236921e+00
      3440 3.176488e-02            1 -4.280901e+01
      3441 4.620933e-02            1 -4.368178e+01
      3442 3.126913e-01            0 -6.236921e+00
      3443 3.176488e-02            1 -4.280901e+01
      3444 4.620933e-02            1 -4.368178e+01
      3445 3.126913e-01            0 -6.236921e+00
      3446 3.176488e-02            1 -4.280901e+01
      3447 4.620933e-02            1 -4.368178e+01
      3448 3.126913e-01            0 -6.236921e+00
      3449 3.176488e-02            1 -4.280901e+01
      3450 4.620933e-02            1 -4.368178e+01
      3451 9.181787e-01            0  1.237731e+00
      3452 3.770812e-01            0 -3.174069e+01
      3453 9.163519e-01            0  3.013894e+00
      3454 9.181787e-01            0  1.237731e+00
      3455 3.770812e-01            0 -3.174069e+01
      3456 9.163519e-01            0  3.013894e+00
      3457 9.181787e-01            0  1.237731e+00
      3458 3.770812e-01            0 -3.174069e+01
      3459 9.163519e-01            0  3.013894e+00
      3460 9.181787e-01            0  1.237731e+00
      3461 3.770812e-01            0 -3.174069e+01
      3462 9.163519e-01            0  3.013894e+00
      3463 9.181787e-01            0  1.237731e+00
      3464 3.770812e-01            0 -3.174069e+01
      3465 9.163519e-01            0  3.013894e+00
      3466 9.181787e-01            0  1.237731e+00
      3467 3.770812e-01            0 -3.174069e+01
      3468 9.163519e-01            0  3.013894e+00
      3469 9.181787e-01            0  1.237731e+00
      3470 3.770812e-01            0 -3.174069e+01
      3471 9.163519e-01            0  3.013894e+00
      3472 9.181787e-01            0  1.237731e+00
      3473 3.770812e-01            0 -3.174069e+01
      3474 9.163519e-01            0  3.013894e+00
      3475 9.181787e-01            0  1.237731e+00
      3476 3.770812e-01            0 -3.174069e+01
      3477 9.163519e-01            0  3.013894e+00
      3478 9.181787e-01            0  1.237731e+00
      3479 3.770812e-01            0 -3.174069e+01
      3480 9.163519e-01            0  3.013894e+00
      3481 9.181787e-01            0  1.237731e+00
      3482 3.770812e-01            0 -3.174069e+01
      3483 9.163519e-01            0  3.013894e+00
      3484 9.181787e-01            0  1.237731e+00
      3485 3.770812e-01            0 -3.174069e+01
      3486 9.163519e-01            0  3.013894e+00
      3487 9.181787e-01            0  1.237731e+00
      3488 3.770812e-01            0 -3.174069e+01
      3489 9.163519e-01            0  3.013894e+00
      3490 9.181787e-01            0  1.237731e+00
      3491 3.770812e-01            0 -3.174069e+01
      3492 9.163519e-01            0  3.013894e+00
      3493 9.181787e-01            0  1.237731e+00
      3494 3.770812e-01            0 -3.174069e+01
      3495 9.163519e-01            0  3.013894e+00
      3496 9.181787e-01            0  1.237731e+00
      3497 3.770812e-01            0 -3.174069e+01
      3498 9.163519e-01            0  3.013894e+00
      3499 5.645567e-01            0  5.114503e+01
      3500 9.449901e-01            0 -1.746654e+01
      3501 8.597512e-01            0  5.008241e+01
      3502 5.645567e-01            0  5.114503e+01
      3503 9.449901e-01            0 -1.746654e+01
      3504 8.597512e-01            0  5.008241e+01
      3505 5.645567e-01            0  5.114503e+01
      3506 9.449901e-01            0 -1.746654e+01
      3507 8.597512e-01            0  5.008241e+01
      3508 5.645567e-01            0  5.114503e+01
      3509 9.449901e-01            0 -1.746654e+01
      3510 8.597512e-01            0  5.008241e+01
      3511 3.080402e-02            1  3.158807e+01
      3512 9.335168e-01            0  5.275050e+00
      3513 6.272578e-01            0 -3.169771e+01
      3514 3.080402e-02            1  3.158807e+01
      3515 9.335168e-01            0  5.275050e+00
      3516 6.272578e-01            0 -3.169771e+01
      3517 3.080402e-02            1  3.158807e+01
      3518 9.335168e-01            0  5.275050e+00
      3519 6.272578e-01            0 -3.169771e+01
      3520 3.080402e-02            1  3.158807e+01
      3521 9.335168e-01            0  5.275050e+00
      3522 6.272578e-01            0 -3.169771e+01
      3523 3.080402e-02            1  3.158807e+01
      3524 9.335168e-01            0  5.275050e+00
      3525 6.272578e-01            0 -3.169771e+01
      3526 8.005628e-01            0 -1.272677e+00
      3527 4.757465e-01            0 -2.118296e+01
      3528 6.548299e-01            0  1.171239e+01
      3529 8.005628e-01            0 -1.272677e+00
      3530 4.757465e-01            0 -2.118296e+01
      3531 6.548299e-01            0  1.171239e+01
      3532 8.005628e-01            0 -1.272677e+00
      3533 4.757465e-01            0 -2.118296e+01
      3534 6.548299e-01            0  1.171239e+01
      3535 8.005628e-01            0 -1.272677e+00
      3536 4.757465e-01            0 -2.118296e+01
      3537 6.548299e-01            0  1.171239e+01
      3538 8.005628e-01            0 -1.272677e+00
      3539 4.757465e-01            0 -2.118296e+01
      3540 6.548299e-01            0  1.171239e+01
      3541 8.005628e-01            0 -1.272677e+00
      3542 4.757465e-01            0 -2.118296e+01
      3543 6.548299e-01            0  1.171239e+01
      3544 8.005628e-01            0 -1.272677e+00
      3545 4.757465e-01            0 -2.118296e+01
      3546 6.548299e-01            0  1.171239e+01
      3547 8.005628e-01            0 -1.272677e+00
      3548 4.757465e-01            0 -2.118296e+01
      3549 6.548299e-01            0  1.171239e+01
      3550 8.005628e-01            0 -1.272677e+00
      3551 4.757465e-01            0 -2.118296e+01
      3552 6.548299e-01            0  1.171239e+01
      3553 8.005628e-01            0 -1.272677e+00
      3554 4.757465e-01            0 -2.118296e+01
      3555 6.548299e-01            0  1.171239e+01
      3556 8.005628e-01            0 -1.272677e+00
      3557 4.757465e-01            0 -2.118296e+01
      3558 6.548299e-01            0  1.171239e+01
      3559 8.005628e-01            0 -1.272677e+00
      3560 4.757465e-01            0 -2.118296e+01
      3561 6.548299e-01            0  1.171239e+01
      3562 8.005628e-01            0 -1.272677e+00
      3563 4.757465e-01            0 -2.118296e+01
      3564 6.548299e-01            0  1.171239e+01
      3565 8.005628e-01            0 -1.272677e+00
      3566 4.757465e-01            0 -2.118296e+01
      3567 6.548299e-01            0  1.171239e+01
      3568 8.005628e-01            0 -1.272677e+00
      3569 4.757465e-01            0 -2.118296e+01
      3570 6.548299e-01            0  1.171239e+01
      3571 2.521753e-01            0 -1.099185e+01
      3572 2.302971e-02            1  5.552811e+01
      3573 5.028762e-01            0 -8.082705e+00
      3574 2.521753e-01            0 -1.099185e+01
      3575 2.302971e-02            1  5.552811e+01
      3576 5.028762e-01            0 -8.082705e+00
      3577 2.521753e-01            0 -1.099185e+01
      3578 2.302971e-02            1  5.552811e+01
      3579 5.028762e-01            0 -8.082705e+00
      3580 2.521753e-01            0 -1.099185e+01
      3581 2.302971e-02            1  5.552811e+01
      3582 5.028762e-01            0 -8.082705e+00
      3583 2.521753e-01            0 -1.099185e+01
      3584 2.302971e-02            1  5.552811e+01
      3585 5.028762e-01            0 -8.082705e+00
      3586 2.521753e-01            0 -1.099185e+01
      3587 2.302971e-02            1  5.552811e+01
      3588 5.028762e-01            0 -8.082705e+00
      3589 2.521753e-01            0 -1.099185e+01
      3590 2.302971e-02            1  5.552811e+01
      3591 5.028762e-01            0 -8.082705e+00
      3592 6.535691e-01            0  3.047067e+00
      3593 8.959884e-02            0 -3.507655e+01
      3594 1.190096e-01            0 -2.866856e+01
      3595 6.535691e-01            0  3.047067e+00
      3596 8.959884e-02            0 -3.507655e+01
      3597 1.190096e-01            0 -2.866856e+01
      3598 6.535691e-01            0  3.047067e+00
      3599 8.959884e-02            0 -3.507655e+01
      3600 1.190096e-01            0 -2.866856e+01
      3601 6.535691e-01            0  3.047067e+00
      3602 8.959884e-02            0 -3.507655e+01
      3603 1.190096e-01            0 -2.866856e+01
      3604 6.535691e-01            0  3.047067e+00
      3605 8.959884e-02            0 -3.507655e+01
      3606 1.190096e-01            0 -2.866856e+01
      3607 6.535691e-01            0  3.047067e+00
      3608 8.959884e-02            0 -3.507655e+01
      3609 1.190096e-01            0 -2.866856e+01
      3610 6.535691e-01            0  3.047067e+00
      3611 8.959884e-02            0 -3.507655e+01
      3612 1.190096e-01            0 -2.866856e+01
      3613 6.535691e-01            0  3.047067e+00
      3614 8.959884e-02            0 -3.507655e+01
      3615 1.190096e-01            0 -2.866856e+01
      3616 6.535691e-01            0  3.047067e+00
      3617 8.959884e-02            0 -3.507655e+01
      3618 1.190096e-01            0 -2.866856e+01
      3619 6.535691e-01            0  3.047067e+00
      3620 8.959884e-02            0 -3.507655e+01
      3621 1.190096e-01            0 -2.866856e+01
      3622 6.535691e-01            0  3.047067e+00
      3623 8.959884e-02            0 -3.507655e+01
      3624 1.190096e-01            0 -2.866856e+01
      3625 6.535691e-01            0  3.047067e+00
      3626 8.959884e-02            0 -3.507655e+01
      3627 1.190096e-01            0 -2.866856e+01
      3628 6.535691e-01            0  3.047067e+00
      3629 8.959884e-02            0 -3.507655e+01
      3630 1.190096e-01            0 -2.866856e+01
      3631 6.535691e-01            0  3.047067e+00
      3632 8.959884e-02            0 -3.507655e+01
      3633 1.190096e-01            0 -2.866856e+01
      3634 6.535691e-01            0  3.047067e+00
      3635 8.959884e-02            0 -3.507655e+01
      3636 1.190096e-01            0 -2.866856e+01
      3637 9.199751e-01            0  1.049781e+00
      3638 9.510051e-01            0 -9.306619e-01
      3639 3.886438e-01            0 -9.891039e+00
      3640 9.199751e-01            0  1.049781e+00
      3641 9.510051e-01            0 -9.306619e-01
      3642 3.886438e-01            0 -9.891039e+00
      3643 9.199751e-01            0  1.049781e+00
      3644 9.510051e-01            0 -9.306619e-01
      3645 3.886438e-01            0 -9.891039e+00
      3646 9.199751e-01            0  1.049781e+00
      3647 9.510051e-01            0 -9.306619e-01
      3648 3.886438e-01            0 -9.891039e+00
      3649 9.199751e-01            0  1.049781e+00
      3650 9.510051e-01            0 -9.306619e-01
      3651 3.886438e-01            0 -9.891039e+00
      3652 9.199751e-01            0  1.049781e+00
      3653 9.510051e-01            0 -9.306619e-01
      3654 3.886438e-01            0 -9.891039e+00
      3655 9.199751e-01            0  1.049781e+00
      3656 9.510051e-01            0 -9.306619e-01
      3657 3.886438e-01            0 -9.891039e+00
      3658 9.199751e-01            0  1.049781e+00
      3659 9.510051e-01            0 -9.306619e-01
      3660 3.886438e-01            0 -9.891039e+00
      3661 9.199751e-01            0  1.049781e+00
      3662 9.510051e-01            0 -9.306619e-01
      3663 3.886438e-01            0 -9.891039e+00
      3664 9.199751e-01            0  1.049781e+00
      3665 9.510051e-01            0 -9.306619e-01
      3666 3.886438e-01            0 -9.891039e+00
      3667 9.199751e-01            0  1.049781e+00
      3668 9.510051e-01            0 -9.306619e-01
      3669 3.886438e-01            0 -9.891039e+00
      3670 9.199751e-01            0  1.049781e+00
      3671 9.510051e-01            0 -9.306619e-01
      3672 3.886438e-01            0 -9.891039e+00
      3673 9.199751e-01            0  1.049781e+00
      3674 9.510051e-01            0 -9.306619e-01
      3675 3.886438e-01            0 -9.891039e+00
      3676 9.199751e-01            0  1.049781e+00
      3677 9.510051e-01            0 -9.306619e-01
      3678 3.886438e-01            0 -9.891039e+00
      3679 9.199751e-01            0  1.049781e+00
      3680 9.510051e-01            0 -9.306619e-01
      3681 3.886438e-01            0 -9.891039e+00
      3682 9.199751e-01            0  1.049781e+00
      3683 9.510051e-01            0 -9.306619e-01
      3684 3.886438e-01            0 -9.891039e+00
      3685 9.199751e-01            0  1.049781e+00
      3686 9.510051e-01            0 -9.306619e-01
      3687 3.886438e-01            0 -9.891039e+00
      3688 9.199751e-01            0  1.049781e+00
      3689 9.510051e-01            0 -9.306619e-01
      3690 3.886438e-01            0 -9.891039e+00
      3691 2.910465e-02            1 -1.003651e+01
      3692 3.911341e-01            0  5.862374e+00
      3693 5.406756e-01            0  7.897987e+00
      3694 2.910465e-02            1 -1.003651e+01
      3695 3.911341e-01            0  5.862374e+00
      3696 5.406756e-01            0  7.897987e+00
      3697 2.910465e-02            1 -1.003651e+01
      3698 3.911341e-01            0  5.862374e+00
      3699 5.406756e-01            0  7.897987e+00
      3700 2.910465e-02            1 -1.003651e+01
      3701 3.911341e-01            0  5.862374e+00
      3702 5.406756e-01            0  7.897987e+00
      3703 2.910465e-02            1 -1.003651e+01
      3704 3.911341e-01            0  5.862374e+00
      3705 5.406756e-01            0  7.897987e+00
      3706 2.910465e-02            1 -1.003651e+01
      3707 3.911341e-01            0  5.862374e+00
      3708 5.406756e-01            0  7.897987e+00
      3709 2.910465e-02            1 -1.003651e+01
      3710 3.911341e-01            0  5.862374e+00
      3711 5.406756e-01            0  7.897987e+00
      3712 2.910465e-02            1 -1.003651e+01
      3713 3.911341e-01            0  5.862374e+00
      3714 5.406756e-01            0  7.897987e+00
      3715 2.910465e-02            1 -1.003651e+01
      3716 3.911341e-01            0  5.862374e+00
      3717 5.406756e-01            0  7.897987e+00
      3718 2.910465e-02            1 -1.003651e+01
      3719 3.911341e-01            0  5.862374e+00
      3720 5.406756e-01            0  7.897987e+00
      3721 2.910465e-02            1 -1.003651e+01
      3722 3.911341e-01            0  5.862374e+00
      3723 5.406756e-01            0  7.897987e+00
      3724 2.910465e-02            1 -1.003651e+01
      3725 3.911341e-01            0  5.862374e+00
      3726 5.406756e-01            0  7.897987e+00
      3727 2.910465e-02            1 -1.003651e+01
      3728 3.911341e-01            0  5.862374e+00
      3729 5.406756e-01            0  7.897987e+00
      3730 2.910465e-02            1 -1.003651e+01
      3731 3.911341e-01            0  5.862374e+00
      3732 5.406756e-01            0  7.897987e+00
      3733 2.910465e-02            1 -1.003651e+01
      3734 3.911341e-01            0  5.862374e+00
      3735 5.406756e-01            0  7.897987e+00
      3736 2.910465e-02            1 -1.003651e+01
      3737 3.911341e-01            0  5.862374e+00
      3738 5.406756e-01            0  7.897987e+00
      3739 2.910465e-02            1 -1.003651e+01
      3740 3.911341e-01            0  5.862374e+00
      3741 5.406756e-01            0  7.897987e+00
      3742 2.910465e-02            1 -1.003651e+01
      3743 3.911341e-01            0  5.862374e+00
      3744 5.406756e-01            0  7.897987e+00
      3745 2.111730e-02            1  4.311745e+01
      3746 5.823165e-01            0  3.688101e+01
      3747 2.578277e-01            0  6.580255e+01
      3748 2.111730e-02            1  4.311745e+01
      3749 5.823165e-01            0  3.688101e+01
      3750 2.578277e-01            0  6.580255e+01
      3751 2.111730e-02            1  4.311745e+01
      3752 5.823165e-01            0  3.688101e+01
      3753 2.578277e-01            0  6.580255e+01
      3754 2.111730e-02            1  4.311745e+01
      3755 5.823165e-01            0  3.688101e+01
      3756 2.578277e-01            0  6.580255e+01
      3757 2.831944e-01            0 -9.453460e+00
      3758 6.751319e-01            0 -1.309305e+01
      3759 3.560843e-01            0  1.890491e+01
      3760 2.831944e-01            0 -9.453460e+00
      3761 6.751319e-01            0 -1.309305e+01
      3762 3.560843e-01            0  1.890491e+01
      3763 2.831944e-01            0 -9.453460e+00
      3764 6.751319e-01            0 -1.309305e+01
      3765 3.560843e-01            0  1.890491e+01
      3766 2.831944e-01            0 -9.453460e+00
      3767 6.751319e-01            0 -1.309305e+01
      3768 3.560843e-01            0  1.890491e+01
      3769 2.831944e-01            0 -9.453460e+00
      3770 6.751319e-01            0 -1.309305e+01
      3771 3.560843e-01            0  1.890491e+01
      3772 2.831944e-01            0 -9.453460e+00
      3773 6.751319e-01            0 -1.309305e+01
      3774 3.560843e-01            0  1.890491e+01
      3775 2.831944e-01            0 -9.453460e+00
      3776 6.751319e-01            0 -1.309305e+01
      3777 3.560843e-01            0  1.890491e+01
      3778 2.831944e-01            0 -9.453460e+00
      3779 6.751319e-01            0 -1.309305e+01
      3780 3.560843e-01            0  1.890491e+01
      3781 2.831944e-01            0 -9.453460e+00
      3782 6.751319e-01            0 -1.309305e+01
      3783 3.560843e-01            0  1.890491e+01
      3784 2.831944e-01            0 -9.453460e+00
      3785 6.751319e-01            0 -1.309305e+01
      3786 3.560843e-01            0  1.890491e+01
      3787 2.831944e-01            0 -9.453460e+00
      3788 6.751319e-01            0 -1.309305e+01
      3789 3.560843e-01            0  1.890491e+01
      3790 2.831944e-01            0 -9.453460e+00
      3791 6.751319e-01            0 -1.309305e+01
      3792 3.560843e-01            0  1.890491e+01
      3793 2.831944e-01            0 -9.453460e+00
      3794 6.751319e-01            0 -1.309305e+01
      3795 3.560843e-01            0  1.890491e+01
      3796 2.831944e-01            0 -9.453460e+00
      3797 6.751319e-01            0 -1.309305e+01
      3798 3.560843e-01            0  1.890491e+01
      3799 2.906998e-01            0 -9.885243e+00
      3800 1.985427e-01            0  1.977130e+01
      3801 8.787918e-01            0  3.303335e+00
      3802 2.906998e-01            0 -9.885243e+00
      3803 1.985427e-01            0  1.977130e+01
      3804 8.787918e-01            0  3.303335e+00
      3805 2.906998e-01            0 -9.885243e+00
      3806 1.985427e-01            0  1.977130e+01
      3807 8.787918e-01            0  3.303335e+00
      3808 2.906998e-01            0 -9.885243e+00
      3809 1.985427e-01            0  1.977130e+01
      3810 8.787918e-01            0  3.303335e+00
      3811 2.906998e-01            0 -9.885243e+00
      3812 1.985427e-01            0  1.977130e+01
      3813 8.787918e-01            0  3.303335e+00
      3814 2.906998e-01            0 -9.885243e+00
      3815 1.985427e-01            0  1.977130e+01
      3816 8.787918e-01            0  3.303335e+00
      3817 2.906998e-01            0 -9.885243e+00
      3818 1.985427e-01            0  1.977130e+01
      3819 8.787918e-01            0  3.303335e+00
      3820 2.906998e-01            0 -9.885243e+00
      3821 1.985427e-01            0  1.977130e+01
      3822 8.787918e-01            0  3.303335e+00
      3823 2.906998e-01            0 -9.885243e+00
      3824 1.985427e-01            0  1.977130e+01
      3825 8.787918e-01            0  3.303335e+00
      3826 2.906998e-01            0 -9.885243e+00
      3827 1.985427e-01            0  1.977130e+01
      3828 8.787918e-01            0  3.303335e+00
      3829 2.906998e-01            0 -9.885243e+00
      3830 1.985427e-01            0  1.977130e+01
      3831 8.787918e-01            0  3.303335e+00
      3832 2.906998e-01            0 -9.885243e+00
      3833 1.985427e-01            0  1.977130e+01
      3834 8.787918e-01            0  3.303335e+00
      3835 2.906998e-01            0 -9.885243e+00
      3836 1.985427e-01            0  1.977130e+01
      3837 8.787918e-01            0  3.303335e+00
      3838 1.477336e-01            0  1.024059e+01
      3839 4.038335e-03            1  3.975669e+01
      3840 9.683001e-01            0  1.062272e+00
      3841 1.477336e-01            0  1.024059e+01
      3842 4.038335e-03            1  3.975669e+01
      3843 9.683001e-01            0  1.062272e+00
      3844 1.477336e-01            0  1.024059e+01
      3845 4.038335e-03            1  3.975669e+01
      3846 9.683001e-01            0  1.062272e+00
      3847 1.477336e-01            0  1.024059e+01
      3848 4.038335e-03            1  3.975669e+01
      3849 9.683001e-01            0  1.062272e+00
      3850 1.477336e-01            0  1.024059e+01
      3851 4.038335e-03            1  3.975669e+01
      3852 9.683001e-01            0  1.062272e+00
      3853 1.477336e-01            0  1.024059e+01
      3854 4.038335e-03            1  3.975669e+01
      3855 9.683001e-01            0  1.062272e+00
      3856 1.477336e-01            0  1.024059e+01
      3857 4.038335e-03            1  3.975669e+01
      3858 9.683001e-01            0  1.062272e+00
      3859 1.477336e-01            0  1.024059e+01
      3860 4.038335e-03            1  3.975669e+01
      3861 9.683001e-01            0  1.062272e+00
      3862 1.477336e-01            0  1.024059e+01
      3863 4.038335e-03            1  3.975669e+01
      3864 9.683001e-01            0  1.062272e+00
      3865 1.477336e-01            0  1.024059e+01
      3866 4.038335e-03            1  3.975669e+01
      3867 9.683001e-01            0  1.062272e+00
      3868 1.477336e-01            0  1.024059e+01
      3869 4.038335e-03            1  3.975669e+01
      3870 9.683001e-01            0  1.062272e+00
      3871 1.477336e-01            0  1.024059e+01
      3872 4.038335e-03            1  3.975669e+01
      3873 9.683001e-01            0  1.062272e+00
      3874 1.477336e-01            0  1.024059e+01
      3875 4.038335e-03            1  3.975669e+01
      3876 9.683001e-01            0  1.062272e+00
      3877 1.477336e-01            0  1.024059e+01
      3878 4.038335e-03            1  3.975669e+01
      3879 9.683001e-01            0  1.062272e+00
      3880 1.477336e-01            0  1.024059e+01
      3881 4.038335e-03            1  3.975669e+01
      3882 9.683001e-01            0  1.062272e+00
      3883 1.477336e-01            0  1.024059e+01
      3884 4.038335e-03            1  3.975669e+01
      3885 9.683001e-01            0  1.062272e+00
      3886 2.089083e-01            0 -1.113160e+01
      3887 4.157236e-01            0 -3.493207e+00
      3888 8.042028e-01            0  4.992377e+00
      3889 2.089083e-01            0 -1.113160e+01
      3890 4.157236e-01            0 -3.493207e+00
      3891 8.042028e-01            0  4.992377e+00
      3892 2.089083e-01            0 -1.113160e+01
      3893 4.157236e-01            0 -3.493207e+00
      3894 8.042028e-01            0  4.992377e+00
      3895 2.089083e-01            0 -1.113160e+01
      3896 4.157236e-01            0 -3.493207e+00
      3897 8.042028e-01            0  4.992377e+00
      3898 2.089083e-01            0 -1.113160e+01
      3899 4.157236e-01            0 -3.493207e+00
      3900 8.042028e-01            0  4.992377e+00
      3901 2.089083e-01            0 -1.113160e+01
      3902 4.157236e-01            0 -3.493207e+00
      3903 8.042028e-01            0  4.992377e+00
      3904 2.089083e-01            0 -1.113160e+01
      3905 4.157236e-01            0 -3.493207e+00
      3906 8.042028e-01            0  4.992377e+00
      3907 2.089083e-01            0 -1.113160e+01
      3908 4.157236e-01            0 -3.493207e+00
      3909 8.042028e-01            0  4.992377e+00
      3910 2.089083e-01            0 -1.113160e+01
      3911 4.157236e-01            0 -3.493207e+00
      3912 8.042028e-01            0  4.992377e+00
      3913 2.089083e-01            0 -1.113160e+01
      3914 4.157236e-01            0 -3.493207e+00
      3915 8.042028e-01            0  4.992377e+00
      3916 2.089083e-01            0 -1.113160e+01
      3917 4.157236e-01            0 -3.493207e+00
      3918 8.042028e-01            0  4.992377e+00
      3919 2.089083e-01            0 -1.113160e+01
      3920 4.157236e-01            0 -3.493207e+00
      3921 8.042028e-01            0  4.992377e+00
      3922 2.089083e-01            0 -1.113160e+01
      3923 4.157236e-01            0 -3.493207e+00
      3924 8.042028e-01            0  4.992377e+00
      3925 2.089083e-01            0 -1.113160e+01
      3926 4.157236e-01            0 -3.493207e+00
      3927 8.042028e-01            0  4.992377e+00
      3928 2.089083e-01            0 -1.113160e+01
      3929 4.157236e-01            0 -3.493207e+00
      3930 8.042028e-01            0  4.992377e+00
      3931 2.089083e-01            0 -1.113160e+01
      3932 4.157236e-01            0 -3.493207e+00
      3933 8.042028e-01            0  4.992377e+00
      3934 7.434486e-01            0  4.498445e+00
      3935 3.826754e-01            0 -8.605838e+00
      3936 6.101373e-01            0  8.301057e+00
      3937 7.434486e-01            0  4.498445e+00
      3938 3.826754e-01            0 -8.605838e+00
      3939 6.101373e-01            0  8.301057e+00
      3940 7.434486e-01            0  4.498445e+00
      3941 3.826754e-01            0 -8.605838e+00
      3942 6.101373e-01            0  8.301057e+00
      3943 7.434486e-01            0  4.498445e+00
      3944 3.826754e-01            0 -8.605838e+00
      3945 6.101373e-01            0  8.301057e+00
      3946 7.434486e-01            0  4.498445e+00
      3947 3.826754e-01            0 -8.605838e+00
      3948 6.101373e-01            0  8.301057e+00
      3949 7.434486e-01            0  4.498445e+00
      3950 3.826754e-01            0 -8.605838e+00
      3951 6.101373e-01            0  8.301057e+00
      3952 7.434486e-01            0  4.498445e+00
      3953 3.826754e-01            0 -8.605838e+00
      3954 6.101373e-01            0  8.301057e+00
      3955 7.434486e-01            0  4.498445e+00
      3956 3.826754e-01            0 -8.605838e+00
      3957 6.101373e-01            0  8.301057e+00
      3958 7.434486e-01            0  4.498445e+00
      3959 3.826754e-01            0 -8.605838e+00
      3960 6.101373e-01            0  8.301057e+00
      3961 7.434486e-01            0  4.498445e+00
      3962 3.826754e-01            0 -8.605838e+00
      3963 6.101373e-01            0  8.301057e+00
      3964 7.434486e-01            0  4.498445e+00
      3965 3.826754e-01            0 -8.605838e+00
      3966 6.101373e-01            0  8.301057e+00
      3967 7.434486e-01            0  4.498445e+00
      3968 3.826754e-01            0 -8.605838e+00
      3969 6.101373e-01            0  8.301057e+00
      3970 1.958134e-02            1 -1.531415e+01
      3971 9.504126e-01            0 -5.829293e-01
      3972 4.211084e-01            0  1.620190e+01
      3973 1.958134e-02            1 -1.531415e+01
      3974 9.504126e-01            0 -5.829293e-01
      3975 4.211084e-01            0  1.620190e+01
      3976 1.958134e-02            1 -1.531415e+01
      3977 9.504126e-01            0 -5.829293e-01
      3978 4.211084e-01            0  1.620190e+01
      3979 1.958134e-02            1 -1.531415e+01
      3980 9.504126e-01            0 -5.829293e-01
      3981 4.211084e-01            0  1.620190e+01
      3982 1.958134e-02            1 -1.531415e+01
      3983 9.504126e-01            0 -5.829293e-01
      3984 4.211084e-01            0  1.620190e+01
      3985 1.958134e-02            1 -1.531415e+01
      3986 9.504126e-01            0 -5.829293e-01
      3987 4.211084e-01            0  1.620190e+01
      3988 1.958134e-02            1 -1.531415e+01
      3989 9.504126e-01            0 -5.829293e-01
      3990 4.211084e-01            0  1.620190e+01
      3991 1.958134e-02            1 -1.531415e+01
      3992 9.504126e-01            0 -5.829293e-01
      3993 4.211084e-01            0  1.620190e+01
      3994 1.958134e-02            1 -1.531415e+01
      3995 9.504126e-01            0 -5.829293e-01
      3996 4.211084e-01            0  1.620190e+01
      3997 1.958134e-02            1 -1.531415e+01
      3998 9.504126e-01            0 -5.829293e-01
      3999 4.211084e-01            0  1.620190e+01
      4000 1.958134e-02            1 -1.531415e+01
      4001 9.504126e-01            0 -5.829293e-01
      4002 4.211084e-01            0  1.620190e+01
      4003 1.958134e-02            1 -1.531415e+01
      4004 9.504126e-01            0 -5.829293e-01
      4005 4.211084e-01            0  1.620190e+01
      4006 1.958134e-02            1 -1.531415e+01
      4007 9.504126e-01            0 -5.829293e-01
      4008 4.211084e-01            0  1.620190e+01
      4009 1.958134e-02            1 -1.531415e+01
      4010 9.504126e-01            0 -5.829293e-01
      4011 4.211084e-01            0  1.620190e+01
      4012 9.755086e-01            0 -1.653987e-01
      4013 5.975639e-01            0 -2.176758e+01
      4014 4.629161e-01            0 -3.266456e+01
      4015 9.755086e-01            0 -1.653987e-01
      4016 5.975639e-01            0 -2.176758e+01
      4017 4.629161e-01            0 -3.266456e+01
      4018 9.755086e-01            0 -1.653987e-01
      4019 5.975639e-01            0 -2.176758e+01
      4020 4.629161e-01            0 -3.266456e+01
      4021 3.112565e-01            0 -4.606667e+00
      4022 7.633363e-01            0  2.112092e+00
      4023 8.734259e-01            0  3.166951e+00
      4024 3.112565e-01            0 -4.606667e+00
      4025 7.633363e-01            0  2.112092e+00
      4026 8.734259e-01            0  3.166951e+00
      4027 3.112565e-01            0 -4.606667e+00
      4028 7.633363e-01            0  2.112092e+00
      4029 8.734259e-01            0  3.166951e+00
      4030 3.112565e-01            0 -4.606667e+00
      4031 7.633363e-01            0  2.112092e+00
      4032 8.734259e-01            0  3.166951e+00
      4033 3.112565e-01            0 -4.606667e+00
      4034 7.633363e-01            0  2.112092e+00
      4035 8.734259e-01            0  3.166951e+00
      4036 3.112565e-01            0 -4.606667e+00
      4037 7.633363e-01            0  2.112092e+00
      4038 8.734259e-01            0  3.166951e+00
      4039 3.112565e-01            0 -4.606667e+00
      4040 7.633363e-01            0  2.112092e+00
      4041 8.734259e-01            0  3.166951e+00
      4042 3.112565e-01            0 -4.606667e+00
      4043 7.633363e-01            0  2.112092e+00
      4044 8.734259e-01            0  3.166951e+00
      4045 3.112565e-01            0 -4.606667e+00
      4046 7.633363e-01            0  2.112092e+00
      4047 8.734259e-01            0  3.166951e+00
      4048 3.112565e-01            0 -4.606667e+00
      4049 7.633363e-01            0  2.112092e+00
      4050 8.734259e-01            0  3.166951e+00
      4051 3.112565e-01            0 -4.606667e+00
      4052 7.633363e-01            0  2.112092e+00
      4053 8.734259e-01            0  3.166951e+00
      4054 3.112565e-01            0 -4.606667e+00
      4055 7.633363e-01            0  2.112092e+00
      4056 8.734259e-01            0  3.166951e+00
      4057 3.112565e-01            0 -4.606667e+00
      4058 7.633363e-01            0  2.112092e+00
      4059 8.734259e-01            0  3.166951e+00
      4060 3.112565e-01            0 -4.606667e+00
      4061 7.633363e-01            0  2.112092e+00
      4062 8.734259e-01            0  3.166951e+00
      4063 3.112565e-01            0 -4.606667e+00
      4064 7.633363e-01            0  2.112092e+00
      4065 8.734259e-01            0  3.166951e+00
      4066 9.578134e-01            0 -2.072608e-02
      4067 1.242256e-01            0  2.053076e+01
      4068 5.385697e-01            0  1.264666e+01
      4069 9.578134e-01            0 -2.072608e-02
      4070 1.242256e-01            0  2.053076e+01
      4071 5.385697e-01            0  1.264666e+01
      4072 9.578134e-01            0 -2.072608e-02
      4073 1.242256e-01            0  2.053076e+01
      4074 5.385697e-01            0  1.264666e+01
      4075 9.578134e-01            0 -2.072608e-02
      4076 1.242256e-01            0  2.053076e+01
      4077 5.385697e-01            0  1.264666e+01
      4078 9.578134e-01            0 -2.072608e-02
      4079 1.242256e-01            0  2.053076e+01
      4080 5.385697e-01            0  1.264666e+01
      4081 9.578134e-01            0 -2.072608e-02
      4082 1.242256e-01            0  2.053076e+01
      4083 5.385697e-01            0  1.264666e+01
      4084 9.578134e-01            0 -2.072608e-02
      4085 1.242256e-01            0  2.053076e+01
      4086 5.385697e-01            0  1.264666e+01
      4087 9.578134e-01            0 -2.072608e-02
      4088 1.242256e-01            0  2.053076e+01
      4089 5.385697e-01            0  1.264666e+01
      4090 9.578134e-01            0 -2.072608e-02
      4091 1.242256e-01            0  2.053076e+01
      4092 5.385697e-01            0  1.264666e+01
      4093 9.578134e-01            0 -2.072608e-02
      4094 1.242256e-01            0  2.053076e+01
      4095 5.385697e-01            0  1.264666e+01
      4096 9.578134e-01            0 -2.072608e-02
      4097 1.242256e-01            0  2.053076e+01
      4098 5.385697e-01            0  1.264666e+01
      4099 9.578134e-01            0 -2.072608e-02
      4100 1.242256e-01            0  2.053076e+01
      4101 5.385697e-01            0  1.264666e+01
      4102 4.300880e-01            0 -1.311060e+01
      4103 1.196131e-01            0  3.839149e+01
      4104 7.111304e-01            0  7.577016e+00
      4105 4.300880e-01            0 -1.311060e+01
      4106 1.196131e-01            0  3.839149e+01
      4107 7.111304e-01            0  7.577016e+00
      4108 4.300880e-01            0 -1.311060e+01
      4109 1.196131e-01            0  3.839149e+01
      4110 7.111304e-01            0  7.577016e+00
      4111 4.300880e-01            0 -1.311060e+01
      4112 1.196131e-01            0  3.839149e+01
      4113 7.111304e-01            0  7.577016e+00
      4114 4.300880e-01            0 -1.311060e+01
      4115 1.196131e-01            0  3.839149e+01
      4116 7.111304e-01            0  7.577016e+00
      4117 4.300880e-01            0 -1.311060e+01
      4118 1.196131e-01            0  3.839149e+01
      4119 7.111304e-01            0  7.577016e+00
      4120 4.300880e-01            0 -1.311060e+01
      4121 1.196131e-01            0  3.839149e+01
      4122 7.111304e-01            0  7.577016e+00
      4123 4.300880e-01            0 -1.311060e+01
      4124 1.196131e-01            0  3.839149e+01
      4125 7.111304e-01            0  7.577016e+00
      4126 9.089372e-01            0  1.170205e+00
      4127 9.624126e-01            0 -1.649244e+00
      4128 1.857697e-01            0 -4.735214e+01
      4129 9.089372e-01            0  1.170205e+00
      4130 9.624126e-01            0 -1.649244e+00
      4131 1.857697e-01            0 -4.735214e+01
      4132 9.089372e-01            0  1.170205e+00
      4133 9.624126e-01            0 -1.649244e+00
      4134 1.857697e-01            0 -4.735214e+01
      4135 9.089372e-01            0  1.170205e+00
      4136 9.624126e-01            0 -1.649244e+00
      4137 1.857697e-01            0 -4.735214e+01
      4138 9.089372e-01            0  1.170205e+00
      4139 9.624126e-01            0 -1.649244e+00
      4140 1.857697e-01            0 -4.735214e+01
      4141 9.089372e-01            0  1.170205e+00
      4142 9.624126e-01            0 -1.649244e+00
      4143 1.857697e-01            0 -4.735214e+01
      4144 9.089372e-01            0  1.170205e+00
      4145 9.624126e-01            0 -1.649244e+00
      4146 1.857697e-01            0 -4.735214e+01
      4147 9.089372e-01            0  1.170205e+00
      4148 9.624126e-01            0 -1.649244e+00
      4149 1.857697e-01            0 -4.735214e+01
      4150 9.089372e-01            0  1.170205e+00
      4151 9.624126e-01            0 -1.649244e+00
      4152 1.857697e-01            0 -4.735214e+01
      4153 9.089372e-01            0  1.170205e+00
      4154 9.624126e-01            0 -1.649244e+00
      4155 1.857697e-01            0 -4.735214e+01
      4156 9.089372e-01            0  1.170205e+00
      4157 9.624126e-01            0 -1.649244e+00
      4158 1.857697e-01            0 -4.735214e+01
      4159 8.931545e-01            0  2.250397e+00
      4160 8.334659e-01            0 -7.711200e+00
      4161 2.795396e-01            0 -1.090430e+01
      4162 8.931545e-01            0  2.250397e+00
      4163 8.334659e-01            0 -7.711200e+00
      4164 2.795396e-01            0 -1.090430e+01
      4165 8.931545e-01            0  2.250397e+00
      4166 8.334659e-01            0 -7.711200e+00
      4167 2.795396e-01            0 -1.090430e+01
      4168 8.931545e-01            0  2.250397e+00
      4169 8.334659e-01            0 -7.711200e+00
      4170 2.795396e-01            0 -1.090430e+01
      4171 8.931545e-01            0  2.250397e+00
      4172 8.334659e-01            0 -7.711200e+00
      4173 2.795396e-01            0 -1.090430e+01
      4174 8.931545e-01            0  2.250397e+00
      4175 8.334659e-01            0 -7.711200e+00
      4176 2.795396e-01            0 -1.090430e+01
      4177 8.931545e-01            0  2.250397e+00
      4178 8.334659e-01            0 -7.711200e+00
      4179 2.795396e-01            0 -1.090430e+01
      4180 8.931545e-01            0  2.250397e+00
      4181 8.334659e-01            0 -7.711200e+00
      4182 2.795396e-01            0 -1.090430e+01
      4183 8.931545e-01            0  2.250397e+00
      4184 8.334659e-01            0 -7.711200e+00
      4185 2.795396e-01            0 -1.090430e+01
      4186 4.170922e-01            0 -9.177050e+00
      4187 4.693441e-01            0  2.129443e+01
      4188 3.205562e-01            0  2.064890e+01
      4189 4.170922e-01            0 -9.177050e+00
      4190 4.693441e-01            0  2.129443e+01
      4191 3.205562e-01            0  2.064890e+01
      4192 4.170922e-01            0 -9.177050e+00
      4193 4.693441e-01            0  2.129443e+01
      4194 3.205562e-01            0  2.064890e+01
      4195 4.170922e-01            0 -9.177050e+00
      4196 4.693441e-01            0  2.129443e+01
      4197 3.205562e-01            0  2.064890e+01
      4198 4.170922e-01            0 -9.177050e+00
      4199 4.693441e-01            0  2.129443e+01
      4200 3.205562e-01            0  2.064890e+01
      4201 4.170922e-01            0 -9.177050e+00
      4202 4.693441e-01            0  2.129443e+01
      4203 3.205562e-01            0  2.064890e+01
      4204 4.170922e-01            0 -9.177050e+00
      4205 4.693441e-01            0  2.129443e+01
      4206 3.205562e-01            0  2.064890e+01
      4207 4.170922e-01            0 -9.177050e+00
      4208 4.693441e-01            0  2.129443e+01
      4209 3.205562e-01            0  2.064890e+01
      4210 4.170922e-01            0 -9.177050e+00
      4211 4.693441e-01            0  2.129443e+01
      4212 3.205562e-01            0  2.064890e+01
      4213 4.170922e-01            0 -9.177050e+00
      4214 4.693441e-01            0  2.129443e+01
      4215 3.205562e-01            0  2.064890e+01
      4216 4.170922e-01            0 -9.177050e+00
      4217 4.693441e-01            0  2.129443e+01
      4218 3.205562e-01            0  2.064890e+01
      4219 4.170922e-01            0 -9.177050e+00
      4220 4.693441e-01            0  2.129443e+01
      4221 3.205562e-01            0  2.064890e+01
      4222 8.564830e-01            0 -1.208374e+00
      4223 7.996197e-01            0 -6.324855e+00
      4224 6.427317e-01            0 -7.496653e+00
      4225 8.564830e-01            0 -1.208374e+00
      4226 7.996197e-01            0 -6.324855e+00
      4227 6.427317e-01            0 -7.496653e+00
      4228 8.564830e-01            0 -1.208374e+00
      4229 7.996197e-01            0 -6.324855e+00
      4230 6.427317e-01            0 -7.496653e+00
      4231 8.564830e-01            0 -1.208374e+00
      4232 7.996197e-01            0 -6.324855e+00
      4233 6.427317e-01            0 -7.496653e+00
      4234 8.564830e-01            0 -1.208374e+00
      4235 7.996197e-01            0 -6.324855e+00
      4236 6.427317e-01            0 -7.496653e+00
      4237 8.564830e-01            0 -1.208374e+00
      4238 7.996197e-01            0 -6.324855e+00
      4239 6.427317e-01            0 -7.496653e+00
      4240 8.564830e-01            0 -1.208374e+00
      4241 7.996197e-01            0 -6.324855e+00
      4242 6.427317e-01            0 -7.496653e+00
      4243 8.564830e-01            0 -1.208374e+00
      4244 7.996197e-01            0 -6.324855e+00
      4245 6.427317e-01            0 -7.496653e+00
      4246 8.564830e-01            0 -1.208374e+00
      4247 7.996197e-01            0 -6.324855e+00
      4248 6.427317e-01            0 -7.496653e+00
      4249 8.564830e-01            0 -1.208374e+00
      4250 7.996197e-01            0 -6.324855e+00
      4251 6.427317e-01            0 -7.496653e+00
      4252 8.564830e-01            0 -1.208374e+00
      4253 7.996197e-01            0 -6.324855e+00
      4254 6.427317e-01            0 -7.496653e+00
      4255 8.564830e-01            0 -1.208374e+00
      4256 7.996197e-01            0 -6.324855e+00
      4257 6.427317e-01            0 -7.496653e+00
      4258 8.564830e-01            0 -1.208374e+00
      4259 7.996197e-01            0 -6.324855e+00
      4260 6.427317e-01            0 -7.496653e+00
      4261 8.564830e-01            0 -1.208374e+00
      4262 7.996197e-01            0 -6.324855e+00
      4263 6.427317e-01            0 -7.496653e+00
      4264 8.564830e-01            0 -1.208374e+00
      4265 7.996197e-01            0 -6.324855e+00
      4266 6.427317e-01            0 -7.496653e+00
      4267 5.309292e-01            0 -6.700726e+00
      4268 4.058408e-01            0 -2.316662e+01
      4269 1.301050e-01            0 -2.737638e+01
      4270 5.309292e-01            0 -6.700726e+00
      4271 4.058408e-01            0 -2.316662e+01
      4272 1.301050e-01            0 -2.737638e+01
      4273 5.309292e-01            0 -6.700726e+00
      4274 4.058408e-01            0 -2.316662e+01
      4275 1.301050e-01            0 -2.737638e+01
      4276 5.309292e-01            0 -6.700726e+00
      4277 4.058408e-01            0 -2.316662e+01
      4278 1.301050e-01            0 -2.737638e+01
      4279 5.309292e-01            0 -6.700726e+00
      4280 4.058408e-01            0 -2.316662e+01
      4281 1.301050e-01            0 -2.737638e+01
      4282 5.309292e-01            0 -6.700726e+00
      4283 4.058408e-01            0 -2.316662e+01
      4284 1.301050e-01            0 -2.737638e+01
      4285 5.309292e-01            0 -6.700726e+00
      4286 4.058408e-01            0 -2.316662e+01
      4287 1.301050e-01            0 -2.737638e+01
      4288 5.309292e-01            0 -6.700726e+00
      4289 4.058408e-01            0 -2.316662e+01
      4290 1.301050e-01            0 -2.737638e+01
      4291 5.309292e-01            0 -6.700726e+00
      4292 4.058408e-01            0 -2.316662e+01
      4293 1.301050e-01            0 -2.737638e+01
      4294 5.309292e-01            0 -6.700726e+00
      4295 4.058408e-01            0 -2.316662e+01
      4296 1.301050e-01            0 -2.737638e+01
      4297 5.555100e-01            0  1.636933e+01
      4298 2.745656e-01            0  2.037250e+01
      4299 3.541003e-01            0  2.554339e+01
      4300 5.555100e-01            0  1.636933e+01
      4301 2.745656e-01            0  2.037250e+01
      4302 3.541003e-01            0  2.554339e+01
      4303 5.555100e-01            0  1.636933e+01
      4304 2.745656e-01            0  2.037250e+01
      4305 3.541003e-01            0  2.554339e+01
      4306 5.555100e-01            0  1.636933e+01
      4307 2.745656e-01            0  2.037250e+01
      4308 3.541003e-01            0  2.554339e+01
      4309 5.555100e-01            0  1.636933e+01
      4310 2.745656e-01            0  2.037250e+01
      4311 3.541003e-01            0  2.554339e+01
      4312 5.555100e-01            0  1.636933e+01
      4313 2.745656e-01            0  2.037250e+01
      4314 3.541003e-01            0  2.554339e+01
      4315 5.555100e-01            0  1.636933e+01
      4316 2.745656e-01            0  2.037250e+01
      4317 3.541003e-01            0  2.554339e+01
      4318 5.555100e-01            0  1.636933e+01
      4319 2.745656e-01            0  2.037250e+01
      4320 3.541003e-01            0  2.554339e+01
      4321 5.555100e-01            0  1.636933e+01
      4322 2.745656e-01            0  2.037250e+01
      4323 3.541003e-01            0  2.554339e+01
      4324 1.973014e-01            0 -7.985221e+00
      4325 3.291882e-01            0  1.986896e+01
      4326 3.014168e-01            0  1.733653e+01
      4327 1.973014e-01            0 -7.985221e+00
      4328 3.291882e-01            0  1.986896e+01
      4329 3.014168e-01            0  1.733653e+01
      4330 1.973014e-01            0 -7.985221e+00
      4331 3.291882e-01            0  1.986896e+01
      4332 3.014168e-01            0  1.733653e+01
      4333 1.973014e-01            0 -7.985221e+00
      4334 3.291882e-01            0  1.986896e+01
      4335 3.014168e-01            0  1.733653e+01
      4336 1.973014e-01            0 -7.985221e+00
      4337 3.291882e-01            0  1.986896e+01
      4338 3.014168e-01            0  1.733653e+01
      4339 1.973014e-01            0 -7.985221e+00
      4340 3.291882e-01            0  1.986896e+01
      4341 3.014168e-01            0  1.733653e+01
      4342 1.973014e-01            0 -7.985221e+00
      4343 3.291882e-01            0  1.986896e+01
      4344 3.014168e-01            0  1.733653e+01
      4345 1.973014e-01            0 -7.985221e+00
      4346 3.291882e-01            0  1.986896e+01
      4347 3.014168e-01            0  1.733653e+01
      4348 1.973014e-01            0 -7.985221e+00
      4349 3.291882e-01            0  1.986896e+01
      4350 3.014168e-01            0  1.733653e+01
      4351 1.973014e-01            0 -7.985221e+00
      4352 3.291882e-01            0  1.986896e+01
      4353 3.014168e-01            0  1.733653e+01
      4354 1.973014e-01            0 -7.985221e+00
      4355 3.291882e-01            0  1.986896e+01
      4356 3.014168e-01            0  1.733653e+01
      4357 1.973014e-01            0 -7.985221e+00
      4358 3.291882e-01            0  1.986896e+01
      4359 3.014168e-01            0  1.733653e+01
      4360 1.973014e-01            0 -7.985221e+00
      4361 3.291882e-01            0  1.986896e+01
      4362 3.014168e-01            0  1.733653e+01
      4363 1.973014e-01            0 -7.985221e+00
      4364 3.291882e-01            0  1.986896e+01
      4365 3.014168e-01            0  1.733653e+01
      4366 1.895114e-01            0 -1.358348e+01
      4367 1.501460e-01            0 -1.288820e+01
      4368 1.029933e-02            1 -3.758654e+01
      4369 1.895114e-01            0 -1.358348e+01
      4370 1.501460e-01            0 -1.288820e+01
      4371 1.029933e-02            1 -3.758654e+01
      4372 1.895114e-01            0 -1.358348e+01
      4373 1.501460e-01            0 -1.288820e+01
      4374 1.029933e-02            1 -3.758654e+01
      4375 1.895114e-01            0 -1.358348e+01
      4376 1.501460e-01            0 -1.288820e+01
      4377 1.029933e-02            1 -3.758654e+01
      4378 1.895114e-01            0 -1.358348e+01
      4379 1.501460e-01            0 -1.288820e+01
      4380 1.029933e-02            1 -3.758654e+01
      4381 1.895114e-01            0 -1.358348e+01
      4382 1.501460e-01            0 -1.288820e+01
      4383 1.029933e-02            1 -3.758654e+01
      4384 1.895114e-01            0 -1.358348e+01
      4385 1.501460e-01            0 -1.288820e+01
      4386 1.029933e-02            1 -3.758654e+01
      4387 1.895114e-01            0 -1.358348e+01
      4388 1.501460e-01            0 -1.288820e+01
      4389 1.029933e-02            1 -3.758654e+01
      4390 1.895114e-01            0 -1.358348e+01
      4391 1.501460e-01            0 -1.288820e+01
      4392 1.029933e-02            1 -3.758654e+01
      4393 1.895114e-01            0 -1.358348e+01
      4394 1.501460e-01            0 -1.288820e+01
      4395 1.029933e-02            1 -3.758654e+01
      4396 1.895114e-01            0 -1.358348e+01
      4397 1.501460e-01            0 -1.288820e+01
      4398 1.029933e-02            1 -3.758654e+01
      4399 1.296566e-01            0 -1.053886e+01
      4400 9.201678e-01            0  1.764268e+00
      4401 2.683278e-02            1  3.678228e+01
      4402 1.296566e-01            0 -1.053886e+01
      4403 9.201678e-01            0  1.764268e+00
      4404 2.683278e-02            1  3.678228e+01
      4405 1.296566e-01            0 -1.053886e+01
      4406 9.201678e-01            0  1.764268e+00
      4407 2.683278e-02            1  3.678228e+01
      4408 1.296566e-01            0 -1.053886e+01
      4409 9.201678e-01            0  1.764268e+00
      4410 2.683278e-02            1  3.678228e+01
      4411 1.296566e-01            0 -1.053886e+01
      4412 9.201678e-01            0  1.764268e+00
      4413 2.683278e-02            1  3.678228e+01
      4414 1.296566e-01            0 -1.053886e+01
      4415 9.201678e-01            0  1.764268e+00
      4416 2.683278e-02            1  3.678228e+01
      4417 1.296566e-01            0 -1.053886e+01
      4418 9.201678e-01            0  1.764268e+00
      4419 2.683278e-02            1  3.678228e+01
      4420 1.296566e-01            0 -1.053886e+01
      4421 9.201678e-01            0  1.764268e+00
      4422 2.683278e-02            1  3.678228e+01
      4423 1.296566e-01            0 -1.053886e+01
      4424 9.201678e-01            0  1.764268e+00
      4425 2.683278e-02            1  3.678228e+01
      4426 1.296566e-01            0 -1.053886e+01
      4427 9.201678e-01            0  1.764268e+00
      4428 2.683278e-02            1  3.678228e+01
      4429 1.296566e-01            0 -1.053886e+01
      4430 9.201678e-01            0  1.764268e+00
      4431 2.683278e-02            1  3.678228e+01
      4432 1.296566e-01            0 -1.053886e+01
      4433 9.201678e-01            0  1.764268e+00
      4434 2.683278e-02            1  3.678228e+01
      4435 1.296566e-01            0 -1.053886e+01
      4436 9.201678e-01            0  1.764268e+00
      4437 2.683278e-02            1  3.678228e+01
      4438 1.296566e-01            0 -1.053886e+01
      4439 9.201678e-01            0  1.764268e+00
      4440 2.683278e-02            1  3.678228e+01
      4441 1.296566e-01            0 -1.053886e+01
      4442 9.201678e-01            0  1.764268e+00
      4443 2.683278e-02            1  3.678228e+01
      4444 1.296566e-01            0 -1.053886e+01
      4445 9.201678e-01            0  1.764268e+00
      4446 2.683278e-02            1  3.678228e+01
      4447 1.296566e-01            0 -1.053886e+01
      4448 9.201678e-01            0  1.764268e+00
      4449 2.683278e-02            1  3.678228e+01
      4450 1.296566e-01            0 -1.053886e+01
      4451 9.201678e-01            0  1.764268e+00
      4452 2.683278e-02            1  3.678228e+01
      4453 3.765075e-02            1 -1.582265e+01
      4454 1.248329e-01            0 -2.244749e+01
      4455 9.798353e-01            0 -9.558001e-03
      4456 3.765075e-02            1 -1.582265e+01
      4457 1.248329e-01            0 -2.244749e+01
      4458 9.798353e-01            0 -9.558001e-03
      4459 3.765075e-02            1 -1.582265e+01
      4460 1.248329e-01            0 -2.244749e+01
      4461 9.798353e-01            0 -9.558001e-03
      4462 3.765075e-02            1 -1.582265e+01
      4463 1.248329e-01            0 -2.244749e+01
      4464 9.798353e-01            0 -9.558001e-03
      4465 3.765075e-02            1 -1.582265e+01
      4466 1.248329e-01            0 -2.244749e+01
      4467 9.798353e-01            0 -9.558001e-03
      4468 3.765075e-02            1 -1.582265e+01
      4469 1.248329e-01            0 -2.244749e+01
      4470 9.798353e-01            0 -9.558001e-03
      4471 3.765075e-02            1 -1.582265e+01
      4472 1.248329e-01            0 -2.244749e+01
      4473 9.798353e-01            0 -9.558001e-03
      4474 3.765075e-02            1 -1.582265e+01
      4475 1.248329e-01            0 -2.244749e+01
      4476 9.798353e-01            0 -9.558001e-03
      4477 3.765075e-02            1 -1.582265e+01
      4478 1.248329e-01            0 -2.244749e+01
      4479 9.798353e-01            0 -9.558001e-03
      4480 3.765075e-02            1 -1.582265e+01
      4481 1.248329e-01            0 -2.244749e+01
      4482 9.798353e-01            0 -9.558001e-03
      4483 3.765075e-02            1 -1.582265e+01
      4484 1.248329e-01            0 -2.244749e+01
      4485 9.798353e-01            0 -9.558001e-03
      4486 3.765075e-02            1 -1.582265e+01
      4487 1.248329e-01            0 -2.244749e+01
      4488 9.798353e-01            0 -9.558001e-03
      4489 3.765075e-02            1 -1.582265e+01
      4490 1.248329e-01            0 -2.244749e+01
      4491 9.798353e-01            0 -9.558001e-03
      4492 3.765075e-02            1 -1.582265e+01
      4493 1.248329e-01            0 -2.244749e+01
      4494 9.798353e-01            0 -9.558001e-03
      4495 3.765075e-02            1 -1.582265e+01
      4496 1.248329e-01            0 -2.244749e+01
      4497 9.798353e-01            0 -9.558001e-03
      4498 3.765075e-02            1 -1.582265e+01
      4499 1.248329e-01            0 -2.244749e+01
      4500 9.798353e-01            0 -9.558001e-03
      4501 3.765075e-02            1 -1.582265e+01
      4502 1.248329e-01            0 -2.244749e+01
      4503 9.798353e-01            0 -9.558001e-03
      4504 3.765075e-02            1 -1.582265e+01
      4505 1.248329e-01            0 -2.244749e+01
      4506 9.798353e-01            0 -9.558001e-03
      4507 6.876317e-02            0 -1.468865e+01
      4508 9.732250e-01            0  9.519861e-01
      4509 8.363933e-01            0 -3.180671e+00
      4510 6.876317e-02            0 -1.468865e+01
      4511 9.732250e-01            0  9.519861e-01
      4512 8.363933e-01            0 -3.180671e+00
      4513 6.876317e-02            0 -1.468865e+01
      4514 9.732250e-01            0  9.519861e-01
      4515 8.363933e-01            0 -3.180671e+00
      4516 6.876317e-02            0 -1.468865e+01
      4517 9.732250e-01            0  9.519861e-01
      4518 8.363933e-01            0 -3.180671e+00
      4519 6.876317e-02            0 -1.468865e+01
      4520 9.732250e-01            0  9.519861e-01
      4521 8.363933e-01            0 -3.180671e+00
      4522 6.876317e-02            0 -1.468865e+01
      4523 9.732250e-01            0  9.519861e-01
      4524 8.363933e-01            0 -3.180671e+00
      4525 6.876317e-02            0 -1.468865e+01
      4526 9.732250e-01            0  9.519861e-01
      4527 8.363933e-01            0 -3.180671e+00
      4528 6.876317e-02            0 -1.468865e+01
      4529 9.732250e-01            0  9.519861e-01
      4530 8.363933e-01            0 -3.180671e+00
      4531 6.876317e-02            0 -1.468865e+01
      4532 9.732250e-01            0  9.519861e-01
      4533 8.363933e-01            0 -3.180671e+00
      4534 6.876317e-02            0 -1.468865e+01
      4535 9.732250e-01            0  9.519861e-01
      4536 8.363933e-01            0 -3.180671e+00
      4537 6.876317e-02            0 -1.468865e+01
      4538 9.732250e-01            0  9.519861e-01
      4539 8.363933e-01            0 -3.180671e+00
      4540 6.876317e-02            0 -1.468865e+01
      4541 9.732250e-01            0  9.519861e-01
      4542 8.363933e-01            0 -3.180671e+00
      4543 6.876317e-02            0 -1.468865e+01
      4544 9.732250e-01            0  9.519861e-01
      4545 8.363933e-01            0 -3.180671e+00
      4546 3.751866e-01            0 -6.583811e+00
      4547 2.649787e-01            0  1.505234e+01
      4548 9.698647e-01            0 -3.445318e-01
      4549 3.751866e-01            0 -6.583811e+00
      4550 2.649787e-01            0  1.505234e+01
      4551 9.698647e-01            0 -3.445318e-01
      4552 3.751866e-01            0 -6.583811e+00
      4553 2.649787e-01            0  1.505234e+01
      4554 9.698647e-01            0 -3.445318e-01
      4555 3.751866e-01            0 -6.583811e+00
      4556 2.649787e-01            0  1.505234e+01
      4557 9.698647e-01            0 -3.445318e-01
      4558 3.751866e-01            0 -6.583811e+00
      4559 2.649787e-01            0  1.505234e+01
      4560 9.698647e-01            0 -3.445318e-01
      4561 3.751866e-01            0 -6.583811e+00
      4562 2.649787e-01            0  1.505234e+01
      4563 9.698647e-01            0 -3.445318e-01
      4564 3.751866e-01            0 -6.583811e+00
      4565 2.649787e-01            0  1.505234e+01
      4566 9.698647e-01            0 -3.445318e-01
      4567 3.751866e-01            0 -6.583811e+00
      4568 2.649787e-01            0  1.505234e+01
      4569 9.698647e-01            0 -3.445318e-01
      4570 3.751866e-01            0 -6.583811e+00
      4571 2.649787e-01            0  1.505234e+01
      4572 9.698647e-01            0 -3.445318e-01
      4573 3.751866e-01            0 -6.583811e+00
      4574 2.649787e-01            0  1.505234e+01
      4575 9.698647e-01            0 -3.445318e-01
      4576 5.089144e-01            0 -6.343656e+01
      4577 9.059482e-01            0 -4.491549e+00
      4578 2.281207e-01            0 -8.730193e+01
      4579 5.089144e-01            0 -6.343656e+01
      4580 9.059482e-01            0 -4.491549e+00
      4581 2.281207e-01            0 -8.730193e+01
      4582 5.089144e-01            0 -6.343656e+01
      4583 9.059482e-01            0 -4.491549e+00
      4584 2.281207e-01            0 -8.730193e+01
      4585 8.854939e-01            0 -1.511192e+00
      4586 5.964024e-02            0 -4.390238e+01
      4587 3.113577e-01            0 -1.892701e+01
      4588 8.854939e-01            0 -1.511192e+00
      4589 5.964024e-02            0 -4.390238e+01
      4590 3.113577e-01            0 -1.892701e+01
      4591 8.854939e-01            0 -1.511192e+00
      4592 5.964024e-02            0 -4.390238e+01
      4593 3.113577e-01            0 -1.892701e+01
      4594 8.854939e-01            0 -1.511192e+00
      4595 5.964024e-02            0 -4.390238e+01
      4596 3.113577e-01            0 -1.892701e+01
      4597 8.854939e-01            0 -1.511192e+00
      4598 5.964024e-02            0 -4.390238e+01
      4599 3.113577e-01            0 -1.892701e+01
      4600 8.854939e-01            0 -1.511192e+00
      4601 5.964024e-02            0 -4.390238e+01
      4602 3.113577e-01            0 -1.892701e+01
      4603 8.854939e-01            0 -1.511192e+00
      4604 5.964024e-02            0 -4.390238e+01
      4605 3.113577e-01            0 -1.892701e+01
      4606 8.854939e-01            0 -1.511192e+00
      4607 5.964024e-02            0 -4.390238e+01
      4608 3.113577e-01            0 -1.892701e+01
      4609 1.296157e-01            0 -1.483163e+01
      4610 7.550114e-01            0 -1.107125e+01
      4611 9.061950e-01            0  3.381195e+00
      4612 1.296157e-01            0 -1.483163e+01
      4613 7.550114e-01            0 -1.107125e+01
      4614 9.061950e-01            0  3.381195e+00
      4615 1.296157e-01            0 -1.483163e+01
      4616 7.550114e-01            0 -1.107125e+01
      4617 9.061950e-01            0  3.381195e+00
      4618 1.296157e-01            0 -1.483163e+01
      4619 7.550114e-01            0 -1.107125e+01
      4620 9.061950e-01            0  3.381195e+00
      4621 1.296157e-01            0 -1.483163e+01
      4622 7.550114e-01            0 -1.107125e+01
      4623 9.061950e-01            0  3.381195e+00
      4624 1.296157e-01            0 -1.483163e+01
      4625 7.550114e-01            0 -1.107125e+01
      4626 9.061950e-01            0  3.381195e+00
      4627 1.296157e-01            0 -1.483163e+01
      4628 7.550114e-01            0 -1.107125e+01
      4629 9.061950e-01            0  3.381195e+00
      4630 1.296157e-01            0 -1.483163e+01
      4631 7.550114e-01            0 -1.107125e+01
      4632 9.061950e-01            0  3.381195e+00
      4633 3.932346e-01            0 -6.151880e+00
      4634 1.702713e-01            0  3.537774e+01
      4635 5.799313e-01            0  1.474914e+01
      4636 3.932346e-01            0 -6.151880e+00
      4637 1.702713e-01            0  3.537774e+01
      4638 5.799313e-01            0  1.474914e+01
      4639 3.932346e-01            0 -6.151880e+00
      4640 1.702713e-01            0  3.537774e+01
      4641 5.799313e-01            0  1.474914e+01
      4642 3.932346e-01            0 -6.151880e+00
      4643 1.702713e-01            0  3.537774e+01
      4644 5.799313e-01            0  1.474914e+01
      4645 3.932346e-01            0 -6.151880e+00
      4646 1.702713e-01            0  3.537774e+01
      4647 5.799313e-01            0  1.474914e+01
      4648 3.932346e-01            0 -6.151880e+00
      4649 1.702713e-01            0  3.537774e+01
      4650 5.799313e-01            0  1.474914e+01
      4651 3.932346e-01            0 -6.151880e+00
      4652 1.702713e-01            0  3.537774e+01
      4653 5.799313e-01            0  1.474914e+01
      4654 3.932346e-01            0 -6.151880e+00
      4655 1.702713e-01            0  3.537774e+01
      4656 5.799313e-01            0  1.474914e+01
      4657 3.932346e-01            0 -6.151880e+00
      4658 1.702713e-01            0  3.537774e+01
      4659 5.799313e-01            0  1.474914e+01
      4660 3.932346e-01            0 -6.151880e+00
      4661 1.702713e-01            0  3.537774e+01
      4662 5.799313e-01            0  1.474914e+01
      4663 3.932346e-01            0 -6.151880e+00
      4664 1.702713e-01            0  3.537774e+01
      4665 5.799313e-01            0  1.474914e+01
      4666 9.565173e-01            0 -1.732132e-02
      4667 9.358310e-01            0 -8.411879e-01
      4668 2.521532e-01            0 -2.843835e+01
      4669 9.565173e-01            0 -1.732132e-02
      4670 9.358310e-01            0 -8.411879e-01
      4671 2.521532e-01            0 -2.843835e+01
      4672 9.565173e-01            0 -1.732132e-02
      4673 9.358310e-01            0 -8.411879e-01
      4674 2.521532e-01            0 -2.843835e+01
      4675 9.565173e-01            0 -1.732132e-02
      4676 9.358310e-01            0 -8.411879e-01
      4677 2.521532e-01            0 -2.843835e+01
      4678 9.565173e-01            0 -1.732132e-02
      4679 9.358310e-01            0 -8.411879e-01
      4680 2.521532e-01            0 -2.843835e+01
      4681 9.565173e-01            0 -1.732132e-02
      4682 9.358310e-01            0 -8.411879e-01
      4683 2.521532e-01            0 -2.843835e+01
      4684 9.565173e-01            0 -1.732132e-02
      4685 9.358310e-01            0 -8.411879e-01
      4686 2.521532e-01            0 -2.843835e+01
      4687 9.565173e-01            0 -1.732132e-02
      4688 9.358310e-01            0 -8.411879e-01
      4689 2.521532e-01            0 -2.843835e+01
      4690 9.565173e-01            0 -1.732132e-02
      4691 9.358310e-01            0 -8.411879e-01
      4692 2.521532e-01            0 -2.843835e+01
      4693 9.565173e-01            0 -1.732132e-02
      4694 9.358310e-01            0 -8.411879e-01
      4695 2.521532e-01            0 -2.843835e+01
      4696 9.565173e-01            0 -1.732132e-02
      4697 9.358310e-01            0 -8.411879e-01
      4698 2.521532e-01            0 -2.843835e+01
      4699 9.221469e-01            0  1.430131e+00
      4700 1.338812e-01            0  1.396205e+01
      4701 8.879199e-01            0  3.081316e+00
      4702 9.221469e-01            0  1.430131e+00
      4703 1.338812e-01            0  1.396205e+01
      4704 8.879199e-01            0  3.081316e+00
      4705 9.221469e-01            0  1.430131e+00
      4706 1.338812e-01            0  1.396205e+01
      4707 8.879199e-01            0  3.081316e+00
      4708 9.221469e-01            0  1.430131e+00
      4709 1.338812e-01            0  1.396205e+01
      4710 8.879199e-01            0  3.081316e+00
      4711 9.221469e-01            0  1.430131e+00
      4712 1.338812e-01            0  1.396205e+01
      4713 8.879199e-01            0  3.081316e+00
      4714 9.221469e-01            0  1.430131e+00
      4715 1.338812e-01            0  1.396205e+01
      4716 8.879199e-01            0  3.081316e+00
      4717 9.221469e-01            0  1.430131e+00
      4718 1.338812e-01            0  1.396205e+01
      4719 8.879199e-01            0  3.081316e+00
      4720 9.221469e-01            0  1.430131e+00
      4721 1.338812e-01            0  1.396205e+01
      4722 8.879199e-01            0  3.081316e+00
      4723 9.221469e-01            0  1.430131e+00
      4724 1.338812e-01            0  1.396205e+01
      4725 8.879199e-01            0  3.081316e+00
      4726 9.221469e-01            0  1.430131e+00
      4727 1.338812e-01            0  1.396205e+01
      4728 8.879199e-01            0  3.081316e+00
      4729 9.221469e-01            0  1.430131e+00
      4730 1.338812e-01            0  1.396205e+01
      4731 8.879199e-01            0  3.081316e+00
      4732 9.221469e-01            0  1.430131e+00
      4733 1.338812e-01            0  1.396205e+01
      4734 8.879199e-01            0  3.081316e+00
      4735 9.221469e-01            0  1.430131e+00
      4736 1.338812e-01            0  1.396205e+01
      4737 8.879199e-01            0  3.081316e+00
      4738 9.221469e-01            0  1.430131e+00
      4739 1.338812e-01            0  1.396205e+01
      4740 8.879199e-01            0  3.081316e+00
      4741 8.267763e-01            0 -1.362607e+00
      4742 4.162608e-01            0  3.661395e+00
      4743 8.798414e-01            0 -1.966104e+00
      4744 8.267763e-01            0 -1.362607e+00
      4745 4.162608e-01            0  3.661395e+00
      4746 8.798414e-01            0 -1.966104e+00
      4747 8.267763e-01            0 -1.362607e+00
      4748 4.162608e-01            0  3.661395e+00
      4749 8.798414e-01            0 -1.966104e+00
      4750 8.267763e-01            0 -1.362607e+00
      4751 4.162608e-01            0  3.661395e+00
      4752 8.798414e-01            0 -1.966104e+00
      4753 8.267763e-01            0 -1.362607e+00
      4754 4.162608e-01            0  3.661395e+00
      4755 8.798414e-01            0 -1.966104e+00
      4756 8.267763e-01            0 -1.362607e+00
      4757 4.162608e-01            0  3.661395e+00
      4758 8.798414e-01            0 -1.966104e+00
      4759 8.267763e-01            0 -1.362607e+00
      4760 4.162608e-01            0  3.661395e+00
      4761 8.798414e-01            0 -1.966104e+00
      4762 8.267763e-01            0 -1.362607e+00
      4763 4.162608e-01            0  3.661395e+00
      4764 8.798414e-01            0 -1.966104e+00
      4765 8.267763e-01            0 -1.362607e+00
      4766 4.162608e-01            0  3.661395e+00
      4767 8.798414e-01            0 -1.966104e+00
      4768 8.267763e-01            0 -1.362607e+00
      4769 4.162608e-01            0  3.661395e+00
      4770 8.798414e-01            0 -1.966104e+00
      4771 8.267763e-01            0 -1.362607e+00
      4772 4.162608e-01            0  3.661395e+00
      4773 8.798414e-01            0 -1.966104e+00
      4774 8.267763e-01            0 -1.362607e+00
      4775 4.162608e-01            0  3.661395e+00
      4776 8.798414e-01            0 -1.966104e+00
      4777 8.267763e-01            0 -1.362607e+00
      4778 4.162608e-01            0  3.661395e+00
      4779 8.798414e-01            0 -1.966104e+00
      4780 8.267763e-01            0 -1.362607e+00
      4781 4.162608e-01            0  3.661395e+00
      4782 8.798414e-01            0 -1.966104e+00
      4783 8.267763e-01            0 -1.362607e+00
      4784 4.162608e-01            0  3.661395e+00
      4785 8.798414e-01            0 -1.966104e+00
      4786 8.267763e-01            0 -1.362607e+00
      4787 4.162608e-01            0  3.661395e+00
      4788 8.798414e-01            0 -1.966104e+00
      4789 7.888001e-01            0 -2.463692e+00
      4790 4.124231e-01            0  7.468559e+00
      4791 1.659898e-01            0 -2.372142e+01
      4792 7.888001e-01            0 -2.463692e+00
      4793 4.124231e-01            0  7.468559e+00
      4794 1.659898e-01            0 -2.372142e+01
      4795 7.888001e-01            0 -2.463692e+00
      4796 4.124231e-01            0  7.468559e+00
      4797 1.659898e-01            0 -2.372142e+01
      4798 7.888001e-01            0 -2.463692e+00
      4799 4.124231e-01            0  7.468559e+00
      4800 1.659898e-01            0 -2.372142e+01
      4801 7.888001e-01            0 -2.463692e+00
      4802 4.124231e-01            0  7.468559e+00
      4803 1.659898e-01            0 -2.372142e+01
      4804 7.888001e-01            0 -2.463692e+00
      4805 4.124231e-01            0  7.468559e+00
      4806 1.659898e-01            0 -2.372142e+01
      4807 7.888001e-01            0 -2.463692e+00
      4808 4.124231e-01            0  7.468559e+00
      4809 1.659898e-01            0 -2.372142e+01
      4810 7.888001e-01            0 -2.463692e+00
      4811 4.124231e-01            0  7.468559e+00
      4812 1.659898e-01            0 -2.372142e+01
      4813 7.888001e-01            0 -2.463692e+00
      4814 4.124231e-01            0  7.468559e+00
      4815 1.659898e-01            0 -2.372142e+01
      4816 7.888001e-01            0 -2.463692e+00
      4817 4.124231e-01            0  7.468559e+00
      4818 1.659898e-01            0 -2.372142e+01
      4819 7.888001e-01            0 -2.463692e+00
      4820 4.124231e-01            0  7.468559e+00
      4821 1.659898e-01            0 -2.372142e+01
      4822 7.888001e-01            0 -2.463692e+00
      4823 4.124231e-01            0  7.468559e+00
      4824 1.659898e-01            0 -2.372142e+01
      4825 7.888001e-01            0 -2.463692e+00
      4826 4.124231e-01            0  7.468559e+00
      4827 1.659898e-01            0 -2.372142e+01
      4828 7.888001e-01            0 -2.463692e+00
      4829 4.124231e-01            0  7.468559e+00
      4830 1.659898e-01            0 -2.372142e+01
      4831 7.888001e-01            0 -2.463692e+00
      4832 4.124231e-01            0  7.468559e+00
      4833 1.659898e-01            0 -2.372142e+01
      4834 2.808760e-01            0  1.386083e+01
      4835 4.027415e-01            0  4.204487e+00
      4836 9.367080e-01            0  3.258904e+00
      4837 2.808760e-01            0  1.386083e+01
      4838 4.027415e-01            0  4.204487e+00
      4839 9.367080e-01            0  3.258904e+00
      4840 2.808760e-01            0  1.386083e+01
      4841 4.027415e-01            0  4.204487e+00
      4842 9.367080e-01            0  3.258904e+00
      4843 2.808760e-01            0  1.386083e+01
      4844 4.027415e-01            0  4.204487e+00
      4845 9.367080e-01            0  3.258904e+00
      4846 2.808760e-01            0  1.386083e+01
      4847 4.027415e-01            0  4.204487e+00
      4848 9.367080e-01            0  3.258904e+00
      4849 2.808760e-01            0  1.386083e+01
      4850 4.027415e-01            0  4.204487e+00
      4851 9.367080e-01            0  3.258904e+00
      4852 2.808760e-01            0  1.386083e+01
      4853 4.027415e-01            0  4.204487e+00
      4854 9.367080e-01            0  3.258904e+00
      4855 2.808760e-01            0  1.386083e+01
      4856 4.027415e-01            0  4.204487e+00
      4857 9.367080e-01            0  3.258904e+00
      4858 2.808760e-01            0  1.386083e+01
      4859 4.027415e-01            0  4.204487e+00
      4860 9.367080e-01            0  3.258904e+00
      4861 2.808760e-01            0  1.386083e+01
      4862 4.027415e-01            0  4.204487e+00
      4863 9.367080e-01            0  3.258904e+00
      4864 2.808760e-01            0  1.386083e+01
      4865 4.027415e-01            0  4.204487e+00
      4866 9.367080e-01            0  3.258904e+00
      4867 1.348197e-01            0  2.794036e+01
      4868 5.511187e-01            0  1.169924e+01
      4869 7.416407e-01            0 -5.615747e+00
      4870 1.348197e-01            0  2.794036e+01
      4871 5.511187e-01            0  1.169924e+01
      4872 7.416407e-01            0 -5.615747e+00
      4873 1.348197e-01            0  2.794036e+01
      4874 5.511187e-01            0  1.169924e+01
      4875 7.416407e-01            0 -5.615747e+00
      4876 1.348197e-01            0  2.794036e+01
      4877 5.511187e-01            0  1.169924e+01
      4878 7.416407e-01            0 -5.615747e+00
      4879 1.348197e-01            0  2.794036e+01
      4880 5.511187e-01            0  1.169924e+01
      4881 7.416407e-01            0 -5.615747e+00
      4882 1.348197e-01            0  2.794036e+01
      4883 5.511187e-01            0  1.169924e+01
      4884 7.416407e-01            0 -5.615747e+00
      4885 1.348197e-01            0  2.794036e+01
      4886 5.511187e-01            0  1.169924e+01
      4887 7.416407e-01            0 -5.615747e+00
      4888 1.529530e-01            0 -1.381294e+01
      4889 1.594204e-01            0 -1.057249e+01
      4890 1.547874e-01            0 -2.350384e+01
      4891 1.529530e-01            0 -1.381294e+01
      4892 1.594204e-01            0 -1.057249e+01
      4893 1.547874e-01            0 -2.350384e+01
      4894 1.529530e-01            0 -1.381294e+01
      4895 1.594204e-01            0 -1.057249e+01
      4896 1.547874e-01            0 -2.350384e+01
      4897 1.529530e-01            0 -1.381294e+01
      4898 1.594204e-01            0 -1.057249e+01
      4899 1.547874e-01            0 -2.350384e+01
      4900 1.529530e-01            0 -1.381294e+01
      4901 1.594204e-01            0 -1.057249e+01
      4902 1.547874e-01            0 -2.350384e+01
      4903 1.529530e-01            0 -1.381294e+01
      4904 1.594204e-01            0 -1.057249e+01
      4905 1.547874e-01            0 -2.350384e+01
      4906 1.529530e-01            0 -1.381294e+01
      4907 1.594204e-01            0 -1.057249e+01
      4908 1.547874e-01            0 -2.350384e+01
      4909 8.355915e-01            0 -1.429245e+00
      4910 9.126836e-01            0 -2.250325e+00
      4911 5.612830e-01            0  9.335048e+00
      4912 8.355915e-01            0 -1.429245e+00
      4913 9.126836e-01            0 -2.250325e+00
      4914 5.612830e-01            0  9.335048e+00
      4915 8.355915e-01            0 -1.429245e+00
      4916 9.126836e-01            0 -2.250325e+00
      4917 5.612830e-01            0  9.335048e+00
      4918 8.355915e-01            0 -1.429245e+00
      4919 9.126836e-01            0 -2.250325e+00
      4920 5.612830e-01            0  9.335048e+00
      4921 8.355915e-01            0 -1.429245e+00
      4922 9.126836e-01            0 -2.250325e+00
      4923 5.612830e-01            0  9.335048e+00
      4924 8.355915e-01            0 -1.429245e+00
      4925 9.126836e-01            0 -2.250325e+00
      4926 5.612830e-01            0  9.335048e+00
      4927 8.355915e-01            0 -1.429245e+00
      4928 9.126836e-01            0 -2.250325e+00
      4929 5.612830e-01            0  9.335048e+00
      4930 8.355915e-01            0 -1.429245e+00
      4931 9.126836e-01            0 -2.250325e+00
      4932 5.612830e-01            0  9.335048e+00
      4933 8.355915e-01            0 -1.429245e+00
      4934 9.126836e-01            0 -2.250325e+00
      4935 5.612830e-01            0  9.335048e+00
      4936 8.355915e-01            0 -1.429245e+00
      4937 9.126836e-01            0 -2.250325e+00
      4938 5.612830e-01            0  9.335048e+00
      4939 8.355915e-01            0 -1.429245e+00
      4940 9.126836e-01            0 -2.250325e+00
      4941 5.612830e-01            0  9.335048e+00
      4942 1.176820e-01            0 -1.706443e+01
      4943 5.235485e-01            0  1.596632e+01
      4944 1.642094e-01            0 -1.639105e+01
      4945 1.176820e-01            0 -1.706443e+01
      4946 5.235485e-01            0  1.596632e+01
      4947 1.642094e-01            0 -1.639105e+01
      4948 1.176820e-01            0 -1.706443e+01
      4949 5.235485e-01            0  1.596632e+01
      4950 1.642094e-01            0 -1.639105e+01
      4951 1.176820e-01            0 -1.706443e+01
      4952 5.235485e-01            0  1.596632e+01
      4953 1.642094e-01            0 -1.639105e+01
      4954 1.176820e-01            0 -1.706443e+01
      4955 5.235485e-01            0  1.596632e+01
      4956 1.642094e-01            0 -1.639105e+01
      4957 1.176820e-01            0 -1.706443e+01
      4958 5.235485e-01            0  1.596632e+01
      4959 1.642094e-01            0 -1.639105e+01
      4960 1.176820e-01            0 -1.706443e+01
      4961 5.235485e-01            0  1.596632e+01
      4962 1.642094e-01            0 -1.639105e+01
      4963 1.176820e-01            0 -1.706443e+01
      4964 5.235485e-01            0  1.596632e+01
      4965 1.642094e-01            0 -1.639105e+01
      4966 1.176820e-01            0 -1.706443e+01
      4967 5.235485e-01            0  1.596632e+01
      4968 1.642094e-01            0 -1.639105e+01
      4969 1.176820e-01            0 -1.706443e+01
      4970 5.235485e-01            0  1.596632e+01
      4971 1.642094e-01            0 -1.639105e+01
      4972 1.176820e-01            0 -1.706443e+01
      4973 5.235485e-01            0  1.596632e+01
      4974 1.642094e-01            0 -1.639105e+01
      4975 2.888320e-01            0 -1.605552e+01
      4976 6.092055e-01            0 -8.434363e+00
      4977 8.712603e-01            0 -1.033393e+01
      4978 2.888320e-01            0 -1.605552e+01
      4979 6.092055e-01            0 -8.434363e+00
      4980 8.712603e-01            0 -1.033393e+01
      4981 2.888320e-01            0 -1.605552e+01
      4982 6.092055e-01            0 -8.434363e+00
      4983 8.712603e-01            0 -1.033393e+01
      4984 2.632918e-01            0 -1.251936e+01
      4985 2.852851e-01            0 -4.140151e+01
      4986 2.792567e-01            0 -2.851416e+01
      4987 2.632918e-01            0 -1.251936e+01
      4988 2.852851e-01            0 -4.140151e+01
      4989 2.792567e-01            0 -2.851416e+01
      4990 2.632918e-01            0 -1.251936e+01
      4991 2.852851e-01            0 -4.140151e+01
      4992 2.792567e-01            0 -2.851416e+01
      4993 2.632918e-01            0 -1.251936e+01
      4994 2.852851e-01            0 -4.140151e+01
      4995 2.792567e-01            0 -2.851416e+01
      4996 2.632918e-01            0 -1.251936e+01
      4997 2.852851e-01            0 -4.140151e+01
      4998 2.792567e-01            0 -2.851416e+01
      4999 2.632918e-01            0 -1.251936e+01
      5000 2.852851e-01            0 -4.140151e+01
      5001 2.792567e-01            0 -2.851416e+01
      5002 2.632918e-01            0 -1.251936e+01
      5003 2.852851e-01            0 -4.140151e+01
      5004 2.792567e-01            0 -2.851416e+01
      5005 2.632918e-01            0 -1.251936e+01
      5006 2.852851e-01            0 -4.140151e+01
      5007 2.792567e-01            0 -2.851416e+01
      5008 2.632918e-01            0 -1.251936e+01
      5009 2.852851e-01            0 -4.140151e+01
      5010 2.792567e-01            0 -2.851416e+01
      5011 2.632918e-01            0 -1.251936e+01
      5012 2.852851e-01            0 -4.140151e+01
      5013 2.792567e-01            0 -2.851416e+01
      5014 2.632918e-01            0 -1.251936e+01
      5015 2.852851e-01            0 -4.140151e+01
      5016 2.792567e-01            0 -2.851416e+01
      5017 1.376697e-01            0 -2.523322e+01
      5018 6.339815e-01            0 -5.904279e+00
      5019 3.882312e-01            0 -2.983585e+01
      5020 1.376697e-01            0 -2.523322e+01
      5021 6.339815e-01            0 -5.904279e+00
      5022 3.882312e-01            0 -2.983585e+01
      5023 1.376697e-01            0 -2.523322e+01
      5024 6.339815e-01            0 -5.904279e+00
      5025 3.882312e-01            0 -2.983585e+01
      5026 1.376697e-01            0 -2.523322e+01
      5027 6.339815e-01            0 -5.904279e+00
      5028 3.882312e-01            0 -2.983585e+01
      5029 1.376697e-01            0 -2.523322e+01
      5030 6.339815e-01            0 -5.904279e+00
      5031 3.882312e-01            0 -2.983585e+01
      5032 1.376697e-01            0 -2.523322e+01
      5033 6.339815e-01            0 -5.904279e+00
      5034 3.882312e-01            0 -2.983585e+01
      5035 1.376697e-01            0 -2.523322e+01
      5036 6.339815e-01            0 -5.904279e+00
      5037 3.882312e-01            0 -2.983585e+01
      5038 1.376697e-01            0 -2.523322e+01
      5039 6.339815e-01            0 -5.904279e+00
      5040 3.882312e-01            0 -2.983585e+01
      5041 9.029285e-01            0  1.811027e+00
      5042 6.200118e-01            0  3.974985e+00
      5043 7.391180e-01            0 -3.856770e+00
      5044 9.029285e-01            0  1.811027e+00
      5045 6.200118e-01            0  3.974985e+00
      5046 7.391180e-01            0 -3.856770e+00
      5047 9.029285e-01            0  1.811027e+00
      5048 6.200118e-01            0  3.974985e+00
      5049 7.391180e-01            0 -3.856770e+00
      5050 9.029285e-01            0  1.811027e+00
      5051 6.200118e-01            0  3.974985e+00
      5052 7.391180e-01            0 -3.856770e+00
      5053 9.029285e-01            0  1.811027e+00
      5054 6.200118e-01            0  3.974985e+00
      5055 7.391180e-01            0 -3.856770e+00
      5056 9.029285e-01            0  1.811027e+00
      5057 6.200118e-01            0  3.974985e+00
      5058 7.391180e-01            0 -3.856770e+00
      5059 9.029285e-01            0  1.811027e+00
      5060 6.200118e-01            0  3.974985e+00
      5061 7.391180e-01            0 -3.856770e+00
      5062 9.029285e-01            0  1.811027e+00
      5063 6.200118e-01            0  3.974985e+00
      5064 7.391180e-01            0 -3.856770e+00
      5065 9.029285e-01            0  1.811027e+00
      5066 6.200118e-01            0  3.974985e+00
      5067 7.391180e-01            0 -3.856770e+00
      5068 6.607557e-01            0 -6.790277e+00
      5069 5.155577e-01            0 -2.741504e+01
      5070 7.580512e-01            0 -1.070280e+01
      5071 6.607557e-01            0 -6.790277e+00
      5072 5.155577e-01            0 -2.741504e+01
      5073 7.580512e-01            0 -1.070280e+01
      5074 6.607557e-01            0 -6.790277e+00
      5075 5.155577e-01            0 -2.741504e+01
      5076 7.580512e-01            0 -1.070280e+01
      5077 6.607557e-01            0 -6.790277e+00
      5078 5.155577e-01            0 -2.741504e+01
      5079 7.580512e-01            0 -1.070280e+01
      5080 6.607557e-01            0 -6.790277e+00
      5081 5.155577e-01            0 -2.741504e+01
      5082 7.580512e-01            0 -1.070280e+01
      5083 6.607557e-01            0 -6.790277e+00
      5084 5.155577e-01            0 -2.741504e+01
      5085 7.580512e-01            0 -1.070280e+01
      5086 2.485210e-01            0 -1.790842e+01
      5087 9.150969e-04            1 -1.030088e+02
      5088 2.524631e-01            0 -2.320844e+01
      5089 2.485210e-01            0 -1.790842e+01
      5090 9.150969e-04            1 -1.030088e+02
      5091 2.524631e-01            0 -2.320844e+01
      5092 2.485210e-01            0 -1.790842e+01
      5093 9.150969e-04            1 -1.030088e+02
      5094 2.524631e-01            0 -2.320844e+01
      5095 2.485210e-01            0 -1.790842e+01
      5096 9.150969e-04            1 -1.030088e+02
      5097 2.524631e-01            0 -2.320844e+01
      5098 2.485210e-01            0 -1.790842e+01
      5099 9.150969e-04            1 -1.030088e+02
      5100 2.524631e-01            0 -2.320844e+01
      5101 5.323376e-01            0  7.287837e+00
      5102 8.919089e-01            0 -2.973512e+00
      5103 8.002203e-01            0 -5.015080e+00
      5104 5.323376e-01            0  7.287837e+00
      5105 8.919089e-01            0 -2.973512e+00
      5106 8.002203e-01            0 -5.015080e+00
      5107 5.323376e-01            0  7.287837e+00
      5108 8.919089e-01            0 -2.973512e+00
      5109 8.002203e-01            0 -5.015080e+00
      5110 5.323376e-01            0  7.287837e+00
      5111 8.919089e-01            0 -2.973512e+00
      5112 8.002203e-01            0 -5.015080e+00
      5113 5.323376e-01            0  7.287837e+00
      5114 8.919089e-01            0 -2.973512e+00
      5115 8.002203e-01            0 -5.015080e+00
      5116 5.323376e-01            0  7.287837e+00
      5117 8.919089e-01            0 -2.973512e+00
      5118 8.002203e-01            0 -5.015080e+00
      5119 5.323376e-01            0  7.287837e+00
      5120 8.919089e-01            0 -2.973512e+00
      5121 8.002203e-01            0 -5.015080e+00
      5122 5.323376e-01            0  7.287837e+00
      5123 8.919089e-01            0 -2.973512e+00
      5124 8.002203e-01            0 -5.015080e+00
      5125 5.323376e-01            0  7.287837e+00
      5126 8.919089e-01            0 -2.973512e+00
      5127 8.002203e-01            0 -5.015080e+00
      5128 3.928072e-01            0 -1.333655e+01
      5129 9.923116e-01            0  2.211884e-01
      5130 9.375278e-01            0  2.469282e+00
      5131 3.928072e-01            0 -1.333655e+01
      5132 9.923116e-01            0  2.211884e-01
      5133 9.375278e-01            0  2.469282e+00
      5134 3.928072e-01            0 -1.333655e+01
      5135 9.923116e-01            0  2.211884e-01
      5136 9.375278e-01            0  2.469282e+00
      5137 3.928072e-01            0 -1.333655e+01
      5138 9.923116e-01            0  2.211884e-01
      5139 9.375278e-01            0  2.469282e+00
      5140 3.928072e-01            0 -1.333655e+01
      5141 9.923116e-01            0  2.211884e-01
      5142 9.375278e-01            0  2.469282e+00
      5143 3.928072e-01            0 -1.333655e+01
      5144 9.923116e-01            0  2.211884e-01
      5145 9.375278e-01            0  2.469282e+00
      5146 3.928072e-01            0 -1.333655e+01
      5147 9.923116e-01            0  2.211884e-01
      5148 9.375278e-01            0  2.469282e+00
      5149 3.928072e-01            0 -1.333655e+01
      5150 9.923116e-01            0  2.211884e-01
      5151 9.375278e-01            0  2.469282e+00
      5152 5.674846e-01            0  5.552807e+00
      5153 9.147262e-01            0  2.816637e+00
      5154 6.185370e-02            0  3.229633e+01
      5155 5.674846e-01            0  5.552807e+00
      5156 9.147262e-01            0  2.816637e+00
      5157 6.185370e-02            0  3.229633e+01
      5158 5.674846e-01            0  5.552807e+00
      5159 9.147262e-01            0  2.816637e+00
      5160 6.185370e-02            0  3.229633e+01
      5161 5.674846e-01            0  5.552807e+00
      5162 9.147262e-01            0  2.816637e+00
      5163 6.185370e-02            0  3.229633e+01
      5164 5.674846e-01            0  5.552807e+00
      5165 9.147262e-01            0  2.816637e+00
      5166 6.185370e-02            0  3.229633e+01
      5167 5.674846e-01            0  5.552807e+00
      5168 9.147262e-01            0  2.816637e+00
      5169 6.185370e-02            0  3.229633e+01
      5170 5.674846e-01            0  5.552807e+00
      5171 9.147262e-01            0  2.816637e+00
      5172 6.185370e-02            0  3.229633e+01
      5173 5.674846e-01            0  5.552807e+00
      5174 9.147262e-01            0  2.816637e+00
      5175 6.185370e-02            0  3.229633e+01
      5176 5.674846e-01            0  5.552807e+00
      5177 9.147262e-01            0  2.816637e+00
      5178 6.185370e-02            0  3.229633e+01
      5179 5.674846e-01            0  5.552807e+00
      5180 9.147262e-01            0  2.816637e+00
      5181 6.185370e-02            0  3.229633e+01
      5182 3.764074e-01            0 -1.040168e+01
      5183 9.342006e-01            0 -1.462595e+00
      5184 3.337548e-01            0 -1.890834e+01
      5185 3.764074e-01            0 -1.040168e+01
      5186 9.342006e-01            0 -1.462595e+00
      5187 3.337548e-01            0 -1.890834e+01
      5188 3.764074e-01            0 -1.040168e+01
      5189 9.342006e-01            0 -1.462595e+00
      5190 3.337548e-01            0 -1.890834e+01
      5191 3.764074e-01            0 -1.040168e+01
      5192 9.342006e-01            0 -1.462595e+00
      5193 3.337548e-01            0 -1.890834e+01
      5194 3.764074e-01            0 -1.040168e+01
      5195 9.342006e-01            0 -1.462595e+00
      5196 3.337548e-01            0 -1.890834e+01
      5197 3.764074e-01            0 -1.040168e+01
      5198 9.342006e-01            0 -1.462595e+00
      5199 3.337548e-01            0 -1.890834e+01
      5200 3.764074e-01            0 -1.040168e+01
      5201 9.342006e-01            0 -1.462595e+00
      5202 3.337548e-01            0 -1.890834e+01
      5203 3.764074e-01            0 -1.040168e+01
      5204 9.342006e-01            0 -1.462595e+00
      5205 3.337548e-01            0 -1.890834e+01
      5206 3.764074e-01            0 -1.040168e+01
      5207 9.342006e-01            0 -1.462595e+00
      5208 3.337548e-01            0 -1.890834e+01
      5209 6.941973e-01            0  4.337292e+00
      5210 1.683287e-01            0 -3.229875e+01
      5211 3.804000e-01            0 -1.808965e+01
      5212 6.941973e-01            0  4.337292e+00
      5213 1.683287e-01            0 -3.229875e+01
      5214 3.804000e-01            0 -1.808965e+01
      5215 6.941973e-01            0  4.337292e+00
      5216 1.683287e-01            0 -3.229875e+01
      5217 3.804000e-01            0 -1.808965e+01
      5218 6.941973e-01            0  4.337292e+00
      5219 1.683287e-01            0 -3.229875e+01
      5220 3.804000e-01            0 -1.808965e+01
      5221 6.941973e-01            0  4.337292e+00
      5222 1.683287e-01            0 -3.229875e+01
      5223 3.804000e-01            0 -1.808965e+01
      5224 6.941973e-01            0  4.337292e+00
      5225 1.683287e-01            0 -3.229875e+01
      5226 3.804000e-01            0 -1.808965e+01
      5227 6.941973e-01            0  4.337292e+00
      5228 1.683287e-01            0 -3.229875e+01
      5229 3.804000e-01            0 -1.808965e+01
      5230 6.941973e-01            0  4.337292e+00
      5231 1.683287e-01            0 -3.229875e+01
      5232 3.804000e-01            0 -1.808965e+01
      5233 6.941973e-01            0  4.337292e+00
      5234 1.683287e-01            0 -3.229875e+01
      5235 3.804000e-01            0 -1.808965e+01
      5236 6.941973e-01            0  4.337292e+00
      5237 1.683287e-01            0 -3.229875e+01
      5238 3.804000e-01            0 -1.808965e+01
      5239 6.941973e-01            0  4.337292e+00
      5240 1.683287e-01            0 -3.229875e+01
      5241 3.804000e-01            0 -1.808965e+01
      5242 6.941973e-01            0  4.337292e+00
      5243 1.683287e-01            0 -3.229875e+01
      5244 3.804000e-01            0 -1.808965e+01
      5245 6.941973e-01            0  4.337292e+00
      5246 1.683287e-01            0 -3.229875e+01
      5247 3.804000e-01            0 -1.808965e+01
      5248 6.941973e-01            0  4.337292e+00
      5249 1.683287e-01            0 -3.229875e+01
      5250 3.804000e-01            0 -1.808965e+01
      5251 6.941973e-01            0  4.337292e+00
      5252 1.683287e-01            0 -3.229875e+01
      5253 3.804000e-01            0 -1.808965e+01
      5254 6.941973e-01            0  4.337292e+00
      5255 1.683287e-01            0 -3.229875e+01
      5256 3.804000e-01            0 -1.808965e+01
      5257 3.943069e-01            0 -1.196108e+01
      5258 9.702944e-01            0 -6.822607e-01
      5259 8.790710e-01            0  3.762448e+00
      5260 3.943069e-01            0 -1.196108e+01
      5261 9.702944e-01            0 -6.822607e-01
      5262 8.790710e-01            0  3.762448e+00
      5263 3.943069e-01            0 -1.196108e+01
      5264 9.702944e-01            0 -6.822607e-01
      5265 8.790710e-01            0  3.762448e+00
      5266 3.943069e-01            0 -1.196108e+01
      5267 9.702944e-01            0 -6.822607e-01
      5268 8.790710e-01            0  3.762448e+00
      5269 3.943069e-01            0 -1.196108e+01
      5270 9.702944e-01            0 -6.822607e-01
      5271 8.790710e-01            0  3.762448e+00
      5272 3.943069e-01            0 -1.196108e+01
      5273 9.702944e-01            0 -6.822607e-01
      5274 8.790710e-01            0  3.762448e+00
      5275 3.943069e-01            0 -1.196108e+01
      5276 9.702944e-01            0 -6.822607e-01
      5277 8.790710e-01            0  3.762448e+00
      5278 3.943069e-01            0 -1.196108e+01
      5279 9.702944e-01            0 -6.822607e-01
      5280 8.790710e-01            0  3.762448e+00
      5281 3.943069e-01            0 -1.196108e+01
      5282 9.702944e-01            0 -6.822607e-01
      5283 8.790710e-01            0  3.762448e+00
      5284 3.943069e-01            0 -1.196108e+01
      5285 9.702944e-01            0 -6.822607e-01
      5286 8.790710e-01            0  3.762448e+00
      5287 3.307869e-01            0  4.639485e+01
      5288 7.760562e-01            0  3.241895e+01
      5289 3.787004e-01            0  6.212188e+01
      5290 3.307869e-01            0  4.639485e+01
      5291 7.760562e-01            0  3.241895e+01
      5292 3.787004e-01            0  6.212188e+01
      5293 3.307869e-01            0  4.639485e+01
      5294 7.760562e-01            0  3.241895e+01
      5295 3.787004e-01            0  6.212188e+01
      5296 3.307869e-01            0  4.639485e+01
      5297 7.760562e-01            0  3.241895e+01
      5298 3.787004e-01            0  6.212188e+01
      5299 5.456132e-01            0 -1.275632e+01
      5300 3.885892e-01            0 -2.241117e+01
      5301 4.848261e-01            0 -2.963720e+01
      5302 5.456132e-01            0 -1.275632e+01
      5303 3.885892e-01            0 -2.241117e+01
      5304 4.848261e-01            0 -2.963720e+01
      5305 5.456132e-01            0 -1.275632e+01
      5306 3.885892e-01            0 -2.241117e+01
      5307 4.848261e-01            0 -2.963720e+01
      5308 5.456132e-01            0 -1.275632e+01
      5309 3.885892e-01            0 -2.241117e+01
      5310 4.848261e-01            0 -2.963720e+01
      5311 5.456132e-01            0 -1.275632e+01
      5312 3.885892e-01            0 -2.241117e+01
      5313 4.848261e-01            0 -2.963720e+01
      5314 5.456132e-01            0 -1.275632e+01
      5315 3.885892e-01            0 -2.241117e+01
      5316 4.848261e-01            0 -2.963720e+01
      5317 8.478002e-01            0  4.799185e+00
      5318 1.963939e-01            0  4.633508e+01
      5319 7.470369e-01            0  1.251325e+01
      5320 8.478002e-01            0  4.799185e+00
      5321 1.963939e-01            0  4.633508e+01
      5322 7.470369e-01            0  1.251325e+01
      5323 8.478002e-01            0  4.799185e+00
      5324 1.963939e-01            0  4.633508e+01
      5325 7.470369e-01            0  1.251325e+01
      5326 8.478002e-01            0  4.799185e+00
      5327 1.963939e-01            0  4.633508e+01
      5328 7.470369e-01            0  1.251325e+01
      5329 8.478002e-01            0  4.799185e+00
      5330 1.963939e-01            0  4.633508e+01
      5331 7.470369e-01            0  1.251325e+01
      5332 8.478002e-01            0  4.799185e+00
      5333 1.963939e-01            0  4.633508e+01
      5334 7.470369e-01            0  1.251325e+01
      5335 8.478002e-01            0  4.799185e+00
      5336 1.963939e-01            0  4.633508e+01
      5337 7.470369e-01            0  1.251325e+01
      5338 6.367582e-01            0  5.074921e+00
      5339 9.419993e-01            0 -2.114218e+00
      5340 7.749842e-01            0  6.783997e+00
      5341 6.367582e-01            0  5.074921e+00
      5342 9.419993e-01            0 -2.114218e+00
      5343 7.749842e-01            0  6.783997e+00
      5344 6.367582e-01            0  5.074921e+00
      5345 9.419993e-01            0 -2.114218e+00
      5346 7.749842e-01            0  6.783997e+00
      5347 6.367582e-01            0  5.074921e+00
      5348 9.419993e-01            0 -2.114218e+00
      5349 7.749842e-01            0  6.783997e+00
      5350 6.367582e-01            0  5.074921e+00
      5351 9.419993e-01            0 -2.114218e+00
      5352 7.749842e-01            0  6.783997e+00
      5353 6.367582e-01            0  5.074921e+00
      5354 9.419993e-01            0 -2.114218e+00
      5355 7.749842e-01            0  6.783997e+00
      5356 9.987791e-01            0  4.816659e-01
      5357 2.236600e-01            0  5.125921e+01
      5358 2.185082e-01            0  4.945305e+01
      5359 9.987791e-01            0  4.816659e-01
      5360 2.236600e-01            0  5.125921e+01
      5361 2.185082e-01            0  4.945305e+01
      5362 9.987791e-01            0  4.816659e-01
      5363 2.236600e-01            0  5.125921e+01
      5364 2.185082e-01            0  4.945305e+01
      5365 9.987791e-01            0  4.816659e-01
      5366 2.236600e-01            0  5.125921e+01
      5367 2.185082e-01            0  4.945305e+01
      5368 9.987791e-01            0  4.816659e-01
      5369 2.236600e-01            0  5.125921e+01
      5370 2.185082e-01            0  4.945305e+01
      5371 9.987791e-01            0  4.816659e-01
      5372 2.236600e-01            0  5.125921e+01
      5373 2.185082e-01            0  4.945305e+01
      5374 7.183679e-02            0  2.905487e+01
      5375 6.107417e-01            0 -1.435417e+01
      5376 5.733037e-01            0 -2.078135e+01
      5377 7.183679e-02            0  2.905487e+01
      5378 6.107417e-01            0 -1.435417e+01
      5379 5.733037e-01            0 -2.078135e+01
      5380 7.183679e-02            0  2.905487e+01
      5381 6.107417e-01            0 -1.435417e+01
      5382 5.733037e-01            0 -2.078135e+01
      5383 4.940771e-02            1 -1.204504e+01
      5384 2.398534e-01            0  3.882231e+01
      5385 1.812381e-01            0  3.035075e+01
      5386 4.940771e-02            1 -1.204504e+01
      5387 2.398534e-01            0  3.882231e+01
      5388 1.812381e-01            0  3.035075e+01
      5389 4.940771e-02            1 -1.204504e+01
      5390 2.398534e-01            0  3.882231e+01
      5391 1.812381e-01            0  3.035075e+01
      5392 4.940771e-02            1 -1.204504e+01
      5393 2.398534e-01            0  3.882231e+01
      5394 1.812381e-01            0  3.035075e+01
      5395 4.940771e-02            1 -1.204504e+01
      5396 2.398534e-01            0  3.882231e+01
      5397 1.812381e-01            0  3.035075e+01
      5398 4.940771e-02            1 -1.204504e+01
      5399 2.398534e-01            0  3.882231e+01
      5400 1.812381e-01            0  3.035075e+01
      5401 4.940771e-02            1 -1.204504e+01
      5402 2.398534e-01            0  3.882231e+01
      5403 1.812381e-01            0  3.035075e+01
      5404 4.940771e-02            1 -1.204504e+01
      5405 2.398534e-01            0  3.882231e+01
      5406 1.812381e-01            0  3.035075e+01
      5407 4.940771e-02            1 -1.204504e+01
      5408 2.398534e-01            0  3.882231e+01
      5409 1.812381e-01            0  3.035075e+01
      5410 4.940771e-02            1 -1.204504e+01
      5411 2.398534e-01            0  3.882231e+01
      5412 1.812381e-01            0  3.035075e+01
      5413 4.940771e-02            1 -1.204504e+01
      5414 2.398534e-01            0  3.882231e+01
      5415 1.812381e-01            0  3.035075e+01
      5416 4.940771e-02            1 -1.204504e+01
      5417 2.398534e-01            0  3.882231e+01
      5418 1.812381e-01            0  3.035075e+01
      5419 3.772315e-01            0  1.731979e+01
      5420 1.824318e-01            0 -5.323982e+01
      5421 8.155181e-01            0 -7.478711e+00
      5422 3.772315e-01            0  1.731979e+01
      5423 1.824318e-01            0 -5.323982e+01
      5424 8.155181e-01            0 -7.478711e+00
      5425 3.772315e-01            0  1.731979e+01
      5426 1.824318e-01            0 -5.323982e+01
      5427 8.155181e-01            0 -7.478711e+00
      5428 3.772315e-01            0  1.731979e+01
      5429 1.824318e-01            0 -5.323982e+01
      5430 8.155181e-01            0 -7.478711e+00
      5431 3.772315e-01            0  1.731979e+01
      5432 1.824318e-01            0 -5.323982e+01
      5433 8.155181e-01            0 -7.478711e+00
      5434 3.772315e-01            0  1.731979e+01
      5435 1.824318e-01            0 -5.323982e+01
      5436 8.155181e-01            0 -7.478711e+00
      5437 3.772315e-01            0  1.731979e+01
      5438 1.824318e-01            0 -5.323982e+01
      5439 8.155181e-01            0 -7.478711e+00
      5440 3.772315e-01            0  1.731979e+01
      5441 1.824318e-01            0 -5.323982e+01
      5442 8.155181e-01            0 -7.478711e+00
      5443 3.772315e-01            0  1.731979e+01
      5444 1.824318e-01            0 -5.323982e+01
      5445 8.155181e-01            0 -7.478711e+00
      5446 3.772315e-01            0  1.731979e+01
      5447 1.824318e-01            0 -5.323982e+01
      5448 8.155181e-01            0 -7.478711e+00
      5449 3.772315e-01            0  1.731979e+01
      5450 1.824318e-01            0 -5.323982e+01
      5451 8.155181e-01            0 -7.478711e+00
      5452 9.997252e-01            0  4.201530e-01
      5453 8.999444e-01            0 -2.576687e+00
      5454 7.972765e-01            0 -3.264679e+00
      5455 9.997252e-01            0  4.201530e-01
      5456 8.999444e-01            0 -2.576687e+00
      5457 7.972765e-01            0 -3.264679e+00
      5458 9.997252e-01            0  4.201530e-01
      5459 8.999444e-01            0 -2.576687e+00
      5460 7.972765e-01            0 -3.264679e+00
      5461 9.997252e-01            0  4.201530e-01
      5462 8.999444e-01            0 -2.576687e+00
      5463 7.972765e-01            0 -3.264679e+00
      5464 9.997252e-01            0  4.201530e-01
      5465 8.999444e-01            0 -2.576687e+00
      5466 7.972765e-01            0 -3.264679e+00
      5467 9.997252e-01            0  4.201530e-01
      5468 8.999444e-01            0 -2.576687e+00
      5469 7.972765e-01            0 -3.264679e+00
      5470 9.997252e-01            0  4.201530e-01
      5471 8.999444e-01            0 -2.576687e+00
      5472 7.972765e-01            0 -3.264679e+00
      5473 9.997252e-01            0  4.201530e-01
      5474 8.999444e-01            0 -2.576687e+00
      5475 7.972765e-01            0 -3.264679e+00
      5476 9.997252e-01            0  4.201530e-01
      5477 8.999444e-01            0 -2.576687e+00
      5478 7.972765e-01            0 -3.264679e+00
      5479 9.997252e-01            0  4.201530e-01
      5480 8.999444e-01            0 -2.576687e+00
      5481 7.972765e-01            0 -3.264679e+00
      5482 9.997252e-01            0  4.201530e-01
      5483 8.999444e-01            0 -2.576687e+00
      5484 7.972765e-01            0 -3.264679e+00
      5485 9.997252e-01            0  4.201530e-01
      5486 8.999444e-01            0 -2.576687e+00
      5487 7.972765e-01            0 -3.264679e+00
      5488 9.997252e-01            0  4.201530e-01
      5489 8.999444e-01            0 -2.576687e+00
      5490 7.972765e-01            0 -3.264679e+00
      5491 9.997252e-01            0  4.201530e-01
      5492 8.999444e-01            0 -2.576687e+00
      5493 7.972765e-01            0 -3.264679e+00
      5494 7.590495e-02            0  1.409226e+02
      5495 7.284511e-01            0 -1.030783e+02
      5496 8.372337e-01            0 -4.033592e+01
      5497 7.590495e-02            0  1.409226e+02
      5498 7.284511e-01            0 -1.030783e+02
      5499 8.372337e-01            0 -4.033592e+01
      5500 7.590495e-02            0  1.409226e+02
      5501 7.284511e-01            0 -1.030783e+02
      5502 8.372337e-01            0 -4.033592e+01
      5503 7.590495e-02            0  1.409226e+02
      5504 7.284511e-01            0 -1.030783e+02
      5505 8.372337e-01            0 -4.033592e+01
      5506 7.590495e-02            0  1.409226e+02
      5507 7.284511e-01            0 -1.030783e+02
      5508 8.372337e-01            0 -4.033592e+01
      5509 5.139653e-01            0 -1.369023e+01
      5510 4.355418e-01            0  5.341327e+01
      5511 1.793533e-01            0  4.980249e+01
      5512 5.139653e-01            0 -1.369023e+01
      5513 4.355418e-01            0  5.341327e+01
      5514 1.793533e-01            0  4.980249e+01
      5515 5.139653e-01            0 -1.369023e+01
      5516 4.355418e-01            0  5.341327e+01
      5517 1.793533e-01            0  4.980249e+01
      5518 5.139653e-01            0 -1.369023e+01
      5519 4.355418e-01            0  5.341327e+01
      5520 1.793533e-01            0  4.980249e+01
      5521 5.139653e-01            0 -1.369023e+01
      5522 4.355418e-01            0  5.341327e+01
      5523 1.793533e-01            0  4.980249e+01
      5524 5.139653e-01            0 -1.369023e+01
      5525 4.355418e-01            0  5.341327e+01
      5526 1.793533e-01            0  4.980249e+01
      5527 5.139653e-01            0 -1.369023e+01
      5528 4.355418e-01            0  5.341327e+01
      5529 1.793533e-01            0  4.980249e+01
      5530 5.139653e-01            0 -1.369023e+01
      5531 4.355418e-01            0  5.341327e+01
      5532 1.793533e-01            0  4.980249e+01
      5533 5.139653e-01            0 -1.369023e+01
      5534 4.355418e-01            0  5.341327e+01
      5535 1.793533e-01            0  4.980249e+01
      5536 2.731958e-01            0  1.039990e+01
      5537 6.640853e-02            0  5.886723e+01
      5538 3.598380e-01            0  2.356546e+01
      5539 2.731958e-01            0  1.039990e+01
      5540 6.640853e-02            0  5.886723e+01
      5541 3.598380e-01            0  2.356546e+01
      5542 2.731958e-01            0  1.039990e+01
      5543 6.640853e-02            0  5.886723e+01
      5544 3.598380e-01            0  2.356546e+01
      5545 2.731958e-01            0  1.039990e+01
      5546 6.640853e-02            0  5.886723e+01
      5547 3.598380e-01            0  2.356546e+01
      5548 2.731958e-01            0  1.039990e+01
      5549 6.640853e-02            0  5.886723e+01
      5550 3.598380e-01            0  2.356546e+01
      5551 2.731958e-01            0  1.039990e+01
      5552 6.640853e-02            0  5.886723e+01
      5553 3.598380e-01            0  2.356546e+01
      5554 2.731958e-01            0  1.039990e+01
      5555 6.640853e-02            0  5.886723e+01
      5556 3.598380e-01            0  2.356546e+01
      5557 2.731958e-01            0  1.039990e+01
      5558 6.640853e-02            0  5.886723e+01
      5559 3.598380e-01            0  2.356546e+01
      5560 2.731958e-01            0  1.039990e+01
      5561 6.640853e-02            0  5.886723e+01
      5562 3.598380e-01            0  2.356546e+01
      5563 2.731958e-01            0  1.039990e+01
      5564 6.640853e-02            0  5.886723e+01
      5565 3.598380e-01            0  2.356546e+01
      5566 2.731958e-01            0  1.039990e+01
      5567 6.640853e-02            0  5.886723e+01
      5568 3.598380e-01            0  2.356546e+01
      5569 2.731958e-01            0  1.039990e+01
      5570 6.640853e-02            0  5.886723e+01
      5571 3.598380e-01            0  2.356546e+01
      5572 2.731958e-01            0  1.039990e+01
      5573 6.640853e-02            0  5.886723e+01
      5574 3.598380e-01            0  2.356546e+01
      5575 2.577534e-02            1 -4.809783e+01
      5576 3.696797e-01            0 -7.944110e+01
      5577 8.699091e-01            0  6.364194e+00
      5578 2.577534e-02            1 -4.809783e+01
      5579 3.696797e-01            0 -7.944110e+01
      5580 8.699091e-01            0  6.364194e+00
      5581 2.577534e-02            1 -4.809783e+01
      5582 3.696797e-01            0 -7.944110e+01
      5583 8.699091e-01            0  6.364194e+00
      5584 2.577534e-02            1 -4.809783e+01
      5585 3.696797e-01            0 -7.944110e+01
      5586 8.699091e-01            0  6.364194e+00
      5587 2.577534e-02            1 -4.809783e+01
      5588 3.696797e-01            0 -7.944110e+01
      5589 8.699091e-01            0  6.364194e+00
      5590 2.577534e-02            1 -4.809783e+01
      5591 3.696797e-01            0 -7.944110e+01
      5592 8.699091e-01            0  6.364194e+00
      5593 2.577534e-02            1 -4.809783e+01
      5594 3.696797e-01            0 -7.944110e+01
      5595 8.699091e-01            0  6.364194e+00
      5596 3.000164e-01            0  2.562670e+01
      5597 1.418300e-01            0 -9.924862e+01
      5598 8.865356e-01            0 -4.219832e+00
      5599 3.000164e-01            0  2.562670e+01
      5600 1.418300e-01            0 -9.924862e+01
      5601 8.865356e-01            0 -4.219832e+00
      5602 3.000164e-01            0  2.562670e+01
      5603 1.418300e-01            0 -9.924862e+01
      5604 8.865356e-01            0 -4.219832e+00
      5605 3.000164e-01            0  2.562670e+01
      5606 1.418300e-01            0 -9.924862e+01
      5607 8.865356e-01            0 -4.219832e+00
      5608 3.000164e-01            0  2.562670e+01
      5609 1.418300e-01            0 -9.924862e+01
      5610 8.865356e-01            0 -4.219832e+00
      5611 3.000164e-01            0  2.562670e+01
      5612 1.418300e-01            0 -9.924862e+01
      5613 8.865356e-01            0 -4.219832e+00
      5614 3.000164e-01            0  2.562670e+01
      5615 1.418300e-01            0 -9.924862e+01
      5616 8.865356e-01            0 -4.219832e+00
      5617 3.000164e-01            0  2.562670e+01
      5618 1.418300e-01            0 -9.924862e+01
      5619 8.865356e-01            0 -4.219832e+00
      5620 7.672251e-01            0  1.798208e+01
      5621 8.129701e-01            0 -8.241423e+01
      5622 8.669855e-01            0 -3.970652e+01
      5623 7.672251e-01            0  1.798208e+01
      5624 8.129701e-01            0 -8.241423e+01
      5625 8.669855e-01            0 -3.970652e+01
      5626 7.672251e-01            0  1.798208e+01
      5627 8.129701e-01            0 -8.241423e+01
      5628 8.669855e-01            0 -3.970652e+01
      5629 3.866018e-01            0 -9.292814e+00
      5630 8.329918e-01            0 -9.995959e+00
      5631 9.047307e-01            0 -3.115935e+00
      5632 3.866018e-01            0 -9.292814e+00
      5633 8.329918e-01            0 -9.995959e+00
      5634 9.047307e-01            0 -3.115935e+00
      5635 3.866018e-01            0 -9.292814e+00
      5636 8.329918e-01            0 -9.995959e+00
      5637 9.047307e-01            0 -3.115935e+00
      5638 3.866018e-01            0 -9.292814e+00
      5639 8.329918e-01            0 -9.995959e+00
      5640 9.047307e-01            0 -3.115935e+00
      5641 3.866018e-01            0 -9.292814e+00
      5642 8.329918e-01            0 -9.995959e+00
      5643 9.047307e-01            0 -3.115935e+00
      5644 3.866018e-01            0 -9.292814e+00
      5645 8.329918e-01            0 -9.995959e+00
      5646 9.047307e-01            0 -3.115935e+00
      5647 3.866018e-01            0 -9.292814e+00
      5648 8.329918e-01            0 -9.995959e+00
      5649 9.047307e-01            0 -3.115935e+00
      5650 3.866018e-01            0 -9.292814e+00
      5651 8.329918e-01            0 -9.995959e+00
      5652 9.047307e-01            0 -3.115935e+00
      5653 3.866018e-01            0 -9.292814e+00
      5654 8.329918e-01            0 -9.995959e+00
      5655 9.047307e-01            0 -3.115935e+00
      5656 3.866018e-01            0 -9.292814e+00
      5657 8.329918e-01            0 -9.995959e+00
      5658 9.047307e-01            0 -3.115935e+00
      5659 2.125943e-01            0  7.190583e+01
      5660 8.943202e-01            0  2.333963e+01
      5661 3.661904e-01            0 -6.090003e+01
      5662 2.125943e-01            0  7.190583e+01
      5663 8.943202e-01            0  2.333963e+01
      5664 3.661904e-01            0 -6.090003e+01
      5665 2.125943e-01            0  7.190583e+01
      5666 8.943202e-01            0  2.333963e+01
      5667 3.661904e-01            0 -6.090003e+01
      5668 2.125943e-01            0  7.190583e+01
      5669 8.943202e-01            0  2.333963e+01
      5670 3.661904e-01            0 -6.090003e+01
      5671 9.942122e-01            0  5.048426e-01
      5672 8.499292e-01            0  9.764860e+00
      5673 5.591158e-01            0 -1.582683e+01
      5674 9.942122e-01            0  5.048426e-01
      5675 8.499292e-01            0  9.764860e+00
      5676 5.591158e-01            0 -1.582683e+01
      5677 9.942122e-01            0  5.048426e-01
      5678 8.499292e-01            0  9.764860e+00
      5679 5.591158e-01            0 -1.582683e+01
      5680 9.942122e-01            0  5.048426e-01
      5681 8.499292e-01            0  9.764860e+00
      5682 5.591158e-01            0 -1.582683e+01
      5683 9.942122e-01            0  5.048426e-01
      5684 8.499292e-01            0  9.764860e+00
      5685 5.591158e-01            0 -1.582683e+01
      5686 9.942122e-01            0  5.048426e-01
      5687 8.499292e-01            0  9.764860e+00
      5688 5.591158e-01            0 -1.582683e+01
      5689 9.942122e-01            0  5.048426e-01
      5690 8.499292e-01            0  9.764860e+00
      5691 5.591158e-01            0 -1.582683e+01
      5692 9.942122e-01            0  5.048426e-01
      5693 8.499292e-01            0  9.764860e+00
      5694 5.591158e-01            0 -1.582683e+01
      5695 9.942122e-01            0  5.048426e-01
      5696 8.499292e-01            0  9.764860e+00
      5697 5.591158e-01            0 -1.582683e+01
      5698 9.942122e-01            0  5.048426e-01
      5699 8.499292e-01            0  9.764860e+00
      5700 5.591158e-01            0 -1.582683e+01
      5701 2.979658e-01            0 -2.657526e+01
      5702 8.040613e-01            0  3.214222e+01
      5703 9.560715e-01            0  4.712561e+00
      5704 2.979658e-01            0 -2.657526e+01
      5705 8.040613e-01            0  3.214222e+01
      5706 9.560715e-01            0  4.712561e+00
      5707 2.979658e-01            0 -2.657526e+01
      5708 8.040613e-01            0  3.214222e+01
      5709 9.560715e-01            0  4.712561e+00
      5710 2.979658e-01            0 -2.657526e+01
      5711 8.040613e-01            0  3.214222e+01
      5712 9.560715e-01            0  4.712561e+00
      5713 2.979658e-01            0 -2.657526e+01
      5714 8.040613e-01            0  3.214222e+01
      5715 9.560715e-01            0  4.712561e+00
      5716 8.972844e-01            0  1.370150e+00
      5717 7.294125e-01            0 -7.116180e+00
      5718 4.772500e-01            0  3.374173e+00
      5719 8.972844e-01            0  1.370150e+00
      5720 7.294125e-01            0 -7.116180e+00
      5721 4.772500e-01            0  3.374173e+00
      5722 8.972844e-01            0  1.370150e+00
      5723 7.294125e-01            0 -7.116180e+00
      5724 4.772500e-01            0  3.374173e+00
      5725 8.972844e-01            0  1.370150e+00
      5726 7.294125e-01            0 -7.116180e+00
      5727 4.772500e-01            0  3.374173e+00
      5728 8.972844e-01            0  1.370150e+00
      5729 7.294125e-01            0 -7.116180e+00
      5730 4.772500e-01            0  3.374173e+00
      5731 8.972844e-01            0  1.370150e+00
      5732 7.294125e-01            0 -7.116180e+00
      5733 4.772500e-01            0  3.374173e+00
      5734 8.972844e-01            0  1.370150e+00
      5735 7.294125e-01            0 -7.116180e+00
      5736 4.772500e-01            0  3.374173e+00
      5737 8.972844e-01            0  1.370150e+00
      5738 7.294125e-01            0 -7.116180e+00
      5739 4.772500e-01            0  3.374173e+00
      5740 8.972844e-01            0  1.370150e+00
      5741 7.294125e-01            0 -7.116180e+00
      5742 4.772500e-01            0  3.374173e+00
      5743 8.972844e-01            0  1.370150e+00
      5744 7.294125e-01            0 -7.116180e+00
      5745 4.772500e-01            0  3.374173e+00
      5746 8.972844e-01            0  1.370150e+00
      5747 7.294125e-01            0 -7.116180e+00
      5748 4.772500e-01            0  3.374173e+00
      5749 8.972844e-01            0  1.370150e+00
      5750 7.294125e-01            0 -7.116180e+00
      5751 4.772500e-01            0  3.374173e+00
      5752 8.972844e-01            0  1.370150e+00
      5753 7.294125e-01            0 -7.116180e+00
      5754 4.772500e-01            0  3.374173e+00
      5755 8.972844e-01            0  1.370150e+00
      5756 7.294125e-01            0 -7.116180e+00
      5757 4.772500e-01            0  3.374173e+00
      5758 6.552727e-01            0 -4.139919e+00
      5759 4.301423e-01            0 -2.259515e+01
      5760 2.218690e-01            0 -2.062734e+01
      5761 6.552727e-01            0 -4.139919e+00
      5762 4.301423e-01            0 -2.259515e+01
      5763 2.218690e-01            0 -2.062734e+01
      5764 6.552727e-01            0 -4.139919e+00
      5765 4.301423e-01            0 -2.259515e+01
      5766 2.218690e-01            0 -2.062734e+01
      5767 6.552727e-01            0 -4.139919e+00
      5768 4.301423e-01            0 -2.259515e+01
      5769 2.218690e-01            0 -2.062734e+01
      5770 6.552727e-01            0 -4.139919e+00
      5771 4.301423e-01            0 -2.259515e+01
      5772 2.218690e-01            0 -2.062734e+01
      5773 6.552727e-01            0 -4.139919e+00
      5774 4.301423e-01            0 -2.259515e+01
      5775 2.218690e-01            0 -2.062734e+01
      5776 6.552727e-01            0 -4.139919e+00
      5777 4.301423e-01            0 -2.259515e+01
      5778 2.218690e-01            0 -2.062734e+01
      5779 6.552727e-01            0 -4.139919e+00
      5780 4.301423e-01            0 -2.259515e+01
      5781 2.218690e-01            0 -2.062734e+01
      5782 6.552727e-01            0 -4.139919e+00
      5783 4.301423e-01            0 -2.259515e+01
      5784 2.218690e-01            0 -2.062734e+01
      5785 2.547029e-01            0 -1.100623e+01
      5786 4.529894e-01            0  1.482554e+01
      5787 7.872583e-01            0  3.661442e+00
      5788 2.547029e-01            0 -1.100623e+01
      5789 4.529894e-01            0  1.482554e+01
      5790 7.872583e-01            0  3.661442e+00
      5791 2.547029e-01            0 -1.100623e+01
      5792 4.529894e-01            0  1.482554e+01
      5793 7.872583e-01            0  3.661442e+00
      5794 2.547029e-01            0 -1.100623e+01
      5795 4.529894e-01            0  1.482554e+01
      5796 7.872583e-01            0  3.661442e+00
      5797 2.547029e-01            0 -1.100623e+01
      5798 4.529894e-01            0  1.482554e+01
      5799 7.872583e-01            0  3.661442e+00
      5800 2.547029e-01            0 -1.100623e+01
      5801 4.529894e-01            0  1.482554e+01
      5802 7.872583e-01            0  3.661442e+00
      5803 2.547029e-01            0 -1.100623e+01
      5804 4.529894e-01            0  1.482554e+01
      5805 7.872583e-01            0  3.661442e+00
      5806 2.547029e-01            0 -1.100623e+01
      5807 4.529894e-01            0  1.482554e+01
      5808 7.872583e-01            0  3.661442e+00
      5809 2.547029e-01            0 -1.100623e+01
      5810 4.529894e-01            0  1.482554e+01
      5811 7.872583e-01            0  3.661442e+00
      5812 2.547029e-01            0 -1.100623e+01
      5813 4.529894e-01            0  1.482554e+01
      5814 7.872583e-01            0  3.661442e+00
      5815 2.547029e-01            0 -1.100623e+01
      5816 4.529894e-01            0  1.482554e+01
      5817 7.872583e-01            0  3.661442e+00
      5818 2.547029e-01            0 -1.100623e+01
      5819 4.529894e-01            0  1.482554e+01
      5820 7.872583e-01            0  3.661442e+00
      5821 2.547029e-01            0 -1.100623e+01
      5822 4.529894e-01            0  1.482554e+01
      5823 7.872583e-01            0  3.661442e+00
      5824 2.547029e-01            0 -1.100623e+01
      5825 4.529894e-01            0  1.482554e+01
      5826 7.872583e-01            0  3.661442e+00
      5827 2.547029e-01            0 -1.100623e+01
      5828 4.529894e-01            0  1.482554e+01
      5829 7.872583e-01            0  3.661442e+00
      5830 2.547029e-01            0 -1.100623e+01
      5831 4.529894e-01            0  1.482554e+01
      5832 7.872583e-01            0  3.661442e+00
      5833 2.547029e-01            0 -1.100623e+01
      5834 4.529894e-01            0  1.482554e+01
      5835 7.872583e-01            0  3.661442e+00
      5836 2.547029e-01            0 -1.100623e+01
      5837 4.529894e-01            0  1.482554e+01
      5838 7.872583e-01            0  3.661442e+00
      5839 6.972189e-01            0 -1.318221e+01
      5840 6.328417e-01            0  5.989449e+01
      5841 5.700118e-01            0  5.495602e+01
      5842 6.972189e-01            0 -1.318221e+01
      5843 6.328417e-01            0  5.989449e+01
      5844 5.700118e-01            0  5.495602e+01
      5845 6.972189e-01            0 -1.318221e+01
      5846 6.328417e-01            0  5.989449e+01
      5847 5.700118e-01            0  5.495602e+01
      5848 6.972189e-01            0 -1.318221e+01
      5849 6.328417e-01            0  5.989449e+01
      5850 5.700118e-01            0  5.495602e+01
      5851 6.972189e-01            0 -1.318221e+01
      5852 6.328417e-01            0  5.989449e+01
      5853 5.700118e-01            0  5.495602e+01
      5854 6.226307e-01            0  8.194182e+00
      5855 3.335644e-01            0  7.237261e+01
      5856 2.510755e-01            0  3.008920e+01
      5857 6.226307e-01            0  8.194182e+00
      5858 3.335644e-01            0  7.237261e+01
      5859 2.510755e-01            0  3.008920e+01
      5860 6.226307e-01            0  8.194182e+00
      5861 3.335644e-01            0  7.237261e+01
      5862 2.510755e-01            0  3.008920e+01
      5863 3.787182e-01            0 -5.006393e+00
      5864 9.916604e-01            0  4.932241e-01
      5865 6.420875e-01            0  7.514289e+00
      5866 3.787182e-01            0 -5.006393e+00
      5867 9.916604e-01            0  4.932241e-01
      5868 6.420875e-01            0  7.514289e+00
      5869 3.787182e-01            0 -5.006393e+00
      5870 9.916604e-01            0  4.932241e-01
      5871 6.420875e-01            0  7.514289e+00
      5872 3.787182e-01            0 -5.006393e+00
      5873 9.916604e-01            0  4.932241e-01
      5874 6.420875e-01            0  7.514289e+00
      5875 3.787182e-01            0 -5.006393e+00
      5876 9.916604e-01            0  4.932241e-01
      5877 6.420875e-01            0  7.514289e+00
      5878 3.787182e-01            0 -5.006393e+00
      5879 9.916604e-01            0  4.932241e-01
      5880 6.420875e-01            0  7.514289e+00
      5881 3.787182e-01            0 -5.006393e+00
      5882 9.916604e-01            0  4.932241e-01
      5883 6.420875e-01            0  7.514289e+00
      5884 3.787182e-01            0 -5.006393e+00
      5885 9.916604e-01            0  4.932241e-01
      5886 6.420875e-01            0  7.514289e+00
      5887 3.787182e-01            0 -5.006393e+00
      5888 9.916604e-01            0  4.932241e-01
      5889 6.420875e-01            0  7.514289e+00
      5890 3.787182e-01            0 -5.006393e+00
      5891 9.916604e-01            0  4.932241e-01
      5892 6.420875e-01            0  7.514289e+00
      5893 3.787182e-01            0 -5.006393e+00
      5894 9.916604e-01            0  4.932241e-01
      5895 6.420875e-01            0  7.514289e+00
      5896 3.787182e-01            0 -5.006393e+00
      5897 9.916604e-01            0  4.932241e-01
      5898 6.420875e-01            0  7.514289e+00
      5899 3.787182e-01            0 -5.006393e+00
      5900 9.916604e-01            0  4.932241e-01
      5901 6.420875e-01            0  7.514289e+00
      5902 3.787182e-01            0 -5.006393e+00
      5903 9.916604e-01            0  4.932241e-01
      5904 6.420875e-01            0  7.514289e+00
      5905 3.787182e-01            0 -5.006393e+00
      5906 9.916604e-01            0  4.932241e-01
      5907 6.420875e-01            0  7.514289e+00
      5908 7.181579e-01            0  1.059460e+01
      5909 7.675531e-01            0  2.735901e+01
      5910 5.396166e-01            0 -2.586108e+01
      5911 7.181579e-01            0  1.059460e+01
      5912 7.675531e-01            0  2.735901e+01
      5913 5.396166e-01            0 -2.586108e+01
      5914 7.181579e-01            0  1.059460e+01
      5915 7.675531e-01            0  2.735901e+01
      5916 5.396166e-01            0 -2.586108e+01
      5917 7.181579e-01            0  1.059460e+01
      5918 7.675531e-01            0  2.735901e+01
      5919 5.396166e-01            0 -2.586108e+01
      5920 7.181579e-01            0  1.059460e+01
      5921 7.675531e-01            0  2.735901e+01
      5922 5.396166e-01            0 -2.586108e+01
      5923 7.181579e-01            0  1.059460e+01
      5924 7.675531e-01            0  2.735901e+01
      5925 5.396166e-01            0 -2.586108e+01
      5926 7.181579e-01            0  1.059460e+01
      5927 7.675531e-01            0  2.735901e+01
      5928 5.396166e-01            0 -2.586108e+01
      5929 7.181579e-01            0  1.059460e+01
      5930 7.675531e-01            0  2.735901e+01
      5931 5.396166e-01            0 -2.586108e+01
      5932 8.424904e-01            0  1.723445e+01
      5933 7.296023e-01            0  6.105418e+01
      5934 7.168354e-01            0  5.223276e+01
      5935 8.424904e-01            0  1.723445e+01
      5936 7.296023e-01            0  6.105418e+01
      5937 7.168354e-01            0  5.223276e+01
      5938 8.424904e-01            0  1.723445e+01
      5939 7.296023e-01            0  6.105418e+01
      5940 7.168354e-01            0  5.223276e+01
      5941 4.773855e-01            0 -4.543777e+00
      5942 8.979641e-01            0  3.686869e+00
      5943 6.492930e-01            0  1.008091e+01
      5944 4.773855e-01            0 -4.543777e+00
      5945 8.979641e-01            0  3.686869e+00
      5946 6.492930e-01            0  1.008091e+01
      5947 4.773855e-01            0 -4.543777e+00
      5948 8.979641e-01            0  3.686869e+00
      5949 6.492930e-01            0  1.008091e+01
      5950 4.773855e-01            0 -4.543777e+00
      5951 8.979641e-01            0  3.686869e+00
      5952 6.492930e-01            0  1.008091e+01
      5953 4.773855e-01            0 -4.543777e+00
      5954 8.979641e-01            0  3.686869e+00
      5955 6.492930e-01            0  1.008091e+01
      5956 4.773855e-01            0 -4.543777e+00
      5957 8.979641e-01            0  3.686869e+00
      5958 6.492930e-01            0  1.008091e+01
      5959 4.773855e-01            0 -4.543777e+00
      5960 8.979641e-01            0  3.686869e+00
      5961 6.492930e-01            0  1.008091e+01
      5962 4.773855e-01            0 -4.543777e+00
      5963 8.979641e-01            0  3.686869e+00
      5964 6.492930e-01            0  1.008091e+01
      5965 4.773855e-01            0 -4.543777e+00
      5966 8.979641e-01            0  3.686869e+00
      5967 6.492930e-01            0  1.008091e+01
      5968 6.393671e-01            0 -4.620404e+00
      5969 9.277046e-01            0  1.891717e+00
      5970 7.138200e-01            0  6.050034e+00
      5971 6.393671e-01            0 -4.620404e+00
      5972 9.277046e-01            0  1.891717e+00
      5973 7.138200e-01            0  6.050034e+00
      5974 6.393671e-01            0 -4.620404e+00
      5975 9.277046e-01            0  1.891717e+00
      5976 7.138200e-01            0  6.050034e+00
      5977 6.393671e-01            0 -4.620404e+00
      5978 9.277046e-01            0  1.891717e+00
      5979 7.138200e-01            0  6.050034e+00
      5980 6.393671e-01            0 -4.620404e+00
      5981 9.277046e-01            0  1.891717e+00
      5982 7.138200e-01            0  6.050034e+00
      5983 6.393671e-01            0 -4.620404e+00
      5984 9.277046e-01            0  1.891717e+00
      5985 7.138200e-01            0  6.050034e+00
      5986 6.393671e-01            0 -4.620404e+00
      5987 9.277046e-01            0  1.891717e+00
      5988 7.138200e-01            0  6.050034e+00
      5989 6.393671e-01            0 -4.620404e+00
      5990 9.277046e-01            0  1.891717e+00
      5991 7.138200e-01            0  6.050034e+00
      5992 6.393671e-01            0 -4.620404e+00
      5993 9.277046e-01            0  1.891717e+00
      5994 7.138200e-01            0  6.050034e+00
      5995 6.393671e-01            0 -4.620404e+00
      5996 9.277046e-01            0  1.891717e+00
      5997 7.138200e-01            0  6.050034e+00
      5998 6.393671e-01            0 -4.620404e+00
      5999 9.277046e-01            0  1.891717e+00
      6000 7.138200e-01            0  6.050034e+00
      6001 6.393671e-01            0 -4.620404e+00
      6002 9.277046e-01            0  1.891717e+00
      6003 7.138200e-01            0  6.050034e+00
      6004 6.393671e-01            0 -4.620404e+00
      6005 9.277046e-01            0  1.891717e+00
      6006 7.138200e-01            0  6.050034e+00
      6007 5.824243e-01            0 -8.075762e+01
      6008 9.595396e-01            0  5.193281e+01
      6009 9.703158e-01            0  3.063415e+01
      6010 5.824243e-01            0 -8.075762e+01
      6011 9.595396e-01            0  5.193281e+01
      6012 9.703158e-01            0  3.063415e+01
      6013 5.824243e-01            0 -8.075762e+01
      6014 9.595396e-01            0  5.193281e+01
      6015 9.703158e-01            0  3.063415e+01
      6016 4.830491e-01            0  3.332050e+01
      6017 5.686437e-01            0 -7.282935e+01
      6018 5.556066e-01            0 -6.882369e+01
      6019 4.830491e-01            0  3.332050e+01
      6020 5.686437e-01            0 -7.282935e+01
      6021 5.556066e-01            0 -6.882369e+01
      6022 4.830491e-01            0  3.332050e+01
      6023 5.686437e-01            0 -7.282935e+01
      6024 5.556066e-01            0 -6.882369e+01
      6025 4.830491e-01            0  3.332050e+01
      6026 5.686437e-01            0 -7.282935e+01
      6027 5.556066e-01            0 -6.882369e+01
      6028 4.830491e-01            0  3.332050e+01
      6029 5.686437e-01            0 -7.282935e+01
      6030 5.556066e-01            0 -6.882369e+01
      6031 8.512678e-01            0 -1.555716e+00
      6032 7.641764e-01            0 -1.816992e+00
      6033 6.333524e-01            0 -3.870540e+00
      6034 8.512678e-01            0 -1.555716e+00
      6035 7.641764e-01            0 -1.816992e+00
      6036 6.333524e-01            0 -3.870540e+00
      6037 8.512678e-01            0 -1.555716e+00
      6038 7.641764e-01            0 -1.816992e+00
      6039 6.333524e-01            0 -3.870540e+00
      6040 8.512678e-01            0 -1.555716e+00
      6041 7.641764e-01            0 -1.816992e+00
      6042 6.333524e-01            0 -3.870540e+00
      6043 8.512678e-01            0 -1.555716e+00
      6044 7.641764e-01            0 -1.816992e+00
      6045 6.333524e-01            0 -3.870540e+00
      6046 8.512678e-01            0 -1.555716e+00
      6047 7.641764e-01            0 -1.816992e+00
      6048 6.333524e-01            0 -3.870540e+00
      6049 9.015562e-01            0 -2.409856e+00
      6050 1.830693e-02            1 -5.701752e+01
      6051 1.029958e-01            0 -3.915804e+01
      6052 9.015562e-01            0 -2.409856e+00
      6053 1.830693e-02            1 -5.701752e+01
      6054 1.029958e-01            0 -3.915804e+01
      6055 9.015562e-01            0 -2.409856e+00
      6056 1.830693e-02            1 -5.701752e+01
      6057 1.029958e-01            0 -3.915804e+01
      6058 9.015562e-01            0 -2.409856e+00
      6059 1.830693e-02            1 -5.701752e+01
      6060 1.029958e-01            0 -3.915804e+01
      6061 7.213481e-01            0 -3.742745e+00
      6062 1.542030e-01            0 -7.660771e+01
      6063 1.952753e-01            0 -4.883943e+01
      6064 7.213481e-01            0 -3.742745e+00
      6065 1.542030e-01            0 -7.660771e+01
      6066 1.952753e-01            0 -4.883943e+01
      6067 7.213481e-01            0 -3.742745e+00
      6068 1.542030e-01            0 -7.660771e+01
      6069 1.952753e-01            0 -4.883943e+01
      6070 7.213481e-01            0 -3.742745e+00
      6071 1.542030e-01            0 -7.660771e+01
      6072 1.952753e-01            0 -4.883943e+01
      6073 7.213481e-01            0 -3.742745e+00
      6074 1.542030e-01            0 -7.660771e+01
      6075 1.952753e-01            0 -4.883943e+01
      6076 7.213481e-01            0 -3.742745e+00
      6077 1.542030e-01            0 -7.660771e+01
      6078 1.952753e-01            0 -4.883943e+01
      6079 7.213481e-01            0 -3.742745e+00
      6080 1.542030e-01            0 -7.660771e+01
      6081 1.952753e-01            0 -4.883943e+01
      6082 7.213481e-01            0 -3.742745e+00
      6083 1.542030e-01            0 -7.660771e+01
      6084 1.952753e-01            0 -4.883943e+01
      6085 7.629589e-01            0  3.212490e+00
      6086 8.327726e-01            0  9.221568e+00
      6087 8.525547e-01            0 -4.629112e+00
      6088 7.629589e-01            0  3.212490e+00
      6089 8.327726e-01            0  9.221568e+00
      6090 8.525547e-01            0 -4.629112e+00
      6091 7.629589e-01            0  3.212490e+00
      6092 8.327726e-01            0  9.221568e+00
      6093 8.525547e-01            0 -4.629112e+00
      6094 7.629589e-01            0  3.212490e+00
      6095 8.327726e-01            0  9.221568e+00
      6096 8.525547e-01            0 -4.629112e+00
      6097 7.629589e-01            0  3.212490e+00
      6098 8.327726e-01            0  9.221568e+00
      6099 8.525547e-01            0 -4.629112e+00
      6100 7.629589e-01            0  3.212490e+00
      6101 8.327726e-01            0  9.221568e+00
      6102 8.525547e-01            0 -4.629112e+00
      6103 7.629589e-01            0  3.212490e+00
      6104 8.327726e-01            0  9.221568e+00
      6105 8.525547e-01            0 -4.629112e+00
      6106 7.629589e-01            0  3.212490e+00
      6107 8.327726e-01            0  9.221568e+00
      6108 8.525547e-01            0 -4.629112e+00
      6109 7.629589e-01            0  3.212490e+00
      6110 8.327726e-01            0  9.221568e+00
      6111 8.525547e-01            0 -4.629112e+00
      6112 7.629589e-01            0  3.212490e+00
      6113 8.327726e-01            0  9.221568e+00
      6114 8.525547e-01            0 -4.629112e+00
      6115 7.629589e-01            0  3.212490e+00
      6116 8.327726e-01            0  9.221568e+00
      6117 8.525547e-01            0 -4.629112e+00
      6118 7.629589e-01            0  3.212490e+00
      6119 8.327726e-01            0  9.221568e+00
      6120 8.525547e-01            0 -4.629112e+00
      6121 7.629589e-01            0  3.212490e+00
      6122 8.327726e-01            0  9.221568e+00
      6123 8.525547e-01            0 -4.629112e+00
      6124 4.413750e-01            0  7.755636e+00
      6125 3.426695e-02            1 -4.402186e+01
      6126 6.693325e-01            0  1.075859e+01
      6127 4.413750e-01            0  7.755636e+00
      6128 3.426695e-02            1 -4.402186e+01
      6129 6.693325e-01            0  1.075859e+01
      6130 4.413750e-01            0  7.755636e+00
      6131 3.426695e-02            1 -4.402186e+01
      6132 6.693325e-01            0  1.075859e+01
      6133 4.413750e-01            0  7.755636e+00
      6134 3.426695e-02            1 -4.402186e+01
      6135 6.693325e-01            0  1.075859e+01
      6136 4.413750e-01            0  7.755636e+00
      6137 3.426695e-02            1 -4.402186e+01
      6138 6.693325e-01            0  1.075859e+01
      6139 3.095039e-01            0 -6.789436e+00
      6140 4.828121e-01            0 -9.291814e+00
      6141 5.804448e-01            0  6.849952e+00
      6142 3.095039e-01            0 -6.789436e+00
      6143 4.828121e-01            0 -9.291814e+00
      6144 5.804448e-01            0  6.849952e+00
      6145 3.095039e-01            0 -6.789436e+00
      6146 4.828121e-01            0 -9.291814e+00
      6147 5.804448e-01            0  6.849952e+00
      6148 3.095039e-01            0 -6.789436e+00
      6149 4.828121e-01            0 -9.291814e+00
      6150 5.804448e-01            0  6.849952e+00
      6151 3.095039e-01            0 -6.789436e+00
      6152 4.828121e-01            0 -9.291814e+00
      6153 5.804448e-01            0  6.849952e+00
      6154 3.095039e-01            0 -6.789436e+00
      6155 4.828121e-01            0 -9.291814e+00
      6156 5.804448e-01            0  6.849952e+00
      6157 3.095039e-01            0 -6.789436e+00
      6158 4.828121e-01            0 -9.291814e+00
      6159 5.804448e-01            0  6.849952e+00
      6160 3.095039e-01            0 -6.789436e+00
      6161 4.828121e-01            0 -9.291814e+00
      6162 5.804448e-01            0  6.849952e+00
      6163 3.095039e-01            0 -6.789436e+00
      6164 4.828121e-01            0 -9.291814e+00
      6165 5.804448e-01            0  6.849952e+00
      6166 3.095039e-01            0 -6.789436e+00
      6167 4.828121e-01            0 -9.291814e+00
      6168 5.804448e-01            0  6.849952e+00
      6169 3.095039e-01            0 -6.789436e+00
      6170 4.828121e-01            0 -9.291814e+00
      6171 5.804448e-01            0  6.849952e+00
      6172 3.095039e-01            0 -6.789436e+00
      6173 4.828121e-01            0 -9.291814e+00
      6174 5.804448e-01            0  6.849952e+00
      6175 3.095039e-01            0 -6.789436e+00
      6176 4.828121e-01            0 -9.291814e+00
      6177 5.804448e-01            0  6.849952e+00
      6178 3.095039e-01            0 -6.789436e+00
      6179 4.828121e-01            0 -9.291814e+00
      6180 5.804448e-01            0  6.849952e+00
      6181 3.095039e-01            0 -6.789436e+00
      6182 4.828121e-01            0 -9.291814e+00
      6183 5.804448e-01            0  6.849952e+00
      6184 3.095039e-01            0 -6.789436e+00
      6185 4.828121e-01            0 -9.291814e+00
      6186 5.804448e-01            0  6.849952e+00
      6187 3.095039e-01            0 -6.789436e+00
      6188 4.828121e-01            0 -9.291814e+00
      6189 5.804448e-01            0  6.849952e+00
      6190 9.931947e-01            0  5.618728e-01
      6191 7.761566e-01            0 -1.121640e+01
      6192 6.804624e-01            0 -1.164196e+01
      6193 9.931947e-01            0  5.618728e-01
      6194 7.761566e-01            0 -1.121640e+01
      6195 6.804624e-01            0 -1.164196e+01
      6196 9.931947e-01            0  5.618728e-01
      6197 7.761566e-01            0 -1.121640e+01
      6198 6.804624e-01            0 -1.164196e+01
      6199 9.931947e-01            0  5.618728e-01
      6200 7.761566e-01            0 -1.121640e+01
      6201 6.804624e-01            0 -1.164196e+01
      6202 9.931947e-01            0  5.618728e-01
      6203 7.761566e-01            0 -1.121640e+01
      6204 6.804624e-01            0 -1.164196e+01
      6205 9.931947e-01            0  5.618728e-01
      6206 7.761566e-01            0 -1.121640e+01
      6207 6.804624e-01            0 -1.164196e+01
      6208 9.931947e-01            0  5.618728e-01
      6209 7.761566e-01            0 -1.121640e+01
      6210 6.804624e-01            0 -1.164196e+01
      6211 9.931947e-01            0  5.618728e-01
      6212 7.761566e-01            0 -1.121640e+01
      6213 6.804624e-01            0 -1.164196e+01
      6214 7.746145e-01            0  2.044458e+00
      6215 1.411298e-02            1  4.038366e+01
      6216 4.306310e-02            1  2.697628e+01
      6217 7.746145e-01            0  2.044458e+00
      6218 1.411298e-02            1  4.038366e+01
      6219 4.306310e-02            1  2.697628e+01
      6220 7.746145e-01            0  2.044458e+00
      6221 1.411298e-02            1  4.038366e+01
      6222 4.306310e-02            1  2.697628e+01
      6223 7.746145e-01            0  2.044458e+00
      6224 1.411298e-02            1  4.038366e+01
      6225 4.306310e-02            1  2.697628e+01
      6226 7.746145e-01            0  2.044458e+00
      6227 1.411298e-02            1  4.038366e+01
      6228 4.306310e-02            1  2.697628e+01
      6229 7.746145e-01            0  2.044458e+00
      6230 1.411298e-02            1  4.038366e+01
      6231 4.306310e-02            1  2.697628e+01
      6232 7.746145e-01            0  2.044458e+00
      6233 1.411298e-02            1  4.038366e+01
      6234 4.306310e-02            1  2.697628e+01
      6235 7.746145e-01            0  2.044458e+00
      6236 1.411298e-02            1  4.038366e+01
      6237 4.306310e-02            1  2.697628e+01
      6238 7.746145e-01            0  2.044458e+00
      6239 1.411298e-02            1  4.038366e+01
      6240 4.306310e-02            1  2.697628e+01
      6241 7.746145e-01            0  2.044458e+00
      6242 1.411298e-02            1  4.038366e+01
      6243 4.306310e-02            1  2.697628e+01
      6244 7.746145e-01            0  2.044458e+00
      6245 1.411298e-02            1  4.038366e+01
      6246 4.306310e-02            1  2.697628e+01
      6247 7.746145e-01            0  2.044458e+00
      6248 1.411298e-02            1  4.038366e+01
      6249 4.306310e-02            1  2.697628e+01
      6250 7.746145e-01            0  2.044458e+00
      6251 1.411298e-02            1  4.038366e+01
      6252 4.306310e-02            1  2.697628e+01
      6253 7.746145e-01            0  2.044458e+00
      6254 1.411298e-02            1  4.038366e+01
      6255 4.306310e-02            1  2.697628e+01
      6256 7.746145e-01            0  2.044458e+00
      6257 1.411298e-02            1  4.038366e+01
      6258 4.306310e-02            1  2.697628e+01
      6259 7.746145e-01            0  2.044458e+00
      6260 1.411298e-02            1  4.038366e+01
      6261 4.306310e-02            1  2.697628e+01
      6262 7.746145e-01            0  2.044458e+00
      6263 1.411298e-02            1  4.038366e+01
      6264 4.306310e-02            1  2.697628e+01
      6265 7.278281e-01            0  2.211124e+00
      6266 1.992488e-01            0 -3.133643e+01
      6267 5.725072e-01            0 -8.708905e+00
      6268 7.278281e-01            0  2.211124e+00
      6269 1.992488e-01            0 -3.133643e+01
      6270 5.725072e-01            0 -8.708905e+00
      6271 7.278281e-01            0  2.211124e+00
      6272 1.992488e-01            0 -3.133643e+01
      6273 5.725072e-01            0 -8.708905e+00
      6274 7.278281e-01            0  2.211124e+00
      6275 1.992488e-01            0 -3.133643e+01
      6276 5.725072e-01            0 -8.708905e+00
      6277 7.278281e-01            0  2.211124e+00
      6278 1.992488e-01            0 -3.133643e+01
      6279 5.725072e-01            0 -8.708905e+00
      6280 7.278281e-01            0  2.211124e+00
      6281 1.992488e-01            0 -3.133643e+01
      6282 5.725072e-01            0 -8.708905e+00
      6283 7.278281e-01            0  2.211124e+00
      6284 1.992488e-01            0 -3.133643e+01
      6285 5.725072e-01            0 -8.708905e+00
      6286 7.278281e-01            0  2.211124e+00
      6287 1.992488e-01            0 -3.133643e+01
      6288 5.725072e-01            0 -8.708905e+00
      6289 7.278281e-01            0  2.211124e+00
      6290 1.992488e-01            0 -3.133643e+01
      6291 5.725072e-01            0 -8.708905e+00
      6292 7.278281e-01            0  2.211124e+00
      6293 1.992488e-01            0 -3.133643e+01
      6294 5.725072e-01            0 -8.708905e+00
      6295 7.278281e-01            0  2.211124e+00
      6296 1.992488e-01            0 -3.133643e+01
      6297 5.725072e-01            0 -8.708905e+00
      6298 7.278281e-01            0  2.211124e+00
      6299 1.992488e-01            0 -3.133643e+01
      6300 5.725072e-01            0 -8.708905e+00
      6301 7.278281e-01            0  2.211124e+00
      6302 1.992488e-01            0 -3.133643e+01
      6303 5.725072e-01            0 -8.708905e+00
      6304 7.278281e-01            0  2.211124e+00
      6305 1.992488e-01            0 -3.133643e+01
      6306 5.725072e-01            0 -8.708905e+00
      6307 7.278281e-01            0  2.211124e+00
      6308 1.992488e-01            0 -3.133643e+01
      6309 5.725072e-01            0 -8.708905e+00
      6310 7.278281e-01            0  2.211124e+00
      6311 1.992488e-01            0 -3.133643e+01
      6312 5.725072e-01            0 -8.708905e+00
      6313 7.278281e-01            0  2.211124e+00
      6314 1.992488e-01            0 -3.133643e+01
      6315 5.725072e-01            0 -8.708905e+00
      6316 7.278281e-01            0  2.211124e+00
      6317 1.992488e-01            0 -3.133643e+01
      6318 5.725072e-01            0 -8.708905e+00
      6319 7.278281e-01            0  2.211124e+00
      6320 1.992488e-01            0 -3.133643e+01
      6321 5.725072e-01            0 -8.708905e+00
      6322 7.278281e-01            0  2.211124e+00
      6323 1.992488e-01            0 -3.133643e+01
      6324 5.725072e-01            0 -8.708905e+00
      6325 9.908319e-01            0 -4.299631e-01
      6326 3.059628e-01            0  1.085615e+02
      6327 2.820607e-01            0  1.541189e+01
      6328 9.908319e-01            0 -4.299631e-01
      6329 3.059628e-01            0  1.085615e+02
      6330 2.820607e-01            0  1.541189e+01
      6331 9.908319e-01            0 -4.299631e-01
      6332 3.059628e-01            0  1.085615e+02
      6333 2.820607e-01            0  1.541189e+01
      6334 9.908319e-01            0 -4.299631e-01
      6335 3.059628e-01            0  1.085615e+02
      6336 2.820607e-01            0  1.541189e+01
      6337 6.292679e-01            0 -5.964102e+00
      6338 2.097095e-01            0 -4.244433e+01
      6339 7.163420e-02            0 -6.290360e+01
      6340 6.292679e-01            0 -5.964102e+00
      6341 2.097095e-01            0 -4.244433e+01
      6342 7.163420e-02            0 -6.290360e+01
      6343 6.292679e-01            0 -5.964102e+00
      6344 2.097095e-01            0 -4.244433e+01
      6345 7.163420e-02            0 -6.290360e+01
      6346 6.292679e-01            0 -5.964102e+00
      6347 2.097095e-01            0 -4.244433e+01
      6348 7.163420e-02            0 -6.290360e+01
      6349 6.292679e-01            0 -5.964102e+00
      6350 2.097095e-01            0 -4.244433e+01
      6351 7.163420e-02            0 -6.290360e+01
      6352 6.292679e-01            0 -5.964102e+00
      6353 2.097095e-01            0 -4.244433e+01
      6354 7.163420e-02            0 -6.290360e+01
      6355 1.587793e-01            0 -1.825978e+01
      6356 4.020065e-01            0  2.910046e+01
      6357 4.789426e-01            0  3.255854e+01
      6358 1.587793e-01            0 -1.825978e+01
      6359 4.020065e-01            0  2.910046e+01
      6360 4.789426e-01            0  3.255854e+01
      6361 1.587793e-01            0 -1.825978e+01
      6362 4.020065e-01            0  2.910046e+01
      6363 4.789426e-01            0  3.255854e+01
      6364 1.587793e-01            0 -1.825978e+01
      6365 4.020065e-01            0  2.910046e+01
      6366 4.789426e-01            0  3.255854e+01
      6367 1.587793e-01            0 -1.825978e+01
      6368 4.020065e-01            0  2.910046e+01
      6369 4.789426e-01            0  3.255854e+01
      6370 2.320166e-01            0 -1.392178e+01
      6371 3.727955e-01            0 -1.360907e+01
      6372 5.189215e-01            0 -6.607111e+00
      6373 2.320166e-01            0 -1.392178e+01
      6374 3.727955e-01            0 -1.360907e+01
      6375 5.189215e-01            0 -6.607111e+00
      6376 2.320166e-01            0 -1.392178e+01
      6377 3.727955e-01            0 -1.360907e+01
      6378 5.189215e-01            0 -6.607111e+00
      6379 2.320166e-01            0 -1.392178e+01
      6380 3.727955e-01            0 -1.360907e+01
      6381 5.189215e-01            0 -6.607111e+00
      6382 2.320166e-01            0 -1.392178e+01
      6383 3.727955e-01            0 -1.360907e+01
      6384 5.189215e-01            0 -6.607111e+00
      6385 2.320166e-01            0 -1.392178e+01
      6386 3.727955e-01            0 -1.360907e+01
      6387 5.189215e-01            0 -6.607111e+00
      6388 2.320166e-01            0 -1.392178e+01
      6389 3.727955e-01            0 -1.360907e+01
      6390 5.189215e-01            0 -6.607111e+00
      6391 2.320166e-01            0 -1.392178e+01
      6392 3.727955e-01            0 -1.360907e+01
      6393 5.189215e-01            0 -6.607111e+00
      6394 2.320166e-01            0 -1.392178e+01
      6395 3.727955e-01            0 -1.360907e+01
      6396 5.189215e-01            0 -6.607111e+00
      6397 2.320166e-01            0 -1.392178e+01
      6398 3.727955e-01            0 -1.360907e+01
      6399 5.189215e-01            0 -6.607111e+00
      6400 2.610320e-01            0 -5.600907e+00
      6401 5.756453e-01            0 -3.371527e+01
      6402 3.474079e-01            0 -3.108970e+01
      6403 2.610320e-01            0 -5.600907e+00
      6404 5.756453e-01            0 -3.371527e+01
      6405 3.474079e-01            0 -3.108970e+01
      6406 2.610320e-01            0 -5.600907e+00
      6407 5.756453e-01            0 -3.371527e+01
      6408 3.474079e-01            0 -3.108970e+01
      6409 2.610320e-01            0 -5.600907e+00
      6410 5.756453e-01            0 -3.371527e+01
      6411 3.474079e-01            0 -3.108970e+01
      6412 2.610320e-01            0 -5.600907e+00
      6413 5.756453e-01            0 -3.371527e+01
      6414 3.474079e-01            0 -3.108970e+01
      6415 2.610320e-01            0 -5.600907e+00
      6416 5.756453e-01            0 -3.371527e+01
      6417 3.474079e-01            0 -3.108970e+01
      6418 3.156523e-05            1 -3.167648e+01
      6419 4.499931e-01            0 -2.600634e+01
      6420 4.092870e-01            0 -2.341839e+01
      6421 3.156523e-05            1 -3.167648e+01
      6422 4.499931e-01            0 -2.600634e+01
      6423 4.092870e-01            0 -2.341839e+01
      6424 3.156523e-05            1 -3.167648e+01
      6425 4.499931e-01            0 -2.600634e+01
      6426 4.092870e-01            0 -2.341839e+01
      6427 3.156523e-05            1 -3.167648e+01
      6428 4.499931e-01            0 -2.600634e+01
      6429 4.092870e-01            0 -2.341839e+01
      6430 3.156523e-05            1 -3.167648e+01
      6431 4.499931e-01            0 -2.600634e+01
      6432 4.092870e-01            0 -2.341839e+01
      6433 3.156523e-05            1 -3.167648e+01
      6434 4.499931e-01            0 -2.600634e+01
      6435 4.092870e-01            0 -2.341839e+01
      6436 3.156523e-05            1 -3.167648e+01
      6437 4.499931e-01            0 -2.600634e+01
      6438 4.092870e-01            0 -2.341839e+01
      6439 3.156523e-05            1 -3.167648e+01
      6440 4.499931e-01            0 -2.600634e+01
      6441 4.092870e-01            0 -2.341839e+01
      6442 3.156523e-05            1 -3.167648e+01
      6443 4.499931e-01            0 -2.600634e+01
      6444 4.092870e-01            0 -2.341839e+01
      6445 3.156523e-05            1 -3.167648e+01
      6446 4.499931e-01            0 -2.600634e+01
      6447 4.092870e-01            0 -2.341839e+01
      6448 3.156523e-05            1 -3.167648e+01
      6449 4.499931e-01            0 -2.600634e+01
      6450 4.092870e-01            0 -2.341839e+01
      6451 3.156523e-05            1 -3.167648e+01
      6452 4.499931e-01            0 -2.600634e+01
      6453 4.092870e-01            0 -2.341839e+01
      6454 3.156523e-05            1 -3.167648e+01
      6455 4.499931e-01            0 -2.600634e+01
      6456 4.092870e-01            0 -2.341839e+01
      6457 6.762909e-01            0 -1.635348e+00
      6458 5.935471e-01            0  2.408939e+01
      6459 6.364019e-01            0  1.386925e+01
      6460 6.762909e-01            0 -1.635348e+00
      6461 5.935471e-01            0  2.408939e+01
      6462 6.364019e-01            0  1.386925e+01
      6463 6.762909e-01            0 -1.635348e+00
      6464 5.935471e-01            0  2.408939e+01
      6465 6.364019e-01            0  1.386925e+01
      6466 6.762909e-01            0 -1.635348e+00
      6467 5.935471e-01            0  2.408939e+01
      6468 6.364019e-01            0  1.386925e+01
      6469 6.762909e-01            0 -1.635348e+00
      6470 5.935471e-01            0  2.408939e+01
      6471 6.364019e-01            0  1.386925e+01
      6472 6.762909e-01            0 -1.635348e+00
      6473 5.935471e-01            0  2.408939e+01
      6474 6.364019e-01            0  1.386925e+01
      6475 6.762909e-01            0 -1.635348e+00
      6476 5.935471e-01            0  2.408939e+01
      6477 6.364019e-01            0  1.386925e+01
      6478 6.762909e-01            0 -1.635348e+00
      6479 5.935471e-01            0  2.408939e+01
      6480 6.364019e-01            0  1.386925e+01
      6481 6.762909e-01            0 -1.635348e+00
      6482 5.935471e-01            0  2.408939e+01
      6483 6.364019e-01            0  1.386925e+01
      6484 6.762909e-01            0 -1.635348e+00
      6485 5.935471e-01            0  2.408939e+01
      6486 6.364019e-01            0  1.386925e+01
      6487 6.762909e-01            0 -1.635348e+00
      6488 5.935471e-01            0  2.408939e+01
      6489 6.364019e-01            0  1.386925e+01
      6490 6.762909e-01            0 -1.635348e+00
      6491 5.935471e-01            0  2.408939e+01
      6492 6.364019e-01            0  1.386925e+01
      6493 6.762909e-01            0 -1.635348e+00
      6494 5.935471e-01            0  2.408939e+01
      6495 6.364019e-01            0  1.386925e+01
      6496 6.762909e-01            0 -1.635348e+00
      6497 5.935471e-01            0  2.408939e+01
      6498 6.364019e-01            0  1.386925e+01
      6499 4.998320e-02            1 -2.596552e+01
      6500 6.639254e-01            0  1.760446e+01
      6501 9.313066e-01            0 -6.944164e-01
      6502 4.998320e-02            1 -2.596552e+01
      6503 6.639254e-01            0  1.760446e+01
      6504 9.313066e-01            0 -6.944164e-01
      6505 4.998320e-02            1 -2.596552e+01
      6506 6.639254e-01            0  1.760446e+01
      6507 9.313066e-01            0 -6.944164e-01
      6508 4.998320e-02            1 -2.596552e+01
      6509 6.639254e-01            0  1.760446e+01
      6510 9.313066e-01            0 -6.944164e-01
      6511 4.998320e-02            1 -2.596552e+01
      6512 6.639254e-01            0  1.760446e+01
      6513 9.313066e-01            0 -6.944164e-01
      6514 4.998320e-02            1 -2.596552e+01
      6515 6.639254e-01            0  1.760446e+01
      6516 9.313066e-01            0 -6.944164e-01
      6517 4.998320e-02            1 -2.596552e+01
      6518 6.639254e-01            0  1.760446e+01
      6519 9.313066e-01            0 -6.944164e-01
      6520 4.998320e-02            1 -2.596552e+01
      6521 6.639254e-01            0  1.760446e+01
      6522 9.313066e-01            0 -6.944164e-01
      6523 4.998320e-02            1 -2.596552e+01
      6524 6.639254e-01            0  1.760446e+01
      6525 9.313066e-01            0 -6.944164e-01
      6526 4.998320e-02            1 -2.596552e+01
      6527 6.639254e-01            0  1.760446e+01
      6528 9.313066e-01            0 -6.944164e-01
      6529 4.998320e-02            1 -2.596552e+01
      6530 6.639254e-01            0  1.760446e+01
      6531 9.313066e-01            0 -6.944164e-01
      6532 7.072029e-01            0  2.582626e+01
      6533 2.007064e-01            0 -2.945053e+02
      6534 1.302335e-01            0 -3.065538e+02
      6535 7.072029e-01            0  2.582626e+01
      6536 2.007064e-01            0 -2.945053e+02
      6537 1.302335e-01            0 -3.065538e+02
      6538 7.072029e-01            0  2.582626e+01
      6539 2.007064e-01            0 -2.945053e+02
      6540 1.302335e-01            0 -3.065538e+02
      6541 7.072029e-01            0  2.582626e+01
      6542 2.007064e-01            0 -2.945053e+02
      6543 1.302335e-01            0 -3.065538e+02
      6544 9.862262e-01            0 -9.374150e-01
      6545 9.807617e-01            0  6.008804e+00
      6546 3.076173e-01            0 -8.467472e+01
      6547 9.862262e-01            0 -9.374150e-01
      6548 9.807617e-01            0  6.008804e+00
      6549 3.076173e-01            0 -8.467472e+01
      6550 9.862262e-01            0 -9.374150e-01
      6551 9.807617e-01            0  6.008804e+00
      6552 3.076173e-01            0 -8.467472e+01
      6553 9.862262e-01            0 -9.374150e-01
      6554 9.807617e-01            0  6.008804e+00
      6555 3.076173e-01            0 -8.467472e+01
      6556 8.308196e-01            0  4.399080e+00
      6557 4.237068e-01            0 -3.595541e+01
      6558 4.958065e-01            0 -3.737246e+01
      6559 8.308196e-01            0  4.399080e+00
      6560 4.237068e-01            0 -3.595541e+01
      6561 4.958065e-01            0 -3.737246e+01
      6562 8.308196e-01            0  4.399080e+00
      6563 4.237068e-01            0 -3.595541e+01
      6564 4.958065e-01            0 -3.737246e+01
      6565 8.308196e-01            0  4.399080e+00
      6566 4.237068e-01            0 -3.595541e+01
      6567 4.958065e-01            0 -3.737246e+01
      6568 8.308196e-01            0  4.399080e+00
      6569 4.237068e-01            0 -3.595541e+01
      6570 4.958065e-01            0 -3.737246e+01
      6571 8.308196e-01            0  4.399080e+00
      6572 4.237068e-01            0 -3.595541e+01
      6573 4.958065e-01            0 -3.737246e+01
      6574 8.308196e-01            0  4.399080e+00
      6575 4.237068e-01            0 -3.595541e+01
      6576 4.958065e-01            0 -3.737246e+01
      6577 7.500817e-01            0 -3.939243e+00
      6578 6.333367e-01            0  2.620092e+01
      6579 4.622423e-02            1  2.654202e+01
      6580 7.500817e-01            0 -3.939243e+00
      6581 6.333367e-01            0  2.620092e+01
      6582 4.622423e-02            1  2.654202e+01
      6583 7.500817e-01            0 -3.939243e+00
      6584 6.333367e-01            0  2.620092e+01
      6585 4.622423e-02            1  2.654202e+01
      6586 7.500817e-01            0 -3.939243e+00
      6587 6.333367e-01            0  2.620092e+01
      6588 4.622423e-02            1  2.654202e+01
      6589 7.500817e-01            0 -3.939243e+00
      6590 6.333367e-01            0  2.620092e+01
      6591 4.622423e-02            1  2.654202e+01
      6592 8.963276e-01            0 -1.221150e+00
      6593 8.796589e-02            0 -7.722551e+01
      6594 5.121277e-02            0 -6.613409e+01
      6595 8.963276e-01            0 -1.221150e+00
      6596 8.796589e-02            0 -7.722551e+01
      6597 5.121277e-02            0 -6.613409e+01
      6598 8.963276e-01            0 -1.221150e+00
      6599 8.796589e-02            0 -7.722551e+01
      6600 5.121277e-02            0 -6.613409e+01
      6601 8.963276e-01            0 -1.221150e+00
      6602 8.796589e-02            0 -7.722551e+01
      6603 5.121277e-02            0 -6.613409e+01
      6604 8.963276e-01            0 -1.221150e+00
      6605 8.796589e-02            0 -7.722551e+01
      6606 5.121277e-02            0 -6.613409e+01
      6607 8.963276e-01            0 -1.221150e+00
      6608 8.796589e-02            0 -7.722551e+01
      6609 5.121277e-02            0 -6.613409e+01
      6610 8.963276e-01            0 -1.221150e+00
      6611 8.796589e-02            0 -7.722551e+01
      6612 5.121277e-02            0 -6.613409e+01
      6613 8.963276e-01            0 -1.221150e+00
      6614 8.796589e-02            0 -7.722551e+01
      6615 5.121277e-02            0 -6.613409e+01
      6616 8.963276e-01            0 -1.221150e+00
      6617 8.796589e-02            0 -7.722551e+01
      6618 5.121277e-02            0 -6.613409e+01
      6619 9.683067e-01            0 -1.472011e-01
      6620 4.544918e-01            0  1.899786e+01
      6621 2.172922e-01            0  2.251148e+01
      6622 9.683067e-01            0 -1.472011e-01
      6623 4.544918e-01            0  1.899786e+01
      6624 2.172922e-01            0  2.251148e+01
      6625 9.683067e-01            0 -1.472011e-01
      6626 4.544918e-01            0  1.899786e+01
      6627 2.172922e-01            0  2.251148e+01
      6628 9.683067e-01            0 -1.472011e-01
      6629 4.544918e-01            0  1.899786e+01
      6630 2.172922e-01            0  2.251148e+01
      6631 9.683067e-01            0 -1.472011e-01
      6632 4.544918e-01            0  1.899786e+01
      6633 2.172922e-01            0  2.251148e+01
      6634 9.683067e-01            0 -1.472011e-01
      6635 4.544918e-01            0  1.899786e+01
      6636 2.172922e-01            0  2.251148e+01
      6637 9.683067e-01            0 -1.472011e-01
      6638 4.544918e-01            0  1.899786e+01
      6639 2.172922e-01            0  2.251148e+01
      6640 9.683067e-01            0 -1.472011e-01
      6641 4.544918e-01            0  1.899786e+01
      6642 2.172922e-01            0  2.251148e+01
      6643 9.683067e-01            0 -1.472011e-01
      6644 4.544918e-01            0  1.899786e+01
      6645 2.172922e-01            0  2.251148e+01
      6646 9.683067e-01            0 -1.472011e-01
      6647 4.544918e-01            0  1.899786e+01
      6648 2.172922e-01            0  2.251148e+01
      6649 9.683067e-01            0 -1.472011e-01
      6650 4.544918e-01            0  1.899786e+01
      6651 2.172922e-01            0  2.251148e+01
      6652 9.683067e-01            0 -1.472011e-01
      6653 4.544918e-01            0  1.899786e+01
      6654 2.172922e-01            0  2.251148e+01
      6655 3.554730e-01            0  2.013564e+01
      6656 8.169086e-01            0  1.041601e+01
      6657 8.499514e-01            0 -4.339248e+00
      6658 3.554730e-01            0  2.013564e+01
      6659 8.169086e-01            0  1.041601e+01
      6660 8.499514e-01            0 -4.339248e+00
      6661 3.554730e-01            0  2.013564e+01
      6662 8.169086e-01            0  1.041601e+01
      6663 8.499514e-01            0 -4.339248e+00
      6664 3.554730e-01            0  2.013564e+01
      6665 8.169086e-01            0  1.041601e+01
      6666 8.499514e-01            0 -4.339248e+00
      6667 3.554730e-01            0  2.013564e+01
      6668 8.169086e-01            0  1.041601e+01
      6669 8.499514e-01            0 -4.339248e+00
      6670 3.554730e-01            0  2.013564e+01
      6671 8.169086e-01            0  1.041601e+01
      6672 8.499514e-01            0 -4.339248e+00
      6673 3.554730e-01            0  2.013564e+01
      6674 8.169086e-01            0  1.041601e+01
      6675 8.499514e-01            0 -4.339248e+00
      6676 3.554730e-01            0  2.013564e+01
      6677 8.169086e-01            0  1.041601e+01
      6678 8.499514e-01            0 -4.339248e+00
      6679 3.554730e-01            0  2.013564e+01
      6680 8.169086e-01            0  1.041601e+01
      6681 8.499514e-01            0 -4.339248e+00
      6682 3.554730e-01            0  2.013564e+01
      6683 8.169086e-01            0  1.041601e+01
      6684 8.499514e-01            0 -4.339248e+00
      6685 3.554730e-01            0  2.013564e+01
      6686 8.169086e-01            0  1.041601e+01
      6687 8.499514e-01            0 -4.339248e+00
      6688 3.554730e-01            0  2.013564e+01
      6689 8.169086e-01            0  1.041601e+01
      6690 8.499514e-01            0 -4.339248e+00
      6691 4.803697e-01            0 -1.145150e+01
      6692 8.306270e-01            0 -6.553334e+00
      6693 1.236810e-01            0 -3.705901e+01
      6694 4.803697e-01            0 -1.145150e+01
      6695 8.306270e-01            0 -6.553334e+00
      6696 1.236810e-01            0 -3.705901e+01
      6697 4.803697e-01            0 -1.145150e+01
      6698 8.306270e-01            0 -6.553334e+00
      6699 1.236810e-01            0 -3.705901e+01
      6700 4.803697e-01            0 -1.145150e+01
      6701 8.306270e-01            0 -6.553334e+00
      6702 1.236810e-01            0 -3.705901e+01
      6703 4.803697e-01            0 -1.145150e+01
      6704 8.306270e-01            0 -6.553334e+00
      6705 1.236810e-01            0 -3.705901e+01
      6706 4.803697e-01            0 -1.145150e+01
      6707 8.306270e-01            0 -6.553334e+00
      6708 1.236810e-01            0 -3.705901e+01
      6709 4.803697e-01            0 -1.145150e+01
      6710 8.306270e-01            0 -6.553334e+00
      6711 1.236810e-01            0 -3.705901e+01
      6712 4.803697e-01            0 -1.145150e+01
      6713 8.306270e-01            0 -6.553334e+00
      6714 1.236810e-01            0 -3.705901e+01
      6715 6.964465e-01            0 -5.358413e+01
      6716 5.077829e-01            0  1.549237e+02
      6717 3.279150e-01            0  1.790173e+02
      6718 6.964465e-01            0 -5.358413e+01
      6719 5.077829e-01            0  1.549237e+02
      6720 3.279150e-01            0  1.790173e+02
      6721 6.964465e-01            0 -5.358413e+01
      6722 5.077829e-01            0  1.549237e+02
      6723 3.279150e-01            0  1.790173e+02
      6724 5.026022e-01            0 -1.248070e+01
      6725 5.350272e-01            0  1.131741e+02
      6726 5.617156e-01            0  5.927229e+01
      6727 5.026022e-01            0 -1.248070e+01
      6728 5.350272e-01            0  1.131741e+02
      6729 5.617156e-01            0  5.927229e+01
      6730 5.026022e-01            0 -1.248070e+01
      6731 5.350272e-01            0  1.131741e+02
      6732 5.617156e-01            0  5.927229e+01
      6733 8.052496e-01            0  3.829510e+00
      6734 8.762857e-01            0  8.064225e+00
      6735 2.076365e-01            0  3.377576e+01
      6736 8.052496e-01            0  3.829510e+00
      6737 8.762857e-01            0  8.064225e+00
      6738 2.076365e-01            0  3.377576e+01
      6739 8.052496e-01            0  3.829510e+00
      6740 8.762857e-01            0  8.064225e+00
      6741 2.076365e-01            0  3.377576e+01
      6742 8.052496e-01            0  3.829510e+00
      6743 8.762857e-01            0  8.064225e+00
      6744 2.076365e-01            0  3.377576e+01
      6745 8.052496e-01            0  3.829510e+00
      6746 8.762857e-01            0  8.064225e+00
      6747 2.076365e-01            0  3.377576e+01
      6748 8.052496e-01            0  3.829510e+00
      6749 8.762857e-01            0  8.064225e+00
      6750 2.076365e-01            0  3.377576e+01
      6751 8.052496e-01            0  3.829510e+00
      6752 8.762857e-01            0  8.064225e+00
      6753 2.076365e-01            0  3.377576e+01
      6754 8.052496e-01            0  3.829510e+00
      6755 8.762857e-01            0  8.064225e+00
      6756 2.076365e-01            0  3.377576e+01
      6757 8.052496e-01            0  3.829510e+00
      6758 8.762857e-01            0  8.064225e+00
      6759 2.076365e-01            0  3.377576e+01
      6760 8.052496e-01            0  3.829510e+00
      6761 8.762857e-01            0  8.064225e+00
      6762 2.076365e-01            0  3.377576e+01
      6763 8.052496e-01            0  3.829510e+00
      6764 8.762857e-01            0  8.064225e+00
      6765 2.076365e-01            0  3.377576e+01
      6766 8.052496e-01            0  3.829510e+00
      6767 8.762857e-01            0  8.064225e+00
      6768 2.076365e-01            0  3.377576e+01
      6769 5.193743e-01            0 -1.062668e+01
      6770 7.878610e-02            0  9.314654e+01
      6771 1.113758e-02            1  6.284813e+01
      6772 5.193743e-01            0 -1.062668e+01
      6773 7.878610e-02            0  9.314654e+01
      6774 1.113758e-02            1  6.284813e+01
      6775 5.193743e-01            0 -1.062668e+01
      6776 7.878610e-02            0  9.314654e+01
      6777 1.113758e-02            1  6.284813e+01
      6778 5.193743e-01            0 -1.062668e+01
      6779 7.878610e-02            0  9.314654e+01
      6780 1.113758e-02            1  6.284813e+01
      6781 5.193743e-01            0 -1.062668e+01
      6782 7.878610e-02            0  9.314654e+01
      6783 1.113758e-02            1  6.284813e+01
      6784 5.193743e-01            0 -1.062668e+01
      6785 7.878610e-02            0  9.314654e+01
      6786 1.113758e-02            1  6.284813e+01
      6787 5.193743e-01            0 -1.062668e+01
      6788 7.878610e-02            0  9.314654e+01
      6789 1.113758e-02            1  6.284813e+01
      6790 5.193743e-01            0 -1.062668e+01
      6791 7.878610e-02            0  9.314654e+01
      6792 1.113758e-02            1  6.284813e+01
      6793 9.874169e-01            0 -3.850963e-01
      6794 6.774666e-01            0 -1.820265e+01
      6795 7.596357e-01            0  1.901026e+01
      6796 9.874169e-01            0 -3.850963e-01
      6797 6.774666e-01            0 -1.820265e+01
      6798 7.596357e-01            0  1.901026e+01
      6799 9.874169e-01            0 -3.850963e-01
      6800 6.774666e-01            0 -1.820265e+01
      6801 7.596357e-01            0  1.901026e+01
      6802 9.874169e-01            0 -3.850963e-01
      6803 6.774666e-01            0 -1.820265e+01
      6804 7.596357e-01            0  1.901026e+01
      6805 9.874169e-01            0 -3.850963e-01
      6806 6.774666e-01            0 -1.820265e+01
      6807 7.596357e-01            0  1.901026e+01
      6808 9.874169e-01            0 -3.850963e-01
      6809 6.774666e-01            0 -1.820265e+01
      6810 7.596357e-01            0  1.901026e+01
      6811 9.874169e-01            0 -3.850963e-01
      6812 6.774666e-01            0 -1.820265e+01
      6813 7.596357e-01            0  1.901026e+01
      6814 3.425069e-01            0 -7.685487e+00
      6815 2.882077e-01            0 -1.918012e+01
      6816 6.767344e-01            0  7.003896e+00
      6817 3.425069e-01            0 -7.685487e+00
      6818 2.882077e-01            0 -1.918012e+01
      6819 6.767344e-01            0  7.003896e+00
      6820 3.425069e-01            0 -7.685487e+00
      6821 2.882077e-01            0 -1.918012e+01
      6822 6.767344e-01            0  7.003896e+00
      6823 3.425069e-01            0 -7.685487e+00
      6824 2.882077e-01            0 -1.918012e+01
      6825 6.767344e-01            0  7.003896e+00
      6826 3.425069e-01            0 -7.685487e+00
      6827 2.882077e-01            0 -1.918012e+01
      6828 6.767344e-01            0  7.003896e+00
      6829 3.425069e-01            0 -7.685487e+00
      6830 2.882077e-01            0 -1.918012e+01
      6831 6.767344e-01            0  7.003896e+00
      6832 3.425069e-01            0 -7.685487e+00
      6833 2.882077e-01            0 -1.918012e+01
      6834 6.767344e-01            0  7.003896e+00
      6835 3.425069e-01            0 -7.685487e+00
      6836 2.882077e-01            0 -1.918012e+01
      6837 6.767344e-01            0  7.003896e+00
      6838 3.425069e-01            0 -7.685487e+00
      6839 2.882077e-01            0 -1.918012e+01
      6840 6.767344e-01            0  7.003896e+00
      6841 3.425069e-01            0 -7.685487e+00
      6842 2.882077e-01            0 -1.918012e+01
      6843 6.767344e-01            0  7.003896e+00
      6844 3.425069e-01            0 -7.685487e+00
      6845 2.882077e-01            0 -1.918012e+01
      6846 6.767344e-01            0  7.003896e+00
      6847 3.425069e-01            0 -7.685487e+00
      6848 2.882077e-01            0 -1.918012e+01
      6849 6.767344e-01            0  7.003896e+00
      6850 3.425069e-01            0 -7.685487e+00
      6851 2.882077e-01            0 -1.918012e+01
      6852 6.767344e-01            0  7.003896e+00
      6853 3.425069e-01            0 -7.685487e+00
      6854 2.882077e-01            0 -1.918012e+01
      6855 6.767344e-01            0  7.003896e+00
      6856 3.425069e-01            0 -7.685487e+00
      6857 2.882077e-01            0 -1.918012e+01
      6858 6.767344e-01            0  7.003896e+00
      6859 3.425069e-01            0 -7.685487e+00
      6860 2.882077e-01            0 -1.918012e+01
      6861 6.767344e-01            0  7.003896e+00
      6862 3.425069e-01            0 -7.685487e+00
      6863 2.882077e-01            0 -1.918012e+01
      6864 6.767344e-01            0  7.003896e+00
      6865 3.425069e-01            0 -7.685487e+00
      6866 2.882077e-01            0 -1.918012e+01
      6867 6.767344e-01            0  7.003896e+00
      6868 3.425069e-01            0 -7.685487e+00
      6869 2.882077e-01            0 -1.918012e+01
      6870 6.767344e-01            0  7.003896e+00
      6871 3.425069e-01            0 -7.685487e+00
      6872 2.882077e-01            0 -1.918012e+01
      6873 6.767344e-01            0  7.003896e+00
      6874 9.441309e-01            0  1.317327e+00
      6875 6.470372e-01            0 -2.834751e+01
      6876 4.466456e-01            0 -3.029388e+01
      6877 9.441309e-01            0  1.317327e+00
      6878 6.470372e-01            0 -2.834751e+01
      6879 4.466456e-01            0 -3.029388e+01
      6880 9.441309e-01            0  1.317327e+00
      6881 6.470372e-01            0 -2.834751e+01
      6882 4.466456e-01            0 -3.029388e+01
      6883 9.441309e-01            0  1.317327e+00
      6884 6.470372e-01            0 -2.834751e+01
      6885 4.466456e-01            0 -3.029388e+01
      6886 9.441309e-01            0  1.317327e+00
      6887 6.470372e-01            0 -2.834751e+01
      6888 4.466456e-01            0 -3.029388e+01
      6889 9.441309e-01            0  1.317327e+00
      6890 6.470372e-01            0 -2.834751e+01
      6891 4.466456e-01            0 -3.029388e+01
      6892 9.441309e-01            0  1.317327e+00
      6893 6.470372e-01            0 -2.834751e+01
      6894 4.466456e-01            0 -3.029388e+01
      6895 9.438586e-01            0  4.424576e+00
      6896 6.902560e-01            0  5.523786e+01
      6897 1.680745e-01            0  8.459113e+01
      6898 9.438586e-01            0  4.424576e+00
      6899 6.902560e-01            0  5.523786e+01
      6900 1.680745e-01            0  8.459113e+01
      6901 9.438586e-01            0  4.424576e+00
      6902 6.902560e-01            0  5.523786e+01
      6903 1.680745e-01            0  8.459113e+01
      6904 9.438586e-01            0  4.424576e+00
      6905 6.902560e-01            0  5.523786e+01
      6906 1.680745e-01            0  8.459113e+01
      6907 9.438586e-01            0  4.424576e+00
      6908 6.902560e-01            0  5.523786e+01
      6909 1.680745e-01            0  8.459113e+01
      6910 9.438586e-01            0  4.424576e+00
      6911 6.902560e-01            0  5.523786e+01
      6912 1.680745e-01            0  8.459113e+01
      6913 1.000000e+00            0  3.944444e-01
      6914 5.156098e-01            0 -1.692556e+02
      6915 6.608294e-01            0 -5.984887e+01
      6916 1.000000e+00            0  3.944444e-01
      6917 5.156098e-01            0 -1.692556e+02
      6918 6.608294e-01            0 -5.984887e+01
      6919 1.000000e+00            0  3.944444e-01
      6920 5.156098e-01            0 -1.692556e+02
      6921 6.608294e-01            0 -5.984887e+01
      6922 1.000000e+00            0  3.944444e-01
      6923 5.156098e-01            0 -1.692556e+02
      6924 6.608294e-01            0 -5.984887e+01
      6925 6.133103e-01            0 -2.517381e+00
      6926 2.144563e-01            0 -2.968926e+01
      6927 3.911635e-01            0  1.179664e+01
      6928 6.133103e-01            0 -2.517381e+00
      6929 2.144563e-01            0 -2.968926e+01
      6930 3.911635e-01            0  1.179664e+01
      6931 6.133103e-01            0 -2.517381e+00
      6932 2.144563e-01            0 -2.968926e+01
      6933 3.911635e-01            0  1.179664e+01
      6934 6.133103e-01            0 -2.517381e+00
      6935 2.144563e-01            0 -2.968926e+01
      6936 3.911635e-01            0  1.179664e+01
      6937 6.133103e-01            0 -2.517381e+00
      6938 2.144563e-01            0 -2.968926e+01
      6939 3.911635e-01            0  1.179664e+01
      6940 6.133103e-01            0 -2.517381e+00
      6941 2.144563e-01            0 -2.968926e+01
      6942 3.911635e-01            0  1.179664e+01
      6943 6.133103e-01            0 -2.517381e+00
      6944 2.144563e-01            0 -2.968926e+01
      6945 3.911635e-01            0  1.179664e+01
      6946 6.133103e-01            0 -2.517381e+00
      6947 2.144563e-01            0 -2.968926e+01
      6948 3.911635e-01            0  1.179664e+01
      6949 6.133103e-01            0 -2.517381e+00
      6950 2.144563e-01            0 -2.968926e+01
      6951 3.911635e-01            0  1.179664e+01
      6952 2.643564e-01            0  6.101091e+01
      6953 5.173134e-02            0 -2.118148e+02
      6954 3.177334e-01            0 -1.130272e+02
      6955 2.643564e-01            0  6.101091e+01
      6956 5.173134e-02            0 -2.118148e+02
      6957 3.177334e-01            0 -1.130272e+02
      6958 2.643564e-01            0  6.101091e+01
      6959 5.173134e-02            0 -2.118148e+02
      6960 3.177334e-01            0 -1.130272e+02
      6961 2.643564e-01            0  6.101091e+01
      6962 5.173134e-02            0 -2.118148e+02
      6963 3.177334e-01            0 -1.130272e+02
      6964 1.615715e-01            0  1.621552e+01
      6965 1.411362e-01            0 -1.779520e+01
      6966 3.480908e-01            0  1.482536e+02
      6967 1.615715e-01            0  1.621552e+01
      6968 1.411362e-01            0 -1.779520e+01
      6969 3.480908e-01            0  1.482536e+02
      6970 1.615715e-01            0  1.621552e+01
      6971 1.411362e-01            0 -1.779520e+01
      6972 3.480908e-01            0  1.482536e+02
      6973 6.259579e-01            0 -9.321472e+00
      6974 6.036761e-01            0 -1.452165e+01
      6975 1.880276e-01            0  2.368459e+01
      6976 6.259579e-01            0 -9.321472e+00
      6977 6.036761e-01            0 -1.452165e+01
      6978 1.880276e-01            0  2.368459e+01
      6979 6.259579e-01            0 -9.321472e+00
      6980 6.036761e-01            0 -1.452165e+01
      6981 1.880276e-01            0  2.368459e+01
      6982 6.259579e-01            0 -9.321472e+00
      6983 6.036761e-01            0 -1.452165e+01
      6984 1.880276e-01            0  2.368459e+01
      6985 2.648419e-01            0 -1.826751e+02
      6986 1.464786e-01            0  4.069463e+02
      6987 4.602529e-01            0 -1.700583e+02
      6988 2.648419e-01            0 -1.826751e+02
      6989 1.464786e-01            0  4.069463e+02
      6990 4.602529e-01            0 -1.700583e+02
      6991 2.648419e-01            0 -1.826751e+02
      6992 1.464786e-01            0  4.069463e+02
      6993 4.602529e-01            0 -1.700583e+02
      6994 2.320065e-01            0 -3.742817e+01
      6995 9.470913e-01            0  6.012934e+00
      6996 9.576068e-01            0  3.901944e+00
      6997 2.320065e-01            0 -3.742817e+01
      6998 9.470913e-01            0  6.012934e+00
      6999 9.576068e-01            0  3.901944e+00
      7000 2.320065e-01            0 -3.742817e+01
      7001 9.470913e-01            0  6.012934e+00
      7002 9.576068e-01            0  3.901944e+00
      7003 2.320065e-01            0 -3.742817e+01
      7004 9.470913e-01            0  6.012934e+00
      7005 9.576068e-01            0  3.901944e+00
      7006 2.320065e-01            0 -3.742817e+01
      7007 9.470913e-01            0  6.012934e+00
      7008 9.576068e-01            0  3.901944e+00
      7009 2.320065e-01            0 -3.742817e+01
      7010 9.470913e-01            0  6.012934e+00
      7011 9.576068e-01            0  3.901944e+00
      7012 2.320065e-01            0 -3.742817e+01
      7013 9.470913e-01            0  6.012934e+00
      7014 9.576068e-01            0  3.901944e+00
      7015 7.127145e-01            0  6.033399e+00
      7016 3.562713e-01            0 -1.551573e+01
      7017 5.989568e-01            0 -1.101223e+01
      7018 7.127145e-01            0  6.033399e+00
      7019 3.562713e-01            0 -1.551573e+01
      7020 5.989568e-01            0 -1.101223e+01
      7021 7.127145e-01            0  6.033399e+00
      7022 3.562713e-01            0 -1.551573e+01
      7023 5.989568e-01            0 -1.101223e+01
      7024 7.127145e-01            0  6.033399e+00
      7025 3.562713e-01            0 -1.551573e+01
      7026 5.989568e-01            0 -1.101223e+01
      7027 7.127145e-01            0  6.033399e+00
      7028 3.562713e-01            0 -1.551573e+01
      7029 5.989568e-01            0 -1.101223e+01
      7030 7.127145e-01            0  6.033399e+00
      7031 3.562713e-01            0 -1.551573e+01
      7032 5.989568e-01            0 -1.101223e+01
      7033 7.127145e-01            0  6.033399e+00
      7034 3.562713e-01            0 -1.551573e+01
      7035 5.989568e-01            0 -1.101223e+01
      7036 7.127145e-01            0  6.033399e+00
      7037 3.562713e-01            0 -1.551573e+01
      7038 5.989568e-01            0 -1.101223e+01
      7039 7.127145e-01            0  6.033399e+00
      7040 3.562713e-01            0 -1.551573e+01
      7041 5.989568e-01            0 -1.101223e+01
      7042 8.695385e-01            0 -2.052199e+01
      7043 2.071968e-01            0  9.087345e+01
      7044 6.565059e-01            0  3.354173e+01
      7045 8.695385e-01            0 -2.052199e+01
      7046 2.071968e-01            0  9.087345e+01
      7047 6.565059e-01            0  3.354173e+01
      7048 8.695385e-01            0 -2.052199e+01
      7049 2.071968e-01            0  9.087345e+01
      7050 6.565059e-01            0  3.354173e+01
      7051 7.563146e-01            0  8.321302e+00
      7052 6.277619e-01            0 -1.018113e+00
      7053 3.703338e-01            0  6.660923e+01
      7054 7.563146e-01            0  8.321302e+00
      7055 6.277619e-01            0 -1.018113e+00
      7056 3.703338e-01            0  6.660923e+01
      7057 7.563146e-01            0  8.321302e+00
      7058 6.277619e-01            0 -1.018113e+00
      7059 3.703338e-01            0  6.660923e+01
      7060 7.563146e-01            0  8.321302e+00
      7061 6.277619e-01            0 -1.018113e+00
      7062 3.703338e-01            0  6.660923e+01
      7063 7.563146e-01            0  8.321302e+00
      7064 6.277619e-01            0 -1.018113e+00
      7065 3.703338e-01            0  6.660923e+01
      7066 7.563146e-01            0  8.321302e+00
      7067 6.277619e-01            0 -1.018113e+00
      7068 3.703338e-01            0  6.660923e+01
      7069 7.563146e-01            0  8.321302e+00
      7070 6.277619e-01            0 -1.018113e+00
      7071 3.703338e-01            0  6.660923e+01
      7072 7.563146e-01            0  8.321302e+00
      7073 6.277619e-01            0 -1.018113e+00
      7074 3.703338e-01            0  6.660923e+01
      7075 8.455953e-02            0  2.286986e+01
      7076 1.240672e-01            0 -3.486659e+00
      7077 6.334920e-02            0 -3.972652e+01
      7078 8.455953e-02            0  2.286986e+01
      7079 1.240672e-01            0 -3.486659e+00
      7080 6.334920e-02            0 -3.972652e+01
      7081 8.455953e-02            0  2.286986e+01
      7082 1.240672e-01            0 -3.486659e+00
      7083 6.334920e-02            0 -3.972652e+01
      7084 8.455953e-02            0  2.286986e+01
      7085 1.240672e-01            0 -3.486659e+00
      7086 6.334920e-02            0 -3.972652e+01
      7087 8.822352e-01            0  4.774220e+00
      7088 8.168084e-01            0  2.268181e-01
      7089 9.007981e-01            0  3.183837e+00
      7090 8.822352e-01            0  4.774220e+00
      7091 8.168084e-01            0  2.268181e-01
      7092 9.007981e-01            0  3.183837e+00
      7093 8.822352e-01            0  4.774220e+00
      7094 8.168084e-01            0  2.268181e-01
      7095 9.007981e-01            0  3.183837e+00
      7096 8.822352e-01            0  4.774220e+00
      7097 8.168084e-01            0  2.268181e-01
      7098 9.007981e-01            0  3.183837e+00
      7099 8.822352e-01            0  4.774220e+00
      7100 8.168084e-01            0  2.268181e-01
      7101 9.007981e-01            0  3.183837e+00
      7102 2.225076e-01            0 -2.177399e+01
      7103 5.897916e-01            0  1.809895e+01
      7104 5.859919e-01            0 -1.623394e+01
      7105 2.225076e-01            0 -2.177399e+01
      7106 5.897916e-01            0  1.809895e+01
      7107 5.859919e-01            0 -1.623394e+01
      7108 2.225076e-01            0 -2.177399e+01
      7109 5.897916e-01            0  1.809895e+01
      7110 5.859919e-01            0 -1.623394e+01
      7111 2.225076e-01            0 -2.177399e+01
      7112 5.897916e-01            0  1.809895e+01
      7113 5.859919e-01            0 -1.623394e+01
      7114 2.225076e-01            0 -2.177399e+01
      7115 5.897916e-01            0  1.809895e+01
      7116 5.859919e-01            0 -1.623394e+01
      7117 2.225076e-01            0 -2.177399e+01
      7118 5.897916e-01            0  1.809895e+01
      7119 5.859919e-01            0 -1.623394e+01
      7120 2.225076e-01            0 -2.177399e+01
      7121 5.897916e-01            0  1.809895e+01
      7122 5.859919e-01            0 -1.623394e+01
      7123 2.225076e-01            0 -2.177399e+01
      7124 5.897916e-01            0  1.809895e+01
      7125 5.859919e-01            0 -1.623394e+01
      7126 8.250307e-01            0 -1.627581e+00
      7127 7.407776e-01            0  1.138373e+01
      7128 4.751933e-01            0  1.486917e+01
      7129 8.250307e-01            0 -1.627581e+00
      7130 7.407776e-01            0  1.138373e+01
      7131 4.751933e-01            0  1.486917e+01
      7132 8.250307e-01            0 -1.627581e+00
      7133 7.407776e-01            0  1.138373e+01
      7134 4.751933e-01            0  1.486917e+01
      7135 8.250307e-01            0 -1.627581e+00
      7136 7.407776e-01            0  1.138373e+01
      7137 4.751933e-01            0  1.486917e+01
      7138 8.250307e-01            0 -1.627581e+00
      7139 7.407776e-01            0  1.138373e+01
      7140 4.751933e-01            0  1.486917e+01
      7141 8.250307e-01            0 -1.627581e+00
      7142 7.407776e-01            0  1.138373e+01
      7143 4.751933e-01            0  1.486917e+01
      7144 8.250307e-01            0 -1.627581e+00
      7145 7.407776e-01            0  1.138373e+01
      7146 4.751933e-01            0  1.486917e+01
      7147 8.250307e-01            0 -1.627581e+00
      7148 7.407776e-01            0  1.138373e+01
      7149 4.751933e-01            0  1.486917e+01
      7150 8.250307e-01            0 -1.627581e+00
      7151 7.407776e-01            0  1.138373e+01
      7152 4.751933e-01            0  1.486917e+01
      7153 8.250307e-01            0 -1.627581e+00
      7154 7.407776e-01            0  1.138373e+01
      7155 4.751933e-01            0  1.486917e+01
      7156 8.250307e-01            0 -1.627581e+00
      7157 7.407776e-01            0  1.138373e+01
      7158 4.751933e-01            0  1.486917e+01
      7159 8.250307e-01            0 -1.627581e+00
      7160 7.407776e-01            0  1.138373e+01
      7161 4.751933e-01            0  1.486917e+01
      7162 4.714964e-01            0 -7.153259e+00
      7163 1.243303e-01            0 -4.581584e+01
      7164 2.775486e-01            0 -2.269418e+01
      7165 4.714964e-01            0 -7.153259e+00
      7166 1.243303e-01            0 -4.581584e+01
      7167 2.775486e-01            0 -2.269418e+01
      7168 4.714964e-01            0 -7.153259e+00
      7169 1.243303e-01            0 -4.581584e+01
      7170 2.775486e-01            0 -2.269418e+01
      7171 4.714964e-01            0 -7.153259e+00
      7172 1.243303e-01            0 -4.581584e+01
      7173 2.775486e-01            0 -2.269418e+01
      7174 4.714964e-01            0 -7.153259e+00
      7175 1.243303e-01            0 -4.581584e+01
      7176 2.775486e-01            0 -2.269418e+01
      7177 4.714964e-01            0 -7.153259e+00
      7178 1.243303e-01            0 -4.581584e+01
      7179 2.775486e-01            0 -2.269418e+01
      7180 4.714964e-01            0 -7.153259e+00
      7181 1.243303e-01            0 -4.581584e+01
      7182 2.775486e-01            0 -2.269418e+01
      7183 4.714964e-01            0 -7.153259e+00
      7184 1.243303e-01            0 -4.581584e+01
      7185 2.775486e-01            0 -2.269418e+01
      7186 4.714964e-01            0 -7.153259e+00
      7187 1.243303e-01            0 -4.581584e+01
      7188 2.775486e-01            0 -2.269418e+01
      7189 4.714964e-01            0 -7.153259e+00
      7190 1.243303e-01            0 -4.581584e+01
      7191 2.775486e-01            0 -2.269418e+01
      7192 9.681676e-03            1 -4.771699e+01
      7193 8.483759e-01            0 -9.535970e+00
      7194 2.243032e-01            0 -4.121010e+01
      7195 9.681676e-03            1 -4.771699e+01
      7196 8.483759e-01            0 -9.535970e+00
      7197 2.243032e-01            0 -4.121010e+01
      7198 9.681676e-03            1 -4.771699e+01
      7199 8.483759e-01            0 -9.535970e+00
      7200 2.243032e-01            0 -4.121010e+01
      7201 9.681676e-03            1 -4.771699e+01
      7202 8.483759e-01            0 -9.535970e+00
      7203 2.243032e-01            0 -4.121010e+01
      7204 9.681676e-03            1 -4.771699e+01
      7205 8.483759e-01            0 -9.535970e+00
      7206 2.243032e-01            0 -4.121010e+01
      7207 9.681676e-03            1 -4.771699e+01
      7208 8.483759e-01            0 -9.535970e+00
      7209 2.243032e-01            0 -4.121010e+01
      7210 8.198886e-01            0 -2.277065e+00
      7211 2.219512e-01            0 -4.523001e+01
      7212 9.895470e-01            0  3.511388e-01
      7213 8.198886e-01            0 -2.277065e+00
      7214 2.219512e-01            0 -4.523001e+01
      7215 9.895470e-01            0  3.511388e-01
      7216 8.198886e-01            0 -2.277065e+00
      7217 2.219512e-01            0 -4.523001e+01
      7218 9.895470e-01            0  3.511388e-01
      7219 8.198886e-01            0 -2.277065e+00
      7220 2.219512e-01            0 -4.523001e+01
      7221 9.895470e-01            0  3.511388e-01
      7222 8.198886e-01            0 -2.277065e+00
      7223 2.219512e-01            0 -4.523001e+01
      7224 9.895470e-01            0  3.511388e-01
      7225 8.198886e-01            0 -2.277065e+00
      7226 2.219512e-01            0 -4.523001e+01
      7227 9.895470e-01            0  3.511388e-01
      7228 6.234915e-01            0 -9.780828e+00
      7229 6.946504e-01            0  3.882584e+01
      7230 9.253679e-01            0 -5.739457e+00
      7231 6.234915e-01            0 -9.780828e+00
      7232 6.946504e-01            0  3.882584e+01
      7233 9.253679e-01            0 -5.739457e+00
      7234 6.234915e-01            0 -9.780828e+00
      7235 6.946504e-01            0  3.882584e+01
      7236 9.253679e-01            0 -5.739457e+00
      7237 9.244364e-01            0  3.298537e+00
      7238 8.278546e-01            0  7.219451e+00
      7239 9.466808e-01            0  4.009409e+00
      7240 9.244364e-01            0  3.298537e+00
      7241 8.278546e-01            0  7.219451e+00
      7242 9.466808e-01            0  4.009409e+00
      7243 9.244364e-01            0  3.298537e+00
      7244 8.278546e-01            0  7.219451e+00
      7245 9.466808e-01            0  4.009409e+00
      7246 9.244364e-01            0  3.298537e+00
      7247 8.278546e-01            0  7.219451e+00
      7248 9.466808e-01            0  4.009409e+00
      7249 3.698052e-01            0  3.111774e+01
      7250 9.143572e-01            0  8.981282e+00
      7251 3.875211e-01            0 -5.302126e+01
      7252 3.698052e-01            0  3.111774e+01
      7253 9.143572e-01            0  8.981282e+00
      7254 3.875211e-01            0 -5.302126e+01
      7255 3.698052e-01            0  3.111774e+01
      7256 9.143572e-01            0  8.981282e+00
      7257 3.875211e-01            0 -5.302126e+01
      7258 3.333333e-01            0 -2.209630e+02
      7259 3.402753e-01            0 -3.569736e+02
      7260 6.725096e-01            0 -1.609656e+02
      7261 3.333333e-01            0 -2.209630e+02
      7262 3.402753e-01            0 -3.569736e+02
      7263 6.725096e-01            0 -1.609656e+02
      7264 3.333333e-01            0 -2.209630e+02
      7265 3.402753e-01            0 -3.569736e+02
      7266 6.725096e-01            0 -1.609656e+02
      7267 6.847438e-01            0 -3.976444e+01
      7268 1.615843e-01            0 -4.915944e-01
      7269 3.841353e-01            0  1.417721e+02
      7270 6.847438e-01            0 -3.976444e+01
      7271 1.615843e-01            0 -4.915944e-01
      7272 3.841353e-01            0  1.417721e+02
      7273 6.847438e-01            0 -3.976444e+01
      7274 1.615843e-01            0 -4.915944e-01
      7275 3.841353e-01            0  1.417721e+02
      7276 6.847438e-01            0 -3.976444e+01
      7277 1.615843e-01            0 -4.915944e-01
      7278 3.841353e-01            0  1.417721e+02
      7279 7.348788e-01            0 -1.145685e+01
      7280 7.172269e-01            0 -3.012700e+01
      7281 7.695251e-01            0 -1.696658e+01
      7282 7.348788e-01            0 -1.145685e+01
      7283 7.172269e-01            0 -3.012700e+01
      7284 7.695251e-01            0 -1.696658e+01
      7285 7.348788e-01            0 -1.145685e+01
      7286 7.172269e-01            0 -3.012700e+01
      7287 7.695251e-01            0 -1.696658e+01
      7288 7.348788e-01            0 -1.145685e+01
      7289 7.172269e-01            0 -3.012700e+01
      7290 7.695251e-01            0 -1.696658e+01
      7291 7.348788e-01            0 -1.145685e+01
      7292 7.172269e-01            0 -3.012700e+01
      7293 7.695251e-01            0 -1.696658e+01
      7294 2.775716e-01            0  3.907699e+01
      7295 5.380643e-01            0  7.018574e+01
      7296 8.200212e-01            0  1.536714e+01
      7297 2.775716e-01            0  3.907699e+01
      7298 5.380643e-01            0  7.018574e+01
      7299 8.200212e-01            0  1.536714e+01
      7300 2.775716e-01            0  3.907699e+01
      7301 5.380643e-01            0  7.018574e+01
      7302 8.200212e-01            0  1.536714e+01
      7303 2.775716e-01            0  3.907699e+01
      7304 5.380643e-01            0  7.018574e+01
      7305 8.200212e-01            0  1.536714e+01
      7306 2.775716e-01            0  3.907699e+01
      7307 5.380643e-01            0  7.018574e+01
      7308 8.200212e-01            0  1.536714e+01
      7309 2.775716e-01            0  3.907699e+01
      7310 5.380643e-01            0  7.018574e+01
      7311 8.200212e-01            0  1.536714e+01
      7312 2.775716e-01            0  3.907699e+01
      7313 5.380643e-01            0  7.018574e+01
      7314 8.200212e-01            0  1.536714e+01
      7315 2.264126e-01            0 -3.247131e+01
      7316 1.154227e-01            0 -1.344629e+02
      7317 5.628986e-02            0 -1.103007e+02
      7318 2.264126e-01            0 -3.247131e+01
      7319 1.154227e-01            0 -1.344629e+02
      7320 5.628986e-02            0 -1.103007e+02
      7321 2.264126e-01            0 -3.247131e+01
      7322 1.154227e-01            0 -1.344629e+02
      7323 5.628986e-02            0 -1.103007e+02
      7324 2.264126e-01            0 -3.247131e+01
      7325 1.154227e-01            0 -1.344629e+02
      7326 5.628986e-02            0 -1.103007e+02
      7327 2.264126e-01            0 -3.247131e+01
      7328 1.154227e-01            0 -1.344629e+02
      7329 5.628986e-02            0 -1.103007e+02
      7330 2.264126e-01            0 -3.247131e+01
      7331 1.154227e-01            0 -1.344629e+02
      7332 5.628986e-02            0 -1.103007e+02
      7333 2.264126e-01            0 -3.247131e+01
      7334 1.154227e-01            0 -1.344629e+02
      7335 5.628986e-02            0 -1.103007e+02
      7336 8.658503e-01            0 -4.650687e+00
      7337 4.364984e-02            1  8.925219e+01
      7338 5.085933e-01            0  1.992912e+01
      7339 8.658503e-01            0 -4.650687e+00
      7340 4.364984e-02            1  8.925219e+01
      7341 5.085933e-01            0  1.992912e+01
      7342 8.658503e-01            0 -4.650687e+00
      7343 4.364984e-02            1  8.925219e+01
      7344 5.085933e-01            0  1.992912e+01
      7345 8.658503e-01            0 -4.650687e+00
      7346 4.364984e-02            1  8.925219e+01
      7347 5.085933e-01            0  1.992912e+01
      7348 8.658503e-01            0 -4.650687e+00
      7349 4.364984e-02            1  8.925219e+01
      7350 5.085933e-01            0  1.992912e+01
      7351 8.658503e-01            0 -4.650687e+00
      7352 4.364984e-02            1  8.925219e+01
      7353 5.085933e-01            0  1.992912e+01
      7354 8.658503e-01            0 -4.650687e+00
      7355 4.364984e-02            1  8.925219e+01
      7356 5.085933e-01            0  1.992912e+01
      7357 8.658503e-01            0 -4.650687e+00
      7358 4.364984e-02            1  8.925219e+01
      7359 5.085933e-01            0  1.992912e+01
      7360 8.815062e-01            0 -1.692843e+01
      7361 8.625666e-01            0  4.895228e+01
      7362 8.297734e-01            0  3.974124e+01
      7363 8.815062e-01            0 -1.692843e+01
      7364 8.625666e-01            0  4.895228e+01
      7365 8.297734e-01            0  3.974124e+01
      7366 8.815062e-01            0 -1.692843e+01
      7367 8.625666e-01            0  4.895228e+01
      7368 8.297734e-01            0  3.974124e+01
      7369 8.815062e-01            0 -1.692843e+01
      7370 8.625666e-01            0  4.895228e+01
      7371 8.297734e-01            0  3.974124e+01
      7372 8.815062e-01            0 -1.692843e+01
      7373 8.625666e-01            0  4.895228e+01
      7374 8.297734e-01            0  3.974124e+01
      7375 1.857185e-02            1  8.246527e+01
      7376 6.177226e-01            0  7.473344e+01
      7377 8.845325e-01            0  3.371448e+01
      7378 1.857185e-02            1  8.246527e+01
      7379 6.177226e-01            0  7.473344e+01
      7380 8.845325e-01            0  3.371448e+01
      7381 1.857185e-02            1  8.246527e+01
      7382 6.177226e-01            0  7.473344e+01
      7383 8.845325e-01            0  3.371448e+01
      7384 1.857185e-02            1  8.246527e+01
      7385 6.177226e-01            0  7.473344e+01
      7386 8.845325e-01            0  3.371448e+01
      7387 7.481094e-01            0 -2.167825e+01
      7388 4.781420e-01            0 -6.391617e+01
      7389 4.764461e-01            0 -4.359531e+01
      7390 7.481094e-01            0 -2.167825e+01
      7391 4.781420e-01            0 -6.391617e+01
      7392 4.764461e-01            0 -4.359531e+01
      7393 7.481094e-01            0 -2.167825e+01
      7394 4.781420e-01            0 -6.391617e+01
      7395 4.764461e-01            0 -4.359531e+01
      7396 1.641498e-02            1  1.153229e+02
      7397 7.449769e-02            0  2.147263e+02
      7398 5.218560e-02            0  1.215022e+02
      7399 1.641498e-02            1  1.153229e+02
      7400 7.449769e-02            0  2.147263e+02
      7401 5.218560e-02            0  1.215022e+02
      7402 1.641498e-02            1  1.153229e+02
      7403 7.449769e-02            0  2.147263e+02
      7404 5.218560e-02            0  1.215022e+02
      7405 1.641498e-02            1  1.153229e+02
      7406 7.449769e-02            0  2.147263e+02
      7407 5.218560e-02            0  1.215022e+02
      7408 2.638507e-02            1  8.192669e+01
      7409 3.215823e-01            0  4.123468e+01
      7410 1.542990e-01            0  8.446988e+01
      7411 2.638507e-02            1  8.192669e+01
      7412 3.215823e-01            0  4.123468e+01
      7413 1.542990e-01            0  8.446988e+01
      7414 2.638507e-02            1  8.192669e+01
      7415 3.215823e-01            0  4.123468e+01
      7416 1.542990e-01            0  8.446988e+01
      7417 2.638507e-02            1  8.192669e+01
      7418 3.215823e-01            0  4.123468e+01
      7419 1.542990e-01            0  8.446988e+01
      7420 2.638270e-01            0  7.690395e+01
      7421 4.422238e-01            0  7.419245e+01
      7422 4.138335e-02            1  8.509208e+01
      7423 2.638270e-01            0  7.690395e+01
      7424 4.422238e-01            0  7.419245e+01
      7425 4.138335e-02            1  8.509208e+01
      7426 2.638270e-01            0  7.690395e+01
      7427 4.422238e-01            0  7.419245e+01
      7428 4.138335e-02            1  8.509208e+01
      7429 2.638270e-01            0  7.690395e+01
      7430 4.422238e-01            0  7.419245e+01
      7431 4.138335e-02            1  8.509208e+01
      7432 1.793857e-01            0 -2.968622e+01
      7433 3.214003e-01            0 -7.848219e+01
      7434 1.016688e-01            0 -5.410236e+01
      7435 1.793857e-01            0 -2.968622e+01
      7436 3.214003e-01            0 -7.848219e+01
      7437 1.016688e-01            0 -5.410236e+01
      7438 1.793857e-01            0 -2.968622e+01
      7439 3.214003e-01            0 -7.848219e+01
      7440 1.016688e-01            0 -5.410236e+01
      7441 6.501379e-01            0 -2.320774e+01
      7442 7.405010e-01            0 -7.261518e+01
      7443 9.294199e-01            0 -1.026415e+01
      7444 6.501379e-01            0 -2.320774e+01
      7445 7.405010e-01            0 -7.261518e+01
      7446 9.294199e-01            0 -1.026415e+01
      7447 6.501379e-01            0 -2.320774e+01
      7448 7.405010e-01            0 -7.261518e+01
      7449 9.294199e-01            0 -1.026415e+01
      7450 5.952543e-01            0 -2.735877e+01
      7451 6.069530e-01            0 -3.181630e+01
      7452 5.029739e-01            0 -3.355086e+01
      7453 5.952543e-01            0 -2.735877e+01
      7454 6.069530e-01            0 -3.181630e+01
      7455 5.029739e-01            0 -3.355086e+01
      7456 5.952543e-01            0 -2.735877e+01
      7457 6.069530e-01            0 -3.181630e+01
      7458 5.029739e-01            0 -3.355086e+01
      7459 7.902396e-02            0 -6.106661e+01
      7460 9.702324e-01            0  3.399236e+00
      7461 4.608442e-01            0 -7.201138e+01
      7462 7.902396e-02            0 -6.106661e+01
      7463 9.702324e-01            0  3.399236e+00
      7464 4.608442e-01            0 -7.201138e+01
      7465 7.902396e-02            0 -6.106661e+01
      7466 9.702324e-01            0  3.399236e+00
      7467 4.608442e-01            0 -7.201138e+01

---

    Code
      set.seed(42)
      gridding(meta, btf) %>% resampling(measure = "BIOMASS", resamps = 1L) %>%
        getBetaMetrics(measure = "BIOMASS") %>% getLinearRegressions(divType = "beta")
    Message
      OK: all SL studies have 1 grid cell
    Condition
      Warning in `resampling()`:
      NA values found and removed.
      Only a subset of `x` is used.
    Output
          YEAR assemblageID           metric dissimilarity        slope      pvalue
      1   1980   211_528514      JaccardDiss    0.56089010  0.016466117 0.229606351
      2   1980   211_528514 MorisitaHornDiss    0.30941089  0.011510256 0.741736591
      3   1980   211_528514   BrayCurtisDiss    0.74911796 -0.001134076 0.943233207
      4   1982   211_528514      JaccardDiss    0.68506589  0.016466117 0.229606351
      5   1982   211_528514 MorisitaHornDiss    0.24569272  0.011510256 0.741736591
      6   1982   211_528514   BrayCurtisDiss    0.60502936 -0.001134076 0.943233207
      7   1985   211_528514      JaccardDiss    0.69466228  0.016466117 0.229606351
      8   1985   211_528514 MorisitaHornDiss    0.62571400  0.011510256 0.741736591
      9   1985   211_528514   BrayCurtisDiss    0.70262391 -0.001134076 0.943233207
      10  1986   211_528514      JaccardDiss    0.76154207  0.016466117 0.229606351
      11  1986   211_528514 MorisitaHornDiss    0.21089100  0.011510256 0.741736591
      12  1986   211_528514   BrayCurtisDiss    0.78037190 -0.001134076 0.943233207
      13  1987   211_528514      JaccardDiss    0.65193125  0.016466117 0.229606351
      14  1987   211_528514 MorisitaHornDiss    0.35762722  0.011510256 0.741736591
      15  1987   211_528514   BrayCurtisDiss    0.63486808 -0.001134076 0.943233207
      16  1983   211_524878      JaccardDiss    0.57738971 -0.030644828 0.061738185
      17  1983   211_524878 MorisitaHornDiss    0.22691635 -0.060114737 0.209823011
      18  1983   211_524878   BrayCurtisDiss    0.38502948 -0.042005035 0.232230755
      19  1987   211_524878      JaccardDiss    0.54145577 -0.030644828 0.061738185
      20  1987   211_524878 MorisitaHornDiss    0.34097951 -0.060114737 0.209823011
      21  1987   211_524878   BrayCurtisDiss    0.69626350 -0.042005035 0.232230755
      22  1982   211_524878      JaccardDiss    0.68693128 -0.030644828 0.061738185
      23  1982   211_524878 MorisitaHornDiss    0.34014119 -0.060114737 0.209823011
      24  1982   211_524878   BrayCurtisDiss    0.84641268 -0.042005035 0.232230755
      25  1981   211_524878      JaccardDiss    0.77388063 -0.030644828 0.061738185
      26  1981   211_524878 MorisitaHornDiss    0.97151872 -0.060114737 0.209823011
      27  1981   211_524878   BrayCurtisDiss    0.92872332 -0.042005035 0.232230755
      28  1984   211_524878      JaccardDiss    0.77171564 -0.030644828 0.061738185
      29  1984   211_524878 MorisitaHornDiss    0.33253371 -0.060114737 0.209823011
      30  1984   211_524878   BrayCurtisDiss    0.85275193 -0.042005035 0.232230755
      31  1980   211_524878      JaccardDiss    0.82896149 -0.030644828 0.061738185
      32  1980   211_524878 MorisitaHornDiss    0.39297574 -0.060114737 0.209823011
      33  1980   211_524878   BrayCurtisDiss    0.90572387 -0.042005035 0.232230755
      34  1986   211_524878      JaccardDiss    0.65215602 -0.030644828 0.061738185
      35  1986   211_524878 MorisitaHornDiss    0.05147589 -0.060114737 0.209823011
      36  1986   211_524878   BrayCurtisDiss    0.53257869 -0.042005035 0.232230755
      37  1985   211_521245      JaccardDiss    0.73550514  0.007492335 0.756120147
      38  1985   211_521245 MorisitaHornDiss    0.82061871 -0.018813874 0.471069461
      39  1985   211_521245   BrayCurtisDiss    0.73336243 -0.014953472 0.568542113
      40  1980   211_521245      JaccardDiss    0.51059112  0.007492335 0.756120147
      41  1980   211_521245 MorisitaHornDiss    0.81701213 -0.018813874 0.471069461
      42  1980   211_521245   BrayCurtisDiss    0.82270828 -0.014953472 0.568542113
      43  1984   211_521245      JaccardDiss    0.59068692  0.007492335 0.756120147
      44  1984   211_521245 MorisitaHornDiss    0.45395670 -0.018813874 0.471069461
      45  1984   211_521245   BrayCurtisDiss    0.47460035 -0.014953472 0.568542113
      46  1987   211_521245      JaccardDiss    0.80055687  0.007492335 0.756120147
      47  1987   211_521245 MorisitaHornDiss    0.76785608 -0.018813874 0.471069461
      48  1987   211_521245   BrayCurtisDiss    0.79127730 -0.014953472 0.568542113
      49  1981   211_521245      JaccardDiss    0.92367347  0.007492335 0.756120147
      50  1981   211_521245 MorisitaHornDiss    0.89430825 -0.018813874 0.471069461
      51  1981   211_521245   BrayCurtisDiss    0.94891966 -0.014953472 0.568542113
      52  1982   211_521245      JaccardDiss    0.72999516  0.007492335 0.756120147
      53  1982   211_521245 MorisitaHornDiss    0.89709119 -0.018813874 0.471069461
      54  1982   211_521245   BrayCurtisDiss    0.82720649 -0.014953472 0.568542113
      55  1986   211_521245      JaccardDiss    0.66283129  0.007492335 0.756120147
      56  1986   211_521245 MorisitaHornDiss    0.75885885 -0.018813874 0.471069461
      57  1986   211_521245   BrayCurtisDiss    0.86076694 -0.014953472 0.568542113
      58  1980   211_522693      JaccardDiss    0.69009328  0.027572520 0.108677342
      59  1980   211_522693 MorisitaHornDiss    0.01601993  0.050219603 0.282118088
      60  1980   211_522693   BrayCurtisDiss    0.18444386  0.032042257 0.421384744
      61  1983   211_522693      JaccardDiss    0.75025613  0.027572520 0.108677342
      62  1983   211_522693 MorisitaHornDiss    0.16110848  0.050219603 0.282118088
      63  1983   211_522693   BrayCurtisDiss    0.51029788  0.032042257 0.421384744
      64  1984   211_522693      JaccardDiss    0.67844317  0.027572520 0.108677342
      65  1984   211_522693 MorisitaHornDiss    0.62689318  0.050219603 0.282118088
      66  1984   211_522693   BrayCurtisDiss    0.83640801  0.032042257 0.421384744
      67  1985   211_522693      JaccardDiss    0.71652401  0.027572520 0.108677342
      68  1985   211_522693 MorisitaHornDiss    0.17193979  0.050219603 0.282118088
      69  1985   211_522693   BrayCurtisDiss    0.41671864  0.032042257 0.421384744
      70  1986   211_522693      JaccardDiss    0.70280634  0.027572520 0.108677342
      71  1986   211_522693 MorisitaHornDiss    0.76711190  0.050219603 0.282118088
      72  1986   211_522693   BrayCurtisDiss    0.78446333  0.032042257 0.421384744
      73  1987   211_522693      JaccardDiss    0.82734265  0.027572520 0.108677342
      74  1987   211_522693 MorisitaHornDiss    0.06762238  0.050219603 0.282118088
      75  1987   211_522693   BrayCurtisDiss    0.43103148  0.032042257 0.421384744
      76  1982   211_522693      JaccardDiss    0.67878847  0.027572520 0.108677342
      77  1982   211_522693 MorisitaHornDiss    0.04316540  0.050219603 0.282118088
      78  1982   211_522693   BrayCurtisDiss    0.81324957  0.032042257 0.421384744
      79  1981   211_522693      JaccardDiss    0.44001586  0.027572520 0.108677342
      80  1981   211_522693 MorisitaHornDiss    0.16608757  0.050219603 0.282118088
      81  1981   211_522693   BrayCurtisDiss    0.41867955  0.032042257 0.421384744
      82  1981   211_516876      JaccardDiss    0.67052995  0.020103306 0.735137376
      83  1981   211_516876 MorisitaHornDiss    0.03009010  0.005039937 0.975352494
      84  1981   211_516876   BrayCurtisDiss    0.19397706  0.093904330 0.392267026
      85  1983   211_516876      JaccardDiss    0.69867947  0.020103306 0.735137376
      86  1983   211_516876 MorisitaHornDiss    0.12643500  0.005039937 0.975352494
      87  1983   211_516876   BrayCurtisDiss    0.66202183  0.093904330 0.392267026
      88  1980   211_516876      JaccardDiss    0.58717670  0.020103306 0.735137376
      89  1980   211_516876 MorisitaHornDiss    0.08775335  0.005039937 0.975352494
      90  1980   211_516876   BrayCurtisDiss    0.44198184  0.093904330 0.392267026
      91  1982   211_516876      JaccardDiss    0.98336710  0.020103306 0.735137376
      92  1982   211_516876 MorisitaHornDiss    0.99435396  0.005039937 0.975352494
      93  1982   211_516876   BrayCurtisDiss    0.99352536  0.093904330 0.392267026
      94  1984   211_516876      JaccardDiss    0.67361846  0.020103306 0.735137376
      95  1984   211_516876 MorisitaHornDiss    0.06478059  0.005039937 0.975352494
      96  1984   211_516876   BrayCurtisDiss    0.67748110  0.093904330 0.392267026
      97  1984   211_516147      JaccardDiss    0.70840042  0.013562248 0.009648326
      98  1984   211_516147 MorisitaHornDiss    0.05632822 -0.049345362 0.410116711
      99  1984   211_516147   BrayCurtisDiss    0.64314179 -0.007715775 0.926900414
      100 1985   211_516147      JaccardDiss    0.72630792  0.013562248 0.009648326
      101 1985   211_516147 MorisitaHornDiss    0.09252659 -0.049345362 0.410116711
      102 1985   211_516147   BrayCurtisDiss    0.94077625 -0.007715775 0.926900414
      103 1982   211_516147      JaccardDiss    0.68374165  0.013562248 0.009648326
      104 1982   211_516147 MorisitaHornDiss    0.26719491 -0.049345362 0.410116711
      105 1982   211_516147   BrayCurtisDiss    0.91609204 -0.007715775 0.926900414
      106 1983   211_516147      JaccardDiss    0.70047676  0.013562248 0.009648326
      107 1983   211_516147 MorisitaHornDiss    0.02577689 -0.049345362 0.410116711
      108 1983   211_516147   BrayCurtisDiss    0.79435215 -0.007715775 0.926900414
      109 2012  437_2074469      JaccardDiss    0.68571429  0.012428120 0.085091524
      110 2012  437_2074469 MorisitaHornDiss    0.52522500  0.049305201 0.208175388
      111 2012  437_2074469   BrayCurtisDiss    0.76557078  0.036612792 0.523905114
      112 2011  437_2074469      JaccardDiss    0.66460275  0.012428120 0.085091524
      113 2011  437_2074469 MorisitaHornDiss    0.38902340  0.049305201 0.208175388
      114 2011  437_2074469   BrayCurtisDiss    0.52386019  0.036612792 0.523905114
      115 2016  437_2074469      JaccardDiss    0.72963782  0.012428120 0.085091524
      116 2016  437_2074469 MorisitaHornDiss    0.66451487  0.049305201 0.208175388
      117 2016  437_2074469   BrayCurtisDiss    0.77529008  0.036612792 0.523905114
      118 2010  437_2076657      JaccardDiss    0.66304631 -0.043230231 0.013422784
      119 2010  437_2076657 MorisitaHornDiss    0.32061112  0.015534820 0.645994406
      120 2010  437_2076657   BrayCurtisDiss    0.46503314 -0.001983839 0.958180478
      121 2011  437_2076657      JaccardDiss    0.66304631 -0.043230231 0.013422784
      122 2011  437_2076657 MorisitaHornDiss    0.17619258  0.015534820 0.645994406
      123 2011  437_2076657   BrayCurtisDiss    0.61652631 -0.001983839 0.958180478
      124 2012  437_2076657      JaccardDiss    0.58453063 -0.043230231 0.013422784
      125 2012  437_2076657 MorisitaHornDiss    0.45180328  0.015534820 0.645994406
      126 2012  437_2076657   BrayCurtisDiss    0.75116171 -0.001983839 0.958180478
      127 2016  437_2076657      JaccardDiss    0.41860465 -0.043230231 0.013422784
      128 2016  437_2076657 MorisitaHornDiss    0.36717709  0.015534820 0.645994406
      129 2016  437_2076657   BrayCurtisDiss    0.52362886 -0.001983839 0.958180478
      130 2010  437_2075929      JaccardDiss    0.75663574 -0.035569936 0.202373158
      131 2010  437_2075929 MorisitaHornDiss    0.20858973 -0.018768995 0.458844587
      132 2010  437_2075929   BrayCurtisDiss    0.58414472 -0.029662335 0.055367840
      133 2011  437_2075929      JaccardDiss    0.66671971 -0.035569936 0.202373158
      134 2011  437_2075929 MorisitaHornDiss    0.33614245 -0.018768995 0.458844587
      135 2011  437_2075929   BrayCurtisDiss    0.49480223 -0.029662335 0.055367840
      136 2012  437_2075929      JaccardDiss    0.52341138 -0.035569936 0.202373158
      137 2012  437_2075929 MorisitaHornDiss    0.33512610 -0.018768995 0.458844587
      138 2012  437_2075929   BrayCurtisDiss    0.47427487 -0.029662335 0.055367840
      139 2016  437_2075929      JaccardDiss    0.51429512 -0.035569936 0.202373158
      140 2016  437_2075929 MorisitaHornDiss    0.15568796 -0.018768995 0.458844587
      141 2016  437_2075929   BrayCurtisDiss    0.38290765 -0.029662335 0.055367840
      142 2010  437_2078113      JaccardDiss    0.60377358  0.011403775 0.672923116
      143 2010  437_2078113 MorisitaHornDiss    0.50473469 -0.018343932 0.540008313
      144 2010  437_2078113   BrayCurtisDiss    0.59092270 -0.003918587 0.821621588
      145 2016  437_2078113      JaccardDiss    0.72340426  0.011403775 0.672923116
      146 2016  437_2078113 MorisitaHornDiss    0.36745286 -0.018343932 0.540008313
      147 2016  437_2078113   BrayCurtisDiss    0.58663357 -0.003918587 0.821621588
      148 2011  437_2078113      JaccardDiss    0.77647059  0.011403775 0.672923116
      149 2011  437_2078113 MorisitaHornDiss    0.44588542 -0.018343932 0.540008313
      150 2011  437_2078113   BrayCurtisDiss    0.65797976 -0.003918587 0.821621588
      151 2012  437_2078113      JaccardDiss    0.58823529  0.011403775 0.672923116
      152 2012  437_2078113 MorisitaHornDiss    0.26229985 -0.018343932 0.540008313
      153 2012  437_2078113   BrayCurtisDiss    0.51654318 -0.003918587 0.821621588
      154 2012  437_2075928      JaccardDiss    0.60465116  0.015061360 0.179385743
      155 2012  437_2075928 MorisitaHornDiss    0.48253364  0.062536228 0.245770912
      156 2012  437_2075928   BrayCurtisDiss    0.51070394  0.030408842 0.252202834
      157 2011  437_2075928      JaccardDiss    0.61224490  0.015061360 0.179385743
      158 2011  437_2075928 MorisitaHornDiss    0.28792174  0.062536228 0.245770912
      159 2011  437_2075928   BrayCurtisDiss    0.54638603  0.030408842 0.252202834
      160 2016  437_2075928      JaccardDiss    0.68000000  0.015061360 0.179385743
      161 2016  437_2075928 MorisitaHornDiss    0.64462811  0.062536228 0.245770912
      162 2016  437_2075928   BrayCurtisDiss    0.67639993  0.030408842 0.252202834
      163 2012  437_2075200      JaccardDiss    0.70731707 -0.036797158 0.233709903
      164 2012  437_2075200 MorisitaHornDiss    0.13897492 -0.015957164 0.181915234
      165 2012  437_2075200   BrayCurtisDiss    0.42864993 -0.024477041 0.174019472
      166 2016  437_2075200      JaccardDiss    0.51111111 -0.036797158 0.233709903
      167 2016  437_2075200 MorisitaHornDiss    0.09138628 -0.015957164 0.181915234
      168 2016  437_2075200   BrayCurtisDiss    0.30696916 -0.024477041 0.174019472
      169 2011  437_2075200      JaccardDiss    0.67058824 -0.036797158 0.233709903
      170 2011  437_2075200 MorisitaHornDiss    0.17929211 -0.015957164 0.181915234
      171 2011  437_2075200   BrayCurtisDiss    0.41746807 -0.024477041 0.174019472
      172 2011  437_2073742      JaccardDiss    0.57334923  0.016442445 0.519997777
      173 2011  437_2073742 MorisitaHornDiss    0.41318746  0.006988277 0.099111013
      174 2011  437_2073742   BrayCurtisDiss    0.55292914 -0.013951057 0.312102595
      175 2012  437_2073742      JaccardDiss    0.68077268  0.016442445 0.519997777
      176 2012  437_2073742 MorisitaHornDiss    0.42587505  0.006988277 0.099111013
      177 2012  437_2073742   BrayCurtisDiss    0.57766760 -0.013951057 0.312102595
      178 2016  437_2073742      JaccardDiss    0.68588846  0.016442445 0.519997777
      179 2016  437_2073742 MorisitaHornDiss    0.45002862  0.006988277 0.099111013
      180 2016  437_2073742   BrayCurtisDiss    0.49607036 -0.013951057 0.312102595
      181 2011  437_2073741      JaccardDiss    0.57446809  0.030656345 0.079023964
      182 2011  437_2073741 MorisitaHornDiss    0.32754820  0.031622558 0.641753140
      183 2011  437_2073741   BrayCurtisDiss    0.48468587  0.047328352 0.516437303
      184 2012  437_2073741      JaccardDiss    0.62500000  0.030656345 0.079023964
      185 2012  437_2073741 MorisitaHornDiss    0.61967368  0.031622558 0.641753140
      186 2012  437_2073741   BrayCurtisDiss    0.79097853  0.047328352 0.516437303
      187 2016  437_2073741      JaccardDiss    0.73437500  0.030656345 0.079023964
      188 2016  437_2073741 MorisitaHornDiss    0.57249530  0.031622558 0.641753140
      189 2016  437_2073741   BrayCurtisDiss    0.80764906  0.047328352 0.516437303
          significance   intercept
      1              0  -31.997958
      2              0  -22.486480
      3              0    2.944410
      4              0  -31.997958
      5              0  -22.486480
      6              0    2.944410
      7              0  -31.997958
      8              0  -22.486480
      9              0    2.944410
      10             0  -31.997958
      11             0  -22.486480
      12             0    2.944410
      13             0  -31.997958
      14             0  -22.486480
      15             0    2.944410
      16             0   61.467806
      17             0  119.604204
      18             0   84.043341
      19             0   61.467806
      20             0  119.604204
      21             0   84.043341
      22             0   61.467806
      23             0  119.604204
      24             0   84.043341
      25             0   61.467806
      26             0  119.604204
      27             0   84.043341
      28             0   61.467806
      29             0  119.604204
      30             0   84.043341
      31             0   61.467806
      32             0  119.604204
      33             0   84.043341
      34             0   61.467806
      35             0  119.604204
      36             0   84.043341
      37             0  -14.153891
      38             0   38.091477
      39             0   30.441113
      40             0  -14.153891
      41             0   38.091477
      42             0   30.441113
      43             0  -14.153891
      44             0   38.091477
      45             0   30.441113
      46             0  -14.153891
      47             0   38.091477
      48             0   30.441113
      49             0  -14.153891
      50             0   38.091477
      51             0   30.441113
      52             0  -14.153891
      53             0   38.091477
      54             0   30.441113
      55             0  -14.153891
      56             0   38.091477
      57             0   30.441113
      58             0  -54.004559
      59             0  -99.358089
      60             0  -63.006406
      61             0  -54.004559
      62             0  -99.358089
      63             0  -63.006406
      64             0  -54.004559
      65             0  -99.358089
      66             0  -63.006406
      67             0  -54.004559
      68             0  -99.358089
      69             0  -63.006406
      70             0  -54.004559
      71             0  -99.358089
      72             0  -63.006406
      73             0  -54.004559
      74             0  -99.358089
      75             0  -63.006406
      76             0  -54.004559
      77             0  -99.358089
      78             0  -63.006406
      79             0  -54.004559
      80             0  -99.358089
      81             0  -63.006406
      82             0  -39.122077
      83             0   -9.728472
      84             0 -185.524584
      85             0  -39.122077
      86             0   -9.728472
      87             0 -185.524584
      88             0  -39.122077
      89             0   -9.728472
      90             0 -185.524584
      91             0  -39.122077
      92             0   -9.728472
      93             0 -185.524584
      94             0  -39.122077
      95             0   -9.728472
      96             0 -185.524584
      97             1  -26.195987
      98             0   97.986983
      99             0   16.127830
      100            1  -26.195987
      101            0   97.986983
      102            0   16.127830
      103            1  -26.195987
      104            0   97.986983
      105            0   16.127830
      106            1  -26.195987
      107            0   97.986983
      108            0   16.127830
      109            0  -24.324486
      110            0  -98.725114
      111            0  -73.013310
      112            0  -24.324486
      113            0  -98.725114
      114            0  -73.013310
      115            0  -24.324486
      116            0  -98.725114
      117            0  -73.013310
      118            1   87.572339
      119            0  -30.930996
      120            0    4.581067
      121            1   87.572339
      122            0  -30.930996
      123            0    4.581067
      124            1   87.572339
      125            0  -30.930996
      126            0    4.581067
      127            1   87.572339
      128            0  -30.930996
      129            0    4.581067
      130            0   72.190870
      131            0   38.026796
      132            0   60.172066
      133            0   72.190870
      134            0   38.026796
      135            0   60.172066
      136            0   72.190870
      137            0   38.026796
      138            0   60.172066
      139            0   72.190870
      140            0   38.026796
      141            0   60.172066
      142            0  -22.274275
      143            0   37.307670
      144            0    8.473196
      145            0  -22.274275
      146            0   37.307670
      147            0    8.473196
      148            0  -22.274275
      149            0   37.307670
      150            0    8.473196
      151            0  -22.274275
      152            0   37.307670
      153            0    8.473196
      154            0  -29.686219
      155            0 -125.413733
      156            0  -60.635169
      157            0  -29.686219
      158            0 -125.413733
      159            0  -60.635169
      160            0  -29.686219
      161            0 -125.413733
      162            0  -60.635169
      163            0   74.702351
      164            0   32.258323
      165            0   49.656646
      166            0   74.702351
      167            0   32.258323
      168            0   49.656646
      169            0   74.702351
      170            0   32.258323
      171            0   49.656646
      172            0  -32.451973
      173            0  -13.637705
      174            0   28.625699
      175            0  -32.451973
      176            0  -13.637705
      177            0   28.625699
      178            0  -32.451973
      179            0  -13.637705
      180            0   28.625699
      181            0  -61.066608
      182            0  -63.149637
      183            0  -94.577536
      184            0  -61.066608
      185            0  -63.149637
      186            0  -94.577536
      187            0  -61.066608
      188            0  -63.149637
      189            0  -94.577536

