% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peakDetection.R
\name{peakDetection}
\alias{peakDetection}
\title{Identification of biomarkers specific to distinct phases of the underlying biological process}
\usage{
peakDetection(exprmat, series, actstrength = 1.3, prominence = 1.3,
  type = "rnaseq", minexpr = 0, peakwidth = 0, sustact = 0.6,
  bgcorr = T)
}
\arguments{
\item{exprmat}{A numeric matrix with expression series data with variables as rownames.}

\item{series}{A numeric vector defining the experimental series (e.g. time-points of sample acquisition).}

\item{actstrength}{Threshold for minimal activation relative to the mean expression across all time-points.}

\item{prominence}{Threshold for minimal peak prominence relative to the second highest peak.}

\item{type}{A character string defining the sequencing platform. Possible values are c('microarray', 'rnaseq').}

\item{minexpr}{An optional threshold for minimal mean expression across all time-points for a given gene.}

\item{peakwidth}{An optional definitino of the minimal number of time-points that a peak spans (based on sustact threshold).}

\item{sustact}{An optional threshold for minimal peakheight relative to the main peak to be considered as sustained activation.}

\item{bgcorr}{An optional logical constant (TRUE or FALSE) defining if a background noise correction is performed or not.}
}
\value{
Returns a list comprising of multiple vectors and matrices. A numeric vector with the location of each peak (peakloc),
a numeric vector with the absolute height of each peak (peakheight), a character vector of gene symbols for which at least
one peak has been identified (peakgenes), a numeric matrix containing time-points with sustained activation, the logical
vector defining which gene index has been selected and the numeric input vector defining the time-series.
}
\description{
The peakDetection function facilitates the identification of impulse-like gene expression changes based on user-defined
selection criteria. This function calls the helper functions: bgCorr(), maProcessing() and findPeaks().
}
\examples{
# Example based on the heat-shock dataset
data(heat)
heat = as.matrix(heat)
# Define series
series <- c(37,40,41,42,43)
# Run the peak detection algorithm
peakdet <- peakDetection(heat, series, type ='rnaseq', actstrength = 1.5,
prominence = 1.3, minexpr = 5000)

}
\author{
David Lauenstein
}
