% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVD_MM.R
\name{sdv_MM}
\alias{sdv_MM}
\title{Fitting a Binary Logistic Biplot using coordinate descendent MM algorithm}
\usage{
sdv_MM(
  x,
  k = 2,
  iterations = 1000,
  truncated = TRUE,
  random = FALSE,
  epsilon = 1e-04
)
}
\arguments{
\item{x}{binary matrix.}

\item{k}{dimensions number. By default \code{k = 2}.}

\item{iterations}{maximum iterations.}

\item{truncated}{if TRUE, find the k largest singular values and vectors of a matrix.}

\item{random}{random initialization}

\item{epsilon}{convergence criteria}
}
\value{
Coordenates of the matrix A and B, and \eqn{\mu}
}
\description{
This function estimates the vector \eqn{\mu}, matrix A and matrix B using coordinate descendent MM algorithm.
}
\examples{
\donttest{
data("Methylation")
out <- sdv_MM(x = Methylation)
}
}
\references{
Babativa-Marquez, J.G. and Vicente-Villardon, J.L. (2021). Logistic biplot by conjugate gradient algorithms and iterated SVD. Mathematics 2021.

Vicente-Villardon, J.L. and Galindo, M. Purificacion (2006), \emph{Multiple Correspondence Analysis and related Methods. Chapter: Logistic Biplots}. Chapman-Hall
}
\seealso{
\code{\link{cv_LogBip}}
}
\author{
Giovany Babativa <gbabativam@gmail.com>
}
