% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binobp.r
\name{binobp}
\alias{binobp}
\title{Binomial sampling with a beta prior}
\usage{
binobp(x, n, a = 1, b = 1, pi = seq(0.01, 0.999, by = 0.001),
  plot = TRUE)
}
\arguments{
\item{x}{the number of observed successes in the binomial experiment.}

\item{n}{the number of trials in the binomial experiment.}

\item{a}{parameter for the beta prior - must be greater than zero}

\item{b}{parameter for the beta prior - must be greater than zero}

\item{pi}{A rannge of values for the prior to be calculated over.}

\item{plot}{if \code{TRUE} then a plot showing the prior and the posterior
will be produced.}
}
\value{
An object of class 'Bolstad' is returned. This is a list with the
following components: \item{prior}{the prior density of \eqn{\pi}{pi}, i.e.
the \eqn{beta(a,b)} density} \item{likelihood}{the likelihood of \eqn{x}
given \eqn{\pi}{pi} and \eqn{n}, i.e. the
\eqn{binomial(n,\pi)}{binomial(n,pi)} density} \item{posterior}{the
posterior density of \eqn{\pi}{pi} given \eqn{x} and \eqn{n} - i.e. the
\eqn{beta(a+x,b+n-x)} density} \item{pi}{the values of \eqn{\pi}{pi} for
which the posterior density was evaluated} \item{mean}{the posterior mean}
\item{var}{the posterior variance} \item{sd}{the posterior std. deviation}
\item{quantiles}{a set of quantiles from the posterior} \item{cdf}{a
cumulative distribution function for the posterior} \item{quantileFun}{a
quantile function for the posterior}
}
\description{
Evaluates and plots the posterior density for \eqn{\pi}{pi}, the probability
of a success in a Bernoulli trial, with binomial sampling and a continous
\eqn{beta(a,b)} prior.
}
\examples{

## simplest call with 6 successes observed in 8 trials and a beta(1,1) uniform
## prior
binobp(6,8)

## 6 successes observed in 8 trials and a non-uniform beta(0.5,6) prior
binobp(6,8,0.5,6)

## 4 successes observed in 12 trials with a non uniform beta(3,3) prior
## plot the stored prior, likelihood and posterior
results = binobp(4, 12, 3, 3)
decomp(results)


}
\seealso{
\code{\link{binodp}} \code{\link{binogcp}}
}
\keyword{misc}

