% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{rfvbm}
\alias{rfvbm}
\title{Random data generation from a fully-visible Boltzmann machine.}
\usage{
rfvbm(num, bvec, Mmat)
}
\arguments{
\item{num}{Number N of random strings to be generated.}

\item{bvec}{Vector of length n containing real valued bias parameters.}

\item{Mmat}{Symmetric n by n matrix, with zeros along the diagonal, containing the interaction parameters.}
}
\value{
An N by n matrix, where each row contains a random spin variable string from a fully-visible Boltzmann machine with bias vector \code{bvec} and interaction matrix \code{Mmat}.
}
\description{
Generate N random strings of n>1 binary spin variables (i.e. each element is -1 or 1) arising from a fully-visible Boltzmann machine with some specified bias vector and interaction matrix.
}
\note{
The function \code{allpfvbm} must be called each time this function is run. Thus, it is much more efficient to generate N strings all at once, than to generate strings one at a time.
}
\examples{
# Generate num=10 random strings of n=3 binary spin variables under bvec and Mmat.
num <- 10
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
rfvbm(num,bvec,Mmat)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
