% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AnnivDates.R
\name{AnnivDates}
\alias{AnnivDates}
\title{AnnivDates (time-invariant properties and temporal structure)}
\usage{
AnnivDates(Em = as.Date(NA), Mat = as.Date(NA), CpY = as.numeric(NA),
  FIPD = as.Date(NA), LIPD = as.Date(NA), FIAD = as.Date(NA),
  RV = as.numeric(NA), Coup = as.numeric(NA), DCC = as.numeric(NA),
  EOM = as.numeric(NA), DateOrigin = as.Date("1970-01-01"),
  InputCheck = 1, FindEOM = FALSE, RegCF.equal = 0)
}
\arguments{
\item{Em}{The bond's issue date. (required)}

\item{Mat}{Maturity date, i.e. date on which the redemption value and the final interest
are paid. (required)}

\item{CpY}{Number of interest payments per year (non-negative integer; element of the set
\{0,1,2,3,4,6,12\}. Default: 2.}

\item{FIPD}{First interest payment date after \code{Em}.}

\item{LIPD}{Last interest payment date prior to \code{Mat}.}

\item{FIAD}{Date on which the interest accrual starts (so-called "dated date").}

\item{RV}{The redemption value of the bond. Default: 100.}

\item{Coup}{Nominal interest rate per year in percent. Default: \code{NA}.}

\item{DCC}{The day count convention the bond follows. Default: \code{NA}.
For a list of day count conventions currently implemented type \code{View(List.DCC)}.}

\item{EOM}{Boolean indicating whether the bond follows the End-of-Month rule. Default: \code{NA}.}

\item{DateOrigin}{Determines the starting point for the daycount in "Date" objects.
Default: "1970-01-01".}

\item{InputCheck}{If 1, the input variables are checked for the correct format. Default: 1.}

\item{FindEOM}{If \code{TRUE}, \code{EOM} is overridden by the value inferred from the data.
Default: \code{FALSE}.}

\item{RegCF.equal}{If 0, the amounts of regular cash flows are calculated according to the
stipulated \code{DCC}. Any other value forces all regular cash flows to be equal sized.
Default: 0.}
}
\value{
All dates are returned irrespective of whether they are on a business day or not.
 \describe{
   \item{\emph{\bold{DateVectors}} (data frame)}{
     \describe{
       \item{}{}
       \item{\emph{RealDates}}{A vector of Date class objects with format "\%Y-\%m-\%d" in ascending order,
       that contains the issue date, all actual coupon payment dates and the maturity date.}
       \item{\emph{RD_indexes}}{A vector of numerics capturing the temporal structure of the bond.}
       \item{\emph{CoupDates}}{A vector of Date class objects with format "\%Y-\%m-\%d" in ascending order,
       that contains all actual coupon payment dates and the maturity date.}
       \item{\emph{CD_indexes}}{A vector of numerics capturing the temporal structure of the bond.}
       \item{\emph{AnnivDates}}{A vector of Date class objects with format "\%Y-\%m-\%d" in ascending order,
       that contains all theoretical coupon anniversary dates. The first value of \emph{AnnivDates} is the
       anniversary date immediately preceding the issue date, if the bond has an irregular first coupon
       period; otherwise it is the issue date. The final value of \emph{AnnivDates} is the anniversary
       date immediately succeeding the maturity date, if the bond has an irregular final coupon period;
       otherwise it is the maturity date.}
       \item{\emph{AD_indexes}}{A vector of numerics capturing the temporal structure of the bond.}
       \item{}{}
     }
   }
   \item{\emph{\bold{PaySched}} (data frame)}{
     \describe{
       \item{}{}
       \item{\emph{CoupDates}}{A vector of Date class objects with format "\%Y-\%m-\%d" in ascending order,
       that contains all actual coupon payment dates and the maturity date.}
       \item{\emph{CoupPayments}}{A vector of class "numeric" objects, that contains the actual amounts of
       interest that the bond pays on the respective coupon payment dates. The unit of these payments is the
       same as that of \code{RV} that was passed to the function. \code{RV} is not included in the final
       interest payment.}
       \item{\bold{NOTE:}}{\code{PaySched} is created only if the variable \code{Coup} is provided.}
       \item{}{}
     }
   }
   \item{\emph{\bold{Traits}} (data frame)}{
     \describe{
       \item{}{}
       \item{\emph{DateOrigin}}{The starting point for the daycount in "Date" objects.}
       \item{\emph{CpY}}{Number of interest payments per year.}
       \item{\emph{FIAD}}{Date on which the interest accrual starts (so-called "dated date").}
       \item{\emph{Em}}{The bond's issue date that was used for calculations.}
       \item{\emph{Em_Orig}}{The bond's issue date that was entered.}
       \item{\emph{FIPD}}{The first interest payment date after \code{Em} that was used for calculations.
                          If the entered \code{FIPD} was dropped during the calculation process,
                          the value is \code{NA}.}
       \item{\emph{FIPD_Orig}}{The first interest payment date after \code{Em} that was entered.}
       \item{\emph{est_FIPD}}{The estimated first interest payment date after \code{Em}. \code{NA}, if
                              a valid \code{FIPD} was entered.}
       \item{\emph{LIPD}}{The last interest payment date prior to \code{Mat} that was used for
                          calculations. If the entered \code{LIPD} was dropped during the calculation
                         process, the value is \code{NA}.}
       \item{\emph{LIPD_Orig}}{The last interest payment date prior to \code{Mat} that was entered.}
       \item{\emph{est_LIPD}}{The estimated last interest payment date prior to \code{Mat}. \code{NA},
                              if a valid \code{LIPD} was entered.}
       \item{\emph{Mat}}{The maturity date that was entered.}
       \item{\emph{Refer}}{Reference date that determines the day figures of all AnnivDates.}
       \item{\emph{FCPType}}{A character string indicating the type of the first coupon period.
       Values: "long", "regular", "short".}
       \item{\emph{FCPLength}}{Length of the first coupon period as a fraction of a regular coupon period.}
       \item{\emph{LCPType}}{A character string indicating the type of the last coupon period.
       Values: "long", "regular", "short".}
       \item{\emph{LCPLength}}{Length of the final coupon period as a fraction of a regular coupon period.}
       \item{\emph{Par}}{The redemption value of the bond.}
       \item{\emph{CouponInPercent.p.a}}{Nominal interest rate per year in percent.}
       \item{\emph{DayCountConvention}}{The day count convention the bond follows.}
       \item{\emph{EOM_Orig}}{The value of \code{EOM} that was entered.}
       \item{\emph{est_EOM}}{The estimated value of \code{EOM}.}
       \item{\emph{EOM_used}}{The value of \code{EOM} that was used in the calculations.}
       \item{}{}
     }
   }
   \item{\emph{\bold{Warnings}} (data frame)}{
     \describe{
       \item{}{}
       \item{}{A set of flags that indicate the occurrence of warnings during the execution.
               Below they are listed according to the hierarchical structure within the function \bold{AnnivDates}.}
       \item{}{
         \tabular{rcl}{
                                           \tab     \tab                                                                         \cr
                                           \tab     \tab                                                                         \cr
                                           \tab     \tab                                                                         \cr
           \bold{\emph{Em_FIAD_differ}} =  \tab     \tab                                                                         \cr
                                         1 \tab     \tab , if the provided issue date (\code{Em}) was substituted by the first   \cr
                                           \tab     \tab interest accrual date (\code{FIAD}).                                    \cr
                                           \tab     \tab This happens, if \code{FIAD} is available and different from \code{Em}. \cr
                                           \tab     \tab ________________________________________________                        \cr
                                           \tab     \tab \emph{Note:} No warning is displayed.                                   \cr
                       ___________________ \tab ___ \tab ________________________________________________                        \cr
                                         0 \tab     \tab , else.                                                                 \cr
                         ================= \tab === \tab ===========================================                             \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{EmMatMissing}} =  \tab     \tab                                                                                        \cr
                                       1 \tab     \tab , if either issue date (\code{Em}) or maturity date (\code{Mat}) or both               \cr
                                         \tab     \tab are missing or \code{NA}.                                                              \cr
                                         \tab     \tab ________________________________________________                                       \cr
                                         \tab     \tab \emph{Output:} \emph{RealDates} \code{= NA}, \emph{CoupDates} \code{= NA},             \cr
                                         \tab     \tab \emph{AnnivDates} \code{= NA}, \emph{FCPType} \code{= NA}, \emph{LCPType} \code{= NA}. \cr
                     ___________________ \tab ___ \tab ________________________________________________                                       \cr
                                       0 \tab     \tab , else.                                                                                \cr
                       ================= \tab === \tab ===========================================                                            \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{CpYOverride}} =  \tab     \tab                                                                                \cr
                                      1 \tab     \tab , if number of interest periods per year (\code{CpY}) is missing or            \cr
                                        \tab     \tab \code{NA}, or if the provided \code{CpY} is not element of \{0,1,2,3,4,6,12\}. \cr
                                        \tab     \tab ________________________________________________                               \cr
                                        \tab     \tab \emph{Note:} \code{CpY} is set 2, and the execution continues.                 \cr
                                        \tab     \tab ________________________________________________                               \cr
                                        \tab     \tab \emph{Output:} as if \code{CpY} = 2 was provided initially.                    \cr
                    ___________________ \tab ___ \tab ________________________________________________                               \cr
                                      0 \tab     \tab , else.                                                                        \cr
                      ================= \tab === \tab ===========================================                                    \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{RV_set100percent}} =  \tab     \tab                                                                 \cr
                                           1 \tab     \tab , if the redemption value (\code{RV}) is missing or \code{NA}.  \cr
                                             \tab     \tab ________________________________________________                \cr
                                             \tab     \tab \emph{Note:} \code{RV} is set 100, and the execution continues. \cr
                                             \tab     \tab ________________________________________________                \cr
                                             \tab     \tab \emph{Output:} as if \code{RV} = 100 was provided initially.    \cr
                         ___________________ \tab ___ \tab ________________________________________________                \cr
                                           0 \tab     \tab , else.                                                         \cr
                           ================= \tab === \tab ===========================================                     \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{NegLifeFlag}} =  \tab     \tab                                                                                        \cr
                                      1 \tab     \tab , if the provided maturity date (\code{Mat}) is before or on the                       \cr
                                        \tab     \tab provided issue date (\code{Em}).                                                       \cr
                                        \tab     \tab ________________________________________________                                       \cr
                                        \tab     \tab \emph{Output:} \emph{RealDates} \code{= NA}, \emph{CoupDates} \code{= NA},             \cr
                                        \tab     \tab \emph{AnnivDates} \code{= NA}, \emph{FCPType} \code{= NA}, \emph{LCPType} \code{= NA}. \cr
                    ___________________ \tab ___ \tab ________________________________________________                                       \cr
                                      0 \tab     \tab , else.                                                                                \cr
                      ================= \tab === \tab ===========================================                                            \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{ZeroFlag}} =  \tab     \tab                                                                                              \cr
                                   1 \tab     \tab , if number of interest payments per year (\code{CpY}) is \code{0}.                          \cr
                                     \tab     \tab ________________________________________________                                             \cr
                                     \tab     \tab \emph{Output:} \emph{RealDates} \code{= (Em,Mat)}, \emph{CoupDates} \code{= Mat},            \cr
                                     \tab     \tab \emph{AnnivDates} \code{= (Em,Mat)}, \emph{FCPType} \code{= NA}, \emph{LCPType} \code{= NA}. \cr
                 ___________________ \tab ___ \tab ________________________________________________                                             \cr
                                   0 \tab     \tab , else.                                                                                      \cr
                   ================= \tab === \tab ===========================================                                                  \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{Em_Mat_SameMY}} =  \tab     \tab                                                                                   \cr
                                        1 \tab     \tab , if the issue date (\code{Em}) and the maturity date (\code{Mat}) are in the     \cr
                                          \tab     \tab same month of the same year but not on the same day, while                        \cr
                                          \tab     \tab \code{CpY} is an element of \{1,2,3,4,6,12\}.                                     \cr
                                          \tab     \tab ________________________________________________                                  \cr
                                          \tab     \tab \emph{Output:} \emph{RealDates} \code{= (Em,Mat)}, \emph{CoupDates} \code{= Mat}, \cr
                                          \tab     \tab \emph{FCPType} \code{= short}, \emph{LCPType} \code{= short}.                     \cr
                      ___________________ \tab ___ \tab ________________________________________________                                  \cr
                                        0 \tab     \tab , else.                                                                           \cr
                        ================= \tab === \tab ===========================================                                       \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{ChronErrorFlag}} =  \tab     \tab                                                                                     \cr
                                         1 \tab     \tab , if the provided dates are in a wrong chronological order.                         \cr
                                           \tab     \tab ________________________________________________                                    \cr
                                           \tab     \tab \emph{Note:}                                                                        \cr
                                           \tab     \tab The correct ascending chronological order is:                                       \cr
                                           \tab     \tab issue date (\code{Em}), first interest payment date (\code{FIPD}),                  \cr
                                           \tab     \tab last interest payment date (\code{LIPD}), maturity date (\code{Mat}).               \cr
                                           \tab     \tab \code{FIPD} and \code{LIPD} are set \code{as.Date(NA)}.                             \cr
                                           \tab     \tab ________________________________________________                                    \cr
                                           \tab     \tab \emph{Output:} as if \code{FIPD} and \code{LIPD} were not provided initially.       \cr
                       ___________________ \tab ___ \tab ________________________________________________                                    \cr
                                         0 \tab     \tab , else.                                                                             \cr
                         ================= \tab === \tab ===========================================                                         \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{FIPD_LIPD_equal}} =  \tab     \tab                                                                                           \cr
                                          1 \tab     \tab if \code{Em} < \code{FIPD} = \code{LIPD} < \code{Mat}.                                    \cr
                                            \tab     \tab ________________________________________________                                          \cr
                                            \tab     \tab \emph{Output:} \emph{AnnivDates} contains \code{FIPD} and has at least \code{3} elements. \cr
                                            \tab     \tab \emph{RealDates} \code{= (Em,FIPD,Mat)}, \emph{CoupDates} \code{= (FIPD,Mat)}.            \cr
                                            \tab     \tab \emph{FCPType} and \emph{LCPType} can be "short", "regular" or "long".                    \cr
                        ___________________ \tab ___ \tab ________________________________________________                                          \cr
                                          0 \tab     \tab , else.                                                                                   \cr
                          ================= \tab === \tab ===========================================                                               \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{IPD_CpY_Corrupt}} =  \tab     \tab                                                                       \cr
                                          1 \tab     \tab , if the provided first interest payment date (\code{FIPD}) and last  \cr
                                            \tab     \tab interest payment date (\code{LIPD}) are inconsistent with the         \cr
                                            \tab     \tab provided number of interest payments per year (\code{CpY}).           \cr
                                            \tab     \tab ________________________________________________                      \cr
                                            \tab     \tab \emph{Note:}                                                          \cr
                                            \tab     \tab Inconsistency occurs if                                               \cr
                                            \tab     \tab 1. \code{FIPD} and \code{LIPD} are in the same month of the same year \cr
                                            \tab     \tab    but not on the same day, or                                        \cr
                                            \tab     \tab 2. the number of months between \code{FIPD} and \code{LIPD} is not a  \cr
                                            \tab     \tab    multiple of the number of months implied by \code{CpY}, or         \cr
                                            \tab     \tab 3. \code{FIPD} and \code{LIPD} are not both last day in month, their  \cr
                                            \tab     \tab    day figures differ and the day figure difference between           \cr
                                            \tab     \tab    \code{FIPD} and \code{LIPD} is not due to different month lengths. \cr
                                            \tab     \tab                                                                       \cr
                                            \tab     \tab In each of the three cases keeping the provided values of              \cr
                                            \tab     \tab \code{FIPD} and \code{LIPD} would violate the assumption, that the    \cr
                                            \tab     \tab anniversary dates between \code{FIPD} and \code{LIPD} are evenly      \cr
                                            \tab     \tab distributed.                                                          \cr
                                            \tab     \tab ________________________________________________                      \cr
                                            \tab     \tab \code{FIPD} and \code{LIPD} are set \code{as.Date(NA)}                \cr
                                            \tab     \tab and the execution continues.                                          \cr
                                            \tab     \tab ________________________________________________                      \cr
                                            \tab     \tab \emph{Output:}                                                        \cr
                                            \tab     \tab as if \code{FIPD} and \code{LIPD} were not provided initially.        \cr
                        ___________________ \tab ___ \tab ________________________________________________                      \cr
                                          0 \tab     \tab , else.                                                               \cr
                          ================= \tab === \tab ===========================================                           \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{EOM_Deviation}} =  \tab     \tab                                                                                  \cr
                                        1 \tab     \tab , if the provided value of \code{EOM} deviates from the value that               \cr
                                          \tab     \tab is inferred from the provided calendar dates.                                    \cr
                                          \tab     \tab ________________________________________________                                 \cr
                                          \tab     \tab \emph{Note:}                                                                     \cr
                                          \tab     \tab The program analyses the valid values of \code{Em}, \code{Mat}, \code{FIPD} and  \cr
                                          \tab     \tab \code{LIPD} to determine the appropriate value of \code{EOM}.                    \cr
                                          \tab     \tab                                                                                  \cr
                                          \tab     \tab If the initially provided value of \code{EOM} deviates from the value            \cr
                                          \tab     \tab determined by the program, there might be an inconsistency                       \cr
                                          \tab     \tab in the provided data.                                                            \cr
                      ___________________ \tab ___ \tab ________________________________________________                                 \cr
                                        0 \tab     \tab , else.                                                                          \cr
                        ================= \tab === \tab ===========================================                                      \cr
                                          \tab     \tab                                                                                  \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{EOMOverride}} =  \tab     \tab                                                                               \cr
                                      1 \tab     \tab , if the provided value of \code{EOM} is overridden by a value that           \cr
                                        \tab     \tab is inferred from the provided calendar dates.                                 \cr
                                        \tab     \tab ________________________________________________                              \cr
                                        \tab     \tab \emph{Note:}                                                                  \cr
                                        \tab     \tab This happens automatically if \code{EOM} is initially missing or \code{NA}    \cr
                                        \tab     \tab or not element of \code{\{0,1\}} and if the provided value of \code{EOM}      \cr
                                        \tab     \tab conflicts with the provided values of \code{FIPD}, \code{LIPD} or \code{Mat}, \cr
                                        \tab     \tab e.g. if \code{est_EOM = 0} but \code{EOM = 1}.                                \cr
                                        \tab     \tab If \code{EOM_Deviation = 1} and the option \code{FindEOM} is set \code{TRUE}, \cr
                                        \tab     \tab the initially provided value of \code{EOM} is also overridden by the          \cr
                                        \tab     \tab value that is inferred from the provided calendar dates if                    \cr
                                        \tab     \tab \code{est_EOM = 1} but \code{EOM = 0}.                                        \cr
                                        \tab     \tab ________________________________________________                              \cr
                                        \tab     \tab \emph{Output:}                                                                \cr
                                        \tab     \tab as if the value of \code{EOM} that is found by the program was                \cr
                                        \tab     \tab provided initially.                                                           \cr
                    ___________________ \tab ___ \tab ________________________________________________                              \cr
                                      0 \tab     \tab , else.                                                                       \cr
                      ================= \tab === \tab ===========================================                                   \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{DCCOverride}} =  \tab     \tab                                                             \cr
                                      1 \tab     \tab if \code{DCC} is missing or NA or not element of c(1:16).   \cr
                                        \tab     \tab ________________________________________________            \cr
                                        \tab     \tab \emph{Note:}                                                \cr
                                        \tab     \tab If the program cannot process the provided day count        \cr
                                        \tab     \tab identifier \code{DCC}, it overrides it with \code{DCC} = 2. \cr
                                        \tab     \tab ________________________________________________            \cr
                                        \tab     \tab \emph{Output:}                                              \cr
                                        \tab     \tab as if \code{DCC} = 2 was provided initially.                \cr
                    ___________________ \tab ___ \tab ________________________________________________            \cr
                                      0 \tab     \tab , else.                                                     \cr
                      ================= \tab === \tab ===========================================                 \cr
         }
       }
       \item{}{
         \tabular{rcl}{
           \bold{\emph{NoCoups}} =  \tab     \tab                                                                      \cr
                                  1 \tab     \tab , if there are no coupon payments between the provided               \cr
                                    \tab     \tab issue date (\code{Em}) and the maturity date (\code{Mat}), but the   \cr
                                    \tab     \tab provided (\code{CpY}) is not zero.                                   \cr
                                    \tab     \tab ________________________________________________                     \cr
                                    \tab     \tab \emph{Output:}                                                       \cr
                                    \tab     \tab \emph{RealDates} \code{= (Em,Mat)}, \emph{CoupDates} \code{= (Mat)}, \cr
                                    \tab     \tab \emph{AnnivDates} contains \code{Mat} and has either                 \cr
                                    \tab     \tab \code{2} or \code{3} elements, \emph{FCPType = LCPType} and          \cr
                                    \tab     \tab can be \code{"short"}, \code{"regular"} or \code{"long"}.            \cr
                ___________________ \tab ___ \tab ________________________________________________                     \cr
                                  0 \tab     \tab , else.                                                              \cr
                  ================= \tab === \tab ===========================================                          \cr
        }
      }
    }
  }
}
}
\description{
\bold{AnnivDates} returns a bond's time-invariant characteristics and temporal structure as a list of
three or four named data frames.
}
\details{
\bold{AnnivDates} generates a list of the three data frames \code{Warnings}, \code{Traits}
and \code{DateVectors}. If the variable \code{Coup} is passed to the function,
the output contains additionally the data frame \code{PaySched}. \bold{AnnivDates} is meant to analyze
large data frames. Therefore some features are implemented to evaluate the quality of the data. The
output of these features is stored in the data frame \code{Warnings}. Please see section \bold{Value}
for a detailed description of the tests run and the meaning of the variables in \code{Warnings}. The
data frame \code{Traits} contains all time-invariant bond characteristics that were either provided by
the user or calculated by the function. The data frame \code{DateVectors} contains three vectors
of Date-Objects named \code{RealDates}, \code{CoupDates} and \code{AnnivDates} and three vectors of
numerics named \code{RD_indexes}, \code{CD_indexes} and \code{AD_indexes}. These vectors are
used in the other functions of this package according to the methodology presented in Djatschenko (2018).
The data frame \code{PaySched} matches \code{CoupDates}
to the actual amount of interest that the bond pays on the respective interest payment date. Section
\bold{Value} provides further information on the output of the function \bold{AnnivDates}. Below
information on the proper input format is provided. Subsequently follows information on the operating
principle of the function \bold{AnnivDates} and on the assumptions that are met to
estimate the points in time needed to evaluate a bond.

\itemize{
  \item The dates \code{Em}, \code{Mat}, \code{FIPD}, \code{LIPD} and \code{FIAD} can be provided as
  \enumerate{
  \item "Date" with format \code{"\%Y-\%m-\%d"}, or
  \item "numeric" with the appropriate \code{DateOrigin}, or
  \item number of class "character" with the appropriate \code{DateOrigin}, or
  \item string of class "character" in the format \code{"yyyy-mm-dd"}.
  }
  \code{CpY}, \code{RV} and \code{Coup} can be provided either as class "numeric" or as a number of
  class "character".

\item The provided issue date (\code{Em}) is instantly substituted by the first interest accrual
  date (\code{FIAD}) if \code{FIAD} is available and different from \code{Em}.

\item Before the determination of the bond's date characteristics begins, the code evaluates
  the provided calendar dates for plausibility. In this process implausible dates are dropped.
  The sort of corresponding implausibility is identified and stored in a warning flag. (See
  section \bold{Value} for details.)

\item The remaining valid calendar dates are used to gauge whether the bond follows the
  End-of-Month-Rule. The resulting parameter est_EOM can take on the following values:
     \describe{
       \item{}{
         \tabular{cl}{
         \bold{\emph{Case 1:}} \tab \bold{\code{FIPD} and \code{LIPD} are both \code{NA}} \cr
                   ___________ \tab ____________________________________                  \cr
            \code{est_EOM = 1} \tab , if \code{Mat} is the last day of a month.           \cr
            \code{est_EOM = 0} \tab , else.                                               \cr
                    ========== \tab ================================                      \cr
         }
       }
       \item{}{
         \tabular{cl}{
         \bold{\emph{Case 2:}} \tab \bold{\code{FIPD} is \code{NA} and \code{LIPD} is a valid calendar date} \cr
                   ___________ \tab ____________________________________                                     \cr
            \code{est_EOM = 1} \tab , if \code{LIPD} is the last day of a month.                             \cr
            \code{est_EOM = 0} \tab , else.                                                                  \cr
                    ========== \tab ================================                                         \cr
         }
       }
       \item{}{
         \tabular{cl}{
         \bold{\emph{Case 3:}} \tab \bold{\code{FIPD} is a valid calendar date and \code{LIPD} is \code{NA}} \cr
                   ___________ \tab ____________________________________                                     \cr
            \code{est_EOM = 1} \tab , if \code{FIPD} is the last day of a month.                             \cr
            \code{est_EOM = 0} \tab , else.                                                                  \cr
                    ========== \tab ================================                                         \cr
         }
       }
       \item{}{
         \tabular{cl}{
         \bold{\emph{Case 4:}} \tab \bold{\code{FIPD} and \code{LIPD} are valid calendar dates} \cr
                   ___________ \tab ____________________________________                        \cr
            \code{est_EOM = 1} \tab , if \code{LIPD} is the last day of a month.                \cr
            \code{est_EOM = 0} \tab , else.                                                     \cr
                    ========== \tab ================================                            \cr
         }
       }
     }
  \item If \code{EOM} is initially missing or \code{NA} or not element of \code{\{0,1\}}, \code{EOM}
  is set \code{est_EOM} with a warning.
  \item If the initially provided value of \code{EOM} deviates from \code{est_EOM}, the following two
  cases apply:
     \tabular{cl}{
             ________ \tab _________________________________________                       \cr
              Case 1: \tab If \code{EOM = 0} and \code{est_EOM = 1}:                       \cr
                      \tab \code{EOM} is not overridden and remains \code{EOM = 0}         \cr
             ________ \tab _________________________________________                       \cr
              Case 2: \tab If \code{EOM = 1} and \code{est_EOM = 0}:                       \cr
                      \tab \code{EOM} is overridden and set \code{EOM = 0} with a warning. \cr
                      \tab Keeping \code{EOM = 1} in this case would conflict with         \cr
                      \tab the provided \code{Mat}, \code{FIPD} or \code{LIPD}.            \cr
             ________ \tab _________________________________________                       \cr
                Note: \tab Set the option \code{FindEOM=TRUE} to always use                \cr
                      \tab \code{est_EOM} found by the code.                               \cr
              ======= \tab ====================================                            \cr
              }

\item If \code{FIPD} and \code{LIPD} are both available, the lengths of the first and final coupon
  periods are determinate and can be "regular", "long" or "short". To find the interest payment dates
  between \code{FIPD} and \code{LIPD} the following assumptions are met:
  \enumerate{
  \item \preformatted{The interest payment dates between FIPD and LIPD are
  evenly distributed.}
  \item \preformatted{The value of EOM determines the location of
  all interest payment dates.}
  }
  If assumption 1 is violated, the exact locatations of the interest payment dates between
  \code{FIPD} and \code{LIPD} are ambiguous. The assumption is violated particularly, if
  \enumerate{
  \item \code{FIPD} and \code{LIPD} are in the same month of the same year but not on the same day, or
  \item the month difference between \code{FIPD} and \code{LIPD} is not a multiple of the number
  of months implied by \code{CpY}, or
  \item \code{FIPD} and \code{LIPD} are not both last day in month,
        their day figures differ and the day figure difference between \code{FIPD}
        and \code{LIPD} is not due to different month lengths.
  }
  In each of the three cases, \code{FIPD} and \code{LIPD} are dropped
  with the flag \code{IPD_CpY_Corrupt = 1}.

\item If neither \code{FIPD} nor \code{LIPD} are available the code
  evaluates the bond based only upon the required variables \code{Em} and
  \code{Mat} (and \code{CpY}, which is \code{2} by default). Since FIPD is
  not given, it is impossible to distinguish between a "short" and "long" odd
  first coupon period, without an assumption on the number of interest
  payment dates. Consequently the first coupon period is assumed to be either
  "regular" or "short". The locations of \code{FIPD} and \code{LIPD} are
  estimated under the following assumptions:
  \enumerate{
  \item \preformatted{The final coupon period is "regular".}
  \item \preformatted{The interest payment dates between the estimated
  FIPD and Mat are evenly distributed.}
  \item \preformatted{The value of EOM determines the location of
  all interest payment dates.}
  }

\item If \code{LIPD} is available but \code{FIPD} is not, the length
  of the final coupon payment period is determined by \code{LIPD} and
  \code{Mat} and can be "regular", "long" or "short". The locations of
  the interest payment dates are estimated under the following assumptions:
  \enumerate{
  \item \preformatted{The first coupon period is either "regular" or "short".}
  \item \preformatted{The interest payment dates between the estimated
  FIPD and LIPD are evenly distributed.}
  \item \preformatted{The value of EOM determines the location of
  all interest payment dates.}
  }

\item If \code{FIPD} is available but \code{LIPD} is not, the length
  of the first coupon payment period is determined by \code{Em} and
  \code{FIPD} and can be "regular", "long" or "short". The locations of
  the interest payment dates are estimated under the following assumptions:
  \enumerate{
  \item \preformatted{The final coupon period is either "regular" or "short".}
  \item \preformatted{The interest payment dates between FIPD and
  the estimated LIPD are evenly distributed.}
  \item \preformatted{The value of EOM determines the location of
  all interest payment dates.}
  }
}
}
\examples{
data(SomeBonds2016)

# Applying the function AnnivDates to the data frame SomeBonds2016.
system.time(
  FullAnalysis<-apply(SomeBonds2016[,c('Issue.Date','Mat.Date','CpY.Input','FIPD.Input',
  'LIPD.Input','FIAD.Input','RV.Input','Coup.Input','DCC.Input','EOM.Input')],1,function(y)
  AnnivDates(y[1],y[2],y[3],y[4],y[5],y[6],y[7],y[8],y[9],y[10],RegCF.equal=1)),
gcFirst = TRUE)
# warnings are due to apply's conversion of the variables' classes in
# SomeBonds2016 to class "character"

# The output stored in FullAnalysis ist a nested list.
# Lets look at what is stored in FullAnalysis for a random bond:
randombond<-sample(c(1:nrow(SomeBonds2016)),1)
FullAnalysis[[randombond]]

# Extracting the data frame Warnings:
AllWarnings<-do.call(rbind,lapply(FullAnalysis, `[[`, 1))
summary(AllWarnings)
# binding the Warnings to the bonds
BondsWithWarnings<-cbind(SomeBonds2016,AllWarnings)

# Extracting the data frame Traits:
AllTraits<-do.call(rbind,lapply(FullAnalysis, `[[`, 2))
summary(AllTraits)
# binding the Traits to the bonds
BondsWithTraits<-cbind(SomeBonds2016,AllTraits)

# Extracting the data frame AnnivDates:
AnnivDates<-lapply(lapply(FullAnalysis, `[[`, 3), `[[`, 5)
AnnivDates<-lapply(AnnivDates, `length<-`, max(lengths(AnnivDates)))
AnnivDates<-as.data.frame(do.call(rbind, AnnivDates))
AnnivDates<-as.data.frame(lapply(AnnivDates, as.Date, as.Date(AllTraits$DateOrigin[1])))
# binding the AnnivDates to the bonds:
BondsWithAnnivDates<-cbind(SomeBonds2016,AnnivDates)

# Extracting the data frames PaySched for each bond and creating a panel:
CoupSched<-lapply(FullAnalysis, `[[`, 4)
CoupSchedPanel<-SomeBonds2016[rep(row.names(SomeBonds2016),sapply(CoupSched, nrow)),]
CoupSched<-as.data.frame(do.call(rbind, CoupSched))
CoupSchedPanel<-cbind(CoupSchedPanel,CoupSched)


}
\references{
\enumerate{
  \item{Djatschenko, Wadim, The Nitty Gritty of Bond Valuation: A Generalized Methodology for Fixed Coupon Bond Analysis Allowing for Irregular Periods and Various Day Count Conventions (November 5, 2018). Available at SSRN: https://ssrn.com/abstract=3205167.}
}
}
