% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BP_PlotBone.R
\name{plot.BoneProfileR}
\alias{plot.BoneProfileR}
\title{Plot a bone section}
\usage{
\method{plot}{BoneProfileR}(
  x,
  message = NULL,
  type = "original",
  angle = NULL,
  show.centers = TRUE,
  show.colors = TRUE,
  show.grid = TRUE,
  analysis = 1,
  parameter.mcmc = "S",
  options.mcmc = list(),
  restorePar = TRUE,
  mar = NULL,
  angle.3D = 55,
  CI = "ML",
  radial.variable = "S",
  show.legend = TRUE,
  ...
)
}
\arguments{
\item{x}{The bone image}

\item{message}{The message to be displayed}

\item{type}{The type of plot; see description}

\item{angle}{Which angle model to show}

\item{show.centers}{Should the centers be shown?}

\item{show.colors}{Should the background and foreground colors be shown?}

\item{show.grid}{Should the grid be shown?}

\item{analysis}{Name or number of analysis to be plotted}

\item{parameter.mcmc}{The posterior parameter to show for type = "mcmc"}

\item{options.mcmc}{The option to plot type mcmc output}

\item{restorePar}{If TRUE, restore the par parameter at the exit}

\item{mar}{The margin for type being "model" or "observations"}

\item{angle.3D}{The angle between x and y for 3Dcolors graph}

\item{CI}{Which confidence interval should be plotted: MCMC or ML}

\item{radial.variable}{Name of the radial variable to plot}

\item{show.legend}{Should a legend be shown?}

\item{...}{Not used}
}
\value{
Nothing
}
\description{
Display a bone section.\cr
type value can be:\cr
Image plot: original, mineralized, unmineralized, section\cr
Original is the original image, mineralized is the mineral interpretation of the section, 
unmineralized is the unmineralized interpretation of the section, section is the interpretation of the section.\cr
colors show the histograms of pixel information with foreground and background colors if they are defined.\cr
3Dcolors show the pixels colors in 3D\cr
Global analysis: observations, model, observations+model\cr
Radial analysis: radial\cr
If angle is not null and a radial analysis exists, it will show the model for this angle.\cr
mcmc: It will show the posterior distribution of parameter
}
\details{
plot.BoneProfileR displays a bone section
}
\examples{
\dontrun{
# Not run:
library(BoneProfileR)
 bone <- BP_OpenImage()
 # or 
 path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 plot(bone, type="colors")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 plot(bone, type="3Dcolors")
 bone <- BP_EstimateCompactness(bone, analysis="logistic", rotation.angle = 1)
 bone <- BP_FitMLCompactness(bone, analysis="logistic")
 plot(bone)
 # 
path_Hedgehog <- system.file("extdata", "Erinaceus_europaeus_fem_2-1_small.png", 
                             package = "BoneProfileR")
 bone <- BP_OpenImage(file=path_Hedgehog)
 bone <- BP_DetectBackground(bone=bone, analysis="logistic")
 bone <- BP_DetectForeground(bone=bone, analysis="logistic")
 bone <- BP_DetectCenters(bone=bone, analysis="logistic")
 bone <- BP_EstimateCompactness(bone, analysis="logistic")
 bone <- BP_FitMLCompactness(bone, analysis="logistic")
 plot(bone)
 plot(bone, type="observations")
 plot(bone, type="observations+model", analysis=1)
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 fittedpar <- BP_GetFittedParameters(bone, analysis="logistic")
 bone <- BP_DuplicateAnalysis(bone, from="logistic", to="flexit")
 bone <- BP_FitMLCompactness(bone, 
                fitted.parameters=c(fittedpar, K1=1, K2=1), 
                fixed.parameters=NULL, analysis="flexit")
 compare_AIC(Logistic=BP_GetFittedParameters(bone, analysis="logistic", alloptim=TRUE), 
             Flexit=BP_GetFittedParameters(bone, analysis="flexit", alloptim=TRUE))
 out4p <- plot(bone, type="observations+model", analysis="logistic")
 out6p <- plot(bone, type="observations+model", analysis="flexit")
 bone <- BP_FitBayesianCompactness(bone, analysis="logistic")
 plot(bone, type="observations+model", CI="MCMC")
 bone <- BP_FitMLRadialCompactness(bone)
 plot(bone, type="radial", radial.variable=c("P", "S"))
 plot(bone, type="radial", radial.variable=c("P", "S", "Min", "Max"))
}
}
\seealso{
Other BoneProfileR: 
\code{\link{BP_AutoFit}()},
\code{\link{BP_ChooseBackground}()},
\code{\link{BP_ChooseCenter}()},
\code{\link{BP_ChooseForeground}()},
\code{\link{BP_DetectBackground}()},
\code{\link{BP_DetectCenters}()},
\code{\link{BP_DetectForeground}()},
\code{\link{BP_DuplicateAnalysis}()},
\code{\link{BP_EstimateCompactness}()},
\code{\link{BP_FitBayesianCompactness}()},
\code{\link{BP_FitMLCompactness}()},
\code{\link{BP_FitMLRadialCompactness}()},
\code{\link{BP_GetFittedParameters}()},
\code{\link{BP_ListAnalyses}()},
\code{\link{BP_LnLCompactness}()},
\code{\link{BP_OpenImage}()},
\code{\link{BP_Report}()},
\code{\link{Erinaceus_europaeus}},
\code{\link{summary.BoneProfileR}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{BoneProfileR}
