\name{simplifyNetwork}
\Rdversion{1.1}
\alias{simplifyNetwork}

\title{
Simplify the functions of a Boolean network
}
\description{
Eliminates irrelevant variables from the inputs of the gene transition functions. This can be useful if the network was generated randomly via \code{\link{generateRandomNKNetwork}} or if it was perturbed via \code{\link{perturbNetwork}}.
}
\usage{
simplifyNetwork(network, readableFunctions=FALSE)
}

\arguments{
  \item{network}{
	A network structure of class \code{BooleanNetwork}. These networks can be read from files by \code{\link{loadNetwork}} or generated by \code{\link{generateRandomNKNetwork}}.
}
  \item{readableFunctions}{
	If this is true, readable DNF representations of the truth tables of the functions are generated. These DNF are displayed when the network is printed. The DNF representations are not minimized and can thus be very long. If set to FALSE, the truth table result column is displayed.	
}
}
\details{
The function checks whether the output of a gene transition function is independent from the states of any of the input variables. If this is the case, these input variables are dropped, and the transition function is shortened accordingly. 

Constant genes are automatically fixed (e.g. knocked-out or over-expressed). This means that they are always set to the constant value, and states with the complementary value are not considered in transition tables etc. If you would like to change this behaviour, use \code{\link{fixGenes}} to reset the fixing.
}
\value{
The simplified network of class \code{BooleanNetwork}. The class \code{BooleanNetwork} is described in more detail in \code{\link{loadNetwork}}.
}
\seealso{
\code{\link{loadNetwork}},\code{\link{generateRandomNKNetwork}}, \code{\link{perturbNetwork}}, \code{\link{fixGenes}}
}
\examples{
library(BoolNet)

# load example data
data(cellcycle)

# perturb the network
perturbedNet <- perturbNetwork(net,perturb="functions",method="shuffle")
print(perturbedNet$interactions)

# simplify the network
perturbedNet <- simplifyNetwork(perturbedNet)
print(perturbedNet$interactions)
}
\keyword{Boolean network
	logic
	simplify
	simplification}
