% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary_null_distrib.R
\name{boundary_null_distrib}
\alias{boundary_null_distrib}
\title{Null distribution for overlap statistics}
\usage{
boundary_null_distrib(
  x,
  convert = FALSE,
  cat = FALSE,
  threshold = 0.2,
  n_iterations = 10,
  model = "random",
  p = 0.5,
  progress = TRUE
)
}
\arguments{
\item{x}{A SpatRaster object.}

\item{convert}{TRUE if x contains numeric trait data that needs to be converted to boundary intensities. default = FALSE.}

\item{cat}{TRUE if the input SpatRaster contains a categorical variable. default = FALSE.}

\item{threshold}{A value between 0 and 1. The proportion of cells to keep as boundary elements. default = 0.2.}

\item{n_iterations}{An integer indicating the number of iterations for the function.
A value of 100 or 1000 is recommended to produce sufficient resolution for downstream
statistical tests. default = 10.}

\item{model}{Neutral model to use. Options: 'random' (stochastic), 'gaussian' (Gaussian random field),
and 'random_cluster' (modified random clusters method)}

\item{p}{If using modified random clusters, proportion of cells to be marked in percolated raster.Higher values of p
produce larger clusters. Default: p = 0.5}

\item{progress}{If progress = TRUE (default) a progress bar will be displayed.}
}
\value{
A list of two probability distribution functions for boundary statistics.
}
\description{
Creates custom probability distributions for two boundary statistics (number of subgraphs and length
of the longest subgraph). Given a SpatRaster object, simulates n iterations of random raster
surfaces from a neutral model.
}
\examples{
\donttest{
data(T.cristatus)
T.cristatus <- terra::rast(T.cristatus_matrix, crs = T.cristatus_crs)
terra::ext(T.cristatus) <- T.cristatus_ext

T.crist_bound_null <- boundary_null_distrib(T.cristatus, cat = TRUE, n_iterations = 100,
model = 'random_cluster')
}

}
\references{
Saura, S. & Martínez-Millán, J. (2000). Landscape patterns simulation with a modified random clusters method. Landscape Ecology, 15:661-678.
}
\author{
Amy Luo
}
