% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VariableImportance.boot.R
\name{boxplot.BranchGLMVI.boot}
\alias{boxplot.BranchGLMVI.boot}
\title{Box Plot Method for BranchGLMVI.boot Objects}
\usage{
\method{boxplot}{BranchGLMVI.boot}(
  x,
  which = "all",
  linecol = "red",
  linelwd = 2,
  horizontal = TRUE,
  lim = NULL,
  show.names = TRUE,
  lab = "Modified Variable Importance",
  main = NULL,
  las = ifelse(horizontal, 1, 2),
  ...
)
}
\arguments{
\item{x}{a \code{BranchGLMVI.boot} object.}

\item{which}{which approximate null distributions to plot, can use a numeric vector of
indices, a character vector of names, or "all" for all variables. The default
is to create box-and-whisker plots for each set of variables that are not
kept in each model.}

\item{linecol}{the color of the line which indicates the observed modified variable
importance values.}

\item{linelwd}{the width of the line which indicates the observed modified variable
importance values.}

\item{horizontal}{a logical value indicating if the boxplots should be horizontal.}

\item{lim}{a numeric vector of length 2, giving the coordinates range.}

\item{show.names}{set to TRUE or FALSE to override the defaults on whether an axis label is printed for each group.}

\item{lab}{a label for the axis corresponding to the modified variable importance values.}

\item{main}{a main title for the plot.}

\item{las}{the style of axis labels, see more at \link{par}.}

\item{...}{further arguments passed to \link{boxplot.default}.}
}
\value{
This only produces a plot, nothing is returned.
}
\description{
Creates box-and-whisker plots of approximate null distributions for
the modified variable importance values.
}
\examples{
Data <- iris
Fit <- BranchGLM(Sepal.Length ~ ., data = Data, family = "gaussian", link = "identity")

# Doing branch and bound selection 
VS <- VariableSelection(Fit, type = "branch and bound", metric = "BIC", 
showprogress = FALSE)

# Getting approximate null distributions
set.seed(40174)
myBoot <- VariableImportance.boot(VS, showprogress =  FALSE)

# Plotting boxplots of selected sets of variables
oldmar <- par("mar")
par(mar = c(4, 6, 3, 1) + 0.1)
boxplot(myBoot, las = 1)
par(mar = oldmar)

# Plotting boxplots of selected sets of variables
boxplot(myBoot, las = 1, cex.axis = 0.55)

}
\seealso{
\link{hist.BranchGLMVI.boot}
}
