% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normexp.R
\name{qnormexp}
\alias{qnormexp}
\title{Density of a Gaussian Variable Plus an Exponential Variable}
\usage{
qnormexp(p, rate, rho)
}
\description{
Density of a Gaussian Variable Plus an Exponential Variable
}
\examples{
\dontrun{
n <- 1e6

c(qnormexp(0.5, rate = 2, rho = 1.5), quantile(rnorm(n) + 1.5 * rexp(n, rate = 2), 0.5))
c(qnormexp(0.95, rate = 1/10, rho = 1.5), quantile(rnorm(n) + 1.5 * rexp(n, rate = 1/10), 0.95))

c(qnormexp(0.5, rate = 2, rho = -1.5), quantile(rnorm(n) - 1.5 * rexp(n, rate = 2), 0.5))
c(qnormexp(0.95, rate = 1/10, rho = -1.5), quantile(rnorm(n) - 1.5 * rexp(n, rate = 1/10), 0.95))
}
}
\keyword{internal}
