/*
 * Decompiled with CFR 0.152.
 */
package org.neptuneinc.cadstat.plots;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.neptuneinc.cadstat.ui.DataPlotDialog;
import org.neptuneinc.cadstat.utils.RUtils;
import org.rosuda.JGR.JGR;

public class TreeRegression
extends DataPlotDialog {
    private JPanel analysisOptionsPane;
    private JCheckBox browserResults;
    private JSpinner cp;
    private JLabel cpLabel;
    private JComboBox dependentComboBox;
    private JLabel dependentLabel;
    private JLabel independentLabel;
    private JList independentList;
    private JScrollPane independentScrollPane;
    private JSpinner minBucket;
    private JLabel minBucketLabel;
    private JSpinner minSplit;
    private JLabel minSplitLabel;
    private JPanel modelEqPane;
    private JScrollPane modelEqScrollPane;
    private JTextArea modelEqTextArea;
    private JPanel plotPane;
    private JPanel savePanel;
    private JPanel varPane;

    protected void initCustom() {
        this.initComponents();
        this.getPlotPane().add((Component)this.plotPane, "Center");
        this.getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeRegression.this.datasetComboBoxActionPerformed(e);
            }
        });
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    private void datasetComboBoxActionPerformed(ActionEvent e) {
        this.refreshVariableList();
        this.refreshValidity();
        this.updateModelEquation();
    }

    public void updateModelEquation() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            String modelEq = this.dependentComboBox.getSelectedItem() + " ~ " + RUtils.toString(this.independentList.getSelectedValues(), " + ", "");
            this.modelEqTextArea.setText(modelEq);
        } else {
            this.modelEqTextArea.setText(null);
        }
    }

    public void refreshVariableListValidity() {
        this.dependentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.dependentComboBox.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.dependentComboBox.getItemCount() > 0);
        this.independentLabel.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
        this.independentList.setEnabled(this.getDatasetPane().getDatasetComboBox().getItemCount() > 0 && this.independentList.getModel().getSize() > 0);
    }

    public void refreshVariableList() {
        if (this.getDatasetPane().getDatasetComboBox().getItemCount() > 0) {
            Vector nonFactors = RUtils.nonFactors(this.getDatasetPane().getSelectedDataset());
            this.dependentComboBox.setModel(new DefaultComboBoxModel(nonFactors));
            this.independentList.setListData(nonFactors);
            if (this.dependentComboBox.getItemCount() > 0) {
                this.dependentComboBox.setSelectedIndex(0);
            }
        } else {
            this.dependentComboBox.removeAllItems();
            this.independentList.setModel(new DefaultListModel());
        }
        this.refreshValidity();
    }

    public void refreshSubmitButtonValidity() {
        this.getSubmitButton().setEnabled(!this.independentList.isSelectionEmpty());
    }

    public void refreshValidity() {
        this.refreshVariableListValidity();
        this.refreshSubmitButtonValidity();
    }

    private void initComponents() {
        this.plotPane = new JPanel();
        this.varPane = new JPanel();
        this.dependentLabel = new JLabel();
        this.dependentComboBox = new JComboBox();
        this.independentLabel = new JLabel();
        this.independentScrollPane = new JScrollPane();
        this.independentList = new JList();
        this.analysisOptionsPane = new JPanel();
        this.minSplitLabel = new JLabel();
        this.minSplit = new JSpinner();
        this.minBucketLabel = new JLabel();
        this.minBucket = new JSpinner();
        this.cpLabel = new JLabel();
        this.cp = new JSpinner();
        this.modelEqPane = new JPanel();
        this.modelEqScrollPane = new JScrollPane();
        this.modelEqTextArea = new JTextArea();
        this.savePanel = new JPanel();
        this.browserResults = new JCheckBox();
        this.varPane.setBorder(BorderFactory.createTitledBorder("Variables"));
        this.dependentLabel.setText("Dependent:");
        this.dependentComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeRegression.this.dependentComboBoxActionPerformed(evt);
            }
        });
        this.independentLabel.setText("Independent:");
        this.independentList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TreeRegression.this.independentListValueChanged(evt);
            }
        });
        this.independentScrollPane.setViewportView(this.independentList);
        GroupLayout varPaneLayout = new GroupLayout((Container)this.varPane);
        this.varPane.setLayout((LayoutManager)varPaneLayout);
        varPaneLayout.setHorizontalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(2).add((Component)this.independentLabel).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentScrollPane, -1, 173, Short.MAX_VALUE).add(2, (Component)this.dependentComboBox, 0, 173, Short.MAX_VALUE)).addContainerGap()));
        varPaneLayout.setVerticalGroup((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((GroupLayout.Group)varPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)varPaneLayout.createParallelGroup(3).add((Component)this.dependentComboBox, -2, -1, -2).add((Component)this.dependentLabel)).addPreferredGap(0).add((GroupLayout.Group)varPaneLayout.createParallelGroup(1).add((Component)this.independentLabel).add((Component)this.independentScrollPane, -1, 142, Short.MAX_VALUE)).addContainerGap()));
        this.analysisOptionsPane.setBorder(BorderFactory.createTitledBorder("Analysis Options"));
        this.minSplitLabel.setText("Min Split:");
        this.minSplit.setModel(new SpinnerNumberModel(20.0, 1.0, 99.0, 1.0));
        this.minBucketLabel.setText("Min Bucket:");
        this.minBucket.setModel(new SpinnerNumberModel(7.0, 1.0, 99.0, 1.0));
        this.cpLabel.setText("CP:");
        this.cp.setModel(new SpinnerNumberModel(0.01, 0.01, 0.99, 0.01));
        GroupLayout analysisOptionsPaneLayout = new GroupLayout((Container)this.analysisOptionsPane);
        this.analysisOptionsPane.setLayout((LayoutManager)analysisOptionsPaneLayout);
        analysisOptionsPaneLayout.setHorizontalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(2).add((Component)this.cpLabel).add((Component)this.minBucketLabel).add((Component)this.minSplitLabel)).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1, false).add((Component)this.cp).add((Component)this.minBucket).add((Component)this.minSplit)).addContainerGap(-1, Short.MAX_VALUE)));
        analysisOptionsPaneLayout.setVerticalGroup((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(1).add((GroupLayout.Group)analysisOptionsPaneLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.minSplitLabel).add((Component)this.minSplit, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.minBucketLabel).add((Component)this.minBucket, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)analysisOptionsPaneLayout.createParallelGroup(3).add((Component)this.cp, -2, -1, -2).add((Component)this.cpLabel))));
        this.modelEqPane.setBorder(BorderFactory.createTitledBorder("Model Equation"));
        this.modelEqTextArea.setColumns(20);
        this.modelEqTextArea.setEditable(false);
        this.modelEqTextArea.setLineWrap(true);
        this.modelEqTextArea.setRows(2);
        this.modelEqTextArea.setWrapStyleWord(true);
        this.modelEqScrollPane.setViewportView(this.modelEqTextArea);
        GroupLayout modelEqPaneLayout = new GroupLayout((Container)this.modelEqPane);
        this.modelEqPane.setLayout((LayoutManager)modelEqPaneLayout);
        modelEqPaneLayout.setHorizontalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add(2, (GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -1, 458, Short.MAX_VALUE).addContainerGap()));
        modelEqPaneLayout.setVerticalGroup((GroupLayout.Group)modelEqPaneLayout.createParallelGroup(1).add((GroupLayout.Group)modelEqPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqScrollPane, -2, -1, -2).addContainerGap(15, Short.MAX_VALUE)));
        this.savePanel.setBorder(BorderFactory.createTitledBorder("Results"));
        this.browserResults.setText("Display Results in Browser");
        this.browserResults.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.browserResults.setMargin(new Insets(0, 0, 0, 0));
        this.browserResults.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeRegression.this.browserResultsActionPerformed(evt);
            }
        });
        GroupLayout savePanelLayout = new GroupLayout((Container)this.savePanel);
        this.savePanel.setLayout((LayoutManager)savePanelLayout);
        savePanelLayout.setHorizontalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().addContainerGap().add((Component)this.browserResults).addContainerGap(-1, Short.MAX_VALUE)));
        savePanelLayout.setVerticalGroup((GroupLayout.Group)savePanelLayout.createParallelGroup(1).add((GroupLayout.Group)savePanelLayout.createSequentialGroup().add((Component)this.browserResults).addContainerGap(5, Short.MAX_VALUE)));
        GroupLayout plotPaneLayout = new GroupLayout((Container)this.plotPane);
        this.plotPane.setLayout((LayoutManager)plotPaneLayout);
        plotPaneLayout.setHorizontalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)plotPaneLayout.createParallelGroup(2, false).add(1, (Component)this.modelEqPane, -1, -1, Short.MAX_VALUE).add(1, (GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.varPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((Component)this.analysisOptionsPane, -2, -1, -2).add((Component)this.savePanel, -2, -1, -2)))).addContainerGap(-1, Short.MAX_VALUE)));
        plotPaneLayout.setVerticalGroup((GroupLayout.Group)plotPaneLayout.createParallelGroup(1).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().addContainerGap().add((Component)this.modelEqPane, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)plotPaneLayout.createParallelGroup(1, false).add((Component)this.varPane, -2, -1, -2).add((GroupLayout.Group)plotPaneLayout.createSequentialGroup().add((Component)this.analysisOptionsPane, -2, -1, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.savePanel, -2, 47, -2))).addContainerGap(16, Short.MAX_VALUE)));
        this.setTitle("Tree Regression");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 540) / 2, (screenSize.height - 480) / 2, 540, 480);
    }

    private void dependentComboBoxActionPerformed(ActionEvent evt) {
        this.updateModelEquation();
    }

    private void independentListValueChanged(ListSelectionEvent evt) {
        this.updateModelEquation();
        this.refreshSubmitButtonValidity();
    }

    private void browserResultsActionPerformed(ActionEvent evt) {
    }

    protected void submitButtonAction() {
        String cmd = "rpart.JGR(my.data=" + this.getDatasetPane().getSelectedDataset() + ", subset1.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane1().getSelectedFactor() + "'") + ", subset1.val=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'") + ")") + ", subset2.name=" + (RUtils.toString(this.getFactorSelectionPane1().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "'" + this.getFactorSelectionPane2().getSelectedFactor() + "'") + ", subset2.val=" + (RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'").length() == 0 ? "NULL" : "c(" + RUtils.toString(this.getFactorSelectionPane2().getSelectedFactorValues(), ",", "'") + ")") + ", formula=" + "'" + this.modelEqTextArea.getText() + "'" + ", minsplit=" + (Double)this.minSplit.getValue() + ", minbucket=" + (Double)this.minBucket.getValue() + ", cp=" + (Double)this.cp.getValue() + ", browserResults=" + String.valueOf(this.browserResults.isSelected()).toUpperCase() + ")";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }

    protected void helpButtonAction() {
        String cmd = "CADStat.help('rpart.JGR')";
        JGR.MAINRCONSOLE.execute(cmd, true);
    }
}

