/*
 * DataPlotDialog.java
 *
 * Created on September 8, 2005, 10:52 PM
 */
package org.neptuneinc.cadstat.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;

/**
 *
 * @author  Pasha Minallah
 */
public class DataPlotDialog extends JDialog implements WindowListener
{
  /** Creates new form DataPlotDialog */
  public DataPlotDialog()
  {
    initComponents();
    initGeneral();
    initCustom();
  }

  /** Perform general initialization. */
  protected void initGeneral()
  {
    getDatasetPane().getDatasetLabel().setText("Active Dataset:");
    getDatasetPane().getDatasetComboBox().addActionListener(new ActionListener()
    {
      @Override
      public void actionPerformed(ActionEvent e)
      {
        datasetComboBoxActionPerformed(e);
      }
    });

    this.addWindowListener(this);

    getFactorSelectionPane1().getFactorLabel().setText("Factor 1:");
    getFactorSelectionPane2().getFactorLabel().setText("Factor 2:");

    refreshFactorSelectionPanes();

    getRootPane().setDefaultButton(getSubmitButton());
    setDefaultCloseOperation(JDialog.DISPOSE_ON_CLOSE);
  }

  private void datasetComboBoxActionPerformed(ActionEvent evt)
  {
    refreshFactorSelectionPanes();
  }

  public void refreshFactorSelectionPanes()
  {
    getFactorSelectionPane1().setDataset(getDatasetPane().getSelectedDataset());
    getFactorSelectionPane2().setDataset(getDatasetPane().getSelectedDataset());
    updateValidity();
  }

  protected void initCustom()
  {
  }

  private void updateValidity()
  {
    getCardPane().setEnabledAt(1, getFactorSelectionPane1().getFactorComboBox().getItemCount() > 0);
  }

  /** This method is called from within the constructor to
   * initialize the form.
   * WARNING: Do NOT modify this code. The content of this method is
   * always regenerated by the Form Editor.
   */
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {

    cardPane = new javax.swing.JTabbedPane();
    plotPane = new javax.swing.JPanel();
    datasetParentPane = new javax.swing.JPanel();
    datasetCenteringPane = new javax.swing.JPanel();
    datasetPane = new org.neptuneinc.cadstat.ui.DatasetPane();
    datasetSeparator = new javax.swing.JSeparator();
    subsetPane = new javax.swing.JPanel();
    factorPane = new javax.swing.JPanel();
    factorSelectionPane1 = new org.neptuneinc.cadstat.ui.FactorSubsetPane();
    factorSelectionPane2 = new org.neptuneinc.cadstat.ui.FactorSubsetPane();
    buttonPane = new javax.swing.JPanel();
    cancelButton = new javax.swing.JButton();
    submitButton = new javax.swing.JButton();
    helpButton = new javax.swing.JButton();

    setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
    setTitle("Scatterplot");

    plotPane.setLayout(new java.awt.BorderLayout());

    datasetCenteringPane.add(datasetPane);

    javax.swing.GroupLayout datasetParentPaneLayout = new javax.swing.GroupLayout(datasetParentPane);
    datasetParentPane.setLayout(datasetParentPaneLayout);
    datasetParentPaneLayout.setHorizontalGroup(
      datasetParentPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addComponent(datasetCenteringPane, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 588, Short.MAX_VALUE)
      .addComponent(datasetSeparator, javax.swing.GroupLayout.DEFAULT_SIZE, 588, Short.MAX_VALUE)
    );
    datasetParentPaneLayout.setVerticalGroup(
      datasetParentPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(datasetParentPaneLayout.createSequentialGroup()
        .addComponent(datasetCenteringPane, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
        .addGap(8, 8, 8)
        .addComponent(datasetSeparator, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
    );

    plotPane.add(datasetParentPane, java.awt.BorderLayout.NORTH);

    cardPane.addTab("Main Options", plotPane);

    factorPane.setLayout(new java.awt.GridLayout(1, 2, 20, 0));
    factorPane.add(factorSelectionPane1);
    factorPane.add(factorSelectionPane2);

    javax.swing.GroupLayout subsetPaneLayout = new javax.swing.GroupLayout(subsetPane);
    subsetPane.setLayout(subsetPaneLayout);
    subsetPaneLayout.setHorizontalGroup(
      subsetPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, subsetPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(factorPane, javax.swing.GroupLayout.DEFAULT_SIZE, 564, Short.MAX_VALUE)
        .addContainerGap())
    );
    subsetPaneLayout.setVerticalGroup(
      subsetPaneLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
      .addGroup(subsetPaneLayout.createSequentialGroup()
        .addContainerGap()
        .addComponent(factorPane, javax.swing.GroupLayout.DEFAULT_SIZE, 208, Short.MAX_VALUE)
        .addContainerGap())
    );

    cardPane.addTab("Data Subsetting", subsetPane);

    getContentPane().add(cardPane, java.awt.BorderLayout.CENTER);

    buttonPane.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.CENTER, 10, 10));

    cancelButton.setText("Cancel");
    cancelButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
    cancelButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        cancelButtonActionPerformed(evt);
      }
    });
    buttonPane.add(cancelButton);

    submitButton.setText("Submit");
    submitButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
    submitButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        submitButtonActionPerformed(evt);
      }
    });
    buttonPane.add(submitButton);

    helpButton.setText("Help");
    helpButton.setMargin(new java.awt.Insets(0, 10, 0, 10));
    helpButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent evt) {
        helpButtonActionPerformed(evt);
      }
    });
    buttonPane.add(helpButton);

    getContentPane().add(buttonPane, java.awt.BorderLayout.SOUTH);

    pack();
  }// </editor-fold>//GEN-END:initComponents

  protected void helpButtonAction()
  {
  }

  private void helpButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_helpButtonActionPerformed
  {//GEN-HEADEREND:event_helpButtonActionPerformed
    helpButtonAction();
  }//GEN-LAST:event_helpButtonActionPerformed

  private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_cancelButtonActionPerformed
  {//GEN-HEADEREND:event_cancelButtonActionPerformed
    this.dispose();
  }//GEN-LAST:event_cancelButtonActionPerformed

  protected void submitButtonAction()
  {
  }

  private void submitButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_submitButtonActionPerformed
  {//GEN-HEADEREND:event_submitButtonActionPerformed
    submitButtonAction();
  }//GEN-LAST:event_submitButtonActionPerformed
  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JPanel buttonPane;
  private javax.swing.JButton cancelButton;
  private javax.swing.JTabbedPane cardPane;
  private javax.swing.JPanel datasetCenteringPane;
  private org.neptuneinc.cadstat.ui.DatasetPane datasetPane;
  private javax.swing.JPanel datasetParentPane;
  private javax.swing.JSeparator datasetSeparator;
  private javax.swing.JPanel factorPane;
  private org.neptuneinc.cadstat.ui.FactorSubsetPane factorSelectionPane1;
  private org.neptuneinc.cadstat.ui.FactorSubsetPane factorSelectionPane2;
  private javax.swing.JButton helpButton;
  private javax.swing.JPanel plotPane;
  private javax.swing.JButton submitButton;
  private javax.swing.JPanel subsetPane;
  // End of variables declaration//GEN-END:variables

  protected javax.swing.JTabbedPane getCardPane()
  {
    return cardPane;
  }

  protected void setCardPane(javax.swing.JTabbedPane cardPane)
  {
    this.cardPane = cardPane;
  }

  protected javax.swing.JPanel getPlotPane()
  {
    return plotPane;
  }

  protected void setPlotPane(javax.swing.JPanel plotPane)
  {
    this.plotPane = plotPane;
  }

  public org.neptuneinc.cadstat.ui.DatasetPane getDatasetPane()
  {
    return datasetPane;
  }

  public void setDatasetPane(org.neptuneinc.cadstat.ui.DatasetPane datasetPane)
  {
    this.datasetPane = datasetPane;
  }

  public org.neptuneinc.cadstat.ui.FactorSubsetPane getFactorSelectionPane1()
  {
    return factorSelectionPane1;
  }

  public void setFactorSelectionPane1(org.neptuneinc.cadstat.ui.FactorSubsetPane factorSelectionPane1)
  {
    this.factorSelectionPane1 = factorSelectionPane1;
  }

  public org.neptuneinc.cadstat.ui.FactorSubsetPane getFactorSelectionPane2()
  {
    return factorSelectionPane2;
  }

  public void setFactorSelectionPane2(org.neptuneinc.cadstat.ui.FactorSubsetPane factorSelectionPane2)
  {
    this.factorSelectionPane2 = factorSelectionPane2;
  }

  public javax.swing.JButton getCancelButton()
  {
    return cancelButton;
  }

  public void setCancelButton(javax.swing.JButton cancelButton)
  {
    this.cancelButton = cancelButton;
  }

  public javax.swing.JButton getHelpButton()
  {
    return helpButton;
  }

  public void setHelpButton(javax.swing.JButton helpButton)
  {
    this.helpButton = helpButton;
  }

  public javax.swing.JButton getSubmitButton()
  {
    return submitButton;
  }

  public void setSubmitButton(javax.swing.JButton submitButton)
  {
    this.submitButton = submitButton;
  }

  @Override
  public void windowOpened(WindowEvent e)
  {
  }

  @Override
  public void windowClosing(WindowEvent e)
  {
  }

  @Override
  public void windowClosed(WindowEvent e)
  {
  }

  @Override
  public void windowIconified(WindowEvent e)
  {
  }

  @Override
  public void windowDeiconified(WindowEvent e)
  {
  }

  @Override
  public void windowActivated(WindowEvent e)
  {
    getDatasetPane().refreshDatasetComboBox();
    refreshFactorSelectionPanes();
  }

  @Override
  public void windowDeactivated(WindowEvent e)
  {
  }
}
