% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_phi.R
\name{calc_phi}
\alias{calc_phi}
\title{Calculates the sample estimator of (simple or percent) differences}
\usage{
calc_phi(x1, x2, dif)
}
\arguments{
\item{x1}{vector of observations}

\item{x2}{vector of observations}

\item{dif}{type of difference to estimate ("simple" or "perc")}
}
\value{
Estimated value of the statistic given in \code{dif}
}
\description{
Calculates the sample estimator of the (simple or percent) differences
between the means of two algorithms on a given instance.
\itemize{
\item If `dif == "simple": estimates \eqn{mu2 - mu1},
\item If `dif == "perc": estimates \eqn{(mu2 - mu1) / mu1},
}
}
\details{
where \eqn{mu1, mu2} are the means of the populations that generated the
sample vectors \eqn{x1, x2}.
}
\section{References}{

\itemize{
\item F. Campelo, F. Takahashi:
Sample size estimation for power and accuracy in the experimental
comparison of algorithms (submitted, 2017).
}
}

\examples{
x1 <- rnorm(25, 3, 0.5)
x2 <- runif(15, 4, 6)
calc_phi(x1, x2, "simple")
calc_phi(x1, x2, "perc")
}
\author{
Felipe Campelo (\email{fcampelo@ufmg.br})
}
