% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{create_Polys}
\alias{create_Polys}
\title{Create Polygons}
\usage{
create_Polys(
  Input,
  NamesIn = NULL,
  Buffer = 0,
  Densify = TRUE,
  Clip = FALSE,
  SeparateBuf = TRUE
)
}
\arguments{
\item{Input}{input dataframe.

\strong{If \code{NamesIn} is not provided, the columns in the \code{Input} must be in the following order:

Polygon name, Latitude, Longitude.

Latitudes and Longitudes must be given clockwise.}}

\item{NamesIn}{character vector of length 3 specifying the column names of polygon identifier, Latitude
and Longitude fields in the \code{Input}.

\strong{Names must be given in that order, e.g.:

\code{NamesIn=c('Polygon ID','Poly Latitudes','Poly Longitudes')}}.}

\item{Buffer}{numeric, distance in nautical miles by which to expand the polygons. Can be specified for
each polygon (as a numeric vector).}

\item{Densify}{logical, if set to TRUE, additional points between points of equal latitude are added
prior to projection (compare examples 1 and 2 below).}

\item{Clip}{logical, if set to TRUE, polygon parts that fall on land are removed (see \link{Clip2Coast}).}

\item{SeparateBuf}{logical, if set to FALSE when adding a \code{Buffer},
all spatial objects are merged, resulting in a single spatial object.}
}
\value{
Spatial object in your environment.
Data within the resulting spatial object contains the data provided in the \code{Input} after aggregation
within polygons. For each numeric variable, the minimum, maximum, mean, sum, count, standard deviation, and, 
median of values in each polygon is returned. In addition, for each polygon, its area (AreaKm2) and projected 
centroid (Labx, Laby) are given (which may be used to add labels to polygons).

To see the data contained in your spatial object, type: \code{View(MyPolygons)}.
}
\description{
Create Polygons such as proposed Research Blocks or Marine Protected Areas.
}
\examples{
\donttest{


#Example 1: Simple and non-densified polygons

MyPolys=create_Polys(Input=PolyData,Densify=FALSE)
plot(st_geometry(MyPolys),col='blue',main="Example 1")
text(MyPolys$Labx,MyPolys$Laby,MyPolys$ID,col='white')

#Example 2: Simple and densified polygons (note the curvature of iso-latitude lines)

MyPolys=create_Polys(Input=PolyData)
plot(st_geometry(MyPolys),col='red',main="Example 2")
text(MyPolys$Labx,MyPolys$Laby,MyPolys$ID,col='white')

#Example 3: Buffered and clipped polygons

MyPolysBefore=create_Polys(Input=PolyData,Buffer=c(10,-15,120))
MyPolysAfter=create_Polys(Input=PolyData,Buffer=c(10,-15,120),Clip=TRUE)
plot(st_geometry(MyPolysBefore),col='green',main="Example 3")
plot(st_geometry(Coast[Coast$ID=='All',]),add=TRUE)
plot(st_geometry(MyPolysAfter),col='red',add=TRUE)
text(MyPolysAfter$Labx,MyPolysAfter$Laby,MyPolysAfter$ID,col='white')

#Example 4: Buffered and grouped polygons
MyPolys=create_Polys(Input=PolyData,Buffer=80,SeparateBuf=FALSE)
plot(st_geometry(MyPolys),border='blue',lwd=3,main="Example 4")


}

}
\seealso{
\code{\link{create_Points}}, \code{\link{create_Lines}}, \code{\link{create_PolyGrids}},
\code{\link{create_Stations}}, \code{\link{add_RefGrid}}.
}
