% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_places.R
\name{get_places}
\alias{get_places}
\title{Obtain data from the CDC PLACES data base.}
\usage{
get_places(geo = "county", state = NULL, measure = NULL, release = "2023")
}
\arguments{
\item{geo}{The level of desired geography. Currently supports 'county' and 'census'.}

\item{state}{Specify the state of the desired data. Supports multiple states if desired.}

\item{measure}{Specify the measures of the data pull. Supports multiple states if desired. For a full list of available measures, see the function 'get_measures'.}

\item{release}{Specify the year of release for the PLACES data set. Currently supports years 2020-2023.}
}
\value{
A tibble that contains observations for each measure (adjusted and unadjusted prevalence) and geographic level.
}
\description{
Use this function to access CDC PLACES API data. Measures are sourced from the Behavioral Risk Factor Surveillance System and the American Community Survey ACS.
}
\examples{
get_places(geo = "county", state = "MI", measure = "SLEEP", release = "2023")
get_places(geo = "county", state = c("MI", "OH", "WI", "IN", "IL"),
measure = c("SLEEP", "ACCESS2"), release = "2023")

}
