% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{dropTable}
\alias{dropTable}
\title{Drop tables from write_schema of a cdm object}
\usage{
dropTable(cdm, name, verbose = FALSE)
}
\arguments{
\item{cdm}{A cdm reference}

\item{name}{A character vector of tables in the cdm's write_schema or
a \href{https://tidyselect.r-lib.org/reference/language.html}{tidyselect}
specification of tables to drop.
(e.g. \code{starts_with("temp")}, \code{matches("study01")}, etc.)}

\item{verbose}{Print a message when dropping a table? TRUE or FALSE (default)}
}
\value{
Returns the cdm object with selected tables removed
}
\description{
cdm objects can have zero or more cohort tables stored in a special schema
where the user has write access. This function removes tables from a cdm's
write_schema
}
\examples{
\dontrun{
library(CDMConnector)

con <- DBI::dbConnect(duckdb::duckdb(), dbdir = CDMConnector::eunomia_dir())
cdm <- cdm_from_con(con, cdm_schema = "main", write_schema = "main")

# create two temporary tables in the remote database from a query with a common prefix
cdm$tmp_table <- cdm$concept \%>\%
  dplyr::count(domain_id == "Drug") \%>\%
  computeQuery("tmp_table", temporary = FALSE, schema = "main")

cdm$tmp_table2 <- cdm$concept \%>\%
  dplyr::count(domain_id == "Condition") \%>\%
  computeQuery("tmp_table2", temporary = FALSE, schema = "main")

stringr::str_subset(DBI::dbListTables(con), "tmp")
#> [1] "tmp_table"  "tmp_table2"
stringr::str_subset(names(cdm), "tmp")
#> [1] "tmp_table"  "tmp_table2"

# drop tables with a common prefix
cdm <- dropTable(cdm, name = dplyr::starts_with("tmp"))

stringr::str_subset(DBI::dbListTables(con), "tmp")
#> character(0)
stringr::str_subset(names(cdm), "tmp")
#> character(0)

DBI::dbDisconnect(con, shutdown = TRUE)
}
}
