% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/modelLm.R
\name{combinatorialLM}
\alias{combinatorialLM}
\title{Distance based Linear Model}
\usage{
combinatorialLM(x, y, distanceFunction, control = list())
}
\arguments{
\item{x}{list of samples in input space}

\item{y}{matrix, vector of observations for each sample}

\item{distanceFunction}{a suitable distance function of type f(x1,x2), returning a scalar distance value, preferably between 0 and 1.
Maximum distances larger 1 are no problem, but may yield scaling bias when different measures are compared.
   Should be non-negative and symmetric.}

\item{control}{currently unused, defaults to \code{list()}}
}
\value{
a fit (list, CLM), with the options and found parameters for the model which has to be passed to the predictor function:\cr
\code{x} samples in input space (see parameters)\cr
\code{y} observations for each sample (see parameters)\cr
\code{distanceFunction} distance function (see parameters)
}
\description{
A simple linear model based on arbitrary distances. Comparable to a nearest neighbor, but potentially able to extrapolate
into regions of improvement. Used as a simple baseline by Zaefferer et al.(2014). Basically just generates a proper \code{CLM}
object for the prediction function.
}
\examples{
#set random number generator seed
set.seed(1)
#simple test landscape
fn <- landscapeGeneratorUNI(1:5,distancePermutationHamming)
#generate data for training and test
x <- unique(replicate(40,sample(5),FALSE))
xtest <- x[-(1:15)]
x <- x[1:15]
#determin true objective function values
y <- sapply(x,fn)
ytest <- sapply(xtest,fn)
#build model
fit <- combinatorialLM(x,y,distancePermutationHamming)
#predicted obj. function values
ypred <- predict(fit,xtest)
#plot
plot(ytest,ypred,xlab="true value",ylab="predicted value",
    pch=20,xlim=c(0.3,1),ylim=c(min(ypred)-0.1,max(ypred)+0.1))
abline(0,1,lty=2)
}
\references{
Zaefferer, Martin; Stork, Joerg; Friese, Martina; Fischbach, Andreas; Naujoks, Boris; Bartz-Beielstein, Thomas. (2014). Efficient global optimization for combinatorial problems. In Proceedings of the 2014 conference on Genetic and evolutionary computation (GECCO '14). ACM, New York, NY, USA, 871-878. DOI=10.1145/2576768.2598282 http://doi.acm.org/10.1145/2576768.2598282
}
\seealso{
\code{\link{predict.CLM}}
}

