% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/optimizer.R
\name{optimRS}
\alias{optimRS}
\title{Combinatorial Random Search}
\usage{
optimRS(par = NULL, fun, creationFunction, control = list())
}
\arguments{
\item{par}{Optional set of solution(s) as a list. If NULL (default), creationFunction is used to create all solutions randomly.
If par has less individuals than the population size, creationFunction will fill up the rest. par basically defines additional user specified solutions to be evaluated.}

\item{fun}{target function to be minimized}

\item{creationFunction}{Function to create individuals/solutions in search space}

\item{control}{(list), with the options\cr
\code{budget} The limit on number of target function evaluations (stopping criterion) (default: 100)
\code{vectorized} Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE\cr}
}
\value{
a list:\cr
\code{xbest} best solution found\cr
\code{ybest} fitness of the best solution\cr
\code{x} history of all evaluated solutions\cr
\code{y} corresponding target function values f(x)\cr
\code{count} number of performed target function evaluations
}
\description{
Random Search for mixed or combinatorial optimization.
}
\examples{
seed=0
glgseed=1
#distance
dF <- distancePermutationHamming
#mutation
mF <- mutationPermutationSwap
#recombination
rF <-  recombinationPermutationCycleCrossover
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(ref=1:5,distFun=dF)
#start optimization
set.seed(seed)
res <- optimRS(,lF,cF,list(budget=100))
res$xbest
}
\seealso{
\code{\link{optimCEGO}}, \code{\link{optimEA}}
}

