% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/optimRS.R
\name{optimRS}
\alias{optimRS}
\title{Combinatorial Random Search}
\usage{
optimRS(x = NULL, fun, control = list())
}
\arguments{
\item{x}{Optional set of solution(s) as a list, which are added to the randomly generated solutions and are also evaluated with the target function.}

\item{fun}{target function to be minimized}

\item{control}{(list), with the options\cr
\code{budget} The limit on number of target function evaluations (stopping criterion) (default: 100)\cr
\code{vectorized} Boolean. Defines whether target function is vectorized (takes a list of solutions as argument) or not (takes single solution as argument). Default: FALSE\cr
\code{creationFunction} Function to create individuals/solutions in search space. Default is a function that creates random permutations of length 6}
}
\value{
a list:\cr
\code{xbest} best solution found\cr
\code{ybest} fitness of the best solution\cr
\code{x} history of all evaluated solutions\cr
\code{y} corresponding target function values f(x)\cr
\code{count} number of performed target function evaluations
}
\description{
Random Search for mixed or combinatorial optimization. Solutions are generated completely at random.
}
\examples{
seed=0
glgseed=1
#distance
dF <- distancePermutationHamming
#mutation
mF <- mutationPermutationSwap
#recombination
rF <-  recombinationPermutationCycleCrossover
#creation
cF <- function()sample(5)
#objective function
lF <- landscapeGeneratorUNI(1:5,dF)
#start optimization
set.seed(seed)
res <- optimRS(,lF,list(creationFunction=cF,budget=100,
		vectorized=TRUE)) ##target function is "vectorized", expects list as input
res$xbest
}
\seealso{
\code{\link{optimCEGO}}, \code{\link{optimEA}}
}

