% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modelKrigingLikelihood.R
\name{modelKrigingLikelihood}
\alias{modelKrigingLikelihood}
\title{Calculate negative log-likelihood}
\usage{
modelKrigingLikelihood(xt, D, y, optimizeP = FALSE, useLambda = FALSE,
  corr = fcorrGauss, indefiniteMethod = "none", indefiniteType = "PSD",
  indefiniteRepair = FALSE, returnLikelihoodOnly = TRUE)
}
\arguments{
\item{xt}{vector, containing parameters like log10(theta), p and lambda.}

\item{D}{matrix (or list of multiple matrices) of distances between training samples. In case of multiple distance matrices, theta (part of xt) has to be a vector, giving a weighting parameter for each matrix.}

\item{y}{vector of observations at sample locations.}

\item{optimizeP}{whether to optimize p or not (FALSE at default).}

\item{useLambda}{whether to use nugget effect, i.e., lambda (FALSE at default).}

\item{corr}{whether to use nugget effect, i.e., lambda (fcorrGauss at default).}

\item{indefiniteMethod}{The specific method used for correction: spectrum \code{"clip"}, spectrum \code{"flip"}, spectrum \code{"square"}, spectrum \code{"diffusion"}, feature embedding "feature", nearest definite matrix "near". Default is no correction: \code{"none"}. See Zaefferer and Bartz-Beielstein (2016).}

\item{indefiniteType}{The general type of correction for indefiniteness: \code{"NSD"},\code{"CNSD"} or the default \code{"PSD"}. See Zaefferer and Bartz-Beielstein (2016).}

\item{indefiniteRepair}{boolean, whether conditions of the distance matrix (in case of \code{"NSD"},\code{"CNSD"} correction type) or correlation matrix (in case of \code{"PSD"} correction type) are repaired.}

\item{returnLikelihoodOnly}{boolean, whether the function should return only the likelihood, or a else a list (see return information below).}
}
\value{
the numeric Likelihood value (if \code{returnLikelihoodOnly} is TRUE) or a list with elements\cr
\code{NegLnLike}  concentrated log-likelihood *-1 for minimising \cr
\code{Psi} correlation matrix\cr
\code{Psinv} inverse of correlation matrix (to save computation time in forrRegPredictor)\cr
\code{mu} MLE of model parameter mu \cr
\code{yMu} vector of observations y minus mu\cr
\code{SSQ} MLE of model parameter sigma^2
\code{a} transformation vector for eigenspectrum transformation, see Zaefferer and Bartz-Beielstein (2016)
\code{U} Matrix of eigenvectors for eigenspectrum transformation, see Zaefferer and Bartz-Beielstein (2016)
\code{isIndefinite} whether the uncorrected correlation (kernel) matrix is indefinite
}
\description{
Used to determine theta/lambda/p values for the Kriging model in \code{\link{modelKriging}}
with Maximum Likelihood Estimation (MLE).
}
\references{
Forrester, Alexander I.J.; Sobester, Andras; Keane, Andy J. (2008). Engineering Design via Surrogate Modelling - A Practical Guide. John Wiley & Sons.

Zaefferer, Martin; Stork, Joerg; Friese, Martina; Fischbach, Andreas; Naujoks, Boris; Bartz-Beielstein, Thomas. (2014). Efficient global optimization for combinatorial problems. In Proceedings of the 2014 conference on Genetic and evolutionary computation (GECCO '14). ACM, New York, NY, USA, 871-878. DOI=10.1145/2576768.2598282 http://doi.acm.org/10.1145/2576768.2598282

Zaefferer, Martin; Stork, Joerg; Bartz-Beielstein, Thomas. (2014). Distance Measures for Permutations in Combinatorial Efficient Global Optimization. In Parallel Problem Solving from Nature - PPSN XIII (p. 373-383). Springer International Publishing.

Martin Zaefferer and Thomas Bartz-Beielstein. (2016). Efficient Global Optimization with Indefinite Kernels. Parallel Problem Solving from Nature-PPSN XIV. Accepted, in press. Springer.
}
\seealso{
\code{\link{modelKriging}}
}
\keyword{internal}

