% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFO2d.oc.R
\name{CFO2d.oc}
\alias{CFO2d.oc}
\title{Generate operating characteristics of drug-combination trials in multiple simulations}
\usage{
CFO2d.oc(nsimu = 1000, target, p.true, init.level = c(1,1), ncohort, cohortsize,
               prior.para = list(alp.prior = target, bet.prior = 1 - target), 
               cutoff.eli = 0.95, early.stop = 0.95, seeds = NULL)
}
\arguments{
\item{nsimu}{the total number of trials to be simulated. The default value is 1000.}

\item{target}{the target DLT rate.}

\item{p.true}{a matrix representing the true DIL rates under the different dose levels.}

\item{init.level}{a numeric vector of length 2 representing the initial dose level (default is \code{c(1,1)}).}

\item{ncohort}{the total number of cohorts.}

\item{cohortsize}{the number of patients of each cohort.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of (\code{cutoff.eli = 0.95}) for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{seeds}{A vector of random seeds for each simulation, for example, \code{seeds = 1:nsimu} (default is \code{NULL}).}
}
\value{
The \code{CFO.oc()} function returns basic setup of ($simu.setup) and the operating
characteristics of the design: \cr
\itemize{
\item p.true: the matrix of the true DLT rates under the different dose levels.
\item selpercent: the matrix of the selection percentage of each dose level.
\item npatients: a matrix of the averaged number of patients allocated to different doses in one simulation.
\item ntox: a matrix of the averaged number of DLT observed for different doses in one simulation.
\item MTDsel: the percentage of the correct selection of the MTD.
\item MTDallo: the averaged percentage of patients assigned to the target DLT rate.
\item oversel: the percentage of selecting a dose above the MTD.
\item overallo: the averaged percentage of patients assigned to dose levels with a DLT rate greater than the target.
\item averDLT: the averaged total number of DLTs observed.
\item percentstop: the percentage of early stopping without selecting the MTD.
\item simu.setup: the parameters for the simulation set-up.
}
}
\description{
This function is used to conduct multiple simulations of drug-combination trials and obtain relevant the operating characteristics.
}
\note{
In the example, we set \code{nsimu = 10} for testing time considerations. In reality, \code{nsimu}
is typically set to 1000 or 5000 to ensure the accuracy of the results.
}
\examples{
## Simulate a two-dimensional dose-finding trial with 20 cohorts of size 3 for 10 replications.
p.true <- matrix(c(0.05, 0.10, 0.15, 0.30, 0.45,
0.10, 0.15, 0.30, 0.45, 0.55,
0.15, 0.30, 0.45, 0.50, 0.60), 
nrow = 3, ncol = 5, byrow = TRUE)
target <- 0.3; ncohort <- 12; cohortsize <- 3
CFO2doc <- CFO2d.oc(nsimu = 5, target, p.true, init.level = c(1,1), ncohort, cohortsize, 
                    seeds = 1:5)
summary(CFO2doc)
plot(CFO2doc)
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Wang W, Jin H, Zhang Y, Yin G (2023). Two-dimensional calibration-free odds (2dCFO)
design for phase I drug-combination trials. \emph{Frontiers in Oncology}, 13, 1294258.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
