% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFO2d.simu.R
\name{CFO2d.simu}
\alias{CFO2d.simu}
\title{Conduct one simulation using the two-dimensional calibration-free odds (2dCFO) design.}
\usage{
CFO2d.simu(target, p.true, init.level = c(1,1), ncohort, cohortsize, 
                 prior.para = list(alp.prior = target, bet.prior = 1 - target),
                 cutoff.eli = 0.95, early.stop = 0.95, seed = NULL)
}
\arguments{
\item{target}{the target DLT rate.}

\item{p.true}{a matrix representing the true DIL rates under the different dose levels.}

\item{init.level}{the dose level assigned to the first cohort. The default value \code{init.level} is \code{c(1,1)}.}

\item{ncohort}{the total number of cohorts.}

\item{cohortsize}{the number of patients of each cohort.}

\item{prior.para}{the prior parameters for a beta distribution, where set as \code{list(alp.prior = target, bet.prior = 1 - target)}
by default, \code{alp.prior} and \code{bet.prior} represent the parameters of the prior distribution for
the true DLT rate at any dose level. This prior distribution is specified as Beta(\code{alpha.prior}, \code{beta.prior}).}

\item{cutoff.eli}{the cutoff to eliminate overly toxic doses for safety. We recommend
the default value of (\code{cutoff.eli = 0.95}) for general use.}

\item{early.stop}{the threshold value for early stopping. The default value \code{early.stop = 0.95}
generally works well.}

\item{seed}{an integer to be set as the seed of the random number generator for reproducible results. The default is set to \code{NULL}.}
}
\value{
The \code{CFO2d.simu()} function returns a list with the following components:
\itemize{
\item target: the target DLT rate.
\item MTD: a vector of length 2 representing the recommended dose level. \code{MTD = (99, 99)} indicates that this trial is terminated due to early stopping.
\item correct: a binary indicator of whether the recommended dose level matches the target DLT rate (1 for yes).
\item npatients: a matrix of the number of patients allocated to different doses.
\item ntox: a matrix of the number of DLT observed for different doses.
\item npercent: the percentage of patients assigned to the target DLT rate.
\item over.doses: a matrix indicating whether each dose is overdosed or not (1 for yes).
\item cohortdose: the dose combination assigned to each cohort.
\item ptoxic: the percentage of subjects assigned to dose levels with a DLT rate greater than the target.
\item patientDLT: the DLT observed at each cohort.
\item sumDLT: the total number of DLT observed.
\item earlystop: a binary indicator of whether the trial is early stopped (1 for yes).
}
}
\description{
In the 2dCFO design, the function is used to conduct one single simulation and find the maximum tolerated dose (MTD).
}
\details{
The \code{CFO2d.simu()} function simulates the operating characteristics of the 2dCFO design
in a dose-combination trial.
The early stopping and dose elimination rules are incorporated into the 2dCFO design
to ensure patient safety and benefit.
}
\examples{
## Simulate a two-dimensional dose-finding trial with 20 cohorts of size 3.
p.true <- matrix(c(0.05, 0.10, 0.15, 0.30, 0.45,
                   0.10, 0.15, 0.30, 0.45, 0.55,
                   0.15, 0.30, 0.45, 0.50, 0.60), 
                 nrow = 3, ncol = 5, byrow = TRUE)
target <- 0.3; ncohort <- 20; cohortsize <- 3
CFO2dtrial <- CFO2d.simu(target, p.true, init.level = c(1,1), ncohort, cohortsize, seed = 1)
summary(CFO2dtrial)
plot(CFO2dtrial)
}
\references{
Jin H, Yin G (2022). CFO: Calibration-free odds design for phase I/II clinical trials.
\emph{Statistical Methods in Medical Research}, 31(6), 1051-1066. \cr
Wang W, Jin H, Zhang Y, Yin G (2023). Two-dimensional calibration-free odds (2dCFO)
design for phase I drug-combination trials. \emph{Frontiers in Oncology}, 13, 1294258.
}
\author{
Jialu Fang, Wenliang Wang, and Guosheng Yin
}
