% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CFtime.R
\name{format,CFtime-method}
\alias{format,CFtime-method}
\title{Format time elements using format specifiers}
\usage{
\S4method{format}{CFtime}(x, format)
}
\arguments{
\item{x}{CFtime. A CFtime instance whose offsets will be returned as
timestamps.}

\item{format}{character. A character string with strptime format
specifiers. If omitted, the most economical format will be used: a full
timestamp when time information is available, a date otherwise.}
}
\value{
A vector of character strings with a properly formatted timestamp.
Any format specifiers not recognized or supported will be returned verbatim.
}
\description{
Format timestamps using a specific format string, using the specifiers
defined for the \code{\link[base:strptime]{base::strptime()}} function, with limitations. The only
supported specifiers are \verb{bBdeFhHIjmMpRSTYz\%}. Modifiers \code{E} and \code{O} are
silently ignored. Other specifiers, including their percent sign, are copied
to the output as if they were adorning text.
}
\details{
The formatting is largely oblivious to locale. The reason for this is that
certain dates in certain calendars are not POSIX-compliant and the system
functions necessary for locale information thus do not work consistently. The
main exception to this is the (abbreviated) names of months (\code{bB}), which
could be useful for pretty printing in the local language. For separators and
other locale-specific adornments, use local knowledge instead of depending on
system locale settings; e.g. specify \verb{\%m/\%d/\%Y} instead of \verb{\%D}.

Week information, including weekday names, is not supported at all as a
"week" is not defined for non-standard CF calendars and not generally useful
for climate projection data. If you are working with observed data and want
to get pretty week formats, use the \code{\link[=as_timestamp]{as_timestamp()}} function to generate
\code{POSIXct} timestamps (observed data generally uses a standard calendar) and
then use the \code{\link[base:format]{base::format()}} function which supports the full set of
specifiers.
}
\examples{
cf <- CFtime("days since 2020-01-01", "standard", 0:365)
format(cf, "\%Y-\%b")

# Use system facilities on a standard calendar
format(as_timestamp(cf, asPOSIX = TRUE), "\%A, \%x")

}
