% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CGGP_plot.R
\name{CGGPplotslice}
\alias{CGGPplotslice}
\title{CGGP slice plot}
\usage{
CGGPplotslice(
  CGGP,
  proj = 0.5,
  np = 300,
  color = "pink",
  outdims,
  scales = "free_y",
  facet = "grid"
)
}
\arguments{
\item{CGGP}{CGGP object}

\item{proj}{Point to project onto}

\item{np}{Number of points to use along each dimension}

\item{color}{Color to make error region}

\item{outdims}{If multiple outputs, which of them should be plotted?}

\item{scales}{Parameter passed to ggplot2::facet_grid()}

\item{facet}{If "grid", will use ggplot2::facet_grid(), if "wrap" will
use ggplot2::facet_wrap(). Only applicable for a single output dimension.}
}
\value{
ggplot2 object
}
\description{
Show prediction plots when varying over only one dimension.
Most useful when setting all values to 0.5 because it will
have the most points.
}
\examples{
\donttest{
d <- 5
f1 <- function(x){x[1]+x[2]^2 + cos(x[3]^2*2*pi*4) - 3.3}
s1 <- CGGPcreate(d, 200)
s1 <- CGGPfit(s1, apply(s1$design, 1, f1))
#s1 <- CGGPappend(s1, 200)
#s1 <- CGGPfit(s1, apply(s1$design, 1, f1))
CGGPplotslice(s1)
CGGPplotslice(s1, 0.)
CGGPplotslice(s1, s1$design[nrow(s1$design),])
}
}
\seealso{
Other CGGP plot functions: 
\code{\link{CGGPplotblocks}()},
\code{\link{CGGPplotcorr}()},
\code{\link{CGGPplotheat}()},
\code{\link{CGGPplothist}()},
\code{\link{CGGPplotsamplesneglogpost}()},
\code{\link{CGGPplottheta}()},
\code{\link{CGGPplotvariogram}()},
\code{\link{CGGPvalplot}()}
}
\concept{CGGP plot functions}
