% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finalClustering.R
\name{finalClustering}
\alias{finalClustering}
\title{Final Clustering Step for Meta-Clustering}
\usage{
finalClustering(
  seu,
  dist,
  cutree.by = "h",
  cutree.h = 0.45,
  cutree.k = 3,
  hc.method = "complete"
)
}
\arguments{
\item{seu}{A Seurat object that has undergone the \code{getIDEr} step. Required.}

\item{dist}{A list output from the \code{getIDEr} function. Required.}

\item{cutree.by}{Character string specifying whether to cut the dendrogram by 
height ("h") or by a fixed number of clusters ("k"). Default is "h".}

\item{cutree.h}{Numeric value between 0 and 1 indicating the height at which 
to cut the dendrogram. This parameter is ignored if \code{cutree.by = "k"}. Default is 0.45.}

\item{cutree.k}{Numeric value specifying the number of clusters to generate 
if \code{cutree.by = "k"}. This parameter is ignored if \code{cutree.by = "h"}. Default is 3.}

\item{hc.method}{Character string specifying the method to be used in 
hierarchical clustering (passed to \code{hclust}).}
}
\value{
A Seurat object with the final clustering results stored in 
the \code{CIDER_clusters} column of its \code{meta.data}.
}
\description{
This function merges initial clusters into final clusters based on the IDEr similarity matrix.
}
\seealso{
\code{\link{getIDEr}}
}
