% Generated by roxygen2 (4.0.2): do not edit by hand
\name{lbsMergeAuthors}
\alias{lbsMergeAuthors}
\title{Merge given authors}
\usage{
lbsMergeAuthors(conn, idAuthors)
}
\arguments{
\item{conn}{a connection object as produced by \code{\link{lbsConnect}}.}

\item{idAuthors}{list of numeric vectors, each consisting of at least 2 authors' identifiers
(see \code{IdAuthor} in the table \code{Biblio_Authors});
every first element of a vector becomes a \emph{parent} to which other
records are merged.}
}
\value{
\code{TRUE} on success.
}
\description{
Merges given sets of authors. For each group, the function
maps all the related documents to a
distinguished \emph{parent} author (the first in a list) and
removes the other, unused from then on, records (\emph{children}).
}
\details{
This function is useful when one author is represented by many
records in a Local Bibliometric Storage (a typical situation in case of
data gathered from on-line bibliographic databases),
e.g. prof. John Thomas Smith
appears as 'Smith J.' and 'Smith J.T.'. Some merge procedures
are often absolutely necessary if we would like to assess the
impact of authors reliably.

Note that you may use \code{\link{lbsFindDuplicateAuthors}}
to generate input to this function. It will try to suggest which
records should be merged (see Examples below).

For safety reasons, an SQL transaction  opened at the beginning of the
removal process is not committed (closed) automatically.
You should do it on your own (or rollback it), see Examples below.
}
\examples{
\dontrun{
conn <- lbsConnect("Bibliometrics.db");
## ...
listauth <- lbsFindDuplicateAuthors(conn,
   ignoreWords=c("van", "von", "der", "no", "author", "name", "available"),
   minWordLength=4,
   orderResultsBy=c("citations"),
   aggressiveness=1);
lbsMergeAuthors(conn, listauth);
dbCommit(conn);
## ...}
}
\seealso{
\code{\link{lbsFindDuplicateAuthors}}, \code{\link{lbsGetInfoAuthors}}, \code{\link{lbsAssess}}
}

