% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppv_npv_ci.R
\name{ppv_npv_ci}
\alias{ppv_npv_ci}
\title{Estimate the confidence intervals for positive predictive value (PPV) and negative predictive value (NPV) based on different methods}
\usage{
ppv_npv_ci(
  x1,
  n1,
  x0,
  n0,
  prevalence,
  method = "gart and nam",
  conf.level = 0.95,
  bias_correction = FALSE,
  continuity.correction = FALSE
)
}
\arguments{
\item{x1}{number of positives for both reference(true) marker and testing marker.}

\item{n1}{number of positives for reference (true) marker.}

\item{x0}{number of negatives for both reference(true) marker and testing marker.}

\item{n0}{number of positives for reference (true) marker.}

\item{prevalence}{disease prevalence.}

\item{method}{current support "gart and nam", "walter", "mover-j", "pepe", "zhou", or "delta"; Default is "gart and nam"; Check the \code{Details} for additional information for each method.}

\item{conf.level}{confidence level. default 0.95.}

\item{bias_correction}{Logical, indicating whether to apply bias correction in the score denominator. default FALSE. This argument can be used only for `gart and nam` method.}

\item{continuity.correction}{logical. default FALSE. 0.5 will be applied if TRUE except the \code{zhou}'s method where \eqn{\frac{z_{\alpha/2}^2}{2}} is used.}
}
\value{
A list object contains the method and the estimates of sensitivity, specificity, PPV, NPV and their confidence intervals.
}
\description{
Estimate the confidence intervals for positive predictive value (PPV) and negative predictive value (NPV) based on different methods
}
\details{
Six methods are supported in current version: "gart and nam", "walter", "mover-j", "pepe", "zhou", and "delta".

Among those, \strong{gart and nam}, \strong{walter}, and \strong{mover-j} construct the confidence intervals for PPV and NPV by converting the confidence intervals for the ratio of two binomial proportions (\eqn{\phi=\frac{p_1}{p_0}}) where
\eqn{\phi_{PPV}=\frac{(1-specificity)}{sensitivity}} and \eqn{\phi_{NPV}=\frac{(1-sensitivity)}{specificity}}.
The sensitivity is estimated by \eqn{sensitivity=\frac{x_1}{n_1}} and the specificity by \eqn{specificity=\frac{x_0}{n_0}}. The confidence intervals for \eqn{\phi_{PPV}} and \eqn{\phi_{NPV}}
are converted to the corresponding confidence intervals for PPV and NPV using the following equations:
\itemize{
\item \eqn{PPV=\frac{\rho}{\rho+(1-\rho)*\phi_{PPV}}}

\item \eqn{NPV=\frac{1-\rho}{(1-\rho)+\rho*\phi_{NPV}}}

where \eqn{\rho} denotes the \code{prevalence}.

}
\enumerate{
\item The \strong{gart and nam} method constructs the confidence interval for \eqn{\phi} based on score method with skewness correction. See the details in the paper listed in the \code{Reference} section.
This method can be applied to special situations where `x1=n1` or `x0=n0` but not for `x1=0` and/or `x0=0`. `continuity.correction` can be considered where `x1=0` and/or `x0=0`.

\item The \strong{walter} method constructs the confidence interval for \eqn{\phi} based on \eqn{log(\phi)}. 0.5 is added to `x1`, `x0`, `n1`, and `n0`. Thus, no continuity correct should be applied additionally. This method has shown skewness concerns for
small ratios and sample sizes.

\item The \strong{mover-j} method constructs the confidence interval for \eqn{\phi} from separate intervals for the individual group rates (i.e., \eqn{p_1} and \eqn{p_0}).
By applying the equal-tailed Jeffreys method (0.5 to each group), it may achieve a skewness-corrected interval for \eqn{\phi}. Since the beta prior distributions (c(0.5, 0.5)) for each group (Jeffreys method) is applied, no continuity correct should be considered. \cr
\cr
The \strong{pepe}, \strong{zhou}, and \strong{delta} are three direct confidence interval methods for PPV and NPV.
\cr
\item The \strong{pepe} method finds the confidence intervals for PPV and NPV via diagnostic likelihood ratios (DLR) and associated logit(PPV) and logit(NPV). This method is not applicable for special
cases when `x1=0`, `x0=0`, `x1=n1` or `x0=n0`. Continuity correction should be considered for those special cases.

\item The \strong{zhou} method can return confidence intervals from the four methods described in the paper. Without continuity correction, it will return the confidence intervals
for PPV and NPV based on standard delta method and based on logit transformed method. If \code{continuity.correction=TRUE}, \eqn{\frac{z_{\alpha/2}^2}{2}} will be added to `x1`, `x0`, `n1`, and `n0`, and the function will return the adjusted and adjusted logit confidence intervals
as described in the paper.

\item The \strong{delta} method constructs the confidence intervals based on the Wald-type formulation. The estimates and variances of PPV and NPV are calculated based equations described in the Zhou's paper listed in the \code{Reference} section.
}
}
\examples{
ppv_npv_ci(60, 65, 113, 113, prevalence = 0.02)
}
\references{
\enumerate{
\item \insertRef{gn_1988}{CIfinder}

\item \insertRef{zhou_2007}{CIfinder}

\item \insertRef{laud_2017}{CIfinder}

\item \insertRef{pepe_2003}{CIfinder}
}
}
