% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_interface_setstaticcovariates.R
\name{SetStaticCovariates}
\alias{SetStaticCovariates}
\title{Add Static Covariates to a CLV data object}
\usage{
SetStaticCovariates(
  clv.data,
  data.cov.life,
  data.cov.trans,
  names.cov.life,
  names.cov.trans,
  name.id = "Id"
)
}
\arguments{
\item{clv.data}{CLV data object to add the covariates data to.}

\item{data.cov.life}{Static covariate data as \code{data.frame} or \code{data.table} for the lifetime process.}

\item{data.cov.trans}{Static covariate data as \code{data.frame} or \code{data.table} for the transaction process.}

\item{names.cov.life}{Vector with names of the columns in \code{data.cov.life} that contain the covariates.}

\item{names.cov.trans}{Vector with names of the columns in \code{data.cov.trans} that contain the covariates.}

\item{name.id}{Name of the column to find the Id data for both, \code{data.cov.life} and \code{data.cov.trans}.}
}
\value{
An object of class \code{clv.data.static.covariates}.
See the class definition \code{\link[CLVTools:clv.data.static.covariates-class]{clv.data.static.covariates}}
for more details about the returned object.
}
\description{
Add static covariate data to an existing data object of class \code{clv.data}.
The returned object then can be used to fit models with static covariates.

No covariate data can be added to a clv data object which already has any covariate set.

At least 1 covariate is needed for both processes and no categorical covariate may be of only a single category.
}
\details{
\code{data.cov.life} and \code{data.cov.trans} are \code{data.frame}s or \code{data.table}s that
each contain exactly one single row of covariate data for every customer appearing in the
transaction data. Covariates of class \code{character} or \code{factor} are converted
to k-1 numeric dummy variables.
}
\examples{

\donttest{

data("apparelTrans")
data("apparelStaticCov")

# Create a clv data object without covariates
clv.data.apparel <- clvdata(apparelTrans, time.unit="w",
                            date.format="ymd")

# Add static covariate data
clv.data.apparel.cov  <-
   SetStaticCovariates(clv.data.apparel,
                       data.cov.life  = apparelStaticCov,
                       names.cov.life = "Gender",
                       data.cov.trans = apparelStaticCov,
                       names.cov.trans = "Gender",
                       name.id = "Id")

# more summary output
summary(clv.data.apparel.cov)

# fit model with static covariates
pnbd(clv.data.apparel.cov)
}

}
