% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_transformer_30_60kv.R
\name{environmental_cof_transformer_30_60kv}
\alias{environmental_cof_transformer_30_60kv}
\title{Environmental cost of Failure for 30/10kV and 60/10kV Transformers}
\usage{
environmental_cof_transformer_30_60kv(
  tf_asset_category,
  prox_water,
  bunded,
  size_kva_mva = NULL
)
}
\arguments{
\item{tf_asset_category}{String The type of Transformer
Options: \code{tf_asset_category = c("30kV Transformer (GM)",
"60kV Transformer (GM)")}.}

\item{prox_water}{Numeric. Specify the proximity to a water course in meters.
A setting of \code{"Default"} will result in a proximity factor of 1. Thus
assume the proximity to a water course is between 80m and 120m}

\item{bunded}{String. Options: \code{bunded = c("Yes", "No", "Default")}.
A setting of \code{"Default"} will result in a bunding factor of 1.}

\item{size_kva_mva}{Numeric The MVA KVA rating for the transformer}
}
\description{
This function calculates environmental consequences of failure
Outputted in DKK.
}
\examples{
environmental_cof_transformer_30_60kv(tf_asset_category = "30kV Transformer (GM)",
prox_water = 95, bunded = "Yes", size_kva_mva = 20)
}
