% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cof_hv_switchgear_primary.R
\name{financial_cof_hv_switchgear_primary}
\alias{financial_cof_hv_switchgear_primary}
\title{Financial cost of Failure for HV swicthgear primary}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 2.1, 2021:
\url{https://www.ofgem.gov.uk/sites/default/files/docs/2021/04/dno_common_network_asset_indices_methodology_v2.1_final_01-04-2021.pdf}
}
\usage{
financial_cof_hv_switchgear_primary(hv_asset_category, access_factor_criteria)
}
\arguments{
\item{hv_asset_category}{String The type of HV switchgear distribution asset category
Options: \code{hv_asset_category = c("6.6/11kV CB (GM) Primary",
"20kV CB (GM) Primary")}}

\item{access_factor_criteria}{String. Asses Financial factor criteria for HV switchgear
setting (cf. table 221, page 180, CNAIM, 2021).
Options: \code{access_factor_criteria = c("Type A", "Type B", "Type C")}.}
}
\value{
Numeric. Financial consequences of failure for HV switchgear primary
}
\description{
This function calculates financial consequences of failure
(cf. section 7.3, page 79, CNAIM, 2021). Financial consequences
of failure is used in
the derivation of consequences of failure see \code{\link{cof}}().
}
\examples{
financial_cof_hv_switchgear_primary(
hv_asset_category = "6.6/11kV CB (GM) Primary",
access_factor_criteria = "Type A")
}
