% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convrg_func.R
\name{cnvrg_VI}
\alias{cnvrg_VI}
\title{Perform variational inference sampling}
\usage{
cnvrg_VI(
  countData,
  starts,
  ends,
  algorithm = "meanfield",
  output_samples = 500,
  params_to_save = c("pi", "p")
)
}
\arguments{
\item{countData}{A matrix or data frame of counts.The first field should be sample names and the subsequent fields should be integer data. Data should be arranged so that the first n rows correspond to one treatment group and the next n rows correspond with the next treatment group, and so on. The row indices for the first and last sample in these groups are fed into this function via 'starts' and 'ends'.}

\item{starts}{A vector defining the indices that correspond to the first sample in each treatment group.}

\item{ends}{A vector defining the indices that correspond to the last sample in each treatment group.}

\item{algorithm}{The algorithm to use when performing variational inference. Either 'meanfield' or 'fullrank'. The former is the default.}

\item{output_samples}{The number of samples from the approximated posterior to save.}

\item{params_to_save}{The parameters from which to save samples. Can be 'p', 'pi', 'theta'.}
}
\value{
A fitted 'Stan' object that includes the samples from the parameters designated.
}
\description{
This function uses a compiled Dirichlet multinomial model and performs variational inference estimation of posteriors using 'Stan'.
Evaluating the performance of variational inference is currently under development per our understanding. Please roll over to the 'Stan' website and see if new diagnostics are available.
If you use this function then credit 'Stan' and 'RStan' along with this package.
}
\details{
It can be helpful to use the indexer function to automatically identify the indices needed for the 'starts' and 'ends' parameters. See the vignette for an example.

Warning: data must be input in the correct organized format or this function will not provide accurate results. See vignette if you are unsure how to organize data.
Warning: depending upon size of data to be analyzed this function can take a very long time to run.
}
\examples{
#simulate an OTU table
com_demo <-matrix(0, nrow = 10, ncol = 10)
com_demo[1:5,] <- c(rep(3,5), rep(7,5)) #Alternates 3 and 7
com_demo[6:10,] <- c(rep(7,5), rep(3,5)) #Reverses alternation
fornames <- NA
for(i in 1:length(com_demo[1,])){
fornames[i] <- paste("otu_", i, sep = "")
}
sample_vec <- NA
for(i in 1:length(com_demo[,1])){
sample_vec[i] <- paste("sample", i, sep = "_")
}
com_demo <- data.frame(sample_vec, com_demo)
names(com_demo) <- c("sample", fornames)

cnvrg_VI(com_demo,starts = c(1,6), ends=c(5,10))
}
