% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCNVKernelProbDist.R
\name{calcCNVKernelProbDist}
\alias{calcCNVKernelProbDist}
\title{Calculate the probability distribution of CNV concordance events with a fast kernel}
\arguments{
\item{submatrix}{A matrix of CNV data in an intrachromosomal region (e.g. chr1 vs chr1 or chr5 vs chr5)}

\item{win}{a window size for the matrix that calculates the windowed average using the kernel function}

\item{debug}{extra output for debugging.}

\item{parallel}{use parallelization using mcmapply and doParallel?}

\item{mcmcores}{The number of cores used for parallelization.}
}
\description{
This function produces several matrices, including a Z-score matrix
from a matrix of the same size
and a percentile matrix of these Z-scores
}
\examples{
load(system.file("extdata","nbl_result_matrix_sign_small.rda",package = "CNVScope"))
mat_prob_dist<-calcCNVKernelProbDist(nbl_result_matrix_sign_small,parallel=FALSE)
mat_prob_dist
}
\keyword{CNV}
\keyword{concordance}
\keyword{distribution}
\keyword{fast}
\keyword{kernel}
\keyword{probability}
