% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coin_rew8r.R
\name{rew8r}
\alias{rew8r}
\title{Re-weight indicators}
\usage{
rew8r(COIN)
}
\arguments{
\item{COIN}{COIN object}
}
\value{
An updated COIN object with additional sets of weights in \code{.$Parameters$Weights}, if specified.
}
\description{
Interactive gadget which lets you adjust weights and see the effects. Weights can be saved with new names to the COIN object.
}
\details{
Correlations between indicators, and between indicators and index, can inform about how well the composite indicator is conveying
information in the underlying indicators. For example, a correlation of zero between an indicator and the index shows that knowing
the index ranks, you have no indication of what the ranks of the underlying indicator are. Since one of the objectives of a composite
indicator is to summarise the information in its underlying indicators, this can be a problem.

The correlation between indicators and index (and other levels) can be adjusted by changing weights. But the effect of changing weights
can be hard to gauge. The \code{\link[=rew8r]{rew8r()}} app allows you to play around with the weights at any level, and to see what happens to the resulting
correlations of interest. It also demonstrates what happens to the results. Rather than changing weights and manually regenerating the
results, the \code{\link[=rew8r]{rew8r()}} app does all this for you. If you find a set or sets of weights that you like, you can also save it/them back to the COIN
as a new weight-set(s). To do this, click "Save", and then at the end of the session, "Close app".

Consider that changing weights to "fix" correlations may result in unusual sets of weights that are hard to justify. This tool may
be more useful as a curiosity, as part of a "what-if" analysis, or simply to better understand what is going on inside your index.

NOTE that you need to have aggregated your data first before using this. This app also requires an interactive R session to
run.
}
\examples{
## Only run this example in interactive R sessions
if (interactive()) {
# build ASEM COIN up to aggregation
ASEM <- build_ASEM()
# launch app
ASEM <- rew8r(ASEM)
}

}
\seealso{
\itemize{
\item \code{\link[=weightOpt]{weightOpt()}} Correlation-optimised weights
\item \code{\link[=plotCorr]{plotCorr()}} Correlation plots
}
}
