% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfuncs.R
\name{qNormalise.purse}
\alias{qNormalise.purse}
\title{Quick normalisation of a purse}
\usage{
\method{qNormalise}{purse}(
  x,
  dset,
  f_n = "n_minmax",
  f_n_para = list(l_u = c(0, 100)),
  directions = NULL,
  global = TRUE,
  ...
)
}
\arguments{
\item{x}{A purse}

\item{dset}{Name of data set to normalise}

\item{f_n}{Name of a normalisation function (as a string) to apply to each indicator. Default \code{"n_minmax"}.}

\item{f_n_para}{Any further arguments to pass to \code{f_n}, as a named list.}

\item{directions}{An optional data frame containing the following columns:
\itemize{
\item \code{iCode} The indicator code, corresponding to the column names of the data frame
\item \code{Direction} numeric vector with entries either \code{-1} or \code{1}
If \code{directions} is not specified, the directions will be taken from the \code{iMeta} table in the coin, if available.
}}

\item{global}{Logical: if \code{TRUE}, normalisation is performed "globally" across all coins, by using e.g. the
max and min of each indicator in any coin. This effectively makes normalised scores comparable between coins
because they are all scaled using the same parameters. Otherwise if \code{FALSE}, coins are normalised individually.}

\item{...}{arguments passed to or from other methods.}
}
\value{
An updated purse with normalised data sets
}
\description{
This is a wrapper function for \code{\link[=Normalise]{Normalise()}}, which offers a simpler syntax but less flexibility. It
normalises data sets within a purse using a specified function \code{f_n} which is used to normalise each indicator, with
additional function arguments passed by \code{f_n_para}. By default, \code{f_n = "n_minmax"} and \code{f_n_para} is
set so that the indicators are normalised using the min-max method, between 0 and 100.
}
\details{
Essentially, this function is similar to \code{\link[=Normalise]{Normalise()}} but brings parameters into the function arguments
rather than being wrapped in a list. It also does not allow individual normalisation.

Normalisation can either be performed independently on each coin, or over the entire panel data set
simultaneously. See the discussion in \code{\link[=Normalise.purse]{Normalise.purse()}} and \code{vignette("normalise")}.
}
\examples{
# build example purse
purse <- build_example_purse(up_to = "new_coin", quietly = TRUE)

# normalise using min-max, globally
purse <- qNormalise(purse, dset = "Raw", global = TRUE)

}
