% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/COMBIA.R
\name{analyzeCOMBO}
\alias{analyzeCOMBO}
\title{This function calculates significant synergy/antagonism according to Bliss or Loewe model 
and creates scientific publication ready graphs.}
\usage{
analyzeCOMBO(filename, sheet = 1, model, inputFormates, platetype = "384",
  keyposition = 2, selectionkey = "65000", platekey = 7051,
  minThersholdForCVCal = 0.15, minThersholdForCV = 0.3, wells,
  yConcentration, xConcentration, xDrug, yDrug, cellLine,
  survivalFunc = function(x, y, z) {     (x - z)/(y - z) }, nBoot = 5000)
}
\arguments{
\item{filename}{Name of file containing experimental data.
For MS Excel files, working version of Perl must be present in the executable search path.}

\item{sheet}{Optional, sheet number if excel file is used for input.}

\item{model}{bliss or loewe.}

\item{inputFormates}{Any of these three formates "fmca", "macsynergy" and "others" are supported.
Example is provided with macsynergy format and test data for this example can be found in 
installation directory ("extdata")  of COMBIA.  See files FluoOptima_384_2014-03-28test_M and testDataM in 
directory "extdata" for format details of "fmca" and "macsynergy". "others" can be any other format.}

\item{platetype}{Optional default is 384. Only 384 and 96 well plates are supported.}

\item{keyposition}{Optional default is 2. Usefull for automated barcoded data.}

\item{selectionkey}{Optional default is 65000.}

\item{platekey}{Optional barcode.}

\item{minThersholdForCVCal}{Optional default is 0.15.}

\item{minThersholdForCV}{Optional default is 0.3.}

\item{wells}{wells argument should  be in triplet form that is 
1-Untreated control wells range, 2-empty wells range and 3-case wells range.
Thus in example below (see well argument) experiment has four replicates.
"l3:l10","m3:m10","b3:k10" is first replicate. Where "l3:l10" is the location
of untreated control values in the testData.csv, "m3:m10" is the background/
empty well well values and "b3:k10" are values after treatment.}

\item{yConcentration}{Y drug Concentrations.}

\item{xConcentration}{X drug Concentrations.}

\item{xDrug}{X drug name.}

\item{yDrug}{Y drug name.}

\item{cellLine}{Cell/Experiment name.}

\item{survivalFunc}{Optional default is function (x,y,z) {(x-z)/(y-z)} 
i.e (treated - background)/ (untreated - background).}

\item{nBoot}{Optional Number of time to bootstrap default is 5000}
}
\value{
Stores and show graph/data of synergy/antagonism analyses
}
\description{
This function calculates significant synergy/antagonism according to Bliss or Loewe model 
and creates scientific publication ready graphs.
}
\examples{
fl <- system.file("extdata", "testData.csv", package="COMBIA")
wellR <- list(c("l3:l10","m3:m10","b3:k10", "l13:l20","m13:m20","b13:k20", 
           "l23:l30","m23:m30","b23:k30", "l33:l40","m33:m40","b33:k40") )
mdl <- "bliss"
xConc <- c(0.00,  0.20,  0.39,  0.78,  1.56,  3.12,  6.25, 12.50, 25.00, 50) 
yConc <- c(128,  64,  32,  16,   8,   4,   2,   0)
xDrug <- "A"
yDrug <- "B"
cellLine <-"Cell"
analyzeCOMBO(filename = c(fl), model = "bliss", inputFormates = "macsynergy", 
                 wells = wellR, yConcentration = yConc, xConcentration = xConc,
                 xDrug = xDrug, yDrug=yDrug, cellLine = cellLine, nBoot=500)

}
\author{
Muhammad kashif
}
