% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zip.R
\name{ZIP Distribution}
\alias{ZIP Distribution}
\alias{dzip}
\alias{rzip}
\alias{pzip}
\alias{qzip}
\alias{ezip}
\alias{vzip}
\title{COM-Poisson Distribution}
\usage{
dzip(x, lambda, p, log = FALSE)

rzip(n, lambda, p)

pzip(x, lambda, p)

qzip(q, lambda, p, log.p = FALSE)

ezip(lambda, p)

vzip(lambda, p)
}
\arguments{
\item{x}{vector of quantiles.}

\item{lambda}{rate parameter.}

\item{p}{zero-inflation probability parameter.}

\item{log}{logical; if TRUE, probabilities are returned on log-scale.}

\item{n}{number of observations.}

\item{q}{vector of probabilities.}

\item{log.p}{logical; if TRUE, probabilities \code{p} are given as \eqn{\log(p)}.}
}
\value{
\describe{
\item{dzip}{density,}
\item{pzip}{cumulative probability,}
\item{qzip}{quantiles,}
\item{rzip}{generate random variates,}
\item{ezip}{expected value,}
\item{vzip}{variance,}
}
}
\description{
Functions for the COM-Poisson distribution.
}
\author{
Kimberly Sellers
}
\keyword{Poisson}
\keyword{Zero-Inflated}
\keyword{distribution}
