% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gapply.R
\name{gapply}
\alias{gapply}
\title{Apply a function to each group}
\usage{
gapply(x, f)
}
\arguments{
\item{x}{a grouped \code{tibble}.}

\item{f}{a function to apply to each group. It should have at least 2 formal arguments: (1) the group data and (2) the group key.}
}
\value{
List of results from calling \code{f} on each group.
}
\description{
Wrapper for \link[dplyr]{group_map} from package \code{dplyr}.
Can be used to iterate on grouped \code{tibbles}.
}
\examples{
# plot by country
x <- world('country')
f <- function(x, group) {
  plot(x$confirmed~x$date, main = group)
}
gapply(x, f)

}
\seealso{
\link[dplyr]{group_map}
}
