% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geomap.R
\name{geomap}
\alias{geomap}
\title{Animated Mapping}
\usage{
geomap(
  x,
  map = "world",
  value = "confirmed",
  label = "",
  filename = "",
  width = 1920,
  height = 1080,
  title = "Coronavirus: {closest_state}",
  text.size = 48,
  caption = "",
  caption.size = 18,
  colour = "#bdbdbd",
  fill = "#2a2a28",
  background = "#000f1a",
  point.alpha = 0.95,
  point.size = c(1, 32),
  point.colour = c("#ffaa00", "#a20f0e"),
  legend.title = "",
  legend.background = "transparent",
  legend.position = c(0, 0),
  legend.barheight = 24,
  legend.barwidth = 3,
  ...
)
}
\arguments{
\item{x}{\code{data.frame} containing the columns \code{lat} (latitude), \code{lng} (longitude) and \code{date} (time). See \code{\link{world}}, \code{\link{diamond}}, \code{\link{italy}} and \code{\link{switzerland}}.}

\item{map}{map data. The string choices include \code{'world'}, \code{'italy'}, \code{'switzerland'} and more (type \code{help(package='maps')} to see the package index). See \code{\link[maps]{map}} for details.}

\item{value}{the value column.}

\item{label}{the label column.}

\item{filename}{file name to create on disk. Use .gif for animations, .png for static images.}

\item{width, height}{plot size.}

\item{title}{the title. Dynamic label variables are available from \code{\link[gganimate]{transition_states}}.}

\item{text.size}{the text size.}

\item{caption}{the caption. Dynamic label variables are available from \code{\link[gganimate]{transition_states}}.}

\item{caption.size}{the caption size.}

\item{colour}{the text colour.}

\item{fill}{the fill colour.}

\item{background}{the background color.}

\item{point.alpha}{the point opacity.}

\item{point.size}{a numeric vector of length 2 that specifies the minimum and maximum size of the plotting symbol.}

\item{point.colour}{a character vector of length 2 that specifies the colours corresponding to the lowest and highest values.}

\item{legend.title}{the legend title. Dynamic label variables are available from \code{\link[gganimate]{transition_states}}.}

\item{legend.background}{the legend background.}

\item{legend.position}{the legend position, \code{c(0,0)} corresponds to bottom-left, \code{c(1,1)} to top-right.}

\item{legend.barheight}{the height of the colourbar.}

\item{legend.barwidth}{the width of the colourbar.}

\item{...}{additional arguments passed to \code{\link[gganimate]{animate}}}
}
\value{
The return value of the \code{\link[gganimate]{animate}} function.
}
\description{
Visualize data across the space and time dimensions by animated mapping.
}
\examples{
\dontrun{

# download data
it <- italy()

# add label
it$label <- factor(it$confirmed)

# map
geomap(it,
  map = "italy",
  value = "confirmed",
  label = "label",
  title = "Coronavirus: {closest_state}",
  caption  = "Data source: ...",
  legend.title = "Total cases",
  nframes = 30+(2*length(unique(it$date))),
  end_pause = 30)
}

}
