% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_icmeans.R
\name{fuzzy_icmeans}
\alias{fuzzy_icmeans}
\title{Interval fuzzy cmeans clustering.}
\usage{
fuzzy_icmeans(x, centers, m = 2, nstart = 2, distance = "euclid",
  trace = FALSE, iter.max = 40)
}
\arguments{
\item{x}{An 3D interval array.}

\item{centers}{A number or interval, number of cluster for clustering or pre init centers.}

\item{m}{A number greater than 1 giving the degree of fuzzification.}

\item{nstart}{A number, number of execution to find the best result.}

\item{distance}{A string ('euclid': Euclidian distance, 'hausdorff': Hausdorff distance).}

\item{trace}{A boolean, tracing information on the progress of the algorithm is produced.}

\item{iter.max}{the maximum number of iterations allowed.}
}
\description{
Culster interval data with fuzzy cmeans algorithm.
}
\examples{
fuzzy_icmeans(iaggregate(iris, col=5), 2)
fuzzy_icmeans(iaggregate(iris, col=5), iaggregate(iris, col=5))
}
