% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diff_multidim.R
\name{diff_multidim}
\alias{diff_multidim}
\title{Multidimensional Difference-in-Means}
\usage{
diff_multidim(data, cols, clusters)
}
\arguments{
\item{data}{a numeric vector or \code{n x k} matrix or data frame containing a vector
identifying cluster membership for each observation, to be passed to
\code{clusters} argument.}

\item{cols}{columns of \code{data} to be used in difference-in-means calculation.}

\item{clusters}{column of \code{data} indicating cluster membership for each
observation.}
}
\value{
Returns a numeric vector of length 1.
}
\description{
Calculates average Euclidean distance between means in arbitrary dimensions.
}
\examples{
data <- matrix(c(rnorm(50, 0, 1), rnorm(50, 5, 1)), ncol = 2, byrow = TRUE)
clusters <- matrix(c(rep(1, 25), rep(2, 25)), ncol = 1)
data <- cbind(data, clusters)

diff_multidim(data, 1:2, 3)

}
