% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.model.R
\name{create.model}
\alias{create.model}
\title{Computes the congruent class, i.e., the pulled rates.}
\usage{
create.model(
  func_spec0,
  func_ext0,
  times = seq(from = 0, to = 5, by = 0.005),
  func_p_spec = NULL,
  func_p_div = NULL
)
}
\arguments{
\item{func_spec0}{The speciation rate function (measured in time before present).}

\item{func_ext0}{The extinction rate function (measured in time before present).}

\item{times}{the time knots for the piecewise-linear rate functions}

\item{func_p_spec}{the pulled speciation rate function}

\item{func_p_div}{the pulled net-diversification rate function}
}
\value{
A list of rate functions representing this congruence class.
}
\description{
Computes the congruent class, i.e., the pulled rates.
}
\examples{
lambda1 <- function(t) exp(0.3*t) - 0.5*t + 1
mu1 <- function(t) exp(0.3*t) - 0.2*t + 0.2

model1 <- create.model(lambda1, mu1, times = seq(0, 5, by = 0.005))

model1

data("primates_ebd")

lambda2 <- approxfun(primates_ebd[["time"]], primates_ebd[["lambda"]])
mu2 <- approxfun(primates_ebd[["time"]], primates_ebd[["mu"]])
model2 <- create.model(lambda2, mu2, primates_ebd[["time"]])

model2
}
