% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger_utils.R
\name{set_logger}
\alias{set_logger}
\title{Set Logger settings}
\usage{
set_logger(logger_file_path = "CRE.log", logger_level = "INFO")
}
\arguments{
\item{logger_file_path}{A path (including file name) to log the messages.
(Default: CRE.log)}

\item{logger_level}{The log level. When a log level is set, all log levels
below it are also activated (if implemented). Available levels include:
\itemize{
\item TRACE: Provides verbose detailed logging, including the steps taken to
achieve a result, often used for debugging. Activating TRACE will also
enable DEBUG, INFO, SUCCESS, WARN, ERROR, and FATAL logs.
\item DEBUG: Provides detailed logging about the flow of the application, used
mostly by developers to understand potential issues. Activating DEBUG will
also enable INFO, SUCCESS, WARN, ERROR, and FATAL logs.
\item INFO (Default): Standard messages that inform the user about the normal
operation of the system. Activating INFO will also enable SUCCESS, WARN,
ERROR, and FATAL logs.
\item SUCCESS: Messages indicating successful completion of a particular
operation or task. Activating SUCCESS will also enable WARN, ERROR, and
FATAL logs.
\item WARN: Warning messages about events that might cause problems in the
future, but are not yet errors. Activating WARN will also enable ERROR
and FATAL logs.
\item ERROR: Reports an error due to which the system may not be able to
achieve its functionality, but the application won't halt. Activating
ERROR will also enable FATAL logs.
\item FATAL: Reports very severe error events that will presumably lead the
application to abort.
}}
}
\value{
No return value. This function is called for side effects.
}
\description{
Updates logger settings, including log level and location of the file.
}
\note{
Log levels are specified by developers during the initial implementation.
Future developers or contributors can leverage these log levels to better
capture and document the application's processes and events.
}
\examples{

set_logger("Debug")

}
