% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{latlong_as_xy}
\alias{latlong_as_xy}
\title{Convert lat long co-ordinates to x,y}
\usage{
latlong_as_xy(trial, latvar = "lat", longvar = "long")
}
\arguments{
\item{trial}{A trial dataframe or list of class \code{"CRTsp"} containing latitudes and longitudes in decimal degrees}

\item{latvar}{name of column containing latitudes in decimal degrees}

\item{longvar}{name of column containing longitudes in decimal degrees}
}
\value{
A list of class \code{"CRTsp"} containing the following components:
\tabular{lll}{
\code{geom_full}   \tab list: \tab summary statistics describing the site \cr
\code{trial} \tab data frame: \tab rows correspond to geolocated points, as follows:\cr
\tab \code{x} \tab numeric vector: x-coordinates of locations \cr
\tab \code{y} \tab numeric vector: y-coordinates of locations \cr
\tab \code{...} \tab other objects included in the input \code{"CRTsp"} object or data frame \cr
}
}
\description{
\code{latlong_as_xy} converts co-ordinates expressed as decimal degrees into x,y
}
\details{
The output object contains the input locations replaced with Cartesian
coordinates in units of km, centred on (0,0), corresponding to using the equirectangular projection
(valid for small areas). Other data are unchanged.
}
\examples{
examplexy <- latlong_as_xy(readdata("example_latlong.csv"))

}
