% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyseCRT.R
\name{compute_mesh}
\alias{compute_mesh}
\title{Create INLA mesh for spatial analysis}
\usage{
compute_mesh(
  trial = trial,
  offset = -0.1,
  max.edge = 0.25,
  inla.alpha = 2,
  maskbuffer = 0.5,
  pixel = 0.5
)
}
\arguments{
\item{trial}{an object of class \code{"CRTsp"} or a data frame containing locations in (x,y) coordinates, cluster
assignments (factor \code{cluster}), and arm assignments (factor \code{arm}) and outcome.}

\item{offset}{see \code{inla.mesh.2d} documentation}

\item{max.edge}{see \code{inla.mesh.2d} documentation}

\item{inla.alpha}{parameter related to the smoothness (see \code{inla} documentation)}

\item{maskbuffer}{numeric: width of buffer around points (km)}

\item{pixel}{numeric: size of pixel (km)}
}
\value{
list
\itemize{
\item \code{prediction} Data frame containing the prediction points and covariate values
\item \code{A} projection matrix from the observations to the mesh nodes.
\item \code{Ap} projection matrix from the prediction points to the mesh nodes.
\item \code{indexs} index set for the SPDE model
\item \code{spde} SPDE model
\item \code{pixel} pixel size (km)
}
}
\description{
\code{compute_mesh} create objects required for INLA analysis of an object of class \code{"CRTsp"}.
}
\details{
\code{compute_mesh} carries out the computationally intensive steps required for setting-up an
INLA analysis of an object of class \code{"CRTsp"}, creating the prediction mesh and the projection matrices.
The mesh can be reused for different models fitted to the same
geography. The computational resources required depend largely on the resolution of the prediction mesh.
The prediction mesh is thinned to include only pixels centred at a distance less than
\code{maskbuffer} from the nearest point.\cr
A warning may be generated if the \code{Matrix} library is not loaded.
}
\examples{
{
# low resolution mesh for test dataset
library(Matrix)
library(sp)
example <- readdata('exampleCRT.txt')
exampleMesh=compute_mesh(example, pixel = 0.5)
}
}
