% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_fill_csgo.R
\name{scale_fill_csgo}
\alias{scale_fill_csgo}
\title{CSGo color palette - fill}
\usage{
scale_fill_csgo(discrete = TRUE, ...)
}
\arguments{
\item{discrete}{logical: if TRUE it will generate a discrete pallet otherwise a continuous palette}

\item{...}{all available options of the \code{discrete_scale} function or \code{scale_fill_gradientn} both from \code{ggplot2}}
}
\value{
\code{scale_color} object
}
\description{
A color palette (fill) to be used with \code{ggplot2}
}
\examples{
\dontrun{
library(CSGo)
library(ggplot2)
library(dplyr)
library(showtext)

## Loading Google fonts (https://fonts.google.com/)
font_add_google("Quantico", "quantico")

df \%>\%
 top_n(n = 10, wt = value) \%>\%
 ggplot(aes(x = name_match, y = value, fill = name_match)) +
 geom_col() +
 ggtitle("KILLS BY WEAPON") +
 ylab("Number of Kills") +
 xlab("") +
 labs(fill = "Weapon Name") +
 theme_csgo(text = element_text(family = "quantico")) +
 scale_fill_csgo()
}
}
