% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_tidyhydat_ECDE.R
\name{ch_tidyhydat_ECDE}
\alias{ch_tidyhydat_ECDE}
\title{Converts a tidyhydat daily flow data tibble to ECDE format}
\usage{
ch_tidyhydat_ECDE(data)
}
\arguments{
\item{data}{Tibble of daily flows retrieved using \pkg{tidyhydat} function \code{hy_daily_flows}.}
}
\value{
A dataframe or a list of flows with formats consistent with datafiles read using \code{ch_read_ECDE_flows}:
\item{ID}{stationID}
\item{PARAM}{Parameter 1 for Flow 2 for Level}
\item{Date}{original charater string converted to date format}
\item{Flow}{Daily mean flow m\eqn{^3}{^3}/sec}
\item{SYM}{Quality flag}
}
\description{
Accessing daily flow data using \pkg{tidyhydat} is quick and efficient. However, it 
sometimes conflicts with other functions as \pkg{tidyhydat} changes variable names and some default 
entries. This function converts a tibble obtained from a \pkg{tidyhydat} tibble to a dataframe 
with standard Environment and Climate Change Canada Data Explorer (ECDE) names.
}
\examples{
\donttest{
library(tidyhydat)
mdata <- hy_daily_flow(station_number=c("05CK004"))
m_data <- ch_tidyhydat_ECDE(mdata)

mdata <- hy_daily_flows(station_number=c("05CK004","08MF005","05BB001"))
mnew <- ch_tidyhydat_ECDE(mdata)
str(mnew[[1]])
str(mnew[[2]])
str(mnew[[3]]) 
#note the order is in increasing alphabetical order}
}
\seealso{
\code{\link{ch_tidyhydat_ECDE_meta}}
}
\author{
Paul Whitfield
}
