% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ch_clear_wd.R
\name{ch_clear_wd}
\alias{ch_clear_wd}
\title{Clear Working Directory}
\usage{
ch_clear_wd(wd, do_check = TRUE)
}
\arguments{
\item{wd}{working directory file path}

\item{do_check}{If \code{TRUE}, the default, the user is asked to confirm the
deletion of the working directory. If \code{TRUE}, the directory is deleted
without confirmation.}
}
\value{
\item{result}{returns TRUE upon successful execution}
}
\description{
Empties and removes a working directory.
}
\details{
The data for raster layers read in as Whitebox
files are held on disk rather than in memory
}
\examples{
\donttest{
# not tested as deleting all files in the directory cannot be tested in CRAN

# create an empty working directory
my_wd <- tempdir()
ch_create_wd(my_wd) # confirm creation

# clear the working directory
ch_clear_wd(my_wd)
}

}
\seealso{
\code{\link{ch_create_wd}} to create working directory
}
\author{
Dan Moore
}
